/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.RegexSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hive.hcatalog.streaming.AbstractRecordWriter;
import org.apache.hive.hcatalog.streaming.ConnectionError;
import org.apache.hive.hcatalog.streaming.HiveEndPoint;
import org.apache.hive.hcatalog.streaming.SerializationError;
import org.apache.hive.hcatalog.streaming.StreamingConnection;
import org.apache.hive.hcatalog.streaming.StreamingException;
import org.apache.hive.hcatalog.streaming.StreamingIOFailure;

@Deprecated
public class StrictRegexWriter
extends AbstractRecordWriter {
    private RegexSerDe serde;
    private final StructObjectInspector recordObjInspector;
    private final ObjectInspector[] bucketObjInspectors;
    private final StructField[] bucketStructFields;

    public StrictRegexWriter(HiveEndPoint endPoint, StreamingConnection conn) throws ConnectionError, SerializationError, StreamingException {
        this(null, endPoint, null, conn);
    }

    public StrictRegexWriter(HiveEndPoint endPoint, HiveConf conf, StreamingConnection conn) throws ConnectionError, SerializationError, StreamingException {
        this(null, endPoint, conf, conn);
    }

    public StrictRegexWriter(String regex, HiveEndPoint endPoint, HiveConf conf, StreamingConnection conn) throws ConnectionError, SerializationError, StreamingException {
        super(endPoint, conf, conn);
        this.serde = StrictRegexWriter.createSerde(this.tbl, conf, regex);
        try {
            this.recordObjInspector = (StructObjectInspector)this.serde.getObjectInspector();
            this.bucketObjInspectors = StrictRegexWriter.getObjectInspectorsForBucketedCols(this.bucketIds, this.recordObjInspector);
        }
        catch (SerDeException e) {
            throw new SerializationError("Unable to get ObjectInspector for bucket columns", (Exception)((Object)e));
        }
        this.bucketStructFields = new StructField[this.bucketIds.size()];
        List allFields = this.recordObjInspector.getAllStructFieldRefs();
        for (int i = 0; i < this.bucketIds.size(); ++i) {
            this.bucketStructFields[i] = (StructField)allFields.get((Integer)this.bucketIds.get(i));
        }
    }

    @Override
    public AbstractSerDe getSerde() {
        return this.serde;
    }

    @Override
    protected StructObjectInspector getRecordObjectInspector() {
        return this.recordObjInspector;
    }

    @Override
    protected StructField[] getBucketStructFields() {
        return this.bucketStructFields;
    }

    @Override
    protected ObjectInspector[] getBucketObjectInspectors() {
        return this.bucketObjInspectors;
    }

    @Override
    public void write(long writeId, byte[] record) throws StreamingIOFailure, SerializationError {
        try {
            Object encodedRow = this.encode(record);
            int bucket = this.getBucket(encodedRow);
            this.getRecordUpdater(bucket).insert(writeId, encodedRow);
        }
        catch (IOException e) {
            throw new StreamingIOFailure("Error writing record in transaction write id(" + writeId + ")", e);
        }
    }

    private static RegexSerDe createSerde(Table tbl, HiveConf conf, String regex) throws SerializationError {
        try {
            Properties tableProps = MetaStoreUtils.getTableMetadata((Table)tbl);
            tableProps.setProperty("input.regex", regex);
            ArrayList<String> tableColumns = StrictRegexWriter.getCols(tbl);
            tableProps.setProperty("columns", StringUtils.join(tableColumns, (String)","));
            RegexSerDe serde = new RegexSerDe();
            SerDeUtils.initializeSerDe((Deserializer)serde, (Configuration)conf, (Properties)tableProps, null);
            return serde;
        }
        catch (SerDeException e) {
            throw new SerializationError("Error initializing serde " + RegexSerDe.class.getName(), (Exception)((Object)e));
        }
    }

    private static ArrayList<String> getCols(Table table) {
        List cols = table.getSd().getCols();
        ArrayList<String> colNames = new ArrayList<String>(cols.size());
        for (FieldSchema col : cols) {
            colNames.add(col.getName().toLowerCase());
        }
        return colNames;
    }

    @Override
    public Object encode(byte[] utf8StrRecord) throws SerializationError {
        try {
            Text blob = new Text(utf8StrRecord);
            return this.serde.deserialize((Writable)blob);
        }
        catch (SerDeException e) {
            throw new SerializationError("Unable to convert byte[] record into Object", (Exception)((Object)e));
        }
    }
}

