/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.LockComponentBuilder;
import org.apache.hadoop.hive.metastore.LockRequestBuilder;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.streaming.ConnectionError;
import org.apache.hive.hcatalog.streaming.HeartBeatFailure;
import org.apache.hive.hcatalog.streaming.ImpersonationFailed;
import org.apache.hive.hcatalog.streaming.InvalidPartition;
import org.apache.hive.hcatalog.streaming.InvalidTable;
import org.apache.hive.hcatalog.streaming.InvalidTrasactionState;
import org.apache.hive.hcatalog.streaming.PartitionCreationFailed;
import org.apache.hive.hcatalog.streaming.QueryFailedException;
import org.apache.hive.hcatalog.streaming.RecordWriter;
import org.apache.hive.hcatalog.streaming.SerializationError;
import org.apache.hive.hcatalog.streaming.StreamingConnection;
import org.apache.hive.hcatalog.streaming.StreamingException;
import org.apache.hive.hcatalog.streaming.TransactionBatch;
import org.apache.hive.hcatalog.streaming.TransactionBatchUnAvailable;
import org.apache.hive.hcatalog.streaming.TransactionError;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class HiveEndPoint {
    public final String metaStoreUri;
    public final String database;
    public final String table;
    public final ArrayList<String> partitionVals;
    private static final Logger LOG = LoggerFactory.getLogger((String)HiveEndPoint.class.getName());

    public HiveEndPoint(String metaStoreUri, String database, String table, List<String> partitionVals) {
        this.metaStoreUri = metaStoreUri;
        if (database == null) {
            throw new IllegalArgumentException("Database cannot be null for HiveEndPoint");
        }
        this.database = database.toLowerCase();
        if (table == null) {
            throw new IllegalArgumentException("Table cannot be null for HiveEndPoint");
        }
        this.partitionVals = partitionVals == null ? new ArrayList() : new ArrayList<String>(partitionVals);
        this.table = table.toLowerCase();
    }

    @Deprecated
    public StreamingConnection newConnection(boolean createPartIfNotExists) throws ConnectionError, InvalidPartition, InvalidTable, PartitionCreationFailed, ImpersonationFailed, InterruptedException {
        return this.newConnection(createPartIfNotExists, null, null, null);
    }

    @Deprecated
    public StreamingConnection newConnection(boolean createPartIfNotExists, HiveConf conf) throws ConnectionError, InvalidPartition, InvalidTable, PartitionCreationFailed, ImpersonationFailed, InterruptedException {
        return this.newConnection(createPartIfNotExists, conf, null, null);
    }

    @Deprecated
    public StreamingConnection newConnection(boolean createPartIfNotExists, HiveConf conf, UserGroupInformation authenticatedUser) throws ConnectionError, InvalidPartition, InvalidTable, PartitionCreationFailed, ImpersonationFailed, InterruptedException {
        return this.newConnection(createPartIfNotExists, conf, authenticatedUser, null);
    }

    public StreamingConnection newConnection(boolean createPartIfNotExists, String agentInfo) throws ConnectionError, InvalidPartition, InvalidTable, PartitionCreationFailed, ImpersonationFailed, InterruptedException {
        return this.newConnection(createPartIfNotExists, null, null, agentInfo);
    }

    public StreamingConnection newConnection(boolean createPartIfNotExists, HiveConf conf, String agentInfo) throws ConnectionError, InvalidPartition, InvalidTable, PartitionCreationFailed, ImpersonationFailed, InterruptedException {
        return this.newConnection(createPartIfNotExists, conf, null, agentInfo);
    }

    public StreamingConnection newConnection(final boolean createPartIfNotExists, final HiveConf conf, final UserGroupInformation authenticatedUser, final String agentInfo) throws ConnectionError, InvalidPartition, InvalidTable, PartitionCreationFailed, ImpersonationFailed, InterruptedException {
        if (authenticatedUser == null) {
            return this.newConnectionImpl(authenticatedUser, createPartIfNotExists, conf, agentInfo);
        }
        try {
            return (StreamingConnection)authenticatedUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<StreamingConnection>(){

                @Override
                public StreamingConnection run() throws ConnectionError, InvalidPartition, InvalidTable, PartitionCreationFailed {
                    return HiveEndPoint.this.newConnectionImpl(authenticatedUser, createPartIfNotExists, conf, agentInfo);
                }
            });
        }
        catch (IOException e) {
            throw new ConnectionError("Failed to connect as : " + authenticatedUser.getShortUserName(), (Exception)e);
        }
    }

    private StreamingConnection newConnectionImpl(UserGroupInformation ugi, boolean createPartIfNotExists, HiveConf conf, String agentInfo) throws ConnectionError, InvalidPartition, InvalidTable, PartitionCreationFailed {
        return new ConnectionImpl(this, ugi, conf, createPartIfNotExists, agentInfo);
    }

    private static UserGroupInformation getUserGroupInfo(String user) throws ImpersonationFailed {
        try {
            return UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser());
        }
        catch (IOException e) {
            LOG.error("Unable to get UserGroupInfo for user : " + user, (Throwable)e);
            throw new ImpersonationFailed(user, e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveEndPoint endPoint = (HiveEndPoint)o;
        if (this.database != null ? !this.database.equals(endPoint.database) : endPoint.database != null) {
            return false;
        }
        if (this.metaStoreUri != null ? !this.metaStoreUri.equals(endPoint.metaStoreUri) : endPoint.metaStoreUri != null) {
            return false;
        }
        if (!this.partitionVals.equals(endPoint.partitionVals)) {
            return false;
        }
        return !(this.table != null ? !this.table.equals(endPoint.table) : endPoint.table != null);
    }

    public int hashCode() {
        int result = this.metaStoreUri != null ? this.metaStoreUri.hashCode() : 0;
        result = 31 * result + (this.database != null ? this.database.hashCode() : 0);
        result = 31 * result + (this.table != null ? this.table.hashCode() : 0);
        result = 31 * result + this.partitionVals.hashCode();
        return result;
    }

    public String toString() {
        return "{metaStoreUri='" + this.metaStoreUri + '\'' + ", database='" + this.database + '\'' + ", table='" + this.table + '\'' + ", partitionVals=" + this.partitionVals + " }";
    }

    static HiveConf createHiveConf(Class<?> clazz, String metaStoreUri) {
        HiveConf conf = new HiveConf(clazz);
        if (metaStoreUri != null) {
            HiveEndPoint.setHiveConf(conf, HiveConf.ConfVars.METASTOREURIS, metaStoreUri);
        }
        HiveEndPoint.overrideConfSettings(conf);
        return conf;
    }

    private static void overrideConfSettings(HiveConf conf) {
        HiveEndPoint.setHiveConf(conf, HiveConf.ConfVars.HIVE_TXN_MANAGER, "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager");
        HiveEndPoint.setHiveConf(conf, HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, true);
        HiveEndPoint.setHiveConf(conf, HiveConf.ConfVars.METASTORE_EXECUTE_SET_UGI, true);
        HiveEndPoint.setHiveConf(conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE, "mr");
    }

    private static void setHiveConf(HiveConf conf, HiveConf.ConfVars var, String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Overriding HiveConf setting : " + var + " = " + value);
        }
        conf.setVar(var, value);
    }

    private static void setHiveConf(HiveConf conf, HiveConf.ConfVars var, boolean value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Overriding HiveConf setting : " + var + " = " + value);
        }
        conf.setBoolVar(var, value);
    }

    private static class TransactionBatchImpl
    implements TransactionBatch {
        private final String username;
        private final UserGroupInformation ugi;
        private final HiveEndPoint endPt;
        private final IMetaStoreClient msClient;
        private final IMetaStoreClient heartbeaterMSClient;
        private final RecordWriter recordWriter;
        private final List<TxnToWriteId> txnToWriteIds;
        private volatile int currentTxnIndex = -1;
        private final String partNameForLock;
        private volatile TransactionBatch.TxnState state;
        private LockRequest lockRequest = null;
        private volatile boolean isClosed = false;
        private final String agentInfo;
        private final TransactionBatch.TxnState[] txnStatus;
        private long lastTxnUsed;

        private TransactionBatchImpl(String user, UserGroupInformation ugi, HiveEndPoint endPt, int numTxns, IMetaStoreClient msClient, IMetaStoreClient heartbeaterMSClient, RecordWriter recordWriter, String agentInfo) throws StreamingException, TransactionBatchUnAvailable, InterruptedException {
            boolean success = false;
            try {
                if (endPt.partitionVals != null && !endPt.partitionVals.isEmpty()) {
                    org.apache.hadoop.hive.metastore.api.Table tableObj = msClient.getTable(endPt.database, endPt.table);
                    List partKeys = tableObj.getPartitionKeys();
                    this.partNameForLock = Warehouse.makePartName((List)partKeys, endPt.partitionVals);
                } else {
                    this.partNameForLock = null;
                }
                this.username = user;
                this.ugi = ugi;
                this.endPt = endPt;
                this.msClient = msClient;
                this.heartbeaterMSClient = heartbeaterMSClient;
                this.recordWriter = recordWriter;
                this.agentInfo = agentInfo;
                List<Long> txnIds = this.openTxnImpl(msClient, user, numTxns, ugi);
                this.txnToWriteIds = this.allocateWriteIdsImpl(msClient, txnIds, ugi);
                assert (this.txnToWriteIds.size() == numTxns);
                this.txnStatus = new TransactionBatch.TxnState[numTxns];
                for (int i = 0; i < this.txnStatus.length; ++i) {
                    assert (this.txnToWriteIds.get(i).getTxnId() == txnIds.get(i).longValue());
                    this.txnStatus[i] = TransactionBatch.TxnState.OPEN;
                }
                this.state = TransactionBatch.TxnState.INACTIVE;
                recordWriter.newBatch(this.txnToWriteIds.get(0).getWriteId(), this.txnToWriteIds.get(numTxns - 1).getWriteId());
                success = true;
            }
            catch (TException e) {
                throw new TransactionBatchUnAvailable(endPt, (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new TransactionBatchUnAvailable(endPt, (Exception)e);
            }
            finally {
                this.markDead(success);
            }
        }

        private List<Long> openTxnImpl(final IMetaStoreClient msClient, final String user, final int numTxns, UserGroupInformation ugi) throws IOException, TException, InterruptedException {
            if (ugi == null) {
                return msClient.openTxns(user, numTxns).getTxn_ids();
            }
            return (List)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return msClient.openTxns(user, numTxns).getTxn_ids();
                }
            });
        }

        private List<TxnToWriteId> allocateWriteIdsImpl(final IMetaStoreClient msClient, final List<Long> txnIds, UserGroupInformation ugi) throws IOException, TException, InterruptedException {
            if (ugi == null) {
                return msClient.allocateTableWriteIdsBatch(txnIds, this.endPt.database, this.endPt.table);
            }
            return (List)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return msClient.allocateTableWriteIdsBatch(txnIds, ((TransactionBatchImpl)this).endPt.database, ((TransactionBatchImpl)this).endPt.table);
                }
            });
        }

        public String toString() {
            if (this.txnToWriteIds == null || this.txnToWriteIds.isEmpty()) {
                return "{}";
            }
            StringBuilder sb = new StringBuilder(" TxnStatus[");
            for (TransactionBatch.TxnState state : this.txnStatus) {
                sb.append(state == null ? "N" : state);
            }
            sb.append("] LastUsed ").append(JavaUtils.txnIdToString((long)this.lastTxnUsed));
            return "TxnId/WriteIds=[" + this.txnToWriteIds.get(0).getTxnId() + "/" + this.txnToWriteIds.get(0).getWriteId() + "..." + this.txnToWriteIds.get(this.txnToWriteIds.size() - 1).getTxnId() + "/" + this.txnToWriteIds.get(this.txnToWriteIds.size() - 1).getWriteId() + "] on endPoint = " + this.endPt + "; " + sb;
        }

        @Override
        public void beginNextTransaction() throws TransactionError, ImpersonationFailed, InterruptedException {
            this.checkIsClosed();
            if (this.ugi == null) {
                this.beginNextTransactionImpl();
                return;
            }
            try {
                this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws TransactionError {
                        this.beginNextTransactionImpl();
                        return null;
                    }
                });
            }
            catch (IOException e) {
                throw new ImpersonationFailed("Failed switching to next Txn as user '" + this.username + "' in Txn batch :" + this, e);
            }
        }

        private void beginNextTransactionImpl() throws TransactionError {
            this.state = TransactionBatch.TxnState.INACTIVE;
            if (this.currentTxnIndex + 1 >= this.txnToWriteIds.size()) {
                throw new InvalidTrasactionState("No more transactions available in current batch for end point : " + this.endPt);
            }
            ++this.currentTxnIndex;
            this.state = TransactionBatch.TxnState.OPEN;
            this.lastTxnUsed = this.getCurrentTxnId();
            this.lockRequest = TransactionBatchImpl.createLockRequest(this.endPt, this.partNameForLock, this.username, this.getCurrentTxnId(), this.agentInfo);
            try {
                LockResponse res = this.msClient.lock(this.lockRequest);
                if (res.getState() != LockState.ACQUIRED) {
                    throw new TransactionError("Unable to acquire lock on " + this.endPt);
                }
            }
            catch (TException e) {
                throw new TransactionError("Unable to acquire lock on " + this.endPt, (Exception)((Object)e));
            }
        }

        @Override
        public Long getCurrentTxnId() {
            if (this.currentTxnIndex >= 0) {
                return this.txnToWriteIds.get(this.currentTxnIndex).getTxnId();
            }
            return -1L;
        }

        @Override
        public Long getCurrentWriteId() {
            if (this.currentTxnIndex >= 0) {
                return this.txnToWriteIds.get(this.currentTxnIndex).getWriteId();
            }
            return -1L;
        }

        @Override
        public TransactionBatch.TxnState getCurrentTransactionState() {
            return this.state;
        }

        @Override
        public int remainingTransactions() {
            if (this.currentTxnIndex >= 0) {
                return this.txnToWriteIds.size() - this.currentTxnIndex - 1;
            }
            return this.txnToWriteIds.size();
        }

        @Override
        public void write(byte[] record) throws StreamingException, InterruptedException {
            this.write(Collections.singletonList(record));
        }

        private void checkIsClosed() throws IllegalStateException {
            if (this.isClosed) {
                throw new IllegalStateException("TransactionBatch " + this.toString() + " has been closed()");
            }
        }

        private void markDead(boolean success) {
            if (success) {
                return;
            }
            this.isClosed = true;
            try {
                this.abort(true);
            }
            catch (Exception ex) {
                LOG.error("Fatal error on " + this.toString() + "; cause " + ex.getMessage(), (Throwable)ex);
            }
            try {
                this.closeImpl();
            }
            catch (Exception ex) {
                LOG.error("Fatal error on " + this.toString() + "; cause " + ex.getMessage(), (Throwable)ex);
            }
        }

        @Override
        public void write(final Collection<byte[]> records) throws StreamingException, InterruptedException, ImpersonationFailed {
            this.checkIsClosed();
            boolean success = false;
            try {
                if (this.ugi == null) {
                    this.writeImpl(records);
                } else {
                    this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws StreamingException {
                            this.writeImpl(records);
                            return null;
                        }
                    });
                }
                success = true;
            }
            catch (SerializationError ex) {
                success = true;
                throw ex;
            }
            catch (IOException e) {
                throw new ImpersonationFailed("Failed writing as user '" + this.username + "' to endPoint :" + this.endPt + ". Transaction Id: " + this.getCurrentTxnId(), e);
            }
            finally {
                this.markDead(success);
            }
        }

        private void writeImpl(Collection<byte[]> records) throws StreamingException {
            for (byte[] record : records) {
                this.recordWriter.write(this.getCurrentWriteId(), record);
            }
        }

        @Override
        public void commit() throws TransactionError, StreamingException, ImpersonationFailed, InterruptedException {
            this.checkIsClosed();
            boolean success = false;
            try {
                if (this.ugi == null) {
                    this.commitImpl();
                } else {
                    this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws StreamingException {
                            this.commitImpl();
                            return null;
                        }
                    });
                }
                success = true;
            }
            catch (IOException e) {
                throw new ImpersonationFailed("Failed committing Txn ID " + this.getCurrentTxnId() + " as user '" + this.username + "'on endPoint :" + this.endPt + ". Transaction Id: ", e);
            }
            finally {
                this.markDead(success);
            }
        }

        private void commitImpl() throws TransactionError, StreamingException {
            try {
                this.recordWriter.flush();
                this.msClient.commitTxn(this.txnToWriteIds.get(this.currentTxnIndex).getTxnId());
                this.state = TransactionBatch.TxnState.COMMITTED;
                this.txnStatus[this.currentTxnIndex] = TransactionBatch.TxnState.COMMITTED;
            }
            catch (NoSuchTxnException e) {
                throw new TransactionError("Invalid transaction id : " + this.getCurrentTxnId(), (Exception)((Object)e));
            }
            catch (TxnAbortedException e) {
                throw new TransactionError("Aborted transaction cannot be committed", (Exception)((Object)e));
            }
            catch (TException e) {
                throw new TransactionError("Unable to commit transaction" + this.getCurrentTxnId(), (Exception)((Object)e));
            }
        }

        @Override
        public void abort() throws TransactionError, StreamingException, ImpersonationFailed, InterruptedException {
            if (this.isClosed) {
                return;
            }
            this.abort(false);
        }

        private void abort(final boolean abortAllRemaining) throws TransactionError, StreamingException, ImpersonationFailed, InterruptedException {
            if (this.ugi == null) {
                this.abortImpl(abortAllRemaining);
                return;
            }
            try {
                this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws StreamingException {
                        this.abortImpl(abortAllRemaining);
                        return null;
                    }
                });
            }
            catch (IOException e) {
                throw new ImpersonationFailed("Failed aborting Txn " + this.getCurrentTxnId() + " as user '" + this.username + "' on endPoint :" + this.endPt, e);
            }
        }

        private void abortImpl(boolean abortAllRemaining) throws TransactionError, StreamingException {
            try {
                if (abortAllRemaining) {
                    int minOpenTxnIndex;
                    this.currentTxnIndex = minOpenTxnIndex = Math.max(this.currentTxnIndex + (this.state == TransactionBatch.TxnState.ABORTED || this.state == TransactionBatch.TxnState.COMMITTED ? 1 : 0), 0);
                    while (this.currentTxnIndex < this.txnToWriteIds.size()) {
                        this.msClient.rollbackTxn(this.txnToWriteIds.get(this.currentTxnIndex).getTxnId());
                        this.txnStatus[this.currentTxnIndex] = TransactionBatch.TxnState.ABORTED;
                        ++this.currentTxnIndex;
                    }
                    --this.currentTxnIndex;
                } else if (this.getCurrentTxnId() > 0L) {
                    this.msClient.rollbackTxn(this.getCurrentTxnId().longValue());
                    this.txnStatus[this.currentTxnIndex] = TransactionBatch.TxnState.ABORTED;
                }
                this.state = TransactionBatch.TxnState.ABORTED;
                this.recordWriter.clear();
            }
            catch (NoSuchTxnException e) {
                throw new TransactionError("Unable to abort invalid transaction id : " + this.getCurrentTxnId(), (Exception)((Object)e));
            }
            catch (TException e) {
                throw new TransactionError("Unable to abort transaction id : " + this.getCurrentTxnId(), (Exception)((Object)e));
            }
        }

        @Override
        public void heartbeat() throws StreamingException, HeartBeatFailure {
            if (this.isClosed) {
                return;
            }
            if (this.state != TransactionBatch.TxnState.OPEN && this.currentTxnIndex >= this.txnToWriteIds.size() - 1) {
                return;
            }
            Long first = this.txnToWriteIds.get(this.state == TransactionBatch.TxnState.OPEN ? this.currentTxnIndex : this.currentTxnIndex + 1).getTxnId();
            Long last = this.txnToWriteIds.get(this.txnToWriteIds.size() - 1).getTxnId();
            try {
                HeartbeatTxnRangeResponse resp = this.heartbeaterMSClient.heartbeatTxnRange(first.longValue(), last.longValue());
                if (!resp.getAborted().isEmpty() || !resp.getNosuch().isEmpty()) {
                    throw new HeartBeatFailure(resp.getAborted(), resp.getNosuch());
                }
            }
            catch (TException e) {
                throw new StreamingException("Failure to heartbeat on ids (" + first + "src/gen/thrift" + last + ") on end point : " + this.endPt);
            }
        }

        @Override
        public boolean isClosed() {
            return this.isClosed;
        }

        @Override
        public void close() throws StreamingException, ImpersonationFailed, InterruptedException {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.abortImpl(true);
            this.closeImpl();
        }

        private void closeImpl() throws StreamingException, InterruptedException {
            this.state = TransactionBatch.TxnState.INACTIVE;
            if (this.ugi == null) {
                this.recordWriter.closeBatch();
                return;
            }
            try {
                this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws StreamingException {
                        recordWriter.closeBatch();
                        return null;
                    }
                });
                try {
                    FileSystem.closeAllForUGI((UserGroupInformation)this.ugi);
                }
                catch (IOException exception) {
                    LOG.error("Could not clean up file-system handles for UGI: " + this.ugi, (Throwable)exception);
                }
            }
            catch (IOException e) {
                throw new ImpersonationFailed("Failed closing Txn Batch as user '" + this.username + "' on  endPoint :" + this.endPt, e);
            }
        }

        private static LockRequest createLockRequest(HiveEndPoint hiveEndPoint, String partNameForLock, String user, long txnId, String agentInfo) {
            LockRequestBuilder rqstBuilder = agentInfo == null ? new LockRequestBuilder() : new LockRequestBuilder(agentInfo);
            rqstBuilder.setUser(user);
            rqstBuilder.setTransactionId(txnId);
            LockComponentBuilder lockCompBuilder = new LockComponentBuilder().setDbName(hiveEndPoint.database).setTableName(hiveEndPoint.table).setShared().setOperationType(DataOperationType.INSERT);
            if (partNameForLock != null && !partNameForLock.isEmpty()) {
                lockCompBuilder.setPartitionName(partNameForLock);
            }
            rqstBuilder.addLockComponent(lockCompBuilder.build());
            return rqstBuilder.build();
        }
    }

    private static class ConnectionImpl
    implements StreamingConnection {
        private final IMetaStoreClient msClient;
        private final IMetaStoreClient heartbeaterMSClient;
        private final HiveEndPoint endPt;
        private final UserGroupInformation ugi;
        private final String username;
        private final boolean secureMode;
        private final String agentInfo;

        private ConnectionImpl(HiveEndPoint endPoint, UserGroupInformation ugi, HiveConf conf, boolean createPart, String agentInfo) throws ConnectionError, InvalidPartition, InvalidTable, PartitionCreationFailed {
            this.endPt = endPoint;
            this.ugi = ugi;
            this.agentInfo = agentInfo;
            String string = this.username = ugi == null ? System.getProperty("user.name") : ugi.getShortUserName();
            if (conf == null) {
                conf = HiveEndPoint.createHiveConf(this.getClass(), endPoint.metaStoreUri);
            } else {
                HiveEndPoint.overrideConfSettings(conf);
            }
            this.secureMode = ugi == null ? false : ugi.hasKerberosCredentials();
            this.msClient = ConnectionImpl.getMetaStoreClient(endPoint, conf, this.secureMode);
            this.heartbeaterMSClient = ConnectionImpl.getMetaStoreClient(endPoint, conf, this.secureMode);
            this.checkEndPoint(endPoint, this.msClient);
            if (createPart && !endPoint.partitionVals.isEmpty()) {
                ConnectionImpl.createPartitionIfNotExists(endPoint, this.msClient, conf);
            }
        }

        private void checkEndPoint(HiveEndPoint endPoint, IMetaStoreClient msClient) throws InvalidTable, ConnectionError {
            org.apache.hadoop.hive.metastore.api.Table t;
            try {
                t = msClient.getTable(endPoint.database, endPoint.table);
            }
            catch (Exception e) {
                LOG.warn("Unable to check the endPoint: " + endPoint, (Throwable)e);
                throw new InvalidTable(endPoint.database, endPoint.table, e);
            }
            if (!AcidUtils.isFullAcidTable((org.apache.hadoop.hive.metastore.api.Table)t)) {
                LOG.error("HiveEndPoint " + endPoint + " must use an acid table");
                throw new InvalidTable(endPoint.database, endPoint.table, "is not an Acid table");
            }
            if (t.getPartitionKeys() != null && !t.getPartitionKeys().isEmpty() && endPoint.partitionVals.isEmpty()) {
                String errMsg = "HiveEndPoint " + endPoint + " doesn't specify any partitions for partitioned table";
                LOG.error(errMsg);
                throw new ConnectionError(errMsg);
            }
            if ((t.getPartitionKeys() == null || t.getPartitionKeys().isEmpty()) && !endPoint.partitionVals.isEmpty()) {
                String errMsg = "HiveEndPoint" + endPoint + " specifies partitions for unpartitioned table";
                LOG.error(errMsg);
                throw new ConnectionError(errMsg);
            }
        }

        @Override
        public void close() {
            if (this.ugi == null) {
                this.msClient.close();
                this.heartbeaterMSClient.close();
                return;
            }
            try {
                this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        msClient.close();
                        heartbeaterMSClient.close();
                        return null;
                    }
                });
                try {
                    FileSystem.closeAllForUGI((UserGroupInformation)this.ugi);
                }
                catch (IOException exception) {
                    LOG.error("Could not clean up file-system handles for UGI: " + this.ugi, (Throwable)exception);
                }
            }
            catch (IOException e) {
                LOG.error("Error closing connection to " + this.endPt, (Throwable)e);
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted when closing connection to " + this.endPt, (Throwable)e);
            }
        }

        @Override
        public UserGroupInformation getUserGroupInformation() {
            return this.ugi;
        }

        @Override
        public TransactionBatch fetchTransactionBatch(final int numTransactions, final RecordWriter recordWriter) throws StreamingException, TransactionBatchUnAvailable, ImpersonationFailed, InterruptedException {
            if (this.ugi == null) {
                return this.fetchTransactionBatchImpl(numTransactions, recordWriter);
            }
            try {
                return (TransactionBatch)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TransactionBatch>(){

                    @Override
                    public TransactionBatch run() throws StreamingException, InterruptedException {
                        return this.fetchTransactionBatchImpl(numTransactions, recordWriter);
                    }
                });
            }
            catch (IOException e) {
                throw new ImpersonationFailed("Failed to fetch Txn Batch as user '" + this.ugi.getShortUserName() + "' when acquiring Transaction Batch on endPoint " + this.endPt, e);
            }
        }

        private TransactionBatch fetchTransactionBatchImpl(int numTransactions, RecordWriter recordWriter) throws StreamingException, TransactionBatchUnAvailable, InterruptedException {
            return new TransactionBatchImpl(this.username, this.ugi, this.endPt, numTransactions, this.msClient, this.heartbeaterMSClient, recordWriter, this.agentInfo);
        }

        private static void createPartitionIfNotExists(HiveEndPoint ep, IMetaStoreClient msClient, HiveConf conf) throws PartitionCreationFailed {
            if (ep.partitionVals.isEmpty()) {
                return;
            }
            try {
                Table tableObject = new Table(msClient.getTable(ep.database, ep.table));
                Map partSpec = Warehouse.makeSpecFromValues((List)tableObject.getPartitionKeys(), ep.partitionVals);
                AddPartitionDesc addPartitionDesc = new AddPartitionDesc(ep.database, ep.table, true);
                String partLocation = new Path(tableObject.getDataLocation(), Warehouse.makePartPath((Map)partSpec)).toString();
                addPartitionDesc.addPartition(partSpec, partLocation);
                Partition partition = Hive.convertAddSpecToMetaPartition((Table)tableObject, (AddPartitionDesc.OnePartitionDesc)addPartitionDesc.getPartition(0), (HiveConf)conf);
                msClient.add_partition(partition);
            }
            catch (AlreadyExistsException tableObject) {
            }
            catch (HiveException | TException e) {
                LOG.error("Failed to create partition : " + ep, e);
                throw new PartitionCreationFailed(ep, (Exception)e);
            }
        }

        private static boolean runDDL(IDriver driver, String sql) throws QueryFailedException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running Hive Query: " + sql);
            }
            driver.run(sql);
            return true;
        }

        private static String partSpecStr(List<FieldSchema> partKeys, ArrayList<String> partVals) {
            if (partKeys.size() != partVals.size()) {
                throw new IllegalArgumentException("Partition values:" + partVals + ", does not match the partition Keys in table :" + partKeys);
            }
            StringBuilder buff = new StringBuilder(partKeys.size() * 20);
            buff.append(" ( ");
            int i = 0;
            for (FieldSchema schema : partKeys) {
                buff.append(schema.getName());
                buff.append("='");
                buff.append(partVals.get(i));
                buff.append("'");
                if (i != partKeys.size() - 1) {
                    buff.append(",");
                }
                ++i;
            }
            buff.append(" )");
            return buff.toString();
        }

        private static IMetaStoreClient getMetaStoreClient(HiveEndPoint endPoint, HiveConf conf, boolean secureMode) throws ConnectionError {
            if (endPoint.metaStoreUri != null) {
                conf.setVar(HiveConf.ConfVars.METASTOREURIS, endPoint.metaStoreUri);
            }
            if (secureMode) {
                conf.setBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL, true);
            }
            try {
                return HCatUtil.getHiveMetastoreClient((HiveConf)conf);
            }
            catch (MetaException e) {
                throw new ConnectionError("Error connecting to Hive Metastore URI: " + endPoint.metaStoreUri + ". " + e.getMessage(), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new ConnectionError("Error connecting to Hive Metastore URI: " + endPoint.metaStoreUri + ". " + e.getMessage(), (Exception)e);
            }
        }
    }
}

