/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.worker;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hive.hcatalog.streaming.mutate.worker.Mutator;
import org.apache.hive.hcatalog.streaming.mutate.worker.MutatorImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestMutatorImpl {
    private static final Object RECORD = new Object();
    private static final int RECORD_ID_COLUMN = 2;
    private static final int BUCKET_ID = 0;
    private static final Path PATH = new Path("X");
    private static final long WRITE_ID = 1L;
    @Mock
    private AcidOutputFormat<?, ?> mockOutputFormat;
    @Mock
    private ObjectInspector mockObjectInspector;
    @Mock
    private RecordUpdater mockRecordUpdater;
    @Captor
    private ArgumentCaptor<AcidOutputFormat.Options> captureOptions;
    private final HiveConf configuration = new HiveConf();
    private Mutator mutator;

    @Before
    public void injectMocks() throws IOException {
        Mockito.when((Object)this.mockOutputFormat.getRecordUpdater((Path)Matchers.eq((Object)PATH), (AcidOutputFormat.Options)Matchers.any(AcidOutputFormat.Options.class))).thenReturn((Object)this.mockRecordUpdater);
        this.mutator = new MutatorImpl((Configuration)this.configuration, 2, this.mockObjectInspector, this.mockOutputFormat, 1L, PATH, 0);
    }

    @Test
    public void testCreatesRecordReader() throws IOException {
        ((AcidOutputFormat)Mockito.verify(this.mockOutputFormat)).getRecordUpdater((Path)Matchers.eq((Object)PATH), (AcidOutputFormat.Options)this.captureOptions.capture());
        AcidOutputFormat.Options options = (AcidOutputFormat.Options)this.captureOptions.getValue();
        Assert.assertThat((Object)options.getBucketId(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)options.getConfiguration(), (Matcher)CoreMatchers.is((Object)this.configuration));
        Assert.assertThat((Object)options.getInspector(), (Matcher)CoreMatchers.is((Object)this.mockObjectInspector));
        Assert.assertThat((Object)options.getRecordIdColumn(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)options.getMinimumWriteId(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)options.getMaximumWriteId(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testInsertDelegates() throws IOException {
        this.mutator.insert(RECORD);
        ((RecordUpdater)Mockito.verify((Object)this.mockRecordUpdater)).insert(1L, RECORD);
    }

    @Test
    public void testUpdateDelegates() throws IOException {
        this.mutator.update(RECORD);
        ((RecordUpdater)Mockito.verify((Object)this.mockRecordUpdater)).update(1L, RECORD);
    }

    @Test
    public void testDeleteDelegates() throws IOException {
        this.mutator.delete(RECORD);
        ((RecordUpdater)Mockito.verify((Object)this.mockRecordUpdater)).delete(1L, RECORD);
    }

    @Test
    public void testCloseDelegates() throws IOException {
        this.mutator.close();
        ((RecordUpdater)Mockito.verify((Object)this.mockRecordUpdater)).close(false);
    }

    @Test
    public void testFlushDoesNothing() throws IOException {
        this.mutator.flush();
        ((RecordUpdater)Mockito.verify((Object)this.mockRecordUpdater, (VerificationMode)Mockito.never())).flush();
    }
}

