/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.worker;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hive.hcatalog.streaming.mutate.worker.MetaStorePartitionHelper;
import org.apache.hive.hcatalog.streaming.mutate.worker.PartitionHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestMetaStorePartitionHelper {
    private static final Path TABLE_PATH = new Path("table");
    private static final String TABLE_LOCATION = TABLE_PATH.toString();
    private static final FieldSchema PARTITION_KEY_A = new FieldSchema("A", "string", null);
    private static final FieldSchema PARTITION_KEY_B = new FieldSchema("B", "string", null);
    private static final List<FieldSchema> PARTITION_KEYS = Arrays.asList(PARTITION_KEY_A, PARTITION_KEY_B);
    private static final Path PARTITION_PATH = new Path(TABLE_PATH, "a=1/b=2");
    private static final String PARTITION_LOCATION = PARTITION_PATH.toString();
    private static final String DATABASE_NAME = "db";
    private static final String TABLE_NAME = "one";
    private static final List<String> UNPARTITIONED_VALUES = Collections.emptyList();
    private static final List<String> PARTITIONED_VALUES = Arrays.asList("1", "2");
    @Mock
    private IMetaStoreClient mockClient;
    @Mock
    private Table mockTable;
    private StorageDescriptor tableStorageDescriptor = new StorageDescriptor();
    @Mock
    private Partition mockPartition;
    @Mock
    private StorageDescriptor mockPartitionStorageDescriptor;
    @Captor
    private ArgumentCaptor<Partition> partitionCaptor;
    private PartitionHelper helper;

    @Before
    public void injectMocks() throws Exception {
        Mockito.when((Object)this.mockClient.getTable(DATABASE_NAME, TABLE_NAME)).thenReturn((Object)this.mockTable);
        Mockito.when((Object)this.mockTable.getDbName()).thenReturn((Object)DATABASE_NAME);
        Mockito.when((Object)this.mockTable.getTableName()).thenReturn((Object)TABLE_NAME);
        Mockito.when((Object)this.mockTable.getPartitionKeys()).thenReturn(PARTITION_KEYS);
        Mockito.when((Object)this.mockTable.getSd()).thenReturn((Object)this.tableStorageDescriptor);
        this.tableStorageDescriptor.setLocation(TABLE_LOCATION);
        Mockito.when((Object)this.mockClient.getPartition(DATABASE_NAME, TABLE_NAME, PARTITIONED_VALUES)).thenReturn((Object)this.mockPartition);
        Mockito.when((Object)this.mockPartition.getSd()).thenReturn((Object)this.mockPartitionStorageDescriptor);
        Mockito.when((Object)this.mockPartitionStorageDescriptor.getLocation()).thenReturn((Object)PARTITION_LOCATION);
        this.helper = new MetaStorePartitionHelper(this.mockClient, DATABASE_NAME, TABLE_NAME, TABLE_PATH);
    }

    @Test
    public void getPathForUnpartitionedTable() throws Exception {
        Path path = this.helper.getPathForPartition(UNPARTITIONED_VALUES);
        Assert.assertThat((Object)path, (Matcher)CoreMatchers.is((Object)TABLE_PATH));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockClient});
    }

    @Test
    public void getPathForPartitionedTable() throws Exception {
        Path path = this.helper.getPathForPartition(PARTITIONED_VALUES);
        Assert.assertThat((Object)path, (Matcher)CoreMatchers.is((Object)PARTITION_PATH));
    }

    @Test
    public void createOnUnpartitionTableDoesNothing() throws Exception {
        this.helper.createPartitionIfNotExists(UNPARTITIONED_VALUES);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockClient});
    }

    @Test
    public void createOnPartitionTable() throws Exception {
        this.helper.createPartitionIfNotExists(PARTITIONED_VALUES);
        ((IMetaStoreClient)Mockito.verify((Object)this.mockClient)).add_partition((Partition)this.partitionCaptor.capture());
        Partition actual = (Partition)this.partitionCaptor.getValue();
        Assert.assertThat((Object)actual.getSd().getLocation(), (Matcher)CoreMatchers.is((Object)PARTITION_LOCATION));
        Assert.assertThat((Object)actual.getValues(), (Matcher)CoreMatchers.is(PARTITIONED_VALUES));
    }

    @Test
    public void closeSucceeds() throws IOException {
        this.helper.close();
        ((IMetaStoreClient)Mockito.verify((Object)this.mockClient)).close();
    }
}

