/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.worker;

import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hive.hcatalog.streaming.mutate.worker.SequenceValidator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestSequenceValidator {
    private static final int BUCKET_ID = 1;
    private SequenceValidator validator = new SequenceValidator();

    @Test
    public void testSingleInSequence() {
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(0L, 1, 0L)), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testRowIdInSequence() {
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(0L, 1, 0L)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(0L, 1, 1L)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(0L, 1, 4L)), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testTxIdInSequence() {
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(0L, 1, 0L)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(1L, 1, 0L)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(4L, 1, 0L)), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testMixedInSequence() {
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(0L, 1, 0L)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(0L, 1, 1L)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(1L, 1, 0L)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(1L, 1, 1L)), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testNegativeTxId() {
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(-1L, 1, 0L)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(0L, 1, 0L)), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testNegativeRowId() {
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(0L, 1, -1L)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(0L, 1, 0L)), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testRowIdOutOfSequence() {
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(0L, 1, 0L)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(0L, 1, 4L)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(0L, 1, 1L)), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testReset() {
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(0L, 1, 0L)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(0L, 1, 4L)), (Matcher)CoreMatchers.is((Object)true));
        this.validator.reset();
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(0L, 1, 1L)), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testTxIdOutOfSequence() {
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(0L, 1, 0L)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(4L, 1, 0L)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(1L, 1, 0L)), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testMixedOutOfSequence() {
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(0L, 1, 0L)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(1L, 1, 4L)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(1L, 1, 0L)), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(1L, 1, 5L)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.validator.isInSequence(new RecordIdentifier(0L, 1, 6L)), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=NullPointerException.class)
    public void testNullRecordIdentifier() {
        this.validator.isInSequence(null);
    }
}

