/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.worker;

import java.util.Arrays;
import java.util.Collections;
import org.apache.hive.hcatalog.streaming.mutate.worker.GroupingValidator;
import org.junit.Assert;
import org.junit.Test;

public class TestGroupingValidator {
    private GroupingValidator validator = new GroupingValidator();

    @Test
    public void uniqueGroups() {
        Assert.assertTrue((boolean)this.validator.isInSequence(Arrays.asList("a", "A"), 1));
        Assert.assertTrue((boolean)this.validator.isInSequence(Arrays.asList("c", "C"), 3));
        Assert.assertTrue((boolean)this.validator.isInSequence(Arrays.asList("b", "B"), 2));
    }

    @Test
    public void sameGroup() {
        Assert.assertTrue((boolean)this.validator.isInSequence(Arrays.asList("a", "A"), 1));
        Assert.assertTrue((boolean)this.validator.isInSequence(Arrays.asList("a", "A"), 1));
        Assert.assertTrue((boolean)this.validator.isInSequence(Arrays.asList("a", "A"), 1));
    }

    @Test
    public void revisitedGroup() {
        Assert.assertTrue((boolean)this.validator.isInSequence(Arrays.asList("a", "A"), 1));
        Assert.assertTrue((boolean)this.validator.isInSequence(Arrays.asList("c", "C"), 3));
        Assert.assertFalse((boolean)this.validator.isInSequence(Arrays.asList("a", "A"), 1));
    }

    @Test
    public void samePartitionDifferentBucket() {
        Assert.assertTrue((boolean)this.validator.isInSequence(Arrays.asList("a", "A"), 1));
        Assert.assertTrue((boolean)this.validator.isInSequence(Arrays.asList("c", "C"), 3));
        Assert.assertTrue((boolean)this.validator.isInSequence(Arrays.asList("a", "A"), 2));
    }

    @Test
    public void sameBucketDifferentPartition() {
        Assert.assertTrue((boolean)this.validator.isInSequence(Arrays.asList("a", "A"), 1));
        Assert.assertTrue((boolean)this.validator.isInSequence(Arrays.asList("c", "C"), 3));
        Assert.assertTrue((boolean)this.validator.isInSequence(Arrays.asList("b", "B"), 1));
    }

    @Test
    public void uniqueGroupsNoPartition() {
        Assert.assertTrue((boolean)this.validator.isInSequence(Collections.emptyList(), 1));
        Assert.assertTrue((boolean)this.validator.isInSequence(Collections.emptyList(), 3));
        Assert.assertTrue((boolean)this.validator.isInSequence(Collections.emptyList(), 2));
    }

    @Test
    public void sameGroupNoPartition() {
        Assert.assertTrue((boolean)this.validator.isInSequence(Collections.emptyList(), 1));
        Assert.assertTrue((boolean)this.validator.isInSequence(Collections.emptyList(), 1));
        Assert.assertTrue((boolean)this.validator.isInSequence(Collections.emptyList(), 1));
    }

    @Test
    public void revisitedGroupNoPartition() {
        Assert.assertTrue((boolean)this.validator.isInSequence(Collections.emptyList(), 1));
        Assert.assertTrue((boolean)this.validator.isInSequence(Collections.emptyList(), 3));
        Assert.assertFalse((boolean)this.validator.isInSequence(Collections.emptyList(), 1));
    }
}

