/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hive.hcatalog.streaming.TransactionBatch;
import org.apache.hive.hcatalog.streaming.mutate.client.AcidTable;
import org.apache.hive.hcatalog.streaming.mutate.client.ConnectionException;
import org.apache.hive.hcatalog.streaming.mutate.client.MutatorClient;
import org.apache.hive.hcatalog.streaming.mutate.client.TableType;
import org.apache.hive.hcatalog.streaming.mutate.client.Transaction;
import org.apache.hive.hcatalog.streaming.mutate.client.lock.Lock;
import org.apache.hive.hcatalog.streaming.mutate.client.lock.LockFailureListener;
import org.apache.thrift.TException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestMutatorClient {
    private static final long TRANSACTION_ID = 42L;
    private static final long WRITE_ID1 = 78L;
    private static final long WRITE_ID2 = 33L;
    private static final String TABLE_NAME_1 = "TABLE_1";
    private static final String TABLE_NAME_2 = "TABLE_2";
    private static final String DB_NAME = "DB_1";
    private static final String USER = "user";
    private static final AcidTable TABLE_1 = new AcidTable("DB_1", "TABLE_1", true, TableType.SINK);
    private static final AcidTable TABLE_2 = new AcidTable("DB_1", "TABLE_2", true, TableType.SINK);
    @Mock
    private IMetaStoreClient mockMetaStoreClient;
    @Mock
    private Lock mockLock;
    @Mock
    private Table mockTable1;
    @Mock
    private Table mockTable2;
    @Mock
    private StorageDescriptor mockSd;
    @Mock
    private Map<String, String> mockParameters;
    @Mock
    private HiveConf mockConfiguration;
    @Mock
    private LockFailureListener mockLockFailureListener;
    private MutatorClient client;

    @Before
    public void configureMocks() throws Exception {
        Mockito.when((Object)this.mockMetaStoreClient.getTable(DB_NAME, TABLE_NAME_1)).thenReturn((Object)this.mockTable1);
        Mockito.when((Object)this.mockTable1.getDbName()).thenReturn((Object)DB_NAME);
        Mockito.when((Object)this.mockTable1.getTableName()).thenReturn((Object)TABLE_NAME_1);
        Mockito.when((Object)this.mockTable1.getSd()).thenReturn((Object)this.mockSd);
        Mockito.when((Object)this.mockTable1.getParameters()).thenReturn(this.mockParameters);
        Mockito.when((Object)this.mockMetaStoreClient.getTable(DB_NAME, TABLE_NAME_2)).thenReturn((Object)this.mockTable2);
        Mockito.when((Object)this.mockTable2.getDbName()).thenReturn((Object)DB_NAME);
        Mockito.when((Object)this.mockTable2.getTableName()).thenReturn((Object)TABLE_NAME_2);
        Mockito.when((Object)this.mockTable2.getSd()).thenReturn((Object)this.mockSd);
        Mockito.when((Object)this.mockTable2.getParameters()).thenReturn(this.mockParameters);
        Mockito.when((Object)this.mockSd.getNumBuckets()).thenReturn((Object)1, (Object[])new Integer[]{2});
        Mockito.when((Object)this.mockSd.getOutputFormat()).thenReturn((Object)OrcOutputFormat.class.getName());
        Mockito.when((Object)this.mockParameters.get("transactional")).thenReturn((Object)Boolean.TRUE.toString());
        Mockito.when((Object)this.mockMetaStoreClient.openTxn(USER)).thenReturn((Object)42L);
        Mockito.when((Object)this.mockMetaStoreClient.allocateTableWriteId(42L, DB_NAME, TABLE_NAME_1)).thenReturn((Object)78L);
        Mockito.when((Object)this.mockMetaStoreClient.allocateTableWriteId(42L, DB_NAME, TABLE_NAME_2)).thenReturn((Object)33L);
        this.client = new MutatorClient(this.mockMetaStoreClient, this.mockConfiguration, this.mockLockFailureListener, USER, Collections.singletonList(TABLE_1));
    }

    @Test
    public void testCheckValidTableConnect() throws Exception {
        ArrayList<AcidTable> inTables = new ArrayList<AcidTable>();
        inTables.add(TABLE_1);
        inTables.add(TABLE_2);
        this.client = new MutatorClient(this.mockMetaStoreClient, this.mockConfiguration, this.mockLockFailureListener, USER, inTables);
        this.client.connect();
        List outTables = this.client.getTables();
        Assert.assertThat((Object)this.client.isConnected(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)outTables.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((AcidTable)outTables.get(0)).getDatabaseName(), (Matcher)CoreMatchers.is((Object)DB_NAME));
        Assert.assertThat((Object)((AcidTable)outTables.get(0)).getTableName(), (Matcher)CoreMatchers.is((Object)TABLE_NAME_1));
        Assert.assertThat((Object)((AcidTable)outTables.get(0)).getTotalBuckets(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((AcidTable)outTables.get(0)).getOutputFormatName(), (Matcher)CoreMatchers.is((Object)OrcOutputFormat.class.getName()));
        Assert.assertThat((Object)((AcidTable)outTables.get(0)).getWriteId(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)((AcidTable)outTables.get(0)).getTable(), (Matcher)CoreMatchers.is((Object)this.mockTable1));
        Assert.assertThat((Object)((AcidTable)outTables.get(1)).getDatabaseName(), (Matcher)CoreMatchers.is((Object)DB_NAME));
        Assert.assertThat((Object)((AcidTable)outTables.get(1)).getTableName(), (Matcher)CoreMatchers.is((Object)TABLE_NAME_2));
        Assert.assertThat((Object)((AcidTable)outTables.get(1)).getTotalBuckets(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((AcidTable)outTables.get(1)).getOutputFormatName(), (Matcher)CoreMatchers.is((Object)OrcOutputFormat.class.getName()));
        Assert.assertThat((Object)((AcidTable)outTables.get(1)).getWriteId(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)((AcidTable)outTables.get(1)).getTable(), (Matcher)CoreMatchers.is((Object)this.mockTable2));
    }

    @Test
    public void testCheckNonTransactionalTableConnect() throws Exception {
        Mockito.when((Object)this.mockParameters.get("transactional")).thenReturn((Object)Boolean.FALSE.toString());
        try {
            this.client.connect();
            Assert.fail();
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        Assert.assertThat((Object)this.client.isConnected(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testCheckUnBucketedTableConnect() throws Exception {
        Mockito.when((Object)this.mockSd.getNumBuckets()).thenReturn((Object)0);
        try {
            this.client.connect();
            Assert.fail();
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        Assert.assertThat((Object)this.client.isConnected(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testMetaStoreFailsOnConnect() throws Exception {
        Mockito.when((Object)this.mockMetaStoreClient.getTable(Matchers.anyString(), Matchers.anyString())).thenThrow(new Throwable[]{new TException()});
        try {
            this.client.connect();
            Assert.fail();
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        Assert.assertThat((Object)this.client.isConnected(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=ConnectionException.class)
    public void testGetDestinationsFailsIfNotConnected() throws Exception {
        this.client.getTables();
    }

    @Test
    public void testNewTransaction() throws Exception {
        ArrayList<AcidTable> inTables = new ArrayList<AcidTable>();
        inTables.add(TABLE_1);
        inTables.add(TABLE_2);
        this.client = new MutatorClient(this.mockMetaStoreClient, this.mockConfiguration, this.mockLockFailureListener, USER, inTables);
        this.client.connect();
        Transaction transaction = this.client.newTransaction();
        List outTables = this.client.getTables();
        Assert.assertThat((Object)this.client.isConnected(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)transaction.getTransactionId(), (Matcher)CoreMatchers.is((Object)42L));
        Assert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Object)TransactionBatch.TxnState.INACTIVE));
        Assert.assertThat((Object)((AcidTable)outTables.get(0)).getWriteId(), (Matcher)CoreMatchers.is((Object)78L));
        Assert.assertThat((Object)((AcidTable)outTables.get(1)).getWriteId(), (Matcher)CoreMatchers.is((Object)33L));
    }

    @Test
    public void testCloseClosesClient() throws Exception {
        this.client.close();
        Assert.assertThat((Object)this.client.isConnected(), (Matcher)CoreMatchers.is((Object)false));
        ((IMetaStoreClient)Mockito.verify((Object)this.mockMetaStoreClient)).close();
    }
}

