/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.client;

import java.io.File;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hive.hcatalog.streaming.mutate.StreamingTestUtils;
import org.apache.hive.hcatalog.streaming.mutate.client.AcidTable;
import org.apache.hive.hcatalog.streaming.mutate.client.AcidTableSerializer;
import org.apache.hive.hcatalog.streaming.mutate.client.TableType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestAcidTableSerializer {
    @Test
    public void testSerializeDeserialize() throws Exception {
        Database database = StreamingTestUtils.databaseBuilder(new File("/tmp")).name("db_1").build();
        Table table = StreamingTestUtils.tableBuilder(database).name("table_1").addColumn("one", "string").addColumn("two", "integer").partitionKeys("partition").addPartition("p1").buckets(10).build();
        AcidTable acidTable = new AcidTable("db_1", "table_1", true, TableType.SINK);
        acidTable.setTable(table);
        acidTable.setWriteId(42L);
        String encoded = AcidTableSerializer.encode((AcidTable)acidTable);
        System.out.println(encoded);
        AcidTable decoded = AcidTableSerializer.decode((String)encoded);
        Assert.assertThat((Object)decoded.getDatabaseName(), (Matcher)CoreMatchers.is((Object)"db_1"));
        Assert.assertThat((Object)decoded.getTableName(), (Matcher)CoreMatchers.is((Object)"table_1"));
        Assert.assertThat((Object)decoded.createPartitions(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)decoded.getOutputFormatName(), (Matcher)CoreMatchers.is((Object)"org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat"));
        Assert.assertThat((Object)decoded.getTotalBuckets(), (Matcher)CoreMatchers.is((Object)10));
        Assert.assertThat((Object)decoded.getQualifiedName(), (Matcher)CoreMatchers.is((Object)"DB_1.TABLE_1"));
        Assert.assertThat((Object)decoded.getWriteId(), (Matcher)CoreMatchers.is((Object)42L));
        Assert.assertThat((Object)decoded.getTableType(), (Matcher)CoreMatchers.is((Object)TableType.SINK));
        Assert.assertThat((Object)decoded.getTable(), (Matcher)CoreMatchers.is((Object)table));
    }

    @Test
    public void testSerializeDeserializeNoTableNoTransaction() throws Exception {
        AcidTable acidTable = new AcidTable("db_1", "table_1", true, TableType.SINK);
        String encoded = AcidTableSerializer.encode((AcidTable)acidTable);
        AcidTable decoded = AcidTableSerializer.decode((String)encoded);
        Assert.assertThat((Object)decoded.getDatabaseName(), (Matcher)CoreMatchers.is((Object)"db_1"));
        Assert.assertThat((Object)decoded.getTableName(), (Matcher)CoreMatchers.is((Object)"table_1"));
        Assert.assertThat((Object)decoded.createPartitions(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)decoded.getOutputFormatName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)decoded.getTotalBuckets(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)decoded.getQualifiedName(), (Matcher)CoreMatchers.is((Object)"DB_1.TABLE_1"));
        Assert.assertThat((Object)decoded.getWriteId(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)decoded.getTableType(), (Matcher)CoreMatchers.is((Object)TableType.SINK));
        Assert.assertThat((Object)decoded.getTable(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

