/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.apache.hive.hcatalog.streaming.DelimitedInputWriter;
import org.apache.hive.hcatalog.streaming.InvalidColumn;
import org.junit.Test;

public class TestDelimitedInputWriter {
    @Test
    public void testFieldReordering() throws Exception {
        ArrayList colNames = Lists.newArrayList((Object[])new String[]{"col1", "col2", "col3", "col4", "col5"});
        String[] fieldNames = new String[]{null, "col2", null, "col4", null};
        int[] mapping = DelimitedInputWriter.getFieldReordering((String[])fieldNames, (List)colNames);
        Assert.assertTrue((boolean)Arrays.equals(mapping, new int[]{-1, 1, -1, 3, -1}));
        fieldNames = new String[]{"col5", "col4", "col3", "col2", "col1"};
        mapping = DelimitedInputWriter.getFieldReordering((String[])fieldNames, (List)colNames);
        Assert.assertTrue((boolean)Arrays.equals(mapping, new int[]{4, 3, 2, 1, 0}));
        fieldNames = new String[]{"xyz", "abc", "col3", "col4", "as"};
        try {
            DelimitedInputWriter.getFieldReordering((String[])fieldNames, (List)colNames);
            Assert.fail();
        }
        catch (InvalidColumn mapping2) {
            // empty catch block
        }
        fieldNames = new String[]{"col3", "col4"};
        mapping = DelimitedInputWriter.getFieldReordering((String[])fieldNames, (List)colNames);
        Assert.assertTrue((boolean)Arrays.equals(mapping, new int[]{2, 3}));
        fieldNames = new String[]{"col5", "col4", "col3", "col2", "col1", "col1"};
        try {
            DelimitedInputWriter.getFieldReordering((String[])fieldNames, (List)colNames);
            Assert.fail();
        }
        catch (InvalidColumn invalidColumn) {
            // empty catch block
        }
    }
}

