/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.client.lock;

import com.google.common.collect.ImmutableSet;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hive.hcatalog.streaming.mutate.client.lock.HeartbeatFactory;
import org.apache.hive.hcatalog.streaming.mutate.client.lock.HeartbeatTimerTask;
import org.apache.hive.hcatalog.streaming.mutate.client.lock.Lock;
import org.apache.hive.hcatalog.streaming.mutate.client.lock.LockException;
import org.apache.hive.hcatalog.streaming.mutate.client.lock.LockFailureListener;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestLock {
    private static final Table SOURCE_TABLE_1 = TestLock.createTable("DB", "SOURCE_1");
    private static final Table SOURCE_TABLE_2 = TestLock.createTable("DB", "SOURCE_2");
    private static final Table SINK_TABLE = TestLock.createTable("DB", "SINK");
    private static final Set<Table> SOURCES = ImmutableSet.of((Object)SOURCE_TABLE_1, (Object)SOURCE_TABLE_2);
    private static final Set<Table> SINKS = ImmutableSet.of((Object)SINK_TABLE);
    private static final Set<Table> TABLES = ImmutableSet.of((Object)SOURCE_TABLE_1, (Object)SOURCE_TABLE_2, (Object)SINK_TABLE);
    private static final long LOCK_ID = 42L;
    private static final long TRANSACTION_ID = 109L;
    private static final String USER = "ewest";
    @Mock
    private IMetaStoreClient mockMetaStoreClient;
    @Mock
    private LockFailureListener mockListener;
    @Mock
    private LockResponse mockLockResponse;
    @Mock
    private HeartbeatFactory mockHeartbeatFactory;
    @Mock
    private Timer mockHeartbeat;
    @Captor
    private ArgumentCaptor<LockRequest> requestCaptor;
    private Lock readLock;
    private Lock writeLock;
    private HiveConf configuration = new HiveConf();

    @Before
    public void injectMocks() throws Exception {
        Mockito.when((Object)this.mockMetaStoreClient.lock((LockRequest)Matchers.any(LockRequest.class))).thenReturn((Object)this.mockLockResponse);
        Mockito.when((Object)this.mockLockResponse.getLockid()).thenReturn((Object)42L);
        Mockito.when((Object)this.mockLockResponse.getState()).thenReturn((Object)LockState.ACQUIRED);
        Mockito.when((Object)this.mockHeartbeatFactory.newInstance((IMetaStoreClient)Matchers.any(IMetaStoreClient.class), (LockFailureListener)Matchers.any(LockFailureListener.class), (Long)Matchers.any(Long.class), (Collection)Matchers.any(Collection.class), Matchers.anyLong(), Matchers.anyInt())).thenReturn((Object)this.mockHeartbeat);
        this.readLock = new Lock(this.mockMetaStoreClient, this.mockHeartbeatFactory, this.configuration, this.mockListener, USER, SOURCES, Collections.emptySet(), 3, 0);
        this.writeLock = new Lock(this.mockMetaStoreClient, this.mockHeartbeatFactory, this.configuration, this.mockListener, USER, SOURCES, SINKS, 3, 0);
    }

    @Test
    public void testAcquireReadLockWithNoIssues() throws Exception {
        this.readLock.acquire();
        Assert.assertEquals((Object)42L, (Object)this.readLock.getLockId());
        Assert.assertNull((Object)this.readLock.getTransactionId());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAcquireWriteLockWithoutTxn() throws Exception {
        this.writeLock.acquire();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAcquireWriteLockWithInvalidTxn() throws Exception {
        this.writeLock.acquire(0L);
    }

    @Test
    public void testAcquireTxnLockWithNoIssues() throws Exception {
        this.writeLock.acquire(109L);
        Assert.assertEquals((Object)42L, (Object)this.writeLock.getLockId());
        Assert.assertEquals((Object)109L, (Object)this.writeLock.getTransactionId());
    }

    @Test
    public void testAcquireReadLockCheckHeartbeatCreated() throws Exception {
        this.configuration.set("hive.txn.timeout", "100s");
        this.readLock.acquire();
        ((HeartbeatFactory)Mockito.verify((Object)this.mockHeartbeatFactory)).newInstance((IMetaStoreClient)Matchers.eq((Object)this.mockMetaStoreClient), (LockFailureListener)Matchers.eq((Object)this.mockListener), (Long)Matchers.any(Long.class), (Collection)Matchers.eq(SOURCES), Matchers.eq((long)42L), Matchers.eq((int)75));
    }

    @Test
    public void testAcquireTxnLockCheckHeartbeatCreated() throws Exception {
        this.configuration.set("hive.txn.timeout", "100s");
        this.writeLock.acquire(109L);
        ((HeartbeatFactory)Mockito.verify((Object)this.mockHeartbeatFactory)).newInstance((IMetaStoreClient)Matchers.eq((Object)this.mockMetaStoreClient), (LockFailureListener)Matchers.eq((Object)this.mockListener), Long.valueOf(Matchers.eq((long)109L)), (Collection)Matchers.eq(TABLES), Matchers.eq((long)42L), Matchers.eq((int)75));
    }

    @Test
    public void testAcquireLockCheckUser() throws Exception {
        this.readLock.acquire();
        ((IMetaStoreClient)Mockito.verify((Object)this.mockMetaStoreClient)).lock((LockRequest)this.requestCaptor.capture());
        LockRequest actualRequest = (LockRequest)this.requestCaptor.getValue();
        Assert.assertEquals((Object)USER, (Object)actualRequest.getUser());
    }

    @Test
    public void testAcquireReadLockCheckLocks() throws Exception {
        this.readLock.acquire();
        ((IMetaStoreClient)Mockito.verify((Object)this.mockMetaStoreClient)).lock((LockRequest)this.requestCaptor.capture());
        LockRequest request = (LockRequest)this.requestCaptor.getValue();
        Assert.assertEquals((long)0L, (long)request.getTxnid());
        Assert.assertEquals((Object)USER, (Object)request.getUser());
        Assert.assertEquals((Object)InetAddress.getLocalHost().getHostName(), (Object)request.getHostname());
        List components = request.getComponent();
        Assert.assertEquals((long)2L, (long)components.size());
        LockComponent expected1 = new LockComponent(LockType.SHARED_READ, LockLevel.TABLE, "DB");
        expected1.setTablename("SOURCE_1");
        expected1.setOperationType(DataOperationType.INSERT);
        expected1.setIsAcid(true);
        Assert.assertTrue((boolean)components.contains(expected1));
        LockComponent expected2 = new LockComponent(LockType.SHARED_READ, LockLevel.TABLE, "DB");
        expected2.setTablename("SOURCE_2");
        expected2.setOperationType(DataOperationType.INSERT);
        expected2.setIsAcid(true);
        Assert.assertTrue((boolean)components.contains(expected2));
    }

    @Test
    public void testAcquireTxnLockCheckLocks() throws Exception {
        this.writeLock.acquire(109L);
        ((IMetaStoreClient)Mockito.verify((Object)this.mockMetaStoreClient)).lock((LockRequest)this.requestCaptor.capture());
        LockRequest request = (LockRequest)this.requestCaptor.getValue();
        Assert.assertEquals((long)109L, (long)request.getTxnid());
        Assert.assertEquals((Object)USER, (Object)request.getUser());
        Assert.assertEquals((Object)InetAddress.getLocalHost().getHostName(), (Object)request.getHostname());
        List components = request.getComponent();
        Assert.assertEquals((long)3L, (long)components.size());
        LockComponent expected1 = new LockComponent(LockType.SHARED_READ, LockLevel.TABLE, "DB");
        expected1.setTablename("SOURCE_1");
        expected1.setOperationType(DataOperationType.INSERT);
        expected1.setIsAcid(true);
        Assert.assertTrue((boolean)components.contains(expected1));
        LockComponent expected2 = new LockComponent(LockType.SHARED_READ, LockLevel.TABLE, "DB");
        expected2.setTablename("SOURCE_2");
        expected2.setOperationType(DataOperationType.INSERT);
        expected2.setIsAcid(true);
        Assert.assertTrue((boolean)components.contains(expected2));
        LockComponent expected3 = new LockComponent(LockType.SHARED_WRITE, LockLevel.TABLE, "DB");
        expected3.setTablename("SINK");
        expected3.setOperationType(DataOperationType.UPDATE);
        expected3.setIsAcid(true);
        Assert.assertTrue((boolean)components.contains(expected3));
    }

    @Test(expected=LockException.class)
    public void testAcquireLockNotAcquired() throws Exception {
        Mockito.when((Object)this.mockLockResponse.getState()).thenReturn((Object)LockState.NOT_ACQUIRED);
        this.readLock.acquire();
    }

    @Test(expected=LockException.class)
    public void testAcquireLockAborted() throws Exception {
        Mockito.when((Object)this.mockLockResponse.getState()).thenReturn((Object)LockState.ABORT);
        this.readLock.acquire();
    }

    @Test(expected=LockException.class)
    public void testAcquireLockWithWaitRetriesExceeded() throws Exception {
        Mockito.when((Object)this.mockLockResponse.getState()).thenReturn((Object)LockState.WAITING, (Object[])new LockState[]{LockState.WAITING, LockState.WAITING});
        this.readLock.acquire();
    }

    @Test
    public void testAcquireLockWithWaitRetries() throws Exception {
        Mockito.when((Object)this.mockLockResponse.getState()).thenReturn((Object)LockState.WAITING, (Object[])new LockState[]{LockState.WAITING, LockState.ACQUIRED});
        this.readLock.acquire();
        Assert.assertEquals((Object)42L, (Object)this.readLock.getLockId());
    }

    @Test
    public void testReleaseLock() throws Exception {
        this.readLock.acquire();
        this.readLock.release();
        ((IMetaStoreClient)Mockito.verify((Object)this.mockMetaStoreClient)).unlock(42L);
    }

    @Test
    public void testReleaseLockNoLock() throws Exception {
        this.readLock.release();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockMetaStoreClient});
    }

    @Test
    public void testReleaseLockCancelsHeartbeat() throws Exception {
        this.readLock.acquire();
        this.readLock.release();
        ((Timer)Mockito.verify((Object)this.mockHeartbeat)).cancel();
    }

    @Test
    public void testReadHeartbeat() throws Exception {
        HeartbeatTimerTask task = new HeartbeatTimerTask(this.mockMetaStoreClient, this.mockListener, null, SOURCES, 42L);
        task.run();
        ((IMetaStoreClient)Mockito.verify((Object)this.mockMetaStoreClient)).heartbeat(0L, 42L);
    }

    @Test
    public void testTxnHeartbeat() throws Exception {
        HeartbeatTimerTask task = new HeartbeatTimerTask(this.mockMetaStoreClient, this.mockListener, Long.valueOf(109L), SOURCES, 42L);
        task.run();
        ((IMetaStoreClient)Mockito.verify((Object)this.mockMetaStoreClient)).heartbeat(109L, 42L);
    }

    @Test
    public void testReadHeartbeatFailsNoSuchLockException() throws Exception {
        NoSuchLockException t = new NoSuchLockException();
        ((IMetaStoreClient)Mockito.doThrow((Throwable)t).when((Object)this.mockMetaStoreClient)).heartbeat(0L, 42L);
        HeartbeatTimerTask task = new HeartbeatTimerTask(this.mockMetaStoreClient, this.mockListener, null, SOURCES, 42L);
        task.run();
        ((LockFailureListener)Mockito.verify((Object)this.mockListener)).lockFailed(42L, null, (Iterable)Lock.asStrings(SOURCES), (Throwable)t);
    }

    @Test
    public void testTxnHeartbeatFailsNoSuchLockException() throws Exception {
        NoSuchLockException t = new NoSuchLockException();
        ((IMetaStoreClient)Mockito.doThrow((Throwable)t).when((Object)this.mockMetaStoreClient)).heartbeat(109L, 42L);
        HeartbeatTimerTask task = new HeartbeatTimerTask(this.mockMetaStoreClient, this.mockListener, Long.valueOf(109L), SOURCES, 42L);
        task.run();
        ((LockFailureListener)Mockito.verify((Object)this.mockListener)).lockFailed(42L, Long.valueOf(109L), (Iterable)Lock.asStrings(SOURCES), (Throwable)t);
    }

    @Test
    public void testHeartbeatFailsNoSuchTxnException() throws Exception {
        NoSuchTxnException t = new NoSuchTxnException();
        ((IMetaStoreClient)Mockito.doThrow((Throwable)t).when((Object)this.mockMetaStoreClient)).heartbeat(109L, 42L);
        HeartbeatTimerTask task = new HeartbeatTimerTask(this.mockMetaStoreClient, this.mockListener, Long.valueOf(109L), SOURCES, 42L);
        task.run();
        ((LockFailureListener)Mockito.verify((Object)this.mockListener)).lockFailed(42L, Long.valueOf(109L), (Iterable)Lock.asStrings(SOURCES), (Throwable)t);
    }

    @Test
    public void testHeartbeatFailsTxnAbortedException() throws Exception {
        TxnAbortedException t = new TxnAbortedException();
        ((IMetaStoreClient)Mockito.doThrow((Throwable)t).when((Object)this.mockMetaStoreClient)).heartbeat(109L, 42L);
        HeartbeatTimerTask task = new HeartbeatTimerTask(this.mockMetaStoreClient, this.mockListener, Long.valueOf(109L), SOURCES, 42L);
        task.run();
        ((LockFailureListener)Mockito.verify((Object)this.mockListener)).lockFailed(42L, Long.valueOf(109L), (Iterable)Lock.asStrings(SOURCES), (Throwable)t);
    }

    @Test
    public void testHeartbeatContinuesTException() throws Exception {
        TException t = new TException();
        ((IMetaStoreClient)Mockito.doThrow((Throwable)t).when((Object)this.mockMetaStoreClient)).heartbeat(0L, 42L);
        HeartbeatTimerTask task = new HeartbeatTimerTask(this.mockMetaStoreClient, this.mockListener, Long.valueOf(109L), SOURCES, 42L);
        task.run();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockListener});
    }

    private static Table createTable(String databaseName, String tableName) {
        Table table = new Table();
        table.setDbName(databaseName);
        table.setTableName(tableName);
        return table;
    }
}

