/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate;

import java.util.List;
import org.apache.hive.hcatalog.streaming.mutate.client.AcidTable;
import org.apache.hive.hcatalog.streaming.mutate.client.MutatorClient;
import org.apache.hive.hcatalog.streaming.mutate.client.MutatorClientBuilder;
import org.apache.hive.hcatalog.streaming.mutate.client.Transaction;
import org.apache.hive.hcatalog.streaming.mutate.worker.BucketIdResolver;
import org.apache.hive.hcatalog.streaming.mutate.worker.MutatorCoordinator;
import org.apache.hive.hcatalog.streaming.mutate.worker.MutatorCoordinatorBuilder;
import org.apache.hive.hcatalog.streaming.mutate.worker.MutatorFactory;

public class ExampleUseCase {
    private String metaStoreUri;
    private String databaseName;
    private String tableName;
    private boolean createPartitions = true;
    private List<String> partitionValues1;
    private List<String> partitionValues2;
    private List<String> partitionValues3;
    private Object record1;
    private Object record2;
    private Object record3;
    private MutatorFactory mutatorFactory;

    public void example() throws Exception {
        MutatorClient client = new MutatorClientBuilder().addSinkTable(this.databaseName, this.tableName, this.createPartitions).metaStoreUri(this.metaStoreUri).build();
        Transaction transaction = client.newTransaction();
        List tables = client.getTables();
        transaction.begin();
        BucketIdResolver bucketIdResolver = this.mutatorFactory.newBucketIdResolver(((AcidTable)tables.get(0)).getTotalBuckets());
        this.record1 = bucketIdResolver.attachBucketIdToRecord(this.record1);
        MutatorCoordinator coordinator = new MutatorCoordinatorBuilder().metaStoreUri(this.metaStoreUri).table((AcidTable)tables.get(0)).mutatorFactory(this.mutatorFactory).build();
        coordinator.insert(this.partitionValues1, this.record1);
        coordinator.update(this.partitionValues2, this.record2);
        coordinator.delete(this.partitionValues3, this.record3);
        coordinator.close();
        transaction.commit();
        client.close();
    }
}

