/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.messaging.json;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hive.hcatalog.messaging.AddPartitionMessage;
import org.apache.hive.hcatalog.messaging.AlterPartitionMessage;
import org.apache.hive.hcatalog.messaging.AlterTableMessage;
import org.apache.hive.hcatalog.messaging.CreateDatabaseMessage;
import org.apache.hive.hcatalog.messaging.CreateFunctionMessage;
import org.apache.hive.hcatalog.messaging.CreateTableMessage;
import org.apache.hive.hcatalog.messaging.DropDatabaseMessage;
import org.apache.hive.hcatalog.messaging.DropFunctionMessage;
import org.apache.hive.hcatalog.messaging.DropPartitionMessage;
import org.apache.hive.hcatalog.messaging.DropTableMessage;
import org.apache.hive.hcatalog.messaging.InsertMessage;
import org.apache.hive.hcatalog.messaging.MessageDeserializer;
import org.apache.hive.hcatalog.messaging.MessageFactory;
import org.apache.hive.hcatalog.messaging.json.JSONAddPartitionMessage;
import org.apache.hive.hcatalog.messaging.json.JSONAlterPartitionMessage;
import org.apache.hive.hcatalog.messaging.json.JSONAlterTableMessage;
import org.apache.hive.hcatalog.messaging.json.JSONCreateDatabaseMessage;
import org.apache.hive.hcatalog.messaging.json.JSONCreateFunctionMessage;
import org.apache.hive.hcatalog.messaging.json.JSONCreateTableMessage;
import org.apache.hive.hcatalog.messaging.json.JSONDropDatabaseMessage;
import org.apache.hive.hcatalog.messaging.json.JSONDropFunctionMessage;
import org.apache.hive.hcatalog.messaging.json.JSONDropPartitionMessage;
import org.apache.hive.hcatalog.messaging.json.JSONDropTableMessage;
import org.apache.hive.hcatalog.messaging.json.JSONInsertMessage;
import org.apache.hive.hcatalog.messaging.json.JSONMessageDeserializer;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONMessageFactory
extends MessageFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)JSONMessageFactory.class.getName());
    private static JSONMessageDeserializer deserializer = new JSONMessageDeserializer();

    @Override
    public MessageDeserializer getDeserializer() {
        return deserializer;
    }

    @Override
    public String getVersion() {
        return "0.1";
    }

    @Override
    public String getMessageFormat() {
        return "json";
    }

    @Override
    public CreateDatabaseMessage buildCreateDatabaseMessage(Database db) {
        return new JSONCreateDatabaseMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, db.getName(), this.now());
    }

    @Override
    public DropDatabaseMessage buildDropDatabaseMessage(Database db) {
        return new JSONDropDatabaseMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, db.getName(), this.now());
    }

    @Override
    public CreateTableMessage buildCreateTableMessage(Table table) {
        return new JSONCreateTableMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, table.getDbName(), table.getTableName(), table.getTableType(), this.now());
    }

    @Override
    public AlterTableMessage buildAlterTableMessage(Table before, Table after) {
        return new JSONAlterTableMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, before.getDbName(), before.getTableName(), before.getTableType(), this.now());
    }

    @Override
    public DropTableMessage buildDropTableMessage(Table table) {
        return new JSONDropTableMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, table.getDbName(), table.getTableName(), table.getTableType(), this.now());
    }

    @Override
    public AddPartitionMessage buildAddPartitionMessage(Table table, Iterator<Partition> partitionsIterator) {
        return new JSONAddPartitionMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, table.getDbName(), table.getTableName(), table.getTableType(), JSONMessageFactory.getPartitionKeyValues(table, partitionsIterator), this.now());
    }

    @Override
    public AlterPartitionMessage buildAlterPartitionMessage(Table table, Partition before, Partition after) {
        return new JSONAlterPartitionMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, before.getDbName(), before.getTableName(), table.getTableType(), JSONMessageFactory.getPartitionKeyValues(table, before), this.now());
    }

    @Override
    public DropPartitionMessage buildDropPartitionMessage(Table table, Iterator<Partition> partitions) {
        return new JSONDropPartitionMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, table.getDbName(), table.getTableName(), table.getTableType(), JSONMessageFactory.getPartitionKeyValues(table, partitions), this.now());
    }

    @Override
    public CreateFunctionMessage buildCreateFunctionMessage(org.apache.hadoop.hive.metastore.api.Function fn) {
        return new JSONCreateFunctionMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, fn, this.now());
    }

    @Override
    public DropFunctionMessage buildDropFunctionMessage(org.apache.hadoop.hive.metastore.api.Function fn) {
        return new JSONDropFunctionMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, fn, this.now());
    }

    @Override
    public InsertMessage buildInsertMessage(String db, String table, Map<String, String> partKeyVals, List<String> files) {
        return new JSONInsertMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, db, table, null, partKeyVals, files, this.now());
    }

    @Override
    public InsertMessage buildInsertMessage(String db, Table table, Map<String, String> partKeyVals, List<String> files) {
        return new JSONInsertMessage(HCAT_SERVER_URL, HCAT_SERVICE_PRINCIPAL, table.getDbName(), table.getTableName(), table.getTableType(), partKeyVals, files, this.now());
    }

    private long now() {
        return System.currentTimeMillis() / 1000L;
    }

    private static Map<String, String> getPartitionKeyValues(Table table, Partition partition) {
        LinkedHashMap<String, String> partitionKeys = new LinkedHashMap<String, String>();
        for (int i = 0; i < table.getPartitionKeysSize(); ++i) {
            partitionKeys.put(((FieldSchema)table.getPartitionKeys().get(i)).getName(), (String)partition.getValues().get(i));
        }
        return partitionKeys;
    }

    private static List<Map<String, String>> getPartitionKeyValues(final Table table, Iterator<Partition> iterator) {
        return Lists.newArrayList((Iterator)Iterators.transform(iterator, (Function)new Function<Partition, Map<String, String>>(){

            public Map<String, String> apply(@Nullable Partition partition) {
                return JSONMessageFactory.getPartitionKeyValues(table, partition);
            }
        }));
    }

    static String createFunctionObjJson(org.apache.hadoop.hive.metastore.api.Function functionObj) throws TException {
        TSerializer serializer = new TSerializer((TProtocolFactory)new TJSONProtocol.Factory());
        return serializer.toString((TBase)functionObj, "UTF-8");
    }
}

