/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.listener;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.RawStoreProxy;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.AbortTxnEvent;
import org.apache.hadoop.hive.metastore.events.AddForeignKeyEvent;
import org.apache.hadoop.hive.metastore.events.AddNotNullConstraintEvent;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AddPrimaryKeyEvent;
import org.apache.hadoop.hive.metastore.events.AddUniqueConstraintEvent;
import org.apache.hadoop.hive.metastore.events.AllocWriteIdEvent;
import org.apache.hadoop.hive.metastore.events.AlterDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.CommitTxnEvent;
import org.apache.hadoop.hive.metastore.events.ConfigChangeEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateFunctionEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropConstraintEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropFunctionEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.events.InsertEvent;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.events.LoadPartitionDoneEvent;
import org.apache.hadoop.hive.metastore.events.OpenTxnEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.metastore.messaging.OpenTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.PartitionFiles;
import org.apache.hadoop.hive.metastore.tools.SQLGenerator;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbNotificationListener
extends TransactionalMetaStoreEventListener {
    private static final Logger LOG = LoggerFactory.getLogger((String)DbNotificationListener.class.getName());
    private static CleanerThread cleaner = null;
    private Configuration conf;
    private MessageFactory msgFactory;

    private static synchronized void init(Configuration conf) throws MetaException {
        if (cleaner == null) {
            cleaner = new CleanerThread(conf, RawStoreProxy.getProxy((Configuration)conf, (Configuration)conf, (String)MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.RAW_STORE_IMPL), (int)999999));
            cleaner.start();
        }
    }

    public DbNotificationListener(Configuration config) throws MetaException {
        super(config);
        this.conf = config;
        DbNotificationListener.init(this.conf);
        this.msgFactory = MessageFactory.getInstance();
    }

    public void onConfigChange(ConfigChangeEvent tableEvent) throws MetaException {
        String key = tableEvent.getKey();
        if (key.equals(MetastoreConf.ConfVars.EVENT_DB_LISTENER_TTL.toString()) || key.equals(MetastoreConf.ConfVars.EVENT_DB_LISTENER_TTL.getHiveName())) {
            long time = MetastoreConf.convertTimeStr((String)tableEvent.getNewValue(), (TimeUnit)TimeUnit.SECONDS, (TimeUnit)TimeUnit.SECONDS);
            MetastoreConf.setTimeVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_DB_LISTENER_TTL, (long)time, (TimeUnit)TimeUnit.SECONDS);
            cleaner.setTimeToLive(MetastoreConf.getTimeVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_DB_LISTENER_TTL, (TimeUnit)TimeUnit.SECONDS));
        }
    }

    public void onCreateTable(CreateTableEvent tableEvent) throws MetaException {
        Table t = tableEvent.getTable();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.CREATE_TABLE.toString(), this.msgFactory.buildCreateTableMessage(t, (Iterator)new FileIterator(t.getSd().getLocation())).toString());
        event.setCatName(t.isSetCatName() ? t.getCatName() : "hive");
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.process(event, (ListenerEvent)tableEvent);
    }

    public void onDropTable(DropTableEvent tableEvent) throws MetaException {
        Table t = tableEvent.getTable();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DROP_TABLE.toString(), this.msgFactory.buildDropTableMessage(t).toString());
        event.setCatName(t.isSetCatName() ? t.getCatName() : "hive");
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.process(event, (ListenerEvent)tableEvent);
    }

    public void onAlterTable(AlterTableEvent tableEvent) throws MetaException {
        Table before = tableEvent.getOldTable();
        Table after = tableEvent.getNewTable();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ALTER_TABLE.toString(), this.msgFactory.buildAlterTableMessage(before, after, tableEvent.getIsTruncateOp()).toString());
        event.setCatName(after.isSetCatName() ? after.getCatName() : "hive");
        event.setDbName(after.getDbName());
        event.setTableName(after.getTableName());
        this.process(event, (ListenerEvent)tableEvent);
    }

    public void onAddPartition(AddPartitionEvent partitionEvent) throws MetaException {
        Table t = partitionEvent.getTable();
        String msg = this.msgFactory.buildAddPartitionMessage(t, partitionEvent.getPartitionIterator(), (Iterator)new PartitionFilesIterator(partitionEvent.getPartitionIterator(), t)).toString();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ADD_PARTITION.toString(), msg);
        event.setCatName(t.isSetCatName() ? t.getCatName() : "hive");
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.process(event, (ListenerEvent)partitionEvent);
    }

    public void onDropPartition(DropPartitionEvent partitionEvent) throws MetaException {
        Table t = partitionEvent.getTable();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DROP_PARTITION.toString(), this.msgFactory.buildDropPartitionMessage(t, partitionEvent.getPartitionIterator()).toString());
        event.setCatName(t.isSetCatName() ? t.getCatName() : "hive");
        event.setDbName(t.getDbName());
        event.setTableName(t.getTableName());
        this.process(event, (ListenerEvent)partitionEvent);
    }

    public void onAlterPartition(AlterPartitionEvent partitionEvent) throws MetaException {
        Partition before = partitionEvent.getOldPartition();
        Partition after = partitionEvent.getNewPartition();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ALTER_PARTITION.toString(), this.msgFactory.buildAlterPartitionMessage(partitionEvent.getTable(), before, after, partitionEvent.getIsTruncateOp()).toString());
        event.setCatName(before.isSetCatName() ? before.getCatName() : "hive");
        event.setDbName(before.getDbName());
        event.setTableName(before.getTableName());
        this.process(event, (ListenerEvent)partitionEvent);
    }

    public void onCreateDatabase(CreateDatabaseEvent dbEvent) throws MetaException {
        Database db = dbEvent.getDatabase();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.CREATE_DATABASE.toString(), this.msgFactory.buildCreateDatabaseMessage(db).toString());
        event.setCatName(db.isSetCatalogName() ? db.getCatalogName() : "hive");
        event.setDbName(db.getName());
        this.process(event, (ListenerEvent)dbEvent);
    }

    public void onDropDatabase(DropDatabaseEvent dbEvent) throws MetaException {
        Database db = dbEvent.getDatabase();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DROP_DATABASE.toString(), this.msgFactory.buildDropDatabaseMessage(db).toString());
        event.setCatName(db.isSetCatalogName() ? db.getCatalogName() : "hive");
        event.setDbName(db.getName());
        this.process(event, (ListenerEvent)dbEvent);
    }

    public void onAlterDatabase(AlterDatabaseEvent dbEvent) throws MetaException {
        Database oldDb = dbEvent.getOldDatabase();
        Database newDb = dbEvent.getNewDatabase();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ALTER_DATABASE.toString(), this.msgFactory.buildAlterDatabaseMessage(oldDb, newDb).toString());
        event.setCatName(oldDb.isSetCatalogName() ? oldDb.getCatalogName() : "hive");
        event.setDbName(oldDb.getName());
        this.process(event, (ListenerEvent)dbEvent);
    }

    public void onCreateFunction(CreateFunctionEvent fnEvent) throws MetaException {
        Function fn = fnEvent.getFunction();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.CREATE_FUNCTION.toString(), this.msgFactory.buildCreateFunctionMessage(fn).toString());
        event.setCatName(fn.isSetCatName() ? fn.getCatName() : "hive");
        event.setDbName(fn.getDbName());
        this.process(event, (ListenerEvent)fnEvent);
    }

    public void onDropFunction(DropFunctionEvent fnEvent) throws MetaException {
        Function fn = fnEvent.getFunction();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DROP_FUNCTION.toString(), this.msgFactory.buildDropFunctionMessage(fn).toString());
        event.setCatName(fn.isSetCatName() ? fn.getCatName() : "hive");
        event.setDbName(fn.getDbName());
        this.process(event, (ListenerEvent)fnEvent);
    }

    public void onInsert(InsertEvent insertEvent) throws MetaException {
        Table tableObj = insertEvent.getTableObj();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.INSERT.toString(), this.msgFactory.buildInsertMessage(tableObj, insertEvent.getPartitionObj(), insertEvent.isReplace(), (Iterator)new FileChksumIterator(insertEvent.getFiles(), insertEvent.getFileChecksums())).toString());
        event.setCatName(tableObj.isSetCatName() ? tableObj.getCatName() : "hive");
        event.setDbName(tableObj.getDbName());
        event.setTableName(tableObj.getTableName());
        this.process(event, (ListenerEvent)insertEvent);
    }

    public void onOpenTxn(OpenTxnEvent openTxnEvent, Connection dbConn, SQLGenerator sqlGenerator) throws MetaException {
        int lastTxnIdx = openTxnEvent.getTxnIds().size() - 1;
        OpenTxnMessage msg = this.msgFactory.buildOpenTxnMessage((Long)openTxnEvent.getTxnIds().get(0), (Long)openTxnEvent.getTxnIds().get(lastTxnIdx));
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.OPEN_TXN.toString(), msg.toString());
        try {
            this.addNotificationLog(event, (ListenerEvent)openTxnEvent, dbConn, sqlGenerator);
        }
        catch (SQLException e) {
            throw new MetaException("Unable to execute direct SQL " + StringUtils.stringifyException((Throwable)e));
        }
    }

    public void onCommitTxn(CommitTxnEvent commitTxnEvent, Connection dbConn, SQLGenerator sqlGenerator) throws MetaException {
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.COMMIT_TXN.toString(), this.msgFactory.buildCommitTxnMessage(commitTxnEvent.getTxnId()).toString());
        try {
            this.addNotificationLog(event, (ListenerEvent)commitTxnEvent, dbConn, sqlGenerator);
        }
        catch (SQLException e) {
            throw new MetaException("Unable to execute direct SQL " + StringUtils.stringifyException((Throwable)e));
        }
    }

    public void onAbortTxn(AbortTxnEvent abortTxnEvent, Connection dbConn, SQLGenerator sqlGenerator) throws MetaException {
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ABORT_TXN.toString(), this.msgFactory.buildAbortTxnMessage(abortTxnEvent.getTxnId()).toString());
        try {
            this.addNotificationLog(event, (ListenerEvent)abortTxnEvent, dbConn, sqlGenerator);
        }
        catch (SQLException e) {
            throw new MetaException("Unable to execute direct SQL " + StringUtils.stringifyException((Throwable)e));
        }
    }

    public void onLoadPartitionDone(LoadPartitionDoneEvent partSetDoneEvent) throws MetaException {
    }

    public void onAddPrimaryKey(AddPrimaryKeyEvent addPrimaryKeyEvent) throws MetaException {
        List cols = addPrimaryKeyEvent.getPrimaryKeyCols();
        if (cols.size() > 0) {
            NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ADD_PRIMARYKEY.toString(), this.msgFactory.buildAddPrimaryKeyMessage(addPrimaryKeyEvent.getPrimaryKeyCols()).toString());
            event.setCatName(((SQLPrimaryKey)cols.get(0)).isSetCatName() ? ((SQLPrimaryKey)cols.get(0)).getCatName() : "hive");
            event.setDbName(((SQLPrimaryKey)cols.get(0)).getTable_db());
            event.setTableName(((SQLPrimaryKey)cols.get(0)).getTable_name());
            this.process(event, (ListenerEvent)addPrimaryKeyEvent);
        }
    }

    public void onAddForeignKey(AddForeignKeyEvent addForeignKeyEvent) throws MetaException {
        List cols = addForeignKeyEvent.getForeignKeyCols();
        if (cols.size() > 0) {
            NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ADD_FOREIGNKEY.toString(), this.msgFactory.buildAddForeignKeyMessage(addForeignKeyEvent.getForeignKeyCols()).toString());
            event.setCatName(((SQLForeignKey)cols.get(0)).isSetCatName() ? ((SQLForeignKey)cols.get(0)).getCatName() : "hive");
            event.setDbName(((SQLForeignKey)cols.get(0)).getPktable_db());
            event.setTableName(((SQLForeignKey)cols.get(0)).getPktable_name());
            this.process(event, (ListenerEvent)addForeignKeyEvent);
        }
    }

    public void onAddUniqueConstraint(AddUniqueConstraintEvent addUniqueConstraintEvent) throws MetaException {
        List cols = addUniqueConstraintEvent.getUniqueConstraintCols();
        if (cols.size() > 0) {
            NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ADD_UNIQUECONSTRAINT.toString(), this.msgFactory.buildAddUniqueConstraintMessage(addUniqueConstraintEvent.getUniqueConstraintCols()).toString());
            event.setCatName(((SQLUniqueConstraint)cols.get(0)).isSetCatName() ? ((SQLUniqueConstraint)cols.get(0)).getCatName() : "hive");
            event.setDbName(((SQLUniqueConstraint)cols.get(0)).getTable_db());
            event.setTableName(((SQLUniqueConstraint)cols.get(0)).getTable_name());
            this.process(event, (ListenerEvent)addUniqueConstraintEvent);
        }
    }

    public void onAddNotNullConstraint(AddNotNullConstraintEvent addNotNullConstraintEvent) throws MetaException {
        List cols = addNotNullConstraintEvent.getNotNullConstraintCols();
        if (cols.size() > 0) {
            NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ADD_NOTNULLCONSTRAINT.toString(), this.msgFactory.buildAddNotNullConstraintMessage(addNotNullConstraintEvent.getNotNullConstraintCols()).toString());
            event.setCatName(((SQLNotNullConstraint)cols.get(0)).isSetCatName() ? ((SQLNotNullConstraint)cols.get(0)).getCatName() : "hive");
            event.setDbName(((SQLNotNullConstraint)cols.get(0)).getTable_db());
            event.setTableName(((SQLNotNullConstraint)cols.get(0)).getTable_name());
            this.process(event, (ListenerEvent)addNotNullConstraintEvent);
        }
    }

    public void onDropConstraint(DropConstraintEvent dropConstraintEvent) throws MetaException {
        String dbName = dropConstraintEvent.getDbName();
        String tableName = dropConstraintEvent.getTableName();
        String constraintName = dropConstraintEvent.getConstraintName();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.DROP_CONSTRAINT.toString(), this.msgFactory.buildDropConstraintMessage(dbName, tableName, constraintName).toString());
        event.setCatName(dropConstraintEvent.getCatName());
        event.setDbName(dbName);
        event.setTableName(tableName);
        this.process(event, (ListenerEvent)dropConstraintEvent);
    }

    public void onAllocWriteId(AllocWriteIdEvent allocWriteIdEvent, Connection dbConn, SQLGenerator sqlGenerator) throws MetaException {
        String tableName = allocWriteIdEvent.getTableName();
        String dbName = allocWriteIdEvent.getDbName();
        NotificationEvent event = new NotificationEvent(0L, this.now(), EventMessage.EventType.ALLOC_WRITE_ID.toString(), this.msgFactory.buildAllocWriteIdMessage(allocWriteIdEvent.getTxnToWriteIdList(), dbName, tableName).toString());
        event.setTableName(tableName);
        event.setDbName(dbName);
        try {
            this.addNotificationLog(event, (ListenerEvent)allocWriteIdEvent, dbConn, sqlGenerator);
        }
        catch (SQLException e) {
            throw new MetaException("Unable to execute direct SQL " + StringUtils.stringifyException((Throwable)e));
        }
    }

    private int now() {
        long millis = System.currentTimeMillis();
        if ((millis /= 1000L) > Integer.MAX_VALUE) {
            LOG.warn("We've passed max int value in seconds since the epoch, all notification times will be the same!");
            return Integer.MAX_VALUE;
        }
        return (int)millis;
    }

    static String quoteString(String input) {
        return "'" + input + "'";
    }

    private void addNotificationLog(NotificationEvent event, ListenerEvent listenerEvent, Connection dbConn, SQLGenerator sqlGenerator) throws MetaException, SQLException {
        if (dbConn == null || sqlGenerator == null) {
            LOG.info("connection or sql generator is not set so executing sql via DN");
            this.process(event, listenerEvent);
            return;
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.createStatement();
            event.setMessageFormat(this.msgFactory.getMessageFormat());
            if (sqlGenerator.getDbProduct() == DatabaseProduct.MYSQL) {
                stmt.execute("SET @@session.sql_mode=ANSI_QUOTES");
            }
            String s = sqlGenerator.addForUpdateClause("select \"NEXT_EVENT_ID\"  from \"NOTIFICATION_SEQUENCE\"");
            LOG.debug("Going to execute query <" + s + ">");
            rs = stmt.executeQuery(s);
            if (!rs.next()) {
                throw new MetaException("Transaction database not properly configured, can't find next event id.");
            }
            long nextEventId = rs.getLong(1);
            long updatedEventid = nextEventId + 1L;
            s = "update \"NOTIFICATION_SEQUENCE\" set \"NEXT_EVENT_ID\" = " + updatedEventid;
            LOG.debug("Going to execute update <" + s + ">");
            stmt.executeUpdate(s);
            s = sqlGenerator.addForUpdateClause("select \"NEXT_VAL\" from \"SEQUENCE_TABLE\" where \"SEQUENCE_NAME\" =  'org.apache.hadoop.hive.metastore.model.MNotificationLog'");
            LOG.debug("Going to execute query <" + s + ">");
            rs = stmt.executeQuery(s);
            if (!rs.next()) {
                throw new MetaException("failed to get next NEXT_VAL from SEQUENCE_TABLE");
            }
            long nextNLId = rs.getLong(1);
            long updatedNLId = nextNLId + 1L;
            s = "update \"SEQUENCE_TABLE\" set \"NEXT_VAL\" = " + updatedNLId + " where \"SEQUENCE_NAME\" =  'org.apache.hadoop.hive.metastore.model.MNotificationLog'";
            LOG.debug("Going to execute update <" + s + ">");
            stmt.executeUpdate(s);
            ArrayList<String> insert = new ArrayList<String>();
            insert.add(0, nextNLId + "," + nextEventId + "," + this.now() + "," + DbNotificationListener.quoteString(event.getEventType()) + "," + DbNotificationListener.quoteString(event.getDbName()) + "," + DbNotificationListener.quoteString(" ") + "," + DbNotificationListener.quoteString(event.getMessage()) + "," + DbNotificationListener.quoteString(event.getMessageFormat()));
            List sql = sqlGenerator.createInsertValuesStmt("\"NOTIFICATION_LOG\" (\"NL_ID\", \"EVENT_ID\", \"EVENT_TIME\",  \"EVENT_TYPE\", \"DB_NAME\", \"TBL_NAME\", \"MESSAGE\", \"MESSAGE_FORMAT\")", insert);
            for (String q : sql) {
                LOG.info("Going to execute insert <" + q + ">");
                stmt.execute(q);
            }
            if (event.isSetEventId()) {
                listenerEvent.putParameter("DB_NOTIFICATION_EVENT_ID_KEY_NAME", Long.toString(event.getEventId()));
            }
        }
        catch (SQLException e) {
            LOG.warn("failed to add notification log" + e.getMessage());
            throw e;
        }
        finally {
            if (stmt != null && !stmt.isClosed()) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LOG.warn("Failed to close statement " + e.getMessage());
                }
            }
            if (rs != null && !rs.isClosed()) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    LOG.warn("Failed to close result set " + e.getMessage());
                }
            }
        }
    }

    private void process(NotificationEvent event, ListenerEvent listenerEvent) throws MetaException {
        event.setMessageFormat(this.msgFactory.getMessageFormat());
        LOG.debug("DbNotificationListener: Processing : {}:{}", (Object)event.getEventId(), (Object)event.getMessage());
        HiveMetaStore.HMSHandler.getMSForConf((Configuration)this.conf).addNotificationEvent(event);
        if (event.isSetEventId()) {
            listenerEvent.putParameter("DB_NOTIFICATION_EVENT_ID_KEY_NAME", Long.toString(event.getEventId()));
        }
    }

    private static class CleanerThread
    extends Thread {
        private RawStore rs;
        private int ttl;
        private static long sleepTime = 60000L;

        CleanerThread(Configuration conf, RawStore rs) {
            super("DB-Notification-Cleaner");
            this.rs = rs;
            this.setTimeToLive(MetastoreConf.getTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_DB_LISTENER_TTL, (TimeUnit)TimeUnit.SECONDS));
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    this.rs.cleanNotificationEvents(this.ttl);
                }
                catch (Exception ex) {
                    LOG.warn("Exception received while cleaning notifications. More details can be found in debug mode" + ex.getMessage());
                    LOG.debug(ex.getMessage(), (Throwable)ex);
                }
                LOG.debug("Cleaner thread done");
                try {
                    Thread.sleep(sleepTime);
                    continue;
                }
                catch (InterruptedException e) {
                    LOG.info("Cleaner thread sleep interrupted", (Throwable)e);
                    continue;
                }
                break;
            }
        }

        public void setTimeToLive(long configTtl) {
            this.ttl = configTtl > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)configTtl;
        }
    }

    class FileChksumIterator
    implements Iterator<String> {
        private List<String> files;
        private List<String> chksums;
        int i = 0;

        FileChksumIterator(List<String> files, List<String> chksums) {
            this.files = files;
            this.chksums = chksums;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.files.size();
        }

        @Override
        public String next() {
            String result;
            try {
                result = ReplChangeManager.encodeFileUri((String)this.files.get(this.i), this.chksums != null ? this.chksums.get(this.i) : null, null);
            }
            catch (IOException e) {
                LOG.error("Encoding file URI failed with error " + e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
            ++this.i;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class PartitionFilesIterator
    implements Iterator<PartitionFiles> {
        private Iterator<Partition> partitionIter;
        private Table t;

        PartitionFilesIterator(Iterator<Partition> partitionIter, Table t) {
            this.partitionIter = partitionIter;
            this.t = t;
        }

        @Override
        public boolean hasNext() {
            return this.partitionIter.hasNext();
        }

        @Override
        public PartitionFiles next() {
            try {
                Partition p = this.partitionIter.next();
                ArrayList files = Lists.newArrayList((Iterator)new FileIterator(p.getSd().getLocation()));
                PartitionFiles partitionFiles = new PartitionFiles(Warehouse.makePartName((List)this.t.getPartitionKeys(), (List)p.getValues()), files.iterator());
                return partitionFiles;
            }
            catch (MetaException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class FileIterator
    implements Iterator<String> {
        PathFilter VALID_FILES_FILTER = new PathFilter(){

            public boolean accept(Path p) {
                try {
                    if (!FileIterator.this.fs.isFile(p)) {
                        return false;
                    }
                    String name = p.getName();
                    return !name.startsWith("_") && !name.startsWith(".");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        private FileSystem fs;
        private FileStatus[] files;
        private int i = 0;

        FileIterator(String locString) {
            try {
                if (locString != null) {
                    Path loc = new Path(locString);
                    this.fs = loc.getFileSystem(DbNotificationListener.this.conf);
                    this.files = this.fs.listStatus(loc, this.VALID_FILES_FILTER);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.files == null) {
                return false;
            }
            return this.i < this.files.length;
        }

        @Override
        public String next() {
            try {
                FileStatus file = this.files[this.i];
                ++this.i;
                return ReplChangeManager.encodeFileUri((String)file.getPath().toString(), (String)ReplChangeManager.checksumFor((Path)file.getPath(), (FileSystem)this.fs), null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

