/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hbase.HBCKFsUtils;
import org.apache.hbase.HBCKMetaTableAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsRegionsMetaRecoverer
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(FsRegionsMetaRecoverer.class);
    private final FileSystem fs;
    private final Connection conn;
    private final Configuration config;

    public FsRegionsMetaRecoverer(Configuration configuration) throws IOException {
        this.config = configuration;
        this.fs = HBCKFsUtils.getRootDir(configuration).getFileSystem(configuration);
        this.conn = ConnectionFactory.createConnection((Configuration)configuration);
    }

    FsRegionsMetaRecoverer(Configuration configuration, Connection connection, FileSystem fileSystem) {
        this.config = configuration;
        this.conn = connection;
        this.fs = fileSystem;
    }

    private List<Path> getTableRegionsDirs(String table) throws IOException {
        String hbaseRoot = this.config.get("hbase.rootdir");
        Path tableDir = HBCKFsUtils.getTableDir(new Path(hbaseRoot), TableName.valueOf((String)table));
        return FSUtils.getRegionDirs((FileSystem)this.fs, (Path)tableDir);
    }

    public Map<TableName, List<Path>> reportTablesMissingRegions(List<String> namespacesOrTables) throws IOException {
        InternalMetaChecker missingChecker = new InternalMetaChecker();
        return missingChecker.reportTablesRegions(namespacesOrTables, this::findMissingRegionsInMETA);
    }

    public Map<TableName, List<RegionInfo>> reportTablesExtraRegions(List<String> namespacesOrTables) throws IOException {
        InternalMetaChecker extraChecker = new InternalMetaChecker();
        return extraChecker.reportTablesRegions(namespacesOrTables, this::findExtraRegionsInMETA);
    }

    List<Path> findMissingRegionsInMETA(String table) throws IOException {
        InternalMetaChecker missingChecker = new InternalMetaChecker();
        return missingChecker.checkRegionsInMETA(table, (regions, dirs) -> {
            ListUtils<Path, RegionInfo> utils = new ListUtils<Path, RegionInfo>();
            return utils.complement((List<Path>)dirs, (List<RegionInfo>)regions, d -> d.getName(), r -> r.getEncodedName());
        });
    }

    List<RegionInfo> findExtraRegionsInMETA(String table) throws IOException {
        InternalMetaChecker extraChecker = new InternalMetaChecker();
        return extraChecker.checkRegionsInMETA(table, (regions, dirs) -> {
            ListUtils<RegionInfo, Path> utils = new ListUtils<RegionInfo, Path>();
            return utils.complement((List<RegionInfo>)regions, (List<Path>)dirs, r -> r.getEncodedName(), d -> d.getName());
        });
    }

    void putRegionInfoFromHdfsInMeta(Path region) throws IOException {
        RegionInfo info = HRegionFileSystem.loadRegionInfoFileContent((FileSystem)this.fs, (Path)region);
        HBCKMetaTableAccessor.addRegionToMeta(this.conn, info);
    }

    List<String> addMissingRegionsInMeta(List<Path> regionsPath) throws IOException {
        ArrayList<String> reAddedRegionsEncodedNames = new ArrayList<String>();
        for (Path regionPath : regionsPath) {
            this.putRegionInfoFromHdfsInMeta(regionPath);
            reAddedRegionsEncodedNames.add(regionPath.getName());
        }
        return reAddedRegionsEncodedNames;
    }

    public List<Future<List<String>>> addMissingRegionsInMetaForTables(List<String> nameSpaceOrTable) throws IOException {
        InternalMetaChecker missingChecker = new InternalMetaChecker();
        return missingChecker.processRegionsMetaCleanup(this::reportTablesMissingRegions, this::addMissingRegionsInMeta, nameSpaceOrTable);
    }

    public List<Future<List<String>>> removeExtraRegionsFromMetaForTables(List<String> nameSpaceOrTable) throws IOException {
        if (nameSpaceOrTable.size() > 0) {
            InternalMetaChecker extraChecker = new InternalMetaChecker();
            return extraChecker.processRegionsMetaCleanup(this::reportTablesExtraRegions, this::deleteAllRegions, nameSpaceOrTable);
        }
        return null;
    }

    private List<String> deleteAllRegions(List<RegionInfo> regions) throws IOException {
        ArrayList<String> resulting = new ArrayList<String>();
        for (RegionInfo r : regions) {
            HBCKMetaTableAccessor.deleteRegionInfo(this.conn, r);
            resulting.add(r.getEncodedName());
        }
        return resulting;
    }

    @Override
    public void close() throws IOException {
        this.conn.close();
    }

    public class ListUtils<T1, T2> {
        public List<T1> complement(List<T1> list1, List<T2> list2, Function<T1, String> convertT1, Function<T2, String> convertT2) {
            ArrayList extraRegions = new ArrayList();
            HashSet baseSet = list2.stream().map(info -> (String)convertT2.apply(info)).collect(Collectors.toCollection(HashSet::new));
            list1.forEach(region -> {
                if (!baseSet.contains(convertT1.apply(region))) {
                    extraRegions.add(region);
                }
            });
            return extraRegions;
        }
    }

    @FunctionalInterface
    static interface ExecFunction<T, NamespaceOrTable> {
        public T execute(NamespaceOrTable var1) throws IOException;
    }

    @FunctionalInterface
    static interface CheckingFunction<RegionsList, DirList, T> {
        public List<T> check(RegionsList var1, DirList var2) throws IOException;
    }

    private class InternalMetaChecker<T> {
        private InternalMetaChecker() {
        }

        List<T> checkRegionsInMETA(String table, CheckingFunction<List<RegionInfo>, List<Path>, T> checkingFunction) throws IOException {
            List regionsDirs = FsRegionsMetaRecoverer.this.getTableRegionsDirs(table);
            TableName tableName = TableName.valueOf((String)table);
            List<RegionInfo> regions = HBCKMetaTableAccessor.getTableRegions(FsRegionsMetaRecoverer.this.conn, tableName);
            return checkingFunction.check(regions, regionsDirs);
        }

        Map<TableName, List<T>> reportTablesRegions(List<String> namespacesOrTables, ExecFunction<List<T>, String> checkingFunction) throws IOException {
            HashMap result = new HashMap();
            List tableNames = HBCKMetaTableAccessor.getTables(FsRegionsMetaRecoverer.this.conn).stream().filter(tableName -> {
                if (namespacesOrTables == null || namespacesOrTables.isEmpty()) {
                    return true;
                }
                Optional<String> findings = namespacesOrTables.stream().filter(name -> name.indexOf(":") > 0 ? tableName.equals((Object)TableName.valueOf((String)name)) : tableName.getNamespaceAsString().equals(name)).findFirst();
                return findings.isPresent();
            }).collect(Collectors.toList());
            tableNames.stream().forEach(tableName -> {
                try {
                    result.put((TableName)tableName, (List)checkingFunction.execute(tableName.getNameWithNamespaceInclAsString()));
                }
                catch (Exception e) {
                    LOG.warn("Can't get related regions report from meta", e);
                }
            });
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<Future<List<String>>> processRegionsMetaCleanup(ExecFunction<Map<TableName, List<T>>, List<String>> reportFunction, final ExecFunction<List<String>, List<T>> execFunction, List<String> nameSpaceOrTable) throws IOException {
            ExecutorService executorService = Executors.newFixedThreadPool(nameSpaceOrTable == null || nameSpaceOrTable.size() > Runtime.getRuntime().availableProcessors() ? Runtime.getRuntime().availableProcessors() : nameSpaceOrTable.size());
            ArrayList<Future<List<String>>> futures = new ArrayList<Future<List<String>>>(nameSpaceOrTable == null ? 1 : nameSpaceOrTable.size());
            try (Admin admin = FsRegionsMetaRecoverer.this.conn.getAdmin();){
                boolean allDone;
                final Map<TableName, List<T>> report = reportFunction.execute(nameSpaceOrTable);
                if (report.size() < 1) {
                    LOG.info("\nNo mismatches found in meta. Worth using related reporting function first.\nYou are likely passing non-existent namespace or table. Note that table names should include the namespace portion even for tables in the default namespace. See also the command usage.\n");
                }
                for (final TableName tableName : report.keySet()) {
                    if (admin.tableExists(tableName)) {
                        futures.add(executorService.submit(new Callable<List<String>>(){

                            @Override
                            public List<String> call() throws Exception {
                                LOG.debug("running thread for {}", (Object)tableName.getNameWithNamespaceInclAsString());
                                return (List)execFunction.execute(report.get(tableName));
                            }
                        }));
                        continue;
                    }
                    LOG.warn("Table {} does not exist! Skipping...", (Object)tableName.getNameWithNamespaceInclAsString());
                }
                do {
                    allDone = true;
                    for (Future future : futures) {
                        allDone &= future.isDone();
                    }
                } while (!allDone);
            }
            finally {
                executorService.shutdown();
            }
            return futures;
        }
    }
}

