/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseZKTestingUtility;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ZKTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ZKTests.class, MediumTests.class})
public class TestRecoverableZooKeeper {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRecoverableZooKeeper.class);
    private static final HBaseZKTestingUtility TEST_UTIL = new HBaseZKTestingUtility();
    private Abortable abortable = new Abortable(){

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }
    };

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testSetDataVersionMismatchInLoop() throws Exception {
        String znode = "/hbase/splitWAL/9af7cfc9b15910a0b3d714bf40a3248f";
        Configuration conf = TEST_UTIL.getConfiguration();
        ZKWatcher zkw = new ZKWatcher(conf, "testSetDataVersionMismatchInLoop", this.abortable, true);
        String ensemble = ZKConfig.getZKQuorumServersString((Configuration)conf);
        RecoverableZooKeeper rzk = RecoverableZooKeeper.connect((Configuration)conf, (String)ensemble, (Watcher)zkw);
        rzk.create(znode, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        rzk.setData(znode, "OPENING".getBytes(), 0);
        Field zkField = RecoverableZooKeeper.class.getDeclaredField("zk");
        zkField.setAccessible(true);
        int timeout = conf.getInt("zookeeper.session.timeout", 90000);
        ZookeeperStub zkStub = new ZookeeperStub(ensemble, timeout, (Watcher)zkw);
        zkStub.setThrowExceptionInNumOperations(1);
        zkField.set(rzk, (Object)zkStub);
        byte[] opened = "OPENED".getBytes();
        rzk.setData(znode, opened, 1);
        byte[] data = rzk.getData(znode, false, new Stat());
        Assert.assertTrue((boolean)Bytes.equals((byte[])opened, (byte[])data));
    }

    static class ZookeeperStub
    extends ZooKeeper {
        private int throwExceptionInNumOperations;

        ZookeeperStub(String connectString, int sessionTimeout, Watcher watcher) throws IOException {
            super(connectString, sessionTimeout, watcher);
        }

        void setThrowExceptionInNumOperations(int throwExceptionInNumOperations) {
            this.throwExceptionInNumOperations = throwExceptionInNumOperations;
        }

        private void checkThrowKeeperException() throws KeeperException {
            if (this.throwExceptionInNumOperations == 1) {
                this.throwExceptionInNumOperations = 0;
                throw new KeeperException.ConnectionLossException();
            }
            if (this.throwExceptionInNumOperations > 0) {
                --this.throwExceptionInNumOperations;
            }
        }

        public Stat setData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
            Stat stat = super.setData(path, data, version);
            this.checkThrowKeeperException();
            return stat;
        }
    }
}

