/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ZKAclReset
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(ZKAclReset.class);

    private static void resetAcls(ZKWatcher zkw, String znode, boolean eraseAcls) throws Exception {
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, znode);
        if (children != null) {
            for (String child : children) {
                ZKAclReset.resetAcls(zkw, ZNodePaths.joinZNode((String)znode, (String)child), eraseAcls);
            }
        }
        ZooKeeper zk = zkw.getRecoverableZooKeeper().getZooKeeper();
        if (eraseAcls) {
            LOG.info(" - erase ACLs for " + znode);
            zk.setACL(znode, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, -1);
        } else {
            LOG.info(" - set ACLs for " + znode);
            zk.setACL(znode, ZKUtil.createACL(zkw, znode, true), -1);
        }
    }

    private static void resetAcls(Configuration conf, boolean eraseAcls) throws Exception {
        try (ZKWatcher zkw = new ZKWatcher(conf, "ZKAclReset", null);){
            LOG.info((eraseAcls ? "Erase" : "Set") + " HBase ACLs for " + zkw.getQuorum() + " " + zkw.znodePaths.baseZNode);
            ZKAclReset.resetAcls(zkw, zkw.znodePaths.baseZNode, eraseAcls);
        }
    }

    private void printUsageAndExit() {
        System.err.printf("Usage: hbase %s [options]%n", ((Object)((Object)this)).getClass().getName());
        System.err.println(" where [options] are:");
        System.err.println("  -h|-help                Show this help and exit.");
        System.err.println("  -set-acls               Setup the hbase znode ACLs for a secure cluster");
        System.err.println();
        System.err.println("Examples:");
        System.err.println("  To reset the ACLs to the unsecure cluster behavior:");
        System.err.println("  hbase " + ((Object)((Object)this)).getClass().getName());
        System.err.println();
        System.err.println("  To reset the ACLs to the secure cluster behavior:");
        System.err.println("  hbase " + ((Object)((Object)this)).getClass().getName() + " -set-acls");
        System.exit(1);
    }

    public int run(String[] args) throws Exception {
        boolean eraseAcls = true;
        String[] stringArray = args;
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String arg;
            switch (arg = stringArray[i]) {
                case "-help": {
                    this.printUsageAndExit();
                    continue block8;
                }
                case "-set-acls": {
                    eraseAcls = false;
                    continue block8;
                }
                default: {
                    this.printUsageAndExit();
                }
            }
        }
        ZKAclReset.resetAcls(this.getConf(), eraseAcls);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new ZKAclReset(), (String[])args));
    }
}

