/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.testclassification.ZKTests;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={ZKTests.class, SmallTests.class})
public class TestZKUtilNoServer {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZKUtilNoServer.class);

    @Test
    public void testUnsecure() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.superuser", "user1");
        String node = "/hbase/testUnsecure";
        ZKWatcher watcher = new ZKWatcher(conf, node, null, false);
        ArrayList aclList = ZKUtil.createACL((ZKWatcher)watcher, (String)node, (boolean)false);
        Assert.assertEquals((long)1L, (long)aclList.size());
        Assert.assertTrue((boolean)aclList.contains(ZooDefs.Ids.OPEN_ACL_UNSAFE.iterator().next()));
    }

    @Test
    public void testSecuritySingleSuperuser() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.superuser", "user1");
        String node = "/hbase/testSecuritySingleSuperuser";
        ZKWatcher watcher = new ZKWatcher(conf, node, null, false);
        ArrayList aclList = ZKUtil.createACL((ZKWatcher)watcher, (String)node, (boolean)true);
        Assert.assertEquals((long)2L, (long)aclList.size());
        Assert.assertTrue((boolean)aclList.contains(new ACL(31, new Id("sasl", "user1"))));
        Assert.assertTrue((boolean)aclList.contains(ZooDefs.Ids.CREATOR_ALL_ACL.iterator().next()));
    }

    @Test
    public void testCreateACL() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.superuser", "user1,@group1,user2,@group2,user3");
        String node = "/hbase/testCreateACL";
        ZKWatcher watcher = new ZKWatcher(conf, node, null, false);
        ArrayList aclList = ZKUtil.createACL((ZKWatcher)watcher, (String)node, (boolean)true);
        Assert.assertEquals((long)4L, (long)aclList.size());
        Assert.assertFalse((boolean)aclList.contains(new ACL(31, new Id("sasl", "@group1"))));
        Assert.assertFalse((boolean)aclList.contains(new ACL(31, new Id("sasl", "@group2"))));
        Assert.assertTrue((boolean)aclList.contains(new ACL(31, new Id("sasl", "user1"))));
        Assert.assertTrue((boolean)aclList.contains(new ACL(31, new Id("sasl", "user2"))));
        Assert.assertTrue((boolean)aclList.contains(new ACL(31, new Id("sasl", "user3"))));
    }

    @Test
    public void testCreateACLWithSameUser() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.superuser", "user4,@group1,user5,user6");
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)"user4"));
        String node = "/hbase/testCreateACL";
        ZKWatcher watcher = new ZKWatcher(conf, node, null, false);
        ArrayList aclList = ZKUtil.createACL((ZKWatcher)watcher, (String)node, (boolean)true);
        Assert.assertEquals((long)3L, (long)aclList.size());
        Assert.assertFalse((boolean)aclList.contains(new ACL(31, new Id("sasl", "@group1"))));
        Assert.assertTrue((boolean)aclList.contains(new ACL(31, new Id("auth", ""))));
        Assert.assertTrue((boolean)aclList.contains(new ACL(31, new Id("sasl", "user5"))));
        Assert.assertTrue((boolean)aclList.contains(new ACL(31, new Id("sasl", "user6"))));
    }

    @Test(expected=KeeperException.SystemErrorException.class)
    public void testInterruptedDuringAction() throws IOException, KeeperException, InterruptedException {
        final RecoverableZooKeeper recoverableZk = (RecoverableZooKeeper)Mockito.mock(RecoverableZooKeeper.class);
        ZKWatcher zkw = new ZKWatcher(HBaseConfiguration.create(), "unittest", null){

            public RecoverableZooKeeper getRecoverableZooKeeper() {
                return recoverableZk;
            }
        };
        ((RecoverableZooKeeper)Mockito.doThrow((Throwable[])new Throwable[]{new InterruptedException()}).when((Object)recoverableZk)).getChildren(zkw.znodePaths.baseZNode, null);
        ZKUtil.listChildrenNoWatch((ZKWatcher)zkw, (String)zkw.znodePaths.baseZNode);
    }
}

