/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseZKTestingUtility;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ZKTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.ZooDefs;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ZKTests.class, MediumTests.class})
public class TestZKMulti {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZKMulti.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestZKMulti.class);
    private static final HBaseZKTestingUtility TEST_UTIL = new HBaseZKTestingUtility();
    private static ZKWatcher zkw = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        Configuration conf = TEST_UTIL.getConfiguration();
        Abortable abortable = new Abortable(){

            public void abort(String why, Throwable e) {
                LOG.info(why, e);
            }

            public boolean isAborted() {
                return false;
            }
        };
        zkw = new ZKWatcher(conf, "TestZKMulti", abortable, true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testSimpleMulti() throws Exception {
        ZKUtil.multiOrSequential((ZKWatcher)zkw, null, (boolean)false);
        ZKUtil.multiOrSequential((ZKWatcher)zkw, new LinkedList(), (boolean)false);
        String path = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"testSimpleMulti");
        LinkedList<ZKUtil.ZKUtilOp> singleCreate = new LinkedList<ZKUtil.ZKUtilOp>();
        singleCreate.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path, (byte[])new byte[0]));
        ZKUtil.multiOrSequential((ZKWatcher)zkw, singleCreate, (boolean)false);
        Assert.assertTrue((ZKUtil.checkExists((ZKWatcher)zkw, (String)path) != -1 ? 1 : 0) != 0);
        LinkedList<ZKUtil.ZKUtilOp> singleSetData = new LinkedList<ZKUtil.ZKUtilOp>();
        byte[] data = Bytes.toBytes((String)"foobar");
        singleSetData.add(ZKUtil.ZKUtilOp.setData((String)path, (byte[])data));
        ZKUtil.multiOrSequential((ZKWatcher)zkw, singleSetData, (boolean)false);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZKWatcher)zkw, (String)path), (byte[])data));
        LinkedList<ZKUtil.ZKUtilOp> singleDelete = new LinkedList<ZKUtil.ZKUtilOp>();
        singleDelete.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)path));
        ZKUtil.multiOrSequential((ZKWatcher)zkw, singleDelete, (boolean)false);
        Assert.assertTrue((ZKUtil.checkExists((ZKWatcher)zkw, (String)path) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testComplexMulti() throws Exception {
        String path1 = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"testComplexMulti1");
        String path2 = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"testComplexMulti2");
        String path3 = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"testComplexMulti3");
        String path4 = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"testComplexMulti4");
        String path5 = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"testComplexMulti5");
        String path6 = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"testComplexMulti6");
        LinkedList<ZKUtil.ZKUtilOp> create4Nodes = new LinkedList<ZKUtil.ZKUtilOp>();
        create4Nodes.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path1, (byte[])Bytes.toBytes((String)path1)));
        create4Nodes.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path2, (byte[])Bytes.toBytes((String)path2)));
        create4Nodes.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path3, (byte[])Bytes.toBytes((String)path3)));
        create4Nodes.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path4, (byte[])Bytes.toBytes((String)path4)));
        ZKUtil.multiOrSequential((ZKWatcher)zkw, create4Nodes, (boolean)false);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZKWatcher)zkw, (String)path1), (byte[])Bytes.toBytes((String)path1)));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZKWatcher)zkw, (String)path2), (byte[])Bytes.toBytes((String)path2)));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZKWatcher)zkw, (String)path3), (byte[])Bytes.toBytes((String)path3)));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZKWatcher)zkw, (String)path4), (byte[])Bytes.toBytes((String)path4)));
        LinkedList<ZKUtil.ZKUtilOp> ops = new LinkedList<ZKUtil.ZKUtilOp>();
        ops.add(ZKUtil.ZKUtilOp.setData((String)path1, (byte[])Bytes.add((byte[])Bytes.toBytes((String)path1), (byte[])Bytes.toBytes((String)path1))));
        ops.add(ZKUtil.ZKUtilOp.setData((String)path2, (byte[])Bytes.add((byte[])Bytes.toBytes((String)path2), (byte[])Bytes.toBytes((String)path2))));
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)path3));
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)path4));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path5, (byte[])Bytes.toBytes((String)path5)));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path6, (byte[])Bytes.toBytes((String)path6)));
        ZKUtil.multiOrSequential((ZKWatcher)zkw, ops, (boolean)false);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZKWatcher)zkw, (String)path1), (byte[])Bytes.add((byte[])Bytes.toBytes((String)path1), (byte[])Bytes.toBytes((String)path1))));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZKWatcher)zkw, (String)path2), (byte[])Bytes.add((byte[])Bytes.toBytes((String)path2), (byte[])Bytes.toBytes((String)path2))));
        Assert.assertTrue((ZKUtil.checkExists((ZKWatcher)zkw, (String)path3) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZKWatcher)zkw, (String)path4) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZKWatcher)zkw, (String)path5), (byte[])Bytes.toBytes((String)path5)));
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZKWatcher)zkw, (String)path6), (byte[])Bytes.toBytes((String)path6)));
    }

    @Test
    public void testSingleFailure() throws Exception {
        boolean caughtNoNode = false;
        String path = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"testSingleFailureZ");
        LinkedList<ZKUtil.ZKUtilOp> ops = new LinkedList<ZKUtil.ZKUtilOp>();
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)path));
        try {
            ZKUtil.multiOrSequential((ZKWatcher)zkw, ops, (boolean)false);
        }
        catch (KeeperException.NoNodeException nne) {
            caughtNoNode = true;
        }
        Assert.assertTrue((boolean)caughtNoNode);
        caughtNoNode = false;
        ops = new LinkedList();
        ops.add(ZKUtil.ZKUtilOp.setData((String)path, (byte[])Bytes.toBytes((String)path)));
        try {
            ZKUtil.multiOrSequential((ZKWatcher)zkw, ops, (boolean)false);
        }
        catch (KeeperException.NoNodeException nne) {
            caughtNoNode = true;
        }
        Assert.assertTrue((boolean)caughtNoNode);
        boolean caughtNodeExists = false;
        ops = new LinkedList();
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path, (byte[])Bytes.toBytes((String)path)));
        ZKUtil.multiOrSequential((ZKWatcher)zkw, ops, (boolean)false);
        try {
            ZKUtil.multiOrSequential((ZKWatcher)zkw, ops, (boolean)false);
        }
        catch (KeeperException.NodeExistsException nee) {
            caughtNodeExists = true;
        }
        Assert.assertTrue((boolean)caughtNodeExists);
    }

    @Test
    public void testSingleFailureInMulti() throws Exception {
        String pathA = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"testSingleFailureInMultiA");
        String pathB = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"testSingleFailureInMultiB");
        String pathC = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"testSingleFailureInMultiC");
        LinkedList<ZKUtil.ZKUtilOp> ops = new LinkedList<ZKUtil.ZKUtilOp>();
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)pathA, (byte[])Bytes.toBytes((String)pathA)));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)pathB, (byte[])Bytes.toBytes((String)pathB)));
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)pathC));
        boolean caughtNoNode = false;
        try {
            ZKUtil.multiOrSequential((ZKWatcher)zkw, ops, (boolean)false);
        }
        catch (KeeperException.NoNodeException nne) {
            caughtNoNode = true;
        }
        Assert.assertTrue((boolean)caughtNoNode);
        Assert.assertTrue((ZKUtil.checkExists((ZKWatcher)zkw, (String)pathA) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZKWatcher)zkw, (String)pathB) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZKWatcher)zkw, (String)pathC) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testMultiFailure() throws Exception {
        String pathX = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"testMultiFailureX");
        String pathY = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"testMultiFailureY");
        String pathZ = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"testMultiFailureZ");
        LinkedList<ZKUtil.ZKUtilOp> ops = new LinkedList<ZKUtil.ZKUtilOp>();
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)pathX, (byte[])Bytes.toBytes((String)pathX)));
        ZKUtil.multiOrSequential((ZKWatcher)zkw, ops, (boolean)false);
        String pathV = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"testMultiFailureV");
        String pathW = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"testMultiFailureW");
        ops = new LinkedList();
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)pathX, (byte[])Bytes.toBytes((String)pathX)));
        ops.add(ZKUtil.ZKUtilOp.setData((String)pathY, (byte[])Bytes.toBytes((String)pathY)));
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)pathZ));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)pathX, (byte[])Bytes.toBytes((String)pathV)));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)pathX, (byte[])Bytes.toBytes((String)pathW)));
        boolean caughtNodeExists = false;
        try {
            ZKUtil.multiOrSequential((ZKWatcher)zkw, ops, (boolean)false);
        }
        catch (KeeperException.NodeExistsException nee) {
            caughtNodeExists = true;
        }
        Assert.assertTrue((boolean)caughtNodeExists);
        Assert.assertFalse((ZKUtil.checkExists((ZKWatcher)zkw, (String)pathX) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZKWatcher)zkw, (String)pathY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZKWatcher)zkw, (String)pathZ) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZKWatcher)zkw, (String)pathW) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZKWatcher)zkw, (String)pathV) == -1 ? 1 : 0) != 0);
        ops = new LinkedList();
        ops.add(ZKUtil.ZKUtilOp.setData((String)pathY, (byte[])Bytes.toBytes((String)pathY)));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)pathX, (byte[])Bytes.toBytes((String)pathX)));
        boolean caughtNoNode = false;
        try {
            ZKUtil.multiOrSequential((ZKWatcher)zkw, ops, (boolean)false);
        }
        catch (KeeperException.NoNodeException nne) {
            caughtNoNode = true;
        }
        Assert.assertTrue((boolean)caughtNoNode);
        Assert.assertFalse((ZKUtil.checkExists((ZKWatcher)zkw, (String)pathX) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZKWatcher)zkw, (String)pathY) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZKWatcher)zkw, (String)pathZ) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZKWatcher)zkw, (String)pathW) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZKWatcher)zkw, (String)pathV) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testRunSequentialOnMultiFailure() throws Exception {
        String path1 = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"runSequential1");
        String path2 = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"runSequential2");
        String path3 = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"runSequential3");
        String path4 = ZNodePaths.joinZNode((String)TestZKMulti.zkw.znodePaths.baseZNode, (String)"runSequential4");
        LinkedList<ZKUtil.ZKUtilOp> ops = new LinkedList<ZKUtil.ZKUtilOp>();
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path1, (byte[])Bytes.toBytes((String)path1)));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path2, (byte[])Bytes.toBytes((String)path2)));
        ZKUtil.multiOrSequential((ZKWatcher)zkw, ops, (boolean)false);
        ops = new LinkedList();
        ops.add(ZKUtil.ZKUtilOp.setData((String)path1, (byte[])Bytes.add((byte[])Bytes.toBytes((String)path1), (byte[])Bytes.toBytes((String)path1))));
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)path2));
        ops.add(ZKUtil.ZKUtilOp.deleteNodeFailSilent((String)path3));
        ops.add(ZKUtil.ZKUtilOp.createAndFailSilent((String)path4, (byte[])Bytes.add((byte[])Bytes.toBytes((String)path4), (byte[])Bytes.toBytes((String)path4))));
        ZKUtil.multiOrSequential((ZKWatcher)zkw, ops, (boolean)true);
        Assert.assertTrue((boolean)Bytes.equals((byte[])ZKUtil.getData((ZKWatcher)zkw, (String)path1), (byte[])Bytes.add((byte[])Bytes.toBytes((String)path1), (byte[])Bytes.toBytes((String)path1))));
        Assert.assertTrue((ZKUtil.checkExists((ZKWatcher)zkw, (String)path2) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((ZKUtil.checkExists((ZKWatcher)zkw, (String)path3) == -1 ? 1 : 0) != 0);
        Assert.assertFalse((ZKUtil.checkExists((ZKWatcher)zkw, (String)path4) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testdeleteChildrenRecursivelyMulti() throws Exception {
        String parentZNode = "/testRootMulti";
        this.createZNodeTree(parentZNode);
        ZKUtil.deleteChildrenRecursivelyMultiOrSequential((ZKWatcher)zkw, (boolean)true, (String[])new String[]{parentZNode});
        Assert.assertTrue((String)"Wrongly deleted parent znode!", (ZKUtil.checkExists((ZKWatcher)zkw, (String)parentZNode) > -1 ? 1 : 0) != 0);
        List children = zkw.getRecoverableZooKeeper().getChildren(parentZNode, false);
        Assert.assertTrue((String)"Failed to delete child znodes!", (0 == children.size() ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteNodeRecursivelyMulti() throws Exception {
        String parentZNode = "/testdeleteNodeRecursivelyMulti";
        this.createZNodeTree(parentZNode);
        ZKUtil.deleteNodeRecursively((ZKWatcher)zkw, (String)parentZNode);
        Assert.assertTrue((String)"Parent znode should be deleted.", (ZKUtil.checkExists((ZKWatcher)zkw, (String)parentZNode) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteNodeRecursivelyMultiOrSequential() throws Exception {
        String parentZNode1 = "/testdeleteNode1";
        String parentZNode2 = "/testdeleteNode2";
        String parentZNode3 = "/testdeleteNode3";
        this.createZNodeTree(parentZNode1);
        this.createZNodeTree(parentZNode2);
        this.createZNodeTree(parentZNode3);
        ZKUtil.deleteNodeRecursivelyMultiOrSequential((ZKWatcher)zkw, (boolean)false, (String[])new String[]{parentZNode1, parentZNode2, parentZNode3});
        Assert.assertTrue((String)"Parent znode 1 should be deleted.", (ZKUtil.checkExists((ZKWatcher)zkw, (String)parentZNode1) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Parent znode 2 should be deleted.", (ZKUtil.checkExists((ZKWatcher)zkw, (String)parentZNode2) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Parent znode 3 should be deleted.", (ZKUtil.checkExists((ZKWatcher)zkw, (String)parentZNode3) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteChildrenRecursivelyMultiOrSequential() throws Exception {
        String parentZNode1 = "/testdeleteChildren1";
        String parentZNode2 = "/testdeleteChildren2";
        String parentZNode3 = "/testdeleteChildren3";
        this.createZNodeTree(parentZNode1);
        this.createZNodeTree(parentZNode2);
        this.createZNodeTree(parentZNode3);
        ZKUtil.deleteChildrenRecursivelyMultiOrSequential((ZKWatcher)zkw, (boolean)true, (String[])new String[]{parentZNode1, parentZNode2, parentZNode3});
        Assert.assertTrue((String)"Wrongly deleted parent znode 1!", (ZKUtil.checkExists((ZKWatcher)zkw, (String)parentZNode1) > -1 ? 1 : 0) != 0);
        List children = zkw.getRecoverableZooKeeper().getChildren(parentZNode1, false);
        Assert.assertTrue((String)"Failed to delete child znodes of parent znode 1!", (0 == children.size() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Wrongly deleted parent znode 2!", (ZKUtil.checkExists((ZKWatcher)zkw, (String)parentZNode2) > -1 ? 1 : 0) != 0);
        children = zkw.getRecoverableZooKeeper().getChildren(parentZNode2, false);
        Assert.assertTrue((String)"Failed to delete child znodes of parent znode 1!", (0 == children.size() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Wrongly deleted parent znode 3!", (ZKUtil.checkExists((ZKWatcher)zkw, (String)parentZNode3) > -1 ? 1 : 0) != 0);
        children = zkw.getRecoverableZooKeeper().getChildren(parentZNode3, false);
        Assert.assertTrue((String)"Failed to delete child znodes of parent znode 1!", (0 == children.size() ? 1 : 0) != 0);
    }

    private void createZNodeTree(String rootZNode) throws KeeperException, InterruptedException {
        ArrayList<Op> opList = new ArrayList<Op>();
        opList.add(Op.create((String)rootZNode, (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
        String parentZNode = rootZNode;
        for (int level = 0; level < 10; ++level) {
            parentZNode = parentZNode + "/" + level;
            opList.add(Op.create((String)parentZNode, (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
            for (int elements = 0; elements < level; ++elements) {
                opList.add(Op.create((String)(parentZNode + "/" + elements), (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
            }
        }
        zkw.getRecoverableZooKeeper().multi(opList);
    }
}

