/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Exchanger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseZKTestingUtility;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ZKTests;
import org.apache.hadoop.hbase.zookeeper.ReadOnlyZKClient;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperHelper;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={ZKTests.class, MediumTests.class})
public class TestReadOnlyZKClient {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReadOnlyZKClient.class);
    private static HBaseZKTestingUtility UTIL = new HBaseZKTestingUtility();
    private static String PATH = "/test";
    private static byte[] DATA;
    private static int CHILDREN;
    private static ReadOnlyZKClient RO_ZK;

    @BeforeClass
    public static void setUp() throws Exception {
        int port = UTIL.startMiniZKCluster().getClientPort();
        ZooKeeper zk = ZooKeeperHelper.getConnectedZooKeeper((String)("localhost:" + port), (int)10000);
        DATA = new byte[10];
        ThreadLocalRandom.current().nextBytes(DATA);
        zk.create(PATH, DATA, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        for (int i = 0; i < CHILDREN; ++i) {
            zk.create(PATH + "/c" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.close();
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.zookeeper.quorum", "localhost:" + port);
        conf.setInt("zookeeper.recovery.retry", 3);
        conf.setInt("zookeeper.recovery.retry.intervalmill", 100);
        conf.setInt("zookeeper.keep-alive.time", 3000);
        RO_ZK = new ReadOnlyZKClient(conf);
        Assert.assertNull((Object)TestReadOnlyZKClient.RO_ZK.zookeeper);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        RO_ZK.close();
        UTIL.shutdownMiniZKCluster();
        UTIL.cleanupTestDir();
    }

    private void waitForIdleConnectionClosed() throws Exception {
        UTIL.waitFor(10000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() {
                return RO_ZK.zookeeper == null;
            }

            public String explainFailure() {
                return "Connection to zookeeper is still alive";
            }
        });
    }

    @Test
    public void testRead() throws Exception {
        Assert.assertArrayEquals((byte[])DATA, (byte[])((byte[])RO_ZK.get(PATH).get()));
        Assert.assertEquals((long)CHILDREN, (long)((Stat)RO_ZK.exists(PATH).get()).getNumChildren());
        List children = (List)RO_ZK.list(PATH).get();
        Assert.assertEquals((long)CHILDREN, (long)children.size());
        Collections.sort(children);
        for (int i = 0; i < CHILDREN; ++i) {
            Assert.assertEquals((Object)("c" + i), children.get(i));
        }
        Assert.assertNotNull((Object)TestReadOnlyZKClient.RO_ZK.zookeeper);
        this.waitForIdleConnectionClosed();
    }

    @Test
    public void testNoNode() throws InterruptedException, ExecutionException {
        KeeperException ke;
        String pathNotExists = PATH + "_whatever";
        try {
            RO_ZK.get(pathNotExists).get();
            Assert.fail((String)("should fail because of " + pathNotExists + " does not exist"));
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(KeeperException.class));
            ke = (KeeperException)e.getCause();
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)ke.code());
            Assert.assertEquals((Object)pathNotExists, (Object)ke.getPath());
        }
        try {
            RO_ZK.list(pathNotExists).get();
            Assert.fail((String)("should fail because of " + pathNotExists + " does not exist"));
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(KeeperException.class));
            ke = (KeeperException)e.getCause();
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)ke.code());
            Assert.assertEquals((Object)pathNotExists, (Object)ke.getPath());
        }
        Assert.assertNull(RO_ZK.exists(pathNotExists).get());
    }

    @Test
    public void testSessionExpire() throws Exception {
        Assert.assertArrayEquals((byte[])DATA, (byte[])((byte[])RO_ZK.get(PATH).get()));
        ZooKeeper zk = TestReadOnlyZKClient.RO_ZK.zookeeper;
        long sessionId = zk.getSessionId();
        ((ZooKeeperServer)UTIL.getZkCluster().getZooKeeperServers().get(0)).closeSession(sessionId);
        Assert.assertSame((Object)zk, (Object)TestReadOnlyZKClient.RO_ZK.zookeeper);
        byte[] got = (byte[])RO_ZK.get(PATH).get();
        Assert.assertArrayEquals((byte[])DATA, (byte[])got);
        Assert.assertNotNull((Object)TestReadOnlyZKClient.RO_ZK.zookeeper);
        Assert.assertNotSame((Object)zk, (Object)TestReadOnlyZKClient.RO_ZK.zookeeper);
        Assert.assertNotEquals((long)sessionId, (long)TestReadOnlyZKClient.RO_ZK.zookeeper.getSessionId());
    }

    @Test
    public void testNotCloseZkWhenPending() throws Exception {
        ZooKeeper mockedZK = (ZooKeeper)Mockito.mock(ZooKeeper.class);
        Exchanger<Object> exchanger = new Exchanger<Object>();
        ((ZooKeeper)Mockito.doAnswer(i -> {
            exchanger.exchange(i.getArgument(2));
            return null;
        }).when((Object)mockedZK)).getData(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), (AsyncCallback.DataCallback)ArgumentMatchers.any(AsyncCallback.DataCallback.class), ArgumentMatchers.any());
        ((ZooKeeper)Mockito.doAnswer(i -> null).when((Object)mockedZK)).close();
        Mockito.when((Object)mockedZK.getState()).thenReturn((Object)ZooKeeper.States.CONNECTED);
        TestReadOnlyZKClient.RO_ZK.zookeeper = mockedZK;
        CompletableFuture future = RO_ZK.get(PATH);
        AsyncCallback.DataCallback callback = exchanger.exchange(null);
        Thread.sleep(6000L);
        Assert.assertNotNull((Object)TestReadOnlyZKClient.RO_ZK.zookeeper);
        ((ZooKeeper)Mockito.verify((Object)mockedZK, (VerificationMode)Mockito.never())).close();
        callback.processResult(KeeperException.Code.OK.intValue(), PATH, null, DATA, null);
        Assert.assertArrayEquals((byte[])DATA, (byte[])((byte[])future.get()));
        this.waitForIdleConnectionClosed();
        ((ZooKeeper)Mockito.verify((Object)mockedZK, (VerificationMode)Mockito.times((int)1))).close();
    }

    static {
        CHILDREN = 5;
    }
}

