/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.testing;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.testing.TestingHBaseCluster;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class TestingHBaseClusterReplicationTestBase {
    protected TestingHBaseCluster sourceCluster;
    protected TestingHBaseCluster peerCluster;
    private Connection sourceConn;
    private Connection peerConn;
    private TableName tableName = TableName.valueOf((String)"test_rep");
    private byte[] family = Bytes.toBytes((String)"family");
    private String peerId = "peer_id";

    private String getPeerClusterKey() {
        return ZKConfig.getZooKeeperClusterKey((Configuration)this.peerCluster.getConf());
    }

    @Before
    public void setUp() throws Exception {
        this.startClusters();
        this.sourceConn = ConnectionFactory.createConnection((Configuration)this.sourceCluster.getConf());
        this.peerConn = ConnectionFactory.createConnection((Configuration)this.peerCluster.getConf());
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)this.tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setScope(1).build()).build();
        try (Admin admin = this.sourceConn.getAdmin();){
            admin.createTable(desc);
            admin.addReplicationPeer(this.peerId, ReplicationPeerConfig.newBuilder().setClusterKey(this.getPeerClusterKey()).setReplicateAllUserTables(true).build());
        }
        admin = this.peerConn.getAdmin();
        var3_3 = null;
        try {
            admin.createTable(desc);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (admin != null) {
                if (var3_3 != null) {
                    try {
                        admin.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    admin.close();
                }
            }
        }
    }

    @After
    public void tearDown() throws Exception {
        Closeables.close((Closeable)this.sourceConn, (boolean)true);
        Closeables.close((Closeable)this.peerConn, (boolean)true);
        if (this.sourceCluster != null) {
            this.sourceCluster.stop();
        }
        if (this.peerCluster != null) {
            this.peerCluster.stop();
        }
        this.stopClusters();
    }

    @Test
    public void testReplication() throws IOException {
        byte[] row = Bytes.toBytes((String)"row");
        byte[] qual = Bytes.toBytes((String)"qual");
        byte[] value = Bytes.toBytes((String)"value");
        try (Table sourceTable = this.sourceConn.getTable(this.tableName);
             Table peerTable = this.peerConn.getTable(this.tableName);){
            sourceTable.put(new Put(row).addColumn(this.family, qual, value));
            Waiter.waitFor((Configuration)this.sourceCluster.getConf(), (long)30000L, () -> peerTable.exists(new Get(row).addColumn(this.family, qual)));
            byte[] actual = peerTable.get(new Get(row)).getValue(this.family, qual);
            Assert.assertArrayEquals((byte[])value, (byte[])actual);
        }
    }

    protected abstract void startClusters() throws Exception;

    protected abstract void stopClusters() throws Exception;
}

