/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.testing;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testing.TestingHBaseCluster;
import org.apache.hadoop.hbase.testing.TestingHBaseClusterOption;
import org.apache.hadoop.hbase.testing.TestingHBaseClusterReplicationTestBase;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, LargeTests.class})
public class TestTestingHBaseClusterReplicationShareZkDfs
extends TestingHBaseClusterReplicationTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTestingHBaseClusterReplicationShareZkDfs.class);
    private HBaseTestingUtility util = new HBaseTestingUtility();

    @Override
    protected void startClusters() throws Exception {
        this.util.startMiniZKCluster();
        this.util.startMiniDFSCluster(1);
        String zkConnectString = this.util.getZkCluster().getAddress().toString();
        String dfsUri = this.util.getDFSCluster().getFileSystem().getUri().toString();
        this.sourceCluster = TestingHBaseCluster.create((TestingHBaseClusterOption)TestingHBaseClusterOption.builder().useExternalZooKeeper(zkConnectString).useExternalDfs(dfsUri).build());
        this.sourceCluster.start();
        this.peerCluster = TestingHBaseCluster.create((TestingHBaseClusterOption)TestingHBaseClusterOption.builder().useExternalZooKeeper(zkConnectString).useExternalDfs(dfsUri).build());
        this.peerCluster.start();
        Assert.assertNotEquals((Object)this.sourceCluster.getConf().get("zookeeper.znode.parent"), (Object)this.peerCluster.getConf().get("zookeeper.znode.parent"));
        Assert.assertNotEquals((Object)this.sourceCluster.getConf().get("hbase.rootdir"), (Object)this.peerCluster.getConf().get("hbase.rootdir"));
    }

    @Override
    protected void stopClusters() throws Exception {
        this.util.shutdownMiniDFSCluster();
        this.util.shutdownMiniZKCluster();
    }
}

