/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileWriterImpl;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.CellSink;
import org.apache.hadoop.hbase.regionserver.DefaultStoreEngine;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.ShipperListener;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.BloomContext;
import org.apache.hadoop.hbase.util.BloomFilterFactory;
import org.apache.hadoop.hbase.util.BloomFilterUtil;
import org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.RowBloomContext;
import org.apache.hadoop.hbase.util.RowColBloomContext;
import org.apache.hadoop.hbase.util.RowPrefixFixedLengthBloomContext;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.base.Strings;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.SetMultimap;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class StoreFileWriter
implements CellSink,
ShipperListener {
    private static final Logger LOG = LoggerFactory.getLogger((String)StoreFileWriter.class.getName());
    public static final String ENABLE_HISTORICAL_COMPACTION_FILES = "hbase.enable.historical.compaction.files";
    public static final boolean DEFAULT_ENABLE_HISTORICAL_COMPACTION_FILES = false;
    private static final Pattern dash = Pattern.compile("-");
    private SingleStoreFileWriter liveFileWriter;
    private SingleStoreFileWriter historicalFileWriter;
    private final FileSystem fs;
    private final Path historicalFilePath;
    private final Configuration conf;
    private final CacheConfig cacheConf;
    private final BloomType bloomType;
    private final long maxKeys;
    private final InetSocketAddress[] favoredNodes;
    private final HFileContext fileContext;
    private final boolean shouldDropCacheBehind;
    private final Supplier<Collection<HStoreFile>> compactedFilesSupplier;
    private final CellComparator comparator;
    private Cell lastCell;
    private Cell deleteFamily;
    private List<Cell> deleteFamilyVersionList = new ArrayList<Cell>();
    private Cell deleteColumn;
    private List<Cell> deleteColumnVersionList = new ArrayList<Cell>();
    private int livePutCellCount;
    private final int maxVersions;
    private final boolean newVersionBehavior;

    private StoreFileWriter(FileSystem fs, Path liveFilePath, Path historicalFilePath, Configuration conf, CacheConfig cacheConf, BloomType bloomType, long maxKeys, InetSocketAddress[] favoredNodes, HFileContext fileContext, boolean shouldDropCacheBehind, Supplier<Collection<HStoreFile>> compactedFilesSupplier, CellComparator comparator, int maxVersions, boolean newVersionBehavior) throws IOException {
        this.fs = fs;
        this.historicalFilePath = historicalFilePath;
        this.conf = conf;
        this.cacheConf = cacheConf;
        this.bloomType = bloomType;
        this.maxKeys = maxKeys;
        this.favoredNodes = favoredNodes;
        this.fileContext = fileContext;
        this.shouldDropCacheBehind = shouldDropCacheBehind;
        this.compactedFilesSupplier = compactedFilesSupplier;
        this.comparator = comparator;
        this.maxVersions = maxVersions;
        this.newVersionBehavior = newVersionBehavior;
        this.liveFileWriter = new SingleStoreFileWriter(fs, liveFilePath, conf, cacheConf, bloomType, maxKeys, favoredNodes, fileContext, shouldDropCacheBehind, compactedFilesSupplier);
    }

    public static boolean shouldEnableHistoricalCompactionFiles(Configuration conf) {
        if (conf.getBoolean(ENABLE_HISTORICAL_COMPACTION_FILES, false)) {
            String storeEngine = conf.get(StoreEngine.STORE_ENGINE_CLASS_KEY, DefaultStoreEngine.class.getName());
            if (!storeEngine.equals(DefaultStoreEngine.class.getName())) {
                LOG.warn("Historical compaction file generation is ignored for " + storeEngine + ". hbase.enable.historical.compaction.files can be set to true only for the default compaction (DefaultStoreEngine and DefaultCompactor)");
                return false;
            }
            String compactor = conf.get(DefaultStoreEngine.DEFAULT_COMPACTOR_CLASS_KEY, DefaultCompactor.class.getName());
            if (!compactor.equals(DefaultCompactor.class.getName())) {
                LOG.warn("Historical compaction file generation is ignored for " + compactor + ". hbase.enable.historical.compaction.files can be set to true only for the default compaction (DefaultStoreEngine and DefaultCompactor)");
                return false;
            }
            return true;
        }
        return false;
    }

    public long getPos() throws IOException {
        return this.liveFileWriter.getPos();
    }

    public void appendMetadata(long maxSequenceId, boolean majorCompaction) throws IOException {
        this.liveFileWriter.appendMetadata(maxSequenceId, majorCompaction);
        if (this.historicalFileWriter != null) {
            this.historicalFileWriter.appendMetadata(maxSequenceId, majorCompaction);
        }
    }

    public void appendMetadata(long maxSequenceId, boolean majorCompaction, Collection<HStoreFile> storeFiles) throws IOException {
        this.liveFileWriter.appendMetadata(maxSequenceId, majorCompaction, storeFiles);
        if (this.historicalFileWriter != null) {
            this.historicalFileWriter.appendMetadata(maxSequenceId, majorCompaction, storeFiles);
        }
    }

    public void appendMetadata(long maxSequenceId, boolean majorCompaction, long mobCellsCount) throws IOException {
        this.liveFileWriter.appendMetadata(maxSequenceId, majorCompaction, mobCellsCount);
        if (this.historicalFileWriter != null) {
            this.historicalFileWriter.appendMetadata(maxSequenceId, majorCompaction, mobCellsCount);
        }
    }

    public void appendMobMetadata(SetMultimap<TableName, String> mobRefSet) throws IOException {
        this.liveFileWriter.appendMobMetadata((SetMultimap<TableName, String>)mobRefSet);
        if (this.historicalFileWriter != null) {
            this.historicalFileWriter.appendMobMetadata((SetMultimap<TableName, String>)mobRefSet);
        }
    }

    public void appendTrackedTimestampsToMetadata() throws IOException {
        this.liveFileWriter.appendTrackedTimestampsToMetadata();
        if (this.historicalFileWriter != null) {
            this.historicalFileWriter.appendTrackedTimestampsToMetadata();
        }
    }

    @Override
    public void beforeShipped() throws IOException {
        this.liveFileWriter.beforeShipped();
        if (this.historicalFileWriter != null) {
            this.historicalFileWriter.beforeShipped();
        }
    }

    public Path getPath() {
        return this.liveFileWriter.getPath();
    }

    public List<Path> getPaths() {
        if (this.historicalFileWriter == null) {
            return Lists.newArrayList((Object[])new Path[]{this.liveFileWriter.getPath()});
        }
        return Lists.newArrayList((Object[])new Path[]{this.liveFileWriter.getPath(), this.historicalFileWriter.getPath()});
    }

    public boolean hasGeneralBloom() {
        return this.liveFileWriter.hasGeneralBloom();
    }

    BloomFilterWriter getGeneralBloomWriter() {
        return this.liveFileWriter.generalBloomFilterWriter;
    }

    public void close() throws IOException {
        this.liveFileWriter.appendFileInfo(HStoreFile.HISTORICAL_KEY, Bytes.toBytes((boolean)false));
        this.liveFileWriter.close();
        if (this.historicalFileWriter != null) {
            this.historicalFileWriter.appendFileInfo(HStoreFile.HISTORICAL_KEY, Bytes.toBytes((boolean)true));
            this.historicalFileWriter.close();
        }
    }

    public void appendFileInfo(byte[] key, byte[] value) throws IOException {
        this.liveFileWriter.appendFileInfo(key, value);
        if (this.historicalFileWriter != null) {
            this.historicalFileWriter.appendFileInfo(key, value);
        }
    }

    HFile.Writer getLiveFileWriter() {
        return this.liveFileWriter.getHFileWriter();
    }

    public static Path getUniqueFile(FileSystem fs, Path dir) throws IOException {
        if (!fs.getFileStatus(dir).isDirectory()) {
            throw new IOException("Expecting " + dir.toString() + " to be a directory");
        }
        return new Path(dir, dash.matcher(UUID.randomUUID().toString()).replaceAll(""));
    }

    private SingleStoreFileWriter getHistoricalFileWriter() throws IOException {
        if (this.historicalFileWriter == null) {
            this.historicalFileWriter = new SingleStoreFileWriter(this.fs, this.historicalFilePath, this.conf, this.cacheConf, this.bloomType, this.maxKeys, this.favoredNodes, this.fileContext, this.shouldDropCacheBehind, this.compactedFilesSupplier);
        }
        return this.historicalFileWriter;
    }

    private void initRowState() {
        this.deleteFamily = null;
        this.deleteFamilyVersionList.clear();
        this.lastCell = null;
    }

    private void initColumnState() {
        this.livePutCellCount = 0;
        this.deleteColumn = null;
        this.deleteColumnVersionList.clear();
    }

    private boolean isDeletedByDeleteFamily(Cell cell) {
        return this.deleteFamily != null && (this.deleteFamily.getTimestamp() > cell.getTimestamp() || this.deleteFamily.getTimestamp() == cell.getTimestamp() && (!this.newVersionBehavior || cell.getSequenceId() < this.deleteFamily.getSequenceId()));
    }

    private boolean isDeletedByDeleteFamilyVersion(Cell cell) {
        for (Cell deleteFamilyVersion : this.deleteFamilyVersionList) {
            if (deleteFamilyVersion.getTimestamp() != cell.getTimestamp() || this.newVersionBehavior && cell.getSequenceId() >= deleteFamilyVersion.getSequenceId()) continue;
            return true;
        }
        return false;
    }

    private boolean isDeletedByDeleteColumn(Cell cell) {
        return this.deleteColumn != null && (this.deleteColumn.getTimestamp() > cell.getTimestamp() || this.deleteColumn.getTimestamp() == cell.getTimestamp() && (!this.newVersionBehavior || cell.getSequenceId() < this.deleteColumn.getSequenceId()));
    }

    private boolean isDeletedByDeleteColumnVersion(Cell cell) {
        for (Cell deleteColumnVersion : this.deleteColumnVersionList) {
            if (deleteColumnVersion.getTimestamp() != cell.getTimestamp() || this.newVersionBehavior && cell.getSequenceId() >= deleteColumnVersion.getSequenceId()) continue;
            return true;
        }
        return false;
    }

    private boolean isDeleted(Cell cell) {
        return this.isDeletedByDeleteFamily(cell) || this.isDeletedByDeleteColumn(cell) || this.isDeletedByDeleteFamilyVersion(cell) || this.isDeletedByDeleteColumnVersion(cell);
    }

    private void appendCell(Cell cell) throws IOException {
        if (this.lastCell == null || !CellUtil.matchingColumn((Cell)this.lastCell, (Cell)cell)) {
            this.initColumnState();
        }
        if (cell.getType() == Cell.Type.DeleteFamily) {
            if (this.deleteFamily == null) {
                this.deleteFamily = cell;
                this.liveFileWriter.append(cell);
            } else {
                this.getHistoricalFileWriter().append(cell);
            }
        } else if (cell.getType() == Cell.Type.DeleteFamilyVersion) {
            if (!this.isDeletedByDeleteFamily(cell)) {
                this.deleteFamilyVersionList.add(cell);
                if (this.deleteFamily != null && this.deleteFamily.getTimestamp() == cell.getTimestamp()) {
                    this.liveFileWriter.append(cell);
                } else {
                    this.liveFileWriter.append(cell);
                }
            } else {
                this.getHistoricalFileWriter().append(cell);
            }
        } else if (cell.getType() == Cell.Type.DeleteColumn) {
            if (!this.isDeletedByDeleteFamily(cell) && this.deleteColumn == null) {
                this.deleteColumn = cell;
                this.liveFileWriter.append(cell);
            } else {
                this.getHistoricalFileWriter().append(cell);
            }
        } else if (cell.getType() == Cell.Type.Delete) {
            if (!this.isDeletedByDeleteFamily(cell) && this.deleteColumn == null) {
                this.deleteColumnVersionList.add(cell);
                if (this.deleteFamily != null && this.deleteFamily.getTimestamp() == cell.getTimestamp()) {
                    this.getHistoricalFileWriter().append(cell);
                } else {
                    this.liveFileWriter.append(cell);
                }
            } else {
                this.getHistoricalFileWriter().append(cell);
            }
        } else if (cell.getType() == Cell.Type.Put) {
            if (this.livePutCellCount < this.maxVersions) {
                if (!this.isDeleted(cell)) {
                    this.liveFileWriter.append(cell);
                    ++this.livePutCellCount;
                } else {
                    this.getHistoricalFileWriter().append(cell);
                    if (this.newVersionBehavior) {
                        ++this.livePutCellCount;
                    }
                }
            } else {
                this.getHistoricalFileWriter().append(cell);
            }
        }
        this.lastCell = cell;
    }

    @Override
    public void appendAll(List<Cell> cellList) throws IOException {
        if (this.historicalFilePath == null) {
            for (Cell cell : cellList) {
                this.liveFileWriter.append(cell);
            }
            return;
        }
        if (cellList.isEmpty()) {
            return;
        }
        if (this.lastCell != null && this.comparator.compareRows(this.lastCell, cellList.get(0)) != 0) {
            this.initRowState();
        }
        for (Cell cell : cellList) {
            this.appendCell(cell);
        }
    }

    @Override
    public void append(Cell cell) throws IOException {
        if (this.historicalFilePath == null) {
            this.liveFileWriter.append(cell);
            return;
        }
        this.appendCell(cell);
    }

    @SuppressWarnings(value={"ICAST_INTEGER_MULTIPLY_CAST_TO_LONG"}, justification="Will not overflow")
    public static class Builder {
        private final Configuration conf;
        private final CacheConfig cacheConf;
        private final FileSystem fs;
        private BloomType bloomType = BloomType.NONE;
        private long maxKeyCount = 0L;
        private Path dir;
        private Path liveFilePath;
        private Path historicalFilePath;
        private InetSocketAddress[] favoredNodes;
        private HFileContext fileContext;
        private boolean shouldDropCacheBehind;
        private Supplier<Collection<HStoreFile>> compactedFilesSupplier = () -> Collections.emptySet();
        private String fileStoragePolicy;
        private Consumer<Path> writerCreationTracker;
        private int maxVersions;
        private boolean newVersionBehavior;
        private CellComparator comparator;
        private boolean isCompaction;

        public Builder(Configuration conf, CacheConfig cacheConf, FileSystem fs) {
            this.conf = conf;
            this.cacheConf = cacheConf;
            this.fs = fs;
        }

        public Builder(Configuration conf, FileSystem fs) {
            this.conf = conf;
            this.cacheConf = CacheConfig.DISABLED;
            this.fs = fs;
        }

        public Builder withOutputDir(Path dir) {
            Preconditions.checkNotNull((Object)dir);
            this.dir = dir;
            return this;
        }

        public Builder withFilePath(Path filePath) {
            Preconditions.checkNotNull((Object)filePath);
            this.liveFilePath = filePath;
            return this;
        }

        public Builder withFavoredNodes(InetSocketAddress[] favoredNodes) {
            this.favoredNodes = favoredNodes;
            return this;
        }

        public Builder withBloomType(BloomType bloomType) {
            Preconditions.checkNotNull((Object)bloomType);
            this.bloomType = bloomType;
            return this;
        }

        public Builder withMaxKeyCount(long maxKeyCount) {
            this.maxKeyCount = maxKeyCount;
            return this;
        }

        public Builder withFileContext(HFileContext fileContext) {
            this.fileContext = fileContext;
            return this;
        }

        public Builder withShouldDropCacheBehind(boolean shouldDropCacheBehind) {
            this.shouldDropCacheBehind = shouldDropCacheBehind;
            return this;
        }

        public Builder withCompactedFilesSupplier(Supplier<Collection<HStoreFile>> compactedFilesSupplier) {
            this.compactedFilesSupplier = compactedFilesSupplier;
            return this;
        }

        public Builder withFileStoragePolicy(String fileStoragePolicy) {
            this.fileStoragePolicy = fileStoragePolicy;
            return this;
        }

        public Builder withWriterCreationTracker(Consumer<Path> writerCreationTracker) {
            this.writerCreationTracker = writerCreationTracker;
            return this;
        }

        public Builder withMaxVersions(int maxVersions) {
            this.maxVersions = maxVersions;
            return this;
        }

        public Builder withNewVersionBehavior(boolean newVersionBehavior) {
            this.newVersionBehavior = newVersionBehavior;
            return this;
        }

        public Builder withCellComparator(CellComparator comparator) {
            this.comparator = comparator;
            return this;
        }

        public Builder withIsCompaction(boolean isCompaction) {
            this.isCompaction = isCompaction;
            return this;
        }

        public StoreFileWriter build() throws IOException {
            String policyName;
            if ((this.dir == null ? 0 : 1) + (this.liveFilePath == null ? 0 : 1) != 1) {
                throw new IllegalArgumentException("Either specify parent directory or file path");
            }
            if (this.dir == null) {
                this.dir = this.liveFilePath.getParent();
            }
            if (!this.fs.exists(this.dir)) {
                HRegionFileSystem.mkdirs(this.fs, this.conf, this.dir);
            }
            if (null == (policyName = this.conf.get("STORAGE_POLICY"))) {
                policyName = this.conf.get("hbase.hstore.block.storage.policy");
            }
            CommonFSUtils.setStoragePolicy((FileSystem)this.fs, (Path)this.dir, (String)policyName);
            if (this.liveFilePath == null) {
                if (!Strings.isNullOrEmpty((String)this.fileStoragePolicy)) {
                    this.dir = new Path(this.dir, "storage_policy_" + this.fileStoragePolicy);
                    if (!this.fs.exists(this.dir)) {
                        HRegionFileSystem.mkdirs(this.fs, this.conf, this.dir);
                        LOG.info("Create tmp dir " + this.dir.toString() + " with storage policy: " + this.fileStoragePolicy);
                    }
                    CommonFSUtils.setStoragePolicy((FileSystem)this.fs, (Path)this.dir, (String)this.fileStoragePolicy);
                }
                this.liveFilePath = StoreFileWriter.getUniqueFile(this.fs, this.dir);
                if (!BloomFilterFactory.isGeneralBloomEnabled(this.conf)) {
                    this.bloomType = BloomType.NONE;
                }
            }
            if (this.isCompaction && StoreFileWriter.shouldEnableHistoricalCompactionFiles(this.conf)) {
                this.historicalFilePath = StoreFileWriter.getUniqueFile(this.fs, this.dir);
            }
            if (this.writerCreationTracker != null) {
                this.writerCreationTracker.accept(this.liveFilePath);
                if (this.historicalFilePath != null) {
                    this.writerCreationTracker.accept(this.historicalFilePath);
                }
            }
            return new StoreFileWriter(this.fs, this.liveFilePath, this.historicalFilePath, this.conf, this.cacheConf, this.bloomType, this.maxKeyCount, this.favoredNodes, this.fileContext, this.shouldDropCacheBehind, this.compactedFilesSupplier, this.comparator, this.maxVersions, this.newVersionBehavior);
        }
    }

    private static final class SingleStoreFileWriter {
        private final BloomFilterWriter generalBloomFilterWriter;
        private final BloomFilterWriter deleteFamilyBloomFilterWriter;
        private final BloomType bloomType;
        private byte[] bloomParam;
        private long earliestPutTs;
        private long deleteFamilyCnt;
        private BloomContext bloomContext;
        private BloomContext deleteFamilyBloomContext;
        private final TimeRangeTracker timeRangeTracker;
        private final Supplier<Collection<HStoreFile>> compactedFilesSupplier;
        private HFile.Writer writer;

        private SingleStoreFileWriter(FileSystem fs, Path path, Configuration conf, CacheConfig cacheConf, BloomType bloomType, long maxKeys, InetSocketAddress[] favoredNodes, HFileContext fileContext, boolean shouldDropCacheBehind, Supplier<Collection<HStoreFile>> compactedFilesSupplier) throws IOException {
            block10: {
                block9: {
                    this.bloomParam = null;
                    this.earliestPutTs = Long.MAX_VALUE;
                    this.deleteFamilyCnt = 0L;
                    this.bloomContext = null;
                    this.deleteFamilyBloomContext = null;
                    this.compactedFilesSupplier = compactedFilesSupplier;
                    this.timeRangeTracker = TimeRangeTracker.create(TimeRangeTracker.Type.NON_SYNC);
                    this.writer = HFile.getWriterFactory(conf, cacheConf).withPath(fs, path).withFavoredNodes(favoredNodes).withFileContext(fileContext).withShouldDropCacheBehind(shouldDropCacheBehind).create();
                    this.generalBloomFilterWriter = BloomFilterFactory.createGeneralBloomAtWrite(conf, cacheConf, bloomType, (int)Math.min(maxKeys, Integer.MAX_VALUE), this.writer);
                    if (this.generalBloomFilterWriter == null) break block9;
                    this.bloomType = bloomType;
                    this.bloomParam = BloomFilterUtil.getBloomFilterParam(bloomType, conf);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Bloom filter type for " + path + ": " + this.bloomType + ", param: " + (bloomType == BloomType.ROWPREFIX_FIXED_LENGTH ? Integer.valueOf(Bytes.toInt((byte[])this.bloomParam)) : Bytes.toStringBinary((byte[])this.bloomParam)) + ", " + this.generalBloomFilterWriter.getClass().getSimpleName());
                    }
                    switch (bloomType) {
                        case ROW: {
                            this.bloomContext = new RowBloomContext(this.generalBloomFilterWriter, fileContext.getCellComparator());
                            break block10;
                        }
                        case ROWCOL: {
                            this.bloomContext = new RowColBloomContext(this.generalBloomFilterWriter, fileContext.getCellComparator());
                            break block10;
                        }
                        case ROWPREFIX_FIXED_LENGTH: {
                            this.bloomContext = new RowPrefixFixedLengthBloomContext(this.generalBloomFilterWriter, fileContext.getCellComparator(), Bytes.toInt((byte[])this.bloomParam));
                            break block10;
                        }
                        default: {
                            throw new IOException("Invalid Bloom filter type: " + bloomType + " (ROW or ROWCOL or ROWPREFIX expected)");
                        }
                    }
                }
                this.bloomType = BloomType.NONE;
            }
            if (this.bloomType != BloomType.ROWCOL) {
                this.deleteFamilyBloomFilterWriter = BloomFilterFactory.createDeleteBloomAtWrite(conf, cacheConf, (int)Math.min(maxKeys, Integer.MAX_VALUE), this.writer);
                this.deleteFamilyBloomContext = new RowBloomContext(this.deleteFamilyBloomFilterWriter, fileContext.getCellComparator());
            } else {
                this.deleteFamilyBloomFilterWriter = null;
            }
            if (this.deleteFamilyBloomFilterWriter != null && LOG.isTraceEnabled()) {
                LOG.trace("Delete Family Bloom filter type for " + path + ": " + this.deleteFamilyBloomFilterWriter.getClass().getSimpleName());
            }
        }

        private long getPos() throws IOException {
            return ((HFileWriterImpl)this.writer).getPos();
        }

        private void appendMetadata(long maxSequenceId, boolean majorCompaction) throws IOException {
            this.appendMetadata(maxSequenceId, majorCompaction, Collections.emptySet());
        }

        private void appendMetadata(long maxSequenceId, boolean majorCompaction, Collection<HStoreFile> storeFiles) throws IOException {
            this.writer.appendFileInfo(HStoreFile.MAX_SEQ_ID_KEY, Bytes.toBytes((long)maxSequenceId));
            this.writer.appendFileInfo(HStoreFile.MAJOR_COMPACTION_KEY, Bytes.toBytes((boolean)majorCompaction));
            this.writer.appendFileInfo(HStoreFile.COMPACTION_EVENT_KEY, this.toCompactionEventTrackerBytes(storeFiles));
            this.appendTrackedTimestampsToMetadata();
        }

        private byte[] toCompactionEventTrackerBytes(Collection<HStoreFile> storeFiles) {
            Set notArchivedCompactedStoreFiles = this.compactedFilesSupplier.get().stream().map(sf -> sf.getPath().getName()).collect(Collectors.toSet());
            HashSet<String> compactedStoreFiles = new HashSet<String>();
            for (HStoreFile storeFile : storeFiles) {
                compactedStoreFiles.add(storeFile.getFileInfo().getPath().getName());
                for (String csf : storeFile.getCompactedStoreFiles()) {
                    if (!notArchivedCompactedStoreFiles.contains(csf)) continue;
                    compactedStoreFiles.add(csf);
                }
            }
            return ProtobufUtil.toCompactionEventTrackerBytes(compactedStoreFiles);
        }

        private void appendMetadata(long maxSequenceId, boolean majorCompaction, long mobCellsCount) throws IOException {
            this.writer.appendFileInfo(HStoreFile.MAX_SEQ_ID_KEY, Bytes.toBytes((long)maxSequenceId));
            this.writer.appendFileInfo(HStoreFile.MAJOR_COMPACTION_KEY, Bytes.toBytes((boolean)majorCompaction));
            this.writer.appendFileInfo(HStoreFile.MOB_CELLS_COUNT, Bytes.toBytes((long)mobCellsCount));
            this.appendTrackedTimestampsToMetadata();
        }

        private void appendMobMetadata(SetMultimap<TableName, String> mobRefSet) throws IOException {
            this.writer.appendFileInfo(HStoreFile.MOB_FILE_REFS, MobUtils.serializeMobFileRefs(mobRefSet));
        }

        private void appendTrackedTimestampsToMetadata() throws IOException {
            this.appendFileInfo(HStoreFile.TIMERANGE_KEY, TimeRangeTracker.toByteArray(this.timeRangeTracker));
            this.appendFileInfo(HStoreFile.EARLIEST_PUT_TS, Bytes.toBytes((long)this.earliestPutTs));
        }

        private void trackTimestamps(Cell cell) {
            if (KeyValue.Type.Put.getCode() == cell.getTypeByte()) {
                this.earliestPutTs = Math.min(this.earliestPutTs, cell.getTimestamp());
            }
            this.timeRangeTracker.includeTimestamp(cell);
        }

        private void appendGeneralBloomfilter(Cell cell) throws IOException {
            if (this.generalBloomFilterWriter != null) {
                this.bloomContext.writeBloom(cell);
            }
        }

        private void appendDeleteFamilyBloomFilter(Cell cell) throws IOException {
            if (!PrivateCellUtil.isDeleteFamily((Cell)cell) && !PrivateCellUtil.isDeleteFamilyVersion((Cell)cell)) {
                return;
            }
            ++this.deleteFamilyCnt;
            if (this.deleteFamilyBloomFilterWriter != null) {
                this.deleteFamilyBloomContext.writeBloom(cell);
            }
        }

        private void append(Cell cell) throws IOException {
            this.appendGeneralBloomfilter(cell);
            this.appendDeleteFamilyBloomFilter(cell);
            this.writer.append(cell);
            this.trackTimestamps(cell);
        }

        private void beforeShipped() throws IOException {
            this.writer.beforeShipped();
            if (this.generalBloomFilterWriter != null) {
                this.generalBloomFilterWriter.beforeShipped();
            }
            if (this.deleteFamilyBloomFilterWriter != null) {
                this.deleteFamilyBloomFilterWriter.beforeShipped();
            }
        }

        private Path getPath() {
            return this.writer.getPath();
        }

        private boolean hasGeneralBloom() {
            return this.generalBloomFilterWriter != null;
        }

        BloomFilterWriter getGeneralBloomWriter() {
            return this.generalBloomFilterWriter;
        }

        private boolean closeBloomFilter(BloomFilterWriter bfw) throws IOException {
            boolean haveBloom;
            boolean bl = haveBloom = bfw != null && bfw.getKeyCount() > 0L;
            if (haveBloom) {
                bfw.compactBloom();
            }
            return haveBloom;
        }

        private boolean closeGeneralBloomFilter() throws IOException {
            boolean hasGeneralBloom = this.closeBloomFilter(this.generalBloomFilterWriter);
            if (hasGeneralBloom) {
                this.writer.addGeneralBloomFilter(this.generalBloomFilterWriter);
                this.writer.appendFileInfo(HStoreFile.BLOOM_FILTER_TYPE_KEY, Bytes.toBytes((String)this.bloomType.toString()));
                if (this.bloomParam != null) {
                    this.writer.appendFileInfo(HStoreFile.BLOOM_FILTER_PARAM_KEY, this.bloomParam);
                }
                this.bloomContext.addLastBloomKey(this.writer);
            }
            return hasGeneralBloom;
        }

        private boolean closeDeleteFamilyBloomFilter() throws IOException {
            boolean hasDeleteFamilyBloom = this.closeBloomFilter(this.deleteFamilyBloomFilterWriter);
            if (hasDeleteFamilyBloom) {
                this.writer.addDeleteFamilyBloomFilter(this.deleteFamilyBloomFilterWriter);
            }
            this.writer.appendFileInfo(HStoreFile.DELETE_FAMILY_COUNT, Bytes.toBytes((long)this.deleteFamilyCnt));
            return hasDeleteFamilyBloom;
        }

        private void close() throws IOException {
            boolean hasGeneralBloom = this.closeGeneralBloomFilter();
            boolean hasDeleteFamilyBloom = this.closeDeleteFamilyBloomFilter();
            this.writer.close();
            if (LOG.isTraceEnabled()) {
                LOG.trace((hasGeneralBloom ? "" : "NO ") + "General Bloom and " + (hasDeleteFamilyBloom ? "" : "NO ") + "DeleteFamily was added to HFile " + this.getPath());
            }
        }

        private void appendFileInfo(byte[] key, byte[] value) throws IOException {
            this.writer.appendFileInfo(key, value);
        }

        private HFile.Writer getHFileWriter() {
            return this.writer;
        }
    }
}

