/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.MockMasterServices;
import org.apache.hadoop.hbase.master.assignment.OpenRegionProcedure;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.ServerRemoteProcedure;
import org.apache.hadoop.hbase.master.procedure.SplitWALRemoteProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestServerRemoteProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(TestServerRemoteProcedure.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestServerRemoteProcedure.class);
    @Rule
    public TestName name = new TestName();
    private HBaseTestingUtility util;
    private MockRSProcedureDispatcher rsDispatcher;
    private MockMasterServices master;
    private AssignmentManager am;
    private ScheduledExecutorService executor;

    @Before
    public void setUp() throws Exception {
        this.util = new HBaseTestingUtility();
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setUncaughtExceptionHandler((t, e) -> LOG.warn("Uncaught: ", e)).build());
        this.master = new MockMasterServices(this.util.getConfiguration());
        this.rsDispatcher = new MockRSProcedureDispatcher(this.master);
        this.rsDispatcher.setMockRsExecutor(new NoopRSExecutor());
        this.master.start(2, this.rsDispatcher);
        this.am = this.master.getAssignmentManager();
        this.master.getServerManager().getOnlineServersList().stream().forEach(serverName -> this.am.getRegionStates().getOrCreateServer(serverName));
    }

    @After
    public void tearDown() throws Exception {
        this.master.stop("tearDown");
        this.executor.shutdownNow();
    }

    @Test
    public void testSplitWALAndCrashBeforeResponse() throws Exception {
        ServerName worker = (ServerName)this.master.getServerManager().getOnlineServersList().get(0);
        ServerName crashedWorker = (ServerName)this.master.getServerManager().getOnlineServersList().get(1);
        SplitWALRemoteProcedure splitWALRemoteProcedure = new SplitWALRemoteProcedure(worker, crashedWorker, "test");
        Future<byte[]> future = this.submitProcedure((Procedure<MasterProcedureEnv>)splitWALRemoteProcedure);
        Thread.sleep(2000L);
        this.master.getServerManager().expireServer(worker);
        future.get(5000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)splitWALRemoteProcedure.isSuccess());
    }

    @Test
    public void testRemoteCompleteAndFailedAtTheSameTime() throws Exception {
        ServerName worker = (ServerName)this.master.getServerManager().getOnlineServersList().get(0);
        NoopServerRemoteProcedure noopServerRemoteProcedure = new NoopServerRemoteProcedure(worker);
        Future<byte[]> future = this.submitProcedure((Procedure<MasterProcedureEnv>)noopServerRemoteProcedure);
        Thread.sleep(2000L);
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        threadPool.execute(() -> noopServerRemoteProcedure.remoteOperationDone((MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment(), null));
        threadPool.execute(() -> noopServerRemoteProcedure.remoteCallFailed((MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment(), worker, new IOException()));
        future.get(2000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)noopServerRemoteProcedure.isSuccess());
    }

    @Test
    public void testRegionOpenProcedureIsNotHandledByDispatcher() throws Exception {
        TableName tableName = TableName.valueOf((String)"testRegionOpenProcedureIsNotHandledByDisPatcher");
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(Bytes.toBytes((int)1)).setEndKey(Bytes.toBytes((int)2)).setSplit(false).setRegionId(0L).build();
        MasterProcedureEnv env = (MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment();
        env.getAssignmentManager().getRegionStates().getOrCreateRegionStateNode(hri);
        TransitRegionStateProcedure proc = TransitRegionStateProcedure.assign((MasterProcedureEnv)env, (RegionInfo)hri, null);
        ServerName worker = (ServerName)this.master.getServerManager().getOnlineServersList().get(0);
        OpenRegionProcedure openRegionProcedure = new OpenRegionProcedure(proc, hri, worker);
        Future<byte[]> future = this.submitProcedure((Procedure<MasterProcedureEnv>)openRegionProcedure);
        Thread.sleep(2000L);
        this.rsDispatcher.removeNode((Comparable)worker);
        try {
            future.get(2000L, TimeUnit.MILLISECONDS);
            Assert.fail();
        }
        catch (TimeoutException e) {
            LOG.info("timeout is expected");
        }
        Assert.assertFalse((boolean)openRegionProcedure.isFinished());
    }

    private Future<byte[]> submitProcedure(Procedure<MasterProcedureEnv> proc) {
        return ProcedureSyncWait.submitProcedure(this.master.getMasterProcedureExecutor(), proc);
    }

    protected static class MockRSProcedureDispatcher
    extends RSProcedureDispatcher {
        private MockRSExecutor mockRsExec;

        public MockRSProcedureDispatcher(MasterServices master) {
            super(master);
        }

        public void setMockRsExecutor(MockRSExecutor mockRsExec) {
            this.mockRsExec = mockRsExec;
        }

        protected void remoteDispatch(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> remoteProcedures) {
            this.submitTask((Runnable)((Object)new MockRemoteCall(serverName, remoteProcedures)));
        }

        private class MockRemoteCall
        extends RSProcedureDispatcher.ExecuteProceduresRemoteCall {
            public MockRemoteCall(ServerName serverName, Set<RemoteProcedureDispatcher.RemoteProcedure> operations) {
                super((RSProcedureDispatcher)MockRSProcedureDispatcher.this, serverName, operations);
            }

            protected AdminProtos.ExecuteProceduresResponse sendRequest(ServerName serverName, AdminProtos.ExecuteProceduresRequest request) throws IOException {
                return MockRSProcedureDispatcher.this.mockRsExec.sendRequest(serverName, request);
            }
        }
    }

    protected static class NoopRSExecutor
    implements MockRSExecutor {
        protected NoopRSExecutor() {
        }

        @Override
        public AdminProtos.ExecuteProceduresResponse sendRequest(ServerName server, AdminProtos.ExecuteProceduresRequest req) throws IOException {
            if (req.getOpenRegionCount() > 0) {
                for (AdminProtos.OpenRegionRequest request : req.getOpenRegionList()) {
                    for (AdminProtos.OpenRegionRequest.RegionOpenInfo openReq : request.getOpenInfoList()) {
                        this.execOpenRegion(server, openReq);
                    }
                }
            }
            return AdminProtos.ExecuteProceduresResponse.getDefaultInstance();
        }

        protected AdminProtos.OpenRegionResponse.RegionOpeningState execOpenRegion(ServerName server, AdminProtos.OpenRegionRequest.RegionOpenInfo regionInfo) throws IOException {
            return null;
        }
    }

    protected static interface MockRSExecutor {
        public AdminProtos.ExecuteProceduresResponse sendRequest(ServerName var1, AdminProtos.ExecuteProceduresRequest var2) throws IOException;
    }

    private static class NoopServerRemoteProcedure
    extends ServerRemoteProcedure
    implements ServerProcedureInterface {
        public NoopServerRemoteProcedure(ServerName targetServer) {
            this.targetServer = targetServer;
        }

        protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
        }

        protected boolean abort(MasterProcedureEnv env) {
            return false;
        }

        protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }

        protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }

        public Optional<RemoteProcedureDispatcher.RemoteOperation> remoteCallBuild(MasterProcedureEnv env, ServerName serverName) {
            return Optional.of(new RSProcedureDispatcher.ServerOperation(null, 0L, ((Object)((Object)this)).getClass(), new byte[0]));
        }

        public synchronized void remoteOperationCompleted(MasterProcedureEnv env) {
            this.complete(env, null);
        }

        public synchronized void remoteOperationFailed(MasterProcedureEnv env, RemoteProcedureException error) {
            this.complete(env, (Throwable)error);
        }

        public void complete(MasterProcedureEnv env, Throwable error) {
            this.succ = true;
        }

        public ServerName getServerName() {
            return this.targetServer;
        }

        public boolean hasMetaTableRegion() {
            return false;
        }

        public ServerProcedureInterface.ServerOperationType getServerOperationType() {
            return ServerProcedureInterface.ServerOperationType.SWITCH_RPC_THROTTLE;
        }
    }
}

