/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.RegionAdminServiceCallable;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ReplicationProtbufUtil;
import org.apache.hadoop.hbase.replication.HBaseReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.EntryBuffers;
import org.apache.hadoop.hbase.wal.OutputSink;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.cache.Cache;
import org.apache.hbase.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionReplicaReplicationEndpoint
extends HBaseReplicationEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(RegionReplicaReplicationEndpoint.class);
    private static String CLIENT_RETRIES_NUMBER = "hbase.region.replica.replication.client.retries.number";
    private Configuration conf;
    private ClusterConnection connection;
    private TableDescriptors tableDescriptors;
    private WALSplitter.PipelineController controller;
    private RegionReplicaOutputSink outputSink;
    private EntryBuffers entryBuffers;
    private int numWriterThreads;
    private int operationTimeout;
    private ExecutorService pool;

    @Override
    public void init(ReplicationEndpoint.Context context) throws IOException {
        super.init(context);
        this.conf = HBaseConfiguration.create((Configuration)context.getConfiguration());
        this.tableDescriptors = context.getTableDescriptors();
        int defaultNumRetries = this.conf.getInt("hbase.client.retries.number", 15);
        if (defaultNumRetries > 10) {
            int mult = this.conf.getInt("hbase.client.serverside.retries.multiplier", 3);
            defaultNumRetries /= mult;
        }
        this.conf.setInt("hbase.client.serverside.retries.multiplier", 1);
        int numRetries = this.conf.getInt(CLIENT_RETRIES_NUMBER, defaultNumRetries);
        this.conf.setInt("hbase.client.retries.number", numRetries);
        this.numWriterThreads = this.conf.getInt("hbase.region.replica.replication.writer.threads", 3);
        this.controller = new WALSplitter.PipelineController();
        this.entryBuffers = new EntryBuffers(this.controller, this.conf.getLong("hbase.region.replica.replication.buffersize", 0x8000000L));
        this.operationTimeout = this.conf.getInt("hbase.client.operation.timeout", 1200000);
    }

    @Override
    protected void doStart() {
        try {
            this.connection = (ClusterConnection)ConnectionFactory.createConnection((Configuration)this.conf);
            this.pool = this.getDefaultThreadPool(this.conf);
            this.outputSink = new RegionReplicaOutputSink(this.controller, this.tableDescriptors, this.entryBuffers, this.connection, this.pool, this.numWriterThreads, this.operationTimeout);
            this.outputSink.startWriterThreads();
            super.doStart();
        }
        catch (IOException ex) {
            LOG.warn("Received exception while creating connection :" + ex);
            this.notifyFailed(ex);
        }
    }

    @Override
    protected void doStop() {
        if (this.outputSink != null) {
            try {
                this.outputSink.close();
            }
            catch (IOException ex) {
                LOG.warn("Got exception while trying to close OutputSink", (Throwable)ex);
            }
        }
        if (this.pool != null) {
            this.pool.shutdownNow();
            try {
                boolean shutdown = this.pool.awaitTermination(10000L, TimeUnit.MILLISECONDS);
                if (!shutdown) {
                    LOG.warn("Failed to shutdown the thread pool after 10 seconds");
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Got interrupted while waiting for the thread pool to shut down" + e);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException ex) {
                LOG.warn("Got exception closing connection :" + ex);
            }
        }
        super.doStop();
    }

    private ExecutorService getDefaultThreadPool(Configuration conf) {
        int maxThreads = conf.getInt("hbase.region.replica.replication.threads.max", 256);
        if (maxThreads == 0) {
            maxThreads = Runtime.getRuntime().availableProcessors() * 8;
        }
        long keepAliveTime = conf.getLong("hbase.region.replica.replication.threads.keepalivetime", 60L);
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(maxThreads * conf.getInt("hbase.client.max.total.tasks", 100));
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(maxThreads, maxThreads, keepAliveTime, TimeUnit.SECONDS, workQueue, new ThreadFactoryBuilder().setNameFormat(this.getClass().getSimpleName() + "-rpc-shared-pool-%d").setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build());
        tpe.allowCoreThreadTimeOut(true);
        return tpe;
    }

    @Override
    public boolean replicate(ReplicationEndpoint.ReplicateContext replicateContext) {
        while (this.isRunning()) {
            try {
                for (WAL.Entry entry : replicateContext.getEntries()) {
                    this.entryBuffers.appendEntry(entry);
                }
                this.outputSink.flush();
                this.ctx.getMetrics().incrLogEditsFiltered(this.outputSink.getSkippedEditsCounter().getAndSet(0L));
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            catch (IOException e) {
                LOG.warn("Received IOException while trying to replicate" + StringUtils.stringifyException((Throwable)e));
                this.outputSink.restartWriterThreadsIfNeeded();
            }
        }
        return false;
    }

    @Override
    public boolean canReplicateToSameCluster() {
        return true;
    }

    @Override
    protected WALEntryFilter getScopeWALEntryFilter() {
        return null;
    }

    static class RegionReplicaReplayCallable
    extends RegionAdminServiceCallable<AdminProtos.ReplicateWALEntryResponse> {
        private final List<WAL.Entry> entries;
        private final byte[] initialEncodedRegionName;
        private final AtomicLong skippedEntries;

        public RegionReplicaReplayCallable(ClusterConnection connection, RpcControllerFactory rpcControllerFactory, TableName tableName, HRegionLocation location, RegionInfo regionInfo, byte[] row, List<WAL.Entry> entries, AtomicLong skippedEntries) {
            super(connection, rpcControllerFactory, location, tableName, row, regionInfo.getReplicaId());
            this.entries = entries;
            this.skippedEntries = skippedEntries;
            this.initialEncodedRegionName = regionInfo.getEncodedNameAsBytes();
        }

        public AdminProtos.ReplicateWALEntryResponse call(HBaseRpcController controller) throws Exception {
            boolean skip = false;
            if (!Bytes.equals((byte[])this.location.getRegionInfo().getEncodedNameAsBytes(), (byte[])this.initialEncodedRegionName)) {
                skip = true;
            }
            if (!this.entries.isEmpty() && !skip) {
                WAL.Entry[] entriesArray = new WAL.Entry[this.entries.size()];
                entriesArray = this.entries.toArray(entriesArray);
                Pair<AdminProtos.ReplicateWALEntryRequest, CellScanner> p = ReplicationProtbufUtil.buildReplicateWALEntryRequest(entriesArray, this.location.getRegionInfo().getEncodedNameAsBytes(), null, null, null);
                controller.setCellScanner((CellScanner)p.getSecond());
                return this.stub.replay((RpcController)controller, (AdminProtos.ReplicateWALEntryRequest)p.getFirst());
            }
            if (skip) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Skipping " + this.entries.size() + " entries in table " + this.tableName + " because located region " + this.location.getRegionInfo().getEncodedName() + " is different than the original region " + Bytes.toStringBinary((byte[])this.initialEncodedRegionName) + " from WALEdit");
                    for (WAL.Entry entry : this.entries) {
                        LOG.trace("Skipping : " + entry);
                    }
                }
                this.skippedEntries.addAndGet(this.entries.size());
            }
            return AdminProtos.ReplicateWALEntryResponse.newBuilder().build();
        }
    }

    static class RetryingRpcCallable<V>
    implements Callable<V> {
        RpcRetryingCallerFactory factory;
        RetryingCallable<V> callable;
        int timeout;

        public RetryingRpcCallable(RpcRetryingCallerFactory factory, RetryingCallable<V> callable, int timeout) {
            this.factory = factory;
            this.callable = callable;
            this.timeout = timeout;
        }

        @Override
        public V call() throws Exception {
            return (V)this.factory.newCaller().callWithRetries(this.callable, this.timeout);
        }
    }

    static class RegionReplicaSinkWriter {
        RegionReplicaOutputSink sink;
        ClusterConnection connection;
        RpcControllerFactory rpcControllerFactory;
        RpcRetryingCallerFactory rpcRetryingCallerFactory;
        int operationTimeout;
        ExecutorService pool;
        Cache<TableName, Boolean> disabledAndDroppedTables;
        TableDescriptors tableDescriptors;

        public RegionReplicaSinkWriter(RegionReplicaOutputSink sink, ClusterConnection connection, ExecutorService pool, int operationTimeout, TableDescriptors tableDescriptors) {
            this.sink = sink;
            this.connection = connection;
            this.operationTimeout = operationTimeout;
            this.rpcRetryingCallerFactory = RpcRetryingCallerFactory.instantiate((Configuration)connection.getConfiguration(), (MetricsConnection)connection.getConnectionMetrics());
            this.rpcControllerFactory = RpcControllerFactory.instantiate((Configuration)connection.getConfiguration());
            this.pool = pool;
            this.tableDescriptors = tableDescriptors;
            int nonExistentTableCacheExpiryMs = connection.getConfiguration().getInt("hbase.region.replica.replication.cache.disabledAndDroppedTables.expiryMs", 5000);
            this.disabledAndDroppedTables = CacheBuilder.newBuilder().expireAfterWrite((long)nonExistentTableCacheExpiryMs, TimeUnit.MILLISECONDS).initialCapacity(10).maximumSize(1000L).build();
        }

        public void append(TableName tableName, byte[] encodedRegionName, byte[] row, List<WAL.Entry> entries) throws IOException {
            RegionLocations locations;
            block26: {
                HRegionLocation primaryLocation;
                if (this.disabledAndDroppedTables.getIfPresent((Object)tableName) != null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Skipping " + entries.size() + " entries because table " + tableName + " is cached as a disabled or dropped table");
                        for (WAL.Entry entry : entries) {
                            LOG.trace("Skipping : " + entry);
                        }
                    }
                    this.sink.getSkippedEditsCounter().addAndGet(entries.size());
                    return;
                }
                locations = null;
                boolean useCache = true;
                while (true) {
                    try {
                        while (true) {
                            if ((locations = RegionReplicaReplayCallable.getRegionLocations((ClusterConnection)this.connection, (TableName)tableName, (byte[])row, (boolean)useCache, (int)0)) == null) {
                                throw new HBaseIOException("Cannot locate locations for " + tableName + ", row:" + Bytes.toStringBinary((byte[])row));
                            }
                            if (useCache && locations.size() == 1 && TableName.isMetaTableName((TableName)tableName) && this.tableDescriptors.get(tableName).getRegionReplication() > 1) {
                                LOG.info("Skipping location cache; only one location found for {}", (Object)tableName);
                                useCache = false;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (TableNotFoundException e) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Skipping " + entries.size() + " entries because table " + tableName + " is dropped. Adding table to cache.");
                            for (WAL.Entry entry : entries) {
                                LOG.trace("Skipping : " + entry);
                            }
                        }
                        this.disabledAndDroppedTables.put((Object)tableName, (Object)Boolean.TRUE);
                        this.sink.getSkippedEditsCounter().addAndGet(entries.size());
                        return;
                    }
                    primaryLocation = locations.getDefaultRegionLocation();
                    if (Bytes.equals((byte[])primaryLocation.getRegionInfo().getEncodedNameAsBytes(), (byte[])encodedRegionName)) break block26;
                    if (!useCache) break;
                    useCache = false;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Skipping " + entries.size() + " entries in table " + tableName + " because located region " + primaryLocation.getRegionInfo().getEncodedName() + " is different than the original region " + Bytes.toStringBinary((byte[])encodedRegionName) + " from WALEdit");
                    for (WAL.Entry entry : entries) {
                        LOG.trace("Skipping : " + entry);
                    }
                }
                this.sink.getSkippedEditsCounter().addAndGet(entries.size());
                return;
            }
            if (locations.size() == 1) {
                return;
            }
            ArrayList tasks = new ArrayList(locations.size() - 1);
            for (int replicaId = 0; replicaId < locations.size(); ++replicaId) {
                HRegionLocation location = locations.getRegionLocation(replicaId);
                if (RegionReplicaUtil.isDefaultReplica((int)replicaId)) continue;
                HRegionInfo regionInfo = location == null ? RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)locations.getDefaultRegionLocation().getRegionInfo(), (int)replicaId) : location.getRegionInfo();
                RegionReplicaReplayCallable callable = new RegionReplicaReplayCallable(this.connection, this.rpcControllerFactory, tableName, location, (RegionInfo)regionInfo, row, entries, this.sink.getSkippedEditsCounter());
                Future task = this.pool.submit(new RetryingRpcCallable(this.rpcRetryingCallerFactory, callable, this.operationTimeout));
                tasks.add(task);
            }
            boolean tasksCancelled = false;
            for (int replicaId = 0; replicaId < tasks.size(); ++replicaId) {
                try {
                    ((Future)tasks.get(replicaId)).get();
                    continue;
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException(e.getMessage());
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    boolean canBeSkipped = false;
                    if (cause instanceof IOException) {
                        TableDescriptor tableDescriptor;
                        if (cause instanceof TableNotFoundException || this.connection.isTableDisabled(tableName)) {
                            this.disabledAndDroppedTables.put((Object)tableName, (Object)Boolean.TRUE);
                            canBeSkipped = true;
                        } else if (this.tableDescriptors != null && (tableDescriptor = this.tableDescriptors.get(tableName)) != null && tableDescriptor.getRegionReplication() <= replicaId + 1) {
                            canBeSkipped = true;
                        }
                        if (canBeSkipped) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Skipping " + entries.size() + " entries in table " + tableName + " because received exception for dropped or disabled table", cause);
                                for (WAL.Entry entry : entries) {
                                    LOG.trace("Skipping : " + entry);
                                }
                            }
                            if (tasksCancelled) continue;
                            this.sink.getSkippedEditsCounter().addAndGet(entries.size());
                            tasksCancelled = true;
                            continue;
                        }
                        throw (IOException)cause;
                    }
                    throw new IOException(cause);
                }
            }
        }
    }

    static class RegionReplicaOutputSink
    extends OutputSink {
        private final RegionReplicaSinkWriter sinkWriter;
        private final TableDescriptors tableDescriptors;
        private final Cache<TableName, Boolean> memstoreReplicationEnabled;

        public RegionReplicaOutputSink(WALSplitter.PipelineController controller, TableDescriptors tableDescriptors, EntryBuffers entryBuffers, ClusterConnection connection, ExecutorService pool, int numWriters, int operationTimeout) {
            super(controller, entryBuffers, numWriters);
            this.sinkWriter = new RegionReplicaSinkWriter(this, connection, pool, operationTimeout, tableDescriptors);
            this.tableDescriptors = tableDescriptors;
            int memstoreReplicationEnabledCacheExpiryMs = connection.getConfiguration().getInt("hbase.region.replica.replication.cache.memstoreReplicationEnabled.expiryMs", 5000);
            this.memstoreReplicationEnabled = CacheBuilder.newBuilder().expireAfterWrite((long)memstoreReplicationEnabledCacheExpiryMs, TimeUnit.MILLISECONDS).initialCapacity(10).maximumSize(1000L).build();
        }

        @Override
        public void append(EntryBuffers.RegionEntryBuffer buffer) throws IOException {
            List<WAL.Entry> entries = buffer.getEntries();
            if (entries.isEmpty() || entries.get(0).getEdit().getCells().isEmpty()) {
                return;
            }
            if (!this.requiresReplication(buffer.getTableName(), entries)) {
                return;
            }
            this.sinkWriter.append(buffer.getTableName(), buffer.getEncodedRegionName(), CellUtil.cloneRow((Cell)entries.get(0).getEdit().getCells().get(0)), entries);
        }

        void flush() throws IOException {
            this.entryBuffers.waitUntilDrained();
        }

        @Override
        public boolean keepRegionEvent(WAL.Entry entry) {
            return true;
        }

        @Override
        public List<Path> close() throws IOException {
            this.finishWriterThreads(true);
            return null;
        }

        @Override
        public Map<String, Long> getOutputCounts() {
            return null;
        }

        @Override
        public int getNumberOfRecoveredRegions() {
            return 0;
        }

        AtomicLong getSkippedEditsCounter() {
            return this.totalSkippedEdits;
        }

        private boolean requiresReplication(TableName tableName, List<WAL.Entry> entries) throws IOException {
            if (this.tableDescriptors == null) {
                return true;
            }
            Boolean requiresReplication = (Boolean)this.memstoreReplicationEnabled.getIfPresent((Object)tableName);
            if (requiresReplication == null) {
                TableDescriptor htd = this.tableDescriptors.get(tableName);
                requiresReplication = htd == null || htd.hasRegionMemStoreReplication();
                this.memstoreReplicationEnabled.put((Object)tableName, (Object)requiresReplication);
            }
            if (!requiresReplication.booleanValue()) {
                int skipEdits = 0;
                Iterator<WAL.Entry> it = entries.iterator();
                while (it.hasNext()) {
                    WAL.Entry entry = it.next();
                    if (entry.getEdit().isMetaEdit()) {
                        requiresReplication = true;
                        continue;
                    }
                    it.remove();
                    ++skipEdits;
                }
                this.totalSkippedEdits.addAndGet(skipEdits);
            }
            return requiresReplication;
        }

        @Override
        protected int getNumOpenWriters() {
            return 0;
        }
    }
}

