/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={FilterTests.class, MediumTests.class})
public class TestFuzzyRowFilterEndToEnd {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFuzzyRowFilterEndToEnd.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFuzzyRowFilterEndToEnd.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte fuzzyValue = 63;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.client.scanner.caching", 1000);
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
        conf.setLong("hbase.hregion.max.filesize", 0x280000000L);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testAllFixedBits() throws IOException {
        String cf = "f";
        String cq = "q";
        Table ht = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), Bytes.toBytes((String)cf), Integer.MAX_VALUE);
        String[] rows = new String[]{"\\x9C\\x00\\x044\\x00\\x00\\x00\\x00", "\\x9C\\x00\\x044\\x01\\x00\\x00\\x00", "\\x9C\\x00\\x044\\x00\\x01\\x00\\x00", "\\x9B\\x00\\x044e\\x9B\\x02\\xBB", "\\x9C\\x00\\x044\\x00\\x00\\x01\\x00", "\\x9C\\x00\\x044\\x00\\x01\\x00\\x01", "\\x9B\\x00\\x044e\\xBB\\xB2\\xBB"};
        for (int i = 0; i < rows.length; ++i) {
            Put p = new Put(Bytes.toBytesBinary((String)rows[i]));
            p.addColumn(cf.getBytes(), cq.getBytes(), "value".getBytes());
            ht.put(p);
        }
        TEST_UTIL.flush();
        this.testAllFixedBitsRunScanWithMask(ht, rows.length, (byte)0);
        this.testAllFixedBitsRunScanWithMask(ht, 2, (byte)2);
        TEST_UTIL.deleteTable(TableName.valueOf((String)this.name.getMethodName()));
    }

    private void testAllFixedBitsRunScanWithMask(Table ht, int expectedRows, byte processedRowMask) throws IOException {
        ArrayList<Pair> data = new ArrayList<Pair>();
        byte[] fuzzyKey = Bytes.toBytesBinary((String)"\\x9B\\x00\\x044e");
        byte[] mask = new byte[]{0, 0, 0, 0, 0};
        byte[] copyFuzzyKey = Arrays.copyOf(fuzzyKey, fuzzyKey.length);
        byte[] copyMask = Arrays.copyOf(mask, mask.length);
        data.add(new Pair((Object)fuzzyKey, (Object)mask));
        FuzzyRowFilter filter = new FuzzyRowFilter(data, processedRowMask);
        Scan scan = new Scan();
        scan.setFilter((Filter)filter);
        ResultScanner scanner = ht.getScanner(scan);
        int total = 0;
        while (scanner.next() != null) {
            ++total;
        }
        Assert.assertEquals((long)expectedRows, (long)total);
        Assert.assertEquals((Object)true, (Object)Arrays.equals(copyFuzzyKey, fuzzyKey));
        Assert.assertEquals((Object)true, (Object)Arrays.equals(copyMask, mask));
    }

    @Test
    public void testHBASE14782() throws IOException {
        String cf = "f";
        String cq = "q";
        Table ht = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), Bytes.toBytes((String)cf), Integer.MAX_VALUE);
        String[] rows = new String[]{"\\x9C\\x00\\x044\\x00\\x00\\x00\\x00", "\\x9C\\x00\\x044\\x01\\x00\\x00\\x00", "\\x9C\\x00\\x044\\x00\\x01\\x00\\x00", "\\x9C\\x00\\x044\\x00\\x00\\x01\\x00", "\\x9C\\x00\\x044\\x00\\x01\\x00\\x01", "\\x9B\\x00\\x044e\\xBB\\xB2\\xBB"};
        String badRow = "\\x9C\\x00\\x03\\xE9e\\xBB{X\\x1Fwts\\x1F\\x15vRX";
        for (int i = 0; i < rows.length; ++i) {
            Put p = new Put(Bytes.toBytesBinary((String)rows[i]));
            p.addColumn(cf.getBytes(), cq.getBytes(), "value".getBytes());
            ht.put(p);
        }
        Put p = new Put(Bytes.toBytesBinary((String)badRow));
        p.addColumn(cf.getBytes(), cq.getBytes(), "value".getBytes());
        ht.put(p);
        TEST_UTIL.flush();
        this.testHBASE14782RunScanWithMask(ht, rows.length, (byte)0);
        this.testHBASE14782RunScanWithMask(ht, rows.length, (byte)2);
        TEST_UTIL.deleteTable(TableName.valueOf((String)this.name.getMethodName()));
    }

    private void testHBASE14782RunScanWithMask(Table ht, int expectedRows, byte processedRowMask) throws IOException {
        ArrayList<Pair> data = new ArrayList<Pair>();
        byte[] fuzzyKey = Bytes.toBytesBinary((String)"\\x00\\x00\\x044");
        byte[] mask = new byte[]{1, 0, 0, 0};
        data.add(new Pair((Object)fuzzyKey, (Object)mask));
        FuzzyRowFilter filter = new FuzzyRowFilter(data, processedRowMask);
        Scan scan = new Scan();
        scan.setFilter((Filter)filter);
        ResultScanner scanner = ht.getScanner(scan);
        int total = 0;
        while (scanner.next() != null) {
            ++total;
        }
        Assert.assertEquals((long)expectedRows, (long)total);
    }

    @Test
    public void testFilterList() throws Exception {
        String cf = "f";
        Table ht = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), Bytes.toBytes((String)cf), Integer.MAX_VALUE);
        for (int i1 = 0; i1 < 5; ++i1) {
            for (int i2 = 0; i2 < 5; ++i2) {
                byte[] rk = new byte[10];
                ByteBuffer buf = ByteBuffer.wrap(rk);
                buf.clear();
                buf.putShort((short)2);
                buf.putInt(i1);
                buf.putInt(i2);
                for (int c = 0; c < 5; ++c) {
                    byte[] cq = new byte[4];
                    Bytes.putBytes((byte[])cq, (int)0, (byte[])Bytes.toBytes((int)c), (int)0, (int)4);
                    Put p = new Put(rk);
                    p.setDurability(Durability.SKIP_WAL);
                    p.addColumn(cf.getBytes(), cq, Bytes.toBytes((int)c));
                    ht.put(p);
                    LOG.info("Inserting: rk: " + Bytes.toStringBinary((byte[])rk) + " cq: " + Bytes.toStringBinary((byte[])cq));
                }
            }
        }
        TEST_UTIL.flush();
        this.runTest(ht, 5);
    }

    private void runTest(Table hTable, int expectedSize) throws IOException {
        byte[] fuzzyKey1 = new byte[10];
        ByteBuffer buf = ByteBuffer.wrap(fuzzyKey1);
        buf.clear();
        buf.putShort((short)2);
        for (int i = 0; i < 4; ++i) {
            buf.put((byte)63);
        }
        buf.putInt(1);
        byte[] mask1 = new byte[]{0, 0, 1, 1, 1, 1, 0, 0, 0, 0};
        byte[] fuzzyKey2 = new byte[10];
        buf = ByteBuffer.wrap(fuzzyKey2);
        buf.clear();
        buf.putShort((short)2);
        buf.putInt(2);
        for (int i = 0; i < 4; ++i) {
            buf.put((byte)63);
        }
        byte[] mask2 = new byte[]{0, 0, 0, 0, 0, 0, 1, 1, 1, 1};
        Pair pair1 = new Pair((Object)fuzzyKey1, (Object)mask1);
        Pair pair2 = new Pair((Object)fuzzyKey2, (Object)mask2);
        FuzzyRowFilter fuzzyRowFilter1 = new FuzzyRowFilter((List)Lists.newArrayList((Object[])new Pair[]{pair1}));
        FuzzyRowFilter fuzzyRowFilter2 = new FuzzyRowFilter((List)Lists.newArrayList((Object[])new Pair[]{pair2}));
        this.runScanner(hTable, expectedSize, (Filter)fuzzyRowFilter1, (Filter)fuzzyRowFilter2);
    }

    private void runScanner(Table hTable, int expectedSize, Filter filter1, Filter filter2) throws IOException {
        Result result;
        String cf = "f";
        Scan scan = new Scan();
        scan.addFamily(cf.getBytes());
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL, new Filter[]{filter1, filter2});
        scan.setFilter((Filter)filterList);
        ResultScanner scanner = hTable.getScanner(scan);
        ArrayList<Cell> results = new ArrayList<Cell>();
        long timeBeforeScan = EnvironmentEdgeManager.currentTime();
        while ((result = scanner.next()) != null) {
            for (Cell kv : result.listCells()) {
                LOG.info("Got rk: " + Bytes.toStringBinary((byte[])CellUtil.cloneRow((Cell)kv)) + " cq: " + Bytes.toStringBinary((byte[])CellUtil.cloneQualifier((Cell)kv)));
                results.add(kv);
            }
        }
        long scanTime = EnvironmentEdgeManager.currentTime() - timeBeforeScan;
        scanner.close();
        LOG.info("scan time = " + scanTime + "ms");
        LOG.info("found " + results.size() + " results");
        Assert.assertEquals((long)expectedSize, (long)results.size());
    }

    @Test
    public void testHBASE26967() throws IOException {
        byte[] row1 = Bytes.toBytes((String)"1");
        byte[] row2 = Bytes.toBytes((String)"2");
        String cf1 = "f1";
        String cf2 = "f2";
        String cq1 = "col1";
        String cq2 = "col2";
        Table ht = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), new String[]{cf1, cf2});
        ArrayList puts = Lists.newArrayList();
        puts.add(new Put(row1).addColumn(Bytes.toBytes((String)cf1), Bytes.toBytes((String)cq1), Bytes.toBytes((String)"a1")));
        puts.add(new Put(row1).addColumn(Bytes.toBytes((String)cf2), Bytes.toBytes((String)cq2), Bytes.toBytes((String)"a2")));
        puts.add(new Put(row2).addColumn(Bytes.toBytes((String)cf1), Bytes.toBytes((String)cq1), Bytes.toBytes((String)"b1")));
        puts.add(new Put(row2).addColumn(Bytes.toBytes((String)cf2), Bytes.toBytes((String)cq2), Bytes.toBytes((String)"b2")));
        ht.put((List)puts);
        TEST_UTIL.flush();
        ArrayList data = Lists.newArrayList();
        byte[] fuzzyKey = Bytes.toBytes((String)"1");
        byte[] mask = new byte[]{0};
        data.add(new Pair((Object)fuzzyKey, (Object)mask));
        FuzzyRowFilter fuzzyRowFilter = new FuzzyRowFilter((List)data);
        SingleColumnValueFilter singleColumnValueFilter = new SingleColumnValueFilter(Bytes.toBytes((String)cf2), Bytes.toBytes((String)cq2), CompareOperator.EQUAL, Bytes.toBytes((String)"x"));
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        filterList.addFilter((List)Lists.newArrayList((Object[])new Filter[]{fuzzyRowFilter, singleColumnValueFilter}));
        Scan scan = new Scan();
        scan.setFilter((Filter)filterList);
        ResultScanner scanner = ht.getScanner(scan);
        Result rs = scanner.next();
        Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])row1, (byte[])rs.getRow()));
        Assert.assertEquals((long)2L, (long)rs.listCells().size());
        Assert.assertNull((Object)scanner.next());
        TEST_UTIL.deleteTable(TableName.valueOf((String)this.name.getMethodName()));
    }
}

