/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.SequenceId;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Replication", "Coprocesssor"})
public interface WALKey
extends SequenceId,
Comparable<WALKey> {
    public static final List<UUID> EMPTY_UUIDS = Collections.unmodifiableList(new ArrayList());

    default public long estimatedSerializedSizeOf() {
        return 0L;
    }

    public byte[] getEncodedRegionName();

    public TableName getTablename();

    public long getWriteTime();

    default public long getNonceGroup() {
        return 0L;
    }

    default public long getNonce() {
        return 0L;
    }

    public UUID getOriginatingClusterId();

    public long getOrigLogSeqNum();

    default public Map<String, Object> toStringMap() {
        HashMap<String, Object> stringMap = new HashMap<String, Object>();
        stringMap.put("table", this.getTablename());
        stringMap.put("region", Bytes.toStringBinary((byte[])this.getEncodedRegionName()));
        stringMap.put("sequence", this.getSequenceId());
        return stringMap;
    }
}

