/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ZKDataMigrator {
    private static final Logger LOG = LoggerFactory.getLogger(ZKDataMigrator.class);

    @Deprecated
    public static Map<TableName, TableState.State> queryForTableStates(ZKWatcher zkw) throws KeeperException, InterruptedException {
        HashMap<TableName, TableState.State> rv = new HashMap<TableName, TableState.State>();
        List children = ZKUtil.listChildrenNoWatch((ZKWatcher)zkw, (String)zkw.znodePaths.tableZNode);
        if (children == null) {
            return rv;
        }
        for (String child : children) {
            TableName tableName = TableName.valueOf((String)child);
            ZooKeeperProtos.DeprecatedTableState.State state = ZKDataMigrator.getTableState(zkw, tableName);
            TableState.State newState = TableState.State.ENABLED;
            if (state != null) {
                switch (state) {
                    case ENABLED: {
                        newState = TableState.State.ENABLED;
                        break;
                    }
                    case DISABLED: {
                        newState = TableState.State.DISABLED;
                        break;
                    }
                    case DISABLING: {
                        newState = TableState.State.DISABLING;
                        break;
                    }
                    case ENABLING: {
                        newState = TableState.State.ENABLING;
                        break;
                    }
                }
            }
            rv.put(tableName, newState);
        }
        return rv;
    }

    @Deprecated
    private static ZooKeeperProtos.DeprecatedTableState.State getTableState(ZKWatcher zkw, TableName tableName) throws KeeperException, InterruptedException {
        String znode = ZNodePaths.joinZNode((String)zkw.znodePaths.tableZNode, (String)tableName.getNameAsString());
        byte[] data = ZKUtil.getData((ZKWatcher)zkw, (String)znode);
        if (data == null || data.length <= 0) {
            return null;
        }
        try {
            ProtobufUtil.expectPBMagicPrefix((byte[])data);
            ZooKeeperProtos.DeprecatedTableState.Builder builder = ZooKeeperProtos.DeprecatedTableState.newBuilder();
            int magicLen = ProtobufUtil.lengthOfPBMagic();
            ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])data, (int)magicLen, (int)(data.length - magicLen));
            return builder.getState();
        }
        catch (IOException e) {
            KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
            ke.initCause((Throwable)e);
            throw ke;
        }
        catch (DeserializationException e) {
            throw ZKUtil.convert((DeserializationException)e);
        }
    }
}

