/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class JVMClusterUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JVMClusterUtil.class);

    public static RegionServerThread createRegionServerThread(Configuration c, Class<? extends HRegionServer> hrsc, int index) throws IOException {
        HRegionServer server;
        try {
            Constructor<? extends HRegionServer> ctor = hrsc.getConstructor(Configuration.class);
            ctor.setAccessible(true);
            server = ctor.newInstance(c);
        }
        catch (InvocationTargetException ite) {
            Throwable target = ite.getTargetException();
            throw new RuntimeException("Failed construction of RegionServer: " + hrsc.toString() + (target.getCause() != null ? target.getCause().getMessage() : ""), target);
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        return new RegionServerThread(server, index);
    }

    public static MasterThread createMasterThread(Configuration c, Class<? extends HMaster> hmc, int index) throws IOException {
        HMaster server;
        try {
            server = hmc.getConstructor(Configuration.class).newInstance(c);
        }
        catch (InvocationTargetException ite) {
            Throwable target = ite.getTargetException();
            throw new RuntimeException("Failed construction of Master: " + hmc.toString() + (target.getCause() != null ? target.getCause().getMessage() : ""), target);
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        return new MasterThread(server, index);
    }

    private static MasterThread findActiveMaster(List<MasterThread> masters) {
        for (MasterThread t : masters) {
            if (!t.master.isActiveMaster()) continue;
            return t;
        }
        return null;
    }

    public static String startup(List<MasterThread> masters, List<RegionServerThread> regionservers) throws IOException {
        Configuration configuration = null;
        if (masters == null || masters.isEmpty()) {
            return null;
        }
        for (MasterThread t : masters) {
            configuration = t.getMaster().getConfiguration();
            t.start();
        }
        long startTime = System.currentTimeMillis();
        while (JVMClusterUtil.findActiveMaster(masters) == null) {
            int startTimeout;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
            int n = startTimeout = configuration != null ? Integer.parseInt(configuration.get("hbase.master.start.timeout.localHBaseCluster", "30000")) : 30000;
            if (System.currentTimeMillis() <= startTime + (long)startTimeout) continue;
            String string = "Master not active after " + startTimeout + "ms";
            Threads.printThreadInfo((PrintStream)System.out, (String)("Thread dump because: " + string));
            throw new RuntimeException(string);
        }
        if (regionservers != null) {
            for (RegionServerThread regionServerThread : regionservers) {
                regionServerThread.start();
            }
        }
        startTime = System.currentTimeMillis();
        int maxwait = 200000;
        MasterThread masterThread;
        while ((masterThread = JVMClusterUtil.findActiveMaster(masters)) == null || !masterThread.master.isInitialized()) {
            if (System.currentTimeMillis() > startTime + 10000L) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                }
            }
            if (System.currentTimeMillis() > startTime + 200000L) {
                String msg = "Master not initialized after 200000ms seconds";
                Threads.printThreadInfo((PrintStream)System.out, (String)("Thread dump because: " + msg));
                throw new RuntimeException(msg);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
        }
        return masterThread.master.getServerName().toString();
    }

    public static void shutdown(List<MasterThread> masters, List<RegionServerThread> regionservers) {
        LOG.debug("Shutting down HBase Cluster");
        if (masters != null) {
            MasterThread activeMaster = null;
            for (MasterThread t : masters) {
                if (!t.master.isActiveMaster()) {
                    try {
                        t.master.stopMaster();
                    }
                    catch (IOException e) {
                        LOG.error("Exception occurred while stopping master", (Throwable)e);
                    }
                    continue;
                }
                activeMaster = t;
            }
            if (activeMaster != null) {
                try {
                    activeMaster.master.shutdown();
                }
                catch (IOException e) {
                    LOG.error("Exception occurred in HMaster.shutdown()", (Throwable)e);
                }
            }
        }
        boolean wasInterrupted = false;
        long maxTime = System.currentTimeMillis() + 30000L;
        if (regionservers != null) {
            for (RegionServerThread t : regionservers) {
                t.getRegionServer().stop("Shutdown requested");
            }
            for (RegionServerThread t : regionservers) {
                long now = System.currentTimeMillis();
                if (!t.isAlive() || wasInterrupted || now >= maxTime) continue;
                try {
                    t.join(maxTime - now);
                }
                catch (InterruptedException e) {
                    LOG.info("Got InterruptedException on shutdown - not waiting anymore on region server ends", (Throwable)e);
                    wasInterrupted = true;
                }
            }
            for (int i = 0; i < 100; ++i) {
                boolean atLeastOneLiveServer = false;
                for (RegionServerThread t : regionservers) {
                    if (!t.isAlive()) continue;
                    atLeastOneLiveServer = true;
                    try {
                        LOG.warn("RegionServerThreads remaining, give one more chance before interrupting");
                        t.join(1000L);
                    }
                    catch (InterruptedException e) {
                        wasInterrupted = true;
                    }
                }
                if (!atLeastOneLiveServer) break;
                for (RegionServerThread t : regionservers) {
                    if (!t.isAlive()) continue;
                    LOG.warn("RegionServerThreads taking too long to stop, interrupting");
                    t.interrupt();
                }
            }
        }
        if (masters != null) {
            for (MasterThread t : masters) {
                while (t.master.isAlive() && !wasInterrupted) {
                    try {
                        Threads.threadDumpingIsAlive((Thread)t.master.getThread());
                    }
                    catch (InterruptedException e) {
                        LOG.info("Got InterruptedException on shutdown - not waiting anymore on master ends", (Throwable)e);
                        wasInterrupted = true;
                    }
                }
            }
        }
        LOG.info("Shutdown of " + (masters != null ? Integer.valueOf(masters.size()) : "0") + " master(s) and " + (regionservers != null ? Integer.valueOf(regionservers.size()) : "0") + " regionserver(s) " + (wasInterrupted ? "interrupted" : "complete"));
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static class MasterThread
    extends Thread {
        private final HMaster master;

        public MasterThread(HMaster m, int index) {
            super((Runnable)((Object)m), "M:" + index + ";" + m.getServerName().toShortString());
            this.master = m;
        }

        public HMaster getMaster() {
            return this.master;
        }
    }

    public static class RegionServerThread
    extends Thread {
        private final HRegionServer regionServer;

        public RegionServerThread(HRegionServer r, int index) {
            super((Runnable)((Object)r), "RS:" + index + ";" + r.getServerName().toShortString());
            this.regionServer = r;
        }

        public HRegionServer getRegionServer() {
            return this.regionServer;
        }

        public void waitForServerOnline() {
            this.regionServer.waitForServerOnline();
        }
    }
}

