/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class IncreasingToUpperBoundRegionSplitPolicy
extends ConstantSizeRegionSplitPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(IncreasingToUpperBoundRegionSplitPolicy.class);
    protected long initialSize;

    @Override
    protected void configureForRegion(HRegion region) {
        super.configureForRegion(region);
        Configuration conf = this.getConf();
        this.initialSize = conf.getLong("hbase.increasing.policy.initial.size", -1L);
        if (this.initialSize > 0L) {
            return;
        }
        TableDescriptor desc = region.getTableDescriptor();
        if (desc != null) {
            this.initialSize = 2L * desc.getMemStoreFlushSize();
        }
        if (this.initialSize <= 0L) {
            this.initialSize = 2L * conf.getLong("hbase.hregion.memstore.flush.size", 0x8000000L);
        }
    }

    @Override
    protected boolean shouldSplit() {
        boolean force = this.region.shouldForceSplit();
        boolean foundABigStore = false;
        int tableRegionsCount = this.getCountOfCommonTableRegions();
        long sizeToCheck = this.getSizeToCheck(tableRegionsCount);
        for (HStore store : this.region.getStores()) {
            if (!store.canSplit()) {
                return false;
            }
            long size = store.getSize();
            if (size <= sizeToCheck) continue;
            LOG.debug("ShouldSplit because " + store.getColumnFamilyName() + " size=" + StringUtils.humanSize((double)size) + ", sizeToCheck=" + StringUtils.humanSize((double)sizeToCheck) + ", regionsWithCommonTable=" + tableRegionsCount);
            foundABigStore = true;
        }
        return foundABigStore | force;
    }

    private int getCountOfCommonTableRegions() {
        RegionServerServices rss = this.region.getRegionServerServices();
        if (rss == null) {
            return 0;
        }
        TableName tablename = this.region.getTableDescriptor().getTableName();
        int tableRegionsCount = 0;
        try {
            List hri = rss.getRegions(tablename);
            tableRegionsCount = hri == null || hri.isEmpty() ? 0 : hri.size();
        }
        catch (IOException e) {
            LOG.debug("Failed getOnlineRegions " + tablename, (Throwable)e);
        }
        return tableRegionsCount;
    }

    protected long getSizeToCheck(int tableRegionsCount) {
        return tableRegionsCount == 0 || tableRegionsCount > 100 ? this.getDesiredMaxFileSize() : Math.min(this.getDesiredMaxFileSize(), this.initialSize * (long)tableRegionsCount * (long)tableRegionsCount * (long)tableRegionsCount);
    }
}

