/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CorruptHFileException;
import org.apache.hadoop.hbase.mob.MobCacheConfig;
import org.apache.hadoop.hbase.mob.MobConstants;
import org.apache.hadoop.hbase.mob.MobFile;
import org.apache.hadoop.hbase.mob.MobFileName;
import org.apache.hadoop.hbase.mob.MobStoreEngine;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MobReferenceOnlyFilter;
import org.apache.hadoop.hbase.regionserver.MobStoreScanner;
import org.apache.hadoop.hbase.regionserver.ReversedMobStoreScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.IdLock;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HMobStore
extends HStore {
    private static final Logger LOG = LoggerFactory.getLogger(HMobStore.class);
    private MobCacheConfig mobCacheConfig;
    private Path homePath;
    private Path mobFamilyPath;
    private volatile long cellsCountCompactedToMob = 0L;
    private volatile long cellsCountCompactedFromMob = 0L;
    private volatile long cellsSizeCompactedToMob = 0L;
    private volatile long cellsSizeCompactedFromMob = 0L;
    private volatile long mobFlushCount = 0L;
    private volatile long mobFlushedCellsCount = 0L;
    private volatile long mobFlushedCellsSize = 0L;
    private volatile long mobScanCellsCount = 0L;
    private volatile long mobScanCellsSize = 0L;
    private ColumnFamilyDescriptor family;
    private Map<String, List<Path>> map = new ConcurrentHashMap<String, List<Path>>();
    private final IdLock keyLock = new IdLock();
    private final byte[] refCellTags;

    public HMobStore(HRegion region, ColumnFamilyDescriptor family, Configuration confParam) throws IOException {
        super(region, family, confParam);
        this.family = family;
        this.mobCacheConfig = (MobCacheConfig)this.cacheConf;
        this.homePath = MobUtils.getMobHome(this.conf);
        this.mobFamilyPath = MobUtils.getMobFamilyPath(this.conf, this.getTableName(), family.getNameAsString());
        ArrayList<Path> locations = new ArrayList<Path>(2);
        locations.add(this.mobFamilyPath);
        TableName tn = region.getTableDescriptor().getTableName();
        locations.add(HFileArchiveUtil.getStoreArchivePath(this.conf, tn, MobUtils.getMobRegionInfo(tn).getEncodedName(), family.getNameAsString()));
        this.map.put(Bytes.toString((byte[])tn.getName()), locations);
        ArrayList<Object> tags = new ArrayList<Object>(2);
        tags.add(MobConstants.MOB_REF_TAG);
        ArrayBackedTag tableNameTag = new ArrayBackedTag(6, this.getTableName().getName());
        tags.add(tableNameTag);
        this.refCellTags = TagUtil.fromList(tags);
    }

    @Override
    protected void createCacheConf(ColumnFamilyDescriptor family) {
        this.cacheConf = new MobCacheConfig(this.conf, family);
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    protected KeyValueScanner createScanner(Scan scan, ScanInfo scanInfo, NavigableSet<byte[]> targetCols, long readPt) throws IOException {
        if (MobUtils.isRefOnlyScan(scan)) {
            MobReferenceOnlyFilter refOnlyFilter = new MobReferenceOnlyFilter();
            Filter filter = scan.getFilter();
            if (filter != null) {
                scan.setFilter((Filter)new FilterList(new Filter[]{filter, refOnlyFilter}));
            } else {
                scan.setFilter((Filter)refOnlyFilter);
            }
        }
        return scan.isReversed() ? new ReversedMobStoreScanner(this, scanInfo, scan, targetCols, readPt) : new MobStoreScanner(this, scanInfo, scan, targetCols, readPt);
    }

    @Override
    protected StoreEngine<?, ?, ?, ?> createStoreEngine(HStore store, Configuration conf, CellComparator cellComparator) throws IOException {
        MobStoreEngine engine = new MobStoreEngine();
        engine.createComponents(conf, store, cellComparator);
        return engine;
    }

    private Path getTempDir() {
        return new Path(this.homePath, ".tmp");
    }

    public StoreFileWriter createWriterInTmp(Date date, long maxKeyCount, Compression.Algorithm compression, byte[] startKey, boolean isCompaction) throws IOException {
        if (startKey == null) {
            startKey = HConstants.EMPTY_START_ROW;
        }
        Path path = this.getTempDir();
        return this.createWriterInTmp(MobUtils.formatDate(date), path, maxKeyCount, compression, startKey, isCompaction);
    }

    public StoreFileWriter createDelFileWriterInTmp(Date date, long maxKeyCount, Compression.Algorithm compression, byte[] startKey) throws IOException {
        if (startKey == null) {
            startKey = HConstants.EMPTY_START_ROW;
        }
        Path path = this.getTempDir();
        String suffix = UUID.randomUUID().toString().replaceAll("-", "") + "_del";
        MobFileName mobFileName = MobFileName.create(startKey, MobUtils.formatDate(date), suffix);
        return this.createWriterInTmp(mobFileName, path, maxKeyCount, compression, true);
    }

    public StoreFileWriter createWriterInTmp(String date, Path basePath, long maxKeyCount, Compression.Algorithm compression, byte[] startKey, boolean isCompaction) throws IOException {
        MobFileName mobFileName = MobFileName.create(startKey, date, UUID.randomUUID().toString().replaceAll("-", ""));
        return this.createWriterInTmp(mobFileName, basePath, maxKeyCount, compression, isCompaction);
    }

    public StoreFileWriter createWriterInTmp(MobFileName mobFileName, Path basePath, long maxKeyCount, Compression.Algorithm compression, boolean isCompaction) throws IOException {
        return MobUtils.createWriter(this.conf, this.region.getFilesystem(), this.family, new Path(basePath, mobFileName.getFileName()), maxKeyCount, compression, this.mobCacheConfig, this.cryptoContext, this.checksumType, this.bytesPerChecksum, this.blocksize, BloomType.NONE, isCompaction);
    }

    public void commitFile(Path sourceFile, Path targetPath) throws IOException {
        if (sourceFile == null) {
            return;
        }
        Path dstPath = new Path(targetPath, sourceFile.getName());
        this.validateMobFile(sourceFile);
        String msg = "Renaming flushed file from " + sourceFile + " to " + dstPath;
        LOG.info(msg);
        Path parent = dstPath.getParent();
        if (!this.region.getFilesystem().exists(parent)) {
            this.region.getFilesystem().mkdirs(parent);
        }
        if (!this.region.getFilesystem().rename(sourceFile, dstPath)) {
            throw new IOException("Failed rename of " + sourceFile + " to " + dstPath);
        }
    }

    private void validateMobFile(Path path) throws IOException {
        HStoreFile storeFile = null;
        try {
            storeFile = new HStoreFile(this.region.getFilesystem(), path, this.conf, (CacheConfig)this.mobCacheConfig, BloomType.NONE, this.isPrimaryReplicaStore());
            storeFile.initReader();
        }
        catch (IOException e) {
            LOG.error("Fail to open mob file[" + path + "], keep it in temp directory.", (Throwable)e);
            throw e;
        }
        finally {
            if (storeFile != null) {
                storeFile.closeStoreFile(false);
            }
        }
    }

    public Cell resolve(Cell reference, boolean cacheBlocks) throws IOException {
        return this.resolve(reference, cacheBlocks, -1L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cell resolve(Cell reference, boolean cacheBlocks, long readPt, boolean readEmptyValueOnMobCellMiss) throws IOException {
        Cell result = null;
        if (MobUtils.hasValidMobRefCellValue(reference)) {
            String fileName = MobUtils.getMobFileName(reference);
            Tag tableNameTag = MobUtils.getTableNameTag(reference);
            if (tableNameTag != null) {
                String tableNameString = Tag.getValueAsString((Tag)tableNameTag);
                List<Path> locations = this.map.get(tableNameString);
                if (locations == null) {
                    IdLock.Entry lockEntry = this.keyLock.getLockEntry(tableNameString.hashCode());
                    try {
                        locations = this.map.get(tableNameString);
                        if (locations == null) {
                            locations = new ArrayList<Path>(2);
                            TableName tn = TableName.valueOf((String)tableNameString);
                            locations.add(MobUtils.getMobFamilyPath(this.conf, tn, this.family.getNameAsString()));
                            locations.add(HFileArchiveUtil.getStoreArchivePath(this.conf, tn, MobUtils.getMobRegionInfo(tn).getEncodedName(), this.family.getNameAsString()));
                            this.map.put(tableNameString, locations);
                        }
                    }
                    finally {
                        this.keyLock.releaseLockEntry(lockEntry);
                    }
                }
                result = this.readCell(locations, fileName, reference, cacheBlocks, readPt, readEmptyValueOnMobCellMiss);
            }
        }
        if (result == null) {
            LOG.warn("The Cell result is null, assemble a new Cell with the same row,family,qualifier,timestamp,type and tags but with an empty value to return.");
            result = ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(reference.getRowArray(), reference.getRowOffset(), (int)reference.getRowLength()).setFamily(reference.getFamilyArray(), reference.getFamilyOffset(), (int)reference.getFamilyLength()).setQualifier(reference.getQualifierArray(), reference.getQualifierOffset(), reference.getQualifierLength()).setTimestamp(reference.getTimestamp()).setType(reference.getTypeByte()).setValue(HConstants.EMPTY_BYTE_ARRAY).setTags(reference.getTagsArray(), reference.getTagsOffset(), reference.getTagsLength()).build();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cell readCell(List<Path> locations, String fileName, Cell search, boolean cacheMobBlocks, long readPt, boolean readEmptyValueOnMobCellMiss) throws IOException {
        FileSystem fs = this.getFileSystem();
        Object throwable = null;
        for (Path location : locations) {
            MobFile file = null;
            Path path = new Path(location, fileName);
            try {
                file = this.mobCacheConfig.getMobFileCache().openFile(fs, path, this.mobCacheConfig);
                Cell cell = readPt != -1L ? file.readCell(search, cacheMobBlocks, readPt) : file.readCell(search, cacheMobBlocks);
                return cell;
            }
            catch (IOException e) {
                this.mobCacheConfig.getMobFileCache().evictFile(fileName);
                throwable = e;
                if (e instanceof FileNotFoundException || e.getCause() instanceof FileNotFoundException) {
                    LOG.debug("Fail to read the cell, the mob file " + path + " doesn't exist", (Throwable)e);
                    continue;
                }
                if (e instanceof CorruptHFileException) {
                    LOG.error("The mob file " + path + " is corrupt", (Throwable)e);
                    break;
                }
                throw e;
            }
            catch (NullPointerException e) {
                this.mobCacheConfig.getMobFileCache().evictFile(fileName);
                LOG.debug("Fail to read the cell", (Throwable)e);
                throwable = e;
            }
            catch (AssertionError e) {
                this.mobCacheConfig.getMobFileCache().evictFile(fileName);
                LOG.debug("Fail to read the cell", (Throwable)((Object)e));
                throwable = e;
            }
            finally {
                if (file == null) continue;
                this.mobCacheConfig.getMobFileCache().closeFile(file);
            }
        }
        LOG.error("The mob file " + fileName + " could not be found in the locations " + locations + " or it is corrupt");
        if (readEmptyValueOnMobCellMiss) {
            return null;
        }
        if (throwable instanceof FileNotFoundException || ((Throwable)throwable).getCause() instanceof FileNotFoundException) {
            throw new DoNotRetryIOException((Throwable)throwable);
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        throw new IOException((Throwable)throwable);
    }

    public Path getPath() {
        return this.mobFamilyPath;
    }

    public void updateCellsCountCompactedToMob(long count) {
        this.cellsCountCompactedToMob += count;
    }

    public long getCellsCountCompactedToMob() {
        return this.cellsCountCompactedToMob;
    }

    public void updateCellsCountCompactedFromMob(long count) {
        this.cellsCountCompactedFromMob += count;
    }

    public long getCellsCountCompactedFromMob() {
        return this.cellsCountCompactedFromMob;
    }

    public void updateCellsSizeCompactedToMob(long size) {
        this.cellsSizeCompactedToMob += size;
    }

    public long getCellsSizeCompactedToMob() {
        return this.cellsSizeCompactedToMob;
    }

    public void updateCellsSizeCompactedFromMob(long size) {
        this.cellsSizeCompactedFromMob += size;
    }

    public long getCellsSizeCompactedFromMob() {
        return this.cellsSizeCompactedFromMob;
    }

    @SuppressWarnings(value={"VO_VOLATILE_INCREMENT"})
    public void updateMobFlushCount() {
        ++this.mobFlushCount;
    }

    public long getMobFlushCount() {
        return this.mobFlushCount;
    }

    public void updateMobFlushedCellsCount(long count) {
        this.mobFlushedCellsCount += count;
    }

    public long getMobFlushedCellsCount() {
        return this.mobFlushedCellsCount;
    }

    public void updateMobFlushedCellsSize(long size) {
        this.mobFlushedCellsSize += size;
    }

    public long getMobFlushedCellsSize() {
        return this.mobFlushedCellsSize;
    }

    public void updateMobScanCellsCount(long count) {
        this.mobScanCellsCount += count;
    }

    public long getMobScanCellsCount() {
        return this.mobScanCellsCount;
    }

    public void updateMobScanCellsSize(long size) {
        this.mobScanCellsSize += size;
    }

    public long getMobScanCellsSize() {
        return this.mobScanCellsSize;
    }

    public byte[] getRefCellTags() {
        return this.refCellTags;
    }
}

