/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.regionserver.FlushPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public abstract class FlushLargeStoresPolicy
extends FlushPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(FlushLargeStoresPolicy.class);
    public static final String HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND = "hbase.hregion.percolumnfamilyflush.size.lower.bound";
    public static final String HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND_MIN = "hbase.hregion.percolumnfamilyflush.size.lower.bound.min";
    public static final long DEFAULT_HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND_MIN = 0x1000000L;
    protected long flushSizeLowerBound = -1L;

    protected long getFlushSizeLowerBound(HRegion region) {
        String flushedSizeLowerBoundString;
        int familyNumber = region.getTableDescriptor().getColumnFamilyCount();
        long flushSizeLowerBound = region.getMemStoreFlushSize() / (long)familyNumber;
        long minimumLowerBound = this.getConf().getLong(HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND_MIN, 0x1000000L);
        if (minimumLowerBound > flushSizeLowerBound) {
            flushSizeLowerBound = minimumLowerBound;
        }
        if ((flushedSizeLowerBoundString = region.getTableDescriptor().getValue(HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND)) == null) {
            LOG.debug("No {} set in table {} descriptor;using region.getMemStoreFlushSize/# of families ({}) instead.", new Object[]{HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND, region.getTableDescriptor().getTableName(), StringUtils.humanSize((double)flushSizeLowerBound) + ")"});
        } else {
            try {
                flushSizeLowerBound = Long.parseLong(flushedSizeLowerBoundString);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Number format exception parsing {} for table {}: {}, {}; using region.getMemStoreFlushSize/# of families ({}) instead.", new Object[]{HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND, region.getTableDescriptor().getTableName(), flushedSizeLowerBoundString, nfe, flushSizeLowerBound});
            }
        }
        return flushSizeLowerBound;
    }

    protected boolean shouldFlush(HStore store) {
        if (store.getMemStoreSize().getDataSize() > this.flushSizeLowerBound) {
            LOG.debug("Flush {} of {}; memstoreSize={} > lowerBound={}", new Object[]{store.getColumnFamilyName(), this.region.getRegionInfo().getEncodedName(), store.getMemStoreSize().getDataSize(), this.flushSizeLowerBound});
            return true;
        }
        return false;
    }
}

