/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.locking.LockProcedure;
import org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.LockAndQueue;
import org.apache.hadoop.hbase.procedure2.LockStatus;
import org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.hadoop.hbase.procedure2.LockedResource;
import org.apache.hadoop.hbase.procedure2.LockedResourceType;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureDeque;
import org.apache.hadoop.hbase.util.AvlUtil;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MasterProcedureScheduler
extends AbstractProcedureScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(MasterProcedureScheduler.class);
    private static final ServerQueueKeyComparator SERVER_QUEUE_KEY_COMPARATOR = new ServerQueueKeyComparator();
    private static final TableQueueKeyComparator TABLE_QUEUE_KEY_COMPARATOR = new TableQueueKeyComparator();
    private final FairQueue<ServerName> serverRunQueue = new FairQueue();
    private final FairQueue<TableName> tableRunQueue = new FairQueue();
    private final ServerQueue[] serverBuckets = new ServerQueue[128];
    private TableQueue tableMap = null;
    private final SchemaLocking locking = new SchemaLocking();
    private final TablePriorities tablePriorities;

    public MasterProcedureScheduler(Configuration conf) {
        this.tablePriorities = new TablePriorities(conf);
    }

    public void yield(Procedure proc) {
        this.push(proc, MasterProcedureScheduler.isTableProcedure(proc), true);
    }

    protected void enqueue(Procedure proc, boolean addFront) {
        if (MasterProcedureScheduler.isTableProcedure(proc)) {
            this.doAdd(this.tableRunQueue, this.getTableQueue(MasterProcedureScheduler.getTableName(proc)), proc, addFront);
        } else if (MasterProcedureScheduler.isServerProcedure(proc)) {
            this.doAdd(this.serverRunQueue, this.getServerQueue(MasterProcedureScheduler.getServerName(proc)), proc, addFront);
        } else {
            throw new UnsupportedOperationException("RQs for non-table/non-server procedures are not implemented yet: " + proc);
        }
    }

    private <T extends Comparable<T>> void doAdd(FairQueue<T> fairq, Queue<T> queue, Procedure proc, boolean addFront) {
        queue.add(proc, addFront);
        if (!queue.getLockStatus().hasExclusiveLock() || queue.getLockStatus().isLockOwner(proc.getProcId())) {
            MasterProcedureScheduler.addToRunQueue(fairq, queue);
        } else if (queue.getLockStatus().hasParentLock(proc)) {
            assert (addFront) : "expected to add a child in the front";
            MasterProcedureScheduler.addToRunQueue(fairq, queue);
        }
    }

    protected boolean queueHasRunnables() {
        return this.tableRunQueue.hasRunnables() || this.serverRunQueue.hasRunnables();
    }

    protected Procedure dequeue() {
        Procedure pollResult = this.doPoll(this.serverRunQueue);
        if (pollResult == null) {
            pollResult = this.doPoll(this.tableRunQueue);
        }
        return pollResult;
    }

    private <T extends Comparable<T>> Procedure doPoll(FairQueue<T> fairq) {
        Procedure nextProc;
        Queue<T> rq = fairq.poll();
        if (rq == null || !rq.isAvailable()) {
            return null;
        }
        Procedure pollResult = rq.peek();
        if (pollResult == null) {
            return null;
        }
        boolean xlockReq = rq.requireExclusiveLock(pollResult);
        if (xlockReq && rq.getLockStatus().isLocked() && !rq.getLockStatus().hasLockAccess(pollResult)) {
            MasterProcedureScheduler.removeFromRunQueue(fairq, rq);
            return null;
        }
        rq.poll();
        if (rq.isEmpty() || xlockReq) {
            MasterProcedureScheduler.removeFromRunQueue(fairq, rq);
        } else if (rq.getLockStatus().hasParentLock(pollResult) && (nextProc = rq.peek()) != null && !Procedure.haveSameParent((Procedure)nextProc, (Procedure)pollResult)) {
            MasterProcedureScheduler.removeFromRunQueue(fairq, rq);
        }
        return pollResult;
    }

    private LockedResource createLockedResource(LockedResourceType resourceType, String resourceName, LockAndQueue queue) {
        int sharedLockCount;
        Procedure exclusiveLockOwnerProcedure;
        LockType lockType;
        if (queue.hasExclusiveLock()) {
            lockType = LockType.EXCLUSIVE;
            exclusiveLockOwnerProcedure = queue.getExclusiveLockOwnerProcedure();
            sharedLockCount = 0;
        } else {
            lockType = LockType.SHARED;
            exclusiveLockOwnerProcedure = null;
            sharedLockCount = queue.getSharedLockCount();
        }
        ArrayList<Procedure> waitingProcedures = new ArrayList<Procedure>();
        for (Procedure procedure : queue) {
            if (!(procedure instanceof LockProcedure)) continue;
            waitingProcedures.add(procedure);
        }
        return new LockedResource(resourceType, resourceName, lockType, exclusiveLockOwnerProcedure, sharedLockCount, waitingProcedures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LockedResource> getLocks() {
        this.schedLock();
        try {
            LockedResource lockedResource;
            LockAndQueue queue;
            ArrayList<LockedResource> lockedResources = new ArrayList<LockedResource>();
            for (Map.Entry<ServerName, LockAndQueue> entry : this.locking.serverLocks.entrySet()) {
                String serverName = entry.getKey().getServerName();
                queue = entry.getValue();
                if (!queue.isLocked()) continue;
                lockedResource = this.createLockedResource(LockedResourceType.SERVER, serverName, queue);
                lockedResources.add(lockedResource);
            }
            for (Map.Entry<Object, LockAndQueue> entry : this.locking.namespaceLocks.entrySet()) {
                String namespaceName = (String)entry.getKey();
                queue = entry.getValue();
                if (!queue.isLocked()) continue;
                lockedResource = this.createLockedResource(LockedResourceType.NAMESPACE, namespaceName, queue);
                lockedResources.add(lockedResource);
            }
            for (Map.Entry<Object, LockAndQueue> entry : this.locking.tableLocks.entrySet()) {
                String tableName = ((TableName)entry.getKey()).getNameAsString();
                queue = entry.getValue();
                if (!queue.isLocked()) continue;
                lockedResource = this.createLockedResource(LockedResourceType.TABLE, tableName, queue);
                lockedResources.add(lockedResource);
            }
            for (Map.Entry<Object, LockAndQueue> entry : this.locking.regionLocks.entrySet()) {
                String regionName = (String)entry.getKey();
                queue = entry.getValue();
                if (!queue.isLocked()) continue;
                lockedResource = this.createLockedResource(LockedResourceType.REGION, regionName, queue);
                lockedResources.add(lockedResource);
            }
            ArrayList<LockedResource> arrayList = lockedResources;
            return arrayList;
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockedResource getLockResource(LockedResourceType resourceType, String resourceName) {
        LockAndQueue queue = null;
        this.schedLock();
        try {
            switch (resourceType) {
                case SERVER: {
                    queue = this.locking.serverLocks.get(ServerName.valueOf((String)resourceName));
                    break;
                }
                case NAMESPACE: {
                    queue = this.locking.namespaceLocks.get(resourceName);
                    break;
                }
                case TABLE: {
                    queue = this.locking.tableLocks.get(TableName.valueOf((String)resourceName));
                    break;
                }
                case REGION: {
                    queue = this.locking.regionLocks.get(resourceName);
                }
            }
            LockedResource lockedResource = queue != null ? this.createLockedResource(resourceType, resourceName, queue) : null;
            return lockedResource;
        }
        finally {
            this.schedUnlock();
        }
    }

    public void clear() {
        this.schedLock();
        try {
            this.clearQueue();
            this.locking.clear();
        }
        finally {
            this.schedUnlock();
        }
    }

    protected void clearQueue() {
        for (int i = 0; i < this.serverBuckets.length; ++i) {
            this.clear(this.serverBuckets[i], this.serverRunQueue, SERVER_QUEUE_KEY_COMPARATOR);
            this.serverBuckets[i] = null;
        }
        this.clear(this.tableMap, this.tableRunQueue, TABLE_QUEUE_KEY_COMPARATOR);
        this.tableMap = null;
        assert (this.size() == 0) : "expected queue size to be 0, got " + this.size();
    }

    private <T extends Comparable<T>, TNode extends Queue<T>> void clear(TNode treeMap, FairQueue<T> fairq, AvlUtil.AvlKeyComparator<TNode> comparator) {
        while (treeMap != null) {
            Queue node = (Queue)AvlUtil.AvlTree.getFirst(treeMap);
            treeMap = (Queue)AvlUtil.AvlTree.remove(treeMap, node.getKey(), comparator);
            if (fairq == null) continue;
            MasterProcedureScheduler.removeFromRunQueue(fairq, node);
        }
    }

    protected int queueSize() {
        int count = 0;
        AvlUtil.AvlTreeIterator serverIter = new AvlUtil.AvlTreeIterator();
        for (int i = 0; i < this.serverBuckets.length; ++i) {
            serverIter.seekFirst((AvlUtil.AvlNode)this.serverBuckets[i]);
            while (serverIter.hasNext()) {
                count += ((ServerQueue)serverIter.next()).size();
            }
        }
        AvlUtil.AvlTreeIterator tableIter = new AvlUtil.AvlTreeIterator((AvlUtil.AvlNode)this.tableMap);
        while (tableIter.hasNext()) {
            count += ((TableQueue)tableIter.next()).size();
        }
        return count;
    }

    public void completionCleanup(Procedure proc) {
        if (proc instanceof TableProcedureInterface) {
            boolean tableDeleted;
            TableProcedureInterface iProcTable = (TableProcedureInterface)proc;
            if (proc.hasException()) {
                Exception procEx = proc.getException().unwrapRemoteException();
                tableDeleted = iProcTable.getTableOperationType() == TableProcedureInterface.TableOperationType.CREATE ? !(procEx instanceof TableExistsException) : procEx instanceof TableNotFoundException;
            } else {
                boolean bl = tableDeleted = iProcTable.getTableOperationType() == TableProcedureInterface.TableOperationType.DELETE;
            }
            if (tableDeleted) {
                this.markTableAsDeleted(iProcTable.getTableName(), proc);
                return;
            }
        } else {
            return;
        }
    }

    private static <T extends Comparable<T>> void addToRunQueue(FairQueue<T> fairq, Queue<T> queue) {
        if (!AvlUtil.AvlIterableList.isLinked(queue) && !queue.isEmpty()) {
            fairq.add(queue);
        }
    }

    private static <T extends Comparable<T>> void removeFromRunQueue(FairQueue<T> fairq, Queue<T> queue) {
        if (AvlUtil.AvlIterableList.isLinked(queue)) {
            fairq.remove(queue);
        }
    }

    private TableQueue getTableQueue(TableName tableName) {
        TableQueue node = (TableQueue)AvlUtil.AvlTree.get((AvlUtil.AvlNode)this.tableMap, (Object)tableName, (AvlUtil.AvlKeyComparator)TABLE_QUEUE_KEY_COMPARATOR);
        if (node != null) {
            return node;
        }
        node = new TableQueue(tableName, this.tablePriorities.getPriority(tableName), (LockStatus)this.locking.getTableLock(tableName), (LockStatus)this.locking.getNamespaceLock(tableName.getNamespaceAsString()));
        this.tableMap = (TableQueue)AvlUtil.AvlTree.insert((AvlUtil.AvlNode)this.tableMap, (AvlUtil.AvlNode)node);
        return node;
    }

    private void removeTableQueue(TableName tableName) {
        this.tableMap = (TableQueue)AvlUtil.AvlTree.remove((AvlUtil.AvlNode)this.tableMap, (Object)tableName, (AvlUtil.AvlKeyComparator)TABLE_QUEUE_KEY_COMPARATOR);
        this.locking.removeTableLock(tableName);
    }

    private static boolean isTableProcedure(Procedure proc) {
        return proc instanceof TableProcedureInterface;
    }

    private static TableName getTableName(Procedure proc) {
        return ((TableProcedureInterface)proc).getTableName();
    }

    private ServerQueue getServerQueue(ServerName serverName) {
        int index = MasterProcedureScheduler.getBucketIndex((Object[])this.serverBuckets, serverName.hashCode());
        ServerQueue node = (ServerQueue)AvlUtil.AvlTree.get((AvlUtil.AvlNode)this.serverBuckets[index], (Object)serverName, (AvlUtil.AvlKeyComparator)SERVER_QUEUE_KEY_COMPARATOR);
        if (node != null) {
            return node;
        }
        node = new ServerQueue(serverName, (LockStatus)this.locking.getServerLock(serverName));
        this.serverBuckets[index] = (ServerQueue)AvlUtil.AvlTree.insert((AvlUtil.AvlNode)this.serverBuckets[index], (AvlUtil.AvlNode)node);
        return node;
    }

    private static int getBucketIndex(Object[] buckets, int hashCode) {
        return Math.abs(hashCode) % buckets.length;
    }

    private static boolean isServerProcedure(Procedure proc) {
        return proc instanceof ServerProcedureInterface;
    }

    private static ServerName getServerName(Procedure proc) {
        return ((ServerProcedureInterface)proc).getServerName();
    }

    private static boolean requireTableExclusiveLock(TableProcedureInterface proc) {
        switch (proc.getTableOperationType()) {
            case CREATE: 
            case DELETE: 
            case DISABLE: 
            case ENABLE: {
                return true;
            }
            case EDIT: {
                return !proc.getTableName().equals((Object)TableName.NAMESPACE_TABLE_NAME);
            }
            case READ: {
                return false;
            }
            case REGION_SPLIT: 
            case REGION_MERGE: 
            case REGION_ASSIGN: 
            case REGION_UNASSIGN: 
            case REGION_EDIT: 
            case REGION_GC: 
            case MERGED_REGIONS_GC: {
                return false;
            }
        }
        throw new UnsupportedOperationException("unexpected type " + (Object)((Object)proc.getTableOperationType()));
    }

    protected void logLockedResource(LockedResourceType resourceType, String resourceName) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LockedResource lockedResource = this.getLockResource(resourceType, resourceName);
        if (lockedResource != null) {
            String msg = resourceType.toString() + " '" + resourceName + "', shared lock count=" + lockedResource.getSharedLockCount();
            Procedure proc = lockedResource.getExclusiveLockOwnerProcedure();
            if (proc != null) {
                msg = msg + ", exclusively locked by procId=" + proc.getProcId();
            }
            LOG.debug(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitTableExclusiveLock(Procedure procedure, TableName table) {
        this.schedLock();
        try {
            String namespace = table.getNamespaceAsString();
            LockAndQueue namespaceLock = this.locking.getNamespaceLock(namespace);
            LockAndQueue tableLock = this.locking.getTableLock(table);
            if (!namespaceLock.trySharedLock()) {
                this.waitProcedure((ProcedureDeque)namespaceLock, procedure);
                this.logLockedResource(LockedResourceType.NAMESPACE, namespace);
                boolean bl = true;
                return bl;
            }
            if (!tableLock.tryExclusiveLock(procedure)) {
                namespaceLock.releaseSharedLock();
                this.waitProcedure((ProcedureDeque)tableLock, procedure);
                this.logLockedResource(LockedResourceType.TABLE, table.getNameAsString());
                boolean bl = true;
                return bl;
            }
            MasterProcedureScheduler.removeFromRunQueue(this.tableRunQueue, this.getTableQueue(table));
            boolean bl = false;
            return bl;
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeTableExclusiveLock(Procedure procedure, TableName table) {
        this.schedLock();
        try {
            LockAndQueue namespaceLock = this.locking.getNamespaceLock(table.getNamespaceAsString());
            LockAndQueue tableLock = this.locking.getTableLock(table);
            int waitingCount = 0;
            if (!tableLock.hasParentLock(procedure)) {
                tableLock.releaseExclusiveLock(procedure);
                waitingCount += this.wakeWaitingProcedures((ProcedureDeque)tableLock);
            }
            if (namespaceLock.releaseSharedLock()) {
                waitingCount += this.wakeWaitingProcedures((ProcedureDeque)namespaceLock);
            }
            MasterProcedureScheduler.addToRunQueue(this.tableRunQueue, this.getTableQueue(table));
            this.wakePollIfNeeded(waitingCount);
        }
        finally {
            this.schedUnlock();
        }
    }

    public boolean waitTableSharedLock(Procedure procedure, TableName table) {
        return this.waitTableQueueSharedLock(procedure, table) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableQueue waitTableQueueSharedLock(Procedure procedure, TableName table) {
        this.schedLock();
        try {
            LockAndQueue namespaceLock = this.locking.getNamespaceLock(table.getNamespaceAsString());
            LockAndQueue tableLock = this.locking.getTableLock(table);
            if (!namespaceLock.trySharedLock()) {
                this.waitProcedure((ProcedureDeque)namespaceLock, procedure);
                TableQueue tableQueue = null;
                return tableQueue;
            }
            if (!tableLock.trySharedLock()) {
                namespaceLock.releaseSharedLock();
                this.waitProcedure((ProcedureDeque)tableLock, procedure);
                TableQueue tableQueue = null;
                return tableQueue;
            }
            TableQueue tableQueue = this.getTableQueue(table);
            return tableQueue;
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeTableSharedLock(Procedure procedure, TableName table) {
        this.schedLock();
        try {
            LockAndQueue namespaceLock = this.locking.getNamespaceLock(table.getNamespaceAsString());
            LockAndQueue tableLock = this.locking.getTableLock(table);
            int waitingCount = 0;
            if (tableLock.releaseSharedLock()) {
                MasterProcedureScheduler.addToRunQueue(this.tableRunQueue, this.getTableQueue(table));
                waitingCount += this.wakeWaitingProcedures((ProcedureDeque)tableLock);
            }
            if (namespaceLock.releaseSharedLock()) {
                waitingCount += this.wakeWaitingProcedures((ProcedureDeque)namespaceLock);
            }
            this.wakePollIfNeeded(waitingCount);
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected boolean markTableAsDeleted(TableName table, Procedure procedure) {
        block7: {
            this.schedLock();
            try {
                TableQueue queue = this.getTableQueue(table);
                LockAndQueue tableLock = this.locking.getTableLock(table);
                if (queue == null) {
                    boolean bl = true;
                    return bl;
                }
                if (queue.isEmpty() && tableLock.tryExclusiveLock(procedure)) {
                    if (AvlUtil.AvlIterableList.isLinked((AvlUtil.AvlLinkedNode)queue)) {
                        this.tableRunQueue.remove(queue);
                    }
                    this.removeTableQueue(table);
                    break block7;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.schedUnlock();
            }
        }
        return true;
    }

    public boolean waitRegion(Procedure procedure, RegionInfo regionInfo) {
        return this.waitRegions(procedure, regionInfo.getTable(), regionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitRegions(Procedure procedure, TableName table, RegionInfo ... regionInfo) {
        Arrays.sort(regionInfo, RegionInfo.COMPARATOR);
        this.schedLock();
        try {
            if (!procedure.hasParent() && this.waitTableQueueSharedLock(procedure, table) == null) {
                boolean bl = true;
                return bl;
            }
            boolean hasLock = true;
            LockAndQueue[] regionLocks = new LockAndQueue[regionInfo.length];
            for (int i = 0; i < regionInfo.length; ++i) {
                LOG.info(procedure + " " + table + " " + regionInfo[i].getRegionNameAsString());
                assert (table != null);
                assert (regionInfo[i] != null);
                assert (regionInfo[i].getTable() != null);
                assert (regionInfo[i].getTable().equals((Object)table)) : regionInfo[i] + " " + procedure;
                assert (i == 0 || regionInfo[i] != regionInfo[i - 1]) : "duplicate region: " + regionInfo[i];
                regionLocks[i] = this.locking.getRegionLock(regionInfo[i].getEncodedName());
                if (regionLocks[i].tryExclusiveLock(procedure)) continue;
                this.waitProcedure((ProcedureDeque)regionLocks[i], procedure);
                hasLock = false;
                while (i-- > 0) {
                    regionLocks[i].releaseExclusiveLock(procedure);
                }
                break;
            }
            if (!hasLock && !procedure.hasParent()) {
                this.wakeTableSharedLock(procedure, table);
            }
            boolean bl = !hasLock;
            return bl;
        }
        finally {
            this.schedUnlock();
        }
    }

    public void wakeRegion(Procedure procedure, RegionInfo regionInfo) {
        this.wakeRegions(procedure, regionInfo.getTable(), regionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeRegions(Procedure procedure, TableName table, RegionInfo ... regionInfo) {
        Arrays.sort(regionInfo, RegionInfo.COMPARATOR);
        this.schedLock();
        try {
            int i;
            int numProcs = 0;
            Procedure[] nextProcs = new Procedure[regionInfo.length];
            for (i = 0; i < regionInfo.length; ++i) {
                assert (regionInfo[i].getTable().equals((Object)table));
                assert (i == 0 || regionInfo[i] != regionInfo[i - 1]) : "duplicate region: " + regionInfo[i];
                LockAndQueue regionLock = this.locking.getRegionLock(regionInfo[i].getEncodedName());
                if (!regionLock.releaseExclusiveLock(procedure)) continue;
                if (!regionLock.isEmpty()) {
                    nextProcs[numProcs++] = (Procedure)regionLock.removeFirst();
                    continue;
                }
                this.locking.removeRegionLock(regionInfo[i].getEncodedName());
            }
            for (i = numProcs - 1; i >= 0; --i) {
                this.wakeProcedure(nextProcs[i]);
            }
            this.wakePollIfNeeded(numProcs);
            if (!procedure.hasParent()) {
                this.wakeTableSharedLock(procedure, table);
            }
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitNamespaceExclusiveLock(Procedure procedure, String namespace) {
        this.schedLock();
        try {
            LockAndQueue systemNamespaceTableLock = this.locking.getTableLock(TableName.NAMESPACE_TABLE_NAME);
            if (!systemNamespaceTableLock.trySharedLock()) {
                this.waitProcedure((ProcedureDeque)systemNamespaceTableLock, procedure);
                this.logLockedResource(LockedResourceType.TABLE, TableName.NAMESPACE_TABLE_NAME.getNameAsString());
                boolean bl = true;
                return bl;
            }
            LockAndQueue namespaceLock = this.locking.getNamespaceLock(namespace);
            if (!namespaceLock.tryExclusiveLock(procedure)) {
                systemNamespaceTableLock.releaseSharedLock();
                this.waitProcedure((ProcedureDeque)namespaceLock, procedure);
                this.logLockedResource(LockedResourceType.NAMESPACE, namespace);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeNamespaceExclusiveLock(Procedure procedure, String namespace) {
        this.schedLock();
        try {
            LockAndQueue namespaceLock = this.locking.getNamespaceLock(namespace);
            LockAndQueue systemNamespaceTableLock = this.locking.getTableLock(TableName.NAMESPACE_TABLE_NAME);
            namespaceLock.releaseExclusiveLock(procedure);
            int waitingCount = 0;
            if (systemNamespaceTableLock.releaseSharedLock()) {
                MasterProcedureScheduler.addToRunQueue(this.tableRunQueue, this.getTableQueue(TableName.NAMESPACE_TABLE_NAME));
                waitingCount += this.wakeWaitingProcedures((ProcedureDeque)systemNamespaceTableLock);
            }
            this.wakePollIfNeeded(waitingCount += this.wakeWaitingProcedures((ProcedureDeque)namespaceLock));
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitServerExclusiveLock(Procedure procedure, ServerName serverName) {
        this.schedLock();
        try {
            LockAndQueue lock = this.locking.getServerLock(serverName);
            if (lock.tryExclusiveLock(procedure)) {
                MasterProcedureScheduler.removeFromRunQueue(this.serverRunQueue, this.getServerQueue(serverName));
                boolean bl = false;
                return bl;
            }
            this.waitProcedure((ProcedureDeque)lock, procedure);
            this.logLockedResource(LockedResourceType.SERVER, serverName.getServerName());
            boolean bl = true;
            return bl;
        }
        finally {
            this.schedUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeServerExclusiveLock(Procedure procedure, ServerName serverName) {
        this.schedLock();
        try {
            LockAndQueue lock = this.locking.getServerLock(serverName);
            lock.releaseExclusiveLock(procedure);
            MasterProcedureScheduler.addToRunQueue(this.serverRunQueue, this.getServerQueue(serverName));
            int waitingCount = this.wakeWaitingProcedures((ProcedureDeque)lock);
            this.wakePollIfNeeded(waitingCount);
        }
        finally {
            this.schedUnlock();
        }
    }

    @VisibleForTesting
    public String dumpLocks() throws IOException {
        this.schedLock();
        try {
            String string = this.locking.toString();
            return string;
        }
        finally {
            this.schedUnlock();
        }
    }

    private static class FairQueue<T extends Comparable<T>> {
        private final int quantum;
        private Queue<T> currentQueue = null;
        private Queue<T> queueHead = null;
        private int currentQuantum = 0;
        private int size = 0;

        public FairQueue() {
            this(1);
        }

        public FairQueue(int quantum) {
            this.quantum = quantum;
        }

        public boolean hasRunnables() {
            return this.size > 0;
        }

        public void add(Queue<T> queue) {
            this.queueHead = (Queue)AvlUtil.AvlIterableList.append(this.queueHead, queue);
            if (this.currentQueue == null) {
                this.setNextQueue(this.queueHead);
            }
            ++this.size;
        }

        public void remove(Queue<T> queue) {
            Queue nextQueue = (Queue)AvlUtil.AvlIterableList.readNext(queue);
            this.queueHead = (Queue)AvlUtil.AvlIterableList.remove(this.queueHead, queue);
            if (this.currentQueue == queue) {
                this.setNextQueue(this.queueHead != null ? nextQueue : null);
            }
            --this.size;
        }

        public Queue<T> poll() {
            if (this.currentQuantum == 0) {
                if (!this.nextQueue()) {
                    return null;
                }
                this.currentQuantum = this.calculateQuantum(this.currentQueue) - 1;
            } else {
                --this.currentQuantum;
            }
            if (!this.currentQueue.isAvailable()) {
                Queue<T> lastQueue = this.currentQueue;
                do {
                    if (this.nextQueue()) continue;
                    return null;
                } while (this.currentQueue != lastQueue && !this.currentQueue.isAvailable());
                this.currentQuantum = this.calculateQuantum(this.currentQueue) - 1;
            }
            return this.currentQueue;
        }

        private boolean nextQueue() {
            if (this.currentQueue == null) {
                return false;
            }
            this.currentQueue = (Queue)AvlUtil.AvlIterableList.readNext(this.currentQueue);
            return this.currentQueue != null;
        }

        private void setNextQueue(Queue<T> queue) {
            this.currentQueue = queue;
            this.currentQuantum = queue != null ? this.calculateQuantum(this.currentQueue) : 0;
        }

        private int calculateQuantum(Queue queue) {
            return Math.max(1, queue.getPriority() * this.quantum);
        }
    }

    private static class SchemaLocking {
        final Map<ServerName, LockAndQueue> serverLocks = new HashMap<ServerName, LockAndQueue>();
        final Map<String, LockAndQueue> namespaceLocks = new HashMap<String, LockAndQueue>();
        final Map<TableName, LockAndQueue> tableLocks = new HashMap<TableName, LockAndQueue>();
        final Map<String, LockAndQueue> regionLocks = new HashMap<String, LockAndQueue>();

        private SchemaLocking() {
        }

        private <T> LockAndQueue getLock(Map<T, LockAndQueue> map, T key) {
            LockAndQueue lock = map.get(key);
            if (lock == null) {
                lock = new LockAndQueue();
                map.put(key, lock);
            }
            return lock;
        }

        LockAndQueue getTableLock(TableName tableName) {
            return this.getLock(this.tableLocks, tableName);
        }

        LockAndQueue removeTableLock(TableName tableName) {
            return this.tableLocks.remove(tableName);
        }

        LockAndQueue getNamespaceLock(String namespace) {
            return this.getLock(this.namespaceLocks, namespace);
        }

        LockAndQueue getRegionLock(String encodedRegionName) {
            return this.getLock(this.regionLocks, encodedRegionName);
        }

        LockAndQueue removeRegionLock(String encodedRegionName) {
            return this.regionLocks.remove(encodedRegionName);
        }

        LockAndQueue getServerLock(ServerName serverName) {
            return this.getLock(this.serverLocks, serverName);
        }

        @VisibleForTesting
        void clear() {
            this.serverLocks.clear();
            this.namespaceLocks.clear();
            this.tableLocks.clear();
            this.regionLocks.clear();
        }

        public String toString() {
            return "serverLocks=" + this.filterUnlocked(this.serverLocks) + ", namespaceLocks=" + this.filterUnlocked(this.namespaceLocks) + ", tableLocks=" + this.filterUnlocked(this.tableLocks) + ", regionLocks=" + this.filterUnlocked(this.regionLocks);
        }

        private String filterUnlocked(Map<?, LockAndQueue> locks) {
            StringBuilder sb = new StringBuilder("{");
            int initialLength = sb.length();
            for (Map.Entry<?, LockAndQueue> entry : locks.entrySet()) {
                if (!entry.getValue().isLocked()) continue;
                if (sb.length() > initialLength) {
                    sb.append(", ");
                }
                sb.append("{");
                sb.append(entry.getKey());
                sb.append("=");
                sb.append(entry.getValue());
                sb.append("}");
            }
            sb.append("}");
            return sb.toString();
        }
    }

    private static abstract class Queue<TKey extends Comparable<TKey>>
    extends AvlUtil.AvlLinkedNode<Queue<TKey>> {
        private final TKey key;
        private final int priority;
        private final ProcedureDeque runnables = new ProcedureDeque();
        private final LockStatus lockStatus;

        abstract boolean requireExclusiveLock(Procedure var1);

        public Queue(TKey key, LockStatus lockStatus) {
            this(key, 1, lockStatus);
        }

        public Queue(TKey key, int priority, LockStatus lockStatus) {
            this.key = key;
            this.priority = priority;
            this.lockStatus = lockStatus;
        }

        protected TKey getKey() {
            return this.key;
        }

        protected int getPriority() {
            return this.priority;
        }

        protected LockStatus getLockStatus() {
            return this.lockStatus;
        }

        public boolean isAvailable() {
            return !this.lockStatus.hasExclusiveLock() && !this.isEmpty();
        }

        public void add(Procedure proc, boolean addToFront) {
            if (addToFront) {
                this.runnables.addFirst((Object)proc);
            } else {
                this.runnables.addLast((Object)proc);
            }
        }

        public Procedure peek() {
            return (Procedure)this.runnables.peek();
        }

        public Procedure poll() {
            return (Procedure)this.runnables.poll();
        }

        public boolean isEmpty() {
            return this.runnables.isEmpty();
        }

        public int size() {
            return this.runnables.size();
        }

        public int compareKey(TKey cmpKey) {
            return this.key.compareTo(cmpKey);
        }

        public int compareTo(Queue<TKey> other) {
            return this.compareKey(other.key);
        }

        public String toString() {
            return String.format("%s(%s, xlock=%s sharedLock=%s size=%s)", ((Object)((Object)this)).getClass().getSimpleName(), this.key, this.lockStatus.hasExclusiveLock() ? "true (" + this.lockStatus.getExclusiveLockProcIdOwner() + ")" : "false", this.lockStatus.getSharedLockCount(), this.size());
        }
    }

    public static class TableQueue
    extends Queue<TableName> {
        private final LockStatus namespaceLockStatus;

        public TableQueue(TableName tableName, int priority, LockStatus tableLock, LockStatus namespaceLockStatus) {
            super(tableName, priority, tableLock);
            this.namespaceLockStatus = namespaceLockStatus;
        }

        @Override
        public boolean isAvailable() {
            if (this.isEmpty() || this.namespaceLockStatus.hasExclusiveLock()) {
                return false;
            }
            if (this.getLockStatus().hasExclusiveLock()) {
                Procedure nextProc = this.peek();
                return nextProc != null && this.getLockStatus().hasLockAccess(nextProc);
            }
            return true;
        }

        @Override
        public boolean requireExclusiveLock(Procedure proc) {
            return MasterProcedureScheduler.requireTableExclusiveLock((TableProcedureInterface)proc);
        }
    }

    private static class TableQueueKeyComparator
    implements AvlUtil.AvlKeyComparator<TableQueue> {
        private TableQueueKeyComparator() {
        }

        public int compareKey(TableQueue node, Object key) {
            return node.compareKey((TableName)key);
        }
    }

    public static class ServerQueue
    extends Queue<ServerName> {
        public ServerQueue(ServerName serverName, LockStatus serverLock) {
            super(serverName, serverLock);
        }

        @Override
        public boolean requireExclusiveLock(Procedure proc) {
            ServerProcedureInterface spi = (ServerProcedureInterface)proc;
            switch (spi.getServerOperationType()) {
                case CRASH_HANDLER: {
                    return true;
                }
            }
            throw new UnsupportedOperationException("unexpected type " + (Object)((Object)spi.getServerOperationType()));
        }
    }

    private static class ServerQueueKeyComparator
    implements AvlUtil.AvlKeyComparator<ServerQueue> {
        private ServerQueueKeyComparator() {
        }

        public int compareKey(ServerQueue node, Object key) {
            return node.compareKey((ServerName)key);
        }
    }

    private static class TablePriorities {
        final int metaTablePriority;
        final int userTablePriority;
        final int sysTablePriority;

        TablePriorities(Configuration conf) {
            this.metaTablePriority = conf.getInt("hbase.master.procedure.queue.meta.table.priority", 3);
            this.sysTablePriority = conf.getInt("hbase.master.procedure.queue.system.table.priority", 2);
            this.userTablePriority = conf.getInt("hbase.master.procedure.queue.user.table.priority", 1);
        }

        int getPriority(TableName tableName) {
            if (tableName.equals((Object)TableName.META_TABLE_NAME)) {
                return this.metaTablePriority;
            }
            if (tableName.isSystemTable()) {
                return this.sysTablePriority;
            }
            return this.userTablePriority;
        }
    }
}

