/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.MultiHConnection;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionStateStore {
    private static final Logger LOG = LoggerFactory.getLogger(RegionStateStore.class);
    protected static final char META_REPLICA_ID_DELIMITER = '_';
    private final MasterServices master;
    private MultiHConnection multiHConnection;

    public RegionStateStore(MasterServices master) {
        this.master = master;
    }

    public void start() throws IOException {
    }

    public void stop() {
        if (this.multiHConnection != null) {
            this.multiHConnection.close();
            this.multiHConnection = null;
        }
    }

    public void visitMeta(final RegionStateVisitor visitor) throws IOException {
        MetaTableAccessor.fullScanRegions((Connection)this.master.getConnection(), (MetaTableAccessor.Visitor)new MetaTableAccessor.Visitor(){
            final boolean isDebugEnabled = RegionStateStore.access$000().isDebugEnabled();

            public boolean visit(Result r) throws IOException {
                if (r != null && !r.isEmpty()) {
                    long st = 0L;
                    if (LOG.isTraceEnabled()) {
                        st = System.currentTimeMillis();
                    }
                    RegionStateStore.this.visitMetaEntry(visitor, r);
                    if (LOG.isTraceEnabled()) {
                        long et = System.currentTimeMillis();
                        LOG.trace("[T] LOAD META PERF " + StringUtils.humanTimeDiff((long)(et - st)));
                    }
                } else if (this.isDebugEnabled) {
                    LOG.debug("NULL result from meta - ignoring but this is strange.");
                }
                return true;
            }
        });
    }

    private void visitMetaEntry(RegionStateVisitor visitor, Result result) throws IOException {
        RegionLocations rl = MetaTableAccessor.getRegionLocations((Result)result);
        if (rl == null) {
            return;
        }
        HRegionLocation[] locations = rl.getRegionLocations();
        if (locations == null) {
            return;
        }
        for (int i = 0; i < locations.length; ++i) {
            HRegionInfo regionInfo;
            HRegionLocation hrl = locations[i];
            if (hrl == null || (regionInfo = hrl.getRegionInfo()) == null) continue;
            int replicaId = regionInfo.getReplicaId();
            RegionState.State state = RegionStateStore.getRegionState(result, replicaId);
            ServerName lastHost = hrl.getServerName();
            ServerName regionLocation = RegionStateStore.getRegionServer(result, replicaId);
            long openSeqNum = -1L;
            LOG.info(String.format("Load hbase:meta entry region=%s regionState=%s lastHost=%s regionLocation=%s", regionInfo, state, lastHost, regionLocation));
            visitor.visitRegionState((RegionInfo)regionInfo, state, regionLocation, lastHost, -1L);
        }
    }

    public void updateRegionLocation(RegionStates.RegionStateNode regionStateNode) throws IOException {
        if (regionStateNode.getRegionInfo().isMetaRegion()) {
            this.updateMetaLocation(regionStateNode.getRegionInfo(), regionStateNode.getRegionLocation());
        } else {
            long openSeqNum = regionStateNode.getState() == RegionState.State.OPEN ? regionStateNode.getOpenSeqNum() : -1L;
            this.updateUserRegionLocation(regionStateNode.getRegionInfo(), regionStateNode.getState(), regionStateNode.getRegionLocation(), regionStateNode.getLastHost(), openSeqNum, regionStateNode.getProcedure().getProcId());
        }
    }

    protected void updateMetaLocation(RegionInfo regionInfo, ServerName serverName) throws IOException {
        try {
            MetaTableLocator.setMetaLocation((ZKWatcher)this.master.getZooKeeper(), (ServerName)serverName, (int)regionInfo.getReplicaId(), (RegionState.State)RegionState.State.OPEN);
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
    }

    protected void updateUserRegionLocation(RegionInfo regionInfo, RegionState.State state, ServerName regionLocation, ServerName lastHost, long openSeqNum, long pid) throws IOException {
        int replicaId = regionInfo.getReplicaId();
        Put put = new Put(MetaTableAccessor.getMetaKeyForRegion((RegionInfo)regionInfo));
        MetaTableAccessor.addRegionInfo((Put)put, (RegionInfo)regionInfo);
        StringBuilder info = new StringBuilder("pid=" + pid + " updating hbase:meta row=");
        info.append(regionInfo.getRegionNameAsString()).append(", regionState=").append(state);
        if (openSeqNum >= 0L) {
            Preconditions.checkArgument((state == RegionState.State.OPEN && regionLocation != null ? 1 : 0) != 0, (Object)"Open region should be on a server");
            MetaTableAccessor.addLocation((Put)put, (ServerName)regionLocation, (long)openSeqNum, (long)-1L, (int)replicaId);
            info.append(", openSeqNum=").append(openSeqNum);
            info.append(", regionLocation=").append(regionLocation);
        } else if (regionLocation != null && !regionLocation.equals((Object)lastHost)) {
            put.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(RegionStateStore.getServerNameColumn(replicaId)).setTimestamp(put.getTimeStamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes((String)regionLocation.getServerName())).build());
            info.append(", regionLocation=").append(regionLocation);
        }
        put.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setRow(put.getRow()).setFamily(HConstants.CATALOG_FAMILY).setQualifier(RegionStateStore.getStateColumn(replicaId)).setTimestamp(put.getTimeStamp()).setType(Cell.Type.Put).setValue(Bytes.toBytes((String)state.name())).build());
        LOG.info(info.toString());
        boolean serialReplication = this.hasSerialReplicationScope(regionInfo.getTable());
        if (serialReplication && state == RegionState.State.OPEN) {
            Put barrierPut = MetaTableAccessor.makeBarrierPut((byte[])regionInfo.getEncodedNameAsBytes(), (long)openSeqNum, (byte[])regionInfo.getTable().getName());
            this.updateRegionLocation(regionInfo, state, put, barrierPut);
        } else {
            this.updateRegionLocation(regionInfo, state, put);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRegionLocation(RegionInfo regionInfo, RegionState.State state, Put ... put) throws IOException {
        RegionStateStore regionStateStore = this;
        synchronized (regionStateStore) {
            if (this.multiHConnection == null) {
                this.multiHConnection = new MultiHConnection(this.master.getConfiguration(), 1);
            }
        }
        try {
            this.multiHConnection.processBatchCallback(Arrays.asList(put), TableName.META_TABLE_NAME, null, null);
        }
        catch (IOException e) {
            String msg = String.format("FAILED persisting region=%s state=%s", regionInfo.getShortNameToLog(), state);
            LOG.error(msg, (Throwable)e);
            this.master.abort(msg, e);
            throw e;
        }
    }

    public void splitRegion(RegionInfo parent, RegionInfo hriA, RegionInfo hriB, ServerName serverName) throws IOException {
        TableDescriptor htd = this.getTableDescriptor(parent.getTable());
        MetaTableAccessor.splitRegion((Connection)this.master.getConnection(), (RegionInfo)parent, (RegionInfo)hriA, (RegionInfo)hriB, (ServerName)serverName, (int)this.getRegionReplication(htd), (boolean)this.hasSerialReplicationScope(htd));
    }

    public void mergeRegions(RegionInfo parent, RegionInfo hriA, RegionInfo hriB, ServerName serverName) throws IOException {
        TableDescriptor htd = this.getTableDescriptor(parent.getTable());
        MetaTableAccessor.mergeRegions((Connection)this.master.getConnection(), (RegionInfo)parent, (RegionInfo)hriA, (RegionInfo)hriB, (ServerName)serverName, (int)this.getRegionReplication(htd), (long)EnvironmentEdgeManager.currentTime(), (boolean)this.hasSerialReplicationScope(htd));
    }

    public void deleteRegion(RegionInfo regionInfo) throws IOException {
        this.deleteRegions(Collections.singletonList(regionInfo));
    }

    public void deleteRegions(List<RegionInfo> regions) throws IOException {
        MetaTableAccessor.deleteRegions((Connection)this.master.getConnection(), regions);
    }

    private boolean hasSerialReplicationScope(TableName tableName) throws IOException {
        return this.hasSerialReplicationScope(this.getTableDescriptor(tableName));
    }

    private boolean hasSerialReplicationScope(TableDescriptor htd) {
        return htd != null ? htd.hasSerialReplicationScope() : false;
    }

    private int getRegionReplication(TableDescriptor htd) {
        return htd != null ? htd.getRegionReplication() : 1;
    }

    private TableDescriptor getTableDescriptor(TableName tableName) throws IOException {
        return this.master.getTableDescriptors().get(tableName);
    }

    static ServerName getRegionServer(Result r, int replicaId) {
        Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, RegionStateStore.getServerNameColumn(replicaId));
        if (cell == null || cell.getValueLength() == 0) {
            HRegionLocation location;
            RegionLocations locations = MetaTableAccessor.getRegionLocations((Result)r);
            if (locations != null && (location = locations.getRegionLocation(replicaId)) != null) {
                return location.getServerName();
            }
            return null;
        }
        return ServerName.parseServerName((String)Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
    }

    private static byte[] getServerNameColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SERVERNAME_QUALIFIER : Bytes.toBytes((String)("sn_" + String.format("%04X", replicaId)));
    }

    @VisibleForTesting
    public static RegionState.State getRegionState(Result r, int replicaId) {
        Cell cell = r.getColumnLatestCell(HConstants.CATALOG_FAMILY, RegionStateStore.getStateColumn(replicaId));
        if (cell == null || cell.getValueLength() == 0) {
            return null;
        }
        return RegionState.State.valueOf((String)Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
    }

    private static byte[] getStateColumn(int replicaId) {
        return replicaId == 0 ? HConstants.STATE_QUALIFIER : Bytes.toBytes((String)("state_" + String.format("%04X", replicaId)));
    }

    public static interface RegionStateVisitor {
        public void visitRegionState(RegionInfo var1, RegionState.State var2, ServerName var3, ServerName var4, long var5);
    }
}

