/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.FileLink;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FSDataInputStreamWrapper
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(FSDataInputStreamWrapper.class);
    private static final boolean isLogTraceEnabled = LOG.isTraceEnabled();
    private final HFileSystem hfs;
    private final Path path;
    private final FileLink link;
    private final boolean doCloseStreams;
    private final boolean dropBehind;
    private final long readahead;
    private volatile FSDataInputStream stream = null;
    private volatile FSDataInputStream streamNoFsChecksum = null;
    private Object streamNoFsChecksumFirstCreateLock = new Object();
    private boolean useHBaseChecksumConfigured;
    private volatile boolean useHBaseChecksum;
    private volatile int hbaseChecksumOffCount = -1;
    private Boolean instanceOfCanUnbuffer = null;
    private Method unbuffer = null;

    public FSDataInputStreamWrapper(FileSystem fs, Path path) throws IOException {
        this(fs, path, false, -1L);
    }

    public FSDataInputStreamWrapper(FileSystem fs, Path path, boolean dropBehind, long readahead) throws IOException {
        this(fs, null, path, dropBehind, readahead);
    }

    public FSDataInputStreamWrapper(FileSystem fs, FileLink link, boolean dropBehind, long readahead) throws IOException {
        this(fs, link, null, dropBehind, readahead);
    }

    private FSDataInputStreamWrapper(FileSystem fs, FileLink link, Path path, boolean dropBehind, long readahead) throws IOException {
        assert (path == null != (link == null));
        this.path = path;
        this.link = link;
        this.doCloseStreams = true;
        this.dropBehind = dropBehind;
        this.readahead = readahead;
        this.hfs = fs instanceof HFileSystem ? (HFileSystem)fs : new HFileSystem(fs);
        this.useHBaseChecksum = false;
        this.useHBaseChecksumConfigured = false;
        this.stream = link != null ? link.open((FileSystem)this.hfs) : this.hfs.open(path);
        this.setStreamOptions(this.stream);
    }

    private void setStreamOptions(FSDataInputStream in) {
        try {
            in.setDropBehind(Boolean.valueOf(this.dropBehind));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.readahead >= 0L) {
            try {
                in.setReadahead(Long.valueOf(this.readahead));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void prepareForBlockReader(boolean forceNoHBaseChecksum) throws IOException {
        boolean useHBaseChecksum;
        if (this.hfs == null) {
            return;
        }
        assert (this.stream != null && !this.useHBaseChecksumConfigured);
        boolean bl = useHBaseChecksum = !forceNoHBaseChecksum && this.hfs.useHBaseChecksum() && this.hfs.getNoChecksumFs() != this.hfs;
        if (useHBaseChecksum) {
            FileSystem fsNc = this.hfs.getNoChecksumFs();
            this.streamNoFsChecksum = this.link != null ? this.link.open(fsNc) : fsNc.open(this.path);
            this.setStreamOptions(this.streamNoFsChecksum);
            this.useHBaseChecksumConfigured = this.useHBaseChecksum = useHBaseChecksum;
            this.stream.close();
            this.stream = null;
        }
    }

    @VisibleForTesting
    public FSDataInputStreamWrapper(FSDataInputStream fsdis) {
        this(fsdis, fsdis);
    }

    @VisibleForTesting
    public FSDataInputStreamWrapper(FSDataInputStream fsdis, FSDataInputStream noChecksum) {
        this.doCloseStreams = false;
        this.stream = fsdis;
        this.streamNoFsChecksum = noChecksum;
        this.path = null;
        this.link = null;
        this.hfs = null;
        this.useHBaseChecksum = false;
        this.useHBaseChecksumConfigured = false;
        this.dropBehind = false;
        this.readahead = 0L;
    }

    public boolean shouldUseHBaseChecksum() {
        return this.useHBaseChecksum;
    }

    public FSDataInputStream getStream(boolean useHBaseChecksum) {
        return useHBaseChecksum ? this.streamNoFsChecksum : this.stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataInputStream fallbackToFsChecksum(int offCount) throws IOException {
        boolean partOfConvoy = false;
        if (this.stream == null) {
            Object object = this.streamNoFsChecksumFirstCreateLock;
            synchronized (object) {
                boolean bl = partOfConvoy = this.stream != null;
                if (!partOfConvoy) {
                    this.stream = this.link != null ? this.link.open((FileSystem)this.hfs) : this.hfs.open(this.path);
                }
            }
        }
        if (!partOfConvoy) {
            this.useHBaseChecksum = false;
            this.hbaseChecksumOffCount = offCount;
        }
        return this.stream;
    }

    public void checksumOk() {
        if (this.useHBaseChecksumConfigured && !this.useHBaseChecksum && this.hbaseChecksumOffCount-- < 0) {
            assert (this.streamNoFsChecksum != null);
            this.useHBaseChecksum = true;
        }
    }

    @Override
    public void close() {
        if (!this.doCloseStreams) {
            return;
        }
        IOUtils.closeQuietly((InputStream)this.streamNoFsChecksum);
        IOUtils.closeQuietly((InputStream)this.stream);
    }

    public HFileSystem getHfs() {
        return this.hfs;
    }

    public void unbuffer() {
        FSDataInputStream stream = this.getStream(this.shouldUseHBaseChecksum());
        if (stream != null) {
            InputStream wrappedStream = stream.getWrappedStream();
            Class<?> streamClass = wrappedStream.getClass();
            if (this.instanceOfCanUnbuffer == null) {
                Class<?>[] streamInterfaces;
                this.instanceOfCanUnbuffer = false;
                for (Class<?> c : streamInterfaces = streamClass.getInterfaces()) {
                    if (!c.getCanonicalName().toString().equals("org.apache.hadoop.fs.CanUnbuffer")) continue;
                    try {
                        this.unbuffer = streamClass.getDeclaredMethod("unbuffer", new Class[0]);
                    }
                    catch (NoSuchMethodException | SecurityException e) {
                        if (isLogTraceEnabled) {
                            LOG.trace("Failed to find 'unbuffer' method in class " + streamClass + " . So there may be a TCP socket connection left open in CLOSE_WAIT state.", (Throwable)e);
                        }
                        return;
                    }
                    this.instanceOfCanUnbuffer = true;
                    break;
                }
            }
            if (this.instanceOfCanUnbuffer.booleanValue()) {
                try {
                    this.unbuffer.invoke((Object)wrappedStream, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    if (isLogTraceEnabled) {
                        LOG.trace("Failed to invoke 'unbuffer' method in class " + streamClass + " . So there may be a TCP socket connection left open in CLOSE_WAIT state.", (Throwable)e);
                    }
                }
            } else if (isLogTraceEnabled) {
                LOG.trace("Failed to find 'unbuffer' method in class " + streamClass + " . So there may be a TCP socket connection left open in CLOSE_WAIT state. For more details check https://issues.apache.org/jira/browse/HBASE-9393");
            }
        }
    }
}

