/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.snapshot.TestExportSnapshot;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;

@Category(value={MapReduceTests.class, MediumTests.class})
public class TestExportSnapshotNoCluster {
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    private static final Log LOG = LogFactory.getLog(TestExportSnapshotNoCluster.class);
    protected static final HBaseCommonTestingUtility TEST_UTIL = new HBaseCommonTestingUtility();
    private static FileSystem fs;
    private static Path testDir;

    public static void setUpBaseConf(Configuration conf) {
        conf.setBoolean("hbase.snapshot.enabled", true);
        conf.setInt("hbase.regionserver.msginterval", 100);
        conf.setInt("hbase.client.pause", 250);
        conf.setInt("hbase.client.retries.number", 6);
        conf.setBoolean("hbase.master.enabletable.roundrobin", true);
        conf.setInt("mapreduce.map.maxattempts", 10);
        conf.set("hbase.rootdir", testDir.toString());
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        testDir = TEST_UTIL.getDataTestDir();
        fs = testDir.getFileSystem(TEST_UTIL.getConfiguration());
        TestExportSnapshotNoCluster.setUpBaseConf(TEST_UTIL.getConfiguration());
    }

    @Test
    public void testSnapshotWithRefsExportFileSystemState() throws Exception {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(TEST_UTIL.getConfiguration(), fs, testDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV2("tableWithRefsV1", "tableWithRefsV1");
        this.testSnapshotWithRefsExportFileSystemState(builder);
        snapshotMock = new SnapshotTestingUtils.SnapshotMock(TEST_UTIL.getConfiguration(), fs, testDir);
        builder = snapshotMock.createSnapshotV2("tableWithRefsV2", "tableWithRefsV2");
        this.testSnapshotWithRefsExportFileSystemState(builder);
    }

    private void testSnapshotWithRefsExportFileSystemState(SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder) throws Exception {
        Path[] r1Files = builder.addRegion();
        Path[] r2Files = builder.addRegion();
        builder.commit();
        int snapshotFilesCount = r1Files.length + r2Files.length;
        byte[] snapshotName = Bytes.toBytes((String)builder.getSnapshotDescription().getName());
        TableName tableName = builder.getTableDescriptor().getTableName();
        TestExportSnapshot.testExportFileSystemState(TEST_UTIL.getConfiguration(), tableName, snapshotName, snapshotName, snapshotFilesCount, testDir, this.getDestinationDir(), false, null, true);
    }

    private Path getDestinationDir() {
        Path path = new Path(new Path(testDir, "export-test"), "export-" + System.currentTimeMillis());
        LOG.info((Object)("HDFS export destination path: " + path));
        return path;
    }
}

