/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.RowCounter;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LauncherSecurityManager;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;

@Category(value={MapReduceTests.class, LargeTests.class})
public class TestRowCounter {
    @Rule
    public final TestRule timeout = CategoryBasedTimeout.builder().withTimeout(this.getClass()).withLookingForStuckThread(true).build();
    private static final Log LOG = LogFactory.getLog(TestRowCounter.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String TABLE_NAME = "testRowCounter";
    private static final String TABLE_NAME_TS_RANGE = "testRowCounter_ts_range";
    private static final String COL_FAM = "col_fam";
    private static final String COL1 = "c1";
    private static final String COL2 = "c2";
    private static final String COMPOSITE_COLUMN = "C:A:A";
    private static final int TOTAL_ROWS = 10;
    private static final int ROWS_WITH_ONE_COL = 2;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)TABLE_NAME), Bytes.toBytes((String)COL_FAM));
        TestRowCounter.writeRows(table, 10, 2);
        table.close();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRowCounterNoColumn() throws Exception {
        String[] args = new String[]{TABLE_NAME};
        this.runRowCount(args, 10);
    }

    @Test
    public void testRowCounterExclusiveColumn() throws Exception {
        String[] args = new String[]{TABLE_NAME, "col_fam:c1"};
        this.runRowCount(args, 8);
    }

    @Test
    public void testRowCounterColumnWithColonInQualifier() throws Exception {
        String[] args = new String[]{TABLE_NAME, "col_fam:C:A:A"};
        this.runRowCount(args, 8);
    }

    @Test
    public void testRowCounterHiddenColumn() throws Exception {
        String[] args = new String[]{TABLE_NAME, "col_fam:c2"};
        this.runRowCount(args, 10);
    }

    @Test
    public void testRowCounterColumnAndRowRange() throws Exception {
        String[] args = new String[]{TABLE_NAME, "--range=\\x00rov,\\x00rox", "col_fam:c1"};
        this.runRowCount(args, 8);
    }

    @Test
    public void testRowCounterRowSingleRange() throws Exception {
        String[] args = new String[]{TABLE_NAME, "--range=\\x00row1,\\x00row3"};
        this.runRowCount(args, 2);
    }

    @Test
    public void testRowCounterRowSingleRangeUpperBound() throws Exception {
        String[] args = new String[]{TABLE_NAME, "--range=,\\x00row3"};
        this.runRowCount(args, 3);
    }

    @Test
    public void testRowCounterRowMultiRangeUpperBound() throws Exception {
        String[] args = new String[]{TABLE_NAME, "--range=,\\x00row3;\\x00row5,\\x00row7"};
        this.runRowCount(args, 5);
    }

    @Test
    public void testRowCounterRowMultiRange() throws Exception {
        String[] args = new String[]{TABLE_NAME, "--range=\\x00row1,\\x00row3;\\x00row5,\\x00row8"};
        this.runRowCount(args, 5);
    }

    @Test
    public void testRowCounterRowMultiEmptyRange() throws Exception {
        String[] args = new String[]{TABLE_NAME, "--range=\\x00row1,\\x00row3;;"};
        this.runRowCount(args, 2);
    }

    @Test
    public void testRowCounter10kRowRange() throws Exception {
        String tableName = "testRowCounter10k";
        try (Table table = TEST_UTIL.createTable(TableName.valueOf((String)tableName), Bytes.toBytes((String)COL_FAM));){
            TestRowCounter.writeRows(table, 10000, 0);
        }
        String[] args = new String[]{tableName, "--range=\\x00row9872,\\x00row9875"};
        this.runRowCount(args, 3);
    }

    @Test
    public void testRowCounterTimeRange() throws Exception {
        byte[] family = Bytes.toBytes((String)COL_FAM);
        byte[] col1 = Bytes.toBytes((String)COL1);
        Put put1 = new Put(Bytes.toBytes((String)"row_timerange_1"));
        Put put2 = new Put(Bytes.toBytes((String)"row_timerange_2"));
        Put put3 = new Put(Bytes.toBytes((String)"row_timerange_3"));
        Table table = TEST_UTIL.createTable(TableName.valueOf((String)TABLE_NAME_TS_RANGE), Bytes.toBytes((String)COL_FAM));
        long ts = System.currentTimeMillis();
        put1.addColumn(family, col1, ts, Bytes.toBytes((String)"val1"));
        table.put(put1);
        Thread.sleep(100L);
        ts = System.currentTimeMillis();
        put2.addColumn(family, col1, ts, Bytes.toBytes((String)"val2"));
        put3.addColumn(family, col1, ts, Bytes.toBytes((String)"val3"));
        table.put(put2);
        table.put(put3);
        table.close();
        String[] args = new String[]{TABLE_NAME_TS_RANGE, "col_fam:c1", "--starttime=0", "--endtime=" + ts};
        this.runRowCount(args, 1);
        args = new String[]{TABLE_NAME_TS_RANGE, "col_fam:c1", "--starttime=0", "--endtime=" + (ts - 10L)};
        this.runRowCount(args, 1);
        args = new String[]{TABLE_NAME_TS_RANGE, "col_fam:c1", "--starttime=" + ts, "--endtime=" + (ts + 1000L)};
        this.runRowCount(args, 2);
        args = new String[]{TABLE_NAME_TS_RANGE, "col_fam:c1", "--starttime=" + (ts - 30000L), "--endtime=" + (ts + 30000L)};
        this.runRowCount(args, 3);
    }

    private void runRowCount(String[] args, int expectedCount) throws Exception {
        Job job = RowCounter.createSubmittableJob((Configuration)TEST_UTIL.getConfiguration(), (String[])args);
        long start = System.currentTimeMillis();
        job.waitForCompletion(true);
        long duration = System.currentTimeMillis() - start;
        LOG.debug((Object)("row count duration (ms): " + duration));
        Assert.assertTrue((boolean)job.isSuccessful());
        Counter counter = job.getCounters().findCounter((Enum)RowCounter.RowCounterMapper.Counters.ROWS);
        Assert.assertEquals((long)expectedCount, (long)counter.getValue());
    }

    private static void writeRows(Table table, int totalRows, int rowsWithOneCol) throws IOException {
        Put put;
        byte[] row;
        int i;
        byte[] family = Bytes.toBytes((String)COL_FAM);
        byte[] value = Bytes.toBytes((String)"abcd");
        byte[] col1 = Bytes.toBytes((String)COL1);
        byte[] col2 = Bytes.toBytes((String)COL2);
        byte[] col3 = Bytes.toBytes((String)COMPOSITE_COLUMN);
        ArrayList<Put> rowsUpdate = new ArrayList<Put>();
        for (i = 0; i < totalRows - rowsWithOneCol; ++i) {
            row = Bytes.toBytesBinary((String)("\\x00row" + i));
            put = new Put(row);
            put.addColumn(family, col1, value);
            put.addColumn(family, col2, value);
            put.addColumn(family, col3, value);
            rowsUpdate.add(put);
        }
        while (i < totalRows) {
            row = Bytes.toBytes((String)("row" + i));
            put = new Put(row);
            put.addColumn(family, col2, value);
            rowsUpdate.add(put);
            ++i;
        }
        table.put(rowsUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportMain() throws Exception {
        PrintStream oldPrintStream = System.err;
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager((SecurityManager)newSecurityManager);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String[] args = new String[]{};
        System.setErr(new PrintStream(data));
        try {
            System.setErr(new PrintStream(data));
            try {
                RowCounter.main((String[])args);
                Assert.fail((String)"should be SecurityException");
            }
            catch (SecurityException e) {
                Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
                Assert.assertTrue((boolean)data.toString().contains("Wrong number of parameters:"));
                Assert.assertTrue((boolean)data.toString().contains("Usage: RowCounter [options] <tablename> [--starttime=[start] --endtime=[end] [--range=[startKey],[endKey][;[startKey],[endKey]...]] [<column1> <column2>...]"));
                Assert.assertTrue((boolean)data.toString().contains("-Dhbase.client.scanner.caching=100"));
                Assert.assertTrue((boolean)data.toString().contains("-Dmapreduce.map.speculative=false"));
            }
            data.reset();
            try {
                args = new String[]{"table", "--range=1"};
                RowCounter.main((String[])args);
                Assert.fail((String)"should be SecurityException");
            }
            catch (SecurityException e) {
                Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
                Assert.assertTrue((boolean)data.toString().contains("Please specify range in such format as \"--range=a,b\" or, with only one boundary, \"--range=,b\" or \"--range=a,\""));
                Assert.assertTrue((boolean)data.toString().contains("Usage: RowCounter [options] <tablename> [--starttime=[start] --endtime=[end] [--range=[startKey],[endKey][;[startKey],[endKey]...]] [<column1> <column2>...]"));
            }
        }
        finally {
            System.setErr(oldPrintStream);
            System.setSecurityManager(SECURITY_MANAGER);
        }
    }
}

