/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HashTable;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestHashTable {
    private static final Log LOG = LogFactory.getLog(TestHashTable.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testHashTable() throws Exception {
        FileStatus[] files;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] family = Bytes.toBytes((String)"family");
        byte[] column1 = Bytes.toBytes((String)"c1");
        byte[] column2 = Bytes.toBytes((String)"c2");
        byte[] column3 = Bytes.toBytes((String)"c3");
        int numRows = 100;
        int numRegions = 10;
        int numHashFiles = 3;
        byte[][] splitRows = new byte[numRegions - 1][];
        for (int i = 1; i < numRegions; ++i) {
            splitRows[i - 1] = Bytes.toBytes((int)(numRows * i / numRegions));
        }
        long timestamp = 1430764183454L;
        Table t1 = TEST_UTIL.createTable(tableName, family, (byte[][])splitRows);
        for (int i = 0; i < numRows; ++i) {
            Put p = new Put(Bytes.toBytes((int)i), timestamp);
            p.addColumn(family, column1, column1);
            p.addColumn(family, column2, column2);
            p.addColumn(family, column3, column3);
            t1.put(p);
        }
        t1.close();
        HashTable hashTable = new HashTable(TEST_UTIL.getConfiguration());
        Path testDir = TEST_UTIL.getDataTestDirOnTestFS(tableName.getNameAsString());
        long batchSize = 300L;
        int code = hashTable.run(new String[]{"--batchsize=" + batchSize, "--numhashfiles=" + numHashFiles, "--scanbatch=2", tableName.getNameAsString(), testDir.toString()});
        Assert.assertEquals((String)"test job failed", (long)0L, (long)code);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        HashTable.TableHash tableHash = HashTable.TableHash.read((Configuration)fs.getConf(), (Path)testDir);
        Assert.assertEquals((Object)tableName.getNameAsString(), (Object)tableHash.tableName);
        Assert.assertEquals((long)batchSize, (long)tableHash.batchSize);
        Assert.assertEquals((long)numHashFiles, (long)tableHash.numHashFiles);
        Assert.assertEquals((long)(numHashFiles - 1), (long)tableHash.partitions.size());
        for (ImmutableBytesWritable bytes : tableHash.partitions) {
            LOG.debug((Object)("partition: " + Bytes.toInt((byte[])bytes.get())));
        }
        ImmutableMap expectedHashes = ImmutableMap.builder().put((Object)-1, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"714cb10a9e3b5569852980edd8c6ca2f"))).put((Object)5, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"28d961d9252ce8f8d44a07b38d3e1d96"))).put((Object)10, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"f6bbc4a224d8fd929b783a92599eaffa"))).put((Object)15, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"522deb5d97f73a414ecc11457be46881"))).put((Object)20, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"b026f2611aaa46f7110116d807545352"))).put((Object)25, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"39ffc1a3094aa12a2e90ffd9cef2ce93"))).put((Object)30, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"f6b4d75727ce9a30ac29e4f08f601666"))).put((Object)35, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"422e2d2f1eb79a8f02171a705a42c090"))).put((Object)40, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"559ad61c900fffefea0a15abf8a97bc3"))).put((Object)45, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"23019084513eca41cee436b2a29611cb"))).put((Object)50, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"b40467d222ddb4949b142fe145ee9edc"))).put((Object)55, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"372bf89fcd8ca4b7ab3c1add9d07f7e4"))).put((Object)60, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"69ae0585e6255de27dce974e332b8f8b"))).put((Object)65, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"8029610044297aad0abdbecd485d8e59"))).put((Object)70, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"de5f784f7f78987b6e57ecfd81c8646f"))).put((Object)75, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"1cd757cc4e1715c8c3b1c24447a1ec56"))).put((Object)80, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"f9a53aacfeb6142b08066615e7038095"))).put((Object)85, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"89b872b7e639df32d3276b33928c0c91"))).put((Object)90, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"45eeac0646d46a474ea0484175faed38"))).put((Object)95, (Object)new ImmutableBytesWritable(Bytes.fromHex((String)"f57c447e32a08f4bf1abb2892839ac56"))).build();
        HashMap<Integer, ImmutableBytesWritable> actualHashes = new HashMap<Integer, ImmutableBytesWritable>();
        Path dataDir = new Path(testDir, "hashes");
        for (int i = 0; i < numHashFiles; ++i) {
            Path hashPath = new Path(dataDir, HashTable.TableHash.getDataFileName((int)i));
            MapFile.Reader reader = new MapFile.Reader(hashPath, fs.getConf(), new SequenceFile.Reader.Option[0]);
            ImmutableBytesWritable key = new ImmutableBytesWritable();
            ImmutableBytesWritable hash = new ImmutableBytesWritable();
            while (reader.next((WritableComparable)key, (Writable)hash)) {
                String keyString = Bytes.toHex((byte[])key.get(), (int)key.getOffset(), (int)key.getLength());
                LOG.debug((Object)("Key: " + (keyString.isEmpty() ? "-1" : Integer.valueOf(Integer.parseInt(keyString, 16))) + " Hash: " + Bytes.toHex((byte[])hash.get(), (int)hash.getOffset(), (int)hash.getLength())));
                int intKey = -1;
                if (key.getLength() > 0) {
                    intKey = Bytes.toInt((byte[])key.get(), (int)key.getOffset(), (int)key.getLength());
                }
                if (actualHashes.containsKey(intKey)) {
                    Assert.fail((String)("duplicate key in data files: " + intKey));
                }
                actualHashes.put(intKey, new ImmutableBytesWritable(hash.copyBytes()));
            }
            reader.close();
        }
        for (FileStatus file : files = fs.listStatus(testDir)) {
            LOG.debug((Object)("Output file: " + file.getPath()));
        }
        for (FileStatus file : files = fs.listStatus(dataDir)) {
            LOG.debug((Object)("Data file: " + file.getPath()));
        }
        if (!expectedHashes.equals(actualHashes)) {
            LOG.error((Object)("Diff: " + Maps.difference((Map)expectedHashes, actualHashes)));
        }
        Assert.assertEquals((Object)expectedHashes, actualHashes);
        TEST_UTIL.deleteTable(tableName);
        TEST_UTIL.cleanupDataTestDirOnTestFS();
    }
}

