/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableMap;
import org.apache.hadoop.hbase.mapred.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapred.TableOutputFormat;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestTableOutputFormatConnectionExhaust {
    private static final Log LOG = LogFactory.getLog(TestTableOutputFormatConnectionExhaust.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    static final String TABLE = "TestTableOutputFormatConnectionExhaust";
    static final String FAMILY = "family";

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.getConfiguration().setInt("hbase.zookeeper.property.maxClientCnxns", 10);
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws IOException {
        LOG.info((Object)"before");
        UTIL.ensureSomeRegionServersAvailable(1);
        LOG.info((Object)"before done");
    }

    static void openCloseTableOutputFormat(int iter) throws IOException {
        LOG.info((Object)("Instantiating TableOutputFormat connection  " + iter));
        JobConf conf = new JobConf();
        conf.addResource(UTIL.getConfiguration());
        conf.set("hbase.mapred.outputtable", TABLE);
        TableMapReduceUtil.initTableMapJob((String)TABLE, (String)FAMILY, TableMap.class, ImmutableBytesWritable.class, ImmutableBytesWritable.class, (JobConf)conf);
        TableOutputFormat tof = new TableOutputFormat();
        RecordWriter rw = tof.getRecordWriter(null, conf, TABLE, null);
        rw.close(null);
    }

    @Test
    public void testConnectionExhaustion() throws IOException {
        int MAX_INSTANCES = 5;
        for (int i = 0; i < MAX_INSTANCES; ++i) {
            int iter = i;
            try {
                TestTableOutputFormatConnectionExhaust.openCloseTableOutputFormat(iter);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)"Exception encountered", (Throwable)e);
                Assert.fail((String)("Failed on iteration " + i));
            }
        }
    }
}

