/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.GroupingTableMap;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.hbase.shaded.com.google.common.primitives.Bytes;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MapReduceTests.class, SmallTests.class})
public class TestGroupingTableMap {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotCallCollectonSinceFindUniqueKeyValueMoreThanOnes() throws Exception {
        try (GroupingTableMap gTableMap = null;){
            Result result = (Result)Mockito.mock(Result.class);
            Reporter reporter = (Reporter)Mockito.mock(Reporter.class);
            gTableMap = new GroupingTableMap();
            Configuration cfg = new Configuration();
            cfg.set("hbase.mapred.groupingtablemap.columns", "familyA:qualifierA familyB:qualifierB");
            JobConf jobConf = new JobConf(cfg);
            gTableMap.configure(jobConf);
            byte[] row = new byte[]{};
            ImmutableList keyValues = ImmutableList.of((Object)new KeyValue(row, "familyA".getBytes(), "qualifierA".getBytes(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"1111")), (Object)new KeyValue(row, "familyA".getBytes(), "qualifierA".getBytes(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"2222")), (Object)new KeyValue(row, "familyB".getBytes(), "qualifierB".getBytes(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"3333")));
            Mockito.when((Object)result.listCells()).thenReturn((Object)keyValues);
            OutputCollector outputCollectorMock = (OutputCollector)Mockito.mock(OutputCollector.class);
            gTableMap.map(null, result, outputCollectorMock, reporter);
            ((Result)Mockito.verify((Object)result)).listCells();
            Mockito.verifyZeroInteractions((Object[])new Object[]{outputCollectorMock});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCreateNewKeyAlthoughExtraKey() throws Exception {
        try (GroupingTableMap gTableMap = null;){
            Result result = (Result)Mockito.mock(Result.class);
            Reporter reporter = (Reporter)Mockito.mock(Reporter.class);
            gTableMap = new GroupingTableMap();
            Configuration cfg = new Configuration();
            cfg.set("hbase.mapred.groupingtablemap.columns", "familyA:qualifierA familyB:qualifierB");
            JobConf jobConf = new JobConf(cfg);
            gTableMap.configure(jobConf);
            byte[] row = new byte[]{};
            ImmutableList keyValues = ImmutableList.of((Object)new KeyValue(row, "familyA".getBytes(), "qualifierA".getBytes(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"1111")), (Object)new KeyValue(row, "familyB".getBytes(), "qualifierB".getBytes(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"2222")), (Object)new KeyValue(row, "familyC".getBytes(), "qualifierC".getBytes(), org.apache.hadoop.hbase.util.Bytes.toBytes((String)"3333")));
            Mockito.when((Object)result.listCells()).thenReturn((Object)keyValues);
            OutputCollector outputCollectorMock = (OutputCollector)Mockito.mock(OutputCollector.class);
            gTableMap.map(null, result, outputCollectorMock, reporter);
            ((Result)Mockito.verify((Object)result)).listCells();
            ((OutputCollector)Mockito.verify((Object)outputCollectorMock, (VerificationMode)Mockito.times((int)1))).collect(Matchers.any(ImmutableBytesWritable.class), Matchers.any(Result.class));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{outputCollectorMock});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCreateNewKey() throws Exception {
        try (GroupingTableMap gTableMap = null;){
            Result result = (Result)Mockito.mock(Result.class);
            Reporter reporter = (Reporter)Mockito.mock(Reporter.class);
            final byte[] bSeparator = org.apache.hadoop.hbase.util.Bytes.toBytes((String)" ");
            gTableMap = new GroupingTableMap();
            Configuration cfg = new Configuration();
            cfg.set("hbase.mapred.groupingtablemap.columns", "familyA:qualifierA familyB:qualifierB");
            JobConf jobConf = new JobConf(cfg);
            gTableMap.configure(jobConf);
            final byte[] firstPartKeyValue = org.apache.hadoop.hbase.util.Bytes.toBytes((String)"34879512738945");
            final byte[] secondPartKeyValue = org.apache.hadoop.hbase.util.Bytes.toBytes((String)"35245142671437");
            byte[] row = new byte[]{};
            ImmutableList cells = ImmutableList.of((Object)new KeyValue(row, "familyA".getBytes(), "qualifierA".getBytes(), firstPartKeyValue), (Object)new KeyValue(row, "familyB".getBytes(), "qualifierB".getBytes(), secondPartKeyValue));
            Mockito.when((Object)result.listCells()).thenReturn((Object)cells);
            final AtomicBoolean outputCollected = new AtomicBoolean();
            OutputCollector<ImmutableBytesWritable, Result> outputCollector = new OutputCollector<ImmutableBytesWritable, Result>(){

                public void collect(ImmutableBytesWritable arg, Result result) throws IOException {
                    Assert.assertArrayEquals((byte[])Bytes.concat((byte[][])new byte[][]{firstPartKeyValue, bSeparator, secondPartKeyValue}), (byte[])arg.copyBytes());
                    outputCollected.set(true);
                }
            };
            gTableMap.map(null, result, (OutputCollector)outputCollector, reporter);
            ((Result)Mockito.verify((Object)result)).listCells();
            Assert.assertTrue((String)"Output not received", (boolean)outputCollected.get());
            byte[] firstPartValue = org.apache.hadoop.hbase.util.Bytes.toBytes((String)"238947928");
            byte[] secondPartValue = org.apache.hadoop.hbase.util.Bytes.toBytes((String)"4678456942345");
            byte[][] data = new byte[][]{firstPartValue, secondPartValue};
            ImmutableBytesWritable byteWritable = gTableMap.createGroupKey((byte[][])data);
            Assert.assertArrayEquals((byte[])Bytes.concat((byte[][])new byte[][]{firstPartValue, bSeparator, secondPartValue}), (byte[])byteWritable.get());
        }
    }

    @Test
    public void shouldReturnNullFromCreateGroupKey() throws Exception {
        try (GroupingTableMap gTableMap = null;){
            gTableMap = new GroupingTableMap();
            Assert.assertNull((Object)gTableMap.createGroupKey((byte[][])null));
        }
    }
}

