/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerMetricsBuilder;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.ServerTask;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.UserMetrics;
import org.apache.hadoop.hbase.replication.ReplicationLoadSink;
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hbase.thirdparty.com.google.common.base.Objects;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
@Deprecated
public class ServerLoad
implements ServerMetrics {
    private final ServerMetrics metrics;
    private int stores = 0;
    private int storefiles = 0;
    private int storeUncompressedSizeMB = 0;
    private int storefileSizeMB = 0;
    private int memstoreSizeMB = 0;
    private long storefileIndexSizeKB = 0L;
    private long readRequestsCount = 0L;
    private long filteredReadRequestsCount = 0L;
    private long writeRequestsCount = 0L;
    private int rootIndexSizeKB = 0;
    private int totalStaticIndexSizeKB = 0;
    private int totalStaticBloomSizeKB = 0;
    private long totalCompactingKVs = 0L;
    private long currentCompactedKVs = 0L;
    protected ClusterStatusProtos.ServerLoad serverLoad;
    @Deprecated
    public static final ServerLoad EMPTY_SERVERLOAD = new ServerLoad(ServerName.valueOf((String)"localhost,1,1"), ClusterStatusProtos.ServerLoad.newBuilder().build());

    @InterfaceAudience.Private
    public ServerLoad(ClusterStatusProtos.ServerLoad serverLoad) {
        this(ServerName.valueOf((String)"localhost,1,1"), serverLoad);
    }

    @InterfaceAudience.Private
    @SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public ServerLoad(ServerName name, ClusterStatusProtos.ServerLoad serverLoad) {
        this(ServerMetricsBuilder.toServerMetrics(name, serverLoad));
        this.serverLoad = serverLoad;
    }

    @InterfaceAudience.Private
    public ServerLoad(ServerMetrics metrics) {
        this.metrics = metrics;
        this.serverLoad = ServerMetricsBuilder.toServerLoad(metrics);
        for (RegionMetrics rl : metrics.getRegionMetrics().values()) {
            this.stores += rl.getStoreCount();
            this.storefiles += rl.getStoreFileCount();
            this.storeUncompressedSizeMB += (int)rl.getUncompressedStoreFileSize().get(Size.Unit.MEGABYTE);
            this.storefileSizeMB += (int)rl.getStoreFileSize().get(Size.Unit.MEGABYTE);
            this.memstoreSizeMB += (int)rl.getMemStoreSize().get(Size.Unit.MEGABYTE);
            this.readRequestsCount += rl.getReadRequestCount();
            this.filteredReadRequestsCount += rl.getFilteredReadRequestCount();
            this.writeRequestsCount += rl.getWriteRequestCount();
            this.storefileIndexSizeKB += (long)rl.getStoreFileIndexSize().get(Size.Unit.KILOBYTE);
            this.rootIndexSizeKB += (int)rl.getStoreFileRootLevelIndexSize().get(Size.Unit.KILOBYTE);
            this.totalStaticIndexSizeKB += (int)rl.getStoreFileUncompressedDataIndexSize().get(Size.Unit.KILOBYTE);
            this.totalStaticBloomSizeKB += (int)rl.getBloomFilterSize().get(Size.Unit.KILOBYTE);
            this.totalCompactingKVs += rl.getCompactingCellCount();
            this.currentCompactedKVs += rl.getCompactedCellCount();
        }
    }

    @InterfaceAudience.Private
    @Deprecated
    public ClusterStatusProtos.ServerLoad obtainServerLoadPB() {
        return this.serverLoad;
    }

    @Deprecated
    public long getNumberOfRequests() {
        return this.getRequestCountPerSecond();
    }

    @Deprecated
    public boolean hasNumberOfRequests() {
        return true;
    }

    @Deprecated
    public long getTotalNumberOfRequests() {
        return this.getRequestCount();
    }

    @Deprecated
    public boolean hasTotalNumberOfRequests() {
        return true;
    }

    @Deprecated
    public int getUsedHeapMB() {
        return (int)this.getUsedHeapSize().get(Size.Unit.MEGABYTE);
    }

    @Deprecated
    public boolean hasUsedHeapMB() {
        return true;
    }

    @Deprecated
    public int getMaxHeapMB() {
        return (int)this.getMaxHeapSize().get(Size.Unit.MEGABYTE);
    }

    @Deprecated
    public boolean hasMaxHeapMB() {
        return true;
    }

    @Deprecated
    public int getStores() {
        return this.stores;
    }

    @Deprecated
    public int getStorefiles() {
        return this.storefiles;
    }

    @Deprecated
    public int getStoreUncompressedSizeMB() {
        return this.storeUncompressedSizeMB;
    }

    @Deprecated
    public int getStorefileSizeInMB() {
        return this.storefileSizeMB;
    }

    @Deprecated
    public int getStorefileSizeMB() {
        return this.storefileSizeMB;
    }

    @Deprecated
    public int getMemstoreSizeInMB() {
        return this.memstoreSizeMB;
    }

    @Deprecated
    public int getMemStoreSizeMB() {
        return this.memstoreSizeMB;
    }

    @Deprecated
    public int getStorefileIndexSizeInMB() {
        return (int)(this.getStorefileIndexSizeKB() >> 10);
    }

    @Deprecated
    public long getStorefileIndexSizeKB() {
        return this.storefileIndexSizeKB;
    }

    @Deprecated
    public long getReadRequestsCount() {
        return this.readRequestsCount;
    }

    @Deprecated
    public long getFilteredReadRequestsCount() {
        return this.filteredReadRequestsCount;
    }

    @Deprecated
    public long getWriteRequestsCount() {
        return this.writeRequestsCount;
    }

    @Deprecated
    public int getRootIndexSizeKB() {
        return this.rootIndexSizeKB;
    }

    @Deprecated
    public int getTotalStaticIndexSizeKB() {
        return this.totalStaticIndexSizeKB;
    }

    @Deprecated
    public int getTotalStaticBloomSizeKB() {
        return this.totalStaticBloomSizeKB;
    }

    @Deprecated
    public long getTotalCompactingKVs() {
        return this.totalCompactingKVs;
    }

    @Deprecated
    public long getCurrentCompactedKVs() {
        return this.currentCompactedKVs;
    }

    @Deprecated
    public int getNumberOfRegions() {
        return this.metrics.getRegionMetrics().size();
    }

    @Override
    public ServerName getServerName() {
        return this.metrics.getServerName();
    }

    @Override
    public long getRequestCountPerSecond() {
        return this.metrics.getRequestCountPerSecond();
    }

    @Override
    public long getRequestCount() {
        return this.metrics.getRequestCount();
    }

    @Override
    public Size getUsedHeapSize() {
        return this.metrics.getUsedHeapSize();
    }

    @Override
    public Size getMaxHeapSize() {
        return this.metrics.getMaxHeapSize();
    }

    @Override
    public int getInfoServerPort() {
        return this.metrics.getInfoServerPort();
    }

    @Override
    public List<ReplicationLoadSource> getReplicationLoadSourceList() {
        return this.metrics.getReplicationLoadSourceList();
    }

    @Override
    public Map<String, List<ReplicationLoadSource>> getReplicationLoadSourceMap() {
        return this.metrics.getReplicationLoadSourceMap();
    }

    @Override
    public ReplicationLoadSink getReplicationLoadSink() {
        return this.metrics.getReplicationLoadSink();
    }

    @Override
    public Map<byte[], RegionMetrics> getRegionMetrics() {
        return this.metrics.getRegionMetrics();
    }

    @Override
    public Map<byte[], UserMetrics> getUserMetrics() {
        return this.metrics.getUserMetrics();
    }

    @Override
    public Set<String> getCoprocessorNames() {
        return this.metrics.getCoprocessorNames();
    }

    @Override
    public long getReportTimestamp() {
        return this.metrics.getReportTimestamp();
    }

    @Override
    public long getLastReportTimestamp() {
        return this.metrics.getLastReportTimestamp();
    }

    @Override
    public List<ServerTask> getTasks() {
        return this.metrics.getTasks();
    }

    @Deprecated
    public int getLoad() {
        return this.getNumberOfRegions();
    }

    @Deprecated
    public Map<byte[], RegionLoad> getRegionsLoad() {
        return this.getRegionMetrics().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new RegionLoad((RegionMetrics)e.getValue()), (v1, v2) -> {
            throw new RuntimeException("key collisions?");
        }, () -> new TreeMap(Bytes.BYTES_COMPARATOR)));
    }

    @Deprecated
    public String[] getRegionServerCoprocessors() {
        return this.getCoprocessorNames().toArray(new String[this.getCoprocessorNames().size()]);
    }

    @Deprecated
    public String[] getRsCoprocessors() {
        return this.getRegionServerCoprocessors();
    }

    @Deprecated
    public double getRequestsPerSecond() {
        return this.getRequestCountPerSecond();
    }

    public String toString() {
        StringBuilder sb = Strings.appendKeyValue((StringBuilder)new StringBuilder(), (String)"requestsPerSecond", (Object)this.getRequestsPerSecond());
        Strings.appendKeyValue((StringBuilder)sb, (String)"numberOfOnlineRegions", (Object)this.getNumberOfRegions());
        Strings.appendKeyValue((StringBuilder)sb, (String)"usedHeapMB", (Object)this.getUsedHeapMB());
        Strings.appendKeyValue((StringBuilder)sb, (String)"maxHeapMB", (Object)this.getMaxHeapMB());
        Strings.appendKeyValue((StringBuilder)sb, (String)"numberOfStores", (Object)this.stores);
        Strings.appendKeyValue((StringBuilder)sb, (String)"numberOfStorefiles", (Object)this.storefiles);
        Strings.appendKeyValue((StringBuilder)sb, (String)"storefileUncompressedSizeMB", (Object)this.storeUncompressedSizeMB);
        Strings.appendKeyValue((StringBuilder)sb, (String)"storefileSizeMB", (Object)this.storefileSizeMB);
        if (this.storeUncompressedSizeMB != 0) {
            Strings.appendKeyValue((StringBuilder)sb, (String)"compressionRatio", (Object)String.format("%.4f", Float.valueOf((float)this.storefileSizeMB / (float)this.storeUncompressedSizeMB)));
        }
        Strings.appendKeyValue((StringBuilder)sb, (String)"memstoreSizeMB", (Object)this.memstoreSizeMB);
        Strings.appendKeyValue((StringBuilder)sb, (String)"storefileIndexSizeKB", (Object)this.storefileIndexSizeKB);
        Strings.appendKeyValue((StringBuilder)sb, (String)"readRequestsCount", (Object)this.readRequestsCount);
        Strings.appendKeyValue((StringBuilder)sb, (String)"filteredReadRequestsCount", (Object)this.filteredReadRequestsCount);
        Strings.appendKeyValue((StringBuilder)sb, (String)"writeRequestsCount", (Object)this.writeRequestsCount);
        Strings.appendKeyValue((StringBuilder)sb, (String)"rootIndexSizeKB", (Object)this.rootIndexSizeKB);
        Strings.appendKeyValue((StringBuilder)sb, (String)"totalStaticIndexSizeKB", (Object)this.totalStaticIndexSizeKB);
        Strings.appendKeyValue((StringBuilder)sb, (String)"totalStaticBloomSizeKB", (Object)this.totalStaticBloomSizeKB);
        Strings.appendKeyValue((StringBuilder)sb, (String)"totalCompactingKVs", (Object)this.totalCompactingKVs);
        Strings.appendKeyValue((StringBuilder)sb, (String)"currentCompactedKVs", (Object)this.currentCompactedKVs);
        float compactionProgressPct = Float.NaN;
        if (this.totalCompactingKVs > 0L) {
            compactionProgressPct = Float.valueOf((float)this.currentCompactedKVs / (float)this.totalCompactingKVs).floatValue();
        }
        Strings.appendKeyValue((StringBuilder)sb, (String)"compactionProgressPct", (Object)Float.valueOf(compactionProgressPct));
        Object[] coprocessorStrings = this.getRsCoprocessors();
        if (coprocessorStrings != null) {
            Strings.appendKeyValue((StringBuilder)sb, (String)"coprocessors", (Object)Arrays.toString(coprocessorStrings));
        }
        return sb.toString();
    }

    @Deprecated
    public long getReportTime() {
        return this.getReportTimestamp();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.stores, this.storefiles, this.storeUncompressedSizeMB, this.storefileSizeMB, this.memstoreSizeMB, this.storefileIndexSizeKB, this.readRequestsCount, this.filteredReadRequestsCount, this.writeRequestsCount, this.rootIndexSizeKB, this.totalStaticIndexSizeKB, this.totalStaticBloomSizeKB, this.totalCompactingKVs, this.currentCompactedKVs});
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ServerLoad) {
            ServerLoad sl = (ServerLoad)other;
            return this.stores == sl.stores && this.storefiles == sl.storefiles && this.storeUncompressedSizeMB == sl.storeUncompressedSizeMB && this.storefileSizeMB == sl.storefileSizeMB && this.memstoreSizeMB == sl.memstoreSizeMB && this.storefileIndexSizeKB == sl.storefileIndexSizeKB && this.readRequestsCount == sl.readRequestsCount && this.filteredReadRequestsCount == sl.filteredReadRequestsCount && this.writeRequestsCount == sl.writeRequestsCount && this.rootIndexSizeKB == sl.rootIndexSizeKB && this.totalStaticIndexSizeKB == sl.totalStaticIndexSizeKB && this.totalStaticBloomSizeKB == sl.totalStaticBloomSizeKB && this.totalCompactingKVs == sl.totalCompactingKVs && this.currentCompactedKVs == sl.currentCompactedKVs;
        }
        return false;
    }
}

