"use strict";
/* jshint ignore:start */

/* jshint ignore:end */

define('yarn-ui/adapters/abstract', ['exports', 'ember', 'ember-data'], function (exports, _ember, _emberData) {
  exports['default'] = _emberData['default'].JSONAPIAdapter.extend({
    address: null, //Must be set by inheriting classes
    restNameSpace: null, //Must be set by inheriting classes
    serverName: null, //Must be set by inheriting classes

    headers: {
      Accept: 'application/json'
    },

    host: _ember['default'].computed("address", function () {
      var address = this.get("address");
      return this.get('hosts.' + address);
    }),

    namespace: _ember['default'].computed("restNameSpace", function () {
      var serverName = this.get("restNameSpace");
      return this.get('env.app.namespaces.' + serverName);
    }),

    ajax: function ajax(url, method, options) {
      options = options || {};
      options.crossDomain = true;
      options.xhrFields = {
        withCredentials: true
      };
      options.targetServer = this.get('serverName');
      return this._super(url, method, options);
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/cluster-info", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {
  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({
    address: "rmWebAddress",
    restNameSpace: "cluster",
    serverName: "RM",

    // Any cluster-info specific adapter changes must be added here
    pathForType: function pathForType() /*modelName*/{
      return ''; // move to some common place, return path by modelname.
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/cluster-metric", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {
  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({
    address: "rmWebAddress",
    restNameSpace: "metrics",
    serverName: "RM",

    // Any cluster-metric specific adapter changes must be added here
    pathForType: function pathForType() /*modelName*/{
      return ''; // move to some common place, return path by modelname.
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/cluster-user-info", ["exports", "yarn-ui/adapters/restabstract"], function (exports, _yarnUiAdaptersRestabstract) {
  exports["default"] = _yarnUiAdaptersRestabstract["default"].extend({
    address: "rmWebAddress",
    restNameSpace: "cluster",
    serverName: "RM",

    pathForType: function pathForType() /*modelName*/{
      return 'userinfo';
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/jhs-health", ["exports", "yarn-ui/adapters/restabstract"], function (exports, _yarnUiAdaptersRestabstract) {
  exports["default"] = _yarnUiAdaptersRestabstract["default"].extend({
    address: "jhsAddress",
    restNameSpace: "jhs",
    serverName: "JHS",

    urlForQueryRecord: function urlForQueryRecord() /*query, modelName*/{
      var url = this.buildURL();
      return url + '/info';
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/adapters/restabstract', ['exports', 'ember-data', 'ember'], function (exports, _emberData, _ember) {
  exports['default'] = _emberData['default'].RESTAdapter.extend({
    address: null, //Must be set by inheriting classes
    restNameSpace: null, //Must be set by inheriting classes
    serverName: null, //Must be set by inheriting classes

    headers: {
      Accept: 'application/json'
    },

    host: _ember['default'].computed("address", function () {
      var address = this.get("address");
      return this.get('hosts.' + address);
    }),

    namespace: _ember['default'].computed("restNameSpace", function () {
      var nameSpace = this.get("restNameSpace");
      return this.get('env.app.namespaces.' + nameSpace);
    }),

    ajax: function ajax(url, method, options) {
      options = options || {};
      options.crossDomain = true;
      options.xhrFields = {
        withCredentials: true
      };
      options.targetServer = this.get('serverName');
      return this._super(url, method, options);
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/timeline-health", ["exports", "yarn-ui/adapters/restabstract"], function (exports, _yarnUiAdaptersRestabstract) {
  exports["default"] = _yarnUiAdaptersRestabstract["default"].extend({
    address: "timelineWebAddress",
    restNameSpace: "timelineV2",
    serverName: "ATS",

    urlForQueryRecord: function urlForQueryRecord() /*query, modelName*/{
      var url = this.buildURL();
      return url + '/health';
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/adapters/yarn-app-attempt', ['exports', 'yarn-ui/adapters/abstract', 'yarn-ui/utils/converter'], function (exports, _yarnUiAdaptersAbstract, _yarnUiUtilsConverter) {
  exports['default'] = _yarnUiAdaptersAbstract['default'].extend({
    address: "rmWebAddress",
    restNameSpace: "cluster",
    serverName: "RM",

    urlForQuery: function urlForQuery(query /*, modelName*/) {
      var url = this._buildURL();
      var appId = query.appId;
      delete query.appId;
      return url + '/apps/' + appId + "/appattempts";
    },

    urlForFindRecord: function urlForFindRecord(id /*, modelName, snapshot*/) {
      var url = this._buildURL();
      return url + '/apps/' + _yarnUiUtilsConverter['default'].attemptIdToAppId(id) + "/appattempts/" + id;
    }

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-app-flowrun", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {
  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({
    address: "timelineWebAddress",
    restNameSpace: "timelineV2",
    serverName: "ATS",

    urlForQuery: function urlForQuery(query /*, modelName*/) {
      var url = this._buildURL();
      var flowrunUid = query['flowrunUid'];
      delete query.flowrunUid;
      url = url + '/run-uid/' + flowrunUid + '/apps?fields=ALL';
      return url;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/adapters/yarn-app-jhs-log', ['exports', 'ember', 'yarn-ui/utils/converter', 'yarn-ui/adapters/restabstract'], function (exports, _ember, _yarnUiUtilsConverter, _yarnUiAdaptersRestabstract) {

  /**
   * REST URL's response when fetching container logs will be
   * in plain text format and not JSON.
   */
  exports['default'] = _yarnUiAdaptersRestabstract['default'].extend({
    address: "jhsAddress",
    restNameSpace: "jhs",
    serverName: "JHS",

    headers: {
      Accept: 'text/plain'
    },

    urlForFindRecord: function urlForFindRecord(id /*, modelName, snapshot*/) {
      var splits = _yarnUiUtilsConverter['default'].splitForAppLogs(id);
      var containerId = splits[0];
      var logFile = splits[1];
      var url = this._buildURL();
      url = url + '/containerlogs/' + containerId + '/' + logFile + '?manual_redirection=true';
      _ember['default'].Logger.info('The URL for getting the log: ' + url);
      return url;
    },

    handleResponse: function handleResponse(status, headers, payload, requestData) {
      if (headers['location'] !== undefined && headers['location'] !== null) {
        return { redirectedUrl: headers.location, data: "" };
      } else {
        return { data: payload };
      }
    },

    /**
     * Override options so that result is not expected to be JSON
     */
    ajaxOptions: function ajaxOptions(url, type, options) {
      var hash = options || {};
      hash.url = url;
      hash.type = type;
      // Make sure jQuery does not try to convert response to JSON.
      hash.dataType = 'text';
      hash.context = this;

      var headers = _ember['default'].get(this, 'headers');
      if (headers !== undefined) {
        hash.beforeSend = function (xhr) {
          Object.keys(headers).forEach(function (key) {
            return xhr.setRequestHeader(key, headers[key]);
          });
        };
      }
      return hash;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/adapters/yarn-app-jhs-redirect-log', ['exports', 'ember', 'yarn-ui/utils/converter', 'yarn-ui/adapters/restabstract'], function (exports, _ember, _yarnUiUtilsConverter, _yarnUiAdaptersRestabstract) {

  /**
   * REST URL's response when fetching container logs will be
   * in plain text format and not JSON.
   */
  exports['default'] = _yarnUiAdaptersRestabstract['default'].extend({
    headers: {
      Accept: 'text/plain'
    },

    urlForFindRecord: function urlForFindRecord(id /*, modelName, snapshot*/) {
      var splits = _yarnUiUtilsConverter['default'].splitForAppLogs(id);
      var url = splits[0];
      return url;
    },

    /**
     * Override options so that result is not expected to be JSON
     */
    ajaxOptions: function ajaxOptions(url, type, options) {
      var hash = options || {};
      hash.url = url;
      hash.type = type;
      // Make sure jQuery does not try to convert response to JSON.
      hash.dataType = 'text';
      hash.context = this;

      var headers = _ember['default'].get(this, 'headers');
      if (headers !== undefined) {
        hash.beforeSend = function (xhr) {
          Object.keys(headers).forEach(function (key) {
            return xhr.setRequestHeader(key, headers[key]);
          });
        };
      }
      return hash;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/adapters/yarn-app-log', ['exports', 'ember', 'yarn-ui/utils/converter', 'yarn-ui/adapters/restabstract'], function (exports, _ember, _yarnUiUtilsConverter, _yarnUiAdaptersRestabstract) {

  /**
   * REST URL's response when fetching container logs will be
   * in plain text format and not JSON.
   */
  exports['default'] = _yarnUiAdaptersRestabstract['default'].extend({
    address: "timelineWebAddress",
    restNameSpace: "timelineV2Log",
    serverName: "ATS",

    headers: {
      Accept: 'text/plain'
    },

    urlForFindRecord: function urlForFindRecord(id /*, modelName, snapshot*/) {
      var splits = _yarnUiUtilsConverter['default'].splitForAppLogs(id);
      var clusterId = this.get("env.app.clusterId");
      var containerId = splits[0];
      var logFile = splits[1];
      if (splits[2]) {
        clusterId = splits[2];
      }
      var url = this._buildURL();
      url = url + '/containers/' + containerId + '/logs/' + logFile + '?clusterid=' + clusterId + '?manual_redirection=true';
      _ember['default'].Logger.info('The URL for getting the log: ' + url);
      return url;
    },

    handleResponse: function handleResponse(status, headers, payload, requestData) {
      if (headers['location'] !== undefined && headers['location'] !== null) {
        return { redirectedUrl: headers.location, data: "" };
      } else {
        return { data: payload };
      }
    },

    /**
     * Override options so that result is not expected to be JSON
     */
    ajaxOptions: function ajaxOptions(url, type, options) {
      var hash = options || {};
      hash.url = url;
      hash.type = type;
      // Make sure jQuery does not try to convert response to JSON.
      hash.dataType = 'text';
      hash.context = this;

      var headers = _ember['default'].get(this, 'headers');
      if (headers !== undefined) {
        hash.beforeSend = function (xhr) {
          Object.keys(headers).forEach(function (key) {
            return xhr.setRequestHeader(key, headers[key]);
          });
        };
      }
      return hash;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/adapters/yarn-app-redirect-log', ['exports', 'ember', 'yarn-ui/utils/converter', 'yarn-ui/adapters/restabstract'], function (exports, _ember, _yarnUiUtilsConverter, _yarnUiAdaptersRestabstract) {

  /**
   * REST URL's response when fetching container logs will be
   * in plain text format and not JSON.
   */
  exports['default'] = _yarnUiAdaptersRestabstract['default'].extend({

    headers: {
      Accept: 'text/plain'
    },

    urlForFindRecord: function urlForFindRecord(id /*, modelName, snapshot*/) {
      var splits = _yarnUiUtilsConverter['default'].splitForAppLogs(id);
      var url = splits[0];
      return url;
    },

    /**
     * Override options so that result is not expected to be JSON
     */
    ajaxOptions: function ajaxOptions(url, type, options) {
      var hash = options || {};
      hash.url = url;
      hash.type = type;
      // Make sure jQuery does not try to convert response to JSON.
      hash.dataType = 'text';
      hash.context = this;

      var headers = _ember['default'].get(this, 'headers');
      if (headers !== undefined) {
        hash.beforeSend = function (xhr) {
          Object.keys(headers).forEach(function (key) {
            return xhr.setRequestHeader(key, headers[key]);
          });
        };
      }
      return hash;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-app-timeline", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {
  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({
    address: "timelineWebAddress",
    restNameSpace: "timelineV2",
    serverName: "ATS",

    urlForFindRecord: function urlForFindRecord(id /*, modelName, snapshot*/) {
      var url = this._buildURL();
      var clusterId = this.get("env.app.clusterId");
      if (clusterId) {
        url += "/clusters/" + clusterId;
      }
      url += '/apps/' + id + '?fields=ALL';
      return url;
    },

    pathForType: function pathForType() /*modelName*/{
      return 'apps';
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-app", ["exports", "yarn-ui/adapters/restabstract"], function (exports, _yarnUiAdaptersRestabstract) {
  exports["default"] = _yarnUiAdaptersRestabstract["default"].extend({
    address: "rmWebAddress",
    restNameSpace: "cluster",
    serverName: "RM",

    urlForQuery: function urlForQuery() /*query, modelName*/{
      var url = this._buildURL();
      url = url + '/apps';
      return url;
    },

    urlForFindRecord: function urlForFindRecord(id /*, modelName, snapshot*/) {
      var url = this._buildURL();
      url = url + '/apps/' + id;
      return url;
    },

    pathForType: function pathForType() /*modelName*/{
      return 'apps'; // move to some common place, return path by modelname.
    },

    sendKillApplication: function sendKillApplication(id) {
      var url = this._buildURL();
      url += '/apps/' + id + '/state';
      var data = {
        "state": "KILLED"
      };
      return this.ajax(url, "PUT", { data: data });
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-component-instance", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {
  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({
    address: "timelineWebAddress",
    restNameSpace: "timelineV2",
    serverName: "ATS",

    urlForQuery: function urlForQuery(query /*, modelName*/) {
      var url = this.buildURL();
      var clusterId = this.get("env.app.clusterId");
      if (clusterId) {
        url += "/clusters/" + clusterId;
      }
      url += '/apps/' + query.appId + '/entities/COMPONENT_INSTANCE?fields=ALL';
      delete query.appId;
      return url;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/adapters/yarn-conf', ['exports', 'ember-data', 'ember', 'yarn-ui/utils/converter', 'yarn-ui/adapters/abstract'], function (exports, _emberData, _ember, _yarnUiUtilsConverter, _yarnUiAdaptersAbstract) {
  exports['default'] = _yarnUiAdaptersAbstract['default'].extend({

    address: 'rmWebAddress',

    headers: {
      Accept: 'text/plain'
    },

    host: _ember['default'].computed("address", function () {
      var address = this.get("address");
      return this.get('hosts.' + address);
    }),

    pathForType: function pathForType(type) {
      return 'conf';
    },

    urlForFindRecord: function urlForFindRecord(id, modelName, snapshot) {
      var extension = this.get("host").split('/').pop();
      if (extension != id) {
        this.host = this.get("host") + id;
      }
      var url = this._buildURL();
      return url;
    },

    ajax: function ajax(url, method, hash) {
      hash = hash || {};
      hash.crossDomain = true;
      hash.xhrFields = { withCredentials: true };
      hash.targetServer = "RM";
      return this._super(url, method, hash);
    },

    /**
     * Override options so that result is not expected to be JSON
     */
    ajaxOptions: function ajaxOptions(url, type, options) {
      var hash = options || {};
      hash.url = url;
      hash.type = type;
      // Make sure jQuery does not try to convert response to JSON.
      hash.dataType = 'text';
      hash.context = this;

      var headers = _ember['default'].get(this, 'headers');
      if (headers != undefined) {
        hash.beforeSend = function (xhr) {
          Object.keys(headers).forEach(function (key) {
            return xhr.setRequestHeader(key, headers[key]);
          });
        };
      }
      return hash;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/adapters/yarn-container-log', ['exports', 'ember-data', 'ember', 'yarn-ui/utils/converter'], function (exports, _emberData, _ember, _yarnUiUtilsConverter) {

  /**
   * REST URL's response when fetching container logs will be
   * in plain text format and not JSON.
   */
  exports['default'] = _emberData['default'].RESTAdapter.extend({
    headers: {
      Accept: 'text/plain'
    },

    host: _ember['default'].computed("address", function () {
      return this.get('hosts.localBaseAddress');
    }),

    namespace: _ember['default'].computed("restNameSpace", function () {
      return this.get('env.app.namespaces.node');
    }),

    urlForFindRecord: function urlForFindRecord(id /*, modelName, snapshot*/) {
      var splits = _yarnUiUtilsConverter['default'].splitForContainerLogs(id);
      var nodeHttpAddr = splits[0];
      var containerId = splits[1];
      var filename = splits[2];
      var url = this._buildURL();
      url = url.replace("{nodeAddress}", nodeHttpAddr) + "/containerlogs/" + containerId + "/" + filename;
      return url;
    },

    ajax: function ajax(url, method, hash) {
      hash = hash || {};
      hash.crossDomain = true;
      hash.xhrFields = { withCredentials: true };
      hash.targetServer = "NM";
      return this._super(url, method, hash);
    },

    /**
     * Override options so that result is not expected to be JSON
     */
    ajaxOptions: function ajaxOptions(url, type, options) {
      var hash = options || {};
      hash.url = url;
      hash.type = type;
      // Make sure jQuery does not try to convert response to JSON.
      hash.dataType = 'text';
      hash.context = this;

      var headers = _ember['default'].get(this, 'headers');
      if (headers !== undefined) {
        hash.beforeSend = function (xhr) {
          Object.keys(headers).forEach(function (key) {
            return xhr.setRequestHeader(key, headers[key]);
          });
        };
      }
      return hash;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-container-threaddump", ["exports", "yarn-ui/adapters/restabstract"], function (exports, _yarnUiAdaptersRestabstract) {
  exports["default"] = _yarnUiAdaptersRestabstract["default"].extend({
    address: "rmWebAddress",
    restNameSpace: "cluster",

    handleResponse: function handleResponse(status, headers, payload, requestData) {
      // If the user is not authorized to signal a threaddump for a container,
      // the response contains a RemoteException with a 403 (Forbidden) status
      // code. Extract out the error message from the RemoteException in this
      // case.
      // If the status is '0' or empty, it is symptomatic of the YARN role not
      // available or able to respond or a network timeout/firewall issue.
      if (status === 403) {
        if (payload && typeof payload === 'object' && payload.RemoteException && payload.RemoteException.message) {
          return new Error(payload.RemoteException.message);
        }
      } else if (status === 0 && payload === "") {
        return new Error("Not able to connect to YARN!");
      }

      return payload;
    },

    /**
     * Set up the POST request to use the signalToContainer REST API
     * to signal a thread dump for a running container to RM.
     */
    signalContainerForThreaddump: function signalContainerForThreaddump(request, containerId, user) {
      var url = this.buildURL();
      if (user && containerId) {
        url += "/containers" + "/" + containerId + "/signal" + "/OUTPUT_THREAD_DUMP" + "?user.name=" + user;
      }
      return this.ajax(url, "POST", { data: request });
    },

    ajax: function ajax(url, method, hash) {
      hash = {};
      hash.crossDomain = true;
      hash.xhrFields = { withCredentials: true };
      hash.targetServer = "RM";
      return this._super(url, method, hash);
    },

    /**
     * Override options so that result is not expected to be JSON
     */
    ajaxOptions: function ajaxOptions(url, type, options) {
      var hash = options || {};
      hash.url = url;
      hash.type = type;
      // Make sure jQuery does not try to convert response to JSON.
      hash.dataType = 'text';
      hash.context = this;

      var headers = Ember.get(this, 'headers');
      if (headers !== undefined) {
        hash.beforeSend = function (xhr) {
          Object.keys(headers).forEach(function (key) {
            return xhr.setRequestHeader(key, headers[key]);
          });
        };
      }
      return hash;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/adapters/yarn-container', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].JSONAPIAdapter.extend({
    headers: {
      Accept: 'application/json'
    },

    host: (function () {
      return this.get('hosts.rmWebAddress');
    }).property(),

    namespace: (function () {
      return this.get('env.app.namespaces.cluster');
    }).property(),

    urlForQuery: function urlForQuery(query /*, modelName*/) {
      var url = this._buildURL();
      url = url + '/apps/' + _yarnUiUtilsConverter['default'].attemptIdToAppId(query.app_attempt_id) + "/appattempts/" + query.app_attempt_id + "/containers";
      return url;
    },

    ajax: function ajax(url, method, hash) {
      hash = {};
      hash.crossDomain = true;
      hash.xhrFields = { withCredentials: true };
      hash.targetServer = "RM";
      return this._super(url, method, hash);
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-entity", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {
  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({
    address: "timelineWebAddress",
    restNameSpace: "timelineV2",
    serverName: "ATS",

    urlForQuery: function urlForQuery(query /*, modelName*/) {
      var url = this._buildURL();
      var appUid = query.app_uid;
      var entityType = query.entity_type;
      delete query.app_uid;
      delete query.entity_type;
      url = url + '/app-uid/' + appUid + '/entities/' + entityType + '?fields=INFO';
      return url;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-flow-activity", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {
  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({
    address: "timelineWebAddress",
    restNameSpace: "timelineV2",
    serverName: "ATS",

    pathForType: function pathForType() /*modelName*/{
      var clusterId = this.get("env.app.clusterId");
      if (clusterId) {
        return "clusters/" + clusterId + "/flows";
      }
      return 'flows'; // move to some common place, return path by modelname.
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-flowrun-brief", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {
  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({
    address: "timelineWebAddress",
    restNameSpace: "timelineV2",
    serverName: "ATS",

    urlForQuery: function urlForQuery(query /*, modelName*/) {
      var url = this._buildURL();
      var flowuid = query['flowuid'];
      delete query.flowuid;
      return url + '/flow-uid/' + flowuid + '/runs?fields=ALL';
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-flowrun", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {
  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({
    address: "timelineWebAddress",
    restNameSpace: "timelineV2",
    serverName: "ATS",

    urlForQueryRecord: function urlForQueryRecord(query /*, modelName*/) {
      var url = this._buildURL();
      var flowrunuid = query.flowrun_uid;
      delete query.flowrun_uid;
      url = url + '/run-uid/' + flowrunuid;
      return url;
    },

    pathForType: function pathForType() /*modelName*/{
      return 'run-uid'; // move to some common place, return path by modelname.
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/adapters/yarn-jhs-container', ['exports', 'ember', 'yarn-ui/adapters/restabstract'], function (exports, _ember, _yarnUiAdaptersRestabstract) {
  exports['default'] = _yarnUiAdaptersRestabstract['default'].extend({
    address: "jhsAddress",
    restNameSpace: "jhs",
    serverName: "JHS",

    urlForQuery: function urlForQuery(query /*, modelName*/) {
      var url = this.buildURL();
      url = url + '/aggregatedlogs?appattemptid=' + query.app_attempt_id;
      delete query.app_attempt_id;
      return url;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/adapters/yarn-jhs-log', ['exports', 'yarn-ui/adapters/abstract', 'yarn-ui/helpers/log-adapter-helper'], function (exports, _yarnUiAdaptersAbstract, _yarnUiHelpersLogAdapterHelper) {
  exports['default'] = _yarnUiAdaptersAbstract['default'].extend({
    address: "jhsAddress",
    restNameSpace: "jhs",
    serverName: "JHS",

    urlForQuery: function urlForQuery(query /*, modelName*/) {
      var url = this._buildURL();
      var containerId = query['containerId'];
      delete query.containerId;
      return url + '/containers/' + containerId + '/logs' + '?manual_redirection=true';
    },

    handleResponse: function handleResponse(status, headers, payload, requestData) {
      if (headers['location'] !== undefined && headers['location'] !== null) {
        return (0, _yarnUiHelpersLogAdapterHelper.createEmptyContainerLogInfo)(headers['location']);
      } else {
        return payload;
      }
    }

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-jhs-redirect-log", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {
  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({
    address: "jhsAddress",
    restNameSpace: "jhs",
    serverName: "JHS",

    urlForQuery: function urlForQuery(url /*, modelName*/) {
      return url;
    }

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-log", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {

  function createEmptyContainerLogInfo(location) {
    return {
      containerLogsInfo: {
        containerLogInfo: [{
          fileName: "",
          fileSize: "",
          lastModifiedTime: "",
          redirectedUrl: location
        }]
      }
    };
  }

  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({
    address: "timelineWebAddress",
    restNameSpace: "timelineV2Log",
    serverName: "ATS",

    urlForQuery: function urlForQuery(query /*, modelName*/) {
      var url = this._buildURL();
      var containerId = query['containerId'];
      var clusterId = this.get("env.app.clusterId");
      delete query.containerId;
      return url + '/containers/' + containerId + '/logs' + '?clusterid=' + clusterId + '?manual_redirection=true';
    },

    handleResponse: function handleResponse(status, headers, payload, requestData) {
      if (headers['location'] !== undefined && headers['location'] !== null) {
        return createEmptyContainerLogInfo(headers['location']);
      } else {
        return payload;
      }
    }

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/adapters/yarn-metrics', ['exports', 'ember-data', 'ember', 'yarn-ui/utils/converter'], function (exports, _emberData, _ember, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].RESTAdapter.extend({
    address: 'rmWebAddress',

    headers: {
      Accept: 'text/plain'
    },

    host: _ember['default'].computed("address", function () {
      var address = this.get("address");
      return this.get('hosts.' + address);
    }),

    pathForType: function pathForType(type) {
      return 'jmx';
    },

    urlForFindRecord: function urlForFindRecord(id, modelName, snapshot) {
      var extension = this.get("host").split('/').pop();
      if (extension != id) {
        this.host = this.get("host") + id;
      }
      var url = this._buildURL();
      return url;
    },

    ajax: function ajax(url, method, hash) {
      hash = hash || {};
      hash.crossDomain = true;
      hash.xhrFields = { withCredentials: true };
      hash.targetServer = "RM";
      return this._super(url, method, hash);
    },

    /**
     * Override options so that result is not expected to be JSON
     */
    ajaxOptions: function ajaxOptions(url, type, options) {
      var hash = options || {};
      hash.url = url;
      hash.type = type;
      // Make sure jQuery does not try to convert response to JSON.
      hash.dataType = 'text';
      hash.context = this;
      var headers = _ember['default'].get(this, 'headers');
      if (headers != undefined) {
        hash.beforeSend = function (xhr) {
          Object.keys(headers).forEach(function (key) {
            return xhr.setRequestHeader(key, headers[key]);
          });
        };
      }
      return hash;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-nm-gpu", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {
  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({

    address: "localBaseAddress",
    restNameSpace: "node",
    serverName: "NM",

    urlForFindRecord: function urlForFindRecord(id /*, modelName, snapshot*/) {
      var url = this._buildURL();
      url = url.replace("{nodeAddress}", id) + "/resources/yarn.io%2Fgpu";
      return url;
    }

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-node-app", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {
  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({

    address: "localBaseAddress",
    restNameSpace: "node",
    serverName: "NM",

    urlForQuery: function urlForQuery(query) {
      var url = this._buildURL();
      url = url.replace("{nodeAddress}", query.nodeAddr) + "/apps";
      return url;
    },

    urlForQueryRecord: function urlForQueryRecord(query) {
      var url = this._buildURL();
      url = url.replace("{nodeAddress}", query.nodeAddr) + "/apps/" + query.appId;
      return url;
    },

    query: function query(store, type, _query) {
      var url = this.urlForQuery(_query);
      // Query params not required.
      _query = null;
      return this.ajax(url, 'GET', { data: _query });
    },

    queryRecord: function queryRecord(store, type, query) {
      var url = this.urlForQueryRecord(query);
      // Query params not required.
      query = null;
      return this.ajax(url, 'GET', { data: query });
    }

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/adapters/yarn-node-container-log', ['exports', 'ember-data', 'ember', 'yarn-ui/utils/converter'], function (exports, _emberData, _ember, _yarnUiUtilsConverter) {

  /**
   * REST URL's response when fetching container logs will be
   * in plain text format and not JSON.
   */
  exports['default'] = _emberData['default'].RESTAdapter.extend({
    headers: {
      Accept: 'text/plain'
    },

    host: _ember['default'].computed("address", function () {
      return this.get('hosts.localBaseAddress');
    }),

    namespace: _ember['default'].computed("restNameSpace", function () {
      return this.get('env.app.namespaces.node');
    }),

    urlForQueryRecord: function urlForQueryRecord(query) {
      var url = this._buildURL();
      url = url.replace("{nodeAddress}", query.nodeHttpAddr) + "/containerlogs/" + query.containerId + "/" + query.fileName;
      return url;
    },

    queryRecord: function queryRecord(store, type, query) {
      var url = this.urlForQueryRecord(query);
      // Query params not required.
      query = null;
      console.log(url);
      return this.ajax(url, 'GET', { data: query });
    },

    ajax: function ajax(url, method, hash) {
      hash = hash || {};
      hash.crossDomain = true;
      hash.xhrFields = { withCredentials: true };
      hash.targetServer = "NM";
      return this._super(url, method, hash);
    },

    /**
     * Override options so that result is not expected to be JSON
     */
    ajaxOptions: function ajaxOptions(url, type, options) {
      var hash = options || {};
      hash.url = url;
      hash.type = type;
      // Make sure jQuery does not try to convert response to JSON.
      hash.dataType = 'text';
      hash.context = this;

      var headers = _ember['default'].get(this, 'headers');
      if (headers !== undefined) {
        hash.beforeSend = function (xhr) {
          Object.keys(headers).forEach(function (key) {
            return xhr.setRequestHeader(key, headers[key]);
          });
        };
      }
      return hash;
    },

    handleResponse: function handleResponse(status, headers, payload, requestData) {
      // If the status is '0' or empty, it is symptomatic of the YARN role not
      // available or able to respond or a network timeout/firewall issue.
      if (status === 0 && payload === "") {
        return new Error("Not able to connect to YARN!");
      }

      return payload;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-node-container", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {
  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({

    address: "localBaseAddress",
    restNameSpace: "node",
    serverName: "NM",

    urlForQuery: function urlForQuery(query) {
      var url = this._buildURL();
      url = url.replace("{nodeAddress}", query.nodeHttpAddr) + "/containers";
      return url;
    },

    urlForQueryRecord: function urlForQueryRecord(query) {
      var url = this._buildURL();
      url = url.replace("{nodeAddress}", query.nodeHttpAddr) + "/containers/" + query.containerId;
      return url;
    },

    query: function query(store, type, _query) {
      var url = this.urlForQuery(_query);
      // Query params not required.
      _query = null;
      return this.ajax(url, 'GET', { data: _query });
    },

    queryRecord: function queryRecord(store, type, query) {
      var url = this.urlForQueryRecord(query);
      // Query params not required.
      query = null;
      console.log(url);
      return this.ajax(url, 'GET', { data: query });
    }

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-node", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {
  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({

    address: "localBaseAddress",
    restNameSpace: "node",
    serverName: "NM",

    urlForFindRecord: function urlForFindRecord(id /*, modelName, snapshot*/) {
      var url = this._buildURL();
      url = url.replace("{nodeAddress}", id);
      return url;
    }

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/adapters/yarn-queue/capacity-queue', ['exports', 'yarn-ui/adapters/yarn-queue/yarn-queue'], function (exports, _yarnUiAdaptersYarnQueueYarnQueue) {
  exports['default'] = _yarnUiAdaptersYarnQueueYarnQueue['default'].extend({});
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/adapters/yarn-queue/fair-queue', ['exports', 'yarn-ui/adapters/yarn-queue/yarn-queue'], function (exports, _yarnUiAdaptersYarnQueueYarnQueue) {
  exports['default'] = _yarnUiAdaptersYarnQueueYarnQueue['default'].extend({});
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/adapters/yarn-queue/fifo-queue', ['exports', 'yarn-ui/adapters/yarn-queue/yarn-queue'], function (exports, _yarnUiAdaptersYarnQueueYarnQueue) {
  exports['default'] = _yarnUiAdaptersYarnQueueYarnQueue['default'].extend({});
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-queue/yarn-queue", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {
  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({
    address: "rmWebAddress",
    restNameSpace: "cluster",
    serverName: "RM",

    pathForType: function pathForType() /*modelName*/{
      return 'scheduler'; // move to some common place, return path by modelname.
    }

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-redirect-log", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {
  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({
    address: "timelineWebAddress",
    restNameSpace: "timelineV2Log",
    serverName: "ATS",

    urlForQuery: function urlForQuery(url /*, modelName*/) {
      return url;
    }

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/adapters/yarn-rm-log', ['exports', 'ember-data', 'ember', 'yarn-ui/utils/converter'], function (exports, _emberData, _ember, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].RESTAdapter.extend({
    address: 'rmWebAddress',
    headers: {
      Accept: 'text/plain'
    },

    host: _ember['default'].computed("address", function () {
      var address = this.get("address");
      return this.get('hosts.' + address);
    }),

    pathForType: function pathForType(type) {
      return 'logs';
    },

    buildURL: function buildURL(modelName, id, snapshot, requestType, query) {
      return this._super(modelName, id, snapshot, requestType, query) + '/';
    },

    urlForFindRecord: function urlForFindRecord(id, modelName, snapshot) {
      this.host = this.get('host');
      var url = this.host + id;
      return url;
    },

    ajax: function ajax(url, method, hash) {
      hash = hash || {};
      hash.crossDomain = true;
      hash.xhrFields = { withCredentials: true };
      hash.targetServer = "RM";
      return this._super(url, method, hash);
    },

    /**
     * Override options so that result is not expected to be JSON
     */
    ajaxOptions: function ajaxOptions(url, type, options) {
      var hash = options || {};
      hash.url = url;
      hash.type = type;
      // Make sure jQuery does not try to convert response to JSON.
      hash.dataType = 'text';
      hash.context = this;
      var headers = _ember['default'].get(this, 'headers');
      if (headers != undefined) {
        hash.beforeSend = function (xhr) {
          Object.keys(headers).forEach(function (key) {
            return xhr.setRequestHeader(key, headers[key]);
          });
        };
      }
      return hash;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-rm-node", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {
  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({
    address: "rmWebAddress",
    restNameSpace: "cluster",
    serverName: "RM",

    pathForType: function pathForType() /*modelName*/{
      return 'nodes';
    },

    urlForFindRecord: function urlForFindRecord(id /*, modelName, snapshot*/) {
      var url = this._buildURL();
      url = url + "/nodes/" + id;
      return url;
    }

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-service-component", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {
  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({
    address: "timelineWebAddress",
    restNameSpace: "timelineV2",
    serverName: "ATS",

    urlForQuery: function urlForQuery(query /*, modelName*/) {
      var url = this.buildURL();
      var clusterId = this.get("env.app.clusterId");
      if (clusterId) {
        url += "/clusters/" + clusterId;
      }
      url += '/apps/' + query.appId + '/entities/COMPONENT?fields=ALL';
      delete query.appId;
      return url;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-service-info", ["exports", "yarn-ui/adapters/abstract"], function (exports, _yarnUiAdaptersAbstract) {
  exports["default"] = _yarnUiAdaptersAbstract["default"].extend({
    address: "timelineWebAddress",
    restNameSpace: "timelineV2",
    serverName: "ATS",

    urlForQueryRecord: function urlForQueryRecord(query /*, modelName*/) {
      var url = this.buildURL();
      var clusterId = this.get("env.app.clusterId");
      if (clusterId) {
        url += "/clusters/" + clusterId;
      }
      url += '/apps/' + query.appId + '/entities/SERVICE_ATTEMPT?fields=ALL';
      delete query.appId;
      return url;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-service", ["exports", "yarn-ui/adapters/restabstract"], function (exports, _yarnUiAdaptersRestabstract) {
  exports["default"] = _yarnUiAdaptersRestabstract["default"].extend({
    address: "rmWebAddress",
    restNameSpace: "dashService",
    serverName: "DASH",

    urlForQueryRecord: function urlForQueryRecord(query /*, modelName*/) {
      var url = this.buildURL();
      url += '/' + query.serviceName;
      delete query.serviceName;
      return url;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/adapters/yarn-servicedef", ["exports", "yarn-ui/adapters/restabstract"], function (exports, _yarnUiAdaptersRestabstract) {
  exports["default"] = _yarnUiAdaptersRestabstract["default"].extend({
    address: "rmWebAddress",
    restNameSpace: "dashService",
    serverName: "DASH",

    normalizeErrorResponse: function normalizeErrorResponse(status, headers, payload) {
      if (payload && typeof payload === 'object' && payload.errors) {
        return payload.errors;
      } else {
        return [payload];
      }
    },

    deployService: function deployService(request, user) {
      var url = this.buildURL();
      if (user) {
        url += "/?user.name=" + user;
      }
      return this.ajax(url, "POST", { data: request });
    },

    stopService: function stopService(serviceName, user) {
      var url = this.buildURL();
      url += "/" + serviceName;
      url += "/?user.name=" + user;
      var data = { "state": "STOPPED", "name": serviceName };
      return this.ajax(url, "PUT", { data: data });
    },

    deleteService: function deleteService(serviceName, user) {
      var url = this.buildURL();
      url += "/" + serviceName;
      url += "/?user.name=" + user;
      return this.ajax(url, "DELETE", { data: {} });
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/adapters/yarn-timeline-appattempt', ['exports', 'yarn-ui/adapters/abstract', 'yarn-ui/utils/converter'], function (exports, _yarnUiAdaptersAbstract, _yarnUiUtilsConverter) {
  exports['default'] = _yarnUiAdaptersAbstract['default'].extend({
    address: "timelineWebAddress",
    restNameSpace: "timelineV2",
    serverName: "ATS",

    urlForQuery: function urlForQuery(query /*, modelName*/) {
      var url = this._buildURL();
      var clusterId = this.get("env.app.clusterId");
      if (clusterId) {
        url += '/clusters/' + clusterId;
      }
      var appId = query.appId;
      query.fields = 'ALL';
      delete query.appId;
      return url + '/apps/' + appId + "/entities/YARN_APPLICATION_ATTEMPT";
    },

    urlForFindRecord: function urlForFindRecord(id /*, modelName, snapshot*/) {
      var url = this._buildURL();
      var clusterId = this.get("env.app.clusterId");
      if (clusterId) {
        url += '/clusters/' + clusterId;
      }
      return url + '/apps/' + _yarnUiUtilsConverter['default'].attemptIdToAppId(id) + "/entities/YARN_APPLICATION_ATTEMPT/" + id + "?fields=ALL";
    }

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/adapters/yarn-timeline-container', ['exports', 'yarn-ui/adapters/abstract', 'yarn-ui/utils/converter'], function (exports, _yarnUiAdaptersAbstract, _yarnUiUtilsConverter) {
  exports['default'] = _yarnUiAdaptersAbstract['default'].extend({
    address: "timelineWebAddress",
    restNameSpace: "timelineV2",
    serverName: "ATS",

    urlForQuery: function urlForQuery(query /*, modelName*/) {
      var url = this._buildURL();
      var clusterId = this.get("env.app.clusterId");
      if (clusterId) {
        url += '/clusters/' + clusterId;
      }
      var app_attempt_id = query.app_attempt_id;
      query.fields = 'ALL';
      delete query.app_attempt_id;
      url = url + '/apps/' + _yarnUiUtilsConverter['default'].attemptIdToAppId(app_attempt_id) + '/entities/YARN_CONTAINER';
      return url;
    },

    pathForType: function pathForType() /*modelName*/{
      return '';
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/app', ['exports', 'ember', 'ember-resolver', 'ember/load-initializers', 'yarn-ui/config/environment', 'yarn-ui/utils/sorter'], function (exports, _ember, _emberResolver, _emberLoadInitializers, _yarnUiConfigEnvironment, _yarnUiUtilsSorter) {

  var App;

  _ember['default'].MODEL_FACTORY_INJECTIONS = true;

  App = _ember['default'].Application.extend({
    modulePrefix: _yarnUiConfigEnvironment['default'].modulePrefix,
    podModulePrefix: _yarnUiConfigEnvironment['default'].podModulePrefix,
    Resolver: _emberResolver['default']
  });

  (0, _emberLoadInitializers['default'])(App, _yarnUiConfigEnvironment['default'].modulePrefix);
  _yarnUiUtilsSorter['default'].initDataTableSorter();

  exports['default'] = App;
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/app-attempt-table', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({});
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/app-table', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({});
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/app-timeout-bar', ['exports', 'ember', 'yarn-ui/utils/converter'], function (exports, _ember, _yarnUiUtilsConverter) {
  exports['default'] = _ember['default'].Component.extend({
    app: null,

    appTimeoutValue: (function () {
      var timeoutValueInSecs = this.get("app.remainingTimeoutInSeconds");
      if (timeoutValueInSecs > -1) {
        return _yarnUiUtilsConverter['default'].msToElapsedTime(timeoutValueInSecs * 1000);
      } else {
        return timeoutValueInSecs;
      }
    }).property("app.remainingTimeoutInSeconds"),

    isAppTimedOut: (function () {
      if (this.get("app.remainingTimeoutInSeconds") > 0) {
        return false;
      } else {
        return true;
      }
    }).property("app.remainingTimeoutInSeconds"),

    appTimeoutBarStyle: (function () {
      var remainingInSecs = this.get("app.remainingTimeoutInSeconds"),
          expiryTimestamp = _yarnUiUtilsConverter['default'].dateToTimeStamp(this.get("app.applicationExpiryTime")),
          expiryInSecs = expiryTimestamp / 1000,
          startTimestamp = _yarnUiUtilsConverter['default'].dateToTimeStamp(this.get("app.startTime")),
          startInSecs = startTimestamp / 1000,
          totalRunInSecs = 0,
          appRunDurationInSecs = 0,
          width = 0;

      if (remainingInSecs > 0) {
        totalRunInSecs = expiryInSecs - startInSecs;
        appRunDurationInSecs = totalRunInSecs - remainingInSecs;
        width = appRunDurationInSecs / totalRunInSecs * 100;
      }

      return "width: " + width + "%";
    }).property("app.remainingTimeoutInSeconds", "app.applicationExpiryTime", "app.startTime")
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/app-usage-donut-chart', ['exports', 'yarn-ui/components/base-usage-donut-chart', 'yarn-ui/utils/color-utils', 'yarn-ui/utils/href-address-utils'], function (exports, _yarnUiComponentsBaseUsageDonutChart, _yarnUiUtilsColorUtils, _yarnUiUtilsHrefAddressUtils) {
  exports['default'] = _yarnUiComponentsBaseUsageDonutChart['default'].extend({
    colors: d3.scale.category20().range(),

    draw: function draw() {
      var usageByApps = [];
      var avail = 100;

      this.get("data").forEach((function (app) {
        var v = app.get("clusterUsagePercentage");
        if (v > 1e-2) {
          usageByApps.push({
            label: app.get("id"),
            link: _yarnUiUtilsHrefAddressUtils['default'].getApplicationLink(app.get("id")),
            value: v.toFixed(2)
          });

          avail = avail - v;
        }
      }).bind(this));

      usageByApps.sort(function (a, b) {
        return b.value - a.value;
      });

      usageByApps = this.mergeLongTails(usageByApps, 8);

      usageByApps.push({
        label: "Available",
        value: avail.toFixed(2)
      });

      this.colors = _yarnUiUtilsColorUtils['default'].getColors(usageByApps.length, ["others", "good"], true);

      this.renderDonutChart(usageByApps, this.get("title"), this.get("showLabels"), this.get("middleLabel"), "100%", "%");
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/app-version', ['exports', 'ember-cli-app-version/components/app-version', 'yarn-ui/config/environment'], function (exports, _emberCliAppVersionComponentsAppVersion, _yarnUiConfigEnvironment) {

  var name = _yarnUiConfigEnvironment['default'].APP.name;
  var version = _yarnUiConfigEnvironment['default'].APP.version;

  exports['default'] = _emberCliAppVersionComponentsAppVersion['default'].extend({
    version: version,
    name: name
  });
});
define('yarn-ui/components/bar-chart', ['exports', 'ember', 'yarn-ui/components/base-chart-component'], function (exports, _ember, _yarnUiComponentsBaseChartComponent) {
  exports['default'] = _yarnUiComponentsBaseChartComponent['default'].extend({
    // data:
    //    [{label=label1, value=value1}, ...]
    //    ...
    renderBarChart: function renderBarChart(data, title) {
      var textWidth = arguments.length <= 2 || arguments[2] === undefined ? 50 : arguments[2];

      var g = this.chart.g;
      var layout = this.getLayout();
      this.renderTitleAndBG(g, title, layout);

      var maxValue = -1;
      for (var i = 0; i < data.length; i++) {
        if (data[i] instanceof Array) {
          if (data[i][0].value > maxValue) {
            maxValue = data[i][0].value;
          }
        } else {
          if (data[i].value > maxValue) {
            maxValue = data[i].value;
          }
        }
      }

      var singleBarHeight = 30;

      // 50 is for text
      var maxBarWidth = layout.x2 - layout.x1 - 2 * layout.margin - textWidth - 50;

      // 30 is for title
      var maxBarsHeight = layout.y2 - layout.y1 - 2 * layout.margin - 30;
      var gap = (maxBarsHeight - data.length * singleBarHeight) / (data.length - 1);

      var xScaler = d3.scale.linear().domain([0, maxValue]).range([0, maxBarWidth]);

      var getBarText = function getBarText(i) {
        return data[i].label;
      };
      // show bar text
      for (i = 0; i < data.length; i++) {
        g.append("text").text(getBarText(i)).attr("y", layout.y1 + singleBarHeight / 2 + layout.margin + (gap + singleBarHeight) * i + 30).attr("x", layout.x1 + layout.margin);
      }

      // show bar
      var bar = g.selectAll("bars").data(data).enter().append("rect").attr("y", function (d, i) {
        return layout.y1 + 30 + layout.margin + (gap + singleBarHeight) * i;
      }).attr("x", layout.x1 + layout.margin + textWidth).attr("height", singleBarHeight).attr("fill", (function (d, i) {
        return this.colors[i];
      }).bind(this)).attr("width", 0);

      this.bindTooltip(bar);

      bar.transition().duration(500).attr("width", function (d) {
        var w;
        w = xScaler(d.value);
        // At least each item has 3 px
        w = Math.max(w, 3);
        return w;
      });

      var getBarValue = function getBarValue(i) {
        return data[i].value;
      };
      // show bar value
      for (i = 0; i < data.length; i++) {
        g.append("text").text(getBarValue(i)).attr("y", layout.y1 + singleBarHeight / 2 + layout.margin + (gap + singleBarHeight) * i + 30).attr("x", layout.x1 + layout.margin + textWidth + 15 + xScaler(data[i].value));
      }
    },

    draw: function draw() {
      this.renderBarChart(this.get("data"), this.get("title"), this.get("textWidth"));
    },

    _dataChange: _ember['default'].observer("data", function () {
      this.chart.g.selectAll("*").remove();
      this.draw();
    }),

    didInsertElement: function didInsertElement() {
      this.initChart();
      this.draw();
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/base-chart-component', ['exports', 'ember', 'yarn-ui/utils/converter'], function (exports, _ember, _yarnUiUtilsConverter) {
  exports['default'] = _ember['default'].Component.extend({
    tooltip: undefined,
    colors: d3.scale.category10().range(),

    init: function init() {
      this._super();
      this.set("chart", {
        svg: undefined,
        g: undefined,
        h: 0,
        w: 0,
        tooltip: undefined
      });
    },

    initChart: function initChart() {
      var removeLast = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];

      // Init tooltip if it is not initialized
      // this.tooltip = d3.select("#chart-tooltip");
      if (!this.tooltip) {
        this.tooltip = d3.select("body").append("div").attr("class", "tooltip").attr("id", "chart-tooltip").style("opacity", 0);
      }

      var parentId = this.get("parentId");

      if (removeLast) {
        // Init svg
        var svg = d3.select("#" + parentId + "-svg");
        if (svg) {
          svg.remove();
        }
      }

      var parent = d3.select("#" + parentId);
      var bbox = parent.node().getBoundingClientRect();
      this.chart.w = bbox.width - 30;

      var ratio = 0.75; // 4:3 by default
      if (this.get("ratio")) {
        ratio = this.get("ratio");
      }
      this.chart.h = bbox.width * ratio;

      if (this.get("maxHeight")) {
        this.chart.h = Math.min(this.get("maxHeight"), this.chart.h);
      }

      this.chart.svg = parent.append("svg").attr("width", this.chart.w).attr("height", this.chart.h).attr("id", parentId + "-svg");

      this.chart.g = this.chart.svg.append("g");
    },

    renderTitleAndBG: function renderTitleAndBG(g, title, layout) {
      var background = arguments.length <= 3 || arguments[3] === undefined ? true : arguments[3];

      var bg = g.append("g");
      bg.append("text").text(title).attr("x", (layout.x1 + layout.x2) / 2).attr("y", layout.y1 + layout.margin + 20).attr("class", "chart-title");

      if (background) {
        bg.append("rect").attr("x", layout.x1).attr("y", layout.y1).attr("width", layout.x2 - layout.x1).attr("height", layout.y2 - layout.y1).attr("class", "chart-frame");
      }
    },

    bindTooltip: function bindTooltip(d) {
      d.on("mouseover", (function () {
        this.tooltip.style("left", d3.event.pageX + "px").style("top", d3.event.pageY - 28 + "px");
      }).bind(this)).on("mousemove", (function (d) {
        // Handle pie chart case
        var data = d;
        if (d.data) {
          data = d.data;
        }

        this.tooltip.style("opacity", 0.7);
        var value = data.value;
        if (this.get("type") === "memory") {
          value = _yarnUiUtilsConverter['default'].memoryToSimpliedUnit(value);
        }
        this.tooltip.html(data.label + " = " + value).style("left", d3.event.pageX + "px").style("top", d3.event.pageY - 28 + "px");
      }).bind(this)).on("mouseout", (function () {
        this.tooltip.style("opacity", 0);
      }).bind(this));
    },

    adjustMaxHeight: function adjustMaxHeight(h) {
      this.chart.svg.attr("height", h);
    },

    getLayout: function getLayout() {
      var x1 = 0;
      var y1 = 0;
      var x2 = this.chart.w;
      var y2 = this.chart.h;

      var layout = {
        x1: x1,
        y1: y1,
        x2: x2 - 10,
        y2: y2 - 10,
        margin: 10
      };
      return layout;
    },

    willDestroy: function willDestroy() {
      this.tooltip.remove();
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/components/base-usage-donut-chart", ["exports", "yarn-ui/components/donut-chart"], function (exports, _yarnUiComponentsDonutChart) {
  exports["default"] = _yarnUiComponentsDonutChart["default"].extend({
    mergeLongTails: function mergeLongTails(usages, nItemsKept) {
      var arr = [];
      for (var i = 0; i < Math.min(usages.length, nItemsKept); i++) {
        arr.push(usages[i]);
      }

      var others = {
        label: "Used by others",
        value: 0
      };

      for (i = nItemsKept; i < usages.length; i++) {
        others.value += Number(usages[i].value);
      }
      others.value = others.value.toFixed(2);

      arr.push(others);

      return arr;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/components/breadcrumb-bar", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Component.extend({

    breadcrumbs: null,
    hideRefresh: false,

    actions: {
      refresh: function refresh() {
        this.get("_targetObject").send("refresh");
      }
    }

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/bs-accordion-item', ['exports', 'ember', 'ember-bootstrap/components/bs-accordion-item'], function (exports, _ember, _emberBootstrapComponentsBsAccordionItem) {
  exports['default'] = _emberBootstrapComponentsBsAccordionItem['default'];
});
define('yarn-ui/components/bs-accordion', ['exports', 'ember', 'ember-bootstrap/components/bs-accordion'], function (exports, _ember, _emberBootstrapComponentsBsAccordion) {
  exports['default'] = _emberBootstrapComponentsBsAccordion['default'];
});
define('yarn-ui/components/bs-alert', ['exports', 'ember', 'ember-bootstrap/components/bs-alert'], function (exports, _ember, _emberBootstrapComponentsBsAlert) {
  exports['default'] = _emberBootstrapComponentsBsAlert['default'];
});
define('yarn-ui/components/bs-button-group', ['exports', 'ember', 'ember-bootstrap/components/bs-button-group'], function (exports, _ember, _emberBootstrapComponentsBsButtonGroup) {
  exports['default'] = _emberBootstrapComponentsBsButtonGroup['default'];
});
define('yarn-ui/components/bs-button', ['exports', 'ember', 'ember-bootstrap/components/bs-button'], function (exports, _ember, _emberBootstrapComponentsBsButton) {
  exports['default'] = _emberBootstrapComponentsBsButton['default'];
});
define('yarn-ui/components/bs-collapse', ['exports', 'ember', 'ember-bootstrap/components/bs-collapse'], function (exports, _ember, _emberBootstrapComponentsBsCollapse) {
  exports['default'] = _emberBootstrapComponentsBsCollapse['default'];
});
define('yarn-ui/components/bs-dropdown-button', ['exports', 'ember', 'ember-bootstrap/components/bs-dropdown-button'], function (exports, _ember, _emberBootstrapComponentsBsDropdownButton) {
  exports['default'] = _emberBootstrapComponentsBsDropdownButton['default'];
});
define('yarn-ui/components/bs-dropdown-menu', ['exports', 'ember', 'ember-bootstrap/components/bs-dropdown-menu'], function (exports, _ember, _emberBootstrapComponentsBsDropdownMenu) {
  exports['default'] = _emberBootstrapComponentsBsDropdownMenu['default'];
});
define('yarn-ui/components/bs-dropdown-toggle', ['exports', 'ember', 'ember-bootstrap/components/bs-dropdown-toggle'], function (exports, _ember, _emberBootstrapComponentsBsDropdownToggle) {
  exports['default'] = _emberBootstrapComponentsBsDropdownToggle['default'];
});
define('yarn-ui/components/bs-dropdown', ['exports', 'ember', 'ember-bootstrap/components/bs-dropdown'], function (exports, _ember, _emberBootstrapComponentsBsDropdown) {
  exports['default'] = _emberBootstrapComponentsBsDropdown['default'];
});
define('yarn-ui/components/bs-form-element', ['exports', 'ember', 'ember-bootstrap/components/bs-form-element'], function (exports, _ember, _emberBootstrapComponentsBsFormElement) {
  exports['default'] = _emberBootstrapComponentsBsFormElement['default'];
});
define('yarn-ui/components/bs-form-group', ['exports', 'ember', 'ember-bootstrap/components/bs-form-group'], function (exports, _ember, _emberBootstrapComponentsBsFormGroup) {
  exports['default'] = _emberBootstrapComponentsBsFormGroup['default'];
});
define('yarn-ui/components/bs-form', ['exports', 'ember', 'ember-bootstrap/components/bs-form'], function (exports, _ember, _emberBootstrapComponentsBsForm) {
  exports['default'] = _emberBootstrapComponentsBsForm['default'];
});
define('yarn-ui/components/bs-input', ['exports', 'ember', 'ember-bootstrap/components/bs-input'], function (exports, _ember, _emberBootstrapComponentsBsInput) {
  exports['default'] = _emberBootstrapComponentsBsInput['default'];
});
define('yarn-ui/components/bs-modal-backdrop', ['exports', 'ember-bootstrap/components/bs-modal-backdrop'], function (exports, _emberBootstrapComponentsBsModalBackdrop) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emberBootstrapComponentsBsModalBackdrop['default'];
    }
  });
});
define('yarn-ui/components/bs-modal-body', ['exports', 'ember', 'ember-bootstrap/components/bs-modal-body'], function (exports, _ember, _emberBootstrapComponentsBsModalBody) {
  exports['default'] = _emberBootstrapComponentsBsModalBody['default'];
});
define('yarn-ui/components/bs-modal-dialog', ['exports', 'ember-bootstrap/components/bs-modal-dialog'], function (exports, _emberBootstrapComponentsBsModalDialog) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emberBootstrapComponentsBsModalDialog['default'];
    }
  });
});
define('yarn-ui/components/bs-modal-footer', ['exports', 'ember', 'ember-bootstrap/components/bs-modal-footer'], function (exports, _ember, _emberBootstrapComponentsBsModalFooter) {
  exports['default'] = _emberBootstrapComponentsBsModalFooter['default'];
});
define('yarn-ui/components/bs-modal-header', ['exports', 'ember', 'ember-bootstrap/components/bs-modal-header'], function (exports, _ember, _emberBootstrapComponentsBsModalHeader) {
  exports['default'] = _emberBootstrapComponentsBsModalHeader['default'];
});
define('yarn-ui/components/bs-modal', ['exports', 'ember', 'ember-bootstrap/components/bs-modal'], function (exports, _ember, _emberBootstrapComponentsBsModal) {
  exports['default'] = _emberBootstrapComponentsBsModal['default'];
});
define('yarn-ui/components/bs-select', ['exports', 'ember', 'ember-bootstrap/components/bs-select'], function (exports, _ember, _emberBootstrapComponentsBsSelect) {
  exports['default'] = _emberBootstrapComponentsBsSelect['default'];
});
define('yarn-ui/components/bs-textarea', ['exports', 'ember', 'ember-bootstrap/components/bs-textarea'], function (exports, _ember, _emberBootstrapComponentsBsTextarea) {
  exports['default'] = _emberBootstrapComponentsBsTextarea['default'];
});
define('yarn-ui/components/collapsible-panel', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['pull-right'],

    targetId: '',
    initialClosedState: false,

    didInsertElement: function didInsertElement() {
      if (!this.get('targetId')) {
        this.$('.toggle_switch').hide();
      }
      if (this.get('targetId') && this.get('initialClosedState')) {
        this.$('.toggle_switch').show();
        this.toggleToggleSwitchArrow();
        _ember['default'].$('#' + this.get('targetId')).removeClass('panel-collapsed').show();
      }
    },

    toggleToggleSwitchArrow: function toggleToggleSwitchArrow() {
      var $toggleArrow = this.$('.toggle_switch').find('span');
      if ($toggleArrow.hasClass('glyphicon-chevron-up')) {
        $toggleArrow.removeClass('glyphicon-chevron-up').addClass('glyphicon-chevron-down');
      } else {
        $toggleArrow.removeClass('glyphicon-chevron-down').addClass('glyphicon-chevron-up');
      }
    },

    toggleCollapsiblePanel: function toggleCollapsiblePanel() {
      var $collapsiblePanel = _ember['default'].$('#' + this.get('targetId'));
      if ($collapsiblePanel.hasClass('panel-collapsed')) {
        $collapsiblePanel.removeClass('panel-collapsed');
        $collapsiblePanel.slideDown();
      } else {
        $collapsiblePanel.addClass('panel-collapsed');
        $collapsiblePanel.slideUp();
      }
    },

    actions: {
      togglePanelCollapse: function togglePanelCollapse() {
        this.toggleToggleSwitchArrow();
        this.toggleCollapsiblePanel();
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/components/confirm-dialog", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Component.extend({
    dialogId: "confirmModalDialog",
    title: "Confirm",
    message: "Are you sure?",

    actions: {
      yesConfirmed: function yesConfirmed() {
        this.sendAction();
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/container-table', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({});
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/deploy-service', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    viewType: 'standard',
    savedStandardTemplates: null,
    savedJsonTemplates: null,
    savedTemplateName: '',
    serviceDef: null,
    customServiceDef: '',
    serviceResp: null,
    isLoading: false,
    userName: '',
    hosts: _ember['default'].inject.service('hosts'),

    actions: {
      showSaveTemplateModal: function showSaveTemplateModal() {
        this.$('#saveListModal').modal('show');
      },

      deployService: function deployService() {
        this.set('serviceResp', null);
        if (this.get('isStandardViewType')) {
          this.sendAction("deployServiceDef", this.get('serviceDef'), this.get('userName'));
        } else {
          try {
            var parsed = JSON.parse(this.get('customServiceDef'));
            this.sendAction("deployServiceJson", parsed, this.get('userName'));
          } catch (err) {
            this.set('serviceResp', { type: 'error', message: 'Invalid JSON: ' + err.message });
            throw err;
          }
        }
      },

      updateViewType: function updateViewType(type) {
        this.set('viewType', type);
      },

      addToSavedList: function addToSavedList() {
        this.unselectAllSavedList();
        if (this.get('isStandardViewType')) {
          this.get('savedStandardTemplates').addObject({
            name: this.get('savedTemplateName'),
            defId: this.get('serviceDef.id'),
            active: true
          });
          this.set('serviceDef.isCached', true);
        } else {
          this.get('savedJsonTemplates').addObject({
            name: this.get('savedTemplateName'),
            custom: this.get('customServiceDef'),
            active: true
          });
        }
        this.$('#saveListModal').modal('hide');
        this.set('savedTemplateName', '');
      },

      updateServiceDef: function updateServiceDef(def) {
        this.selectActiveListItem(def);
        if (this.get('isStandardViewType')) {
          this.set('serviceDef', this.getStore().peekRecord('yarn-servicedef', def.defId));
        } else {
          this.set('customServiceDef', def.custom);
        }
      },

      clearConfigs: function clearConfigs() {
        this.unselectAllSavedList();
        this.set('serviceResp', null);
        if (this.get('isStandardViewType')) {
          var oldDef = this.get('serviceDef');
          var def = oldDef.createNewServiceDef();
          this.set('serviceDef', def);
          if (!oldDef.get('isCached')) {
            oldDef.deleteRecord();
          }
        } else {
          this.set('customServiceDef', '');
        }
      },

      removeFromSavedList: function removeFromSavedList(list) {
        if (list.active) {
          this.send('clearConfigs');
        }
        if (this.get('isStandardViewType')) {
          this.get('savedStandardTemplates').removeObject(list);
        } else {
          this.get('savedJsonTemplates').removeObject(list);
        }
      },

      clearServiceResponse: function clearServiceResponse() {
        this.set('serviceResp', null);
      }
    },

    didInsertElement: function didInsertElement() {
      var self = this;
      self.$().find('.modal').on('shown.bs.modal', function () {
        self.$().find('.modal.in').find('input.form-control:first').focus();
      });
    },

    selectActiveListItem: function selectActiveListItem(item) {
      this.unselectAllSavedList();
      _ember['default'].set(item, 'active', true);
    },

    unselectAllSavedList: function unselectAllSavedList() {
      this.get('getSavedList').forEach(function (item) {
        _ember['default'].set(item, 'active', false);
      });
    },

    getSavedList: _ember['default'].computed('viewType', function () {
      if (this.get('isStandardViewType')) {
        return this.get('savedStandardTemplates');
      } else {
        return this.get('savedJsonTemplates');
      }
    }),

    getStore: function getStore() {
      return this.get('serviceDef.store');
    },

    isStandardViewType: _ember['default'].computed.equal('viewType', 'standard'),

    isCustomViewType: _ember['default'].computed.equal('viewType', 'custom'),

    isValidTemplateName: _ember['default'].computed.notEmpty('savedTemplateName'),

    isUserNameGiven: _ember['default'].computed.empty('userName'),

    isValidServiceDef: _ember['default'].computed('serviceDef.name', 'serviceDef.queue', 'serviceDef.version', 'serviceDef.serviceComponents.[]', function () {
      return this.get('serviceDef').isValidServiceDef();
    }),

    isValidCustomServiceDef: _ember['default'].computed.notEmpty('customServiceDef'),

    isSecurityNotEnabled: _ember['default'].computed('isSecurityEnabled', function () {
      return this.get('hosts.isSecurityEnabled') === 'simple';
    }),

    enableSaveOrDeployBtn: _ember['default'].computed('isValidServiceDef', 'isValidCustomServiceDef', 'viewType', 'isLoading', 'isUserNameGiven', function () {
      if (this.get('isLoading')) {
        return false;
      }
      if (this.get('isSecurityNotEnabled') && this.get('isUserNameGiven')) {
        return false;
      }
      if (this.get('isStandardViewType')) {
        return this.get('isValidServiceDef');
      } else {
        return this.get('isValidCustomServiceDef');
      }
    })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/donut-chart', ['exports', 'ember', 'yarn-ui/components/base-chart-component', 'yarn-ui/utils/color-utils', 'yarn-ui/utils/converter', 'yarn-ui/constants'], function (exports, _ember, _yarnUiComponentsBaseChartComponent, _yarnUiUtilsColorUtils, _yarnUiUtilsConverter, _yarnUiConstants) {
  exports['default'] = _yarnUiComponentsBaseChartComponent['default'].extend({
    /*
     * data = [{label="xx", value=},{...}]
     */
    renderDonutChart: function renderDonutChart(data, title) {
      var showLabels = arguments.length <= 2 || arguments[2] === undefined ? false : arguments[2];
      var middleLabel = arguments.length <= 3 || arguments[3] === undefined ? "Total" : arguments[3];
      var middleValue = arguments.length <= 4 || arguments[4] === undefined ? undefined : arguments[4];
      var suffix = arguments.length <= 5 || arguments[5] === undefined ? "" : arguments[5];

      var g = this.chart.g;
      var layout = this.getLayout();
      this.renderTitleAndBG(g, title, layout);

      var total = 0;
      var allZero = true;
      for (var i = 0; i < data.length; i++) {
        total += data[i].value;
        if (data[i].value > 1e-6) {
          allZero = false;
        }
      }

      if (!middleValue) {
        if (this.get(_yarnUiConstants.Entities.Type) === _yarnUiConstants.Entities.Memory) {
          middleValue = _yarnUiUtilsConverter['default'].memoryToSimpliedUnit(total);
        } else if (this.get(_yarnUiConstants.Entities.Type) === _yarnUiConstants.Entities.Resource) {
          middleValue = _yarnUiUtilsConverter['default'].resourceToSimplifiedUnit(total, this.get(_yarnUiConstants.Entities.Unit));
        } else {
          middleValue = total;
        }
      }

      //Width and height
      var h = layout.y2 - layout.y1;

      // 50 is for title
      var outerRadius = (h - 50 - 2 * layout.margin) / 2;

      // Ratio of inner radius to outer radius
      var radiusRatio = 0.75;
      var innerRadius = outerRadius * radiusRatio;

      var arc = d3.svg.arc().innerRadius(innerRadius).outerRadius(outerRadius);

      var cx;
      var cy = layout.y1 + 50 + layout.margin + outerRadius;
      if (showLabels) {
        cx = layout.x1 + layout.margin + outerRadius;
      } else {
        cx = (layout.x1 + layout.x2) / 2;
      }

      var pie = d3.layout.pie();
      pie.sort(null);
      pie.value(function (d) {
        var v = d.value;
        // make sure it > 0
        v = Math.max(v, 1e-6);
        return v;
      });

      //Set up groups
      var arcs = g.selectAll("g.arc").data(pie(data)).enter().append("g").attr("class", "arc").attr("transform", "translate(" + cx + "," + cy + ")");

      function tweenPie(finish) {
        var start = {
          startAngle: 0,
          endAngle: 0
        };
        var i = d3.interpolate(start, finish);
        return function (d) {
          return arc(i(d));
        };
      }

      //Draw arc paths
      var path = arcs.append("path").attr("fill", (function (d, i) {
        if (d.value > 1e-6) {
          return this.colors[i];
        } else {
          return "white";
        }
      }).bind(this)).attr("d", arc).attr("stroke", (function (d, i) {
        if (allZero) {
          return this.colors[i];
        }
      }).bind(this));
      this.bindTooltip(path);
      path.on("click", (function (d) {
        var data = d.data;
        if (data.link) {
          this.tooltip.remove();
          document.location.href = data.link;
        }
      }).bind(this));

      // Show labels
      if (showLabels) {
        var lx = layout.x1 + layout.margin + outerRadius * 2 + 30;
        var squareW = 15;
        var margin = 10;

        var select = g.selectAll(".rect").data(data).enter();
        select.append("rect").attr("fill", (function (d, i) {
          return this.colors[i];
        }).bind(this)).attr("x", lx).attr("y", function (d, i) {
          return layout.y1 + 75 + (squareW + margin) * i + layout.margin;
        }).attr("width", squareW).attr("height", squareW);
        select.append("text").attr("x", lx + squareW + margin).attr("y", function (d, i) {
          return layout.y1 + 80 + (squareW + margin) * i + layout.margin + squareW / 2;
        }).text((function (d) {
          var value = d.value;
          if (this.get("type") === "memory") {
            value = _yarnUiUtilsConverter['default'].memoryToSimpliedUnit(value);
          } else if (this.get("type") === "resource") {
            value = _yarnUiUtilsConverter['default'].resourceToSimplifiedUnit(value, this.get(_yarnUiConstants.Entities.Unit));
          }

          return d.label + ' = ' + value + suffix;
        }).bind(this));
      }

      if (middleLabel) {
        var highLightColor = this.colors[0];
        g.append("text").text(middleLabel).attr("x", cx).attr("y", cy - 10).attr("class", "donut-highlight-text").attr("fill", highLightColor);
        g.append("text").text(middleValue).attr("x", cx).attr("y", cy + 15).attr("class", "donut-highlight-sub").attr("fill", highLightColor);
      }

      path.transition().duration(500).attrTween('d', tweenPie);
    },

    _dataChange: _ember['default'].observer("data", function () {
      this.chart.g.selectAll("*").remove();
      if (this.get("data")) {
        this.draw();
      }
    }),

    draw: function draw() {
      var colorTargets = this.get("colorTargets");
      if (colorTargets) {
        var colorTargetReverse = Boolean(this.get("colorTargetReverse"));
        var targets = colorTargets.split(" ");
        this.colors = _yarnUiUtilsColorUtils['default'].getColors(this.get("data").length, targets, colorTargetReverse);
      }

      this.renderDonutChart(this.get("data"), this.get("title"), this.get("showLabels"), this.get("middleLabel"), this.get("middleValue"), this.get("suffix"));
    },

    didInsertElement: function didInsertElement() {
      // When parentIdPrefix is specified, use parentidPrefix + name as new parent
      // id
      if (this.get("parentIdPrefix")) {
        var newParentId = this.get("parentIdPrefix") + this.get("id");
        this.set("parentId", newParentId);
        console.log(newParentId);
      }

      this.initChart();
      this.draw();
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/em-breadcrumbs', ['exports', 'em-helpers/components/em-breadcrumbs'], function (exports, _emHelpersComponentsEmBreadcrumbs) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emHelpersComponentsEmBreadcrumbs['default'];
    }
  });
});
define('yarn-ui/components/em-progress', ['exports', 'em-helpers/components/em-progress'], function (exports, _emHelpersComponentsEmProgress) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emHelpersComponentsEmProgress['default'];
    }
  });
});
define('yarn-ui/components/em-table-cell', ['exports', 'em-table/components/em-table-cell'], function (exports, _emTableComponentsEmTableCell) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emTableComponentsEmTableCell['default'];
    }
  });
});
define('yarn-ui/components/em-table-column', ['exports', 'em-table/components/em-table-column'], function (exports, _emTableComponentsEmTableColumn) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emTableComponentsEmTableColumn['default'];
    }
  });
});
define('yarn-ui/components/em-table-facet-panel-values', ['exports', 'em-table/components/em-table-facet-panel-values'], function (exports, _emTableComponentsEmTableFacetPanelValues) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emTableComponentsEmTableFacetPanelValues['default'];
    }
  });
});
define('yarn-ui/components/em-table-facet-panel', ['exports', 'em-table/components/em-table-facet-panel'], function (exports, _emTableComponentsEmTableFacetPanel) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emTableComponentsEmTableFacetPanel['default'];
    }
  });
});
define('yarn-ui/components/em-table-header-cell', ['exports', 'em-table/components/em-table-header-cell'], function (exports, _emTableComponentsEmTableHeaderCell) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emTableComponentsEmTableHeaderCell['default'];
    }
  });
});
define('yarn-ui/components/em-table-html-cell', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    content: null
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/em-table-linked-cell', ['exports', 'em-table/components/em-table-linked-cell'], function (exports, _emTableComponentsEmTableLinkedCell) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emTableComponentsEmTableLinkedCell['default'];
    }
  });
});
define('yarn-ui/components/em-table-pagination-ui', ['exports', 'em-table/components/em-table-pagination-ui'], function (exports, _emTableComponentsEmTablePaginationUi) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emTableComponentsEmTablePaginationUi['default'];
    }
  });
});
define('yarn-ui/components/em-table-progress-cell', ['exports', 'em-table/components/em-table-progress-cell'], function (exports, _emTableComponentsEmTableProgressCell) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emTableComponentsEmTableProgressCell['default'];
    }
  });
});
define('yarn-ui/components/em-table-search-ui', ['exports', 'em-table/components/em-table-search-ui'], function (exports, _emTableComponentsEmTableSearchUi) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emTableComponentsEmTableSearchUi['default'];
    }
  });
});
define("yarn-ui/components/em-table-simple-status-cell", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Component.extend({
    content: null,

    classNames: ["em-table-simple-status-cell"],

    statusName: _ember["default"].computed("content", function () {
      var status = this.get("content");

      return status.toLowerCase().capitalize();
    })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/em-table-status-cell', ['exports', 'em-table/components/em-table-status-cell'], function (exports, _emTableComponentsEmTableStatusCell) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emTableComponentsEmTableStatusCell['default'];
    }
  });
});
define("yarn-ui/components/em-table-tooltip-text", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Component.extend({
    content: null,

    classNames: ["em-table-text-with-tooltip"],

    didRender: function didRender() {
      this.$().parent().css("position", "static");
    },

    tooltipText: _ember["default"].computed("content", function () {
      return this.get("content");
    })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/em-table', ['exports', 'em-table/components/em-table'], function (exports, _emTableComponentsEmTable) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emTableComponentsEmTable['default'];
    }
  });
});
define('yarn-ui/components/ember-wormhole', ['exports', 'ember-wormhole/components/ember-wormhole'], function (exports, _emberWormholeComponentsEmberWormhole) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emberWormholeComponentsEmberWormhole['default'];
    }
  });
});
define("yarn-ui/components/fileconfig-viewer-dialog", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Component.extend({
    dialogId: "fileconfig_viewer_dialog",
    title: "File Configuration Properties",
    props: null,
    customProps: _ember["default"].computed('props', function () {
      var custom = [];
      var props = this.get('props');
      for (var pro in props) {
        custom.push({
          name: pro,
          value: props[pro]
        });
      }
      return custom;
    })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/gpu-donut-chart', ['exports', 'yarn-ui/components/donut-chart', 'yarn-ui/utils/color-utils'], function (exports, _yarnUiComponentsDonutChart, _yarnUiUtilsColorUtils) {
  exports['default'] = _yarnUiComponentsDonutChart['default'].extend({
    draw: function draw() {
      // Construct data
      var data = [];
      if (this.get("gpu-render-type") === "gpu-memory") {
        data.push({
          label: "Used",
          value: parseFloat(this.get("gpuInfo").gpuMemoryUsage.usedMemoryMiB)
        });
        data.push({
          label: "Available",
          value: parseFloat(this.get("gpuInfo").gpuMemoryUsage.availMemoryMiB)
        });
      } else if (this.get("gpu-render-type") === "gpu-utilization") {
        var utilization = parseFloat(this.get("gpuInfo").gpuUtilizations.overallGpuUtilization);
        data.push({
          label: "Utilized",
          value: utilization
        });
        data.push({
          label: "Available",
          value: 100 - utilization
        });
      }

      var colorTargets = this.get("colorTargets");
      if (colorTargets) {
        var colorTargetReverse = Boolean(this.get("colorTargetReverse"));
        var targets = colorTargets.split(" ");
        this.colors = _yarnUiUtilsColorUtils['default'].getColors(data.length, targets, colorTargetReverse);
      }

      this.renderDonutChart(data, this.get("title"), this.get("showLabels"), this.get("middleLabel"), this.get("middleValue"), this.get("suffix"));
    },

    didInsertElement: function didInsertElement() {
      // ParentId includes minorNumber
      var newParentId = this.get("parentId") + this.get("gpuInfo").minorNumber;
      this.set("parentId", newParentId);

      this.initChart();
      this.draw();
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/info-tooltip', ['exports', 'ember', 'yarn-ui/utils/info-seeder'], function (exports, _ember, _yarnUiUtilsInfoSeeder) {
  exports['default'] = _ember['default'].Component.extend({
    classNames: ['tooltip', 'info-tooltip'],
    elementId: 'info_tooltip_wrapper',

    didInsertElement: function didInsertElement() {
      var $tooltip = _ember['default'].$('#info_tooltip_wrapper');
      _ember['default'].$('body').on('mouseenter', '.info-icon', function () {
        var $elem = _ember['default'].$(this);
        var info = _yarnUiUtilsInfoSeeder['default'][$elem.data('info')];
        var offset = $elem.offset();
        $tooltip.show();
        $tooltip.find("#tooltip_content").text(info);
        $tooltip.offset({ top: offset.top + 20, left: offset.left - 10 });
      }).on('mouseleave', '.info-icon', function () {
        $tooltip.find("#tooltip_content").text('');
        $tooltip.hide();
      });
    },

    WillDestroyElement: function WillDestroyElement() {
      _ember['default'].$('body').off('hover');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/item-selector', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    didInsertElement: function didInsertElement() {
      $(".js-example-basic-single").select2({
        width: '100%',
        placeholder: "Select a queue"
      });
      var elementId = this.get("element-id");
      var prefix = this.get("prefix");

      var element = d3.select("#" + elementId);

      if (element) {
        this.get("model").forEach(function (o) {
          element.append("option").attr("value", o.get("name")).text(prefix + o.get("name"));
        });
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/jqui-accordion/component', ['exports', 'ember', 'ember-cli-jquery-ui/components/jqui-accordion/component'], function (exports, _ember, _emberCliJqueryUiComponentsJquiAccordionComponent) {
  exports['default'] = _emberCliJqueryUiComponentsJquiAccordionComponent['default'];
});
define('yarn-ui/components/jqui-autocomplete/component', ['exports', 'ember', 'ember-cli-jquery-ui/components/jqui-autocomplete/component'], function (exports, _ember, _emberCliJqueryUiComponentsJquiAutocompleteComponent) {
  exports['default'] = _emberCliJqueryUiComponentsJquiAutocompleteComponent['default'];
});
define('yarn-ui/components/jqui-button/component', ['exports', 'ember', 'ember-cli-jquery-ui/components/jqui-button/component'], function (exports, _ember, _emberCliJqueryUiComponentsJquiButtonComponent) {
  exports['default'] = _emberCliJqueryUiComponentsJquiButtonComponent['default'];
});
define('yarn-ui/components/jqui-datepicker/component', ['exports', 'ember', 'ember-cli-jquery-ui/components/jqui-datepicker/component'], function (exports, _ember, _emberCliJqueryUiComponentsJquiDatepickerComponent) {
  exports['default'] = _emberCliJqueryUiComponentsJquiDatepickerComponent['default'];
});
define('yarn-ui/components/jqui-menu/component', ['exports', 'ember', 'ember-cli-jquery-ui/components/jqui-menu/component'], function (exports, _ember, _emberCliJqueryUiComponentsJquiMenuComponent) {
  exports['default'] = _emberCliJqueryUiComponentsJquiMenuComponent['default'];
});
define('yarn-ui/components/jqui-progress-bar/component', ['exports', 'ember', 'ember-cli-jquery-ui/components/jqui-progress-bar/component'], function (exports, _ember, _emberCliJqueryUiComponentsJquiProgressBarComponent) {
  exports['default'] = _emberCliJqueryUiComponentsJquiProgressBarComponent['default'];
});
define('yarn-ui/components/jqui-slider/component', ['exports', 'ember', 'ember-cli-jquery-ui/components/jqui-slider/component'], function (exports, _ember, _emberCliJqueryUiComponentsJquiSliderComponent) {
  exports['default'] = _emberCliJqueryUiComponentsJquiSliderComponent['default'];
});
define('yarn-ui/components/jqui-spinner/component', ['exports', 'ember', 'ember-cli-jquery-ui/components/jqui-spinner/component'], function (exports, _ember, _emberCliJqueryUiComponentsJquiSpinnerComponent) {
  exports['default'] = _emberCliJqueryUiComponentsJquiSpinnerComponent['default'];
});
define('yarn-ui/components/jqui-tabs/component', ['exports', 'ember', 'ember-cli-jquery-ui/components/jqui-tabs/component'], function (exports, _ember, _emberCliJqueryUiComponentsJquiTabsComponent) {
  exports['default'] = _emberCliJqueryUiComponentsJquiTabsComponent['default'];
});
define('yarn-ui/components/metrics-table', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    metrics: null,
    type: ''
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/node-menu-panel', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    encodedAddr: _ember['default'].computed("nodeAddr", function () {
      return encodeURIComponent(this.get('nodeAddr'));
    })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/components/nodes-heatmap", ["exports", "yarn-ui/components/base-chart-component"], function (exports, _yarnUiComponentsBaseChartComponent) {
  exports["default"] = _yarnUiComponentsBaseChartComponent["default"].extend({
    CELL_WIDTH: 250,
    SAMPLE_CELL_WIDTH: 100,
    SAMPLE_HEIGHT: 30,
    CELL_HEIGHT: 30,
    CELL_MARGIN: 2,
    RACK_MARGIN: 20,
    filter: "",
    selectedCategory: 0,
    memoryLabel: "Memory",
    cpuLabel: "VCores",
    containersLabel: "Containers",
    totalContainers: 0,

    bindTP: function bindTP(element, cell) {
      var currentToolTip = this.tooltip;
      element.on("mouseover", (function () {
        currentToolTip.style("left", d3.event.pageX + "px").style("top", d3.event.pageY - 28 + "px");
        cell.style("opacity", 1.0);
      }).bind(this)).on("mousemove", (function () {
        // Handle pie chart case
        var text = cell.attr("tooltiptext");
        currentToolTip.style("background", "black").style("opacity", 0.7);
        currentToolTip.html(text).style('font-size', '12px').style('color', 'white').style('font-weight', '400');
        currentToolTip.style("left", d3.event.pageX + "px").style("top", d3.event.pageY - 28 + "px");
      }).bind(this)).on("mouseout", (function () {
        currentToolTip.style("opacity", 0);
        cell.style("opacity", 0.8);
      }).bind(this));
    },

    bindSelectCategory: function bindSelectCategory(element, i) {
      element.on("click", (function () {
        if (this.selectedCategory === i) {
          // Remove selection for second click
          this.selectedCategory = 0;
        } else {
          this.selectedCategory = i;
        }
        this.didInsertElement();
      }).bind(this));
    },

    isNodeSelected: function isNodeSelected(node) {
      if (this.filter) {
        var rack = node.get("rack");
        var host = node.get("nodeHostName");
        if (!rack.includes(this.filter) && !host.includes(this.filter)) {
          return false;
        }
      }

      if (this.selectedCategory === 0) {
        return true;
      }

      var usage = this.calcUsage(node);
      var lowerLimit = (this.selectedCategory - 1) * 0.2;
      var upperLimit = this.selectedCategory * 0.2;
      if (lowerLimit <= usage && usage <= upperLimit) {
        return true;
      }
      return false;
    },

    // data:
    //    [{label=label1, value=value1}, ...]
    //    ...
    renderCells: function renderCells(model, title) {
      var selectedOption = d3.select("select").property("value");
      var data = [];
      model.forEach(function (o) {
        data.push(o);
      });

      this.chart.g.remove();
      this.chart.g = this.chart.svg.append("g");
      var g = this.chart.g;
      var layout = this.getLayout();
      layout.margin = 50;

      var racks = new Set();
      for (var i = 0; i < data.length; i++) {
        racks.add(data[i].get("rack"));
      }

      var racksArray = [];
      racks.forEach(function (v) {
        return racksArray.push(v);
      });

      var xOffset = layout.margin;
      var yOffset = layout.margin * 3;

      var gradientStartColor = "#60cea5";
      var gradientEndColor = "#ffbc0b";

      var colorFunc = d3.interpolateRgb(d3.rgb(gradientStartColor), d3.rgb(gradientEndColor));

      var sampleXOffset = (layout.x2 - layout.x1) / 2 - 2.5 * this.SAMPLE_CELL_WIDTH - 2 * this.CELL_MARGIN;
      var sampleYOffset = layout.margin * 2;
      var text;

      for (i = 1; i <= 5; i++) {
        var ratio = i * 0.2 - 0.1;

        var rect = g.append("rect").attr("x", sampleXOffset).attr("y", sampleYOffset).attr("fill", this.selectedCategory === i ? "#26bbf0" : colorFunc(ratio)).attr("width", this.SAMPLE_CELL_WIDTH).attr("height", this.SAMPLE_HEIGHT).attr("class", "hyperlink");
        this.bindSelectCategory(rect, i);
        text = g.append("text").text("" + (ratio * 100).toFixed(1) + "% Used").attr("y", sampleYOffset + this.SAMPLE_HEIGHT / 2 + 5).attr("x", sampleXOffset + this.SAMPLE_CELL_WIDTH / 2).attr("class", "heatmap-cell hyperlink");
        this.bindSelectCategory(text, i);
        sampleXOffset += this.CELL_MARGIN + this.SAMPLE_CELL_WIDTH;
      }

      if (this.selectedCategory !== 0) {
        text = g.append("text").text("Clear").attr("y", sampleYOffset + this.SAMPLE_HEIGHT / 2 + 5).attr("x", sampleXOffset + 20).attr("class", "heatmap-clear hyperlink");
        this.bindSelectCategory(text, 0);
      }

      var chartXOffset = -1;

      this.totalContainers = 0;
      for (i = 0; i < racksArray.length; i++) {
        text = g.append("text").text(racksArray[i]).attr("y", yOffset + this.CELL_HEIGHT / 2 + 5).attr("x", layout.margin).attr("class", "heatmap-rack");

        if (-1 === chartXOffset) {
          chartXOffset = layout.margin + text.node().getComputedTextLength() + 30;
        }

        xOffset = chartXOffset;

        for (var j = 0; j < data.length; j++) {
          var rack = data[j].get("rack");

          if (rack === racksArray[i]) {
            this.totalContainers += data[j].get("numContainers");
            this.addNode(g, xOffset, yOffset, colorFunc, data[j]);
            xOffset += this.CELL_MARGIN + this.CELL_WIDTH;
            if (xOffset + this.CELL_MARGIN + this.CELL_WIDTH >= layout.x2 - layout.margin) {
              xOffset = chartXOffset;
              yOffset = yOffset + this.CELL_MARGIN + this.CELL_HEIGHT;
            }
          }
        }

        while (xOffset > chartXOffset && xOffset + this.CELL_MARGIN + this.CELL_WIDTH < layout.x2 - layout.margin) {
          this.addPlaceholderNode(g, xOffset, yOffset);
          xOffset += this.CELL_MARGIN + this.CELL_WIDTH;
        }

        if (xOffset !== chartXOffset) {
          xOffset = chartXOffset;
          yOffset += this.CELL_MARGIN + this.CELL_HEIGHT;
        }
        yOffset += this.RACK_MARGIN;
      }

      layout.y2 = yOffset + layout.margin;
      this.adjustMaxHeight(layout.y2);
      this.renderTitleAndBG(g, title + selectedOption + ")", layout, false);
    },

    addNode: function addNode(g, xOffset, yOffset, colorFunc, data) {
      var rect = g.append("rect").attr("y", yOffset).attr("x", xOffset).attr("height", this.CELL_HEIGHT).attr("fill", colorFunc(this.calcUsage(data))).attr("width", this.CELL_WIDTH).attr("tooltiptext", data.get("toolTipText") + this.getToolTipText(data));

      if (this.isNodeSelected(data)) {
        rect.style("opacity", 0.8);
        this.bindTP(rect, rect);
      } else {
        rect.style("opacity", 0.8);
        rect.attr("fill", "DimGray");
      }
      var node_id = data.get("id"),
          node_addr = encodeURIComponent(data.get("nodeHTTPAddress")),
          href = "#/yarn-node/" + node_id + "/" + node_addr + "/info";
      var nodeHostName = data.get("nodeHostName");
      var a = g.append("a").attr("href", href);
      a.append("text").text(nodeHostName.length > 30 ? nodeHostName.substr(0, 30) + '...' : nodeHostName).attr("y", yOffset + this.CELL_HEIGHT / 2 + 5).attr("x", nodeHostName.length > 30 ? xOffset + 10 : xOffset + this.CELL_WIDTH / 2).style("text-anchor", nodeHostName.length > 30 ? "start" : "middle").attr("class", this.isNodeSelected(data) ? "heatmap-cell" : "heatmap-cell-notselected");
      if (this.isNodeSelected(data)) {
        this.bindTP(a, rect);
      }
    },

    addPlaceholderNode: function addPlaceholderNode(g, xOffset, yOffset) {
      g.append("rect").attr("y", yOffset).attr("x", xOffset).attr("height", this.CELL_HEIGHT).attr("fill", "grey").attr("width", this.CELL_WIDTH).style("opacity", 0.20);
    },

    draw: function draw() {
      this.initChart(true);
      this.renderCells(this.get("model"), this.get("title"), this.get("textWidth"));
    },

    didInsertElement: function didInsertElement() {
      var self = this;
      var optionsData = [this.memoryLabel, this.cpuLabel, this.containersLabel];
      d3.select("#heatmap-select").on('change', function () {
        self.renderCells(self.get("model"), self.get("title"), self.get("textWidth"));
      }).selectAll('option').data(optionsData).enter().append('option').text(function (d) {
        return d;
      });

      this.draw();
    },

    actions: {
      applyFilter: function applyFilter(event) {
        this.filter = event.srcElement.value;
        this.selectedCategory = 0;
        this.didInsertElement();
      }
    },

    calcUsage: function calcUsage(data) {
      var selectedOption = d3.select('select').property("value");
      if (selectedOption === this.memoryLabel) {
        return data.get("usedMemoryMB") / (data.get("usedMemoryMB") + data.get("availMemoryMB"));
      } else if (selectedOption === this.cpuLabel) {
        return data.get("usedVirtualCores") / (data.get("usedVirtualCores") + data.get("availableVirtualCores"));
      } else if (selectedOption === this.containersLabel) {
        var totalContainers = this.totalContainers;
        if (totalContainers === 0) {
          return 0;
        }
        return data.get("numContainers") / totalContainers;
      }
    },

    getToolTipText: function getToolTipText(data) {
      var selectedOption = d3.select('select').property("value");
      if (selectedOption === this.memoryLabel) {
        return "<p>Used Memory: " + Math.round(data.get("usedMemoryMB")) + " MB</p>" + "<p>Available Memory: " + Math.round(data.get("availMemoryMB")) + " MB</p>";
      } else if (selectedOption === this.cpuLabel) {
        return "<p>Used VCores: " + Math.round(data.get("usedVirtualCores")) + " VCores</p>" + "<p>Available VCores: " + Math.round(data.get("availableVirtualCores")) + " VCores</p>";
      } else if (selectedOption === this.containersLabel) {
        return "<p>Containers: " + Math.round(data.get("numContainers")) + " Containers</p>" + "<p>Total Containers: " + this.totalContainers + " Containers</p>";
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/per-app-memusage-by-nodes-stacked-barchart', ['exports', 'yarn-ui/components/stacked-barchart', 'yarn-ui/utils/converter'], function (exports, _yarnUiComponentsStackedBarchart, _yarnUiUtilsConverter) {
  exports['default'] = _yarnUiComponentsStackedBarchart['default'].extend({
    getDataForRender: function getDataForRender(containers, nodes) {
      var arr = [];
      var nodeToResources = {};
      nodes.forEach(function (n) {
        nodeToResources[n.id] = {
          used: Number(n.get("usedMemoryMB")),
          avail: Number(n.get("availMemoryMB"))
        };
      });

      containers.forEach(function (c) {
        res = nodeToResources[c.get("assignedNodeId")];
        if (res) {
          if (!res.usedByTheApp) {
            res.usedByTheApp = 0;
          }
          res.usedByTheApp += Number(c.get("allocatedMB"));
        }
      });

      for (var nodeId in nodeToResources) {
        var res = nodeToResources[nodeId];

        var subArr = [];
        var value = res.usedByTheApp ? res.usedByTheApp : 0;
        subArr.push({
          value: value,
          bindText: "This app uses " + _yarnUiUtilsConverter['default'].memoryToSimpliedUnit(value) + " on node=" + nodeId
        });

        value = res.used - value;
        value = Math.max(value, 0);
        subArr.push({
          value: value,
          bindText: "Other applications use " + _yarnUiUtilsConverter['default'].memoryToSimpliedUnit(value) + " on node=" + nodeId
        });

        subArr.push({
          value: res.avail,
          bindText: _yarnUiUtilsConverter['default'].memoryToSimpliedUnit(res.avail) + " memory is available on node=" + nodeId
        });

        arr.push(subArr);
      }

      return arr;
    },

    didInsertElement: function didInsertElement() {
      this.initChart(true);

      this.colors = ["lightsalmon", "Grey", "mediumaquamarine"];

      var containers = this.get("rmContainers");
      var nodes = this.get("nodes");

      var data = this.getDataForRender(containers, nodes);

      this.show(data, this.get("title"), ["Used by this app", "Used by other apps", "Available"]);
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/components/per-app-ncontainers-by-nodes-stacked-barchart", ["exports", "yarn-ui/components/stacked-barchart"], function (exports, _yarnUiComponentsStackedBarchart) {
  exports["default"] = _yarnUiComponentsStackedBarchart["default"].extend({
    getDataForRender: function getDataForRender(containers, nodes) {
      var arr = [];
      var nodeToContainers = {};
      nodes.forEach(function (n) {
        nodeToContainers[n.id] = 0;
      });

      containers.forEach(function (c) {
        var nodeId = c.get("assignedNodeId");
        var n = nodeToContainers[nodeId];
        if (undefined !== n) {
          nodeToContainers[nodeId] += 1;
        }
      });

      for (var nodeId in nodeToContainers) {
        var n = nodeToContainers[nodeId];

        var subArr = [];
        subArr.push({
          value: n,
          bindText: "This app has " + n + " containers running on node=" + nodeId
        });

        arr.push(subArr);
      }

      return arr;
    },

    didInsertElement: function didInsertElement() {
      this.initChart(true);

      this.colors = ["Orange", "Grey", "Gainsboro"];

      var containers = this.get("rmContainers");
      var nodes = this.get("nodes");

      var data = this.getDataForRender(containers, nodes);

      this.show(data, this.get("title"), ["Running containers from this app"]);
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/components/per-app-vcoreusage-by-nodes-stacked-barchart", ["exports", "yarn-ui/components/stacked-barchart"], function (exports, _yarnUiComponentsStackedBarchart) {
  exports["default"] = _yarnUiComponentsStackedBarchart["default"].extend({
    getDataForRender: function getDataForRender(containers, nodes) {
      var arr = [];
      var nodeToResources = {};
      nodes.forEach(function (n) {
        nodeToResources[n.id] = {
          used: Number(n.get("usedVirtualCores")),
          avail: Number(n.get("availableVirtualCores"))
        };
      });

      containers.forEach(function (c) {
        res = nodeToResources[c.get("assignedNodeId")];
        if (res) {
          if (!res.usedByTheApp) {
            res.usedByTheApp = 0;
          }
          res.usedByTheApp += Number(c.get("allocatedVCores"));
        }
      });

      for (var nodeId in nodeToResources) {
        var res = nodeToResources[nodeId];

        var subArr = [];
        var value = res.usedByTheApp ? res.usedByTheApp : 0;
        subArr.push({
          value: value,
          bindText: "This app uses " + value + " vcores on node=" + nodeId
        });

        value = res.used - value;
        value = Math.max(value, 0);
        subArr.push({
          value: value,
          bindText: "Other applications use " + value + " vcores on node=" + nodeId
        });

        subArr.push({
          value: res.avail,
          bindText: res.avail + (res.avail > 1 ? " vcores are" : " vcore is") + " available on node=" + nodeId
        });

        arr.push(subArr);
      }

      return arr;
    },

    didInsertElement: function didInsertElement() {
      this.initChart(true);

      this.colors = ["lightsalmon", "Grey", "mediumaquamarine"];

      var containers = this.get("rmContainers");
      var nodes = this.get("nodes");

      var data = this.getDataForRender(containers, nodes);

      this.show(data, this.get("title"), ["Used by this app", "Used by other apps", "Available"]);
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/queue-configuration-table', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({});
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/components/queue-navigator", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Component.extend(_ember["default"].TargetActionSupport, {
    actions: {
      filterQueuesByPartition: function filterQueuesByPartition(filter) {
        this.set("filteredPartition", filter);
        this.sendAction("setFilter", filter);
      }
    },
    didInsertElement: function didInsertElement() {
      var _this = this;

      $(".js-filter-queue-by-labels").select2({
        width: "350px",
        multiple: false
      });

      $(".js-filter-queue-by-labels").on("select2:select", function (e) {
        _this.triggerAction({
          action: "filterQueuesByPartition",
          target: _this,
          actionContext: e.params.data.text
        });
      });
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/queue-usage-donut-chart', ['exports', 'yarn-ui/components/donut-chart', 'yarn-ui/utils/color-utils', 'yarn-ui/utils/href-address-utils'], function (exports, _yarnUiComponentsDonutChart, _yarnUiUtilsColorUtils, _yarnUiUtilsHrefAddressUtils) {
  exports['default'] = _yarnUiComponentsDonutChart['default'].extend({
    colors: d3.scale.category20().range(),

    draw: function draw() {
      var usageByQueues = [];
      var avail = 100;

      var partitionFilter = this.partition;

      this.get("data").forEach(function (queue) {
        if (queue.get("isLeafQueue")) {
          var partitionMap = queue.get("partitionMap");
          var absUsedForPartition = 0;
          if (partitionMap[partitionFilter]) {
            var v = partitionMap[partitionFilter].absoluteUsedCapacity;

            if (v > 1e-2) {
              usageByQueues.push({
                label: queue.get("id"),
                link: _yarnUiUtilsHrefAddressUtils['default'].getQueueLink(queue.get("id")),
                value: v.toFixed(2)
              });

              avail = avail - v;
            }
          }
        }
      });

      usageByQueues.sort(function (a, b) {
        return b.value - a.value;
      });

      usageByQueues.push({
        label: "Available",
        value: avail.toFixed(2)
      });

      this.colors = _yarnUiUtilsColorUtils['default'].getColors(usageByQueues.length, ["good"], true);

      this.renderDonutChart(usageByQueues, this.get("title"), this.get("showLabels"), this.get("middleLabel"), "100%", "%");
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/queue-view', ['exports', 'ember', 'yarn-ui/mixins/charts-utils'], function (exports, _ember, _yarnUiMixinsChartsUtils) {
  exports['default'] = _ember['default'].Component.extend(_yarnUiMixinsChartsUtils['default'], {
    queues: {
      data: undefined,
      foldedQueues: {},
      selectedQueueCircle: undefined,
      maxDepth: -1
    },

    queueColors: d3.scale.category20().range(),

    renderQueue: function renderQueue(now, depth, sequence) {
      if (depth > this.queues.maxDepth) {
        this.queues.maxDepth = depth;
      }

      var cx = 20 + depth * 30;
      var cy = 20 + sequence * 30;
      var name = now.get("name");

      var g = this.queues.dataGroup.append("g").attr("id", "queue-" + name + "-g");

      var folded = this.queues.foldedQueues[name];
      var isParentQueue = false;

      // render its children
      var children = [];
      var childrenNames = now.get("children");
      if (childrenNames) {
        childrenNames.forEach((function (name) {
          isParentQueue = true;
          var child = this.queues.data[name];
          if (child) {
            children.push(child);
          }
        }).bind(this));
      }
      if (folded) {
        children = [];
      }
      var linefunction = d3.svg.line().interpolate("basis").x(function (d) {
        return d.x;
      }).y(function (d) {
        return d.y;
      });

      for (var i = 0; i < children.length; i++) {
        sequence = sequence + 1;
        // Get center of children queue
        var cc = this.renderQueue(children[i], depth + 1, sequence);
        g.append("path").attr("class", "queue").attr("d", linefunction([{
          x: cx,
          y: cy
        }, {
          x: cc.x - 20,
          y: cc.y
        }, cc]));
      }

      var circle = g.append("circle").attr("cx", cx).attr("cy", cy).attr("class", "queue");

      circle.on('mouseover', (function () {}).bind(this));
      circle.on('mouseout', (function () {
        if (circle !== this.queues.selectedQueueCircle) {
          circle.style("fill", this.queueColors[0]);
        }
      }).bind(this));
      circle.on('click', (function () {
        circle.style("fill", this.queueColors[2]);
        var pre = this.queues.selectedQueueCircle;
        this.queues.selectedQueueCircle = circle;
        if (pre) {
          pre.on('mouseout')();
        }
        this.renderCharts(name);
      }).bind(this));
      circle.on('dblclick', (function () {
        if (!isParentQueue) {
          return;
        }

        if (this.queues.foldedQueues[name]) {
          delete this.queues.foldedQueues[name];
        } else {
          this.queues.foldedQueues[name] = now;
        }
        this.renderQueues();
      }).bind(this));

      var text = name;
      if (folded) {
        text = name + " (+)";
      }

      // print queue's name
      g.append("text").attr("x", cx + 30).attr("y", cy + 5).text(text).attr("class", "queue");

      return {
        x: cx,
        y: cy
      };
    },

    renderQueues: function renderQueues() {
      if (this.queues.dataGroup) {
        this.queues.dataGroup.remove();
      }
      // render queues
      this.queues.dataGroup = this.canvas.svg.append("g").attr("id", "queues-g");

      if (this.queues.data) {
        this.renderQueue(this.queues.data['root'], 0, 0);
      }
    },

    draw: function draw() {
      this.queues.data = {};
      this.get("model").forEach((function (o) {
        this.queues.data[o.id] = o;
      }).bind(this));

      // get w/h of the svg
      var bbox = d3.select("#main-container").node().getBoundingClientRect();
      this.canvas.w = bbox.width;
      this.canvas.h = Math.max(Object.keys(this.queues.data).length * 35, 1500);

      this.canvas.svg = d3.select("#main-container").append("svg").attr("width", this.canvas.w).attr("height", this.canvas.h).attr("id", "main-svg");

      this.renderBackground();

      this.renderQueues();
      this.renderCharts("root");
    },

    didInsertElement: function didInsertElement() {
      this.draw();
    },

    /*
     * data = [{label="xx", value=},{...}]
     */
    renderTable: function renderTable(data) {
      d3.select("#main-svg").append('table').selectAll('tr').data(data).enter().append('tr').selectAll('td').data(function (d) {
        return d;
      }).enter().append('td').text(function (d) {
        return d;
      });
    },

    renderQueueCapacities: function renderQueueCapacities(queue, layout) {
      // Render bar chart
      this.renderCells(this.charts.g, [{
        label: "Cap",
        value: queue.get("capacity")
      }, {
        label: "MaxCap",
        value: queue.get("maxCapacity")
      }, {
        label: "UsedCap",
        value: queue.get("usedCapacity")
      }], "Queue Capacities", layout, 60);
    },

    renderChildrenCapacities: function renderChildrenCapacities(queue, layout) {
      var data = [];
      var children = queue.get("children");
      if (children) {
        for (var i = 0; i < children.length; i++) {
          var child = this.queues.data[children[i]];
          data.push({
            label: child.get("name"),
            value: child.get("capacity")
          });
        }
      }

      this.renderDonutChart(this.charts.g, data, "Children Capacities", layout, true);
    },

    renderChildrenUsedCapacities: function renderChildrenUsedCapacities(queue, layout) {
      var data = [];
      var children = queue.get("children");
      if (children) {
        for (var i = 0; i < children.length; i++) {
          var child = this.queues.data[children[i]];
          data.push({
            label: child.get("name"),
            value: child.get("usedCapacity")
          });
        }
      }

      this.renderDonutChart(this.charts.g, data, "Children Used Capacities", layout, true);
    },

    renderLeafQueueUsedCapacities: function renderLeafQueueUsedCapacities(layout) {
      var leafQueueUsedCaps = [];
      for (var queueName in this.queues.data) {
        var q = this.queues.data[queueName];
        if (!q.get("children") || q.get("children").length === 0) {
          // it's a leafqueue
          leafQueueUsedCaps.push({
            label: q.get("name"),
            value: q.get("usedCapacity")
          });
        }
      }

      this.renderDonutChart(this.charts.g, leafQueueUsedCaps, "LeafQueues Used Capacities", layout, true);
    },

    renderCharts: function renderCharts(queueName) {
      this.charts.leftBannerLen = this.queues.maxDepth * 30 + 100;
      this.initCharts();

      var queue = this.queues.data[queueName];
      var idx = 0;

      if (queue.get("name") === "root") {
        this.renderLeafQueueUsedCapacities(this.getLayout(idx++));
      }
      if (queue.get("name") !== "root") {
        this.renderQueueCapacities(queue, this.getLayout(idx++));
      }
      if (queue.get("children") && queue.get("children").length > 0) {
        this.renderChildrenCapacities(queue, this.getLayout(idx++));
        this.renderChildrenUsedCapacities(queue, this.getLayout(idx++));
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/service-component-table', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    serviceDef: null,
    currentComponent: null,
    duplicateNameError: false,

    actions: {
      showAddComponentModal: function showAddComponentModal() {
        var newComp = this.get('serviceDef').createNewServiceComponent();
        this.set('currentComponent', newComp);
        this.set('duplicateNameError', false);
        this.$('#addComponentModal').modal('show');
      },

      addNewComponent: function addNewComponent() {
        this.set('duplicateNameError', false);
        if (this.isCurrentNameDuplicate()) {
          this.set('duplicateNameError', true);
          return;
        }
        this.get('serviceDef.serviceComponents').addObject(this.get('currentComponent'));
        this.$('#addComponentModal').modal('hide');
      },

      removeComponent: function removeComponent(component) {
        this.get('serviceDef.serviceComponents').removeObject(component);
      }
    },

    isCurrentNameDuplicate: function isCurrentNameDuplicate() {
      var currName = this.get('currentComponent.name');
      var item = this.get('serviceDef.serviceComponents').findBy('name', currName);
      return !_ember['default'].isNone(item);
    },

    isValidCurrentComponent: _ember['default'].computed.and('currentComponent', 'currentComponent.name', 'currentComponent.cpus', 'currentComponent.memory', 'currentComponent.numOfContainers', 'currentComponent.launchCommand')
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/service-config-table', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    serviceDef: null,
    currentConfig: null,
    serviceConfigJson: '',

    actions: {
      showNewConfigurationModal: function showNewConfigurationModal() {
        var newConfig = this.get('serviceDef').createNewServiceConfig();
        this.set('currentConfig', newConfig);
        this.$('#addConfigurationModal').modal('show');
        if (this.get('isNonEmptyComponents') && this.get('currentConfig.componentName') === '') {
          this.set('currentConfig.componentName', this.get('componentNames.firstObject'));
        }
      },

      removeConfiguration: function removeConfiguration(config) {
        this.get('serviceDef.serviceConfigs').removeObject(config);
      },

      configTypeChanged: function configTypeChanged(type) {
        this.set('currentConfig.type', type);
        if (type === 'quicklink') {
          this.set('currentConfig.scope', 'service');
          this.set('currentConfig.componentName', '');
        }
      },

      addNewConfiguration: function addNewConfiguration() {
        this.get('serviceDef.serviceConfigs').addObject(this.get('currentConfig'));
        this.$('#addConfigurationModal').modal('hide');
      },

      showServiceConfigUploadModal: function showServiceConfigUploadModal() {
        this.set('serviceConfigJson', '');
        this.$("#service_config_upload_modal").modal('show');
      },

      uploadServiceConfig: function uploadServiceConfig(json) {
        this.get('serviceDef').convertJsonServiceConfigs(json);
        this.$("#service_config_upload_modal").modal('hide');
      },

      configScopeChanged: function configScopeChanged(scope) {
        this.set('currentConfig.scope', scope);
      },

      scopeComponentChanged: function scopeComponentChanged(name) {
        this.set('currentConfig.componentName', name);
      }
    },

    isNonEmptyComponents: _ember['default'].computed('serviceDef.serviceComponents.length', function () {
      return this.get('serviceDef.serviceComponents.length') > 0;
    }),

    isNotQuicklink: _ember['default'].computed('currentConfig.type', function () {
      return this.get('currentConfig.type') !== "quicklink";
    }),

    componentNames: _ember['default'].computed('serviceDef.serviceComponents.[]', function () {
      var names = [];
      this.get('serviceDef.serviceComponents').forEach(function (cmp) {
        names.push(cmp.get('name'));
      });
      return names;
    }),

    isValidCurrentConfig: _ember['default'].computed.and('currentConfig', 'currentConfig.name', 'currentConfig.value')
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/service-fileconfig-table', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    serviceDef: null,
    currentFileConfig: null,
    fileConfigJson: '',
    fileConfigProps: '',
    propertyViewer: null,
    parseError: '',

    actions: {
      showNewConfigFileModal: function showNewConfigFileModal() {
        var newFile = this.get('serviceDef').createNewFileConfig();
        this.set('currentFileConfig', newFile);
        this.set('fileConfigProps', '');
        this.set('parseError', '');
        this.$('#addFileConfigModal').modal('show');
        if (this.get('isNonEmptyComponents') && this.get('currentFileConfig.componentName') === '') {
          this.set('currentFileConfig.componentName', this.get('componentNames.firstObject'));
        }
      },

      removeFileConfiguration: function removeFileConfiguration(file) {
        this.get('serviceDef.fileConfigs').removeObject(file);
      },

      addNewFileConfig: function addNewFileConfig() {
        this.set('parseError', '');
        var props = this.get('fileConfigProps');
        if (props) {
          try {
            var parsed = JSON.parse(props);
            this.set('currentFileConfig.props', parsed);
          } catch (err) {
            this.set('parseError', 'Invalid JSON: ' + err.message);
            throw err;
          }
        }
        this.get('serviceDef.fileConfigs').addObject(this.get('currentFileConfig'));
        this.$('#addFileConfigModal').modal('hide');
      },

      showFileConfigUploadModal: function showFileConfigUploadModal() {
        this.set('fileConfigJson', '');
        this.$("#service_file_config_upload_modal").modal('show');
      },

      uploadFileConfig: function uploadFileConfig(json) {
        this.get('serviceDef').convertJsonFileConfigs(json);
        this.$("#service_file_config_upload_modal").modal('hide');
      },

      configScopeChanged: function configScopeChanged(scope) {
        this.set('currentFileConfig.scope', scope);
      },

      scopeComponentChanged: function scopeComponentChanged(name) {
        this.set('currentFileConfig.componentName', name);
      },

      configTypeChanged: function configTypeChanged(type) {
        this.set('currentFileConfig.type', type);
        if (type === "TEMPLATE") {
          this.set('currentFileConfig.props', null);
          this.set('fileConfigProps', '');
        }
      },

      showFileConfigPropertyViewer: function showFileConfigPropertyViewer(props) {
        this.set('propertyViewer', props);
        this.$("#file_config_properties_viewer").modal('show');
      }
    },

    isNonEmptyComponents: _ember['default'].computed('serviceDef.serviceComponents.length', function () {
      return this.get('serviceDef.serviceComponents.length') > 0;
    }),

    componentNames: _ember['default'].computed('serviceDef.serviceComponents.[]', function () {
      var names = [];
      this.get('serviceDef.serviceComponents').forEach(function (cmp) {
        names.push(cmp.get('name'));
      });
      return names;
    }),

    isValidCurrentFileConfig: _ember['default'].computed('currentFileConfig', 'currentFileConfig.srcFile', 'currentFileConfig.destFile', 'fileConfigProps', function () {
      return this.get('currentFileConfig') && this.get('currentFileConfig.destFile') && (this.get('currentFileConfig.srcFile') || this.get('fileConfigProps'));
    }),

    isConfigTypeHadoopXml: _ember['default'].computed('currentFileConfig.type', function () {
      return this.get('currentFileConfig.type') === 'HADOOP_XML';
    })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/simple-bar-chart', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Component.extend({
    data: [],
    xAxisTickFormatter: null,
    yAxisTickFormatter: null,
    xAxisText: '',
    yAxisText: '',
    enableTooltip: true,
    onBarChartClickCallback: _ember['default'].K,
    hideTootlipOnBarChartClick: true,

    initChart: function initChart() {
      this.height = 400;
      this.barWidth = 30;
      this.width = Math.max(500, 40 * this.data.length);
    },

    drawChart: function drawChart() {
      var margin = { top: 20, right: 20, bottom: 100, left: 100 },
          axisLabelPadding = 10,
          width = this.width - margin.left - margin.right - axisLabelPadding,
          height = this.height - margin.top - margin.bottom - axisLabelPadding,
          xAxisText = this.xAxisText ? this.xAxisText : '',
          yAxisText = this.yAxisText ? this.yAxisText : '',
          data = this.data,
          self = this;

      var xScale = d3.scale.ordinal().rangeRoundBands([0, width], 0.1);
      var yScale = d3.scale.linear().range([height, 0]);

      var xAxis = d3.svg.axis().scale(xScale).orient("bottom").tickFormat(function (tick) {
        if (self.isFunction(self.xAxisTickFormatter)) {
          return self.xAxisTickFormatter(tick);
        } else {
          return tick;
        }
      });

      var yAxis = d3.svg.axis().scale(yScale).orient("left").tickFormat(function (tick) {
        if (self.isFunction(self.yAxisTickFormatter)) {
          return self.yAxisTickFormatter(tick);
        } else {
          return tick;
        }
      });

      var svg = d3.select(this.element).append("svg").attr("class", "simple-bar-chart").attr("width", width + margin.left + margin.right + axisLabelPadding).attr("height", height + margin.top + margin.bottom + axisLabelPadding).append("g").attr("transform", "translate(" + (margin.left + axisLabelPadding) + "," + margin.top + ")");

      xScale.domain(data.map(function (d) {
        return d.label;
      }));
      yScale.domain([0, d3.max(data, function (d) {
        return d.value;
      })]);

      var gx = svg.append("g").attr("class", "x axis").attr("transform", "translate(0," + height + ")").call(xAxis);

      gx.selectAll("text").style("text-anchor", "end").attr("dx", "-.8em").attr("dy", "-.3em").attr("transform", "rotate(-60)");

      gx.append("text").attr("transform", "translate(" + width / 2 + "," + margin.bottom + ")").style("text-anchor", "middle").text(xAxisText);

      var gy = svg.append("g").attr("class", "y axis").call(yAxis);

      gy.append("text").attr("transform", "translate(" + -margin.left + "," + height / 2 + ")rotate(-90)").style("text-anchor", "middle").text(yAxisText);

      var barWidth = this.barWidth;
      var minBarWidth = Math.min(barWidth, xScale.rangeBand());
      var bars = svg.selectAll("bar").data(data).enter().append("rect").attr("x", function (d) {
        var padding = 0;
        var rangeBand = xScale.rangeBand();
        if (rangeBand - barWidth > 0) {
          padding = (rangeBand - barWidth) / 2;
        }
        return xScale(d.label) + padding;
      }).attr("width", minBarWidth).attr("y", function () {
        return yScale(0);
      }).attr("height", function () {
        return height - yScale(0);
      }).on('click', function (d) {
        if (self.enableTooltip && self.hideTootlipOnBarChartClick) {
          self.hideTootlip();
        }
        if (self.isFunction(self.onBarChartClickCallback)) {
          self.onBarChartClickCallback(d);
        }
      });

      bars.transition().duration(1000).delay(100).attr("y", function (d) {
        return yScale(d.value);
      }).attr("height", function (d) {
        return height - yScale(d.value);
      });

      if (this.enableTooltip) {
        this.bindTooltip(bars);
      }
    },

    bindTooltip: function bindTooltip(bars) {
      var self = this;
      var tooltip = this.tooltip;
      if (tooltip) {
        bars.on("mouseenter", function (d) {
          tooltip.html(d.tooltip);
          self.showTooltip();
        }).on("mousemove", function () {
          tooltip.style("left", d3.event.pageX + 5 + "px").style("top", d3.event.pageY - 25 + "px");
        }).on("mouseout", function () {
          self.hideTootlip();
        });
      }
    },

    initTooltip: function initTooltip() {
      this.tooltip = d3.select("body").append("div").attr("class", "tooltip simple-barchart-tooltip").style("opacity", 1);

      this.hideTootlip();
    },

    hideTootlip: function hideTootlip() {
      if (this.tooltip) {
        this.tooltip.style("display", "none");
      }
    },

    showTooltip: function showTooltip() {
      if (this.tooltip) {
        this.tooltip.style("display", "block");
      }
    },

    isFunction: function isFunction(func) {
      return _ember['default'].typeOf(func) === "function";
    },

    didInsertElement: function didInsertElement() {
      this.initChart();
      if (this.enableTooltip) {
        this.initTooltip();
      }
      this.drawChart();
    },

    willDestroyElement: function willDestroyElement() {
      if (this.tooltip) {
        this.tooltip.remove();
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/components/simple-table", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Component.extend({
    didInsertElement: function didInsertElement() {
      var paging = this.get("paging") ? true : this.get("paging");
      var ordering = this.get("ordering") ? true : this.get("ordering");
      var info = this.get("info") ? true : this.get("info");
      var bFilter = this.get("bFilter") ? true : this.get("bFilter");
      var defaultSearch = this.get("defaultSearch") ? this.get("defaultSearch") : "";

      // Defines sorter for the columns if not default.
      // Can also specify a custom sorter.
      var i;
      var colDefs = [];
      if (this.get("colTypes")) {
        var typesArr = this.get("colTypes").split(' ');
        var targetsArr = this.get("colTargets").split(' ');
        for (i = 0; i < typesArr.length; i++) {
          console.log(typesArr[i] + " " + targetsArr[i]);
          colDefs.push({
            type: typesArr[i],
            targets: parseInt(targetsArr[i])
          });
        }
      }
      // Defines initial column and sort order.
      var orderArr = [];
      if (this.get("colsOrder")) {
        var cols = this.get("colsOrder").split(' ');
        for (i = 0; i < cols.length; i++) {
          var col = cols[i].split(',');
          if (col.length !== 2) {
            continue;
          }
          var order = col[1].trim();
          if (order !== 'asc' && order !== 'desc') {
            continue;
          }
          var colOrder = [];
          colOrder.push(parseInt(col[0]));
          colOrder.push(order);
          orderArr.push(colOrder);
        }
      }
      if (orderArr.length === 0) {
        var defaultOrder = [0, 'asc'];
        orderArr.push(defaultOrder);
      }
      console.log(orderArr[0]);
      _ember["default"].$('#' + this.get('table-id')).DataTable({
        "paging": paging,
        "ordering": ordering,
        "info": info,
        "bFilter": bFilter,
        "order": orderArr,
        "columnDefs": colDefs,
        "oSearch": {
          "sSearch": defaultSearch
        }
      });
    }
  });
});

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/spin-spinner', ['exports', 'ember-spin-spinner/components/spin-spinner'], function (exports, _emberSpinSpinnerComponentsSpinSpinner) {
  exports['default'] = _emberSpinSpinnerComponentsSpinSpinner['default'];
});
define("yarn-ui/components/stacked-barchart", ["exports", "yarn-ui/components/base-chart-component"], function (exports, _yarnUiComponentsBaseChartComponent) {
  exports["default"] = _yarnUiComponentsBaseChartComponent["default"].extend({
    MAX_BAR_HEIGHT: 120,
    MAX_BAR_WIDTH: 30,
    GAP: 5,
    filter: "",
    WIDTH_OF_SAMPLE: 200,

    bindTP: function bindTP(element) {
      element.on("mouseover", (function () {
        this.tooltip.style("left", d3.event.pageX + "px").style("top", d3.event.pageY - 28 + "px");
        element.style("opacity", 1.0);
      }).bind(this)).on("mousemove", (function () {
        // Handle pie chart case
        var text = element.attr("tooltiptext");

        this.tooltip.style("opacity", 0.9);
        this.tooltip.html(text).style("left", d3.event.pageX + "px").style("top", d3.event.pageY - 28 + "px");
      }).bind(this)).on("mouseout", (function () {
        this.tooltip.style("opacity", 0);
        element.style("opacity", 0.8);
      }).bind(this));

      element.on("click", (function () {
        if (element.attr("link")) {
          this.tooltip.remove();
          document.location.href = element.attr("link");
        }
      }).bind(this));
    },

    printSamples: function printSamples(n, layout, g, colorTitles) {
      var yOffset = layout.margin * 3;

      for (var i = 0; i < n; i++) {
        var xOffset = layout.x2 - this.WIDTH_OF_SAMPLE - layout.margin;
        g.append("rect").attr("fill", this.colors[i]).attr("x", xOffset).attr("y", yOffset).attr("width", 20).attr("height", 20);

        g.append("text").attr("x", xOffset + 30).attr("y", yOffset + 10).text(colorTitles[i]);

        yOffset = yOffset + 30;
      }
    },

    // data:
    //    [[{value=xx, bindText=xx}, {value=yy, bindText=yy}],  [  ...    ]]
    //     __________________________________________________   ___________
    //                          bar-1                              bar-2
    show: function show(data, title, colorTitles) {
      var width = this.MAX_BAR_WIDTH;
      var height = this.MAX_BAR_HEIGHT;

      this.chart.g.remove();
      this.chart.g = this.chart.svg.append("g");
      var g = this.chart.g;
      var layout = this.getLayout();
      layout.margin = 50;

      var nBarPerRow = Math.floor((layout.x2 - layout.x1 - 3 * layout.margin - this.WIDTH_OF_SAMPLE) / (width + this.GAP));

      var xOffset;
      var yOffset = layout.margin * 2;

      var maxValue = 0;
      var maxN = 0;

      var i = 0;
      var j = 0;

      for (i = 0; i < data.length; i++) {
        var total = 0;
        for (j = 0; j < data[i].length; j++) {
          total += data[i][j].value;
        }

        if (total > maxValue) {
          maxValue = total;
        }
        if (data[i].length > maxN) {
          maxN = data[i].length;
        }
      }

      // print samples
      this.printSamples(maxN, layout, g, colorTitles);

      // print data
      data.sort(function (a, b) {
        return b[0].value - a[0].value;
      });

      for (i = 0; i < data.length; i++) {
        if (i % nBarPerRow === 0) {
          xOffset = layout.margin;
          yOffset += layout.margin + height;
        }

        var leftTopY = yOffset;
        for (j = 0; j < data[i].length; j++) {
          var dy = data[i][j].value * height / maxValue;
          if (dy > 0) {
            leftTopY = leftTopY - dy;

            var node = g.append("rect").attr("fill", this.colors[j]).attr("x", xOffset).attr("y", leftTopY).attr("width", width).attr("height", dy).attr("tooltiptext", data[i][j].bindText ? data[i][j].bindText : data[i][j].value).attr("link", data[i][j].link).style("opacity", 0.8);

            this.bindTP(node);
          }
        }

        if (data[i].length === 1) {
          g.append("text").text(data[i][0].value).attr("y", leftTopY - 10).attr("x", xOffset + width / 2).attr("class", "heatmap-cell").style("fill", "black");
        }

        xOffset += width + this.GAP;
      }

      layout.y2 = yOffset + layout.margin;
      this.adjustMaxHeight(layout.y2);
      this.renderTitleAndBG(g, title, layout, false);
    },

    draw: function draw() {
      this.initChart(true);
      //Mock.initMockNodesData(this);

      // mock data
      var arr = [];
      for (var i = 0; i < 5; i++) {
        var subArr = [];
        for (var j = 0; j < Math.random() * 4 + 1; j++) {
          subArr.push({
            value: Math.abs(Math.random())
          });
        }
        arr.push(subArr);
      }

      this.show(arr, this.get("title"));
    },

    didInsertElement: function didInsertElement() {
      this.draw();
    },

    actions: {
      applyFilter: function applyFilter(event) {
        this.filter = event.srcElement.value;
        this.didInsertElement();
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/components/sunburst-chart", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Component.extend({

    didInsertElement: function didInsertElement() {
      var json = buildHierarchy(this.get("arr"));
      createVisualization(json);
    }

  });

  // Dimensions of sunburst.
  var width = 1000;
  var height = 750;
  var radius = Math.min(width, height) / 2;
  // Breadcrumb dimensions: width, height, spacing, width of tip/tail.
  var b = { w: 225, h: 30, s: 3, t: 10 };
  // Total size of all segments; we set this later, after loading the data.
  var totalSize = 0;
  var vis = null;
  var partition = null;
  var arc = null;
  var colors = d3.scale.category20c();

  function colorMap(d) {
    return colors(d.name);
  }

  // Given a node in a partition layout, return an array of all of its ancestor
  // nodes, highest first, but excluding the root.
  function getAncestors(node) {
    var path = [];
    var current = node;
    while (current.parent) {
      path.unshift(current);
      current = current.parent;
    }
    return path;
  }

  // Main function to draw and set up the visualization, once we have the data.
  function createVisualization(json) {
    partition = d3.layout.partition().size([2 * Math.PI, radius * radius]).value(function (d) {
      return d.size;
    });
    arc = d3.svg.arc().startAngle(function (d) {
      return d.x;
    }).endAngle(function (d) {
      return d.x + d.dx;
    }).innerRadius(function (d) {
      return Math.sqrt(d.y);
    }).outerRadius(function (d) {
      return Math.sqrt(d.y + d.dy);
    });
    // Basic setup of page elements.
    initializeBreadcrumbTrail();
    //drawLegend();
    //d3.select("#togglelegend").on("click", toggleLegend);

    // Bounding circle underneath the sunburst, to make it easier to detect
    // when the mouse leaves the parent g.
    vis = d3.select("#chart").append("svg:svg").attr("width", width).attr("height", height).append("svg:g").attr("id", "container").attr("transform", "translate(" + width / 2 + "," + height / 2 + ")");
    vis.append("svg:circle").attr("r", radius).style("opacity", 0);

    // For efficiency, filter nodes to keep only those large enough to see.
    var nodes = partition.nodes(json).filter(function (d) {
      return d.dx > 0.005; // 0.005 radians = 0.29 degrees
    });

    var path = vis.data([json]).selectAll("path").data(nodes).enter().append("svg:path").attr("display", function (d) {
      return d.depth ? null : "none";
    }).attr("d", arc).attr("fill-rule", "evenodd").attr("fill", colorMap).style("opacity", 1).on("mouseover", mouseover);
    // Add the mouseleave handler to the bounding circle.
    d3.select("#container").on("mouseleave", mouseleave);

    // Get total size of the tree = value of root node from partition.
    totalSize = path.node().__data__.value;
  }

  // Take a 2-column CSV and transform it into a hierarchical structure suitable
  // for a partition layout. The first column is a sequence of step names, from
  // root to leaf, separated by hyphens. The second column is a count of how
  // often that sequence occurred.
  function buildHierarchy(csv) {
    var root = { "name": "root", "children": [] };
    for (var i = 0; i < csv.length; i++) {
      var sequence = csv[i][0];
      var size = +csv[i][1];
      if (isNaN(size)) {
        // e.g. if this is a header row
        continue;
      }
      var parts = sequence.split("-");
      var currentNode = root;
      for (var j = 0; j < parts.length; j++) {
        var children = currentNode["children"];
        var nodeName = parts[j];
        var childNode;
        if (j + 1 < parts.length) {
          // Not yet at the end of the sequence; move down the tree.
          var foundChild = false;
          for (var k = 0; k < children.length; k++) {
            if (children[k]["name"] === nodeName) {
              childNode = children[k];
              foundChild = true;
              break;
            }
          }
          // If we don't already have a child node for this branch, create it.
          if (!foundChild) {
            childNode = { "name": nodeName, "children": [] };
            children.push(childNode);
          }
          currentNode = childNode;
        } else {
          // Reached the end of the sequence; create a leaf node.
          childNode = { "name": nodeName, "size": size, "children": [], "sequence": sequence };
          children.push(childNode);
        }
      }
    }
    return root;
  }

  // Fade all but the current sequence, and show it in the breadcrumb trail.
  function mouseover(d) {
    //var percentage = (100 * d.value / totalSize).toPrecision(3);
    //var percentageString = percentage + "%";
    var percentageString = d.value;

    d3.select("#percentage").html('<p align="center" style="font-size: 150%;"><b>' + percentageString + '</b></p><br/><p align="center">(' + d.name + ')</p>');
    d3.select("#explanation").style("visibility", "");

    var sequenceArray = getAncestors(d);
    updateBreadcrumbs(sequenceArray, percentageString);

    // Fade all the segments.
    d3.selectAll("path").style("opacity", 0.2);

    // Then highlight only those that are an ancestor of the current segment.
    vis.selectAll("path").filter(function (node) {
      return sequenceArray.indexOf(node) >= 0;
    }).style("opacity", 1);
  }

  // Restore everything to full opacity when moving off the visualization.
  function mouseleave() {
    // Hide the breadcrumb trail
    d3.select("#trail").style("visibility", "hidden");

    // Deactivate all segments during transition.
    d3.selectAll("path").on("mouseover", null);

    // Transition each segment to full opacity and then reactivate it.
    d3.selectAll("path").transition().duration(1000).style("opacity", 1).each("end", function () {
      d3.select(this).on("mouseover", mouseover);
    });

    d3.select("#explanation").style("visibility", "hidden");
  }

  function initializeBreadcrumbTrail() {
    // Add the svg area.
    var trail = d3.select("#sequence").append("svg:svg").attr("width", width).attr("height", 50).attr("id", "trail");
    // Add the label at the end, for the percentage.
    trail.append("svg:text").attr("id", "endlabel").style("fill", "#000");
  }

  // Generate a string that describes the points of a breadcrumb polygon.
  function breadcrumbPoints(d, i) {
    var points = [];
    points.push("0,0");
    points.push(b.w + ",0");
    points.push(b.w + b.t + "," + b.h / 2);
    points.push(b.w + "," + b.h);
    points.push("0," + b.h);
    if (i > 0) {
      // Leftmost breadcrumb; don't include 6th vertex.
      points.push(b.t + "," + b.h / 2);
    }
    return points.join(" ");
  }

  // Update the breadcrumb trail to show the current sequence and percentage.
  function updateBreadcrumbs(nodeArray, percentageString) {
    // Data join; key function combines name and depth (= position in sequence).
    var g = d3.select("#trail").selectAll("g").data(nodeArray, function (d) {
      return d.name + d.depth;
    });

    // Add breadcrumb and label for entering nodes.
    var entering = g.enter().append("svg:g");

    entering.append("svg:polygon").attr("points", breadcrumbPoints).attr("fill", colorMap);

    entering.append("svg:text").attr("x", (b.w + b.t) / 2).attr("y", b.h / 2).attr("dy", "0.35em").attr("text-anchor", "middle").text(function (d) {
      return d.name;
    });

    // Set position for entering and updating nodes.
    g.attr("transform", function (d, i) {
      return "translate(" + i * (b.w + b.s) + ", 0)";
    });

    // Remove exiting nodes.
    g.exit().remove();

    // Now move and update the percentage at the end.
    d3.select("#trail").select("#endlabel").attr("x", (nodeArray.length + 0.5) * (b.w + b.s)).attr("y", b.h / 2).attr("dy", "0.35em").attr("text-anchor", "middle").text(percentageString);

    // Make the breadcrumb trail visible, if it's hidden.
    d3.select("#trail").style("visibility", "");
  }
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/components/timeline-view', ['exports', 'ember', 'yarn-ui/utils/converter', 'em-table/utils/column-definition', 'em-table/utils/table-definition'], function (exports, _ember, _yarnUiUtilsConverter, _emTableUtilsColumnDefinition, _emTableUtilsTableDefinition) {
  exports['default'] = _ember['default'].Component.extend({
    tableDefinition: _emTableUtilsTableDefinition['default'].create({
      searchType: 'manual'
    }),
    graphDrawn: false,
    userInfo: null,

    actions: {
      changeViewType: function changeViewType(param) {
        this.sendAction("changeViewType", param);
        if (this.get('attemptModel')) {
          this.setAttemptsGridColumnsAndRows();
        }
      }
    },

    canvas: {
      svg: undefined,
      h: 0,
      w: 0,
      tooltip: undefined
    },

    clusterMetrics: undefined,
    modelArr: [],
    containerIdArr: [],
    colors: d3.scale.category10().range(),
    _selected: undefined,
    gridColumns: [],
    gridRows: [],
    serviceName: undefined,

    selected: (function () {
      return this._selected;
    }).property(),

    tableComponentName: (function () {
      return "app-attempt-table";
    }).property(),

    setSelected: function setSelected(d) {
      var dom;

      if (this._selected === d) {
        return;
      }

      // restore color
      if (this._selected) {
        dom = d3.select("#timeline-bar-" + this._selected.get("id"));
        dom.attr("fill", this.colors[0]);
      }

      this._selected = d;
      this.set("selected", d);
      dom = d3.select("#timeline-bar-" + d.get("id"));
      dom.attr("fill", this.colors[1]);
    },

    getPerItemHeight: function getPerItemHeight() {
      var arrSize = this.modelArr.length;

      if (arrSize < 20) {
        return 30;
      } else if (arrSize < 100) {
        return 10;
      } else {
        return 2;
      }
    },

    getPerItemGap: function getPerItemGap() {
      var arrSize = this.modelArr.length;

      if (arrSize < 20) {
        return 5;
      } else if (arrSize < 100) {
        return 1;
      } else {
        return 1;
      }
    },

    getCanvasHeight: function getCanvasHeight() {
      return (this.getPerItemHeight() + this.getPerItemGap()) * this.modelArr.length + 200;
    },

    draw: function draw(start, end) {
      // get w/h of the svg
      var bbox = d3.select("#" + this.get("parent-id")).node().getBoundingClientRect();
      this.canvas.w = bbox.width;
      this.canvas.h = this.getCanvasHeight();

      this.canvas.svg = d3.select("#" + this.get("parent-id")).append("svg").attr("width", this.canvas.w).attr("height", this.canvas.h).attr("id", this.get("my-id"));
      this.renderTimeline(start, end);
    },

    renderTimeline: function renderTimeline(start, end) {
      var border = 30;
      var singleBarHeight = this.getPerItemHeight();
      var gap = this.getPerItemGap();
      var textWidth = 200;
      /*
       start-time                              end-time
        |--------------------------------------|
           ==============
                  ==============
                          ==============
                                ===============
       */
      var xScaler = d3.scale.linear().domain([start, end]).range([0, this.canvas.w - 2 * border - textWidth]);

      /*
       * Render frame of timeline view
       */
      this.canvas.svg.append("line").attr("x1", border + textWidth).attr("y1", border - 5).attr("x2", this.canvas.w - border).attr("y2", border - 5).attr("class", "chart");

      this.canvas.svg.append("line").attr("x1", border + textWidth).attr("y1", border - 10).attr("x2", border + textWidth).attr("y2", border - 5).attr("class", "chart");

      this.canvas.svg.append("line").attr("x1", this.canvas.w - border).attr("y1", border - 10).attr("x2", this.canvas.w - border).attr("y2", border - 5).attr("class", "chart");

      this.canvas.svg.append("text").text(_yarnUiUtilsConverter['default'].timeStampToDate(start)).attr("y", border - 15).attr("x", border + textWidth).attr("class", "bar-chart-text").attr("text-anchor", "left");

      this.canvas.svg.append("text").text(_yarnUiUtilsConverter['default'].timeStampToDate(end)).attr("y", border - 15).attr("x", this.canvas.w - border).attr("class", "bar-chart-text").attr("text-anchor", "end");

      // show bar
      var bar = this.canvas.svg.selectAll("bars").data(this.modelArr).enter().append("rect").attr("y", function (d, i) {
        return border + (gap + singleBarHeight) * i;
      }).attr("x", function (d) {
        return border + textWidth + xScaler(d.get("startTs"));
      }).attr("height", singleBarHeight).attr("fill", (function () {
        return this.colors[0];
      }).bind(this)).attr("width", function (d) {
        var finishedTs = xScaler(d.get("finishedTs"));
        finishedTs = finishedTs > 0 ? finishedTs : xScaler(end);
        return finishedTs - xScaler(d.get("startTs"));
      }).attr("id", function (d) {
        return "timeline-bar-" + d.get("id");
      });
      bar.on("click", (function (d) {
        this.setSelected(d);
      }).bind(this));

      this.bindTooltip(bar);

      if (this.modelArr.length <= 20) {
        // show bar texts
        for (var i = 0; i < this.modelArr.length; i++) {
          this.canvas.svg.append("text").text(this.modelArr[i].get(this.get("label"))).attr("y", border + (gap + singleBarHeight) * i + singleBarHeight / 2).attr("x", border).attr("class", "bar-chart-text");
        }
      }
    },

    bindTooltip: function bindTooltip(d) {
      d.on("mouseover", (function () {
        this.tooltip.style("left", d3.event.pageX + "px").style("top", d3.event.pageY - 28 + "px");
      }).bind(this)).on("mousemove", (function (d) {
        this.tooltip.style("opacity", 0.9);
        this.tooltip.html(d.get("tooltipLabel")).style("left", d3.event.pageX + "px").style("top", d3.event.pageY - 28 + "px");
      }).bind(this)).on("mouseout", (function () {
        this.tooltip.style("opacity", 0);
      }).bind(this));
    },

    initTooltip: function initTooltip() {
      this.tooltip = d3.select("body").append("div").attr("class", "tooltip").attr("id", "chart-tooltip").style("opacity", 0);
    },

    didInsertElement: function didInsertElement() {
      // init model
      this.modelArr = [];
      this.containerIdArr = [];

      if (this.get("rmModel")) {
        this.get("rmModel").forEach((function (o) {
          if (!this.modelArr.contains(o)) {
            this.modelArr.push(o);
            this.containerIdArr.push(o.id);
          }
        }).bind(this));
      }

      if (this.get("tsModel")) {
        this.get("tsModel").forEach((function (o) {
          if (!this.containerIdArr.contains(o.id)) {
            this.modelArr.push(o);
          }
        }).bind(this));
      }

      if (this.modelArr.length === 0) {
        return;
      }

      this.modelArr.sort(function (a, b) {
        var tsA = a.get("startTs");
        var tsB = b.get("startTs");
        return tsA - tsB;
      });

      if (this.get('attemptModel')) {
        this.setAttemptsGridColumnsAndRows();
      } else {
        this.setContainersGridColumnsAndRows();
      }
    },

    didUpdate: function didUpdate() {
      if (this.get("viewType") === "grid" || this.graphDrawn) {
        return;
      }

      this.initTooltip();

      var begin = 0;
      if (this.modelArr.length > 0) {
        begin = this.modelArr[0].get("startTs");
      }
      var end = 0;
      for (var i = 0; i < this.modelArr.length; i++) {
        var ts = this.modelArr[i].get("finishedTs");
        if (ts > end) {
          end = ts;
        }
      }
      if (end < begin) {
        end = Date.now();
      }

      this.draw(begin, end);

      if (this.modelArr.length > 0) {
        this.setSelected(this.modelArr[0]);
      }

      this.graphDrawn = true;
    },

    setAttemptsGridColumnsAndRows: function setAttemptsGridColumnsAndRows() {
      var self = this;
      var columns = [];
      var serviceName = this.get('serviceName');

      columns.push({
        id: 'id',
        headerTitle: 'Attempt ID',
        contentPath: 'id',
        cellComponentName: 'em-table-linked-cell',
        minWidth: '300px',
        getCellContent: function getCellContent(row) {
          var attemptId = row.get('id');
          var query = 'viewType=' + self.get("viewType");
          if (serviceName) {
            query += '&service=' + serviceName;
          }
          return {
            displayText: attemptId,
            href: '#/yarn-app-attempt/' + attemptId + '?' + query
          };
        }
      }, {
        id: 'attemptStartedTime',
        headerTitle: 'Started Time',
        contentPath: 'attemptStartedTime'
      }, {
        id: 'finishedTime',
        headerTitle: 'Finished Time',
        contentPath: 'finishedTime',
        getCellContent: function getCellContent(row) {
          if (row.get('finishedTs')) {
            return row.get('finishedTime');
          }
          return 'N/A';
        }
      }, {
        id: 'elapsedTime',
        headerTitle: 'Elapsed Time',
        contentPath: 'elapsedTime'
      }, {
        id: 'appMasterContainerId',
        headerTitle: 'AM Container ID',
        contentPath: 'appMasterContainerId',
        minWidth: '350px'
      }, {
        id: 'amNodeId',
        headerTitle: 'AM Node ID',
        contentPath: 'amNodeId'
      }, {
        id: 'attemptState',
        headerTitle: 'State',
        contentPath: 'attemptState',
        getCellContent: function getCellContent(row) {
          var state = row.get('attemptState');
          if (state) {
            return state;
          } else {
            return 'N/A';
          }
        }
      }, {
        id: 'exposedPorts',
        headerTitle: 'Exposed Ports',
        contentPath: 'exposedPorts',
        getCellContent: function getCellContent(row) {
          var ports = row.get('exposedPorts');
          if (ports) {
            return ports;
          } else {
            return 'N/A';
          }
        }
      }, {
        id: 'nodeHttpAddress',
        headerTitle: 'NodeManager Web UI',
        contentPath: 'nodeHttpAddress',
        cellComponentName: 'em-table-html-cell',
        getCellContent: function getCellContent(row) {
          var address = self.checkHttpProtocol(row.get('nodeHttpAddress'));
          var link = row.get('masterNodeURL');
          if (address) {
            return '<a href="' + link + '">' + address + '</a>';
          } else {
            return 'N/A';
          }
        }
      }, {
        id: 'logsLink',
        headerTitle: 'Logs',
        contentPath: 'logsLink',
        cellComponentName: 'em-table-html-cell',
        getCellContent: function getCellContent(row) {
          var containerLogUrl = row.get('appAttemptContainerLogsURL');
          if (containerLogUrl) {
            return '<a href="' + containerLogUrl + '">Link</a>';
          } else {
            return 'N/A';
          }
        }
      });

      var gridCols = _emTableUtilsColumnDefinition['default'].make(columns);
      this.set('gridColumns', gridCols);
      this.set('gridRows', this.modelArr);
    },

    setContainersGridColumnsAndRows: function setContainersGridColumnsAndRows() {
      var self = this;
      var columns = [];

      columns.push({
        id: 'id',
        headerTitle: 'Container ID',
        contentPath: 'id',
        cellComponentName: 'em-table-html-cell',
        minWidth: '350px',
        getCellContent: function getCellContent(row) {
          var termLink = self.checkHttpProtocol(row.get('nodeHttpAddress'));
          var containerId = row.get('id');
          var requestedUser = self.get('requestedUser');
          return '<a href="' + termLink + '/terminal/terminal.template?container=' + containerId + '&user.name=' + requestedUser + '" target="_blank">' + containerId + '</a>';
        }
      }, {
        id: 'startedTime',
        headerTitle: 'Started Time',
        contentPath: 'startedTime'
      }, {
        id: 'finishedTime',
        headerTitle: 'Finished Time',
        contentPath: 'finishedTime',
        getCellContent: function getCellContent(row) {
          if (row.get('finishedTs')) {
            return row.get('finishedTime');
          }
          return 'N/A';
        }
      }, {
        id: 'elapsedTime',
        headerTitle: 'Elapsed Time',
        contentPath: 'elapsedTime'
      }, {
        id: 'priority',
        headerTitle: 'Priority',
        contentPath: 'priority'
      }, {
        id: 'containerExitStatus',
        headerTitle: 'Exit Status',
        contentPath: 'containerExitStatus',
        getCellContent: function getCellContent(row) {
          var status = row.get('containerExitStatus');
          if (status) {
            return status;
          } else {
            return 'N/A';
          }
        }
      }, {
        id: 'containerState',
        headerTitle: 'State',
        contentPath: 'containerState',
        getCellContent: function getCellContent(row) {
          var state = row.get('containerState');
          if (state) {
            return state;
          } else {
            return 'N/A';
          }
        }
      }, {
        id: 'logUrl',
        headerTitle: 'Logs',
        contentPath: 'logUrl',
        cellComponentName: 'em-table-html-cell',
        getCellContent: function getCellContent(row) {
          var containerLogUrl = row.get('appAttemptContainerLogsURL');
          if (containerLogUrl) {
            return '<a href="' + containerLogUrl + '">Link</a>';
          } else {
            return 'N/A';
          }
        }
      }, {
        id: 'exposedPorts',
        headerTitle: 'Exposed Ports',
        contentPath: 'exposedPorts',
        getCellContent: function getCellContent(row) {
          var ports = row.get('exposedPorts');
          if (ports) {
            return ports;
          } else {
            return 'N/A';
          }
        }
      }, {
        id: 'nodeHttpAddress',
        headerTitle: 'Node Manager UI',
        contentPath: 'nodeHttpAddress',
        cellComponentName: 'em-table-html-cell',
        getCellContent: function getCellContent(row) {
          var address = self.checkHttpProtocol(row.get('nodeHttpAddress'));
          var link = row.get('masterNodeURL');
          if (address) {
            return '<a href="' + link + '">' + address + '</a>';
          } else {
            return 'N/A';
          }
        }
      });

      var gridCols = _emTableUtilsColumnDefinition['default'].make(columns);
      this.set('gridColumns', gridCols);
      this.set('gridRows', this.modelArr);
    },

    checkHttpProtocol: function checkHttpProtocol(prop) {
      if (prop && prop.indexOf('://') < 0) {
        prop = 'http://' + prop;
      }
      return prop;
    },

    requestedUser: (function () {
      if (this.get('userInfo')) {
        return this.get('userInfo.requestedUser');
      }
      return '';
    }).property('userInfo')
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/components/tree-selector", ["exports", "ember", "yarn-ui/constants"], function (exports, _ember, _yarnUiConstants) {

  var INBETWEEN_HEIGHT = 130;

  exports["default"] = _ember["default"].Component.extend({
    // Map: <queue-name, queue>
    map: undefined,

    // Normalized data for d3
    treeData: undefined,

    // folded queues, folded[<queue-name>] == true means <queue-name> is folded
    foldedQueues: {},

    // maxDepth
    maxDepth: 0,

    // num of leaf queue, folded queue is treated as leaf queue
    numOfLeafQueue: 0,

    // mainSvg
    mainSvg: undefined,

    used: undefined,
    max: undefined,

    didUpdateAttrs: function didUpdateAttrs(_ref) {
      var oldAttrs = _ref.oldAttrs;
      var newAttrs = _ref.newAttrs;

      if (oldAttrs.filteredPartition.value !== newAttrs.filteredPartition.value) {
        this.reDraw();
      }
    },
    // Init data
    initData: function initData() {
      this.map = {};
      this.treeData = {};
      this.maxDepth = 0;
      this.numOfLeafQueue = 0;

      this.get("model").forEach((function (o) {
        this.map[o.id] = o;
      }).bind(this));

      // var selected = this.get("selected");
      this.used = this.get("used");
      this.max = this.get("max");
      this.initQueue("root", 1, this.treeData);
    },

    // get Children array of given queue
    getChildrenNamesArray: function getChildrenNamesArray(q) {
      var namesArr = [];

      // Folded queue's children is empty
      if (this.foldedQueues[q.get("name")]) {
        return namesArr;
      }

      var names = q.get("children");
      if (names) {
        names.forEach(function (name) {
          namesArr.push(name);
        });
      }

      return namesArr;
    },

    // Init queues
    initQueue: function initQueue(queueName, depth, node) {
      if (!queueName || !this.map[queueName]) {
        // Queue is not existed
        return false;
      }
      if (depth > this.maxDepth) {
        this.maxDepth = this.maxDepth + 1;
      }

      var queue = this.map[queueName];

      if (this.filteredPartition && !queue.get("partitions").contains(this.filteredPartition)) {
        return false;
      }

      var names = this.getChildrenNamesArray(queue);

      node.name = queueName;
      node.parent = queue.get("parent");
      node.queueData = queue;

      if (names.length > 0) {
        node.children = [];

        names.forEach((function (name) {
          var childQueueData = {};
          node.children.push(childQueueData);
          var status = this.initQueue(name, depth + 1, childQueueData);
          if (!status) {
            node.children.pop();
          }
        }).bind(this));
      } else {
        this.numOfLeafQueue = this.numOfLeafQueue + 1;
      }

      return true;
    },

    update: function update(source, root, tree, diagonal) {
      var duration = 300;
      var i = 0;

      // Compute the new tree layout.
      var nodes = tree.nodes(root).reverse();
      var links = tree.links(nodes);

      // Normalize for fixed-depth.
      nodes.forEach(function (d) {
        d.y = d.depth * 200;
      });

      // Update the nodes…
      var node = this.mainSvg.selectAll("g.node").data(nodes, function (d) {
        return d.id || (d.id = ++i);
      });

      // Enter any new nodes at the parent's previous position.
      var nodeEnter = node.enter().append("g").attr("class", "node").attr("transform", function () {
        return "translate(" + (source.y0 + 50) + ", " + source.x0 + ")";
      }).on("click", (function (d) {
        if (d.queueData.get("queuePath") !== this.get("selected")) {
          document.location.href = "#/yarn-queues/" + d.queueData.get("queuePath") + "!";
        }

        _ember["default"].run.later(this, function () {
          var treeWidth = this.maxDepth * 200;
          var treeHeight = this.numOfLeafQueue * INBETWEEN_HEIGHT;
          var tree = d3.layout.tree().size([treeHeight, treeWidth]);
          var diagonal = d3.svg.diagonal().projection(function (d) {
            return [d.y + 50, d.x];
          });

          this.update(this.treeData, this.treeData, tree, diagonal);
        }, 100);
      }).bind(this)).on("dblclick", function (d) {
        document.location.href = "#/yarn-queue/" + d.queueData.get("queuePath") + "/apps";
      });

      nodeEnter.append("circle").attr("r", 1e-6).style("fill", (function (d) {
        var usedCapacity = getUsedCapacity(d.queueData, this.filteredPartition);

        if (usedCapacity <= 60.0) {
          return "#60cea5";
        } else if (usedCapacity <= 100.0) {
          return "#ffbc0b";
        } else {
          return "#ef6162";
        }
      }).bind(this));

      // append percentage
      nodeEnter.append("text").attr("x", function () {
        return 0;
      }).attr("dy", ".35em").attr("fill", "white").attr("text-anchor", function () {
        return "middle";
      }).text((function (d) {
        var usedCapacity = getUsedCapacity(d.queueData, this.filteredPartition);

        if (usedCapacity >= 100.0) {
          return usedCapacity.toFixed(0) + "%";
        } else {
          return usedCapacity.toFixed(1) + "%";
        }
      }).bind(this)).style("fill-opacity", 1e-6);

      // append queue name
      nodeEnter.append("text").attr("x", "0px").attr("dy", "45px").attr("text-anchor", "middle").text(function (d) {
        return d.queueData.get("name");
      }).style("fill-opacity", 1e-6);

      // Transition nodes to their new position.
      var nodeUpdate = node.transition().duration(duration).attr("transform", function (d) {
        return "translate(" + (d.y + 50) + ", " + d.x + ")";
      });

      nodeUpdate.select("circle").attr("r", 30).attr("href", function (d) {
        return "#/yarn-queues/" + d.queueData.get("queuePath");
      }).style("stroke-width", (function (d) {
        if (d.queueData.get("queuePath") === this.get("selected")) {
          return 7;
        } else {
          return 2;
        }
      }).bind(this)).style("stroke", (function (d) {
        if (d.queueData.get("queuePath") === this.get("selected")) {
          return "gray";
        } else {
          return "gray";
        }
      }).bind(this));

      nodeUpdate.selectAll("text").style("fill-opacity", 1);

      // Transition exiting nodes to the parent's new position.
      var nodeExit = node.exit().transition().duration(duration).attr("transform", function () {
        return "translate(" + source.y + ", " + source.x + ")";
      }).remove();

      nodeExit.select("circle").attr("r", 1e-6);

      nodeExit.select("text").style("fill-opacity", 1e-6);

      // Update the links…
      var link = this.mainSvg.selectAll("path.link").data(links, function (d) {
        return d.target.id;
      });

      // Enter any new links at the parent's previous position.
      link.enter().insert("path", "g").attr("class", "link").attr("d", function () {
        var o = { x: source.x0, y: source.y0 + 50 };
        return diagonal({ source: o, target: o });
      });

      // Transition links to their new position.
      link.transition().duration(duration).attr("d", diagonal);

      // Transition exiting nodes to the parent's new position.
      link.exit().transition().duration(duration).attr("d", function () {
        var o = { x: source.x, y: source.y };
        return diagonal({ source: o, target: o });
      }).remove();

      // Stash the old positions for transition.
      nodes.forEach(function (d) {
        d.x0 = d.x;
        d.y0 = d.y;
      });
    },

    reDraw: function reDraw() {
      this.initData();

      var margin = { top: 20, right: 120, bottom: 20, left: 120 };
      var treeWidth = this.maxDepth * 200;
      var treeHeight = this.numOfLeafQueue * INBETWEEN_HEIGHT;
      var width = treeWidth + margin.left + margin.right;
      var height = treeHeight + margin.top + margin.bottom;

      if (this.mainSvg) {
        this.mainSvg.selectAll("*").remove();
      } else {
        this.mainSvg = d3.select("#" + this.get("parentId")).append("svg").attr("width", width).attr("height", height).attr("class", "tree-selector");
      }

      this.mainSvg.append("g").attr("transform", "translate(" + margin.left + "," + margin.top + ")");

      var tree = d3.layout.tree().size([treeHeight, treeWidth]);

      var diagonal = d3.svg.diagonal().projection(function (d) {
        return [d.y + 50, d.x];
      });

      var root = this.treeData;
      root.x0 = height / 2;
      root.y0 = 0;

      d3.select(window.frameElement).style("height", height);

      this.update(root, root, tree, diagonal);
    },

    didInsertElement: function didInsertElement() {
      this.reDraw();
    }
  });

  var getUsedCapacity = function getUsedCapacity(queueData) {
    var filter = arguments.length <= 1 || arguments[1] === undefined ? _yarnUiConstants.PARTITION_LABEL : arguments[1];

    var type = queueData.get("type");
    var result;

    switch (type) {
      case "capacity":
        var partitionMap = queueData.get("partitionMap");
        if (null == partitionMap || null == partitionMap[filter] || null == partitionMap[filter].absoluteUsedCapacity) {
          result = 0.0;
        } else {
          result = partitionMap[filter].absoluteUsedCapacity;
        }
        break;

      case "fair":
        if (null == queueData.get("fairResources") || null == queueData.get("fairResources").memory || null == queueData.get("usedResources") || null == queueData.get("usedResources").memory || 0 == queueData.get("fairResources").memory) {
          result = 0.0;
        } else {
          result = queueData.get("usedResources").memory / queueData.get("fairResources").memory * 100;
        }
        break;

      case "fifo":
        if (null == queueData.get("usedCapacity") || null == queueData.get("capacity") || queueData.get("capacity") == 0) {
          result = 0.0;
        } else {
          result = queueData.get("usedCapacity") / queueData.get("capacity") * 100;
        }
        break;

      default:
        result = 0.0;
    }
    return result;
  };
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/components/upload-config", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Component.extend({
    dialogId: "config_upload_modal",
    title: "Upload Configuration",
    configJson: '',
    parseErrorMsg: '',

    actions: {
      uploadConfig: function uploadConfig() {
        var json = this.get('configJson');
        try {
          JSON.parse(json);
          this.upateParseResults("");
        } catch (ex) {
          this.upateParseResults("Invalid JSON: " + ex.message);
          throw ex;
        }
        if (!this.get('parseErrorMsg')) {
          this.sendAction("uploadConfig", json);
        }
      }
    },

    didInsertElement: function didInsertElement() {
      this.$('#' + this.get('dialogId')).on('shown.bs.modal', (function () {
        this.upateParseResults("");
      }).bind(this));
    },

    isValidConfigJson: _ember["default"].computed.notEmpty('configJson'),

    upateParseResults: function upateParseResults(message) {
      this.set('parseErrorMsg', message);
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/components/yarn-queue-partition-capacity-labels", ["exports", "ember", "yarn-ui/constants"], function (exports, _ember, _yarnUiConstants) {
  var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

  exports["default"] = _ember["default"].Component.extend({
    didUpdateAttrs: function didUpdateAttrs(_ref) {
      var oldAttrs = _ref.oldAttrs;
      var newAttrs = _ref.newAttrs;

      this._super.apply(this, arguments);
      this.set("data", this.initData());
    },

    init: function init() {
      this._super.apply(this, arguments);
      this.set("data", this.initData());
    },

    initData: function initData() {
      var queue = this.get("queue");
      var partitionMap = this.get("partitionMap");
      var resourceUsagesByPartitionMap = this.get("resourceUsagesByPartitionMap");
      var filteredPartition = this.get("filteredPartition") || _yarnUiConstants.PARTITION_LABEL;
      var userLimit = queue.get("userLimit");
      var userLimitFactor = queue.get("userLimitFactor");
      var isLeafQueue = queue.get("isLeafQueue");
      var isWeightMode = queue.get("isWeightMode");
      var isFlexibleDynamicQueue = queue.get("isFlexibleDynamicQueue");
      var weight = queue.get("weight");
      var orderingPolicyInfo = queue.get("orderingPolicyInfo");
      var normalizedWeight = queue.get("normalizedWeight");
      var creationMethod = queue.get("creationMethod");
      var numActiveApplications = queue.get("numActiveApplications");
      var numPendingApplications = queue.get("numPendingApplications");
      var numContainers = queue.get("numContainers");
      var maxApplications = queue.get("maxApplications");
      var maxApplicationsPerUser = queue.get("maxApplicationsPerUser");
      var nodeLabels = queue.get("nodeLabels");
      var defaultNodeLabelExpression = queue.get("defaultNodeLabelExpression");
      var preemptionDisabled = queue.get("preemptionDisabled");
      var intraQueuePreemptionDisabled = queue.get("intraQueuePreemptionDisabled");
      var defaultPriority = queue.get("defaultPriority");

      return _extends({}, partitionMap[filteredPartition], resourceUsagesByPartitionMap[filteredPartition], {
        userLimit: userLimit,
        userLimitFactor: userLimitFactor,
        isLeafQueue: isLeafQueue,
        isWeightMode: isWeightMode,
        weight: weight,
        normalizedWeight: normalizedWeight,
        orderingPolicyInfo: orderingPolicyInfo,
        creationMethod: creationMethod,
        isFlexibleDynamicQueue: isFlexibleDynamicQueue,
        numActiveApplications: numActiveApplications,
        numPendingApplications: numPendingApplications,
        numContainers: numContainers,
        maxApplications: maxApplications,
        maxApplicationsPerUser: maxApplicationsPerUser,
        userLimit: userLimit,
        userLimitFactor: userLimitFactor,
        nodeLabels: nodeLabels,
        defaultNodeLabelExpression: defaultNodeLabelExpression,
        preemptionDisabled: preemptionDisabled,
        intraQueuePreemptionDisabled: intraQueuePreemptionDisabled,
        defaultPriority: defaultPriority
      });
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/config", ["exports"], function (exports) {
  /**
   * Licensed to the Apache Software Foundation (ASF) under one
   * or more contributor license agreements.  See the NOTICE file
   * distributed with this work for additional information
   * regarding copyright ownership.  The ASF licenses this file
   * to you under the Apache License, Version 2.0 (the
   * "License"); you may not use this file except in compliance
   * with the License.  You may obtain a copy of the License at
   *
   *     http://www.apache.org/licenses/LICENSE-2.0
   *
   * Unless required by applicable law or agreed to in writing, software
   * distributed under the License is distributed on an "AS IS" BASIS,
   * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   * See the License for the specific language governing permissions and
   * limitations under the License.
   */

  /**
   * Host and port configurations
   */

  exports["default"] = {};
});
define('yarn-ui/constants', ['exports'], function (exports) {
  /**
   * Licensed to the Apache Software Foundation (ASF) under one
   * or more contributor license agreements.  See the NOTICE file
   * distributed with this work for additional information
   * regarding copyright ownership.  The ASF licenses this file
   * to you under the Apache License, Version 2.0 (the
   * "License"); you may not use this file except in compliance
   * with the License.  You may obtain a copy of the License at
   *
   *     http://www.apache.org/licenses/LICENSE-2.0
   *
   * Unless required by applicable law or agreed to in writing, software
   * distributed under the License is distributed on an "AS IS" BASIS,
   * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   * See the License for the specific language governing permissions and
   * limitations under the License.
   */

  /**
   * Application level global constants go here.
   */
  exports['default'] = {
    PARAM_SEPARATOR: '!'
  };

  var BASE_UNIT = 1024;

  var Type = 'type';
  exports.Type = Type;
  var Memory = 'memory';
  exports.Memory = Memory;
  var Resource = 'resource';
  exports.Resource = Resource;
  var Unit = 'unit';
  exports.Unit = Unit;
  var Entities = {
    Type: 'type',
    Memory: 'memory',
    Resource: 'resource',
    Unit: 'unit'
  };

  exports.Entities = Entities;
  var PARTITION_LABEL = 'Default partition';
  exports.PARTITION_LABEL = PARTITION_LABEL;
});
define('yarn-ui/controllers/app-table-columns', ['exports', 'ember', 'em-table/utils/column-definition', 'em-table/utils/table-definition', 'yarn-ui/utils/converter'], function (exports, _ember, _emTableUtilsColumnDefinition, _emTableUtilsTableDefinition, _yarnUiUtilsConverter) {
  exports['default'] = _ember['default'].Controller.extend({
    tableDefinition: _emTableUtilsTableDefinition['default'].create({
      sortColumnId: 'stTime',
      sortOrder: 'desc'
    }),

    columns: (function () {
      var colums = [];
      colums.push({
        id: 'appId',
        headerTitle: 'Application ID',
        contentPath: 'id',
        cellComponentName: 'em-table-linked-cell',
        minWidth: "280px",
        facetType: null,
        getCellContent: function getCellContent(row) {
          return {
            displayText: row.id,
            href: '#/yarn-app/' + row.id + '/attempts'
          };
        }
      }, {
        id: 'appType',
        headerTitle: 'Application Type',
        contentPath: 'applicationType',
        facetType: null
      }, {
        id: 'appTag',
        headerTitle: 'Application Tag',
        contentPath: 'applicationTags',
        facetType: null
      }, {
        id: 'appName',
        headerTitle: 'Application Name',
        cellComponentName: 'em-table-tooltip-text',
        contentPath: 'appName',
        facetType: null
      }, {
        id: 'appUsr',
        headerTitle: 'User',
        contentPath: 'user',
        minWidth: "50px"
      }, {
        id: 'state',
        headerTitle: 'State',
        contentPath: 'state',
        cellComponentName: 'em-table-simple-status-cell',
        minWidth: "50px"
      }, {
        id: 'queue',
        headerTitle: 'Queue',
        cellComponentName: 'em-table-tooltip-text',
        contentPath: 'queue'
      }, {
        id: 'progress',
        headerTitle: 'Progress',
        contentPath: 'progress',
        cellComponentName: 'em-table-progress-cell',
        facetType: null,
        cellDefinition: {
          valueMax: 100
        }
      }, {
        id: 'stTime',
        headerTitle: 'Start Time',
        contentPath: 'startTime',
        facetType: null,
        getCellContent: function getCellContent(row) {
          return row.get('formattedStartTime');
        }
      }, {
        id: 'elTime',
        headerTitle: 'Elapsed Time',
        contentPath: 'elapsedTime',
        facetType: null,
        cellDefinition: {
          type: "duration"
        }
      }, {
        id: 'finishTime',
        headerTitle: 'Finished Time',
        contentPath: 'validatedFinishedTs',
        facetType: null,
        observePath: true,
        getCellContent: function getCellContent(row) {
          return row.get('formattedFinishedTime');
        }
      }, {
        id: 'priority',
        headerTitle: 'Priority',
        contentPath: 'priority'
      }, {
        id: 'cluster',
        headerTitle: '%Cluster',
        contentPath: 'clusterUsagePercentage',
        observePath: true
      });
      return _emTableUtilsColumnDefinition['default'].make(colums);
    }).property(),

    serviceColumns: (function () {
      var colums = [];
      colums.push({
        id: 'appName',
        headerTitle: 'Service Name',
        contentPath: 'appName',
        minWidth: "200px",
        facetType: null,
        cellComponentName: 'em-table-linked-cell',
        getCellContent: function getCellContent(row) {
          return {
            displayText: row.get('appName'),
            href: '#/yarn-app/' + row.id + '/components?service=' + row.get('appName')
          };
        }
      }, {
        id: 'appId',
        headerTitle: 'Application Tag',
        contentPath: 'id',
        facetType: null,
        cellComponentName: 'em-table-tooltip-text',
        minWidth: "250px"
      }, {
        id: 'appTag',
        headerTitle: 'Application ID',
        contentPath: 'applicationTags',
        facetType: null
      }, {
        id: 'state',
        headerTitle: 'State',
        contentPath: 'state',
        cellComponentName: 'em-table-simple-status-cell',
        minWidth: "50px"
      }, {
        id: 'cluster',
        headerTitle: '%Cluster',
        contentPath: 'clusterUsagePercentage',
        facetType: null,
        observePath: true
      }, {
        id: 'elTime',
        headerTitle: 'Elapsed Time',
        contentPath: 'elapsedTime',
        facetType: null,
        cellDefinition: {
          type: "duration"
        },
        minWidth: "200px"
      }, {
        id: 'appUsr',
        headerTitle: 'User',
        contentPath: 'user',
        facetType: null,
        minWidth: "50px"
      }, {
        id: 'queue',
        headerTitle: 'Queue',
        contentPath: 'queue',
        cellComponentName: 'em-table-tooltip-text'
      }, {
        id: 'stTime',
        headerTitle: 'Started Time',
        contentPath: 'startTime',
        facetType: null,
        getCellContent: function getCellContent(row) {
          return row.get('formattedStartTime');
        }
      }, {
        id: 'finishTime',
        headerTitle: 'Finished Time',
        contentPath: 'validatedFinishedTs',
        facetType: null,
        observePath: true,
        getCellContent: function getCellContent(row) {
          return row.get('formattedFinishedTime');
        }
      });
      return _emTableUtilsColumnDefinition['default'].make(colums);
    }).property()
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/application', ['exports', 'ember'], function (exports, _ember) {

  /**
   * Base controller for application.
   */
  exports['default'] = _ember['default'].Controller.extend({
    /**
     * Output main top UI menu which is common across all pages.
     * Menu item will be made active based on current path.
     */
    outputMainMenu: (function () {
      var path = this.get('currentPath');
      var html = '<li';
      if (path === 'yarn-queue') {
        html = html + ' class="active"';
      }
      html = html + '><a href="yarn-queue/root">Queues<span class="sr-only">' + '(current)</span></a></li><li';
      if (path.lastIndexOf('yarn-app', 0) === 0) {
        html = html + ' class="active"';
      }
      html = html + '><a href="yarn-apps">Applications<span class="sr-only">' + '(current)</span></a></li><li';
      if (path === 'cluster-overview') {
        html = html + ' class="active"';
      }
      html = html + '><a href="cluster-overview">Cluster Overview<span class=' + '"sr-only">(current)</span></a></li><li';
      if (path.lastIndexOf('yarn-node', 0) === 0) {
        html = html + ' class="active"';
      }
      html = html + '><a href="yarn-nodes">Nodes<span class="sr-only">' + '(current)</span></a></li>';
      return _ember['default'].String.htmlSafe(html);
    }).property('currentPath'),

    isQueuesTabActive: (function () {
      var path = this.get('currentPath');
      if (path === 'yarn-queues') {
        return true;
      }
      return false;
    }).property('currentPath'),

    clusterInfo: (function () {
      if (this.model && this.model.clusterInfo) {
        return this.model.clusterInfo.get('firstObject');
      }
      return null;
    }).property('model.clusterInfo'),

    userInfo: (function () {
      if (this.model && this.model.userInfo) {
        return this.model.userInfo.get('firstObject');
      }
      return null;
    }).property('model.userInfo'),

    isTimelineUnHealthy: (function () {
      if (this.model && this.model.timelineHealth) {
        return this.model.timelineHealth.get('isTimelineUnHealthy');
      }
      return true;
    }).property('model.timelineHealth')
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/array', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller;
});
define('yarn-ui/controllers/cluster-overview', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller.extend({
    loading: true,

    breadcrumbs: [{
      text: "Home",
      routeName: 'application'
    }, {
      text: "Cluster Overview",
      routeName: 'cluster-overview'
    }]

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/object', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller;
});
define("yarn-ui/controllers/yarn-app-attempt", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Controller.extend({
    queryParams: ["service", "viewType"],
    service: undefined,
    viewType: "graph",

    actions: {
      changeViewType: function changeViewType(param) {
        this.set("viewType", param);
      }
    },

    breadcrumbs: _ember["default"].computed("model.attempt.appId", "model.attempt.id", function () {
      var appId = this.get("model.attempt.appId");
      var attemptId = this.get("model.attempt.id");
      var serviceName = this.get('service');
      var breadcrumbs = [{
        text: "Home",
        routeName: 'application'
      }, {
        text: "Applications",
        routeName: 'yarn-apps.apps'
      }, {
        text: "App [" + appId + "]",
        href: "#/yarn-app/" + appId + "/attempts"
      }, {
        text: "Attempts",
        href: "#/yarn-app/" + appId + "/attempts"
      }, {
        text: "Attempt [" + attemptId + "]"
      }];
      if (serviceName) {
        breadcrumbs = [{
          text: "Home",
          routeName: 'application'
        }, {
          text: "Services",
          routeName: 'yarn-services'
        }, {
          text: serviceName + " [" + appId + "]",
          href: "#/yarn-app/" + appId + "/components?service=" + serviceName
        }, {
          text: "Attempts",
          href: "#/yarn-app/" + appId + "/attempts?service=" + serviceName
        }, {
          text: "Attempt [" + attemptId + "]"
        }];
      }
      return breadcrumbs;
    })

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-app', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller.extend({
    appId: '',
    serviceName: undefined,

    breadcrumbs: [{
      text: "Home",
      routeName: 'application'
    }, {
      text: "Applications",
      routeName: 'yarn-apps.apps'
    }, {
      text: 'App'
    }],

    actions: {
      showStopServiceConfirm: function showStopServiceConfirm() {
        this.set('actionResponse', null);
        _ember['default'].$("#stopServiceConfirmDialog").modal('show');
      },

      stopService: function stopService() {
        var self = this;
        _ember['default'].$("#stopServiceConfirmDialog").modal('hide');
        var adapter = this.store.adapterFor('yarn-servicedef');
        self.set('isLoading', true);
        adapter.stopService(this.model.serviceName, this.get('model.app.user')).then(function () {
          self.set('actionResponse', { msg: 'Service stopped successfully. Auto refreshing in 5 seconds.', type: 'success' });
          _ember['default'].run.later(self, function () {
            this.set('actionResponse', null);
            this.send("refresh");
          }, 5000);
        }, function (errr) {
          var messg = 'Error: Stop service failed!';
          if (errr.errors && errr.errors[0] && errr.errors[0].diagnostics) {
            messg = 'Error: ' + errr.errors[0].diagnostics;
          }
          self.set('actionResponse', { msg: messg, type: 'error' });
        })['finally'](function () {
          self.set('isLoading', false);
        });
      },

      showDeleteServiceConfirm: function showDeleteServiceConfirm() {
        this.set('actionResponse', null);
        _ember['default'].$("#deleteServiceConfirmDialog").modal('show');
      },

      deleteService: function deleteService() {
        var self = this;
        _ember['default'].$("#deleteServiceConfirmDialog").modal('hide');
        var adapter = this.store.adapterFor('yarn-servicedef');
        self.set('isLoading', true);
        adapter.deleteService(this.model.serviceName, this.get('model.app.user')).then(function () {
          self.set('actionResponse', { msg: 'Service deleted successfully. Redirecting to services in 5 seconds.', type: 'success' });
          _ember['default'].run.later(self, function () {
            this.set('actionResponse', null);
            this.transitionToRoute("yarn-services");
          }, 5000);
        }, function (errr) {
          var messg = 'Error: Delete service failed!';
          if (errr.errors && errr.errors[0] && errr.errors[0].diagnostics) {
            messg = 'Error: ' + errr.errors[0].diagnostics;
          }
          self.set('actionResponse', { msg: messg, type: 'error' });
        })['finally'](function () {
          self.set('isLoading', false);
        });
      },

      showKillApplicationConfirm: function showKillApplicationConfirm() {
        this.set('actionResponse', null);
        _ember['default'].$("#killApplicationConfirmDialog").modal('show');
      },

      killApplication: function killApplication() {
        var self = this;
        _ember['default'].$("#killApplicationConfirmDialog").modal('hide');
        var adapter = this.store.adapterFor('yarn-app');
        self.set('isLoading', true);
        adapter.sendKillApplication(this.model.app.id).then(function () {
          self.set('actionResponse', {
            msg: 'Application killed successfully. Auto refreshing in 5 seconds.',
            type: 'success'
          });
          _ember['default'].run.later(self, function () {
            this.set('actionResponse', null);
            this.send("refresh");
          }, 5000);
        }, function (err) {
          var message = err.diagnostics || 'Error: Kill application failed!';
          self.set('actionResponse', { msg: message, type: 'error' });
        })['finally'](function () {
          self.set('isLoading', false);
        });
      },

      resetActionResponse: function resetActionResponse() {
        this.set('actionResponse', null);
      }
    },

    isRunningService: _ember['default'].computed('model.serviceName', 'model.app.state', function () {
      return this.model.serviceName && this.model.app.get('state') === 'RUNNING';
    }),

    updateBreadcrumbs: function updateBreadcrumbs(appId, serviceName, tailCrumbs) {
      var breadcrumbs = [{
        text: "Home",
        routeName: 'application'
      }];
      if (appId && serviceName) {
        breadcrumbs.push({
          text: "Services",
          routeName: 'yarn-services'
        }, {
          text: serviceName + ' [' + appId + ']',
          href: '#/yarn-app/' + appId + '/components?service=' + serviceName
        });
      } else {
        breadcrumbs.push({
          text: "Applications",
          routeName: 'yarn-apps.apps'
        }, {
          text: 'App [' + appId + ']',
          href: '#/yarn-app/' + appId + '/attempts'
        });
      }
      if (tailCrumbs) {
        breadcrumbs.pushObjects(tailCrumbs);
      }
      this.set('breadcrumbs', breadcrumbs);
    },

    amHostHttpAddressFormatted: _ember['default'].computed('model.app.amHostHttpAddress', function () {
      var amHostAddress = this.get('model.app.amHostHttpAddress');
      if (amHostAddress && amHostAddress.indexOf('://') < 0) {
        amHostAddress = 'http://' + amHostAddress;
      }
      return amHostAddress;
    }),

    isAppKillable: _ember['default'].computed("model.app.state", function () {
      if (this.get("model.app.applicationType") === 'yarn-service') {
        return false;
      }
      var killableStates = ['NEW', 'NEW_SAVING', 'SUBMITTED', 'ACCEPTED', 'RUNNING'];
      return killableStates.indexOf(this.get("model.app.state")) > -1;
    }),

    isServiceDeployedOrRunning: _ember['default'].computed('model.serviceInfo', function () {
      var serviceInfo = this.get('model.serviceInfo');
      var stoppedStates = ['STOPPED', 'SUCCEEDED', 'FAILED'];
      if (serviceInfo) {
        return stoppedStates.indexOf(serviceInfo.get('state')) === -1;
      }
      return false;
    }),

    isServiceStoppped: _ember['default'].computed('model.serviceInfo', function () {
      var serviceInfo = this.get('model.serviceInfo');
      var stoppedStates = ['STOPPED', 'SUCCEEDED'];
      if (serviceInfo) {
        return stoppedStates.indexOf(serviceInfo.get('state')) > -1;
      }
      return false;
    })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/controllers/yarn-app/attempts", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Controller.extend({
    queryParams: ["service", "viewType"],
    service: undefined,
    viewType: "graph",

    actions: {
      changeViewType: function changeViewType(param) {
        this.set("viewType", param);
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-app/charts', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller.extend({
    queryParams: ["service"],
    service: undefined,

    isRunningApp: _ember['default'].computed('model.app.state', function () {
      return this.get('model.app.state') === "RUNNING";
    })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-app/components', ['exports', 'ember', 'em-table/utils/column-definition', 'em-table/utils/table-definition'], function (exports, _ember, _emTableUtilsColumnDefinition, _emTableUtilsTableDefinition) {
  exports['default'] = _ember['default'].Controller.extend({
    queryParams: ["service"],
    service: undefined,

    tableDefinition: _emTableUtilsTableDefinition['default'].create({
      searchType: 'manual'
    }),

    tableColumns: _ember['default'].computed('model.appId', 'model.serviceName', function () {
      var cols = [];
      var service = this.get('model.serviceName');
      var appId = this.get('model.appId');

      cols.push({
        id: 'name',
        headerTitle: 'Component',
        contentPath: 'name',
        cellComponentName: 'em-table-linked-cell',
        getCellContent: function getCellContent(row) {
          return {
            displayText: row.get('name'),
            href: '#/yarn-component-instances/' + row.get('name') + '/info?service=' + service + '&appid=' + appId
          };
        }
      }, {
        id: 'vcores',
        headerTitle: 'VCores',
        contentPath: 'vcores'
      }, {
        id: 'memory',
        headerTitle: 'Memory (MB)',
        contentPath: 'memory'
      }, {
        id: 'instances',
        headerTitle: 'Number of Instances',
        contentPath: 'instances',
        observePath: true
      });

      return _emTableUtilsColumnDefinition['default'].make(cols);
    })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/controllers/yarn-app/configs", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Controller.extend({
    queryParams: ["service"],
    service: undefined
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-app/info', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller.extend({
    queryParams: ["service"],
    service: undefined,
    isLoading: false,
    actionResponse: null,

    actions: {
      showStopServiceConfirm: function showStopServiceConfirm() {
        this.set('actionResponse', null);
        _ember['default'].$("#stopServiceConfirmDialog").modal('show');
      },

      stopService: function stopService() {
        var self = this;
        _ember['default'].$("#stopServiceConfirmDialog").modal('hide');
        var adapter = this.store.adapterFor('yarn-servicedef');
        self.set('isLoading', true);
        adapter.stopService(this.get('service'), this.get('model.app.user')).then(function () {
          self.set('actionResponse', { msg: 'Service stopped successfully. Auto refreshing in 5 seconds.', type: 'success' });
          _ember['default'].run.later(self, function () {
            this.set('actionResponse', null);
            this.send("refresh");
          }, 5000);
        }, function (errr) {
          var messg = errr.diagnostics || 'Error: Stop service failed!';
          self.set('actionResponse', { msg: messg, type: 'error' });
        })['finally'](function () {
          self.set('isLoading', false);
        });
      },

      showDeleteServiceConfirm: function showDeleteServiceConfirm() {
        this.set('actionResponse', null);
        _ember['default'].$("#deleteServiceConfirmDialog").modal('show');
      },

      deleteService: function deleteService() {
        var self = this;
        _ember['default'].$("#deleteServiceConfirmDialog").modal('hide');
        var adapter = this.store.adapterFor('yarn-servicedef');
        self.set('isLoading', true);
        adapter.deleteService(this.get('service'), this.get('model.app.user')).then(function () {
          self.set('actionResponse', { msg: 'Service deleted successfully. Redirecting to services in 5 seconds.', type: 'success' });
          _ember['default'].run.later(self, function () {
            this.set('actionResponse', null);
            this.transitionToRoute("yarn-services");
          }, 5000);
        }, function (errr) {
          var messg = errr.diagnostics || 'Error: Delete service failed!';
          self.set('actionResponse', { msg: messg, type: 'error' });
        })['finally'](function () {
          self.set('isLoading', false);
        });
      },

      resetActionResponse: function resetActionResponse() {
        this.set('actionResponse', null);
      }
    },

    isRunningService: _ember['default'].computed('model.serviceName', 'model.app.state', function () {
      return this.get('service') !== undefined && this.get('model.app.state') === 'RUNNING';
    }),

    amHostHttpAddressFormatted: _ember['default'].computed('model.app.amHostHttpAddress', function () {
      var amHostAddress = this.get('model.app.amHostHttpAddress');
      if (amHostAddress && amHostAddress.indexOf('://') < 0) {
        amHostAddress = 'http://' + amHostAddress;
      }
      return amHostAddress;
    }),

    totalOutstandingResourceRequests: _ember['default'].computed('model.app.resourceRequests', function () {
      var resourceRequests = this.get('model.app.resourceRequests');
      if (resourceRequests) {
        var _ret = (function () {
          var totatResourceRequests = { memory: 0, vCores: 0 };
          [].forEach.call(resourceRequests, function (resource) {
            if (resource.resourceName === '*') {
              var totalMemory = resource.capability.resourceInformations.resourceInformation[0].value * resource.numContainers;
              var totalVCores = resource.capability.resourceInformations.resourceInformation[1].value * resource.numContainers;
              totatResourceRequests.memory += totalMemory;
              totatResourceRequests.vCores += totalVCores;
            }
          });
          return {
            v: totatResourceRequests
          };
        })();

        if (typeof _ret === 'object') return _ret.v;
      }
      return null;
    })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-app/logs', ['exports', 'ember', 'yarn-ui/constants'], function (exports, _ember, _yarnUiConstants) {
  var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

  exports['default'] = _ember['default'].Controller.extend({
    queryParams: ["service", "attempt", "containerid"],
    service: undefined,
    attempt: undefined,
    containerid: undefined,

    selectedAttemptId: "",
    attemptContainerList: null,
    selectedContainerId: "",
    selectedLogFileName: "",
    containerLogFiles: null,
    selectedLogFileContent: "",

    _isLoadingTopPanel: false,
    _isLoadingBottomPanel: false,

    initializeSelect: function initializeSelect() {
      var selector = arguments.length <= 0 || arguments[0] === undefined ? ".js-fetch-attempt-containers" : arguments[0];

      _ember['default'].run.schedule("afterRender", this, function () {
        $(selector).select2({ width: "350px", multiple: false });
      });
    },

    actions: {
      showContainersForAttemptId: function showContainersForAttemptId(attemptId) {
        var _this = this;

        var containerId = arguments.length <= 1 || arguments[1] === undefined ? "" : arguments[1];

        this.set("selectedAttemptId", "");
        if (attemptId) {
          this.set("_isLoadingTopPanel", true);
          this.set("selectedAttemptId", attemptId);
          this.fetchContainersForAttemptId(attemptId).then(function (hash) {
            var containers = null;
            var containerIdArr = {};

            // Getting running containers from the RM first
            if (hash.rmContainers.get("length") > 0 && hash.rmContainers.get("content")) {
              hash.rmContainers.get("content").forEach((function (o) {
                containerIdArr[o.id] = true;
              }).bind(_this));
              containers = (containers || []).concat(hash.rmContainers.get("content"));
            }

            var historyProvider = _this.fallbackToJHS ? hash.jhsContainers : hash.tsContainers;
            var fieldName = _this.fallbackToJHS ? "containerId" : "id";

            // Getting aggregated containers from the selected history provider
            if (historyProvider.get("length") > 0 && historyProvider.get("content")) {
              (function () {
                var historyContainers = [];
                historyProvider.get("content").forEach((function (o) {
                  if (!containerIdArr[o[fieldName]]) {
                    historyContainers.push(o);
                  }
                }).bind(_this));
                containers = (containers || []).concat(historyContainers);
              })();
            }

            _this.set("attemptContainerList", containers);
            _this.initializeSelect(".js-fetch-logs-containers");
            if (containerId) {
              _this.send("showLogFilesForContainerId", containerId);
            }
          })['finally'](function () {
            _this.set("_isLoadingTopPanel", false);
          });
        } else {
          this.set("attemptContainerList", null);
          this.set("selectedContainerId", "");
          this.set("containerLogFiles", null);
          this.set("selectedLogFileName", "");
          this.set("selectedLogFileContent", "");
        }
      },

      showLogFilesForContainerId: function showLogFilesForContainerId(containerId) {
        var _this2 = this;

        this.set("selectedContainerId", "");
        this.set("containerLogFiles", null);
        this.set("selectedLogFileName", "");
        this.set("selectedLogFileContent", "");

        if (containerId) {
          this.set("_isLoadingBottomPanel", true);
          this.set("selectedContainerId", containerId);
          this.fetchLogFilesForContainerId(containerId).then(function (hash) {
            if (hash.logs.get("length") > 0) {
              _this2.set("containerLogFiles", hash.logs);
            } else {
              _this2.set("containerLogFiles", null);
            }
            _this2.initializeSelect(".js-fetch-log-for-container");
          })['finally'](function () {
            _this2.set("_isLoadingBottomPanel", false);
          });
        }
      },

      showContentForLogFile: function showContentForLogFile(logFile) {
        var _this3 = this;

        this.set("selectedLogFileName", "");
        _ember['default'].$("#logContentTextArea1234554321").val("");
        this.set("showFullLog", false);
        if (logFile) {
          this.set("_isLoadingBottomPanel", true);
          this.set("selectedLogFileName", logFile);
          var id = this.get("selectedContainerId") + _yarnUiConstants['default'].PARAM_SEPARATOR + logFile;
          this.fetchContentForLogFile(id).then(function (hash) {
            _this3.set("selectedLogFileContent", hash.logs.get('logs').trim());
          }, function () {
            _this3.set("selectedLogFileContent", "");
          }).then(function () {
            _this3.set("_isLoadingBottomPanel", false);
          });
        } else {
          this.set("selectedLogFileContent", "");
        }
      },

      findNextTextInLogContent: function findNextTextInLogContent() {
        var searchInputElem = document.getElementById("logSeachInput98765");
        this.send("searchTextInLogContent", searchInputElem.value);
      },

      searchTextInLogContent: function searchTextInLogContent(searchText) {
        _ember['default'].$("body").scrollTop(278);
        var textAreaElem = document.getElementById("logContentTextArea1234554321");
        var logContent = textAreaElem.innerText;
        var startIndex = this.searchTextStartIndex || 0;
        if (startIndex === -1) {
          startIndex = this.searchTextStartIndex = 0;
        }
        if (this.prevSearchText !== searchText) {
          startIndex = this.searchTextStartIndex = 0;
        }
        if (searchText && searchText.trim()) {
          searchText = searchText.trim();
          this.prevSearchText = searchText;
          if (startIndex === 0) {
            startIndex = logContent.indexOf(searchText, 0);
          }
          var endIndex = startIndex + searchText.length;
          if (document.createRange && window.getSelection) {
            var range = document.createRange();
            range.selectNodeContents(textAreaElem);
            range.setStart(textAreaElem.childNodes.item(0), startIndex);
            range.setEnd(textAreaElem.childNodes.item(0), endIndex);
            var selection = window.getSelection();
            selection.removeAllRanges();
            selection.addRange(range);
          }
          this.searchTextStartIndex = logContent.indexOf(searchText, endIndex + 1);
        } else {
          this.searchTextStartIndex = 0;
        }
      },

      showFullLogFileContent: function showFullLogFileContent() {
        this.set("showFullLog", true);
        this.notifyPropertyChange("selectedLogFileContent");
      }
    },

    attemptList: _ember['default'].computed("model.attempts", function () {
      var attempts = this.get("model.attempts");
      var list = null;
      if (attempts && attempts.get("length") && attempts.get("content")) {
        list = [].concat(attempts.get("content"));
      }
      return list;
    }),

    fetchContainersForAttemptId: function fetchContainersForAttemptId(attemptId) {
      var request = {};

      request["rmContainers"] = this.store.query("yarn-container", {
        app_attempt_id: attemptId
      })['catch'](function (error) {
        return _ember['default'].A();
      });

      var historyProvider = this.fallbackToJHS ? "jhsContainers" : "tsContainers";
      var historyQuery = this.fallbackToJHS ? "yarn-jhs-container" : "yarn-timeline-container";

      request[historyProvider] = this.store.query(historyQuery, {
        app_attempt_id: attemptId
      })['catch'](function (error) {
        return _ember['default'].A();
      });

      return _ember['default'].RSVP.hash(request);
    },

    fetchLogFilesForContainerId: function fetchLogFilesForContainerId(containerId) {
      var _this4 = this;

      var queryName = this.fallbackToJHS ? "yarn-jhs-log" : "yarn-log";
      var redirectQuery = queryName === "yarn-jhs-log" ? "yarn-jhs-redirect-log" : "yarn-redirect-log";

      return _ember['default'].RSVP.hash({
        logs: this.resolveRedirectableQuery(this.store.query(queryName, { containerId: containerId }), function (m) {
          return m.map(function (model) {
            return model.get('redirectedUrl');
          })[0];
        }, function (url) {
          return _this4.store.query(redirectQuery, url);
        })
      });
    },

    fetchContentForLogFile: function fetchContentForLogFile(id) {
      var _this5 = this;

      var queryName = this.fallbackToJHS ? 'yarn-app-jhs-log' : 'yarn-app-log';
      var redirectQuery = queryName === "yarn-app-jhs-log" ? "yarn-app-jhs-redirect-log" : "yarn-app-redirect-log";

      return _ember['default'].RSVP.hash({
        logs: this.resolveRedirectableQuery(this.store.findRecord(queryName, id), function (m) {
          return m.get('redirectedUrl');
        }, function (url) {
          return _this5.store.findRecord(redirectQuery, url + _yarnUiConstants['default'].PARAM_SEPARATOR + id);
        })
      });
    },

    resolveRedirectableQuery: function resolveRedirectableQuery(initial, urlResolver, redirectResolver) {
      return initial.then(function (m) {
        var redirectedUrl = urlResolver(m);
        if (redirectedUrl !== null && redirectedUrl !== undefined && redirectedUrl !== '') {
          var logFromRedirect = redirectResolver(redirectedUrl);
          return Promise.all([m, logFromRedirect]);
        } else {
          return Promise.all([m, null]);
        }
      }).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2);

        var originalLog = _ref2[0];
        var logFromRedirect = _ref2[1];

        return logFromRedirect !== null ? logFromRedirect : originalLog;
      })['catch'](function () {
        return _ember['default'].A();
      });
    },

    resetAfterRefresh: function resetAfterRefresh() {
      this.set("selectedAttemptId", "");
      this.set("attemptContainerList", null);
      this.set("selectedContainerId", "");
      this.set("selectedLogFileName", "");
      this.set("containerLogFiles", null);
      this.set("selectedLogFileContent", "");
    },

    showFullLog: false,

    showLastFewLinesOfLogContent: _ember['default'].computed("selectedLogFileContent", function () {
      var content = this.get("selectedLogFileContent");
      var lines = content.split("\n");
      if (this.get("showFullLog") || lines.length < 10) {
        return content;
      }
      return lines.slice(lines.length - 10).join("\n");
    }),

    isLogAggregationNotSucceeded: _ember['default'].computed("model.app", function () {
      var logAggregationStatus = this.get("model.app.logAggregationStatus");
      return logAggregationStatus !== "SUCCEEDED";
    }),

    fallbackToJHS: (function () {
      // Let's fall back to JHS if ATS is not available, but JHS is.
      return this.model && (!this.model.timelineHealth || this.model.timelineHealth.get('isTimelineUnHealthy')) && this.model.jhsHealth && this.model.jhsHealth.get('isJHSHealthy');
    }).property('model.timelineHealth', 'model.isJHSHealthy'),

    areJHSandATSUnhealthy: (function () {
      if (this.model && this.model.timelineHealth) {
        if (!this.model.timelineHealth.get('isTimelineUnHealthy')) {
          return false;
        }
      }
      if (this.model && this.model.jhsHealth) {
        if (this.model.jhsHealth.get('isJHSHealthy')) {
          return false;
        }
      }
      return true;
    }).property('model.timelineHealth', 'model.isJHSHealthy')
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-app/threaddump', ['exports', 'ember', 'yarn-ui/constants'], function (exports, _ember, _yarnUiConstants) {
  exports['default'] = _ember['default'].Controller.extend({
    queryParams: ["service", "attempt", "containerid"],
    service: undefined,
    attempt: undefined,
    containerid: undefined,

    selectedAttemptId: "",
    attemptContainerList: null,
    selectedContainerId: "",
    selectedLogFileName: "",
    containerLogFiles: null,
    selectedContainerThreaddumpContent: "",
    containerNodeMappings: [],
    threaddumpErrorMessage: "",
    stdoutLogsFetchFailedError: "",
    appAttemptToStateMappings: [],

    _isLoadingTopPanel: false,
    _isLoadingBottomPanel: false,
    _isThreaddumpAttemptFailed: false,
    _isStdoutLogsFetchFailed: false,

    initializeSelect: function initializeSelect() {
      var selector = arguments.length <= 0 || arguments[0] === undefined ? ".js-fetch-attempt-containers" : arguments[0];

      _ember['default'].run.schedule("afterRender", this, function () {
        $(selector).select2({ width: "350px", multiple: false });
      });
    },

    actions: {
      showContainersForAttemptId: function showContainersForAttemptId(attemptId) {
        var _this = this;

        var containerId = arguments.length <= 1 || arguments[1] === undefined ? "" : arguments[1];

        this.set("selectedAttemptId", "");
        if (attemptId) {
          this.set("_isLoadingTopPanel", true);
          this.set("selectedAttemptId", attemptId);
          this.fetchRunningContainersForAttemptId(attemptId).then(function (hash) {
            var containers = null;
            var containerIdArr = {};
            var containerNodeMapping = null;
            var nodeHttpAddress = null;

            // Getting RUNNING containers from the RM first.
            if (hash.rmContainers.get("length") > 0 && hash.rmContainers.get("content")) {
              // Create a container-to-NMnode mapping for later use.
              hash.rmContainers.get("content").forEach((function (containerInfo) {
                nodeHttpAddress = containerInfo._data.nodeHttpAddress;
                nodeHttpAddress = nodeHttpAddress.replace(/(^\w+:|^)\/\//, '');
                containerNodeMapping = _ember['default'].Object.create({
                  name: containerInfo.id,
                  value: nodeHttpAddress
                });
                this.containerNodeMappings.push(containerNodeMapping);
                containerIdArr[containerInfo.id] = true;
              }).bind(_this));

              containers = (containers || []).concat(hash.rmContainers.get("content"));
            }

            _this.set("attemptContainerList", containers);
            _this.initializeSelect(".js-fetch-threaddump-containers");

            if (containerId) {
              _this.send("showThreaddumpForContainer", containerId);
            }
          })['finally'](function () {
            _this.set("_isLoadingTopPanel", false);
          });
        } else {
          this.set("attemptContainerList", null);
          this.set("selectedContainerId", "");
          this.set("containerLogFiles", null);
          this.set("selectedLogFileName", "");
          this.set("selectedContainerThreaddumpContent", "");
          this.set("containerNodeMappings", []);
        }
      },

      showThreaddumpForContainer: function showThreaddumpForContainer(containerIdForThreaddump) {
        _ember['default'].$("#logContentTextArea1234554321").val("");
        this.set("showFullThreaddump", false);
        this.set("selectedContainerId", containerIdForThreaddump);
        this.set("_isLoadingBottomPanel", true);
        this.set("_isStdoutLogsFetchFailed", false);
        this.set("stdoutLogsFetchFailedError", "");
        this.set("_isThreaddumpAttemptFailed", false);
        this.set("threaddumpErrorMessage", "");

        if (containerIdForThreaddump) {
          this.set("selectedContainerThreaddumpContent", "");

          this.fetchThreaddumpForContainer(containerIdForThreaddump).then((function () {
            _ember['default'].Logger.log("Threaddump attempt has been successful!");

            var currentContainerId = null;
            var currentContainerNode = null;
            var nodeForContainerThreaddump = null;

            // Fetch the NM node for the selected container from the
            // mappings stored above when
            this.containerNodeMappings.forEach(function (item) {
              currentContainerId = item.name;
              currentContainerNode = item.value;

              if (currentContainerId === containerIdForThreaddump && nodeForContainerThreaddump == null) {
                nodeForContainerThreaddump = currentContainerNode;
              }
            });

            if (nodeForContainerThreaddump) {
              // Fetch stdout logs after 1.2 seconds of a successful POST
              // request to RM. This is to allow for sufficient time for the NM
              // to heartbeat into RM (default of 1 second) whereupon it will
              // receive RM's signal to post a threaddump that will be captured
              // in the stdout logs of the container. The extra 200ms is to
              // allow for any network/IO delays.
              _ember['default'].run.later((function () {
                var _this2 = this;

                this.fetchLogsForContainer(nodeForContainerThreaddump, containerIdForThreaddump, "stdout").then((function (hash) {
                  _this2.set("selectedContainerThreaddumpContent", hash.logs.get('logs').trim());
                }).bind(this))['catch']((function (error) {
                  this.set("_isStdoutLogsFetchFailed", true);
                  this.set("stdoutLogsFetchFailedError", error);
                }).bind(this))['finally']((function () {
                  this.set("_isLoadingBottomPanel", false);
                }).bind(this));
              }).bind(this), 1200);
            }
          }).bind(this), (function (error) {
            this.set("_isThreaddumpAttemptFailed", true);
            this.set("threaddumpErrorMessage", error);
            this.set("_isLoadingBottomPanel", false);
          }).bind(this))['finally']((function () {
            this.set("selectedContainerThreaddumpContent", "");
          }).bind(this));
        } else {
          this.set("selectedContainerId", "");
          this.set("selectedContainerThreaddumpContent", "");
        }
      }
    },

    // Set up the running attempt for the first time threaddump button is clicked.
    runningAttempt: _ember['default'].computed("model.attempts", function () {
      var attempts = this.get("model.attempts");
      var runningAttemptId = null;

      if (attempts && attempts.get("length") && attempts.get("content")) {
        attempts.get("content").forEach(function (appAttempt) {
          if (appAttempt._data.state === "RUNNING") {
            runningAttemptId = appAttempt._data.appAttemptId;
          }
        });
      }

      return runningAttemptId;
    }),

    /**
     * Create and send fetch running containers request.
     */
    fetchRunningContainersForAttemptId: function fetchRunningContainersForAttemptId(attemptId) {
      var request = {};

      request["rmContainers"] = this.store.query("yarn-container", {
        app_attempt_id: attemptId
      })['catch'](function (error) {
        return _ember['default'].A();
      });

      return _ember['default'].RSVP.hash(request);
    },

    /**
     * Create and send fetch logs request for a selected container, from a
     * specific node.
     */
    fetchLogsForContainer: function fetchLogsForContainer(nodeForContainer, containerId, logFile) {
      var request = {};

      request["logs"] = this.store.queryRecord("yarn-node-container-log", {
        nodeHttpAddr: nodeForContainer,
        containerId: containerId,
        fileName: logFile
      });

      return _ember['default'].RSVP.hash(request);
    },

    /**
     * Send out a POST request to RM to signal a threaddump for the selected
     * container for the currently logged-in user.
     */
    fetchThreaddumpForContainer: function fetchThreaddumpForContainer(containerId) {
      var adapter = this.store.adapterFor("yarn-container-threaddump");

      var requestedUser = "";
      if (this.model && this.model.userInfo && this.model.userInfo.get('firstObject')) {
        requestedUser = this.model.userInfo.get('firstObject').get('requestedUser');
      }

      return adapter.signalContainerForThreaddump({}, containerId, requestedUser);
    },

    /**
     * Reset attributes after a refresh.
     */
    resetAfterRefresh: function resetAfterRefresh() {
      this.set("selectedAttemptId", "");
      this.set("attemptContainerList", null);
      this.set("selectedContainerId", "");
      this.set("selectedLogFileName", "");
      this.set("containerLogFiles", null);
      this.set("selectedContainerThreaddumpContent", "");
      this.set("containerNodeMappings", []);
      this.set("_isThreaddumpAttemptFailed", false);
      this.set("threaddumpErrorMessage", "");
      this.set("_isStdoutLogsFetchFailed", false);
      this.set("stdoutLogsFetchFailedError", "");
      this.set("appAttemptToStateMappings", []);
    },

    // Set the threaddump content in the content area.
    showThreaddumpContent: _ember['default'].computed("selectedContainerThreaddumpContent", function () {
      return this.get("selectedContainerThreaddumpContent");
    }),

    /**
     * Check if the application for the container whose threaddump is being attempted
     * is even running.
     */
    isRunningApp: _ember['default'].computed('model.app.state', function () {
      return this.get('model.app.state') === "RUNNING";
    })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-apps', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller.extend({

    breadcrumbs: [{
      text: "Home",
      routeName: 'application'
    }, {
      text: "Applications",
      routeName: 'yarn-apps.apps'
    }]

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-apps/apps', ['exports', 'ember', 'em-table/utils/table-definition', 'yarn-ui/controllers/app-table-columns'], function (exports, _ember, _emTableUtilsTableDefinition, _yarnUiControllersAppTableColumns) {
  exports['default'] = _yarnUiControllersAppTableColumns['default'].extend({
    queryParams: ['searchText', 'sortColumnId', 'sortOrder', 'pageNum', 'rowCount'],
    tableDefinition: _emTableUtilsTableDefinition['default'].create({
      searchType: 'manual',
      enableFaceting: true,
      rowCount: 25,
      sortColumnId: 'stTime',
      sortOrder: 'desc'
    }),
    searchText: _ember['default'].computed.alias('tableDefinition.searchText'),
    sortColumnId: _ember['default'].computed.alias('tableDefinition.sortColumnId'),
    sortOrder: _ember['default'].computed.alias('tableDefinition.sortOrder'),
    pageNum: _ember['default'].computed.alias('tableDefinition.pageNum'),
    rowCount: _ember['default'].computed.alias('tableDefinition.rowCount')
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-component-instance', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller.extend({
    componentName: '',
    instanceName: '',
    serviceName: '',
    appId: '',

    breadcrumbs: [{
      text: "Home",
      routeName: 'application'
    }, {
      text: "Services",
      routeName: 'yarn-services'
    }],

    updateBreadcrumbs: function updateBreadcrumbs(appId, serviceName, componentName, instanceName) {
      var crumbs = [{
        text: "Home",
        routeName: 'application'
      }, {
        text: "Services",
        routeName: 'yarn-services'
      }];
      if (appId && serviceName && componentName && instanceName) {
        crumbs.push({
          text: serviceName + ' [' + appId + ']',
          href: '#/yarn-app/' + appId + '/components?service=' + serviceName
        }, {
          text: 'Components'
        }, {
          text: '' + componentName,
          href: '#/yarn-component-instances/' + componentName + '/info?service=' + serviceName + '&&appid=' + appId
        }, {
          text: '' + instanceName
        });
      }
      this.set('breadcrumbs', crumbs);
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/controllers/yarn-component-instance/info", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Controller.extend({
    queryParams: ["appid", "service", "containerid"],
    appid: undefined,
    service: undefined,
    containerid: undefined
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-component-instances', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller.extend({
    componentName: '',
    serviceName: '',
    appId: '',

    breadcrumbs: [{
      text: "Home",
      routeName: 'application'
    }, {
      text: "Services",
      routeName: 'yarn-services'
    }],

    updateBreadcrumbs: function updateBreadcrumbs(appId, serviceName, componentName, tailCrumbs) {
      var crumbs = [{
        text: "Home",
        routeName: 'application'
      }, {
        text: "Services",
        routeName: 'yarn-services'
      }];
      if (appId && serviceName && componentName) {
        crumbs.push({
          text: serviceName + ' [' + appId + ']',
          href: '#/yarn-app/' + appId + '/components?service=' + serviceName
        }, {
          text: 'Components'
        }, {
          text: '' + componentName,
          href: '#/yarn-component-instances/' + componentName + '/info?service=' + serviceName + '&&appid=' + appId
        });
      }
      if (tailCrumbs) {
        crumbs.pushObjects(tailCrumbs);
      }
      this.set('breadcrumbs', crumbs);
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/controllers/yarn-component-instances/configs", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Controller.extend({
    queryParams: ["service", "appid"],
    appid: undefined,
    service: undefined
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-component-instances/info', ['exports', 'ember', 'em-table/utils/column-definition', 'em-table/utils/table-definition'], function (exports, _ember, _emTableUtilsColumnDefinition, _emTableUtilsTableDefinition) {
  exports['default'] = _ember['default'].Controller.extend({
    queryParams: ["service", "appid"],
    appid: undefined,
    service: undefined,

    tableDefinition: _emTableUtilsTableDefinition['default'].create({
      searchType: 'manual'
    }),

    tableColumns: _ember['default'].computed('model.appId', 'model.serviceName', function () {
      var cols = [];
      var appId = this.get('model.appId');
      var serviceName = this.get('model.serviceName');

      cols.push({
        id: 'instanceName',
        headerTitle: 'Component Instance',
        contentPath: 'instanceName',
        cellComponentName: 'em-table-linked-cell',
        getCellContent: function getCellContent(row) {
          var component = row.get('component');
          var instance = row.get('instanceName');
          var containerId = row.get('containerId');
          return {
            text: instance,
            href: '#/yarn-component-instance/' + component + '/instances/' + instance + '/info?appid=' + appId + '&service=' + serviceName + '&containerid=' + containerId
          };
        }
      }, {
        id: 'containerId',
        headerTitle: 'Current Container Id',
        contentPath: 'containerId',
        minWidth: '350px'
      }, {
        id: 'state',
        headerTitle: 'State',
        contentPath: 'state'
      }, {
        id: 'startedDate',
        headerTitle: 'Started Time',
        contentPath: 'startedDate'
      }, {
        id: 'logsLink',
        headerTitle: 'Logs',
        contentPath: 'logsLink',
        cellComponentName: 'em-table-html-cell',
        getCellContent: function getCellContent(row) {
          var containerLogUrl = row.get('containerLogURL');
          if (containerLogUrl) {
            return '<a href="' + containerLogUrl + '&service=' + serviceName + '">Link</a>';
          } else {
            return 'N/A';
          }
        }
      });

      return _emTableUtilsColumnDefinition['default'].make(cols);
    })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-container-log', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller.extend({

    breadcrumbs: _ember['default'].computed('model.nodeInfo', 'model.containerInfo', function () {
      var nodeInfo = this.get('model.nodeInfo'),
          containerInfo = this.get('model.containerInfo');
      var nodeAddr = encodeURIComponent(nodeInfo.addr);
      return [{
        text: "Home",
        routeName: 'application'
      }, {
        text: "Nodes",
        routeName: 'yarn-nodes.table'
      }, {
        text: 'Node [ ' + nodeInfo.id + ' ]',
        href: '#/yarn-node/' + nodeInfo.id + '/' + nodeAddr + '/info'
      }, {
        text: 'Container [ ' + containerInfo.id + ' ]',
        href: '#/yarn-node-container/' + nodeInfo.id + '/' + nodeAddr + '/' + containerInfo.id
      }, {
        text: "Log"
      }];
    })

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-deploy-service', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller.extend({
    breadcrumbs: [{
      text: "Home",
      routeName: 'application'
    }, {
      text: "Services",
      routeName: 'yarn-services'
    }, {
      text: "New Service",
      routeName: 'yarn-deploy-service'
    }],

    savedStandardTemplates: [],
    savedJsonTemplates: [],
    serviceResponse: null,
    isLoading: false,

    actions: {
      deployServiceDef: function deployServiceDef(serviceDef, userName) {
        var defjson = serviceDef.getServiceJSON();
        this.deployServiceApp(defjson, userName);
      },

      deployServiceJson: function deployServiceJson(json, userName) {
        this.deployServiceApp(json, userName);
      }
    },

    gotoServices: function gotoServices() {
      _ember['default'].run.later(this, function () {
        this.set('serviceResponse', null);
        this.transitionToRoute('yarn-services');
      }, 1000);
    },

    deployServiceApp: function deployServiceApp(requestJson, userName) {
      var self = this;
      var adapter = this.store.adapterFor('yarn-servicedef');
      this.set('isLoading', true);
      adapter.deployService(requestJson, userName).then(function () {
        self.set('serviceResponse', { message: 'Service has been accepted successfully. Redirecting to services in a second.', type: 'success' });
        self.gotoServices();
      }, function (errr) {
        var messg = 'Error: Deploy service failed!';
        if (errr.errors && errr.errors[0] && errr.errors[0].diagnostics) {
          messg = 'Error: ' + errr.errors[0].diagnostics;
        }
        self.set('serviceResponse', { message: messg, type: 'error' });
      })['finally'](function () {
        self.set('isLoading', false);
      });
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-flow-activity', ['exports', 'ember', 'em-table/utils/table-definition', 'em-table/utils/column-definition', 'lodash/lodash'], function (exports, _ember, _emTableUtilsTableDefinition, _emTableUtilsColumnDefinition, _lodashLodash) {

  function _createColumns() {
    var columns = [];
    columns.push({
      id: 'flowName',
      headerTitle: 'Flow Name',
      contentPath: 'flowName',
      observePath: true
    }, {
      id: 'user',
      headerTitle: 'User',
      contentPath: 'user',
      observePath: true
    }, {
      id: 'uid',
      headerTitle: 'Flow ID',
      contentPath: 'uid',
      observePath: true,
      cellComponentName: 'em-table-linked-cell',
      minWidth: "300px",
      getCellContent: function getCellContent(row) {
        return {
          routeName: 'yarn-flow.info',
          id: row.get('uid'),
          displayText: row.get('uid')
        };
      }
    }, {
      id: 'lastExecDate',
      headerTitle: 'Last Execution Date',
      contentPath: 'lastExecDate',
      observePath: true
    });
    return _emTableUtilsColumnDefinition['default'].make(columns);
  }

  function _getAggregatedFlowsData(flows) {
    var aggregatedFlows = [];
    flows = flows ? flows.get('content') : [];

    var aggregated = _lodashLodash['default'].groupBy(flows, function (flow) {
      return flow.getRecord().get('uid');
    });

    _lodashLodash['default'].forIn(aggregated, function (flows) {
      var flowsInAsc = _lodashLodash['default'].sortBy(flows, function (flow) {
        return flow.getRecord().get('lastExecDate');
      });
      var flowsInDesc = flowsInAsc.reverse();
      aggregatedFlows.push(flowsInDesc[0].getRecord());
    });

    return aggregatedFlows;
  }

  function _createRows(flows) {
    var data = [],
        aggregatedFlows = null,
        row = null;

    aggregatedFlows = _getAggregatedFlowsData(flows);

    aggregatedFlows.forEach(function (flow) {
      row = _ember['default'].Object.create({
        user: flow.get('user'),
        flowName: flow.get('flowName'),
        uid: flow.get('uid'),
        lastExecDate: flow.get('lastExecDate')
      });
      data.push(row);
    });

    return _ember['default'].A(data);
  }

  exports['default'] = _ember['default'].Controller.extend({
    breadcrumbs: [{
      text: "Home",
      routeName: 'application'
    }, {
      text: "Flow Activities",
      routeName: 'yarn-flow-activity'
    }],

    columns: _createColumns(),

    rows: _ember['default'].computed('model', function () {
      return _createRows(this.get('model'));
    }),

    tableDefinition: _emTableUtilsTableDefinition['default'].create({
      sortColumnId: 'lastExecDate',
      sortOrder: 'desc'
    }),

    getLastFlowExecutionInfoByFlowUid: function getLastFlowExecutionInfoByFlowUid(uid) {
      var aggregatedFlows = _getAggregatedFlowsData(this.get('model'));
      var recent = aggregatedFlows.find(function (flow) {
        return flow.get('uid') === uid;
      });
      return recent;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-flow', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller.extend({
    breadcrumbs: _ember['default'].computed("model.flowUid", function () {
      var flowUid = this.get('model.flowUid');
      return [{
        text: "Home",
        routeName: 'application'
      }, {
        text: "Flow Activities",
        routeName: 'yarn-flow-activity'
      }, {
        text: 'Flow Info [' + flowUid + ']',
        routeName: 'yarn-flow.info',
        model: flowUid
      }];
    })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-flow/info', ['exports', 'ember', 'yarn-ui/utils/converter'], function (exports, _ember, _yarnUiUtilsConverter) {
  exports['default'] = _ember['default'].Controller.extend({
    flowUid: (function () {
      return this.get('model.flowUid');
    }).property('model.flowUid'),

    flowLastExecutionDate: (function () {
      if (this.get('model.lastFlowExecutionInfo')) {
        return this.get('model.lastFlowExecutionInfo').get('lastExecDate');
      } else {
        return '';
      }
    }).property('model.lastFlowExecutionInfo'),

    flowInfo: (function () {
      var info = {};
      var firstRunObj = this.get('model.flowRuns').get('firstObject');
      info.flowUid = this.get('flowUid');
      info.flowName = firstRunObj.get('flowName');
      info.user = firstRunObj.get('user');
      info.lastExecutionDate = this.get('flowLastExecutionDate');
      info.firstRunStarted = this.get('earliestStartTime');
      info.lastRunFinished = this.get('latestFinishTime');
      return info;
    }).property('model.flowRuns', 'flowLastExecutionDate'),

    earliestStartTime: (function () {
      var earliestStart = Number.MAX_VALUE;
      this.get('model.flowRuns').forEach(function (flowrun) {
        if (flowrun.get('createTimeRaw') < earliestStart) {
          earliestStart = flowrun.get('createTimeRaw');
        }
      });
      return _yarnUiUtilsConverter['default'].timeStampToDate(earliestStart);
    }).property('model.flowRuns'),

    latestFinishTime: (function () {
      var latestFinish = 0;
      this.get('model.flowRuns').forEach(function (flowrun) {
        if (flowrun.get('endTimeRaw') > latestFinish) {
          latestFinish = flowrun.get('endTimeRaw');
        }
      });
      return _yarnUiUtilsConverter['default'].timeStampToDate(latestFinish);
    }).property('model.flowRuns')
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-flow/runs', ['exports', 'ember', 'em-table/utils/table-definition', 'em-table/utils/column-definition', 'yarn-ui/utils/converter'], function (exports, _ember, _emTableUtilsTableDefinition, _emTableUtilsColumnDefinition, _yarnUiUtilsConverter) {

  function createColumn() {
    var columns = [];

    // Generate columns
    columns.push({
      id: 'runid',
      headerTitle: 'Run ID',
      contentPath: 'runid',
      cellComponentName: 'em-table-linked-cell',
      minWidth: "300px",
      getCellContent: function getCellContent(row) {
        return {
          routeName: 'yarn-flowrun.info',
          id: row.get('uid'),
          displayText: row.get('shownid')
        };
      }
    });

    columns.push({
      id: 'runDurationTs',
      headerTitle: 'Run Duration',
      contentPath: 'runDurationTs',
      getCellContent: function getCellContent(row) {
        return _yarnUiUtilsConverter['default'].msToElapsedTimeUnit(row.get('runDurationTs'));
      }
    });

    columns.push({
      id: 'cpuVCores',
      headerTitle: 'CPU VCores',
      contentPath: 'cpuVCores',
      getCellContent: function getCellContent(row) {
        if (row.get('cpuVCores') > -1) {
          return row.get('cpuVCores');
        }
        return 'N/A';
      }
    });

    columns.push({
      id: 'memoryUsed',
      headerTitle: 'Memory Used',
      contentPath: 'memoryUsed',
      getCellContent: function getCellContent(row) {
        if (row.get('memoryUsed') > -1) {
          return _yarnUiUtilsConverter['default'].memoryBytesToMB(row.get('memoryUsed'));
        }
        return 'N/A';
      }
    });

    columns.push({
      id: 'createTime',
      headerTitle: 'Creation Time',
      contentPath: 'createTime'
    });

    columns.push({
      id: 'endTime',
      headerTitle: 'End Time',
      contentPath: 'endTime'
    });

    return _emTableUtilsColumnDefinition['default'].make(columns);
  }

  exports['default'] = _ember['default'].Controller.extend({
    vizWidgets: {
      runDuration: true,
      cpuVcores: false,
      memoryUsed: false
    },

    actions: {
      addVizWidget: function addVizWidget(widget) {
        _ember['default'].set(this.vizWidgets, widget, true);
      },

      removeVizWidget: function removeVizWidget(widget) {
        _ember['default'].set(this.vizWidgets, widget, false);
      }
    },

    columns: createColumn(),

    tableDefinition: _emTableUtilsTableDefinition['default'].create({
      sortColumnId: 'createTime',
      sortOrder: 'desc'
    }),

    elapsedTimeVizData: (function () {
      var data = [];
      this.get('model.flowRuns').forEach(function (run) {
        var vizData = run.getElapsedTimeVizDataForBarChart();
        if (vizData.value > 0) {
          data.push(vizData);
        }
      });
      data = this.getSortedVizDataInDesc(data);
      return this.getRefactoredVizData(data);
    }).property('model.flowRuns'),

    elapsedTimeFormatter: function elapsedTimeFormatter(tick) {
      return _yarnUiUtilsConverter['default'].msToElapsedTimeUnit(tick, true);
    },

    cpuVCoresVizData: (function () {
      var data = [];
      this.get('model.flowRuns').forEach(function (run) {
        var vizData = run.getCpuVCoresVizDataForBarChart();
        if (vizData.value > 0) {
          data.push(vizData);
        }
      });
      data = this.getSortedVizDataInDesc(data);
      return this.getRefactoredVizData(data);
    }).property('model.flowRuns'),

    memoryVizData: (function () {
      var data = [];
      this.get('model.flowRuns').forEach(function (run) {
        var vizData = run.getMemoryVizDataForBarChart();
        if (vizData.value > 0) {
          data.push(vizData);
        }
      });
      data = this.getSortedVizDataInDesc(data);
      return this.getRefactoredVizData(data);
    }).property('model.flowRuns'),

    memoryFormatter: function memoryFormatter(tick) {
      return _yarnUiUtilsConverter['default'].memoryBytesToMB(tick);
    },

    onBarChartClick: (function () {
      var self = this;
      return function (data) {
        self.transitionToRoute('yarn-flowrun.info', data.flowrunUid);
      };
    }).property(),

    getSortedVizDataInDesc: function getSortedVizDataInDesc(data) {
      return data.sort(function (d1, d2) {
        return d2.createdTs - d1.createdTs;
      });
    },

    getRefactoredVizData: function getRefactoredVizData(data) {
      data.forEach(function (viz, idx) {
        viz.label = "Run " + ++idx;
      }, this);
      return data;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-flowrun', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller.extend({
    breadcrumbs: _ember['default'].computed('model.flowrun_uid', 'model.parentFlowUid', function () {
      var flowRunId = this.get('model.flowrun_uid');
      var parentFlowUid = this.get('model.parentFlowUid');
      var crumbs = [{
        text: "Home",
        routeName: 'application'
      }, {
        text: "Flow Activities",
        routeName: 'yarn-flow-activity'
      }];
      if (parentFlowUid) {
        crumbs.push({
          text: 'Flow Info [' + parentFlowUid + ']',
          routeName: 'yarn-flow.info',
          model: parentFlowUid
        }, {
          text: 'Flow Runs [' + parentFlowUid + ']',
          routeName: 'yarn-flow.runs',
          model: parentFlowUid
        });
      }
      crumbs.push({
        text: 'Run Info [' + flowRunId + ']',
        routeName: 'yarn-flowrun.info',
        model: flowRunId
      });
      return crumbs;
    })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-flowrun/info', ['exports', 'ember', 'em-table/utils/column-definition', 'yarn-ui/utils/converter', 'em-table/utils/table-definition'], function (exports, _ember, _emTableUtilsColumnDefinition, _yarnUiUtilsConverter, _emTableUtilsTableDefinition) {

  function createColumn() {
    var columns = [];

    tableDefinition: _emTableUtilsTableDefinition['default'].create({
      searchType: 'manual'
    }),

    // Generate columns
    columns.push({
      id: 'appId',
      headerTitle: 'Application ID',
      contentPath: 'appId',
      cellComponentName: 'em-table-linked-cell',
      minWidth: "300px",
      getCellContent: function getCellContent(row) {
        return {
          routeName: 'yarn-app.attempts',
          id: row.get('appId'),
          displayText: row.get('appId')
        };
      }
    });

    columns.push({
      id: 'appType',
      headerTitle: 'Application Type',
      contentPath: 'type'
    });

    columns.push({
      id: 'state',
      headerTitle: 'State',
      contentPath: 'state',
      cellComponentName: 'em-table-status-cell'
    });

    columns.push({
      id: 'elapsedTs',
      headerTitle: 'Elapsed Time',
      contentPath: 'elapsedTs',
      getCellContent: function getCellContent(row) {
        return _yarnUiUtilsConverter['default'].msToElapsedTimeUnit(row.get('elapsedTs'));
      }
    });

    columns.push({
      id: 'cpuVCores',
      headerTitle: 'CPU VCores',
      contentPath: 'cpuVCores',
      getCellContent: function getCellContent(row) {
        if (row.get('cpuVCores') > -1) {
          return row.get('cpuVCores');
        }
        return 'N/A';
      }
    });

    columns.push({
      id: 'memoryUsed',
      headerTitle: 'Memory Used',
      contentPath: 'memoryUsed',
      getCellContent: function getCellContent(row) {
        if (row.get('memoryUsed') > -1) {
          return _yarnUiUtilsConverter['default'].memoryBytesToMB(row.get('memoryUsed'));
        }
        return 'N/A';
      }
    });

    return _emTableUtilsColumnDefinition['default'].make(columns);
  }

  exports['default'] = _ember['default'].Controller.extend({
    vizWidgets: {
      cpuVcores: true,
      memoryUsed: false
    },

    actions: {
      addVizWidget: function addVizWidget(widget) {
        _ember['default'].set(this.vizWidgets, widget, true);
      },

      removeVizWidget: function removeVizWidget(widget) {
        _ember['default'].set(this.vizWidgets, widget, false);
      }
    },

    columns: createColumn(),

    cpuVCoresVizData: (function () {
      var data = [];
      this.get('model.apps').forEach(function (app) {
        var vizData = app.getCpuVCoresVizDataForBarChart();
        if (vizData.value > 0) {
          data.push(vizData);
        }
      });
      data = this.getSortedVizDataInDesc(data);
      return this.getRefactoredVizData(data);
    }).property('model.apps'),

    memoryVizData: (function () {
      var data = [];
      this.get('model.apps').forEach(function (app) {
        var vizData = app.getMemoryVizDataForBarChart();
        if (vizData.value > 0) {
          data.push(vizData);
        }
      });
      data = this.getSortedVizDataInDesc(data);
      return this.getRefactoredVizData(data);
    }).property('model.apps'),

    memoryFormatter: function memoryFormatter(tick) {
      return _yarnUiUtilsConverter['default'].memoryBytesToMB(tick);
    },

    onBarChartClick: (function () {
      var self = this;
      return function (data) {
        self.transitionToRoute('yarn-app', data.appId);
      };
    }).property(),

    getSortedVizDataInDesc: function getSortedVizDataInDesc(data) {
      return data.sort(function (d1, d2) {
        return d2.value - d1.value;
      });
    },

    getRefactoredVizData: function getRefactoredVizData(data) {
      data.forEach(function (viz, idx) {
        viz.appId = viz.label;
        viz.label = "App " + ++idx;
      }, this);
      return data;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-flowrun/metrics', ['exports', 'ember', 'em-table/utils/column-definition', 'em-table/utils/table-definition'], function (exports, _ember, _emTableUtilsColumnDefinition, _emTableUtilsTableDefinition) {

  function _createColumns() {
    var columns = [];

    columns.push({
      id: 'name',
      headerTitle: 'Name',
      contentPath: 'name',
      observePath: true,
      cellComponentName: 'em-table-html-cell',
      getCellContent: function getCellContent(row) {
        var plainName = row.name;
        if (plainName.indexOf('MAP:') > -1 || plainName.indexOf('REDUCE:') > -1) {
          plainName = plainName.substring(plainName.indexOf(':') + 1);
        }
        return '<span>' + plainName + '</span>';
      }
    }, {
      id: 'value',
      headerTitle: 'Value',
      contentPath: 'value',
      observePath: true
    });

    return _emTableUtilsColumnDefinition['default'].make(columns);
  }

  exports['default'] = _ember['default'].Controller.extend({
    mapMetrics: null,
    reduceMetrics: null,
    generalMetrics: null,

    tableDefinition: _emTableUtilsTableDefinition['default'].create({
      searchType: 'manual'
    }),

    columns: _ember['default'].computed(function () {
      return _createColumns(this.get('model.flowrun_uid'));
    }),

    metricsObserver: _ember['default'].observer('model.flowrun', function () {
      var metrics = this.get('model.flowrun.metrics');
      var mapConfigs = [],
          reduceConfigs = [],
          generalConfigs = [];

      metrics.forEach(function (metric) {
        var id = metric.id;
        if (id.startsWith('MAP:')) {
          mapConfigs.push(metric);
        } else if (id.startsWith('REDUCE:')) {
          reduceConfigs.push(metric);
        } else {
          generalConfigs.push(metric);
        }
      }, this);

      this.set('mapMetrics', mapConfigs);
      this.set('reduceMetrics', reduceConfigs);
      this.set('generalMetrics', generalConfigs);
    }),

    mapConfigRows: _ember['default'].computed('mapMetrics', function () {
      var row = null,
          data = [];

      this.get('mapMetrics').forEach(function (map) {
        var value = map.values[Object.keys(map.values)[0]];
        row = _ember['default'].Object.create({
          name: map.id,
          value: value
        });
        data.push(row);
      }, this);

      return _ember['default'].A(data);
    }),

    reduceConfigRows: _ember['default'].computed('reduceMetrics', function () {
      var row = null,
          data = [];

      this.get('reduceMetrics').forEach(function (map) {
        var value = map.values[Object.keys(map.values)[0]];
        row = _ember['default'].Object.create({
          name: map.id,
          value: value
        });
        data.push(row);
      }, this);

      return _ember['default'].A(data);
    }),

    generalConfigRows: _ember['default'].computed('generalMetrics', function () {
      var row = null,
          data = [];

      this.get('generalMetrics').forEach(function (map) {
        var value = map.values[Object.keys(map.values)[0]];
        row = _ember['default'].Object.create({
          name: map.id,
          value: value
        });
        data.push(row);
      }, this);

      return _ember['default'].A(data);
    })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-node-app', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller.extend({

    breadcrumbs: _ember['default'].computed('model.nodeInfo', function () {
      var nodeInfo = this.get('model.nodeInfo');
      var addr = encodeURIComponent(nodeInfo.addr);
      return [{
        text: "Home",
        routeName: 'application'
      }, {
        text: "Nodes",
        routeName: 'yarn-nodes.table'
      }, {
        text: 'Node [ ' + nodeInfo.id + ' ]',
        href: '#/yarn-node/' + nodeInfo.id + '/' + addr + '/info'
      }, {
        text: 'Application [ ' + nodeInfo.appId + ' ]'
      }];
    }),

    encodedNodeAddr: _ember['default'].computed("model.nodeInfo", function () {
      var nodeInfo = this.get("model.nodeInfo");
      return encodeURIComponent(nodeInfo.addr);
    })

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/controllers/yarn-node-apps", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Controller.extend({

    breadcrumbs: _ember["default"].computed("model.attempt.appId", function () {
      var nodeInfo = this.get("model.nodeInfo");
      var addr = encodeURIComponent(nodeInfo.addr);
      return [{
        text: "Home",
        routeName: 'application'
      }, {
        text: "Nodes",
        routeName: 'yarn-nodes.table'
      }, {
        text: "Node [ " + nodeInfo.id + " ]",
        href: "#/yarn-node/" + nodeInfo.id + "/" + addr + "/info"
      }, {
        text: "Applications"
      }];
    }),

    encodedNodeAddr: _ember["default"].computed("model.nodeInfo", function () {
      var nodeInfo = this.get("model.nodeInfo");
      return encodeURIComponent(nodeInfo.addr);
    })

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/controllers/yarn-node-container", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Controller.extend({

    breadcrumbs: _ember["default"].computed("model.nodeInfo", function () {
      var nodeInfo = this.get("model.nodeInfo");
      var addr = encodeURIComponent(nodeInfo.addr);
      return [{
        text: "Home",
        routeName: 'application'
      }, {
        text: "Nodes",
        routeName: 'yarn-nodes.table'
      }, {
        text: "Node [ " + nodeInfo.id + " ]",
        href: "#/yarn-node/" + nodeInfo.id + "/" + addr + "/info"
      }, {
        text: "Container [ " + nodeInfo.containerId + " ]"
      }];
    }),

    encodedNodeAddr: _ember["default"].computed("model.nodeInfo", function () {
      var nodeInfo = this.get("model.nodeInfo");
      return encodeURIComponent(nodeInfo.addr);
    })

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/controllers/yarn-node-containers", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Controller.extend({

    breadcrumbs: _ember["default"].computed("model.nodeInfo", function () {
      var nodeInfo = this.get("model.nodeInfo");
      var addr = encodeURIComponent(nodeInfo.addr);
      return [{
        text: "Home",
        routeName: 'application'
      }, {
        text: "Nodes",
        routeName: 'yarn-nodes.table'
      }, {
        text: "Node [ " + nodeInfo.id + " ]",
        href: "#/yarn-node/" + nodeInfo.id + "/" + addr + "/info"
      }, {
        text: "Containers"
      }];
    }),

    encodedNodeAddr: _ember["default"].computed("model.nodeInfo", function () {
      var nodeInfo = this.get("model.nodeInfo");
      return encodeURIComponent(nodeInfo.addr);
    })

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/controllers/yarn-node", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Controller.extend({

    breadcrumbs: _ember["default"].computed("model.nodeInfo", function () {
      var nodeInfo = this.get("model.nodeInfo");
      var addr = encodeURIComponent(nodeInfo.addr);

      return [{
        text: "Home",
        routeName: 'application'
      }, {
        text: "Nodes",
        routeName: 'yarn-nodes.table'
      }, {
        text: "Node [ " + nodeInfo.id + " ]",
        href: "#/yarn-node/" + nodeInfo.id + "/" + addr + "/info"
      }];
    })

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-nodes-heatmap', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller.extend({
    needReload: true,
    selectedQueue: undefined,

    breadcrumbs: [{
      text: "Home",
      routeName: 'application'
    }, {
      text: "Nodes",
      routeName: 'yarn-nodes.table'
    }, {
      text: "Heatmap",
      routeName: 'yarn-nodes-heatmap'
    }]

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-nodes-status', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller.extend({
    needReload: true,
    selectedQueue: undefined,

    breadcrumbs: [{
      text: "Home",
      routeName: 'application'
    }, {
      text: "Nodes",
      routeName: 'yarn-nodes.table'
    }, {
      text: "Node status",
      routeName: 'yarn-nodes-status'
    }]

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-nodes', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller.extend({
    needReload: true,
    selectedQueue: undefined,

    breadcrumbs: [{
      text: "Home",
      routeName: 'application'
    }, {
      text: "Nodes",
      routeName: 'yarn-nodes.table'
    }]

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-nodes/table', ['exports', 'ember', 'em-table/utils/column-definition', 'em-table/utils/table-definition'], function (exports, _ember, _emTableUtilsColumnDefinition, _emTableUtilsTableDefinition) {
    exports['default'] = _ember['default'].Controller.extend({
        queryParams: ['searchText', 'sortColumnId', 'sortOrder', 'pageNum', 'rowCount'],
        tableDefinition: _emTableUtilsTableDefinition['default'].create({
            searchType: 'manual'
        }),
        searchText: _ember['default'].computed.alias('tableDefinition.searchText'),
        sortColumnId: _ember['default'].computed.alias('tableDefinition.sortColumnId'),
        sortOrder: _ember['default'].computed.alias('tableDefinition.sortOrder'),
        pageNum: _ember['default'].computed.alias('tableDefinition.pageNum'),
        rowCount: _ember['default'].computed.alias('tableDefinition.rowCount'),
        tableDefinition: _emTableUtilsTableDefinition['default'].create({
            enableFaceting: true,
            minValuesToDisplay: 1,
            rowCount: 25
        }),
        columns: (function () {
            var colums = [];
            colums.push({
                id: 'label',
                headerTitle: 'Node Label',
                contentPath: 'nodeLabelsAsString',
                minWidth: "125px"
            }, {
                id: 'rack',
                headerTitle: 'Rack',
                contentPath: 'rack',
                facetType: null,
                minWidth: "250px"
            }, {
                id: 'state',
                headerTitle: 'Node State',
                contentPath: 'state',
                cellComponentName: 'em-table-status-cell',
                minWidth: "125px"
            }, {
                id: 'address',
                headerTitle: 'Node Address',
                contentPath: 'id',
                minWidth: "300px",
                facetType: null
            }, {
                id: 'nodeId',
                headerTitle: 'Node HTTP Address',
                contentPath: 'nodeHTTPAddress',
                cellComponentName: 'em-table-linked-cell',
                facetType: null,
                getCellContent: function getCellContent(row) {
                    var node_id = row.get("id"),
                        node_addr = encodeURIComponent(row.get("nodeHTTPAddress")),
                        href = '#/yarn-node/' + node_id + '/' + node_addr + '/info';
                    switch (row.get("nodeState")) {
                        case "SHUTDOWN":
                        case "LOST":
                            href = "";
                    }
                    return {
                        text: row.get("nodeHTTPAddress"),
                        href: href
                    };
                },
                minWidth: "250px"
            }, {
                id: 'containers',
                headerTitle: 'Containers',
                contentPath: 'numContainers',
                facetType: null
            }, {
                id: 'memUsed',
                headerTitle: 'Mem Used',
                contentPath: 'usedMemoryBytes',
                facetType: null,
                cellDefinition: {
                    type: "memory"
                }
            }, {
                id: 'memAvail',
                headerTitle: 'Mem Available',
                contentPath: 'availMemoryBytes',
                facetType: null,
                cellDefinition: {
                    type: "memory"
                }
            }, {
                id: 'coresUsed',
                headerTitle: 'VCores Used',
                contentPath: 'usedVirtualCores',
                facetType: null
            }, {
                id: 'coresAvail',
                headerTitle: 'VCores Available',
                contentPath: 'availableVirtualCores',
                facetType: null
            }, {
                id: 'healthUpdate',
                headerTitle: 'Last Health Update',
                contentPath: 'lastHealthUpdate',
                facetType: null,
                minWidth: "250px"
            }, {
                id: 'healthReport',
                headerTitle: 'Health-Report',
                contentPath: 'healthReport',
                facetType: null,
                minWidth: "200px"
            }, {
                id: 'version',
                headerTitle: 'Version',
                contentPath: 'version',
                facetType: null,
                observePath: true
            });
            return _emTableUtilsColumnDefinition['default'].make(colums);
        }).property()
    });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/controllers/yarn-queue", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Controller.extend({
    needReload: true,
    selectedQueue: undefined,

    breadcrumbs: _ember["default"].computed("model.selected", "target.currentPath", function () {
      var queueName = this.get("model.selected");
      var path = this.get("target.currentPath");

      var crumbs = [{
        text: "Home",
        routeName: 'application'
      }, {
        text: "Queues",
        routeName: 'yarn-queues',
        model: 'root'
      }];

      if (path && path === "yarn-queue.apps") {
        crumbs.push({
          text: "Queue [ " + queueName + " ]",
          routeName: 'yarn-queue.apps',
          model: queueName
        });
      }

      return crumbs;
    })

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-queue/apps', ['exports', 'ember', 'em-table/utils/table-definition', 'yarn-ui/controllers/app-table-columns'], function (exports, _ember, _emTableUtilsTableDefinition, _yarnUiControllersAppTableColumns) {
  exports['default'] = _yarnUiControllersAppTableColumns['default'].extend({
    tableDefinition: _emTableUtilsTableDefinition['default'].create({
      searchType: 'manual',
      enableFaceting: true,
      rowCount: 25
    }),

    // Search text alias, any change in controller's searchText would affect the table's searchText, and vice-versa.
    _selectedObserver: _ember['default'].on("init", _ember['default'].observer("model.selected", function () {
      this.set("tableDefinition.searchText", this.get("model.selected"));
    }))
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-queues', ['exports', 'ember', 'yarn-ui/constants'], function (exports, _ember, _yarnUiConstants) {
  exports['default'] = _ember['default'].Controller.extend({
    needReload: true,
    selectedQueue: undefined,
    showLoading: true,
    filteredPartition: _yarnUiConstants.PARTITION_LABEL,

    breadcrumbs: [{
      text: "Home",
      routeName: "application"
    }, {
      text: "Queues",
      routeName: "yarn-queues",
      model: "root"
    }],

    actions: {
      setFilter: function setFilter(partition) {
        this.set("filteredPartition", partition);
        var model = this.get('model');
        var selectedQueue = model.selectedQueue;

        // If the selected queue does not have the filtered partition
        // reset it to root
        if (!selectedQueue.get('partitions').contains(partition)) {
          var root = model.queues.get('firstObject');
          document.location.href = "#/yarn-queues/" + root.get("id") + "!";
          this.set("model.selectedQueue", root);
          this.set("model.selected", root.get('id'));
        }
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-services', ['exports', 'ember', 'yarn-ui/controllers/app-table-columns', 'em-table/utils/table-definition'], function (exports, _ember, _yarnUiControllersAppTableColumns, _emTableUtilsTableDefinition) {
  exports['default'] = _yarnUiControllersAppTableColumns['default'].extend({
    queryParams: ['searchText', 'sortColumnId', 'sortOrder', 'pageNum', 'rowCount'],
    tableDefinition: _emTableUtilsTableDefinition['default'].create({
      searchType: 'manual',
      sortColumnId: 'stTime',
      sortOrder: 'desc',
      rowCount: 25,
      minValuesToDisplay: 1,
      enableFaceting: true
    }),
    searchText: _ember['default'].computed.alias('tableDefinition.searchText'),
    sortColumnId: _ember['default'].computed.alias('tableDefinition.sortColumnId'),
    sortOrder: _ember['default'].computed.alias('tableDefinition.sortOrder'),
    pageNum: _ember['default'].computed.alias('tableDefinition.pageNum'),
    rowCount: _ember['default'].computed.alias('tableDefinition.rowCount'),

    breadcrumbs: [{
      text: "Home",
      routeName: 'application'
    }, {
      text: "Services",
      routeName: 'yarn-services'
    }],

    getFinishedServicesDataForDonutChart: _ember['default'].computed('model.apps', function () {

      var finishdApps = 0;
      var failedApps = 0;
      var killedApps = 0;

      this.get('model.apps').forEach(function (service) {
        if (service.get('state') === "FINISHED") {
          finishdApps++;
        }

        if (service.get('state') === "FAILED") {
          failedApps++;
        }

        if (service.get('state') === "KILLED") {
          killedApps++;
        }
      });

      var arr = [];
      arr.push({
        label: "Completed",
        value: finishdApps
      });
      arr.push({
        label: "Killed",
        value: killedApps
      });
      arr.push({
        label: "Failed",
        value: failedApps
      });

      return arr;
    }),

    getRunningServicesDataForDonutChart: _ember['default'].computed('model.apps', function () {
      var pendingApps = 0;
      var runningApps = 0;

      this.get('model.apps').forEach(function (service) {
        if (service.get('state') === "RUNNING") {
          runningApps++;
        }

        if (service.get('state') === "ACCEPTED" || service.get('state') === "SUBMITTED" || service.get('state') === "NEW" || service.get('state') === "NEW_SAVING") {
          pendingApps++;
        }
      });

      var arr = [];
      arr.push({
        label: "Pending",
        value: pendingApps
      });
      arr.push({
        label: "Running",
        value: runningApps
      });

      return arr;
    })

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-tools', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller.extend({
    breadcrumbs: [{
      text: "Home",
      routeName: 'application'
    }, {
      text: "YARN Tools",
      routeName: 'yarn-tools'
    }]
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-tools/yarn-conf', ['exports', 'ember', 'em-table/utils/table-definition', 'em-table/utils/column-definition', 'yarn-ui/models/yarn-conf'], function (exports, _ember, _emTableUtilsTableDefinition, _emTableUtilsColumnDefinition, _yarnUiModelsYarnConf) {
  exports['default'] = _ember['default'].Controller.extend({
    coreTableDefinition: _emTableUtilsTableDefinition['default'].create({
      searchType: 'manual'
    }),

    mapredTableDefinition: _emTableUtilsTableDefinition['default'].create({
      searchType: 'manual'
    }),

    yarnTableDefinition: _emTableUtilsTableDefinition['default'].create({
      searchType: 'manual'
    }),

    init: function init() {
      var that = this;
      this.get('store').query('yarn-conf', {}).then(function (conf) {
        var coreProps = conf.filter(function (o) {
          return o.get('source') == 'core-default.xml';
        });
        that.set('rowsForCoreColumnsFromModel', coreProps);
        var mapredProps = conf.filter(function (o) {
          return o.get('source') == 'mapred-default.xml';
        });
        that.set('rowsForMapredColumnsFromModel', mapredProps);
        var yarnProps = conf.filter(function (o) {
          return o.get('source') == 'yarn-default.xml';
        });
        that.set('rowsForYarnColumnsFromModel', yarnProps);
      });
    },

    columnsFromModel: _emTableUtilsColumnDefinition['default'].makeFromModel(_yarnUiModelsYarnConf['default'])

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/controllers/yarn-tools/yarn-rm-log', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Controller.extend({
    queryParams: ['filename'],
    filename: null
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/helpers/and', ['exports', 'ember', 'ember-truth-helpers/helpers/and'], function (exports, _ember, _emberTruthHelpersHelpersAnd) {

  var forExport = null;

  if (_ember['default'].Helper) {
    forExport = _ember['default'].Helper.helper(_emberTruthHelpersHelpersAnd.andHelper);
  } else if (_ember['default'].HTMLBars.makeBoundHelper) {
    forExport = _ember['default'].HTMLBars.makeBoundHelper(_emberTruthHelpersHelpersAnd.andHelper);
  }

  exports['default'] = forExport;
});
define('yarn-ui/helpers/array-contains', ['exports', 'ember-array-contains-helper/helpers/array-contains'], function (exports, _emberArrayContainsHelperHelpersArrayContains) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emberArrayContainsHelperHelpersArrayContains['default'];
    }
  });
  Object.defineProperty(exports, 'arrayContains', {
    enumerable: true,
    get: function get() {
      return _emberArrayContainsHelperHelpersArrayContains.arrayContains;
    }
  });
});
define('yarn-ui/helpers/check-availability', ['exports', 'ember'], function (exports, _ember) {
  exports.checkAvailability = checkAvailability;

  function checkAvailability(params /*, hash*/) {
    if (params[0] !== undefined && params[0] !== null && params[0] !== '') {
      return params[0];
    }
    return 'N/A';
  }

  exports['default'] = _ember['default'].Helper.helper(checkAvailability);
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/helpers/date-formatter', ['exports', 'ember', 'yarn-ui/utils/converter'], function (exports, _ember, _yarnUiUtilsConverter) {
  var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

  exports.dateFormatter = dateFormatter;

  function dateFormatter(params) {
    var _params = _slicedToArray(params, 2);

    var timestamp = _params[0];
    var dateOnly = _params[1];

    return dateOnly ? _yarnUiUtilsConverter['default'].timeStampToDateOnly(timestamp) : _yarnUiUtilsConverter['default'].timeStampToDate(timestamp);
  }

  exports['default'] = _ember['default'].Helper.helper(dateFormatter);
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/helpers/divide', ['exports', 'ember'], function (exports, _ember) {

  /**
   * Helper assumes values are numeric. num means numerator and
   * den means denominator.
   */
  exports['default'] = _ember['default'].Helper.helper(function (params, hash) {
    var num = hash.num;
    var den = hash.den;
    if (den === 0) {
      return 0;
    }
    return Math.floor(num / den);
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/helpers/eq', ['exports', 'ember', 'ember-truth-helpers/helpers/equal'], function (exports, _ember, _emberTruthHelpersHelpersEqual) {

  var forExport = null;

  if (_ember['default'].Helper) {
    forExport = _ember['default'].Helper.helper(_emberTruthHelpersHelpersEqual.equalHelper);
  } else if (_ember['default'].HTMLBars.makeBoundHelper) {
    forExport = _ember['default'].HTMLBars.makeBoundHelper(_emberTruthHelpersHelpersEqual.equalHelper);
  }

  exports['default'] = forExport;
});
define('yarn-ui/helpers/get-from-map', ['exports', 'ember'], function (exports, _ember) {
  exports.getFromMap = getFromMap;

  function getNestedValue(obj, path) {
    return path.split('.').reduce(function (acc, key) {
      if (acc === null || acc === undefined) {
        return undefined;
      }

      /* Handle array indexing.
      Sample input data:
       {
         "partitionKey": {
           "configuredMinResource": {
             "resourceInformations": {
               "resourceInformation": [
                 {
                   "maximumAllocation": 1024
                 },
                 {
                   "maximumAllocation": 88
                 }
               ]
             }
           }
         }
       }
      */
      var arrayMatch = key.match(/(\w+)\[(\d+)\]/);
      if (arrayMatch) {
        var arrayKey = arrayMatch[1];
        var arrayIndex = parseInt(arrayMatch[2], 10);
        return acc[arrayKey] && acc[arrayKey][arrayIndex];
      }

      return acc[key];
    }, obj);
  }

  function getFromMap(params, hash) {
    /*
    Extract map values based on the key provided and the path to the nested value
    Example:
    XPATH from the metrics: /scheduler/schedulerInfo/capacities/queueCapacitiesByPartition[3]/configuredMinResource/resourceInformations/resourceInformation[2]/maximumAllocation
    The partition map is: queueCapacitiesByPartition and accessed as "partitionMap" from the code defined in the models/yarn-queue/capacity-queue.js
    The supplied hash.map is partitionMap
    The supplied key is the partition name (nodelabel), e.g. "customPartition"
    The parameter is "configuredMinResource/resourceInformations/resourceInformation[2]/maximumAllocation"
    The returned value is the value of the maximumAllocation, which in this case will be the number of vCores present.
    */
    return getNestedValue(hash.map[hash.key], hash.parameter);
  }

  exports['default'] = _ember['default'].Helper.helper(getFromMap);
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/helpers/gt', ['exports', 'ember', 'ember-truth-helpers/helpers/gt'], function (exports, _ember, _emberTruthHelpersHelpersGt) {

  var forExport = null;

  if (_ember['default'].Helper) {
    forExport = _ember['default'].Helper.helper(_emberTruthHelpersHelpersGt.gtHelper);
  } else if (_ember['default'].HTMLBars.makeBoundHelper) {
    forExport = _ember['default'].HTMLBars.makeBoundHelper(_emberTruthHelpersHelpersGt.gtHelper);
  }

  exports['default'] = forExport;
});
define('yarn-ui/helpers/gte', ['exports', 'ember', 'ember-truth-helpers/helpers/gte'], function (exports, _ember, _emberTruthHelpersHelpersGte) {

  var forExport = null;

  if (_ember['default'].Helper) {
    forExport = _ember['default'].Helper.helper(_emberTruthHelpersHelpersGte.gteHelper);
  } else if (_ember['default'].HTMLBars.makeBoundHelper) {
    forExport = _ember['default'].HTMLBars.makeBoundHelper(_emberTruthHelpersHelpersGte.gteHelper);
  }

  exports['default'] = forExport;
});
define('yarn-ui/helpers/is-array', ['exports', 'ember', 'ember-truth-helpers/helpers/is-array'], function (exports, _ember, _emberTruthHelpersHelpersIsArray) {

  var forExport = null;

  if (_ember['default'].Helper) {
    forExport = _ember['default'].Helper.helper(_emberTruthHelpersHelpersIsArray.isArrayHelper);
  } else if (_ember['default'].HTMLBars.makeBoundHelper) {
    forExport = _ember['default'].HTMLBars.makeBoundHelper(_emberTruthHelpersHelpersIsArray.isArrayHelper);
  }

  exports['default'] = forExport;
});
define('yarn-ui/helpers/is-equal', ['exports', 'ember-truth-helpers/helpers/is-equal'], function (exports, _emberTruthHelpersHelpersIsEqual) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emberTruthHelpersHelpersIsEqual['default'];
    }
  });
  Object.defineProperty(exports, 'isEqual', {
    enumerable: true,
    get: function get() {
      return _emberTruthHelpersHelpersIsEqual.isEqual;
    }
  });
});
define('yarn-ui/helpers/is-not', ['exports', 'ember-bootstrap/helpers/is-not'], function (exports, _emberBootstrapHelpersIsNot) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emberBootstrapHelpersIsNot['default'];
    }
  });
  Object.defineProperty(exports, 'isNot', {
    enumerable: true,
    get: function get() {
      return _emberBootstrapHelpersIsNot.isNot;
    }
  });
});
define('yarn-ui/helpers/json-pretty', ['exports', 'ember'], function (exports, _ember) {
  exports.jsonPretty = jsonPretty;

  function jsonPretty(params /*, hash*/) {
    var j = params[0];
    return j;
  }

  exports['default'] = _ember['default'].Helper.helper(jsonPretty);
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/helpers/log-adapter-helper", ["exports"], function (exports) {
  exports.createEmptyContainerLogInfo = createEmptyContainerLogInfo;
  /**
   * Licensed to the Apache Software Foundation (ASF) under one
   * or more contributor license agreements.  See the NOTICE file
   * distributed with this work for additional information
   * regarding copyright ownership.  The ASF licenses this file
   * to you under the Apache License, Version 2.0 (the
   * "License"); you may not use this file except in compliance
   * with the License.  You may obtain a copy of the License at
   *
   *     http://www.apache.org/licenses/LICENSE-2.0
   *
   * Unless required by applicable law or agreed to in writing, software
   * distributed under the License is distributed on an "AS IS" BASIS,
   * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   * See the License for the specific language governing permissions and
   * limitations under the License.
   */

  function createEmptyContainerLogInfo(location) {
    return {
      containerLogsInfo: {
        containerLogInfo: [{
          fileName: "",
          fileSize: "",
          lastModifiedTime: "",
          redirectedUrl: location
        }]
      }
    };
  }
});
define("yarn-ui/helpers/log-files-comma", ["exports", "ember"], function (exports, _ember) {

  /**
   * Represent log files as comma separated list.
   */
  exports["default"] = _ember["default"].Helper.helper(function (params, hash) {
    var logFiles = hash.logFiles;
    if (logFiles == null) {
      return "";
    }
    var logFilesLen = logFiles.length;
    if (logFilesLen === 0) {
      return "";
    }
    var nodeId = hash.nodeId;
    var nodeAddr = hash.nodeAddr;
    var containerId = hash.containerId;
    var html = '<td>';
    for (var i = 0; i < logFilesLen; i++) {
      var logFileName = "";
      if (logFiles[i]) {
        if (typeof logFiles[i] === "object" && logFiles[i].containerLogFiles) {
          logFileName = logFiles[i].containerLogFiles;
        } else if (typeof logFiles[i] === "string") {
          logFileName = logFiles[i];
        }
      }
      html = html + '<a href="#/yarn-container-log/' + nodeId + '/' + nodeAddr + '/' + containerId + '/' + logFileName + '">' + logFileName + '</a>';
      if (i !== logFilesLen - 1) {
        html = html + ", ";
      }
    }
    html = html + '</td>';
    return _ember["default"].String.htmlSafe(html);
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/helpers/lower", ["exports", "ember"], function (exports, _ember) {
  exports.lower = lower;

  function lower(params) {
    var string = params[0];
    if (!string) {
      return "";
    }
    return string.toLowerCase();
  }

  exports["default"] = _ember["default"].Helper.helper(lower);
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/helpers/lt', ['exports', 'ember', 'ember-truth-helpers/helpers/lt'], function (exports, _ember, _emberTruthHelpersHelpersLt) {

  var forExport = null;

  if (_ember['default'].Helper) {
    forExport = _ember['default'].Helper.helper(_emberTruthHelpersHelpersLt.ltHelper);
  } else if (_ember['default'].HTMLBars.makeBoundHelper) {
    forExport = _ember['default'].HTMLBars.makeBoundHelper(_emberTruthHelpersHelpersLt.ltHelper);
  }

  exports['default'] = forExport;
});
define('yarn-ui/helpers/lte', ['exports', 'ember', 'ember-truth-helpers/helpers/lte'], function (exports, _ember, _emberTruthHelpersHelpersLte) {

  var forExport = null;

  if (_ember['default'].Helper) {
    forExport = _ember['default'].Helper.helper(_emberTruthHelpersHelpersLte.lteHelper);
  } else if (_ember['default'].HTMLBars.makeBoundHelper) {
    forExport = _ember['default'].HTMLBars.makeBoundHelper(_emberTruthHelpersHelpersLte.lteHelper);
  }

  exports['default'] = forExport;
});
define('yarn-ui/helpers/node-link', ['exports', 'ember'], function (exports, _ember) {

  /**
   * Generate link to node page if its not SHUTDOWN or LOST.
   */
  exports['default'] = _ember['default'].Helper.helper(function (params, hash) {
    var nodeState = hash.nodeState;
    var nodeHTTPAddress = hash.nodeHTTPAddress;
    var nodeId = hash.nodeId;
    var html = '<td>';
    if (nodeState === "SHUTDOWN" || nodeState === "LOST") {
      html = html + nodeHTTPAddress;
    } else {
      html = html + '<a href="#/yarn-node/' + nodeId + "/" + encodeURIComponent(nodeHTTPAddress) + '">' + nodeHTTPAddress + '</a>';
    }
    html = html + '</td>';
    return _ember['default'].String.htmlSafe(html);
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/helpers/node-menu', ['exports', 'ember'], function (exports, _ember) {

  /**
   * Create left hand side node manager menu with menu item activated based
   * on page being accessed.
   */
  exports['default'] = _ember['default'].Helper.helper(function (params, hash) {
    // Place a menu within a panel inside col-md-2 container.
    var nodeIdSplitAtPort = hash.nodeId;
    var portIndex = nodeIdSplitAtPort.indexOf(':');
    if (portIndex !== -1) {
      nodeIdSplitAtPort = nodeIdSplitAtPort.substring(0, portIndex) + ':&#8203;' + nodeIdSplitAtPort.substring(portIndex + 1);
    }
    var normalizedNodeId = '';
    var splitsAlongDots = nodeIdSplitAtPort.split('.');
    if (splitsAlongDots) {
      var len = splitsAlongDots.length;
      for (var i = 0; i < len; i++) {
        normalizedNodeId = normalizedNodeId + splitsAlongDots[i];
        if (i !== len - 1) {
          normalizedNodeId = normalizedNodeId + '.&#8203;';
        }
      }
    } else {
      normalizedNodeId = nodeIdSplitAtPort;
    }

    var html = '<div class="col-md-2 container-fluid"><div class="panel panel-default">' + '<div class="panel-heading"><h4>Node Manager<br>(' + normalizedNodeId + ')</h4></div>' + '<div class="panel-body"><ul class="nav nav-pills nav-stacked" id="stacked-menu">' + '<ul class="nav nav-pills nav-stacked collapse in"><li';
    if (hash.path === 'yarn-node') {
      html = html + ' class="active"';
    }
    html = html + '><a href="#/yarn-node/' + hash.nodeId + '/' + hash.nodeAddr + '">Node Information</a></li><li';
    if (hash.path === 'yarn-node-apps') {
      html = html + ' class="active"';
    }
    html = html + '><a href="#/yarn-node-apps/' + hash.nodeId + '/' + hash.nodeAddr + '">List of Applications on this Node</a></li><li';
    if (hash.path === 'yarn-node-containers') {
      html = html + ' class="active"';
    }
    html = html + '><a href="#/yarn-node-containers/' + hash.nodeId + '/' + hash.nodeAddr + '">List of Containers on this Node</a></li></ul></ul></div>';
    return _ember['default'].String.htmlSafe(html);
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/helpers/not-eq', ['exports', 'ember', 'ember-truth-helpers/helpers/not-equal'], function (exports, _ember, _emberTruthHelpersHelpersNotEqual) {

  var forExport = null;

  if (_ember['default'].Helper) {
    forExport = _ember['default'].Helper.helper(_emberTruthHelpersHelpersNotEqual.notEqualHelper);
  } else if (_ember['default'].HTMLBars.makeBoundHelper) {
    forExport = _ember['default'].HTMLBars.makeBoundHelper(_emberTruthHelpersHelpersNotEqual.notEqualHelper);
  }

  exports['default'] = forExport;
});
define('yarn-ui/helpers/not', ['exports', 'ember', 'ember-truth-helpers/helpers/not'], function (exports, _ember, _emberTruthHelpersHelpersNot) {

  var forExport = null;

  if (_ember['default'].Helper) {
    forExport = _ember['default'].Helper.helper(_emberTruthHelpersHelpersNot.notHelper);
  } else if (_ember['default'].HTMLBars.makeBoundHelper) {
    forExport = _ember['default'].HTMLBars.makeBoundHelper(_emberTruthHelpersHelpersNot.notHelper);
  }

  exports['default'] = forExport;
});
define('yarn-ui/helpers/or', ['exports', 'ember', 'ember-truth-helpers/helpers/or'], function (exports, _ember, _emberTruthHelpersHelpersOr) {

  var forExport = null;

  if (_ember['default'].Helper) {
    forExport = _ember['default'].Helper.helper(_emberTruthHelpersHelpersOr.orHelper);
  } else if (_ember['default'].HTMLBars.makeBoundHelper) {
    forExport = _ember['default'].HTMLBars.makeBoundHelper(_emberTruthHelpersHelpersOr.orHelper);
  }

  exports['default'] = forExport;
});
define('yarn-ui/helpers/prepend-protocol', ['exports', 'ember'], function (exports, _ember) {
  exports.prependProtocol = prependProtocol;

  function prependProtocol(params /*, hash*/) {
    var address = params[0];
    if (address && address.indexOf('://') < 0) {
      address = 'http://' + address;
    }
    return address;
  }

  exports['default'] = _ember['default'].Helper.helper(prependProtocol);
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/helpers/read-path', ['exports', 'ember-bootstrap/helpers/read-path'], function (exports, _emberBootstrapHelpersReadPath) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emberBootstrapHelpersReadPath['default'];
    }
  });
  Object.defineProperty(exports, 'readPath', {
    enumerable: true,
    get: function get() {
      return _emberBootstrapHelpersReadPath.readPath;
    }
  });
});
define('yarn-ui/helpers/txt', ['exports', 'em-helpers/helpers/txt'], function (exports, _emHelpersHelpersTxt) {
  Object.defineProperty(exports, 'default', {
    enumerable: true,
    get: function get() {
      return _emHelpersHelpersTxt['default'];
    }
  });
  Object.defineProperty(exports, 'txt', {
    enumerable: true,
    get: function get() {
      return _emHelpersHelpersTxt.txt;
    }
  });
});
define('yarn-ui/helpers/xor', ['exports', 'ember', 'ember-truth-helpers/helpers/xor'], function (exports, _ember, _emberTruthHelpersHelpersXor) {

  var forExport = null;

  if (_ember['default'].Helper) {
    forExport = _ember['default'].Helper.helper(_emberTruthHelpersHelpersXor.xorHelper);
  } else if (_ember['default'].HTMLBars.makeBoundHelper) {
    forExport = _ember['default'].HTMLBars.makeBoundHelper(_emberTruthHelpersHelpersXor.xorHelper);
  }

  exports['default'] = forExport;
});
define('yarn-ui/initializers/app-version', ['exports', 'ember-cli-app-version/initializer-factory', 'yarn-ui/config/environment'], function (exports, _emberCliAppVersionInitializerFactory, _yarnUiConfigEnvironment) {
  exports['default'] = {
    name: 'App Version',
    initialize: (0, _emberCliAppVersionInitializerFactory['default'])(_yarnUiConfigEnvironment['default'].APP.name, _yarnUiConfigEnvironment['default'].APP.version)
  };
});
define('yarn-ui/initializers/container-debug-adapter', ['exports', 'ember-resolver/container-debug-adapter'], function (exports, _emberResolverContainerDebugAdapter) {
  exports['default'] = {
    name: 'container-debug-adapter',

    initialize: function initialize() {
      var app = arguments[1] || arguments[0];

      app.register('container-debug-adapter:main', _emberResolverContainerDebugAdapter['default']);
      app.inject('container-debug-adapter:main', 'namespace', 'application:main');
    }
  };
});
define('yarn-ui/initializers/env', ['exports'], function (exports) {
  exports.initialize = initialize;
  /**
   * Licensed to the Apache Software Foundation (ASF) under one
   * or more contributor license agreements.  See the NOTICE file
   * distributed with this work for additional information
   * regarding copyright ownership.  The ASF licenses this file
   * to you under the Apache License, Version 2.0 (the
   * "License"); you may not use this file except in compliance
   * with the License.  You may obtain a copy of the License at
   *
   *     http://www.apache.org/licenses/LICENSE-2.0
   *
   * Unless required by applicable law or agreed to in writing, software
   * distributed under the License is distributed on an "AS IS" BASIS,
   * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   * See the License for the specific language governing permissions and
   * limitations under the License.
   */

  function initialize(application) {
    application.inject('controller', 'env', 'service:env');
    application.inject('route', 'env', 'service:env');
    application.inject('adapter', 'env', 'service:env');
    application.inject('model', 'env', 'service:env');
  }

  exports['default'] = {
    name: 'env',
    initialize: initialize
  };
});
define('yarn-ui/initializers/export-application-global', ['exports', 'ember', 'yarn-ui/config/environment'], function (exports, _ember, _yarnUiConfigEnvironment) {
  exports.initialize = initialize;

  function initialize() {
    var application = arguments[1] || arguments[0];
    if (_yarnUiConfigEnvironment['default'].exportApplicationGlobal !== false) {
      var value = _yarnUiConfigEnvironment['default'].exportApplicationGlobal;
      var globalName;

      if (typeof value === 'string') {
        globalName = value;
      } else {
        globalName = _ember['default'].String.classify(_yarnUiConfigEnvironment['default'].modulePrefix);
      }

      if (!window[globalName]) {
        window[globalName] = application;

        application.reopen({
          willDestroy: function willDestroy() {
            this._super.apply(this, arguments);
            delete window[globalName];
          }
        });
      }
    }
  }

  exports['default'] = {
    name: 'export-application-global',

    initialize: initialize
  };
});
define('yarn-ui/initializers/hosts', ['exports'], function (exports) {
  exports.initialize = initialize;
  /**
   * Licensed to the Apache Software Foundation (ASF) under one
   * or more contributor license agreements.  See the NOTICE file
   * distributed with this work for additional information
   * regarding copyright ownership.  The ASF licenses this file
   * to you under the Apache License, Version 2.0 (the
   * "License"); you may not use this file except in compliance
   * with the License.  You may obtain a copy of the License at
   *
   *     http://www.apache.org/licenses/LICENSE-2.0
   *
   * Unless required by applicable law or agreed to in writing, software
   * distributed under the License is distributed on an "AS IS" BASIS,
   * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   * See the License for the specific language governing permissions and
   * limitations under the License.
   */

  function initialize(application) {
    application.inject('controller', 'hosts', 'service:hosts');
    application.inject('route', 'hosts', 'service:hosts');
    application.inject('adapter', 'hosts', 'service:hosts');
  }

  exports['default'] = {
    name: 'hosts',
    initialize: initialize
  };
});
define('yarn-ui/initializers/jquery', ['exports', 'ember'], function (exports, _ember) {
  exports.initialize = initialize;

  function initialize() /* application */{
    _ember['default'].$(document).tooltip({
      tooltipClass: 'generic-tooltip',
      selector: ".yarn-tooltip"
    });

    _ember['default'].$.ajaxSetup({
      cache: false
    });
  }

  exports['default'] = {
    name: 'jquery',
    initialize: initialize
  };
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/initializers/load-bootstrap-config', ['exports', 'yarn-ui/config/environment', 'ember-bootstrap/config'], function (exports, _yarnUiConfigEnvironment, _emberBootstrapConfig) {
  exports.initialize = initialize;

  function initialize() /* container, application */{
    _emberBootstrapConfig['default'].load(_yarnUiConfigEnvironment['default']['ember-bootstrap'] || {});
  }

  exports['default'] = {
    name: 'load-bootstrap-config',
    initialize: initialize
  };
});
define('yarn-ui/initializers/loader', ['exports', 'ember'], function (exports, _ember) {
  exports.initialize = initialize;

  function getConfigFromYarn(rmhost, application, config) {
    var httpUrl = window.location.protocol + '//' + (ENV.hosts.localBaseAddress ? ENV.hosts.localBaseAddress + '/' : '') + rmhost;

    httpUrl += '/conf?name=' + config;
    _ember['default'].Logger.log("The RM URL is: " + httpUrl);

    var configValue = "";
    $.ajax({
      type: 'GET',
      dataType: 'json',
      async: false,
      context: this,
      url: httpUrl,
      success: function success(data) {
        configValue = data.property.value;
        _ember['default'].Logger.log("Value of the config returned from RM: " + configValue);

        application.advanceReadiness();
      },
      error: function error() {
        application.advanceReadiness();
      }
    });
    return configValue;
  }

  function getJHSURL(rmhost, application, isHttpsSchemeEnabled) {
    _ember['default'].Logger.log("getJHSURL, params:rmhost=" + rmhost + ",application=" + application + ",isHttpsSchemeEnabled=" + isHttpsSchemeEnabled);
    var config = '';
    if (isHttpsSchemeEnabled) {
      config = 'mapreduce.jobhistory.webapp.https.address';
    } else {
      config = 'mapreduce.jobhistory.webapp.address';
    }
    return getConfigFromYarn(rmhost, application, config);
  }

  function getYarnHttpProtocolScheme(rmhost, application) {
    return getConfigFromYarn(rmhost, application, 'yarn.http.policy');
  }

  function getYarnTimelineEnabled(rmhost, application) {
    return getConfigFromYarn(rmhost, application, 'yarn.timeline-service.enabled');
  }

  function getTimeLineURL(rmhost, isHttpsSchemeEnabled) {
    var url = window.location.protocol + '//' + (ENV.hosts.localBaseAddress ? ENV.hosts.localBaseAddress + '/' : '') + rmhost;

    if (isHttpsSchemeEnabled) {
      url += '/conf?name=yarn.timeline-service.reader.webapp.https.address';
    } else {
      url += '/conf?name=yarn.timeline-service.reader.webapp.address';
    }

    _ember['default'].Logger.log("Get Timeline V2 Address URL: " + url);
    return url;
  }

  function getTimeLineV1URL(rmhost, isHttpsSchemeEnabled) {
    var url = window.location.protocol + '//' + (ENV.hosts.localBaseAddress ? ENV.hosts.localBaseAddress + '/' : '') + rmhost;

    if (isHttpsSchemeEnabled) {
      url += '/conf?name=yarn.timeline-service.webapp.https.address';
    } else {
      url += '/conf?name=yarn.timeline-service.webapp.address';
    }

    _ember['default'].Logger.log("Get Timeline V1 Address URL: " + url);
    return url;
  }

  function getSecurityURL(rmhost) {
    var url = window.location.protocol + '//' + (ENV.hosts.localBaseAddress ? ENV.hosts.localBaseAddress + '/' : '') + rmhost;

    url += '/conf?name=hadoop.security.authentication';
    _ember['default'].Logger.log("Server security mode url is: " + url);
    return url;
  }

  function getClusterIdFromYARN(rmhost, application) {
    var httpUrl = window.location.protocol + '//' + (ENV.hosts.localBaseAddress ? ENV.hosts.localBaseAddress + '/' : '') + rmhost;

    httpUrl += '/conf?name=yarn.resourcemanager.cluster-id';
    _ember['default'].Logger.log("Get cluster-id URL is: " + httpUrl);

    var clusterId = "";
    $.ajax({
      type: 'GET',
      dataType: 'json',
      async: false,
      context: this,
      url: httpUrl,
      success: function success(data) {
        clusterId = data.property.value;
        _ember['default'].Logger.log("Cluster Id from RM: " + clusterId);
        application.advanceReadiness();
      },
      error: function error() {
        application.advanceReadiness();
      }
    });
    return clusterId;
  }

  function getNodeManagerPort(rmhost, application) {
    var httpUrl = window.location.protocol + "//" + (ENV.hosts.localBaseAddress ? ENV.hosts.localBaseAddress + '/' : '') + rmhost + "/conf?name=yarn.nodemanager.webapp.address";

    var port = "8042";
    $.ajax({
      type: 'GET',
      dataType: 'json',
      async: false,
      context: this,
      url: httpUrl,
      success: function success(data) {
        port = data.property.value.split(":")[1];
        application.advanceReadiness();
      },
      error: function error() {
        port = "8042";
        application.advanceReadiness();
      }
    });
    return port;
  }

  function transformURL(url, hostname) {
    // Deleting the scheme from the beginning of the url
    url = url.replace(/(^\w+:|^)\/\//, '');

    var address = url.split(":")[0];
    var port = url.split(":")[1];
    // Instead of localhost, use the name of the host
    if (address === "0.0.0.0" || address === "localhost") {
      url = hostname + ":" + port;
    }

    _ember['default'].Logger.log("The transformed URL is: " + url);
    return url;
  }

  function updateConfigs(application) {
    var hostname = window.location.hostname;
    var rmhost = hostname + (window.location.port ? ':' + window.location.port : '') + skipTrailingSlash(window.location.pathname);

    window.ENV = window.ENV || {};
    window.ENV.hosts = window.ENV.hosts || {};

    if (!ENV.hosts.rmWebAddress) {
      ENV.hosts.rmWebAddress = rmhost;
      ENV.hosts.protocolScheme = window.location.protocol;
    } else {
      rmhost = ENV.hosts.rmWebAddress;
    }

    _ember['default'].Logger.log("RM Address: " + rmhost);

    var protocolSchemeFromRM = getYarnHttpProtocolScheme(rmhost, application);
    _ember['default'].Logger.log("Is protocol scheme https? " + (protocolSchemeFromRM == "HTTPS_ONLY"));
    var isHttpsSchemeEnabled = protocolSchemeFromRM == "HTTPS_ONLY";

    var clusterIdFromYARN = getClusterIdFromYARN(rmhost, application);
    ENV.clusterId = clusterIdFromYARN;

    var nodeManagerPort = getNodeManagerPort(rmhost, application);
    _ember['default'].Logger.log("NodeMananger port: " + nodeManagerPort);
    ENV.nodeManagerPort = nodeManagerPort;

    var timelineServiceEnabled = getYarnTimelineEnabled(rmhost, application);
    _ember['default'].Logger.log("Timeline Service enabled: " + timelineServiceEnabled);
    ENV.timelineServiceEnabled = timelineServiceEnabled.toLowerCase() === 'true';

    if (!ENV.hosts.jhsAddress) {
      var jhsAddress = getJHSURL(rmhost, application, isHttpsSchemeEnabled);
      jhsAddress = transformURL(jhsAddress, hostname);
      _ember['default'].Logger.log("The JHS address is " + jhsAddress);
      ENV.hosts.jhsAddress = jhsAddress;
    }

    if (!ENV.hosts.timelineWebAddress) {
      var timelinehost = "";
      $.ajax({
        type: 'GET',
        dataType: 'json',
        async: false,
        context: this,
        url: getTimeLineURL(rmhost, isHttpsSchemeEnabled),
        success: function success(data) {
          timelinehost = data.property.value;
          timelinehost = transformURL(timelinehost, hostname);
          ENV.hosts.timelineWebAddress = timelinehost;
          _ember['default'].Logger.log("Timeline Address from RM: " + timelinehost);

          application.advanceReadiness();
        },
        error: function error() {
          application.advanceReadiness();
        }
      });
    } else {
      _ember['default'].Logger.log("Timeline Address: " + ENV.hosts.timelineWebAddress);
      application.advanceReadiness();
    }

    if (!ENV.hosts.timelineV1WebAddress) {
      var timelinehost = "";
      $.ajax({
        type: 'GET',
        dataType: 'json',
        async: false,
        context: this,
        url: getTimeLineV1URL(rmhost, isHttpsSchemeEnabled),
        success: function success(data) {
          timelinehost = data.property.value;
          timelinehost = transformURL(timelinehost, hostname);
          ENV.hosts.timelineV1WebAddress = timelinehost;
          _ember['default'].Logger.log("Timeline V1 Address from RM: " + timelinehost);

          application.advanceReadiness();
        },
        error: function error() {
          application.advanceReadiness();
        }
      });
    } else {
      _ember['default'].Logger.log("Timeline V1 Address: " + ENV.hosts.timelineV1WebAddress);
      application.advanceReadiness();
    }

    if (!ENV.hosts.isSecurityEnabled) {
      var isSecurityEnabled = "";
      $.ajax({
        type: 'GET',
        dataType: 'json',
        async: false,
        context: this,
        url: getSecurityURL(rmhost),
        success: function success(data) {
          isSecurityEnabled = data.property.value;
          ENV.hosts.isSecurityEnabled = isSecurityEnabled;
          _ember['default'].Logger.log("Security mode is : " + isSecurityEnabled);
          application.advanceReadiness();
        },
        error: function error() {
          application.advanceReadiness();
        }
      });
    } else {
      _ember['default'].Logger.log("Security mode is: " + ENV.hosts.isSecurityEnabled);
      application.advanceReadiness();
    }
  }

  function initialize(application) {
    application.deferReadiness();
    updateConfigs(application);
  }

  exports['default'] = {
    name: 'loader',
    before: 'env',
    initialize: initialize
  };

  var skipTrailingSlash = function skipTrailingSlash(path) {
    path = path.replace('index.html', '');
    path = path.replace('ui2/', '');
    path = path.replace(/\/$/, '');
    console.log('base url:' + path);
    if (path.includes("redirect")) {
      var to = path.lastIndexOf('/');
      to = to == -1 ? path.length : to + 1;
      path = path.substring(0, to);
      console.log('base url after redirect:' + path);
    }
    return path;
  };
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* globals ENV: true */
define('yarn-ui/initializers/modals-container', ['exports', 'ember-bootstrap/initializers/modals-container'], function (exports, _emberBootstrapInitializersModalsContainer) {
  exports['default'] = _emberBootstrapInitializersModalsContainer['default'];
});
define('yarn-ui/initializers/truth-helpers', ['exports', 'ember', 'ember-truth-helpers/utils/register-helper', 'ember-truth-helpers/helpers/and', 'ember-truth-helpers/helpers/or', 'ember-truth-helpers/helpers/equal', 'ember-truth-helpers/helpers/not', 'ember-truth-helpers/helpers/is-array', 'ember-truth-helpers/helpers/not-equal', 'ember-truth-helpers/helpers/gt', 'ember-truth-helpers/helpers/gte', 'ember-truth-helpers/helpers/lt', 'ember-truth-helpers/helpers/lte'], function (exports, _ember, _emberTruthHelpersUtilsRegisterHelper, _emberTruthHelpersHelpersAnd, _emberTruthHelpersHelpersOr, _emberTruthHelpersHelpersEqual, _emberTruthHelpersHelpersNot, _emberTruthHelpersHelpersIsArray, _emberTruthHelpersHelpersNotEqual, _emberTruthHelpersHelpersGt, _emberTruthHelpersHelpersGte, _emberTruthHelpersHelpersLt, _emberTruthHelpersHelpersLte) {
  exports.initialize = initialize;

  function initialize() /* container, application */{

    // Do not register helpers from Ember 1.13 onwards, starting from 1.13 they
    // will be auto-discovered.
    if (_ember['default'].Helper) {
      return;
    }

    (0, _emberTruthHelpersUtilsRegisterHelper.registerHelper)('and', _emberTruthHelpersHelpersAnd.andHelper);
    (0, _emberTruthHelpersUtilsRegisterHelper.registerHelper)('or', _emberTruthHelpersHelpersOr.orHelper);
    (0, _emberTruthHelpersUtilsRegisterHelper.registerHelper)('eq', _emberTruthHelpersHelpersEqual.equalHelper);
    (0, _emberTruthHelpersUtilsRegisterHelper.registerHelper)('not', _emberTruthHelpersHelpersNot.notHelper);
    (0, _emberTruthHelpersUtilsRegisterHelper.registerHelper)('is-array', _emberTruthHelpersHelpersIsArray.isArrayHelper);
    (0, _emberTruthHelpersUtilsRegisterHelper.registerHelper)('not-eq', _emberTruthHelpersHelpersNotEqual.notEqualHelper);
    (0, _emberTruthHelpersUtilsRegisterHelper.registerHelper)('gt', _emberTruthHelpersHelpersGt.gtHelper);
    (0, _emberTruthHelpersUtilsRegisterHelper.registerHelper)('gte', _emberTruthHelpersHelpersGte.gteHelper);
    (0, _emberTruthHelpersUtilsRegisterHelper.registerHelper)('lt', _emberTruthHelpersHelpersLt.ltHelper);
    (0, _emberTruthHelpersUtilsRegisterHelper.registerHelper)('lte', _emberTruthHelpersHelpersLte.lteHelper);
  }

  exports['default'] = {
    name: 'truth-helpers',
    initialize: initialize
  };
});
define('yarn-ui/mixins/app-attempt', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Mixin.create({
    fetchAppInfoFromRMorATS: function fetchAppInfoFromRMorATS(appId, store) {
      return new _ember['default'].RSVP.Promise(function (resolve, reject) {
        store.find('yarn-app', appId).then(function (rmApp) {
          resolve(rmApp);
        }, function () {
          store.find('yarn-app-timeline', appId).then(function (atsApp) {
            resolve(atsApp);
          }, function () {
            console.error('Error:', 'Application not found in RM or ATS for appId: ' + appId);
            reject(null);
          });
        });
      });
    },

    fetchAppInfoFromRM: function fetchAppInfoFromRM(appId, store) {
      return new _ember['default'].RSVP.Promise(function (resolve, reject) {
        store.find('yarn-app', appId).then(function (rmApp) {
          resolve(rmApp);
        }, function () {
          console.error('Error:', 'Application not found in RM for appId: ' + appId);
          reject(null);
        });
      });
    },

    fetchAttemptInfoFromRMorATS: function fetchAttemptInfoFromRMorATS(attemptId, store) {
      return new _ember['default'].RSVP.Promise(function (resolve, reject) {
        store.findRecord('yarn-app-attempt', attemptId, { reload: true }).then(function (rmAttempt) {
          resolve(rmAttempt);
        }, function () {
          store.findRecord('yarn-timeline-appattempt', attemptId, { reload: true }).then(function (atsAttempt) {
            resolve(atsAttempt);
          }, function () {
            console.error('Error:', 'Application attempt not found in RM or ATS for attemptId: ' + attemptId);
            reject(null);
          });
        });
      });
    },

    fetchAttemptListFromRMorATS: function fetchAttemptListFromRMorATS(appId, store) {
      return new _ember['default'].RSVP.Promise(function (resolve, reject) {
        store.query('yarn-app-attempt', { appId: appId }).then(function (rmAttempts) {
          resolve(rmAttempts);
        }, function () {
          store.query('yarn-timeline-appattempt', { appId: appId }).then(function (atsAttempts) {
            resolve(atsAttempts);
          }, function () {
            console.error('Error:', 'Application attempts not found in RM or ATS for appId: ' + appId);
            reject(null);
          });
        });
      });
    },

    fetchAttemptListFromRM: function fetchAttemptListFromRM(appId, store) {
      return new _ember['default'].RSVP.Promise(function (resolve, reject) {
        store.query('yarn-app-attempt', { appId: appId }).then(function (rmAttempts) {
          resolve(rmAttempts);
        }, function () {
          console.error('Error:', 'Application attempts not found in RM for appId: ' + appId);
          reject(null);
        });
      });
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/cluster-info', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    startedOn: _emberData['default'].attr('string'),
    state: _emberData['default'].attr('string'),
    haState: _emberData['default'].attr('string'),
    rmStateStoreName: _emberData['default'].attr('string'),
    resourceManagerVersion: _emberData['default'].attr('string'),
    resourceManagerBuildVersion: _emberData['default'].attr('string'),
    hadoopVersion: _emberData['default'].attr('string'),
    hadoopBuildVersion: _emberData['default'].attr('string'),
    hadoopVersionBuiltOn: _emberData['default'].attr('string'),
    getYARNBuildHash: (function () {
      return this.get("hadoopVersion") + " from " + this.get("resourceManagerBuildVersion").split(" ")[2];
    }).property("yarnHash")
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/cluster-metric', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    appsSubmitted: _emberData['default'].attr('number'),
    appsCompleted: _emberData['default'].attr('number'),
    appsPending: _emberData['default'].attr('number'),
    appsRunning: _emberData['default'].attr('number'),
    appsFailed: _emberData['default'].attr('number'),
    appsKilled: _emberData['default'].attr('number'),
    reservedMB: _emberData['default'].attr('number'),
    availableMB: _emberData['default'].attr('number'),
    allocatedMB: _emberData['default'].attr('number'),
    reservedVirtualCores: _emberData['default'].attr('number'),
    availableVirtualCores: _emberData['default'].attr('number'),
    allocatedVirtualCores: _emberData['default'].attr('number'),
    containersAllocated: _emberData['default'].attr('number'),
    containersReserved: _emberData['default'].attr('number'),
    containersPending: _emberData['default'].attr('number'),
    totalMB: _emberData['default'].attr('number'),
    totalVirtualCores: _emberData['default'].attr('number'),
    totalNodes: _emberData['default'].attr('number'),
    lostNodes: _emberData['default'].attr('number'),
    unhealthyNodes: _emberData['default'].attr('number'),
    decommissioningNodes: _emberData['default'].attr('number'),
    decommissionedNodes: _emberData['default'].attr('number'),
    rebootedNodes: _emberData['default'].attr('number'),
    activeNodes: _emberData['default'].attr('number'),
    totalUsedResourcesAcrossPartition: _emberData['default'].attr('object'),
    totalClusterResourcesAcrossPartition: _emberData['default'].attr('object'),

    getFinishedAppsDataForDonutChart: (function () {
      var arr = [];
      arr.push({
        label: "Completed",
        value: this.get("appsCompleted")
      });
      arr.push({
        label: "Killed",
        value: this.get("appsKilled")
      });
      arr.push({
        label: "Failed",
        value: this.get("appsFailed")
      });

      return arr;
    }).property("appsCompleted", "appsKilled", "appsFailed"),

    getRunningAppsDataForDonutChart: (function () {
      var arr = [];

      arr.push({
        label: "Pending",
        value: this.get("appsPending")
      });
      arr.push({
        label: "Running",
        value: this.get("appsRunning")
      });

      return arr;
    }).property("appsPending", "appsRunning"),

    getNodesDataForDonutChart: (function () {
      var arr = [];
      arr.push({
        label: "Active",
        value: this.get("activeNodes")
      });
      arr.push({
        label: "Unhealthy",
        value: this.get("unhealthyNodes")
      });
      arr.push({
        label: "Decommissioning",
        value: this.get("decommissioningNodes") || 0
      });
      arr.push({
        label: "Decommissioned",
        value: this.get("decommissionedNodes")
      });
      arr.push({
        label: "Lost",
        value: this.get("lostNodes")
      });
      return arr;
    }).property("activeNodes", "unhealthyNodes", "decommissioningNodes", "decommissionedNodes", "lostNodes"),

    getMemoryDataForDonutChart: (function () {
      var type = "MB";
      var arr = [];
      arr.push({
        label: "Allocated",
        value: this.get("allocated" + type)
      });
      arr.push({
        label: "Reserved",
        value: this.get("reserved" + type)
      });
      arr.push({
        label: "Available",
        value: this.get("available" + type)
      });

      return arr;
    }).property("allocatedMB", "reservedMB", "availableMB"),

    getVCoreDataForDonutChart: (function () {
      var type = "VirtualCores";
      var arr = [];
      arr.push({
        label: "Allocated",
        value: this.get("allocated" + type)
      });
      arr.push({
        label: "Reserved",
        value: this.get("reserved" + type)
      });
      arr.push({
        label: "Available",
        value: Math.max(this.get("available" + type), 0)
      });

      return arr;
    }).property("allocatedVirtualCores", "reservedVirtualCores", "availableVirtualCores"),

    getResourceTypes: (function () {
      var types = [];
      if (this.get("totalClusterResourcesAcrossPartition")) {

        console.log(types);
      }
    }).property("totalClusterResourcesAcrossPartition"),

    /*
     * Returned format
     * [
     *     {
     *         name: <resource-name>
     *         unit: <resource-unit>
     *         [
     *            {
     *               label: <label>
     *               value: <value>
     *            },
     *            {
     *            }
     *            ...
     *         ],
     *     }
     * ]
     */
    getAllResourceTypesDonutChart: (function () {
      if (this.get("totalClusterResourcesAcrossPartition") && this.get("totalUsedResourcesAcrossPartition")) {
        var usages = [];

        var clusterResourceInformations = this.get("totalClusterResourcesAcrossPartition").resourceInformations.resourceInformation;
        var usedResourceInformations = this.get("totalUsedResourcesAcrossPartition").resourceInformations.resourceInformation;

        clusterResourceInformations.forEach(function (cluster) {
          var perResourceTypeUsage = {
            name: cluster.name,
            unit: cluster.units,
            data: []
          };

          usedResourceInformations.forEach(function (used) {
            if (used.name === perResourceTypeUsage.name) {
              var usedValue = used.value;
              perResourceTypeUsage.data.push({
                label: "Used",
                value: usedValue
              }, {
                label: "Available",
                value: cluster.value - usedValue
              });
            }
          });

          usages.push(perResourceTypeUsage);

          // Make sure id is a valid w3c ID
          perResourceTypeUsage.id = perResourceTypeUsage.name.replace('/', '-');
          perResourceTypeUsage.id = perResourceTypeUsage.id.replace('.', '-');
        });

        console.log(usages);
        return usages;
      }
      return null;
    }).property()
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/cluster-user-info', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    rmLoginUser: _emberData['default'].attr('string'),
    requestedUser: _emberData['default'].attr('string')
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/jhs-health', ['exports', 'ember-data', 'ember'], function (exports, _emberData, _ember) {
  exports['default'] = _emberData['default'].Model.extend({
    startedOn: _emberData['default'].attr('string'),

    isJHSHealthy: (function () {
      return this.get('startedOn') !== null;
    }).property('startedOn')
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/timeline-health', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    healthStatus: _emberData['default'].attr('string'),

    isTimelineUnHealthy: (function () {
      return this.get('healthStatus') !== 'RUNNING';
    }).property('healthStatus')
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-app-attempt', ['exports', 'ember', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _ember, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].Model.extend({
    startTime: _emberData['default'].attr('string'),
    startedTime: _emberData['default'].attr('string'),
    finishedTime: _emberData['default'].attr('string'),
    containerId: _emberData['default'].attr('string'),
    amContainerId: _emberData['default'].attr('string'),
    nodeHttpAddress: _emberData['default'].attr('string'),
    exposedPorts: _emberData['default'].attr('string'),
    nodeId: _emberData['default'].attr('string'),
    hosts: _emberData['default'].attr('string'),
    logsLink: _emberData['default'].attr('string'),
    state: _emberData['default'].attr('string'),
    appAttemptId: _emberData['default'].attr('string'),
    diagnosticsInfo: _emberData['default'].attr('string'),

    appId: _ember['default'].computed("id", function () {
      var id = this.get("id");
      id = id.split("_");

      id[0] = "application";
      id.pop();

      return id.join("_");
    }),

    attemptStartedTime: (function () {
      var startTime = this.get("startTime");
      // If startTime variable is not present, get from startedTime
      if (startTime === undefined || startTime === "Invalid date") {
        startTime = this.get("startedTime");
      }

      return startTime;
    }).property("startedTime"),

    startTs: (function () {
      return _yarnUiUtilsConverter['default'].dateToTimeStamp(this.get('attemptStartedTime'));
    }).property("startTime"),

    finishedTs: (function () {
      var ts = _yarnUiUtilsConverter['default'].dateToTimeStamp(this.get("finishedTime"));
      return ts;
    }).property("finishedTime"),

    validatedFinishedTs: (function () {
      if (this.get("finishedTs") < this.get("startTs")) {
        return "";
      }
      return this.get("finishedTime");
    }).property("finishedTime"),

    shortAppAttemptId: (function () {
      if (!this.get("containerId")) {
        return this.get("id");
      }
      return "attempt_" + parseInt(_yarnUiUtilsConverter['default'].containerIdToAttemptId(this.get("containerId")).split("_")[3]);
    }).property("containerId"),

    appMasterContainerId: (function () {
      var id = this.get("containerId");
      // If containerId variable is not present, get from amContainerId
      if (id === undefined) {
        id = this.get("amContainerId");
      }
      return id;
    }).property("amContainerId"),

    IsAmNodeUrl: (function () {
      var url = this.get("nodeHttpAddress");
      // If nodeHttpAddress variable is not present, hardcode it.
      if (url === undefined) {
        url = "Not Available";
      }
      return url !== "Not Available";
    }).property("nodeHttpAddress"),

    amNodeId: (function () {
      var id = this.get("nodeId");
      // If nodeId variable is not present, get from host
      if (id === undefined) {
        id = this.get("hosts");
      }
      return id;
    }).property("nodeId"),

    IsLinkAvailable: (function () {
      var url = this.get("logsLink");
      // If logsLink variable is not present, hardcode its.
      if (url === undefined) {
        url = "Not Available";
      }
      return url !== "Not Available";
    }).property("logsLink"),

    elapsedTime: (function () {
      var elapsedMs = this.get("finishedTs") - this.get("startTs");
      if (elapsedMs <= 0) {
        elapsedMs = Date.now() - this.get("startTs");
      }
      return _yarnUiUtilsConverter['default'].msToElapsedTimeUnit(elapsedMs);
    }).property(),

    tooltipLabel: (function () {
      return "<p>Id:" + this.get("id") + "</p><p>ElapsedTime:" + String(this.get("elapsedTime")) + "</p>";
    }).property(),

    link: (function () {
      return "/yarn-app-attempt/" + this.get("id");
    }).property(),

    linkname: (function () {
      return "yarn-app-attempt";
    }).property(),

    attemptState: (function () {
      return this.get("state");
    }).property(),

    masterNodeURL: (function () {
      var addr = encodeURIComponent(this.get("nodeHttpAddress"));
      return '#/yarn-node/' + this.get("nodeId") + '/' + addr + '/info';
    }).property("nodeId", "nodeHttpAddress"),

    appAttemptContainerLogsURL: (function () {
      var attemptId = this.get("id");
      var containerId = this.get("appMasterContainerId");
      var appId = _yarnUiUtilsConverter['default'].attemptIdToAppId(attemptId);
      return '#/yarn-app/' + appId + '/logs?attempt=' + attemptId + '&containerid=' + containerId;
    }).property("id", "appMasterContainerId")
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-app-flowrun', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].Model.extend({
    appId: _emberData['default'].attr('string'),
    type: _emberData['default'].attr('string'),
    uid: _emberData['default'].attr('string'),
    metrics: _emberData['default'].attr('array'),
    startedTs: _emberData['default'].attr('number'),
    finishedTs: _emberData['default'].attr('number'),
    state: _emberData['default'].attr('string'),
    cpuVCores: _emberData['default'].attr('number'),
    memoryUsed: _emberData['default'].attr('number'),

    elapsedTs: (function () {
      return this.get('finishedTs') - this.get('startedTs');
    }).property('startedTs', 'finishedTs'),

    getCpuVCoresVizDataForBarChart: function getCpuVCoresVizDataForBarChart() {
      return {
        label: this.get('appId'),
        value: this.get('cpuVCores'),
        tooltip: this.get("appId") + "<br>" + 'CPU VCores: ' + this.get('cpuVCores')
      };
    },

    getMemoryVizDataForBarChart: function getMemoryVizDataForBarChart() {
      return {
        label: this.get('appId'),
        value: this.get('memoryUsed'),
        tooltip: this.get("appId") + "<br>" + 'Memory Used: ' + _yarnUiUtilsConverter['default'].memoryBytesToMB(this.get('memoryUsed'))
      };
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-app-jhs-log', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    logs: _emberData['default'].attr('string', { defaultValue: '' }),
    containerID: _emberData['default'].attr('string', { defaultValue: '' }),
    logFileName: _emberData['default'].attr('string', { defaultValue: '' }),
    redirectedUrl: _emberData['default'].attr('string', { defaultValue: '' })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-app-jhs-redirect-log', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    logs: _emberData['default'].attr('string', { defaultValue: '' }),
    containerID: _emberData['default'].attr('string', { defaultValue: '' }),
    logFileName: _emberData['default'].attr('string', { defaultValue: '' }),
    redirectedUrl: _emberData['default'].attr('string', { defaultValue: '' })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-app-log', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    logs: _emberData['default'].attr('string', { defaultValue: '' }),
    containerID: _emberData['default'].attr('string', { defaultValue: '' }),
    logFileName: _emberData['default'].attr('string', { defaultValue: '' }),
    redirectedUrl: _emberData['default'].attr('string', { defaultValue: '' })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-app-redirect-log', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    logs: _emberData['default'].attr('string', { defaultValue: '' }),
    containerID: _emberData['default'].attr('string', { defaultValue: '' }),
    logFileName: _emberData['default'].attr('string', { defaultValue: '' }),
    redirectedUrl: _emberData['default'].attr('string', { defaultValue: '' })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-app-timeline', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].Model.extend({
    appName: _emberData['default'].attr('string'),
    user: _emberData['default'].attr('string'),
    queue: _emberData['default'].attr('string'),
    state: _emberData['default'].attr('string'),
    startTime: _emberData['default'].attr('string'),
    elapsedTime: _emberData['default'].attr('string'),
    finalStatus: _emberData['default'].attr('string'),
    finishedTime: _emberData['default'].attr('finishedTime'),
    progress: _emberData['default'].attr('number'),
    diagnostics: _emberData['default'].attr('string'),
    amHostHttpAddress: _emberData['default'].attr('string'),
    logAggregationStatus: _emberData['default'].attr('string'),
    unmanagedApplication: _emberData['default'].attr('string'),
    amNodeLabelExpression: _emberData['default'].attr('string'),
    applicationTags: _emberData['default'].attr('string'),
    applicationType: _emberData['default'].attr('string'),
    priority: _emberData['default'].attr('number'),
    allocatedMB: _emberData['default'].attr('number'),
    allocatedVCores: _emberData['default'].attr('number'),
    runningContainers: _emberData['default'].attr('number'),
    memorySeconds: _emberData['default'].attr('number'),
    vcoreSeconds: _emberData['default'].attr('number'),
    preemptedResourceMB: _emberData['default'].attr('number'),
    preemptedResourceVCores: _emberData['default'].attr('number'),
    numNonAMContainerPreempted: _emberData['default'].attr('number'),
    numAMContainerPreempted: _emberData['default'].attr('number'),
    clusterUsagePercentage: _emberData['default'].attr('number'),
    queueUsagePercentage: _emberData['default'].attr('number'),
    currentAppAttemptId: _emberData['default'].attr('string'),

    isFailed: (function () {
      return this.get('finalStatus') === "FAILED";
    }).property("finalStatus"),

    validatedFinishedTs: (function () {
      if (this.get("finishedTime") < this.get("startTime")) {
        return "";
      }
      return this.get("finishedTime");
    }).property("finishedTime"),

    formattedElapsedTime: (function () {
      return _yarnUiUtilsConverter['default'].msToElapsedTimeUnit(this.get('elapsedTime'));
    }).property('elapsedTime'),

    allocatedResource: (function () {
      return _yarnUiUtilsConverter['default'].resourceToString(this.get("allocatedMB"), this.get("allocatedVCores"));
    }).property("allocatedMB", "allocatedVCores"),

    preemptedResource: (function () {
      return _yarnUiUtilsConverter['default'].resourceToString(this.get("preemptedResourceMB"), this.get("preemptedResourceVCores"));
    }).property("preemptedResourceMB", "preemptedResourceVCores"),

    aggregatedResourceUsage: (function () {
      return _yarnUiUtilsConverter['default'].resourceToString(this.get("memorySeconds"), this.get("vcoreSeconds")) + " (× Secs)";
    }).property("memorySeconds", "vcoreSeconds"),

    progressStyle: (function () {
      return "width: " + this.get("progress") + "%";
    }).property("progress"),

    runningContainersNumber: (function () {
      if (this.get("runningContainers") < 0) {
        return 0;
      }
      return this.get("runningContainers");
    }).property("progress"),

    finalStatusStyle: (function () {
      var style = "default";
      var finalStatus = this.get("finalStatus");
      if (finalStatus === "KILLED") {
        style = "warning";
      } else if (finalStatus === "FAILED") {
        style = "danger";
      } else {
        style = "success";
      }

      return "label label-" + style;
    }).property("finalStatus")
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-app', ['exports', 'yarn-ui/utils/converter', 'ember-data'], function (exports, _yarnUiUtilsConverter, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    appName: _emberData['default'].attr("string"),
    user: _emberData['default'].attr("string"),
    queue: _emberData['default'].attr("string"),
    state: _emberData['default'].attr("string"),
    startTime: _emberData['default'].attr("number"),
    elapsedTime: _emberData['default'].attr("string"),
    finalStatus: _emberData['default'].attr("string"),
    finishedTime: _emberData['default'].attr("number"),
    progress: _emberData['default'].attr("number"),
    diagnostics: _emberData['default'].attr("string"),
    amHostHttpAddress: _emberData['default'].attr("string"),
    masterNodeId: _emberData['default'].attr("string"),
    logAggregationStatus: _emberData['default'].attr("string"),
    unmanagedApplication: _emberData['default'].attr("boolean"),
    amNodeLabelExpression: _emberData['default'].attr("string"),
    applicationTags: _emberData['default'].attr("string"),
    applicationType: _emberData['default'].attr("string"),
    priority: _emberData['default'].attr("string"),
    allocatedMB: _emberData['default'].attr("number"),
    allocatedVCores: _emberData['default'].attr("number"),
    runningContainers: _emberData['default'].attr("number"),
    memorySeconds: _emberData['default'].attr("number"),
    vcoreSeconds: _emberData['default'].attr("number"),
    preemptedResourceMB: _emberData['default'].attr("number"),
    preemptedResourceVCores: _emberData['default'].attr("number"),
    numNonAMContainerPreempted: _emberData['default'].attr("number"),
    numAMContainerPreempted: _emberData['default'].attr("number"),
    clusterUsagePercentage: _emberData['default'].attr("number"),
    queueUsagePercentage: _emberData['default'].attr("number"),
    currentAppAttemptId: _emberData['default'].attr("string"),
    remainingTimeoutInSeconds: _emberData['default'].attr("number"),
    applicationExpiryTime: _emberData['default'].attr("string"),
    resourceRequests: _emberData['default'].attr("array"),
    trackingUI: _emberData['default'].attr("string"),
    trackingUrl: _emberData['default'].attr("string"),

    isFailed: (function () {
      return this.get("finalStatus") === "FAILED";
    }).property("finalStatus"),

    validatedFinishedTs: (function () {
      if (this.get("finishedTime") < this.get("startTime")) {
        return "N/A";
      }
      return this.get("finishedTime");
    }).property("finishedTime"),

    hasFinishedTime: (function () {
      return this.get("finishedTime") >= this.get("startTime");
    }).property("hasFinishedTime"),

    formattedStartTime: (function () {
      return _yarnUiUtilsConverter['default'].timeStampToDate(this.get('startTime'));
    }).property('startTime'),

    formattedFinishedTime: (function () {
      if (this.get("finishedTime") < this.get("startTime")) {
        return "N/A";
      }
      return _yarnUiUtilsConverter['default'].timeStampToDate(this.get("finishedTime"));
    }).property('finishedTime'),

    formattedElapsedTime: (function () {
      return _yarnUiUtilsConverter['default'].msToElapsedTimeUnit(this.get("elapsedTime"));
    }).property("elapsedTime"),

    allocatedResource: (function () {
      return _yarnUiUtilsConverter['default'].resourceToString(this.get("allocatedMB"), this.get("allocatedVCores"));
    }).property("allocatedMB", "allocatedVCores"),

    preemptedResource: (function () {
      return _yarnUiUtilsConverter['default'].resourceToString(this.get("preemptedResourceMB"), this.get("preemptedResourceVCores"));
    }).property("preemptedResourceMB", "preemptedResourceVCores"),

    aggregatedResourceUsage: (function () {
      return _yarnUiUtilsConverter['default'].resourceToString(this.get("memorySeconds"), this.get("vcoreSeconds")) + " (× Secs)";
    }).property("memorySeconds", "vcoreSeconds"),

    progressStyle: (function () {
      return "width: " + this.get("progress") + "%";
    }).property("progress"),

    runningContainersNumber: (function () {
      if (this.get("runningContainers") < 0) {
        return 0;
      }
      return this.get("runningContainers");
    }).property("progress"),

    finalStatusStyle: (function () {
      var finalStatus = this.get("finalStatus");
      var style = "";

      if (finalStatus === "KILLED") {
        style = "warning";
      } else if (finalStatus === "FAILED") {
        style = "danger";
      } else if (finalStatus === "SUCCEEDED") {
        style = "success";
      } else {
        style = "default";
      }

      return "label label-" + style;
    }).property("finalStatus"),

    logAggregationStatusStyle: (function () {
      var logAggregationStatus = this.get("logAggregationStatus");
      var style = "";
      if (logAggregationStatus === "FAILED" || logAggregationStatus === "TIME_OUT") {
        style = "danger";
      } else if (logAggregationStatus === "RUNNING_WITH_FAILURE") {
        style = "warning";
      } else if (logAggregationStatus === "SUCCEEDED") {
        style = "success";
      } else {
        style = "default";
      }
      return "label label-" + style;
    }).property("logAggregationStatus")
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-component-instance', ['exports', 'ember-data', 'ember', 'yarn-ui/utils/converter'], function (exports, _emberData, _ember, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].Model.extend({
    containerId: _emberData['default'].attr('string'),
    component: _emberData['default'].attr('string'),
    instanceName: _emberData['default'].attr('string'),
    state: _emberData['default'].attr('number'),
    createdTimestamp: _emberData['default'].attr('number'),
    startedTimestamp: _emberData['default'].attr('number'),
    host: _emberData['default'].attr('string'),
    node: _emberData['default'].attr('string'),
    hostUrl: _emberData['default'].attr('string'),
    ipAddr: _emberData['default'].attr('string'),
    exposedPorts: _emberData['default'].attr('string'),
    exitStatusCode: _emberData['default'].attr('string'),

    createdDate: _ember['default'].computed('createdTimestamp', function () {
      var timestamp = this.get('createdTimestamp');
      if (timestamp > 0) {
        return _yarnUiUtilsConverter['default'].timeStampToDate(timestamp);
      }
      return 'N/A';
    }),

    startedDate: _ember['default'].computed('startedTimestamp', function () {
      var timestamp = this.get('startedTimestamp');
      if (timestamp > 0) {
        return _yarnUiUtilsConverter['default'].timeStampToDate(timestamp);
      }
      return 'N/A';
    }),

    termLink: _ember['default'].computed('node', 'containerId', function () {
      var protocol = window.location.protocol;
      var node = this.get('node');
      var port = this.get('env.app.nodeManagerPort');
      var containerId = this.get('containerId');
      var url = protocol + "//" + node + ":" + port + "/terminal/terminal.template?container=" + containerId;
      return url;
    }),

    containerLogURL: _ember['default'].computed('containerId', function () {
      var containerId = this.get('containerId');
      var attemptId = _yarnUiUtilsConverter['default'].containerIdToAttemptId(containerId);
      var appId = _yarnUiUtilsConverter['default'].attemptIdToAppId(attemptId);
      return '#/yarn-app/' + appId + '/logs?attempt=' + attemptId + '&containerid=' + containerId;
    })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-conf', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    name: _emberData['default'].attr(),
    source: _emberData['default'].attr(),
    value: _emberData['default'].attr()
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-container-log', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    logs: _emberData['default'].attr('string'),
    containerID: _emberData['default'].attr('string'),
    logFileName: _emberData['default'].attr('string')
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-container', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].Model.extend({
    allocatedMB: _emberData['default'].attr('number'),
    allocatedVCores: _emberData['default'].attr('number'),
    assignedNodeId: _emberData['default'].attr('string'),
    priority: _emberData['default'].attr('number'),
    startedTime: _emberData['default'].attr('number'),
    finishedTime: _emberData['default'].attr('number'),
    logUrl: _emberData['default'].attr('string'),
    containerExitStatus: _emberData['default'].attr('number'),
    containerState: _emberData['default'].attr('string'),
    nodeHttpAddress: _emberData['default'].attr('string'),
    exposedPorts: _emberData['default'].attr('string'),
    nodeId: _emberData['default'].attr('string'),

    startTs: (function () {
      return _yarnUiUtilsConverter['default'].dateToTimeStamp(this.get("startedTime"));
    }).property("startedTime"),

    finishedTs: (function () {
      var ts = _yarnUiUtilsConverter['default'].dateToTimeStamp(this.get("finishedTime"));
      return ts;
    }).property("finishedTime"),

    validatedFinishedTs: (function () {
      if (this.get("finishedTs") < this.get("startTs")) {
        return "";
      }
      return this.get("finishedTime");
    }).property("finishedTime"),

    elapsedTime: (function () {
      var elapsedMs = this.get("finishedTs") - this.get("startTs");
      if (elapsedMs <= 0) {
        elapsedMs = Date.now() - this.get("startTs");
      }
      return _yarnUiUtilsConverter['default'].msToElapsedTimeUnit(elapsedMs);
    }).property(),

    tooltipLabel: (function () {
      return "<p>Id:" + this.get("id") + "</p><p>ElapsedTime:" + String(this.get("elapsedTime")) + "</p>";
    }).property(),

    masterNodeURL: (function () {
      var addr = encodeURIComponent(this.get("nodeHttpAddress"));
      return '#/yarn-node/' + this.get("nodeId") + '/' + addr + '/info';
    }).property("nodeId", "nodeHttpAddress"),

    appAttemptContainerLogsURL: (function () {
      var containerId = this.get("id");
      var attemptId = _yarnUiUtilsConverter['default'].containerIdToAttemptId(containerId);
      var appId = _yarnUiUtilsConverter['default'].attemptIdToAppId(attemptId);
      return '#/yarn-app/' + appId + '/logs?attempt=' + attemptId + '&containerid=' + containerId;
    }).property("id")
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-entity', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    entityId: _emberData['default'].attr('string'),
    type: _emberData['default'].attr('string'),
    uid: _emberData['default'].attr('string'),
    metrics: _emberData['default'].attr('array')
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-flow-activity', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    cluster: _emberData['default'].attr('string'),
    flowName: _emberData['default'].attr('string'),
    lastExecDate: _emberData['default'].attr('string'),
    user: _emberData['default'].attr('string'),
    flowruns: _emberData['default'].attr('string'),
    uid: _emberData['default'].attr('string')
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-flowrun-brief', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].Model.extend({
    flowName: _emberData['default'].attr('string'),
    runid: _emberData['default'].attr('string'),
    shownid: _emberData['default'].attr('string'),
    type: _emberData['default'].attr('string'),
    createTime: _emberData['default'].attr('string'),
    createTimeRaw: _emberData['default'].attr(),
    endTime: _emberData['default'].attr('string'),
    endTimeRaw: _emberData['default'].attr(),
    user: _emberData['default'].attr('string'),
    uid: _emberData['default'].attr('string'),
    cpuVCores: _emberData['default'].attr('number'),
    memoryUsed: _emberData['default'].attr('number'),

    runDurationTs: (function () {
      var duration = this.get('endTimeRaw') - this.get('createTimeRaw');
      if (duration <= 0) {
        duration = Date.now() - this.get('createTimeRaw');
      }
      return duration;
    }).property('createTimeRaw', 'endTimeRaw'),

    getElapsedTimeVizDataForBarChart: function getElapsedTimeVizDataForBarChart() {
      return {
        label: this.get('runid'),
        value: this.get('runDurationTs'),
        tooltip: this.get("shownid") + "<br>" + _yarnUiUtilsConverter['default'].msToElapsedTimeUnit(this.get('runDurationTs')),
        flowrunUid: this.get('uid'),
        createdTs: this.get('createTimeRaw')
      };
    },

    getCpuVCoresVizDataForBarChart: function getCpuVCoresVizDataForBarChart() {
      return {
        label: this.get('runid'),
        value: this.get('cpuVCores'),
        tooltip: this.get("shownid") + "<br>" + 'CPU VCores: ' + this.get('cpuVCores'),
        flowrunUid: this.get('uid'),
        createdTs: this.get('createTimeRaw')
      };
    },

    getMemoryVizDataForBarChart: function getMemoryVizDataForBarChart() {
      return {
        label: this.get('runid'),
        value: this.get('memoryUsed'),
        tooltip: this.get("shownid") + "<br>" + 'Memory Used: ' + _yarnUiUtilsConverter['default'].memoryBytesToMB(this.get('memoryUsed')),
        flowrunUid: this.get('uid'),
        createdTs: this.get('createTimeRaw')
      };
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-flowrun', ['exports', 'ember-data'], function (exports, _emberData) {

  // For now, similar to yarn-flowrun-brief, but may add more in future.

  exports['default'] = _emberData['default'].Model.extend({
    flowName: _emberData['default'].attr('string'),
    runid: _emberData['default'].attr('string'),
    shownid: _emberData['default'].attr('string'),
    type: _emberData['default'].attr('string'),
    createTime: _emberData['default'].attr('string'),
    endTime: _emberData['default'].attr('string'),
    user: _emberData['default'].attr('string'),
    metrics: _emberData['default'].attr('array')
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-jhs-container', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].Model.extend({
    containerLogInfo: _emberData['default'].attr('array'),
    logAggregationType: _emberData['default'].attr('string'),
    containerId: _emberData['default'].attr('string'),
    nodeId: _emberData['default'].attr('string')
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-jhs-log', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    fileName: _emberData['default'].attr('string', { defaultValue: '' }),
    fileSize: _emberData['default'].attr('string', { defaultValue: '' }),
    lastModifiedTime: _emberData['default'].attr('string', { defaultValue: '' }),
    containerId: _emberData['default'].attr('string', { defaultValue: '' }),
    nodeId: _emberData['default'].attr('string', { defaultValue: '' }),
    redirectedUrl: _emberData['default'].attr('string', { defaultValue: '' })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-jhs-redirect-log', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    fileName: _emberData['default'].attr('string', { defaultValue: '' }),
    fileSize: _emberData['default'].attr('string', { defaultValue: '' }),
    lastModifiedTime: _emberData['default'].attr('string', { defaultValue: '' }),
    containerId: _emberData['default'].attr('string', { defaultValue: '' }),
    nodeId: _emberData['default'].attr('string', { defaultValue: '' }),
    redirectedUrl: _emberData['default'].attr('string', { defaultValue: '' })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-log', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    fileName: _emberData['default'].attr('string', { defaultValue: '' }),
    fileSize: _emberData['default'].attr('string', { defaultValue: '' }),
    lastModifiedTime: _emberData['default'].attr('string', { defaultValue: '' }),
    containerId: _emberData['default'].attr('string', { defaultValue: '' }),
    nodeId: _emberData['default'].attr('string', { defaultValue: '' }),
    redirectedUrl: _emberData['default'].attr('string', { defaultValue: '' })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-metrics', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    metrics: _emberData['default'].attr()
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-nm-gpu', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    info: _emberData['default'].attr('object'),

    jsonString: (function () {
      return JSON.stringify(this.get("info"));
    }).property()
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-node-app', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    appId: _emberData['default'].attr('string'),
    state: _emberData['default'].attr('string'),
    user: _emberData['default'].attr('string'),
    containers: _emberData['default'].attr('array'),
    /**
     * Indicates no rows were retrieved from backend
     */
    isDummyApp: (function () {
      return this.get('id') === "dummy";
    }).property("id"),

    appStateStyle: (function () {
      var style = "default";
      var appState = this.get("state");
      if (appState === "RUNNING" || appState === "FINISHING_CONTAINERS_WAIT" || appState === "APPLICATION_RESOURCES_CLEANINGUP") {
        style = "primary";
      } else if (appState === "FINISHED") {
        style = "success";
      }
      return "label label-" + style;
    }).property("state")
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-node-container-log', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    logs: _emberData['default'].attr('string')
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-node-container', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    containerId: _emberData['default'].attr('string'),
    state: _emberData['default'].attr('string'),
    user: _emberData['default'].attr('string'),
    exitCode: _emberData['default'].attr('string'),
    diagnostics: _emberData['default'].attr('string'),
    totalMemoryNeeded: _emberData['default'].attr('number'),
    totalVCoresNeeded: _emberData['default'].attr('number'),
    containerLogFiles: _emberData['default'].attr('array'),

    /**
     * Indicates that there was no container retrieved from backend.
     */
    isDummyContainer: (function () {
      return this.get('id') === "dummy";
    }).property("id"),

    containerStateStyle: (function () {
      var style = "primary";
      var containerState = this.get('state');
      var containerExitCode = this.get('exitCode');
      if (containerState === "DONE") {
        if (parseInt(containerExitCode) === 0) {
          style = "success";
        } else if (containerExitCode !== "N/A") {
          style = "danger";
        }
      }
      if (containerState === "EXITED_WITH_SUCCESS") {
        style = "success";
      }
      if (containerState === "EXITED_WITH_FAILURE") {
        style = "danger";
      }
      return "label label-" + style;
    }).property("state", "exitCode")
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-node', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    totalVmemAllocatedContainersMB: _emberData['default'].attr('number'),
    totalPmemAllocatedContainersMB: _emberData['default'].attr('number'),
    totalVCoresAllocatedContainers: _emberData['default'].attr('number'),
    vmemCheckEnabled: _emberData['default'].attr('boolean'),
    pmemCheckEnabled: _emberData['default'].attr('boolean'),
    nodeHealthy: _emberData['default'].attr('boolean'),
    lastNodeUpdateTime: _emberData['default'].attr('string'),
    healthReport: _emberData['default'].attr('string'),
    nmStartupTime: _emberData['default'].attr('string'),
    nodeManagerBuildVersion: _emberData['default'].attr('string'),
    hadoopBuildVersion: _emberData['default'].attr('string')
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-queue/capacity-queue', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].Model.extend({
    name: _emberData['default'].attr("string"),
    queuePath: _emberData['default'].attr("string"),
    children: _emberData['default'].attr("array"),
    parent: _emberData['default'].attr("string"),
    capacity: _emberData['default'].attr("number"),
    partitions: _emberData['default'].attr("array"),
    partitionMap: _emberData['default'].attr("object"),
    resourceUsagesByPartitionMap: _emberData['default'].attr("object"),
    maxCapacity: _emberData['default'].attr("number"),
    usedCapacity: _emberData['default'].attr("number"),
    absCapacity: _emberData['default'].attr("number"),
    absMaxCapacity: _emberData['default'].attr("number"),
    absUsedCapacity: _emberData['default'].attr("number"),
    weight: _emberData['default'].attr("number"),
    normalizedWeight: _emberData['default'].attr("number"),
    creationMethod: _emberData['default'].attr("string"),
    orderingPolicyInfo: _emberData['default'].attr("string"),
    state: _emberData['default'].attr("string"),
    userLimit: _emberData['default'].attr("number"),
    userLimitFactor: _emberData['default'].attr("number"),
    preemptionDisabled: _emberData['default'].attr("string"),
    intraQueuePreemptionDisabled: _emberData['default'].attr("string"),
    defaultPriority: _emberData['default'].attr("number"),
    numPendingApplications: _emberData['default'].attr("number"),
    numActiveApplications: _emberData['default'].attr("number"),
    numContainers: _emberData['default'].attr("number"),
    maxApplications: _emberData['default'].attr("number"),
    maxApplicationsPerUser: _emberData['default'].attr("number"),
    nodeLabels: _emberData['default'].attr("string"),
    defaultNodeLabelExpression: _emberData['default'].attr("string"),
    users: _emberData['default'].hasMany("YarnUser"),
    type: _emberData['default'].attr("string"),
    resources: _emberData['default'].attr("object"),

    isLeafQueue: (function () {
      var len = this.get("children.length");
      if (!len) {
        return true;
      }
      return len <= 0;
    }).property("children"),

    isWeightMode: (function () {
      return this.get("weight") !== -1;
    }).property("children"),

    isFlexibleDynamicQueue: (function () {
      return this.get("creationMethod") === "dynamicFlexible";
    }).property("children"),

    capacitiesBarChartData: (function () {
      var floatToFixed = _yarnUiUtilsConverter['default'].floatToFixed;
      return [{
        label: "Absolute Used",
        style: "primary",
        value: this.get("name") === "root" ? floatToFixed(this.get("usedCapacity")) : floatToFixed(this.get("absUsedCapacity"))
      }, {
        label: "Absolute Capacity",
        style: "primary",
        value: this.get("name") === "root" ? 100 : floatToFixed(this.get("absCapacity"))
      }, {
        label: "Absolute Max Capacity",
        style: "secondary",
        value: this.get("name") === "root" ? 100 : floatToFixed(this.get("absMaxCapacity"))
      }];
    }).property("absCapacity", "usedCapacity", "absMaxCapacity"),
    userUsagesDonutChartData: (function () {
      var data = [];
      if (this.get("users")) {
        this.get("users").forEach(function (o) {
          data.push({
            label: o.get("name"),
            value: o.get("usedMemoryMB")
          });
        });
      }

      return data;
    }).property("users"),

    hasUserUsages: (function () {
      return this.get("userUsagesDonutChartData").length > 0;
    }).property("userUsagesDonutChartData"),

    numOfApplicationsDonutChartData: (function () {
      return [{
        label: "Pending Apps",
        value: this.get("numPendingApplications") || 0 // TODO, fix the REST API so root will return #applications as well.
      }, {
        label: "Active Apps",
        value: this.get("numActiveApplications") || 0
      }];
    }).property("numPendingApplications", "numActiveApplications")
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-queue/fair-queue', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].Model.extend({
    name: _emberData['default'].attr('string'),
    children: _emberData['default'].attr('array'),
    parent: _emberData['default'].attr('string'),
    maxApps: _emberData['default'].attr('number'),
    minResources: _emberData['default'].attr(),
    maxResources: _emberData['default'].attr(),
    usedResources: _emberData['default'].attr(),
    demandResources: _emberData['default'].attr(),
    steadyFairResources: _emberData['default'].attr(),
    fairResources: _emberData['default'].attr(),
    clusterResources: _emberData['default'].attr(),
    pendingContainers: _emberData['default'].attr('number'),
    allocatedContainers: _emberData['default'].attr('number'),
    reservedContainers: _emberData['default'].attr('number'),
    schedulingPolicy: _emberData['default'].attr('string'),
    preemptable: _emberData['default'].attr('number'),
    numPendingApplications: _emberData['default'].attr('number'),
    numActiveApplications: _emberData['default'].attr('number'),
    type: _emberData['default'].attr('string'),

    isLeafQueue: (function () {
      var len = this.get("children.length");
      if (!len) {
        return true;
      }
      return len <= 0;
    }).property("children"),

    capacitiesBarChartData: (function () {
      var floatToFixed = _yarnUiUtilsConverter['default'].floatToFixed;
      return [{
        label: "Steady Fair Memory",
        value: floatToFixed(this.get("steadyFairResources.memory"))
      }, {
        label: "Used Memory",
        value: floatToFixed(this.get("usedResources.memory"))
      }, {
        label: "Maximum Memory",
        value: floatToFixed(this.get("maxResources.memory"))
      }];
    }).property("maxResources.memory", "usedResources.memory", "maxResources.memory"),

    numOfApplicationsDonutChartData: (function () {
      return [{
        label: "Pending Apps",
        value: this.get("numPendingApplications") || 0 // TODO, fix the REST API so root will return #applications as well.
      }, {
        label: "Active Apps",
        value: this.get("numActiveApplications") || 0
      }];
    }).property()
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-queue/fifo-queue', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].Model.extend({
    name: _emberData['default'].attr('string'),
    capacity: _emberData['default'].attr('number'),
    usedCapacity: _emberData['default'].attr('number'),
    state: _emberData['default'].attr('string'),
    minQueueMemoryCapacity: _emberData['default'].attr('number'),
    maxQueueMemoryCapacity: _emberData['default'].attr('number'),
    numNodes: _emberData['default'].attr('number'),
    usedNodeCapacity: _emberData['default'].attr('number'),
    availNodeCapacity: _emberData['default'].attr('number'),
    totalNodeCapacity: _emberData['default'].attr('number'),
    numContainers: _emberData['default'].attr('number'),
    type: _emberData['default'].attr('string'),

    capacitiesBarChartData: (function () {
      var floatToFixed = _yarnUiUtilsConverter['default'].floatToFixed;
      return [{
        label: "Available Capacity",
        value: floatToFixed(this.get("availNodeCapacity"))
      }, {
        label: "Used Capacity",
        value: floatToFixed(this.get("usedNodeCapacity"))
      }, {
        label: "Total Capacity",
        value: floatToFixed(this.get("totalNodeCapacity"))
      }];
    }).property("availNodeCapacity", "usedNodeCapacity", "totalNodeCapacity")

  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-queue/yarn-queue', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    type: _emberData['default'].attr('string')
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-redirect-log', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    fileName: _emberData['default'].attr('string', { defaultValue: '' }),
    fileSize: _emberData['default'].attr('string', { defaultValue: '' }),
    lastModifiedTime: _emberData['default'].attr('string', { defaultValue: '' }),
    containerId: _emberData['default'].attr('string', { defaultValue: '' }),
    nodeId: _emberData['default'].attr('string', { defaultValue: '' }),
    redirectedUrl: _emberData['default'].attr('string', { defaultValue: '' })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-rm-log', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    logFileName: _emberData['default'].attr(),
    logFileUrl: _emberData['default'].attr()
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-rm-node', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    rack: _emberData['default'].attr('string'),
    state: _emberData['default'].attr('string'),
    nodeHostName: _emberData['default'].attr('string'),
    nodeHTTPAddress: _emberData['default'].attr('string'),
    lastHealthUpdate: _emberData['default'].attr('string'),
    healthReport: _emberData['default'].attr('string'),
    numContainers: _emberData['default'].attr('number'),
    usedMemoryMB: _emberData['default'].attr('number'),
    availMemoryMB: _emberData['default'].attr('number'),
    usedVirtualCores: _emberData['default'].attr('number'),
    availableVirtualCores: _emberData['default'].attr('number'),
    version: _emberData['default'].attr('string'),
    nodeLabels: _emberData['default'].attr('array'),
    availableResource: _emberData['default'].attr('object'),
    usedResource: _emberData['default'].attr('object'),

    nodeLabelsAsString: (function () {
      var labels = this.get("nodeLabels");
      var labelToReturn = "default";
      // Only one label per node supported.
      if (labels && labels.length > 0) {
        labelToReturn = labels[0];
      }
      return labelToReturn;
    }).property("nodeLabels"),

    /**
     * Indicates no rows were retrieved from backend
     */
    isDummyNode: (function () {
      return this.get('id') === "dummy";
    }).property("id"),

    nodeStateStyle: (function () {
      var style = "default";
      var nodeState = this.get("state");
      if (nodeState === "REBOOTED" || nodeState === "DECOMMISSIONING") {
        style = "warning";
      } else if (nodeState === "UNHEALTHY" || nodeState === "DECOMMISSIONED" || nodeState === "LOST" || nodeState === "SHUTDOWN") {
        style = "danger";
      } else if (nodeState === "RUNNING") {
        style = "success";
      }
      return "label label-" + style;
    }).property("state"),

    getMemoryDataForDonutChart: (function () {
      var arr = [];
      arr.push({
        label: "Used",
        value: this.get("usedMemoryMB")
      });
      arr.push({
        label: "Available",
        value: this.get("availMemoryMB")
      });
      return arr;
    }).property("availMemoryMB", "usedMemoryMB"),

    getVCoreDataForDonutChart: (function () {
      var arr = [];
      arr.push({
        label: "Used",
        value: this.get("usedVirtualCores")
      });
      arr.push({
        label: "Available",
        value: this.get("availableVirtualCores")
      });
      return arr;
    }).property("availableVirtualCores", "usedVirtualCores"),

    getGpuDataForDonutChart: (function () {
      var arr = [];
      var used = 0;
      var ri;

      var usedResource = this.get("usedResource");
      var availableResource = this.get("availableResource");
      var resourceInformations = usedResource ? usedResource.resourceInformations.resourceInformation : [];
      for (var i = 0; i < resourceInformations.length; i++) {
        ri = resourceInformations[i];
        if (ri.name === "yarn.io/gpu") {
          used = ri.value;
        }
      }

      var available = 0;
      resourceInformations = availableResource ? availableResource.resourceInformations.resourceInformation : [];
      for (i = 0; i < resourceInformations.length; i++) {
        ri = resourceInformations[i];
        if (ri.name === "yarn.io/gpu") {
          available = ri.value;
        }
      }

      arr.push({
        label: "Used",
        value: used
      });
      arr.push({
        label: "Available",
        value: available
      });
      return arr;
    }).property("availableResource", "usedResource"),

    toolTipText: (function () {
      return "<p>Rack: " + this.get("rack") + '</p>' + "<p>Host: " + this.get("nodeHostName") + '</p>';
    }).property(),

    usedMemoryBytes: (function () {
      return this.get("usedMemoryMB") * 1024 * 1024;
    }).property("usedMemoryMB"),

    availMemoryBytes: (function () {
      return this.get("availMemoryMB") * 1024 * 1024;
    }).property("availMemoryMB")
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-service-component', ['exports', 'ember-data', 'ember', 'yarn-ui/utils/converter'], function (exports, _emberData, _ember, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].Model.extend({
    name: _emberData['default'].attr('string'),
    vcores: _emberData['default'].attr('string'),
    memory: _emberData['default'].attr('string'),
    priority: _emberData['default'].attr('string'),
    instances: _emberData['default'].attr('string'),
    createdTimestamp: _emberData['default'].attr('number'),

    configs: _emberData['default'].attr({ defaultValue: function defaultValue() {
        return _ember['default'].A();
      } }),

    metrics: _emberData['default'].attr({ defaultValue: function defaultValue() {
        return _ember['default'].Object.create();
      } }),

    createdDate: _ember['default'].computed('createdTimestamp', function () {
      var timestamp = this.get('createdTimestamp');
      if (timestamp > 0) {
        return _yarnUiUtilsConverter['default'].timeStampToDate(timestamp);
      }
      return 'N/A';
    })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-service-info', ['exports', 'ember-data', 'ember', 'yarn-ui/utils/converter'], function (exports, _emberData, _ember, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].Model.extend({
    name: _emberData['default'].attr('string'),
    appId: _emberData['default'].attr('string'),
    state: _emberData['default'].attr('string'),
    createdTimestamp: _emberData['default'].attr('number'),
    launchTimestamp: _emberData['default'].attr('number'),

    quicklinks: _emberData['default'].attr({ defaultValue: function defaultValue() {
        return _ember['default'].A();
      } }),

    configs: _emberData['default'].attr({ defaultValue: function defaultValue() {
        return _ember['default'].A();
      } }),

    metrics: _emberData['default'].attr({ defaultValue: function defaultValue() {
        return _ember['default'].Object.create();
      } }),

    createdDate: _ember['default'].computed('createdTimestamp', function () {
      var timestamp = this.get('createdTimestamp');
      if (timestamp > 0) {
        return _yarnUiUtilsConverter['default'].timeStampToDate(timestamp);
      }
      return 'N/A';
    }),

    launchDate: _ember['default'].computed('launchTimestamp', function () {
      var timestamp = this.get('launchTimestamp');
      if (timestamp > 0) {
        return _yarnUiUtilsConverter['default'].timeStampToDate(timestamp);
      }
      return 'N/A';
    })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-service', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    appId: _emberData['default'].attr('string'),
    name: _emberData['default'].attr('string'),
    state: _emberData['default'].attr('string'),
    version: _emberData['default'].attr('string'),
    lifetime: _emberData['default'].attr('string'),
    components: _emberData['default'].attr(),
    configuration: _emberData['default'].attr(),
    quicklinks: _emberData['default'].attr()
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-servicedef', ['exports', 'ember-data', 'ember'], function (exports, _emberData, _ember) {
  exports['default'] = _emberData['default'].Model.extend({
    name: _emberData['default'].attr('string', { defaultValue: '' }),
    queue: _emberData['default'].attr('string', { defaultValue: '' }),
    version: _emberData['default'].attr('string', { defaultValue: '' }),
    lifetime: _emberData['default'].attr('string', { defaultValue: '' }),
    isCached: _emberData['default'].attr('boolean', { defaultValue: false }),

    serviceComponents: _emberData['default'].attr({ defaultValue: function defaultValue() {
        return _ember['default'].A();
      } }),

    serviceConfigs: _emberData['default'].attr({ defaultValue: function defaultValue() {
        return _ember['default'].A();
      } }),

    fileConfigs: _emberData['default'].attr({ defaultValue: function defaultValue() {
        return _ember['default'].A();
      } }),

    quicklinks: _emberData['default'].attr({ defaultValue: function defaultValue() {
        return {};
      } }),

    clear: function clear() {
      this.set('name', '');
      this.set('queue', '');
      this.set('version', '');
      this.set('lifetime', '');
      this.get('serviceComponents').clear();
      this.get('serviceConfigs').clear();
      this.get('fileConfigs').clear();
      this.set('quicklinks', {});
    },

    isValidServiceDef: function isValidServiceDef() {
      return this.get('name') !== '' && this.get('queue') !== '' && this.get('version') !== '' && this.get('serviceComponents.length') > 0;
    },

    createNewServiceComponent: function createNewServiceComponent() {
      return _ember['default'].Object.create({
        name: '',
        numOfContainers: '',
        cpus: '',
        memory: '',
        artifactId: '',
        artifactType: 'DOCKER',
        launchCommand: '',
        dependencies: [],
        configuration: null
      });
    },

    createNewServiceConfig: function createNewServiceConfig(name, value) {
      var Config = _ember['default'].Object.extend({
        name: name || '',
        value: value || '',
        type: 'property', // property OR env OR quicklink
        scope: 'service', // service OR component
        componentName: '',
        capitalizedType: _ember['default'].computed('type', function () {
          return _ember['default'].String.capitalize(this.get('type'));
        }),
        formattedScope: _ember['default'].computed('scope', 'componentName', function () {
          if (this.get('scope') !== 'service') {
            return this.get('componentName') + ' [Component]';
          }
          return _ember['default'].String.capitalize(this.get('scope'));
        })
      });
      return Config.create();
    },

    createNewFileConfig: function createNewFileConfig(src, dest) {
      var FileConfig = _ember['default'].Object.extend({
        type: 'TEMPLATE', // HADOOP_XML OR TEMPLATE
        srcFile: src || '',
        destFile: dest || '',
        scope: 'service', // service OR component
        componentName: '',
        props: null,
        formattedScope: _ember['default'].computed('scope', 'componentName', function () {
          if (this.get('scope') !== 'service') {
            return this.get('componentName') + ' [Component]';
          }
          return _ember['default'].String.capitalize(this.get('scope'));
        })
      });
      return FileConfig.create();
    },

    getServiceJSON: function getServiceJSON() {
      return this.serializeServiceDef();
    },

    serializeServiceDef: function serializeServiceDef() {
      var json = {
        name: "",
        queue: "",
        version: "",
        lifetime: "-1",
        components: [],
        configuration: {
          properties: {},
          env: {},
          files: []
        },
        quicklinks: {}
      };

      var components = this.get('serviceComponents');
      var configs = this.get('serviceConfigs');
      var fileConfigs = this.get('fileConfigs');

      json['name'] = this.get('name');
      json['queue'] = this.get('queue');
      json['version'] = this.get('version');

      if (this.get('lifetime')) {
        json['lifetime'] = this.get('lifetime');
      }

      components.forEach((function (component) {
        json.components.push(this.serializeComponent(component));
      }).bind(this));

      configs.forEach((function (config) {
        var conf = this.serializeConfiguration(config);
        if (conf.scope === "service") {
          if (conf.type === "property") {
            json.configuration.properties[conf.name] = conf.value;
          } else if (conf.type === "env") {
            json.configuration.env[conf.name] = conf.value;
          } else if (conf.type === "quicklink") {
            json.quicklinks[conf.name] = conf.value;
          }
        } else if (conf.scope === "component") {
          var requiredCmp = json.components.findBy('name', conf.componentName);
          if (requiredCmp) {
            requiredCmp.configuration = requiredCmp.configuration || {};
            requiredCmp.configuration.properties = requiredCmp.configuration.properties || {};
            requiredCmp.configuration.env = requiredCmp.configuration.env || {};
            if (conf.type === "property") {
              requiredCmp.configuration.properties[conf.name] = conf.value;
            } else if (conf.type === "env") {
              requiredCmp.configuration.env[conf.name] = conf.value;
            }
          }
        }
      }).bind(this));

      fileConfigs.forEach((function (file) {
        var scope = file.get('scope');
        if (scope === "service") {
          json.configuration.files.push(this.serializeFileConfig(file));
        } else if (scope === "component") {
          var requiredCmp = json.components.findBy('name', file.get('componentName'));
          if (requiredCmp) {
            requiredCmp.configuration = requiredCmp.configuration || {};
            requiredCmp.configuration.files = requiredCmp.configuration.files || [];
            requiredCmp.configuration.files.push(this.serializeFileConfig(file));
          }
        }
      }).bind(this));

      return json;
    },

    serializeComponent: function serializeComponent(record) {
      var json = {};
      json['name'] = record.get('name');
      json['number_of_containers'] = record.get('numOfContainers');
      json['launch_command'] = record.get('launchCommand');
      json['dependencies'] = [];
      if (!_ember['default'].isEmpty(record.get('artifactId'))) {
        json['artifact'] = {
          id: record.get('artifactId'),
          type: record.get('artifactType')
        };
      }
      json['resource'] = {
        cpus: record.get('cpus'),
        memory: record.get('memory')
      };
      if (record.get('configuration')) {
        json['configuration'] = record.get('configuration');
      }
      return json;
    },

    serializeConfiguration: function serializeConfiguration(config) {
      var json = {};
      json["type"] = config.get('type');
      json["scope"] = config.get('scope');
      json["componentName"] = config.get('componentName');
      json["name"] = config.get('name');
      json["value"] = config.get('value');
      return json;
    },

    serializeFileConfig: function serializeFileConfig(file) {
      var json = {};
      json["type"] = file.get('type');
      json["dest_file"] = file.get('destFile');
      json["src_file"] = file.get('srcFile');
      if (file.get('type') === "HADOOP_XML" && file.get('props')) {
        json["props"] = file.get('props');
      }
      return json;
    },

    createNewServiceDef: function createNewServiceDef() {
      return this.get('store').createRecord('yarn-servicedef', {
        id: 'yarn_servicedef_' + Date.now()
      });
    },

    convertJsonServiceConfigs: function convertJsonServiceConfigs(json) {
      var parsedJson = JSON.parse(json);
      if (parsedJson.properties) {
        for (var prop in parsedJson.properties) {
          if (parsedJson.properties.hasOwnProperty(prop)) {
            var newPropObj = this.createNewServiceConfig(prop, parsedJson.properties[prop]);
            this.get('serviceConfigs').addObject(newPropObj);
          }
        }
      }
      if (parsedJson.env) {
        for (var envprop in parsedJson.env) {
          if (parsedJson.env.hasOwnProperty(envprop)) {
            var newEnvObj = this.createNewServiceConfig(envprop, parsedJson.env[envprop]);
            newEnvObj.set('type', 'env');
            this.get('serviceConfigs').addObject(newEnvObj);
          }
        }
      }
    },

    convertJsonFileConfigs: function convertJsonFileConfigs(json) {
      var parsedJson = JSON.parse(json);
      if (parsedJson.files) {
        parsedJson.files.forEach((function (file) {
          var newFileObj = this.createNewFileConfig(file.src_file, file.dest_file);
          this.get('fileConfigs').addObject(newFileObj);
        }).bind(this));
      }
    },

    cloneServiceDef: function cloneServiceDef() {
      var clone = this.createNewServiceDef();
      clone.set('name', this.get('name'));
      clone.set('queue', this.get('queue'));
      clone.set('version', this.get('version'));
      clone.set('lifetime', this.get('lifetime'));
      clone.get('serviceComponents', this.get('serviceComponents'));
      clone.get('serviceConfigs', this.get('serviceConfigs'));
      clone.get('fileConfigs', this.get('fileConfigs'));
      clone.set('quicklinks', this.get('quicklinks'));
      return clone;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-timeline-appattempt', ['exports', 'ember', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _ember, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].Model.extend({
    startTime: _emberData['default'].attr('string'),
    startedTime: _emberData['default'].attr('string'),
    finishedTime: _emberData['default'].attr('string'),
    containerId: _emberData['default'].attr('string'),
    amContainerId: _emberData['default'].attr('string'),
    nodeHttpAddress: _emberData['default'].attr('string'),
    nodeId: _emberData['default'].attr('string'),
    hosts: _emberData['default'].attr('string'),
    logsLink: _emberData['default'].attr('string'),
    state: _emberData['default'].attr('string'),
    appAttemptId: _emberData['default'].attr('string'),
    exposedPorts: _emberData['default'].attr('string'),

    appId: _ember['default'].computed("id", function () {
      var id = this.get("id");
      id = id.split("_");

      id[0] = "application";
      id.pop();

      return id.join("_");
    }),

    attemptStartedTime: (function () {
      var startTime = this.get("startTime");
      // If startTime variable is not present, get from startedTime
      if (startTime === undefined || startTime === "Invalid date") {
        startTime = this.get("startedTime");
      }

      return startTime;
    }).property("startedTime"),

    startTs: (function () {
      return _yarnUiUtilsConverter['default'].dateToTimeStamp(this.get('attemptStartedTime'));
    }).property("startTime"),

    finishedTs: (function () {
      var ts = _yarnUiUtilsConverter['default'].dateToTimeStamp(this.get("finishedTime"));
      return ts;
    }).property("finishedTime"),

    validatedFinishedTs: (function () {
      if (this.get("finishedTs") < this.get("startTs")) {
        return "";
      }
      return this.get("finishedTime");
    }).property("finishedTime"),

    shortAppAttemptId: (function () {
      if (!this.get("containerId")) {
        return this.get("id");
      }
      return "attempt_" + parseInt(_yarnUiUtilsConverter['default'].containerIdToAttemptId(this.get("containerId")).split("_")[3]);
    }).property("containerId"),

    appMasterContainerId: (function () {
      var id = this.get("containerId");
      // If containerId variable is not present, get from amContainerId
      if (id === undefined) {
        id = this.get("amContainerId");
      }
      return id;
    }).property("amContainerId"),

    IsAmNodeUrl: (function () {
      var url = this.get("nodeHttpAddress");
      // If nodeHttpAddress variable is not present, hardcode it.
      if (url === undefined) {
        url = "Not Available";
      }
      return url !== "Not Available";
    }).property("nodeHttpAddress"),

    amNodeId: (function () {
      var id = this.get("nodeId");
      // If nodeId variable is not present, get from host
      if (id === undefined) {
        id = this.get("hosts");
      }
      return id;
    }).property("nodeId"),

    IsLinkAvailable: (function () {
      var url = this.get("logsLink");
      // If logsLink variable is not present, hardcode its.
      if (url === undefined) {
        url = "Not Available";
      }
      return url !== "Not Available";
    }).property("logsLink"),

    elapsedTime: (function () {
      var elapsedMs = this.get("finishedTs") - this.get("startTs");
      if (elapsedMs <= 0) {
        elapsedMs = Date.now() - this.get("startTs");
      }
      return _yarnUiUtilsConverter['default'].msToElapsedTimeUnit(elapsedMs);
    }).property(),

    tooltipLabel: (function () {
      return "<p>Id:" + this.get("id") + "</p><p>ElapsedTime:" + String(this.get("elapsedTime")) + "</p>";
    }).property(),

    link: (function () {
      return "/yarn-app-attempt/" + this.get("id");
    }).property(),

    linkname: (function () {
      return "yarn-app-attempt";
    }).property(),

    attemptState: (function () {
      return this.get("state");
    }).property(),

    masterNodeURL: (function () {
      var addr = encodeURIComponent(this.get("nodeHttpAddress"));
      return '#/yarn-node/' + this.get("nodeId") + '/' + addr + '/info';
    }).property("nodeId", "nodeHttpAddress")
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-timeline-container', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].Model.extend({
    allocatedMB: _emberData['default'].attr('number'),
    allocatedVCores: _emberData['default'].attr('number'),
    assignedNodeId: _emberData['default'].attr('string'),
    priority: _emberData['default'].attr('number'),
    startedTime: _emberData['default'].attr('number'),
    finishedTime: _emberData['default'].attr('number'),
    logUrl: _emberData['default'].attr('string'),
    containerExitStatus: _emberData['default'].attr('number'),
    containerState: _emberData['default'].attr('string'),
    nodeHttpAddress: _emberData['default'].attr('string'),
    nodeId: _emberData['default'].attr('string'),
    diagnosticsInfo: _emberData['default'].attr('string'),
    exposedPorts: _emberData['default'].attr('string'),

    startTs: (function () {
      return _yarnUiUtilsConverter['default'].dateToTimeStamp(this.get("startedTime"));
    }).property("startedTime"),

    finishedTs: (function () {
      var ts = _yarnUiUtilsConverter['default'].dateToTimeStamp(this.get("finishedTime"));
      return ts;
    }).property("finishedTime"),

    validatedFinishedTs: (function () {
      if (this.get("finishedTs") < this.get("startTs")) {
        return "";
      }
      return this.get("finishedTime");
    }).property("finishedTime"),

    elapsedTime: (function () {
      var elapsedMs = this.get("finishedTs") - this.get("startTs");
      if (elapsedMs <= 0) {
        elapsedMs = Date.now() - this.get("startTs");
      }
      return _yarnUiUtilsConverter['default'].msToElapsedTimeUnit(elapsedMs);
    }).property(),

    tooltipLabel: (function () {
      return "<p>Id:" + this.get("id") + "</p><p>ElapsedTime:" + String(this.get("elapsedTime")) + "</p>";
    }).property(),

    masterNodeURL: (function () {
      var addr = encodeURIComponent(this.get("nodeHttpAddress"));
      return '#/yarn-node/' + this.get("nodeId") + '/' + addr + '/info';
    }).property("nodeId", "nodeHttpAddress"),

    appAttemptContainerLogsURL: (function () {
      var containerId = this.get("id");
      var attemptId = _yarnUiUtilsConverter['default'].containerIdToAttemptId(containerId);
      var appId = _yarnUiUtilsConverter['default'].attemptIdToAppId(attemptId);
      return '#/yarn-app/' + appId + '/logs?attempt=' + attemptId + '&containerid=' + containerId;
    }).property("id")
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/models/yarn-user', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].Model.extend({
    name: _emberData['default'].attr('string'),
    queueName: _emberData['default'].attr('string'),
    usedMemoryMB: _emberData['default'].attr('number'),
    usedVCore: _emberData['default'].attr('number'),
    maxMemoryMB: _emberData['default'].attr('number'),
    maxVCore: _emberData['default'].attr('number'),
    amUsedMemoryMB: _emberData['default'].attr('number'),
    amUsedVCore: _emberData['default'].attr('number'),
    maxAMMemoryMB: _emberData['default'].attr('number'),
    maxAMVCore: _emberData['default'].attr('number'),
    userWeight: _emberData['default'].attr('string'),
    activeApps: _emberData['default'].attr('number'),
    pendingApps: _emberData['default'].attr('number')
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/router', ['exports', 'ember', 'yarn-ui/config/environment'], function (exports, _ember, _yarnUiConfigEnvironment) {

  var Router = _ember['default'].Router.extend({
    location: _yarnUiConfigEnvironment['default'].locationType
  });

  Router.map(function () {
    this.route('yarn-apps', function () {
      this.route('apps');
    });
    this.route('yarn-services');
    this.route('yarn-nodes', function () {
      this.route('table');
      this.route('heatmap');
      this.route('status');
    });
    this.route('yarn-queue', { path: '/yarn-queue/:queue_name' }, function () {
      this.route('info');
      this.route('apps');
    });
    this.route('yarn-nodes-heatmap');
    this.route('yarn-node', { path: '/yarn-node/:node_id/:node_addr' }, function () {
      this.route("info");
      this.route("yarn-nm-gpu");
    });
    this.route('yarn-node-apps', { path: '/yarn-node-apps/:node_id/:node_addr' });
    this.route('yarn-node-app', { path: '/yarn-node-app/:node_id/:node_addr/:app_id' });
    this.route('yarn-node-containers', { path: '/yarn-node-containers/:node_id/:node_addr' });
    this.route('yarn-node-container', { path: '/yarn-node-container/:node_id/:node_addr/:container_id' });
    this.route('yarn-container-log', { path: '/yarn-container-log/:node_id/:node_addr/:container_id/:filename' });
    this.route('yarn-log-service', { path: '/yarn-log-service/cluster/:cluster_id/container/:container_id/user/:user_name/filename/:filename' });

    this.route('yarn-deploy-service');
    this.route('cluster-overview');
    this.route('yarn-app', { path: '/yarn-app/:app_id' }, function () {
      this.route('info');
      this.route('attempts');
      this.route('components');
      this.route('charts');
      this.route('configs');
      this.route('logs');
      this.route('threaddump');
    });
    this.route('yarn-component-instances', function () {
      this.route('info', { path: '/:component_name/info' });
      this.route('configs', { path: '/:component_name/configs' });
    });
    this.route('yarn-component-instance', function () {
      this.route('info', { path: '/:component_name/instances/:instance_name/info' });
    });
    this.route('yarn-app-attempt', { path: '/yarn-app-attempt/:app_attempt_id' });
    this.route('yarn-queues', { path: '/yarn-queues/:queue_name' });
    this.route('yarn-queue-apps', { path: '/yarn-queue-apps/:queue_name' });
    this.route('yarn-tools', function () {
      this.route('yarn-conf');
      this.route('yarn-metrics');
      this.route('yarn-rm-log');
    });

    this.route('yarn-flow-activity');
    this.route('yarn-flow', { path: '/yarn-flow/:flow_uid' }, function () {
      this.route('info');
      this.route('runs');
    });
    this.route('yarn-flowrun', { path: '/yarn-flowrun/:flowrun_uid' }, function () {
      this.route('info');
      this.route('metrics');
    });
    this.route('yarn-flowrun-metric', { path: '/yarn-flowrun-metric/:flowrun_uid/:metric_id' });
    this.route('timeline-error', { path: 'timeline-error/:error_id' });

    this.route('notauth');
    this.route('notfound');
    this.route('error', { path: '*:' });
  });

  exports['default'] = Router;
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/abstract', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Route.extend({
    unloadAll: function unloadAll() {
      // Must be implemented by inheriting classes
    },

    actions: {
      refresh: function refresh() {
        this.unloadAll();
        this.refresh();
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/application', ['exports', 'ember', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model() {
      var promises = {
        clusterInfo: this.store.findAll('ClusterInfo', { reload: true })['catch'](function () {
          return null;
        }),
        userInfo: this.store.findAll('cluster-user-info', { reload: true })['catch'](function () {
          return null;
        }),
        jhsHealth: this.store.queryRecord('jhs-health', {})['catch'](function () {
          return null;
        })
      };

      if (ENV.timelineServiceEnabled) {
        promises.timelineHealth = this.store.queryRecord('timeline-health', {})['catch'](function () {
          return null;
        });
      }
      return _ember['default'].RSVP.hash(promises);
    },

    actions: {
      /**
       * Base error handler for the application.
       * If specific routes do not handle the error, it will bubble up to
       * this handler. Here we redirect to either 404 page or a generic
       * error handler page.
       */
      error: function error(_error) {
        if (_error && _error.stack) {
          _ember['default'].Logger.log(_error.stack);
        }

        if (_error && _error.errors[0] && parseInt(_error.errors[0].status) === 404) {
          this.intermediateTransitionTo('/notfound');
        } else if (_error && _error.errors[0] && parseInt(_error.errors[0].status) === 401) {
          this.intermediateTransitionTo('/notauth');
        } else {
          this.intermediateTransitionTo('/error');
        }
      }
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('ClusterInfo');
      this.store.unloadAll('cluster-user-info');
      if (ENV.timelineServiceEnabled) {
        this.store.unloadAll('timeline-health');
      }
      this.store.unloadAll('jhs-health');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/cluster-overview', ['exports', 'ember', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model() {
      var _this = this;

      return _ember['default'].RSVP.hash({
        clusterMetrics: this.store.findAll('ClusterMetric', { reload: true }),
        apps: this.store.query('yarn-app', {
          state: "RUNNING"
        }),
        queues: this.store.query("yarn-queue.yarn-queue", {}).then(function (model) {
          var type = model.get('firstObject').get('type');
          return _this.store.query("yarn-queue." + type + "-queue", {});
        })
      });
    },

    afterModel: function afterModel() {
      this.controllerFor("ClusterOverview").set("loading", false);
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('ClusterMetric');
      this.store.unloadAll('yarn-app');
      this.store.unloadAll('yarn-queue.yarn-queue');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/index', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Route.extend({
    /**
     * Redirect root URL to cluster overview page.
     */
    beforeModel: function beforeModel() {
      this.replaceWith('cluster-overview');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/routes/timeline-error", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Route.extend({
    model: function model() {
      return {};
    },
    afterModel: function afterModel(model /*, transition*/) {
      model.error_id = "error";
      model.isValidErrorCode = false;
      if (model.errorCode && model.errorCode !== "0") {
        model.isValidErrorCode = true;
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-app-attempt', ['exports', 'ember', 'yarn-ui/routes/abstract', 'yarn-ui/mixins/app-attempt'], function (exports, _ember, _yarnUiRoutesAbstract, _yarnUiMixinsAppAttempt) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend(_yarnUiMixinsAppAttempt['default'], {
    model: function model(param) {
      return _ember['default'].RSVP.hash({
        attempt: this.fetchAttemptInfoFromRMorATS(param.app_attempt_id, this.store),
        rmContainers: this.store.query('yarn-container', {
          app_attempt_id: param.app_attempt_id
        })['catch'](function () {
          return _ember['default'].A();
        }),
        tsContainers: this.store.query('yarn-timeline-container', {
          app_attempt_id: param.app_attempt_id
        })['catch'](function () {
          return _ember['default'].A();
        })
      });
    },

    afterModel: function afterModel(model) {
      var appContrl = this.controllerFor('application');
      model.userInfo = appContrl.get('userInfo');
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-app-attempt');
      this.store.unloadAll('yarn-timeline-appattempt');
      this.store.unloadAll('yarn-container');
      this.store.unloadAll('yarn-timeline-container');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-app', ['exports', 'ember', 'yarn-ui/routes/abstract', 'yarn-ui/mixins/app-attempt'], function (exports, _ember, _yarnUiRoutesAbstract, _yarnUiMixinsAppAttempt) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend(_yarnUiMixinsAppAttempt['default'], {
    model: function model(param, transition) {
      var _this = this;

      var service = transition.queryParams.service;

      transition.send('updateBreadcrumbs', param.app_id, service);

      return _ember['default'].RSVP.hash({
        appId: param.app_id,
        serviceName: service,
        app: this.fetchAppInfoFromRMorATS(param.app_id, this.store),

        quicklinks: this.store.queryRecord('yarn-service-info', { appId: param.app_id }).then(function (info) {
          if (info && info.get('quicklinks')) {
            return info.get('quicklinks');
          }
          return [];
        }, function () {
          return [];
        }),

        serviceInfo: new _ember['default'].RSVP.Promise(function (resolve) {
          if (service) {
            _this.store.queryRecord('yarn-service', { serviceName: service }).then(function (info) {
              resolve(info);
            }, function () {
              resolve(null);
            });
          } else {
            resolve(null);
          }
        })
      });
    },
    actions: {
      updateBreadcrumbs: function updateBreadcrumbs(appId, serviceName, tailCrumbs) {
        var controller = this.controllerFor('yarn-app');
        controller.setProperties({ appId: appId, serviceName: serviceName });
        controller.updateBreadcrumbs(appId, serviceName, tailCrumbs);
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-app/attempts', ['exports', 'ember', 'yarn-ui/routes/abstract', 'yarn-ui/mixins/app-attempt'], function (exports, _ember, _yarnUiRoutesAbstract, _yarnUiMixinsAppAttempt) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend(_yarnUiMixinsAppAttempt['default'], {
    model: function model(param, transition) {
      var _paramsFor = this.paramsFor('yarn-app');

      var app_id = _paramsFor.app_id;
      var service = param.service;

      transition.send('updateBreadcrumbs', app_id, service, [{ text: 'Attempts' }]);
      return _ember['default'].RSVP.hash({
        appId: app_id,
        serviceName: service,
        attempts: this.fetchAttemptListFromRMorATS(app_id, this.store)['catch'](function () {
          return _ember['default'].A();
        })
      });
    },

    refresh: function refresh() {
      window.location.reload();
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-app-attempt');
      this.store.unloadAll('yarn-timeline-appattempt');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-app/charts', ['exports', 'ember', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model(param, transition) {
      var _paramsFor = this.paramsFor('yarn-app');

      var app_id = _paramsFor.app_id;
      var service = param.service;

      transition.send('updateBreadcrumbs', app_id, service, [{ text: "Charts" }]);
      return _ember['default'].RSVP.hash({
        appId: app_id,
        serviceName: service,

        app: this.store.find('yarn-app', app_id),

        rmContainers: this.store.find('yarn-app', app_id).then((function () {
          return this.store.query('yarn-app-attempt', { appId: app_id }).then((function (attempts) {
            if (attempts && attempts.get('firstObject')) {
              var appAttemptId = attempts.get('firstObject').get('appAttemptId');
              return this.store.query('yarn-container', {
                app_attempt_id: appAttemptId,
                is_rm: true
              });
            }
          }).bind(this));
        }).bind(this)),

        nodes: this.store.findAll('yarn-rm-node')
      });
    },

    refresh: function refresh() {
      window.location.reload();
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-app');
      this.store.unloadAll('yarn-app-attempt');
      this.store.unloadAll('yarn-container');
      this.store.unloadAll('yarn-rm-node');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-app/components', ['exports', 'ember', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model(param, transition) {
      var _paramsFor = this.paramsFor('yarn-app');

      var app_id = _paramsFor.app_id;
      var service = param.service;

      transition.send('updateBreadcrumbs', app_id, service, [{ text: 'Components' }]);
      return _ember['default'].RSVP.hash({
        appId: app_id,
        serviceName: service,
        components: this.store.query('yarn-service-component', { appId: app_id, type: 'COMPONENT' })['catch'](function () {
          return [];
        }),
        instances: this.store.query('yarn-component-instance', { appId: app_id })['catch'](function () {
          return [];
        })
      });
    },

    afterModel: function afterModel(model) {
      var instances = model.instances;
      model.components.forEach(function (component) {
        var num = instances.filterBy('component', component.get('name')).length;
        component.set('instances', num);
      });
    },

    refresh: function refresh() {
      window.location.reload();
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-service-component');
      this.store.unloadAll('yarn-component-instance');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-app/configs', ['exports', 'ember', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model(param, transition) {
      var _paramsFor = this.paramsFor('yarn-app');

      var app_id = _paramsFor.app_id;
      var service = param.service;

      transition.send('updateBreadcrumbs', app_id, service, [{ text: "Configurations & Metrics" }]);
      return _ember['default'].RSVP.hash({
        appId: app_id,
        serviceName: service,

        configs: this.store.queryRecord('yarn-service-info', { appId: app_id }).then(function (info) {
          if (info && info.get('configs')) {
            return info.get('configs');
          }
          return [];
        }, function () {
          return [];
        }),

        metrics: this.store.queryRecord('yarn-service-info', { appId: app_id }).then(function (info) {
          if (info && info.get('metrics')) {
            return info.get('metrics');
          }
          return null;
        }, function () {
          return null;
        })
      });
    },

    refresh: function refresh() {
      window.location.reload();
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-service-info');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-app/info', ['exports', 'ember', 'yarn-ui/routes/abstract', 'yarn-ui/mixins/app-attempt'], function (exports, _ember, _yarnUiRoutesAbstract, _yarnUiMixinsAppAttempt) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend(_yarnUiMixinsAppAttempt['default'], {
    model: function model(param, transition) {
      var _paramsFor = this.paramsFor('yarn-app');

      var app_id = _paramsFor.app_id;
      var service = param.service;

      transition.send('updateBreadcrumbs', app_id, service);

      return _ember['default'].RSVP.hash({
        appId: app_id,
        serviceName: service,
        app: this.fetchAppInfoFromRMorATS(app_id, this.store),

        quicklinks: this.store.queryRecord('yarn-service-info', { appId: app_id }).then(function (info) {
          if (info && info.get('quicklinks')) {
            return info.get('quicklinks');
          }
          return [];
        }, function () {
          return [];
        })
      });
    },

    refresh: function refresh() {
      window.location.reload();
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-app');
      this.store.unloadAll('yarn-app-timeline');
      this.store.unloadAll('yarn-service-info');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-app/logs', ['exports', 'ember', 'yarn-ui/routes/abstract', 'yarn-ui/mixins/app-attempt'], function (exports, _ember, _yarnUiRoutesAbstract, _yarnUiMixinsAppAttempt) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend(_yarnUiMixinsAppAttempt['default'], {
    model: function model(param, transition) {
      var _paramsFor = this.paramsFor('yarn-app');

      var app_id = _paramsFor.app_id;
      var service = param.service;

      transition.send('updateBreadcrumbs', app_id, service, [{ text: 'Logs' }]);
      var promises = {
        appId: app_id,
        serviceName: service,
        attempts: this.fetchAttemptListFromRMorATS(app_id, this.store)['catch'](function () {
          return [];
        }),
        app: this.fetchAppInfoFromRMorATS(app_id, this.store),
        jhsHealth: this.store.queryRecord('jhs-health', {})['catch'](function (error) {
          _ember['default'].Logger.log("jhs-health querying failed");
          _ember['default'].Logger.log(error);
          return null;
        })
      };

      if (ENV.timelineServiceEnabled) {
        promises.timelineHealth = this.store.queryRecord('timeline-health', {})['catch'](function () {
          return null;
        });
      }
      return _ember['default'].RSVP.hash(promises);
    },

    activate: function activate() {
      var controller = this.controllerFor("yarn-app.logs");

      var _paramsFor2 = this.paramsFor('yarn-app.logs');

      var attempt = _paramsFor2.attempt;
      var containerid = _paramsFor2.containerid;

      controller.resetAfterRefresh();
      controller.initializeSelect();
      if (attempt) {
        controller.send("showContainersForAttemptId", attempt, containerid);
      } else {
        controller.set("selectedAttemptId", "");
      }
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-app-attempt');
      this.store.unloadAll('yarn-timeline-appattempt');
      this.store.unloadAll('yarn-container');
      this.store.unloadAll('yarn-timeline-container');
      this.store.unloadAll('yarn-jhs-container');
      this.store.unloadAll('yarn-log');
      if (this.controller) {
        this.controller.resetAfterRefresh();
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-app/threaddump', ['exports', 'ember', 'yarn-ui/routes/abstract', 'yarn-ui/mixins/app-attempt'], function (exports, _ember, _yarnUiRoutesAbstract, _yarnUiMixinsAppAttempt) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend(_yarnUiMixinsAppAttempt['default'], {
    model: function model(param, transition) {
      var _paramsFor = this.paramsFor('yarn-app');

      var app_id = _paramsFor.app_id;
      var service = param.service;

      transition.send('updateBreadcrumbs', app_id, service, [{ text: 'Threaddump' }]);
      return _ember['default'].RSVP.hash({
        appId: app_id,
        serviceName: service,
        attempts: this.fetchAttemptListFromRM(app_id, this.store)['catch'](function (error) {
          _ember['default'].Logger.log("App attempt list fetch failed!");
          _ember['default'].Logger.log(error);
          return [];
        }),
        app: this.fetchAppInfoFromRM(app_id, this.store),
        userInfo: this.store.findAll('cluster-user-info', { reload: true })['catch'](function (error) {
          _ember['default'].Logger.log("userInfo querying failed");
          _ember['default'].Logger.log(error);
          return null;
        })
      });
    },

    activate: function activate() {
      var controller = this.controllerFor("yarn-app.threaddump");

      var _paramsFor2 = this.paramsFor('yarn-app.threaddump');

      var attempt = _paramsFor2.attempt;
      var containerid = _paramsFor2.containerid;

      controller.resetAfterRefresh();
      controller.initializeSelect();
      if (attempt) {
        controller.send("showContainersForAttemptId", attempt, containerid);
      } else {
        controller.set("selectedAttemptId", "");
      }
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-app-attempt');
      this.store.unloadAll('yarn-container');
      this.store.unloadAll('yarn-node-container-log');
      this.store.unloadAll('cluster-user-info');
      if (this.controller) {
        this.controller.resetAfterRefresh();
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-apps', ['exports', 'ember', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model() {
      return _ember['default'].RSVP.hash({
        clusterMetrics: this.store.findAll('ClusterMetric', { reload: true })
      });
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('ClusterMetric');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-apps/apps', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Route.extend({
    model: function model() {
      return _ember['default'].RSVP.hash({
        apps: this.store.findAll('yarn-app', { reload: true })
      });
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-app');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-component-instance', ['exports', 'yarn-ui/routes/abstract'], function (exports, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    actions: {
      updateBreadcrumbs: function updateBreadcrumbs(appId, serviceName, componentName, instanceName) {
        var controller = this.controllerFor('yarn-component-instance');
        controller.setProperties({ appId: appId, serviceName: serviceName, componentName: componentName, instanceName: instanceName });
        controller.updateBreadcrumbs(appId, serviceName, componentName, instanceName);
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-component-instance/info', ['exports', 'ember', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model(params, transition) {
      var instanceName = params.instance_name;
      transition.send('updateBreadcrumbs', params.appid, params.service, params.component_name, instanceName);
      return _ember['default'].RSVP.hash({
        appId: params.appid,
        serviceName: params.service,
        componentName: params.component_name,
        instanceName: instanceName,
        container: this.store.query('yarn-component-instance', { appId: params.appid }).then(function (instances) {
          if (instances && instances.findBy('containerId', params.containerid)) {
            return instances.findBy('containerId', params.containerid);
          }
          return null;
        }, function () {
          return null;
        })
      });
    },

    afterModel: function afterModel(model) {
      var appContrl = this.controllerFor('application');
      model.userInfo = appContrl.get('userInfo');
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-component-instance');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-component-instances', ['exports', 'yarn-ui/routes/abstract'], function (exports, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    actions: {
      updateBreadcrumbs: function updateBreadcrumbs(appId, serviceName, componentName, tailCrumbs) {
        var controller = this.controllerFor('yarn-component-instances');
        controller.setProperties({ appId: appId, componentName: componentName, serviceName: serviceName });
        controller.updateBreadcrumbs(appId, serviceName, componentName, tailCrumbs);
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-component-instances/configs', ['exports', 'ember', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model(params, transition) {
      var componentName = params.component_name;
      transition.send('updateBreadcrumbs', params.appid, params.service, componentName, [{ text: 'Configurations' }]);
      return _ember['default'].RSVP.hash({
        appId: params.appid,
        serviceName: params.service,
        componentName: componentName,
        configs: this.store.query('yarn-service-component', { appId: params.appid }).then(function (components) {
          if (components && components.findBy('name', componentName)) {
            return components.findBy('name', componentName).get('configs');
          }
          return [];
        }, function () {
          return [];
        })
      });
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-service-component');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-component-instances/info', ['exports', 'ember', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model(params, transition) {
      var componentName = params.component_name;
      transition.send('updateBreadcrumbs', params.appid, params.service, componentName);
      return _ember['default'].RSVP.hash({
        appId: params.appid,
        serviceName: params.service,
        componentName: componentName,
        instances: this.store.query('yarn-component-instance', { appId: params.appid }).then(function (instances) {
          if (instances && instances.filterBy('component', componentName)) {
            return instances.filterBy('component', componentName);
          }
          return [];
        }, function () {
          return [];
        }),
        metrics: this.store.query('yarn-service-component', { appId: params.appid }).then(function (components) {
          if (components && components.findBy('name', componentName)) {
            return components.findBy('name', componentName).get('metrics');
          }
          return null;
        }, function () {
          return null;
        })
      });
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-service-component');
      this.store.unloadAll('yarn-component-instance');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-container-log', ['exports', 'ember', 'yarn-ui/constants', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiConstants, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model(param) {
      var nodeAddress = decodeURIComponent(param.node_addr);
      nodeAddress = nodeAddress.replace(/(^\w+:|^)\/\//, '');
      var id = nodeAddress + _yarnUiConstants['default'].PARAM_SEPARATOR + param.container_id + _yarnUiConstants['default'].PARAM_SEPARATOR + param.filename;
      return _ember['default'].RSVP.hash({
        containerLog: this.store.findRecord('yarn-container-log', id),
        containerInfo: { id: param.container_id },
        nodeInfo: { id: param.node_id, addr: nodeAddress }
      }).then(function (hash) {
        // Just return as its success.
        return hash;
      }, function (reason) {
        if (reason.errors && reason.errors[0]) {
          // This means HTTP error response was sent by adapter.
          return reason;
        } else {
          // Assume empty response received from server.
          return { nodeInfo: { id: param.node_id, addr: nodeAddress },
            containerInfo: { id: param.container_id },
            containerLog: { logs: "", containerID: param.container_id,
              logFileName: param.filename } };
        }
      });
    },

    afterModel: function afterModel(model) {
      // Handle errors and redirect if promise is rejected.
      if (model.errors && model.errors[0]) {
        if (parseInt(model.errors[0].status) === 404) {
          this.replaceWith('/notfound');
        } else {
          this.replaceWith('/error');
        }
      }
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-container-log');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-deploy-service', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Route.extend({
    model: function model() {
      return this.store.createRecord('yarn-servicedef', {
        id: 'yarn_servicedef_' + Date.now()
      });
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-flow-activity', ['exports', 'yarn-ui/routes/abstract', 'yarn-ui/utils/error-utils'], function (exports, _yarnUiRoutesAbstract, _yarnUiUtilsErrorUtils) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model() {
      return this.store.findAll('yarn-flow-activity', { reload: true });
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-flow-activity');
    },

    actions: {
      error: function error(err /*, transition*/) {
        var errObj = _yarnUiUtilsErrorUtils['default'].stripErrorCodeAndMessageFromError(err);
        this.transitionTo('timeline-error', errObj);
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-flow', ['exports', 'ember', 'yarn-ui/routes/abstract', 'yarn-ui/utils/error-utils'], function (exports, _ember, _yarnUiRoutesAbstract, _yarnUiUtilsErrorUtils) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model(params) {
      return _ember['default'].RSVP.hash({
        flowRuns: this.store.query('yarn-flowrun-brief', { flowuid: params.flow_uid }),
        flowUid: params.flow_uid,
        lastFlowExecutionInfo: this.getLastFlowExecutionInfo(params.flow_uid)
      });
    },

    getLastFlowExecutionInfo: function getLastFlowExecutionInfo(flowUid) {
      var yarnfaCtrl = this.controllerFor('yarn-flow-activity');
      var recentFlow = yarnfaCtrl.getLastFlowExecutionInfoByFlowUid(flowUid);
      if (recentFlow) {
        return recentFlow;
      } else {
        return null;
      }
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-flowrun-brief');
    },

    actions: {
      error: function error(err /*, transition*/) {
        var errObj = _yarnUiUtilsErrorUtils['default'].stripErrorCodeAndMessageFromError(err);
        this.transitionTo('timeline-error', errObj);
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-flow/info', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Route.extend({});
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-flow/runs', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Route.extend({});
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-flowrun-metric', ['exports', 'ember', 'yarn-ui/utils/error-utils'], function (exports, _ember, _yarnUiUtilsErrorUtils) {
  exports['default'] = _ember['default'].Route.extend({
    model: function model(params) {
      var _this = this;
      var appsArr = [];
      var flowrun = _this.store.queryRecord('yarn-flowrun', { flowrun_uid: params.flowrun_uid,
        metricstoretrieve: params.metric_id }).then(function (value) {
        var apps = _this.store.query('yarn-app-flowrun', { flowrunUid: params.flowrun_uid,
          metricstoretrieve: params.metric_id }).then(function (value) {
          for (var i = 0; i < value.content.length; i++) {
            var tasks = undefined;
            // No need to fetch task or container info for Job counters.
            if (params.metric_id.indexOf("JobCounter") === -1) {
              var entityType = "MAPREDUCE_TASK";
              // CPU and MEMORY are container metrics.
              if (params.metric_id === "CPU" || params.metric_id === "MEMORY") {
                entityType = "YARN_CONTAINER";
              }
              tasks = _this.fetchTasksForEntity(value.content[i]._data.uid, params.metric_id, entityType);
            }
            appsArr.push(_ember['default'].RSVP.hash({ id: value.content[i].id, tasks: tasks, metrics: value.content[i]._data.metrics }));
          }
          return _ember['default'].RSVP.all(appsArr);
        });
        return _ember['default'].RSVP.hash({ run: value, id: value.id, metrics: value._internalModel._data.metrics, apps: apps });
      });
      return _ember['default'].RSVP.all([_ember['default'].RSVP.hash({ flowrun: flowrun, metricId: params.metric_id })]);
    },

    fetchTasksForEntity: function fetchTasksForEntity(appUid, metricId, entityType) {
      return this.store.query('yarn-entity', {
        app_uid: appUid,
        metricstoretrieve: metricId,
        entity_type: entityType,
        metricslimit: 100
      }).then(function (value) {
        var tasksArr = [];
        for (var j = 0; j < value.content.length; j++) {
          tasksArr.push(_ember['default'].RSVP.hash({ id: value.content[j].id, metrics: value.content[j]._data.metrics }));
        }
        return _ember['default'].RSVP.all(tasksArr);
      });
    },

    getMetricValue: function getMetricValue(metrics) {
      var metricValue = 0;
      if (metrics.length > 0) {
        for (var j in metrics[0].values) {
          metricValue = metrics[0].values[j];
          break;
        }
      }
      return metricValue.toString();
    },

    setupController: function setupController(controller, model) {
      var metricsArr = [];
      var flowRunId = model[0].flowrun.id;
      metricsArr.push([model[0].flowrun.id, this.getMetricValue(model[0].flowrun.metrics)]);
      for (var i = 0; i < model[0].flowrun.apps.length; i++) {
        var appId = flowRunId + '-' + model[0].flowrun.apps[i].id;
        metricsArr.push([appId, this.getMetricValue(model[0].flowrun.apps[i].metrics)]);
        if (model[0].flowrun.apps[i].tasks) {
          for (var j = 0; j < model[0].flowrun.apps[i].tasks.length; j++) {
            var taskId = appId + '-' + model[0].flowrun.apps[i].tasks[j].id;
            metricsArr.push([taskId, this.getMetricValue(model[0].flowrun.apps[i].tasks[j].metrics)]);
          }
        }
      }
      controller.set('flowrun', model[0].flowrun);
      controller.set('metric_id', model[0].metricId);
      controller.set('arr', metricsArr);
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-flowrun');
      this.store.unloadAll('yarn-app-flowrun');
      this.store.unloadAll('yarn-entity');
    },

    actions: {
      error: function error(err /*, transition*/) {
        var errObj = _yarnUiUtilsErrorUtils['default'].stripErrorCodeAndMessageFromError(err);
        this.transitionTo('timeline-error', errObj);
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-flowrun', ['exports', 'ember', 'yarn-ui/routes/abstract', 'yarn-ui/utils/error-utils'], function (exports, _ember, _yarnUiRoutesAbstract, _yarnUiUtilsErrorUtils) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model(params) {
      return _ember['default'].RSVP.hash({
        flowrun: this.store.findRecord('yarn-flowrun', params.flowrun_uid),
        apps: this.store.query('yarn-app-flowrun', { flowrunUid: params.flowrun_uid }),
        flowrun_uid: params.flowrun_uid,
        parentFlowUid: this.getParentFlowUid()
      });
    },

    getParentFlowUid: function getParentFlowUid() {
      var parentFlowModel = this.modelFor('yarn-flow');
      if (parentFlowModel) {
        return parentFlowModel.flowUid;
      } else {
        return '';
      }
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-flowrun');
      this.store.unloadAll('yarn-app-flowrun');
    },

    actions: {
      reload: function reload() {
        this.modelFor('apps').reload();
      },

      error: function error(err /*, transition*/) {
        var errObj = _yarnUiUtilsErrorUtils['default'].stripErrorCodeAndMessageFromError(err);
        this.transitionTo('timeline-error', errObj);
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-flowrun/info', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Route.extend({});
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-flowrun/metrics', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Route.extend({});
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-log-service', ['exports', 'ember', 'yarn-ui/constants', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiConstants, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model(param) {
      var id = param.container_id + _yarnUiConstants['default'].PARAM_SEPARATOR + param.filename + _yarnUiConstants['default'].PARAM_SEPARATOR + param.cluster_id;
      return _ember['default'].RSVP.hash({
        containerLog: this.store.findRecord('yarn-app-log', id),
        containerInfo: { id: param.container_id }
      }).then(function (hash) {
        // Just return as its success.
        return hash;
      }, function (reason) {
        if (reason.errors && reason.errors[0]) {
          // This means HTTP error response was sent by adapter.
          return reason;
        } else {
          // Assume empty response received from server.
          return {
            containerInfo: { id: param.container_id },
            containerLog: {
              logs: "",
              containerID: param.container_id,
              logFileName: param.filename
            }
          };
        }
      });
    },

    afterModel: function afterModel(model) {
      // Handle errors and redirect if promise is rejected.
      if (model.errors && model.errors[0]) {
        if (parseInt(model.errors[0].status) === 404) {
          this.replaceWith('/notfound');
        } else {
          this.replaceWith('/error');
        }
      }
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-app-log');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-node-app', ['exports', 'ember', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model(param) {
      var address = decodeURIComponent(param.node_addr);
      address = address.replace(/(^\w+:|^)\/\//, '');
      return _ember['default'].RSVP.hash({
        nodeApp: this.store.queryRecord('yarn-node-app', { nodeAddr: address, appId: param.app_id }),
        nmGpuInfo: this.store.findRecord('yarn-nm-gpu', address, { reload: true }),
        nodeInfo: { id: param.node_id, addr: address, appId: param.app_id }
      });
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-node-app');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-node-apps', ['exports', 'ember', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model(param) {
      // Get all apps running on a specific node. Node is contacted by using node_addr.
      var address = decodeURIComponent(param.node_addr);
      address = address.replace(/(^\w+:|^)\/\//, '');
      return _ember['default'].RSVP.hash({
        apps: this.store.query('yarn-node-app', { nodeAddr: address }),
        nmGpuInfo: this.store.findRecord('yarn-nm-gpu', address, { reload: true }),
        nodeInfo: { id: param.node_id, addr: address }
      });
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-node-app');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-node-container', ['exports', 'ember', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model(param) {
      var nodeAddress = decodeURIComponent(param.node_addr);
      nodeAddress = nodeAddress.replace(/(^\w+:|^)\/\//, '');
      // Get a specific container running on a specific node.
      return _ember['default'].RSVP.hash({
        nodeContainer: this.store.queryRecord('yarn-node-container', { nodeHttpAddr: nodeAddress, containerId: param.container_id }),
        nmGpuInfo: this.store.findRecord('yarn-nm-gpu', nodeAddress, { reload: true }),
        nodeInfo: { id: param.node_id, addr: nodeAddress, containerId: param.container_id }
      });
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-node-container');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-node-containers', ['exports', 'ember', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model(param) {
      // Get all containers running on specific node.
      var address = decodeURIComponent(param.node_addr);
      address = address.replace(/(^\w+:|^)\/\//, '');
      return _ember['default'].RSVP.hash({
        containers: this.store.query('yarn-node-container', { nodeHttpAddr: address }),
        nmGpuInfo: this.store.findRecord('yarn-nm-gpu', address, { reload: true }),
        nodeInfo: { id: param.node_id, addr: address }
      });
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-node-container');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-node', ['exports', 'ember', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model(param) {
      // Fetches data from both NM and RM. RM is queried to get node usage info.
      var address = decodeURIComponent(param.node_addr);
      address = address.replace(/(^\w+:|^)\/\//, '');
      return _ember['default'].RSVP.hash({
        nodeInfo: { id: param.node_id, addr: address },
        nmGpuInfo: this.store.findRecord('yarn-nm-gpu', address, { reload: true }),
        node: this.store.findRecord('yarn-node', address, { reload: true }),
        rmNode: this.store.findRecord('yarn-rm-node', param.node_id, { reload: true })
      });
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-node');
      this.store.unloadAll('yarn-rm-node');
      this.store.unloadAll('yarn-nm-gpu');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-node/yarn-nm-gpu', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Route.extend({});
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-nodes', ['exports', 'ember', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model() {
      return _ember['default'].RSVP.hash({
        nodes: this.store.findAll('yarn-rm-node', { reload: true }),
        clusterMetrics: this.store.findAll('ClusterMetric', { reload: true })
      });
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-rm-node');
      this.store.unloadAll('ClusterMetric');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-nodes/heatmap', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Route.extend({});
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-nodes/table', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Route.extend({});
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-queue', ['exports', 'ember', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model(param) {
      var _this = this;

      return _ember['default'].RSVP.hash({
        selected: param.queue_name,
        queues: this.store.query("yarn-queue.yarn-queue", {}).then(function (model) {
          var type = model.get('firstObject').get('type');
          return _this.store.query("yarn-queue." + type + "-queue", {});
        }),
        selectedQueue: undefined,
        apps: this.store.query('yarn-app', {
          queue: param.queue_name
        })
      });
    },

    afterModel: function afterModel(model) {
      var type = model.queues.get('firstObject').constructor.modelName;
      model.selectedQueue = this.store.peekRecord(type, model.selected);
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-queue.capacity-queue');
      this.store.unloadAll('yarn-queue.fair-queue');
      this.store.unloadAll('yarn-queue.fifo-queue');
      this.store.unloadAll('yarn-app');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-queue/apps', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Route.extend({});
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-queue/info', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Route.extend({});
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-queues', ['exports', 'ember', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model(param) {
      var _this = this;

      var queueName = param.queue_name ? param.queue_name.split('!')[0] : 'root';
      if (param.queue_name && param.queue_name.split('!').length > 1) {
        this.controllerFor('yarn-queues').set('showLoading', false);
      } else {
        this.controllerFor('yarn-queues').set('showLoading', true);
      }
      return _ember['default'].RSVP.hash({
        selected: queueName,
        queues: this.store.query("yarn-queue.yarn-queue", {}).then(function (model) {
          var type = model.get('firstObject').get('type');
          return _this.store.query("yarn-queue." + type + "-queue", {});
        }),
        selectedQueue: undefined
      });
    },

    afterModel: function afterModel(model) {
      var type = model.queues.get('firstObject').constructor.modelName;
      model.selectedQueue = this.store.peekRecord(type, model.selected);
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-queue.capacity-queue');
      this.store.unloadAll('yarn-queue.fair-queue');
      this.store.unloadAll('yarn-queue.fifo-queue');
      this.store.unloadAll('yarn-app');
    },

    refreshModel: function refreshModel() {
      var param = this.paramsFor('yarn-queues');
      var queueName = param.queue_name ? param.queue_name.split('!')[0] : 'root';
      if (queueName !== param.queue_name) {
        this.transitionTo('yarn-queues', queueName);
      } else {
        this.refresh();
      }
    },

    actions: {
      refresh: function refresh() {
        this.unloadAll();
        this.refreshModel();
      },

      loading: function loading() {
        if (!this.controllerFor('yarn-queues').get('showLoading')) {
          return false;
        }
        return true;
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-services', ['exports', 'ember', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model() {
      return _ember['default'].RSVP.hash({
        apps: this.store.query('yarn-app', {
          applicationTypes: "yarn-service"
        })
      });
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-app');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-tools', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Route.extend({});
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-tools/yarn-conf', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Route.extend({});
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-tools/yarn-metrics', ['exports', 'ember', 'yarn-ui/constants', 'yarn-ui/routes/abstract'], function (exports, _ember, _yarnUiConstants, _yarnUiRoutesAbstract) {
  exports['default'] = _yarnUiRoutesAbstract['default'].extend({
    model: function model() {
      return _ember['default'].RSVP.hash({ jmx: this.store.findAll('yarn-metrics') });
    },

    afterModel: function afterModel(model) {
      // Handle errors and redirect if promise is rejected.
      if (model.errors && model.errors[0]) {
        if (model.errors[0].status == 404) {
          this.replaceWith('/notfound');
        } else {
          this.replaceWith('/error');
        }
      }
    },

    unloadAll: function unloadAll() {
      this.store.unloadAll('yarn-metrics');
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/routes/yarn-tools/yarn-rm-log', ['exports', 'ember'], function (exports, _ember) {
  exports['default'] = _ember['default'].Route.extend({
    queryParams: {
      filename: {
        refreshModel: true
      }
    },

    model: function model(param) {
      if (param.filename == null) {
        return _ember['default'].RSVP.hash({ logs: this.store.findAll('yarn-rm-log') });
      } else {
        // TODO: Loading log file is disallowed for cross-origin requests that require preflight
        window.open(this.get('hosts.rmWebAddress') + param.filename);
      }
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/cluster-info', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id, requestType) {
      var fixedPayload = {
        id: id,
        type: primaryModelClass.modelName,
        attributes: payload
      };

      return this._super(store, primaryModelClass, fixedPayload, id, requestType);
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload, id, requestType) {
      // return expected is { data: [ {}, {} ] }
      var normalizedArrayResponse = {};

      // payload has apps : { app: [ {},{},{} ]  }
      // need some error handling for ex apps or app may not be defined.
      normalizedArrayResponse.data = [this.normalizeSingleResponse(store, primaryModelClass, payload.clusterInfo, payload.clusterInfo.id, requestType)];
      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/cluster-metric', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id, requestType) {
      var fixedPayload = {
        id: id,
        type: primaryModelClass.modelName,
        attributes: payload
      };

      return this._super(store, primaryModelClass, fixedPayload, id, requestType);
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload, id, requestType) {
      // return expected is { data: [ {}, {} ] }
      var normalizedArrayResponse = {};

      // payload has apps : { app: [ {},{},{} ]  }
      // need some error handling for ex apps or app may not be defined.
      normalizedArrayResponse.data = [this.normalizeSingleResponse(store, primaryModelClass, payload.clusterMetrics, 1, requestType)];
      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/cluster-user-info', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id, requestType) {
      var fixedPayload = {
        id: id,
        type: primaryModelClass.modelName,
        attributes: payload
      };

      return this._super(store, primaryModelClass, fixedPayload, id, requestType);
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload, id, requestType) {
      // return expected is { data: [ {}, {} ] }
      var normalizedArrayResponse = {};

      normalizedArrayResponse.data = [this.normalizeSingleResponse(store, primaryModelClass, payload, Date.now(), requestType)];
      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/jhs-health', ['exports', 'ember-data', 'ember'], function (exports, _emberData, _ember) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload) {
      var fixedPayload = {
        id: Date.now(),
        type: primaryModelClass.modelName,
        attributes: payload.historyInfo
      };

      return { data: fixedPayload };
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/timeline-health', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload) {
      var fixedPayload = {
        id: Date.now(),
        type: primaryModelClass.modelName,
        attributes: payload
      };

      return { data: fixedPayload };
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-app-attempt', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload) {

      if (payload.appAttempt) {
        payload = payload.appAttempt;
      }

      var fixedPayload = {
        id: payload.appAttemptId,
        type: primaryModelClass.modelName, // yarn-app
        attributes: {
          startTime: _yarnUiUtilsConverter['default'].timeStampToDate(payload.startTime),
          startedTime: _yarnUiUtilsConverter['default'].timeStampToDate(payload.startedTime),
          finishedTime: _yarnUiUtilsConverter['default'].timeStampToDate(payload.finishedTime),
          containerId: payload.containerId,
          amContainerId: payload.amContainerId,
          nodeHttpAddress: payload.nodeHttpAddress,
          exposedPorts: payload.exposedPorts,
          nodeId: payload.nodeId,
          hosts: payload.host,
          state: payload.appAttemptState,
          logsLink: payload.logsLink,
          appAttemptId: payload.appAttemptId,
          diagnosticsInfo: payload.diagnosticsInfo
        }
      };

      return fixedPayload;
    },

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var p = this.internalNormalizeSingleResponse(store, primaryModelClass, payload);
      return { data: p };
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var _this = this;

      // return expected is { data: [ {}, {} ] }
      var normalizedArrayResponse = {};

      if (payload.appAttempts && payload.appAttempts.appAttempt) {
        // payload has apps : { app: [ {},{},{} ]  }
        // need some error handling for ex apps or app may not be defined.
        normalizedArrayResponse.data = payload.appAttempts.appAttempt.map(function (singleApp) {
          return _this.internalNormalizeSingleResponse(store, primaryModelClass, singleApp);
        }, this);
      } else {
        normalizedArrayResponse.data = [];
      }
      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-app-flowrun', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id, requestType) {
      var events = payload.events,
          appFinishedEvent = events.findBy('id', 'YARN_APPLICATION_FINISHED'),
          finishedTs = appFinishedEvent ? appFinishedEvent.timestamp : Date.now(),
          appState = appFinishedEvent && appFinishedEvent.info ? appFinishedEvent.info.YARN_APPLICATION_STATE : "N/A",
          metrics = payload.metrics,
          cpuMetric = metrics.findBy('id', 'CPU'),
          memoryMetric = metrics.findBy('id', 'MEMORY'),
          cpu = cpuMetric ? cpuMetric.values[Object.keys(cpuMetric.values)[0]] : -1,
          memory = memoryMetric ? memoryMetric.values[Object.keys(memoryMetric.values)[0]] : -1;

      var fixedPayload = {
        id: id,
        type: primaryModelClass.modelName,
        attributes: {
          appId: payload.id,
          type: payload.info.YARN_APPLICATION_TYPE,
          uid: payload.info.UID,
          metrics: metrics,
          startedTs: payload.createdtime,
          finishedTs: finishedTs,
          state: payload.info.YARN_APPLICATION_STATE || appState,
          cpuVCores: cpu,
          memoryUsed: memory
        }
      };

      return this._super(store, primaryModelClass, fixedPayload, id, requestType);
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload, id, requestType) {
      var _this = this;

      var normalizedArrayResponse = {};

      normalizedArrayResponse.data = payload.map(function (singleApp) {
        return _this.normalizeSingleResponse(store, primaryModelClass, singleApp, singleApp.id, requestType);
      });

      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-app-jhs-log', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id /*, requestType*/) {
      // Convert plain text response into JSON.
      // ID is of the form containerId!fileName
      var splits = _yarnUiUtilsConverter['default'].splitForAppLogs(id);
      var convertedPayload = {
        id: id,
        type: primaryModelClass.modelName,
        attributes: {
          logs: payload.data,
          containerID: splits[0],
          logFileName: splits[1],
          redirectedUrl: payload.redirectedUrl
        }
      };
      return { data: convertedPayload };
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-app-jhs-redirect-log', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id /*, requestType*/) {
      var splits = _yarnUiUtilsConverter['default'].splitForAppLogs(id);
      var convertedPayload = {
        id: id,
        type: primaryModelClass.modelName,
        attributes: {
          logs: payload,
          containerID: splits[1],
          logFileName: splits[2]
        }
      };
      return { data: convertedPayload };
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-app-log', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id /*, requestType*/) {
      // Convert plain text response into JSON.
      // ID is of the form containerId!fileName
      var splits = _yarnUiUtilsConverter['default'].splitForAppLogs(id);
      var convertedPayload = {
        id: id,
        type: primaryModelClass.modelName,
        attributes: {
          logs: payload.data,
          containerID: splits[0],
          logFileName: splits[1],
          redirectedUrl: payload.redirectedUrl
        }
      };
      return { data: convertedPayload };
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-app-redirect-log', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id /*, requestType*/) {
      var splits = _yarnUiUtilsConverter['default'].splitForAppLogs(id);
      var convertedPayload = {
        id: id,
        type: primaryModelClass.modelName,
        attributes: {
          logs: payload,
          containerID: splits[1],
          logFileName: splits[2]
        }
      };
      return { data: convertedPayload };
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-app-timeline', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload, id) {

      var events = payload.events,
          appFinishedEvent = events.findBy('id', 'YARN_APPLICATION_FINISHED'),
          startedTime = payload.createdtime,
          finishedTime = appFinishedEvent ? appFinishedEvent.timestamp : Date.now(),
          elapsedTime = finishedTime - startedTime,
          diagnostics = payload.info.YARN_APPLICATION_DIAGNOSTICS_INFO,
          priority = payload.info.YARN_APPLICATION_PRIORITY;

      var fixedPayload = {
        id: id,
        type: primaryModelClass.modelName,
        attributes: {
          appName: payload.info.YARN_APPLICATION_NAME,
          user: payload.info.YARN_APPLICATION_USER,
          queue: "N/A",
          state: payload.info.YARN_APPLICATION_STATE,
          startTime: _yarnUiUtilsConverter['default'].timeStampToDate(startedTime),
          elapsedTime: elapsedTime,
          finishedTime: _yarnUiUtilsConverter['default'].timeStampToDate(finishedTime),
          finalStatus: payload.info.YARN_APPLICATION_FINAL_STATUS,
          progress: 100,
          applicationType: payload.info.YARN_APPLICATION_TYPE,
          diagnostics: diagnostics && diagnostics !== 'null' ? diagnostics : '',
          amHostHttpAddress: '',
          logAggregationStatus: '',
          unmanagedApplication: payload.info.YARN_APPLICATION_UNMANAGED_APPLICATION || 'N/A',
          amNodeLabelExpression: payload.configs.YARN_AM_NODE_LABEL_EXPRESSION,
          priority: priority !== undefined ? priority : 'N/A',
          allocatedMB: 0,
          allocatedVCores: 0,
          runningContainers: 0,
          memorySeconds: payload.info.YARN_APPLICATION_MEM_METRIC,
          vcoreSeconds: payload.info.YARN_APPLICATION_CPU_METRIC,
          preemptedResourceMB: 0,
          preemptedResourceVCores: 0,
          numNonAMContainerPreempted: 0,
          numAMContainerPreempted: 0,
          clusterUsagePercentage: 0,
          queueUsagePercentage: 0,
          currentAppAttemptId: payload.info.YARN_APPLICATION_LATEST_APP_ATTEMPT,
          trackingUI: '',
          trackingUrl: ''
        }
      };

      return fixedPayload;
    },

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id /*, requestType*/) {
      var p = this.internalNormalizeSingleResponse(store, primaryModelClass, payload, id);
      return { data: p };
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-app', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload, id) {
      if (payload.app) {
        payload = payload.app;
      }

      var timeoutInSecs = -1;
      var appExpiryTime = _yarnUiUtilsConverter['default'].timeStampToDate(payload.finishedTime);
      if (payload.timeouts && payload.timeouts.timeout && payload.timeouts.timeout[0]) {
        timeoutInSecs = payload.timeouts.timeout[0].remainingTimeInSeconds;
        if (timeoutInSecs > -1) {
          appExpiryTime = _yarnUiUtilsConverter['default'].isoDateToDate(payload.timeouts.timeout[0].expiryTime);
        }
      }

      var fixedPayload = {
        id: id,
        type: primaryModelClass.modelName, // yarn-app
        attributes: {
          appName: payload.name,
          user: payload.user,
          queue: payload.queue,
          state: payload.state,
          startTime: payload.startedTime, // will be formatted in yarn-app model
          elapsedTime: payload.elapsedTime,
          finishedTime: payload.finishedTime, // will be formatted in yarn-app model
          finalStatus: payload.finalStatus,
          progress: payload.progress,
          applicationType: payload.applicationType,
          applicationTags: payload.applicationTags && payload.applicationTags !== 'null' ? payload.applicationTags : 'N/A',
          diagnostics: payload.diagnostics && payload.diagnostics !== 'null' ? payload.diagnostics : '',
          amHostHttpAddress: payload.amHostHttpAddress,
          masterNodeId: payload.masterNodeId,
          logAggregationStatus: payload.logAggregationStatus,
          unmanagedApplication: payload.unmanagedApplication,
          amNodeLabelExpression: payload.amNodeLabelExpression,
          priority: payload.priority !== undefined ? payload.priority : 'N/A',
          allocatedMB: payload.allocatedMB,
          allocatedVCores: payload.allocatedVCores,
          runningContainers: payload.runningContainers,
          resourceRequests: payload.resourceRequests,
          memorySeconds: payload.memorySeconds,
          vcoreSeconds: payload.vcoreSeconds,
          preemptedResourceMB: payload.preemptedResourceMB,
          preemptedResourceVCores: payload.preemptedResourceVCores,
          numNonAMContainerPreempted: payload.numNonAMContainerPreempted,
          numAMContainerPreempted: payload.numAMContainerPreempted,
          clusterUsagePercentage: payload.clusterUsagePercentage,
          queueUsagePercentage: payload.queueUsagePercentage,
          currentAppAttemptId: payload.currentAppAttemptId,
          remainingTimeoutInSeconds: timeoutInSecs,
          applicationExpiryTime: appExpiryTime,
          trackingUI: payload.trackingUI,
          trackingUrl: payload.trackingUrl
        }
      };

      return fixedPayload;
    },

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id /*, requestType*/) {
      var p = this.internalNormalizeSingleResponse(store, primaryModelClass, payload, id);
      return { data: p };
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var _this = this;

      // return expected is { data: [ {}, {} ] }
      var normalizedArrayResponse = {};

      // payload has apps : { app: [ {},{},{} ]  }
      // need some error handling for ex apps or app may not be defined.
      if (payload.apps && payload.apps.app) {
        normalizedArrayResponse.data = payload.apps.app.map(function (singleApp) {
          return _this.internalNormalizeSingleResponse(store, primaryModelClass, singleApp, singleApp.id);
        }, this);
      } else {
        normalizedArrayResponse.data = [];
      }

      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-component-instance', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload) {
      var info = payload.info;

      var fixedPayload = {
        id: 'yarn_component_instance_' + payload.id,
        type: primaryModelClass.modelName,
        attributes: {
          containerId: payload.id,
          component: info.COMPONENT_NAME,
          instanceName: info.COMPONENT_INSTANCE_NAME,
          state: info.STATE,
          createdTimestamp: payload.createdtime,
          startedTimestamp: info.LAUNCH_TIME,
          host: info.HOSTNAME,
          node: info.BARE_HOST,
          ipAddr: info.IP,
          exposedPorts: info.EXPOSED_PORTS,
          exitStatusCode: info.EXIT_STATUS_CODE
        }
      };

      return fixedPayload;
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var normalizedResponse = { data: [] };
      var instanceUid = {};

      if (payload && Array.isArray(payload)) {
        this.sortPayloadByCreatedTimeAscending(payload);

        payload.forEach((function (container) {
          var componentName = container.info.COMPONENT_NAME;
          if (!instanceUid[componentName]) {
            instanceUid[componentName] = 0;
          }
          container.instanceId = ++instanceUid[componentName];
          var pl = this.internalNormalizeSingleResponse(store, primaryModelClass, container);
          normalizedResponse.data.push(pl);
        }).bind(this));
      }

      return normalizedResponse;
    },

    sortPayloadByCreatedTimeAscending: function sortPayloadByCreatedTimeAscending(payload) {
      payload.sort(function (inst1, inst2) {
        return inst1.createdtime - inst2.createdtime;
      });
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-conf', ['exports', 'ember', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _ember, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    normalizeResponse: function normalizeResponse(store, primaryModelClass, payload, id, requestType) {
      var x2js = new X2JS();
      var props = x2js.xml_str2json(payload);
      var properties = props.configuration.property;
      var convertedPayload = [];
      for (var i = 0; i < properties.length; i++) {
        var row = {
          id: i,
          type: primaryModelClass.modelName,
          attributes: {
            name: properties[i].name,
            source: properties[i].source,
            value: properties[i].value
          }
        };
        convertedPayload.push(row);
      }
      return { data: convertedPayload };
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-container-log', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id /*, requestType*/) {
      // Convert plain text response into JSON.
      // ID is of the form nodeAddress!containerId!fileName
      var splits = _yarnUiUtilsConverter['default'].splitForContainerLogs(id);
      var convertedPayload = {
        id: id,
        type: primaryModelClass.modelName,
        attributes: {
          logs: payload,
          containerID: splits[1],
          logFileName: splits[2]
        }
      };
      return { data: convertedPayload };
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-container', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload) {

      var fixedPayload = {
        id: payload.containerId,
        type: primaryModelClass.modelName, // yarn-app
        attributes: {
          allocatedMB: payload.allocatedMB,
          allocatedVCores: payload.allocatedVCores,
          assignedNodeId: payload.assignedNodeId,
          priority: payload.priority,
          startedTime: _yarnUiUtilsConverter['default'].timeStampToDate(payload.startedTime),
          finishedTime: _yarnUiUtilsConverter['default'].timeStampToDate(payload.finishedTime),
          elapsedTime: payload.elapsedTime,
          logUrl: payload.logUrl,
          containerExitStatus: payload.containerExitStatus + '',
          containerState: payload.containerState,
          nodeId: payload.nodeId,
          nodeHttpAddress: payload.nodeHttpAddress,
          exposedPorts: payload.exposedPorts
        }
      };

      return fixedPayload;
    },

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var p = this.internalNormalizeSingleResponse(store, primaryModelClass, payload);
      return { data: p };
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var _this = this;

      // return expected is { data: [ {}, {} ] }
      var normalizedArrayResponse = {};

      if (payload && payload.container) {
        if (Array.isArray(payload.container)) {
          // payload has apps : { app: [ {},{},{} ]  }
          // need some error handling for ex apps or app may not be defined.
          normalizedArrayResponse.data = payload.container.map(function (singleContainer) {
            return _this.internalNormalizeSingleResponse(store, primaryModelClass, singleContainer);
          }, this);
        } else {
          normalizedArrayResponse.data = [this.internalNormalizeSingleResponse(store, primaryModelClass, payload.container)];
        }
        return normalizedArrayResponse;
      } else {
        normalizedArrayResponse.data = [];
      }

      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-entity', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id, requestType) {
      var fixedPayload = {
        id: id,
        type: primaryModelClass.modelName, // yarn-entity
        attributes: {
          entityId: payload.id,
          type: payload.type,
          uid: payload.info.UID,
          metrics: payload.metrics
        }
      };

      return this._super(store, primaryModelClass, fixedPayload, id, requestType);
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload, id, requestType) {
      var _this = this;

      // return expected is { data: [ {}, {} ] }
      var normalizedArrayResponse = {};

      normalizedArrayResponse.data = payload.map(function (singleApp) {
        return _this.normalizeSingleResponse(store, primaryModelClass, singleApp, singleApp.id, requestType);
      }, this);
      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-flow-activity', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id, requestType) {
      var fixedPayload = {
        id: id,
        type: primaryModelClass.modelName, // yarn-timeline-flow
        attributes: {
          cluster: payload.info.SYSTEM_INFO_CLUSTER,
          flowName: payload.info.SYSTEM_INFO_FLOW_NAME,
          lastExecDate: _yarnUiUtilsConverter['default'].timeStampToDateOnly(payload.info.SYSTEM_INFO_DATE),
          user: payload.info.SYSTEM_INFO_USER,
          flowruns: payload.flowruns,
          uid: payload.info.UID
        }
      };

      return this._super(store, primaryModelClass, fixedPayload, id, requestType);
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload, id, requestType) {
      var _this = this;

      // return expected is { data: [ {}, {} ] }
      var normalizedArrayResponse = {};

      normalizedArrayResponse.data = payload.map(function (singleEntity) {
        return _this.normalizeSingleResponse(store, primaryModelClass, singleEntity, singleEntity.id, requestType);
      }, this);
      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-flowrun-brief', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id, requestType) {
      var metrics = payload.metrics,
          cpuMetric = metrics.findBy('id', 'CPU'),
          cpu = cpuMetric ? cpuMetric.values[Object.keys(cpuMetric.values)[0]] : -1,
          memMetric = metrics.findBy('id', 'MEMORY'),
          memory = memMetric ? memMetric.values[Object.keys(memMetric.values)[0]] : -1;

      var fixedPayload = {
        id: id,
        type: primaryModelClass.modelName, // yarn-flowrun-brief
        attributes: {
          flowName: payload.info.SYSTEM_INFO_FLOW_NAME,
          runid: payload.info.SYSTEM_INFO_FLOW_RUN_ID,
          shownid: payload.id,
          type: payload.type,
          createTime: this.checkDateValidity(payload.createdtime),
          createTimeRaw: payload.createdtime,
          endTime: this.checkDateValidity(payload.info.SYSTEM_INFO_FLOW_RUN_END_TIME),
          endTimeRaw: payload.info.SYSTEM_INFO_FLOW_RUN_END_TIME || 0,
          user: payload.info.SYSTEM_INFO_USER,
          uid: payload.info.UID,
          cpuVCores: cpu,
          memoryUsed: memory
        }
      };

      return this._super(store, primaryModelClass, fixedPayload, id, requestType);
    },

    checkDateValidity: function checkDateValidity(timestamp) {
      if (timestamp && timestamp > 0) {
        return _yarnUiUtilsConverter['default'].timeStampToDate(timestamp);
      }
      return 'N/A';
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload, id, requestType) {
      var _this = this;

      var normalizedArrayResponse = { data: [] };

      normalizedArrayResponse.data = payload.map(function (singleApp) {
        return _this.normalizeSingleResponse(store, primaryModelClass, singleApp, singleApp.id, requestType);
      });

      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-flowrun', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({

    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload, id) {
      var recordId = id;
      if (!recordId) {
        recordId = payload.id;
      }
      var fixedPayload = {
        id: recordId,
        type: primaryModelClass.modelName,
        attributes: {
          flowName: payload.info.SYSTEM_INFO_FLOW_NAME,
          runid: payload.info.SYSTEM_INFO_FLOW_RUN_ID,
          shownid: payload.id,
          type: payload.type,
          createTime: this.checkDateValidity(payload.createdtime),
          endTime: this.checkDateValidity(payload.info.SYSTEM_INFO_FLOW_RUN_END_TIME),
          user: payload.info.SYSTEM_INFO_USER,
          metrics: payload.metrics
        }
      };

      return fixedPayload;
    },

    checkDateValidity: function checkDateValidity(timestamp) {
      if (timestamp && timestamp > 0) {
        return _yarnUiUtilsConverter['default'].timeStampToDate(timestamp);
      }
      return 'N/A';
    },

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id /*, requestType*/) {
      var p = this.internalNormalizeSingleResponse(store, primaryModelClass, payload, id);
      return { data: p };
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var _this = this;

      // return expected is { data: [ {}, {} ] }
      var normalizedArrayResponse = {};

      normalizedArrayResponse.data = payload.map(function (singleApp) {
        return _this.internalNormalizeSingleResponse(store, primaryModelClass, singleApp, singleApp.id);
      }, this);
      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-jhs-container', ['exports', 'ember-data', 'ember', 'yarn-ui/utils/converter'], function (exports, _emberData, _ember, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload) {

      var fixedPayload = {
        id: payload.containerId,
        type: primaryModelClass.modelName,
        attributes: {
          containerLogInfo: payload.containerLogInfo,
          logAggregationType: payload.logAggregationType,
          containerId: payload.containerId,
          nodeId: payload.nodeId
        }
      };
      return fixedPayload;
    },

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var normalized = this.internalNormalizeSingleResponse(store, primaryModelClass, payload);
      return {
        data: normalized
      };
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var _this = this;

      // Handling single container and multiple containers case at the same time
      payload = [].concat(payload["containerLogsInfo"]);

      var normalizedArrayResponse = {
        data: []
      };
      if (payload && _ember['default'].isArray(payload) && !_ember['default'].isEmpty(payload)) {
        normalizedArrayResponse.data = payload.map(function (singleContainer) {
          return _this.internalNormalizeSingleResponse(store, primaryModelClass, singleContainer);
        });
      }
      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/serializers/yarn-jhs-log", ["exports", "ember-data"], function (exports, _emberData) {
  exports["default"] = _emberData["default"].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload, containerId, nodeId) {
      var fixedPayload = {
        id: "yarn_log_" + payload.fileName + "_" + Date.now(),
        type: primaryModelClass.modelName,
        attributes: {
          fileName: payload.fileName,
          fileSize: payload.fileSize,
          lastModifiedTime: payload.lastModifiedTime,
          redirectedUrl: payload.redirectedUrl,
          containerId: containerId,
          nodeId: nodeId
        }
      };
      return fixedPayload;
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var _this = this;

      var normalizedArrayResponse = {
        data: []
      };
      // If JSON payload is an object with a containerLogsInfo property
      if (payload && payload.containerLogsInfo && payload.containerLogsInfo.containerLogInfo) {
        normalizedArrayResponse.data = payload.containerLogsInfo.containerLogInfo.map(function (signle_payload) {
          return _this.internalNormalizeSingleResponse(store, primaryModelClass, signle_payload, payload.containerLogsInfo.containerId, payload.containerLogsInfo.nodeId);
        });
      }
      // If JSON payload is an array
      if (payload && payload[0] && payload[0].containerLogInfo) {
        normalizedArrayResponse.data = payload[0].containerLogInfo.map(function (signle_payload) {
          return _this.internalNormalizeSingleResponse(store, primaryModelClass, signle_payload, payload[0].containerId, payload[0].nodeId);
        });
      }
      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/serializers/yarn-jhs-redirect-log", ["exports", "ember-data"], function (exports, _emberData) {
  exports["default"] = _emberData["default"].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload, containerId, nodeId) {
      var fixedPayload = {
        id: "yarn_log_" + payload.fileName + "_" + Date.now(),
        type: primaryModelClass.modelName,
        attributes: {
          fileName: payload.fileName,
          fileSize: payload.fileSize,
          lastModifiedTime: payload.lastModifiedTime,
          redirectedUrl: payload.redirectedUrl,
          containerId: containerId,
          nodeId: nodeId
        }
      };
      return fixedPayload;
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var _this = this;

      var normalizedArrayResponse = {
        data: []
      };
      // If JSON payload is an object with a containerLogsInfo property
      if (payload && payload.containerLogsInfo && payload.containerLogsInfo.containerLogInfo) {
        normalizedArrayResponse.data = payload.containerLogsInfo.containerLogInfo.map(function (signle_payload) {
          return _this.internalNormalizeSingleResponse(store, primaryModelClass, signle_payload, payload.containerLogsInfo.containerId, payload.containerLogsInfo.nodeId);
        });
      }
      // If JSON payload is an array
      if (payload && payload[0] && payload[0].containerLogInfo) {
        normalizedArrayResponse.data = payload[0].containerLogInfo.map(function (signle_payload) {
          return _this.internalNormalizeSingleResponse(store, primaryModelClass, signle_payload, payload[0].containerId, payload[0].nodeId);
        });
      }
      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/serializers/yarn-log", ["exports", "ember-data"], function (exports, _emberData) {
  exports["default"] = _emberData["default"].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload, containerId, nodeId) {
      var fixedPayload = {
        id: "yarn_log_" + payload.fileName + "_" + Date.now(),
        type: primaryModelClass.modelName,
        attributes: {
          fileName: payload.fileName,
          fileSize: payload.fileSize,
          lastModifiedTime: payload.lastModifiedTime,
          containerId: containerId,
          nodeId: nodeId
        }
      };
      return fixedPayload;
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var _this = this;

      var normalizedArrayResponse = {
        data: []
      };
      if (payload && payload.containerLogsInfo && payload.containerLogsInfo.containerLogInfo) {
        normalizedArrayResponse.data = payload.containerLogsInfo.containerLogInfo.map(function (paylog) {
          return _this.internalNormalizeSingleResponse(store, primaryModelClass, paylog, payload.containerLogsInfo.containerId, payload.containerLogsInfo.nodeId);
        });
      }
      if (payload && payload[0] && payload[0].containerLogInfo) {
        normalizedArrayResponse.data = payload[0].containerLogInfo.map(function (paylog) {
          return _this.internalNormalizeSingleResponse(store, primaryModelClass, paylog, payload[0].containerId, payload[0].nodeId);
        });
      }
      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-metrics', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    normalizeResponse: function normalizeResponse(store, primaryModelClass, payload, id, requestType) {
      var ret = {
        id: 0,
        type: primaryModelClass.modelName,
        attributes: {
          metrics: payload
        }
      };
      return { data: ret };
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-nm-gpu', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload, id) {
      if (payload.nodeInfo) {
        payload = payload.nodeInfo;
      }

      var fixedPayload = {
        id: id,
        type: primaryModelClass.modelName,
        attributes: {
          info: payload
        }
      };
      return fixedPayload;
    },

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id /*, requestType*/) {
      // payload is of the form {"nodeInfo":{}}
      var p = this.internalNormalizeSingleResponse(store, primaryModelClass, payload, id);
      return { data: p };
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-node-app', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload) {
      if (payload.app) {
        payload = payload.app;
      }

      var fixedPayload = {
        id: payload.id,
        type: primaryModelClass.modelName,
        attributes: {
          appId: payload.id,
          state: payload.state,
          user: payload.user,
          containers: payload.containerids
        }
      };
      return fixedPayload;
    },

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      // payload is of the form {"app":{}}
      var p = this.internalNormalizeSingleResponse(store, primaryModelClass, payload);
      return { data: p };
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var _this = this;

      // expected return response is of the form { data: [ {}, {} ] }
      var normalizedArrayResponse = {};
      // payload is of the form { "apps" : { "app": [ {},{},{} ]  } }
      if (payload.apps && payload.apps.app) {
        normalizedArrayResponse.data = payload.apps.app.map(function (singleApp) {
          return _this.internalNormalizeSingleResponse(store, primaryModelClass, singleApp);
        }, this);
      } else {
        // No container reported inside containers.
        // Response of the form { "apps": null }
        normalizedArrayResponse.data = [];
      }
      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/serializers/yarn-node-container-log", ["exports", "ember-data"], function (exports, _emberData) {
  exports["default"] = _emberData["default"].JSONAPISerializer.extend({

    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload) {
      var fixedPayload = {
        id: "yarn_node_container_log" + "_" + Date.now(),
        type: primaryModelClass.modelName,
        attributes: {
          logs: payload
        }
      };
      return fixedPayload;
    },

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var p = this.internalNormalizeSingleResponse(store, primaryModelClass, payload);

      return { data: p };
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var normalizedArrayResponse = {
        data: []
      };

      if (payload) {
        normalizedArrayResponse.data = [this.internalNormalizeSingleResponse(store, primaryModelClass, payload)];
      }
      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-node-container', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload) {
      if (payload.container) {
        payload = payload.container;
      }
      var fixedPayload = {
        id: payload.id,
        type: primaryModelClass.modelName,
        attributes: {
          containerId: payload.id,
          state: payload.state,
          user: payload.user,
          diagnostics: payload.diagnostics || 'N/A',
          exitCode: payload.exitCode,
          totalMemoryNeeded: payload.totalMemoryNeededMB,
          totalVCoresNeeded: payload.totalVCoresNeeded,
          containerLogFiles: payload.containerLogFiles
        }
      };

      return fixedPayload;
    },

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      // payload is of the form {"container":{}}
      var p = this.internalNormalizeSingleResponse(store, primaryModelClass, payload);
      return { data: p };
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var _this = this;

      // expected return response is of the form { data: [ {}, {} ] }
      var normalizedArrayResponse = {};
      if (payload.containers && payload.containers.container) {
        // payload is of the form { "containers" : { "container": [ {},{},{} ]  } }
        normalizedArrayResponse.data = payload.containers.container.map(function (singleContainer) {
          return _this.internalNormalizeSingleResponse(store, primaryModelClass, singleContainer);
        }, this);
      } else {
        // No container reported inside containers.
        // Response of the form { "containers": null }
        normalizedArrayResponse.data = [];
      }
      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-node', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload, id) {
      if (payload.nodeInfo) {
        payload = payload.nodeInfo;
      }

      var fixedPayload = {
        id: id,
        type: primaryModelClass.modelName,
        attributes: {
          totalVmemAllocatedContainersMB: payload.totalVmemAllocatedContainersMB,
          totalPmemAllocatedContainersMB: payload.totalPmemAllocatedContainersMB,
          totalVCoresAllocatedContainers: payload.totalVCoresAllocatedContainers,
          vmemCheckEnabled: payload.vmemCheckEnabled,
          pmemCheckEnabled: payload.pmemCheckEnabled,
          nodeHealthy: payload.nodeHealthy,
          lastNodeUpdateTime: _yarnUiUtilsConverter['default'].timeStampToDate(payload.lastNodeUpdateTime),
          healthReport: payload.healthReport || 'N/A',
          nmStartupTime: payload.nmStartupTime ? _yarnUiUtilsConverter['default'].timeStampToDate(payload.nmStartupTime) : '',
          nodeManagerBuildVersion: payload.nodeManagerBuildVersion,
          hadoopBuildVersion: payload.hadoopBuildVersion
        }
      };
      return fixedPayload;
    },

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id /*, requestType*/) {
      // payload is of the form {"nodeInfo":{}}
      var p = this.internalNormalizeSingleResponse(store, primaryModelClass, payload, id);
      return { data: p };
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-queue/capacity-queue', ['exports', 'ember-data', 'yarn-ui/constants'], function (exports, _emberData, _yarnUiConstants) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id, requestType) {
      var children = [];
      if (payload.queues && payload.queues.queue) {
        payload.queues.queue.forEach(function (queue) {
          children.push(queue.queuePath);
        });
      }

      var includedData = [];
      var relationshipUserData = [];

      // update user models
      if (payload.users && payload.users.user) {
        payload.users.user.forEach(function (u) {
          var defaultPartitionResource = u.resources.resourceUsagesByPartition[0];
          var maxAMResource = defaultPartitionResource.amLimit;
          includedData.push({
            type: "YarnUser",
            id: u.username + "_" + payload.queuePath,
            attributes: {
              name: u.username,
              queueName: payload.queuePath,
              usedMemoryMB: u.resourcesUsed.memory || 0,
              usedVCore: u.resourcesUsed.vCores || 0,
              maxMemoryMB: u.userResourceLimit.memory || 0,
              maxVCore: u.userResourceLimit.vCores || 0,
              amUsedMemoryMB: u.AMResourceUsed.memory || 0,
              amUsedVCore: u.AMResourceUsed.vCores || 0,
              maxAMMemoryMB: maxAMResource.memory || 0,
              maxAMVCore: maxAMResource.vCores || 0,
              userWeight: u.userWeight || '',
              activeApps: u.numActiveApplications || 0,
              pendingApps: u.numPendingApplications || 0
            }
          });

          relationshipUserData.push({
            type: "YarnUser",
            id: u.username + "_" + payload.queuePath
          });
        });
      }

      var partitions = [];
      var partitionMap = {};
      if ("capacities" in payload) {
        partitions = payload.capacities.queueCapacitiesByPartition.map(function (cap) {
          return cap.partitionName || _yarnUiConstants.PARTITION_LABEL;
        });
        partitionMap = payload.capacities.queueCapacitiesByPartition.reduce(function (init, cap) {
          init[cap.partitionName || _yarnUiConstants.PARTITION_LABEL] = cap;
          return init;
        }, {});
      } else {
        partitions = [_yarnUiConstants.PARTITION_LABEL];
        partitionMap[_yarnUiConstants.PARTITION_LABEL] = {
          partitionName: "",
          capacity: payload.capacity,
          maxCapacity: payload.maxCapacity,
          usedCapacity: payload.usedCapacity,
          absoluteCapacity: 'absoluteCapacity' in payload ? payload.absoluteCapacity : payload.capacity,
          absoluteMaxCapacity: 'absoluteMaxCapacity' in payload ? payload.absoluteMaxCapacity : payload.maxCapacity,
          absoluteUsedCapacity: 'absoluteUsedCapacity' in payload ? payload.absoluteUsedCapacity : payload.usedCapacity
        };
      }

      //add here the partitioninfo
      ///scheduler/schedulerInfo/queues/queue[2]/resources/resourceUsagesByPartition/partitionName
      //resources.resourceUsagesByPartition[].used.memory
      var resourcePartitions = [];
      var resourceUsagesByPartitionMap = {};
      if ("resources" in payload) {
        resourcePartitions = payload.resources.resourceUsagesByPartition.map(function (res) {
          return res.partitionName || _yarnUiConstants.PARTITION_LABEL;
        });
        resourceUsagesByPartitionMap = payload.resources.resourceUsagesByPartition.reduce(function (init, res) {
          init[res.partitionName || _yarnUiConstants.PARTITION_LABEL] = res;
          return init;
        }, {});
      } else {
        resourceUsagesByPartitionMap[_yarnUiConstants.PARTITION_LABEL] = {
          partitionName: ""
        };
      }

      var fixedPayload = {
        id: id,
        type: primaryModelClass.modelName, // yarn-queue
        attributes: {
          name: payload.queueName,
          queuePath: payload.queuePath,
          parent: payload.myParent,
          children: children,
          capacity: payload.capacity,
          usedCapacity: payload.usedCapacity,
          maxCapacity: payload.maxCapacity,
          absCapacity: payload.absoluteCapacity,
          absMaxCapacity: payload.absoluteMaxCapacity,
          absUsedCapacity: payload.absoluteUsedCapacity,
          weight: payload.weight,
          normalizedWeight: payload.normalizedWeight,
          creationMethod: payload.creationMethod,
          state: payload.state,
          orderingPolicyInfo: payload.orderingPolicyInfo,
          userLimit: payload.userLimit,
          userLimitFactor: payload.userLimitFactor,
          preemptionDisabled: payload.preemptionDisabled,
          intraQueuePreemptionDisabled: payload.intraQueuePreemptionDisabled,
          numPendingApplications: payload.numPendingApplications,
          numActiveApplications: payload.numActiveApplications,
          numContainers: payload.numContainers,
          maxApplications: payload.maxApplications,
          maxApplicationsPerUser: payload.maxApplicationsPerUser,
          nodeLabels: payload.nodeLabels,
          defaultNodeLabelExpression: payload.defaultNodeLabelExpression,
          resources: payload.resources,
          defaultPriority: payload.defaultPriority,
          partitions: partitions,
          partitionMap: partitionMap,
          resourceUsagesByPartitionMap: resourceUsagesByPartitionMap,
          type: "capacity"
        },
        // Relationships
        relationships: {
          users: {
            data: relationshipUserData
          }
        }
      };
      return {
        queue: this._super(store, primaryModelClass, fixedPayload, id, requestType),
        includedData: includedData
      };
    },

    handleQueue: function handleQueue(store, primaryModelClass, payload, id, requestType) {
      var data = [];
      var includedData = [];
      var result = this.normalizeSingleResponse(store, primaryModelClass, payload, id, requestType);

      data.push(result.queue);
      includedData = includedData.concat(result.includedData);

      if (payload.queues && payload.queues.queue) {
        for (var i = 0; i < payload.queues.queue.length; i++) {
          var queue = payload.queues.queue[i];
          queue.myParent = payload.queuePath;
          var childResult = this.handleQueue(store, primaryModelClass, queue, queue.queuePath, requestType);

          data = data.concat(childResult.data);
          includedData = includedData.concat(childResult.includedData);
        }
      }

      return {
        data: data,
        includedData: includedData
      };
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload, id, requestType) {
      var normalizedArrayResponse = {};
      var result = this.handleQueue(store, primaryModelClass, payload.scheduler.schedulerInfo, "root", requestType);

      normalizedArrayResponse.data = result.data;
      normalizedArrayResponse.included = result.includedData;

      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/serializers/yarn-queue/fair-queue", ["exports", "ember-data"], function (exports, _emberData) {
  exports["default"] = _emberData["default"].JSONAPISerializer.extend({

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id, requestType) {
      var children = [];
      if (payload.childQueues) {
        payload.childQueues.queue.forEach(function (queue) {
          children.push(queue.queueName);
        });
      }

      var fixedPayload = {
        id: id,
        type: primaryModelClass.modelName,
        attributes: {
          name: payload.queueName,
          parent: payload.myParent,
          children: children,
          maxApps: payload.maxApps,
          minResources: payload.minResources,
          maxResources: payload.maxResources,
          usedResources: payload.usedResources,
          demandResources: payload.demandResources,
          steadyFairResources: payload.steadyFairResources,
          fairResources: payload.fairResources,
          clusterResources: payload.clusterResources,
          pendingContainers: payload.pendingContainers,
          allocatedContainers: payload.allocatedContainers,
          reservedContainers: payload.reservedContainers,
          schedulingPolicy: payload.schedulingPolicy,
          preemptable: payload.preemptable,
          numPendingApplications: payload.numPendingApps,
          numActiveApplications: payload.numActiveApps,
          type: "fair"
        }
      };
      return this._super(store, primaryModelClass, fixedPayload, id, requestType);
    },

    handleQueue: function handleQueue(store, primaryModelClass, payload, id, requestType) {
      var data = [];
      if (!payload) {
        return data;
      }
      var result = this.normalizeSingleResponse(store, primaryModelClass, payload, id, requestType);

      data.push(result);

      if (payload.childQueues) {
        for (var i = 0; i < payload.childQueues.queue.length; i++) {
          var queue = payload.childQueues.queue[i];
          queue.myParent = payload.queueName;
          var childResult = this.handleQueue(store, primaryModelClass, queue, queue.queueName, requestType);

          data = data.concat(childResult);
        }
      }

      return data;
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload, id, requestType) {
      var normalizedArrayResponse = {};
      var result = this.handleQueue(store, primaryModelClass, payload.scheduler.schedulerInfo.rootQueue, "root", requestType);

      normalizedArrayResponse.data = result;
      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/serializers/yarn-queue/fifo-queue", ["exports", "ember-data"], function (exports, _emberData) {
  exports["default"] = _emberData["default"].JSONAPISerializer.extend({

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id, requestType) {

      var fixedPayload = {
        id: id,
        type: primaryModelClass.modelName,
        attributes: {
          name: id,
          capacity: payload.capacity * 100,
          usedCapacity: payload.usedCapacity * 100,
          usedNodeCapacity: payload.usedNodeCapacity,
          availNodeCapacity: payload.availNodeCapacity,
          totalNodeCapacity: payload.totalNodeCapacity,
          numNodes: payload.numNodes,
          numContainers: payload.numContainers,
          state: payload.qstate,
          minQueueMemoryCapacity: payload.minQueueMemoryCapacity,
          maxQueueMemoryCapacity: payload.maxQueueMemoryCapacity,
          type: "fifo"
        }

      };

      return this._super(store, primaryModelClass, fixedPayload, id, requestType);
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload, id, requestType) {
      var normalizedArrayResponse = {};
      normalizedArrayResponse.data = [this.normalizeSingleResponse(store, primaryModelClass, payload.scheduler.schedulerInfo, "root", requestType)];

      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/serializers/yarn-queue/yarn-queue", ["exports", "ember-data"], function (exports, _emberData) {
  exports["default"] = _emberData["default"].JSONAPISerializer.extend({

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id, requestType) {

      var fixedPayload = {
        id: id,
        type: primaryModelClass.modelName,
        attributes: {
          type: payload.type.split(/(?=[A-Z])/)[0]
        }
      };
      return this._super(store, primaryModelClass, fixedPayload, id, requestType);
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload, id, requestType) {
      var normalizedArrayResponse = {};

      normalizedArrayResponse.data = [this.normalizeSingleResponse(store, primaryModelClass, payload.scheduler.schedulerInfo, "root", requestType)];

      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/serializers/yarn-redirect-log", ["exports", "ember-data"], function (exports, _emberData) {
  exports["default"] = _emberData["default"].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload, containerId, nodeId) {
      var fixedPayload = {
        id: "yarn_log_" + payload.fileName + "_" + Date.now(),
        type: primaryModelClass.modelName,
        attributes: {
          fileName: payload.fileName,
          fileSize: payload.fileSize,
          lastModifiedTime: payload.lastModifiedTime,
          containerId: containerId,
          nodeId: nodeId
        }
      };
      return fixedPayload;
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var _this = this;

      var normalizedArrayResponse = {
        data: []
      };
      if (payload && payload.containerLogsInfo && payload.containerLogsInfo.containerLogInfo) {
        normalizedArrayResponse.data = payload.containerLogsInfo.containerLogInfo.map(function (paylog) {
          return _this.internalNormalizeSingleResponse(store, primaryModelClass, paylog, payload.containerLogsInfo.containerId, payload.containerLogsInfo.nodeId);
        });
      }
      if (payload && payload[0] && payload[0].containerLogInfo) {
        normalizedArrayResponse.data = payload[0].containerLogInfo.map(function (paylog) {
          return _this.internalNormalizeSingleResponse(store, primaryModelClass, paylog, payload[0].containerId, payload[0].nodeId);
        });
      }
      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-rm-log', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    normalizeResponse: function normalizeResponse(store, primaryModelClass, payload) {
      var pattern = new RegExp('<A HREF="/logs/.+">|<a href="/logs/.+">', 'g');
      var fileNames = payload.match(pattern);

      if (fileNames == null) {
        return { data: [] };
      }

      var logfileNames = [];
      for (var i = 0; i < fileNames.length; i++) {
        var fileNameMatch = fileNames[i].match(/<A HREF="(\/logs\/.+)">.+<\/A>|<a href="(\/logs\/.+)">.+<\/a>/);
        var logFileUrl = fileNameMatch[1] || fileNameMatch[2];
        var logFileName = logFileUrl.replace('logs', '').replace(/\//g, '');

        if (fileNameMatch.length != null) {
          logfileNames.push({
            id: i,
            type: primaryModelClass.modelName,
            attributes: {
              logFileUrl: logFileUrl,
              logFileName: logFileName
            }
          });
        }
      }
      return { data: logfileNames };
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-rm-node', ['exports', 'ember-data', 'yarn-ui/utils/converter'], function (exports, _emberData, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload, id) {
      if (payload.node) {
        payload = payload.node;
      }

      var fixedPayload = {
        id: id,
        type: primaryModelClass.modelName,
        attributes: {
          rack: payload.rack,
          state: payload.state,
          nodeHostName: payload.nodeHostName,
          nodeHTTPAddress: payload.nodeHTTPAddress,
          lastHealthUpdate: _yarnUiUtilsConverter['default'].timeStampToDate(payload.lastHealthUpdate),
          healthReport: payload.healthReport || 'N/A',
          numContainers: payload.numContainers,
          usedMemoryMB: payload.usedMemoryMB,
          availMemoryMB: payload.availMemoryMB,
          usedVirtualCores: payload.usedVirtualCores,
          availableVirtualCores: payload.availableVirtualCores,
          version: payload.version,
          nodeLabels: payload.nodeLabels,
          usedResource: payload.usedResource,
          availableResource: payload.availableResource
        }
      };
      return fixedPayload;
    },

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload, id /*, requestType*/) {
      // payload is of the form {"nodeInfo":{}}
      var p = this.internalNormalizeSingleResponse(store, primaryModelClass, payload, id);
      return { data: p };
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var _this = this;

      // expected response is of the form { data: [ {}, {} ] }
      var normalizedArrayResponse = {};
      if (payload.nodes && payload.nodes.node) {
        // payload is of the form { "nodes": { "node": [ {},{},{} ]  } }
        normalizedArrayResponse.data = payload.nodes.node.map(function (singleNode) {
          return _this.internalNormalizeSingleResponse(store, primaryModelClass, singleNode, singleNode.id);
        }, this);
      } else {
        normalizedArrayResponse.data = [];
      }
      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-service-component', ['exports', 'ember-data', 'ember'], function (exports, _emberData, _ember) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload) {
      var info = payload.info;
      var configs = payload.configs;
      var metrics = payload.metrics;
      var newConfigs = _ember['default'].A();
      var newMetrics = _ember['default'].Object.create();

      if (configs) {
        for (var conf in configs) {
          var confObj = _ember['default'].Object.create({
            name: conf,
            value: configs[conf] || 'N/A'
          });
          newConfigs.push(confObj);
        }
      }

      if (metrics) {
        metrics.forEach(function (metric) {
          var val = metric.values[Object.keys(metric.values)[0]];
          newMetrics.set(metric.id, val !== undefined ? val : 'N/A');
        });
      }

      var fixedPayload = {
        id: 'yarn_service_component_' + payload.id,
        type: primaryModelClass.modelName,
        attributes: {
          name: payload.id,
          vcores: info.RESOURCE_CPU,
          memory: info.RESOURCE_MEMORY,
          priority: 'N/A',
          instances: '0',
          createdTimestamp: payload.createdtime,
          configs: newConfigs,
          metrics: newMetrics
        }
      };

      return fixedPayload;
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var normalizedResponse = { data: [] };

      if (payload && Array.isArray(payload)) {
        payload.forEach((function (component) {
          var pl = this.internalNormalizeSingleResponse(store, primaryModelClass, component);
          normalizedResponse.data.push(pl);
        }).bind(this));
      }

      return normalizedResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-service-info', ['exports', 'ember-data', 'ember'], function (exports, _emberData, _ember) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload) {
      var info = payload.info;
      var configs = payload.configs;
      var quicklinks = info.QUICK_LINKS;
      var metrics = payload.metrics;
      var newConfigs = _ember['default'].A();
      var newQuicklinks = _ember['default'].A();
      var newMetrics = _ember['default'].Object.create();

      if (configs) {
        for (var conf in configs) {
          var confObj = _ember['default'].Object.create({
            name: conf,
            value: configs[conf] || 'N/A'
          });
          newConfigs.push(confObj);
        }
      }

      if (quicklinks) {
        for (var link in quicklinks) {
          var linkObj = _ember['default'].Object.create({
            name: link,
            value: quicklinks[link] || 'N/A'
          });
          newQuicklinks.push(linkObj);
        }
      }

      if (metrics) {
        metrics.forEach(function (metric) {
          var val = metric.values[Object.keys(metric.values)[0]];
          newMetrics.set(metric.id, val !== undefined ? val : 'N/A');
        });
      }

      var fixedPayload = {
        id: 'yarn_service_info_' + payload.id,
        type: primaryModelClass.modelName,
        attributes: {
          name: info.NAME,
          appId: payload.id,
          state: info.STATE,
          createdTimestamp: payload.createdtime,
          launchTimestamp: info.LAUNCH_TIME,
          quicklinks: newQuicklinks,
          configs: newConfigs,
          metrics: newMetrics
        }
      };

      return fixedPayload;
    },

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var normalizedResponse = { data: [] };

      if (payload && payload[0]) {
        var pl = this.internalNormalizeSingleResponse(store, primaryModelClass, payload[0]);
        normalizedResponse.data = pl;
      }

      return normalizedResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-service', ['exports', 'ember-data'], function (exports, _emberData) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload) {
      var fixedPayload = {
        id: 'yarn_service_' + (payload.id || Date.now()),
        type: primaryModelClass.modelName,
        attributes: {
          appId: payload.id,
          name: payload.name,
          state: payload.state,
          version: payload.version,
          lifetime: payload.lifetime,
          components: payload.components,
          configuration: payload.configuration,
          quicklinks: payload.quicklinks
        }
      };
      return fixedPayload;
    },

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var pl = this.internalNormalizeSingleResponse(store, primaryModelClass, payload);
      return { data: pl };
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-timeline-appattempt', ['exports', 'ember-data', 'ember', 'yarn-ui/utils/converter'], function (exports, _emberData, _ember, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload) {
      var payloadEvents = payload.events,
          createdEvent = payloadEvents.filterBy('id', 'YARN_APPLICATION_ATTEMPT_REGISTERED')[0],
          startedTime = createdEvent ? createdEvent.timestamp : Date.now(),
          finishedEvent = payloadEvents.filterBy('id', 'YARN_APPLICATION_ATTEMPT_FINISHED')[0],
          finishedTime = finishedEvent ? finishedEvent.timestamp : Date.now();

      var fixedPayload = {
        id: payload.id,
        type: primaryModelClass.modelName,
        attributes: {
          startTime: _yarnUiUtilsConverter['default'].timeStampToDate(startedTime),
          startedTime: _yarnUiUtilsConverter['default'].timeStampToDate(startedTime),
          finishedTime: _yarnUiUtilsConverter['default'].timeStampToDate(finishedTime),
          containerId: payload.info.YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER,
          amContainerId: payload.info.YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER,
          nodeHttpAddress: payload.info.YARN_APPLICATION_ATTEMPT_MASTER_NODE_ADDRESS,
          exposedPorts: payload.info.YARN_CONTAINER_ALLOCATED_EXPOSED_PORTS,
          nodeId: payload.info.YARN_APPLICATION_ATTEMPT_MASTER_NODE_ID,
          hosts: payload.info.YARN_APPLICATION_ATTEMPT_HOST,
          state: payload.info.YARN_APPLICATION_ATTEMPT_STATE,
          logsLink: '',
          appAttemptId: payload.id
        }
      };
      return fixedPayload;
    },

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var normalized = this.internalNormalizeSingleResponse(store, primaryModelClass, payload);
      return { data: normalized };
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var _this = this;

      var normalizedArrayResponse = {
        data: []
      };
      if (payload && _ember['default'].isArray(payload) && !_ember['default'].isEmpty(payload)) {
        normalizedArrayResponse.data = payload.map(function (singleAttempt) {
          return _this.internalNormalizeSingleResponse(store, primaryModelClass, singleAttempt);
        });
      }
      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/serializers/yarn-timeline-container', ['exports', 'ember-data', 'ember', 'yarn-ui/utils/converter'], function (exports, _emberData, _ember, _yarnUiUtilsConverter) {
  exports['default'] = _emberData['default'].JSONAPISerializer.extend({
    internalNormalizeSingleResponse: function internalNormalizeSingleResponse(store, primaryModelClass, payload) {

      var fixedPayload = {
        id: payload.id,
        type: primaryModelClass.modelName,
        attributes: {
          allocatedMB: payload.info.YARN_CONTAINER_ALLOCATED_MEMORY,
          allocatedVCores: payload.info.YARN_CONTAINER_ALLOCATED_VCORE,
          assignedNodeId: payload.info.YARN_CONTAINER_ALLOCATED_HOST,
          priority: payload.info.YARN_CONTAINER_ALLOCATED_PRIORITY,
          startedTime: _yarnUiUtilsConverter['default'].timeStampToDate(payload.createdtime),
          finishedTime: _yarnUiUtilsConverter['default'].timeStampToDate(payload.info.YARN_CONTAINER_FINISHED_TIME),
          nodeHttpAddress: payload.info.YARN_CONTAINER_ALLOCATED_HOST_HTTP_ADDRESS,
          exposedPorts: payload.info.YARN_CONTAINER_ALLOCATED_EXPOSED_PORTS,
          containerExitStatus: payload.info.YARN_CONTAINER_EXIT_STATUS + '',
          containerState: payload.info.YARN_CONTAINER_STATE,
          nodeId: payload.info.YARN_CONTAINER_ALLOCATED_HOST + ':' + payload.info.YARN_CONTAINER_ALLOCATED_PORT,
          diagnosticsInfo: payload.info.YARN_CONTAINER_DIAGNOSTICS_INFO
        }
      };
      return fixedPayload;
    },

    normalizeSingleResponse: function normalizeSingleResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var normalized = this.internalNormalizeSingleResponse(store, primaryModelClass, payload);
      return {
        data: normalized
      };
    },

    normalizeArrayResponse: function normalizeArrayResponse(store, primaryModelClass, payload /*, id, requestType*/) {
      var _this = this;

      var normalizedArrayResponse = {
        data: []
      };
      if (payload && _ember['default'].isArray(payload) && !_ember['default'].isEmpty(payload)) {
        normalizedArrayResponse.data = payload.map(function (singleContainer) {
          return _this.internalNormalizeSingleResponse(store, primaryModelClass, singleContainer);
        });
      }
      return normalizedArrayResponse;
    }
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define('yarn-ui/services/env', ['exports', 'ember', 'yarn-ui/config/environment'], function (exports, _ember, _yarnUiConfigEnvironment) {

  var MoreObject = more.Object;

  exports['default'] = _ember['default'].Service.extend({
    ENV: null,

    init: function init() {
      this.collateConfigs();
    },

    collateConfigs: function collateConfigs() {
      var collatedENV = {
        APP: {}
      },
          ENV = window.ENV;

      MoreObject.merge(collatedENV, _yarnUiConfigEnvironment['default']);

      if (ENV) {
        MoreObject.merge(collatedENV.APP, ENV);
      }

      this.setComputedENVs(collatedENV);

      this.set("ENV", collatedENV);
    },

    setComputedENVs: function setComputedENVs(env) {
      var navigator = window.navigator;
      env.isIE = navigator.userAgent.indexOf('MSIE') !== -1 || navigator.appVersion.indexOf('Trident/') > 0;
      console.log('In setComputedENVs', env.isIE);
    },

    app: _ember['default'].computed("ENV.APP", function () {
      return this.get("ENV.APP");
    })
  });
});
/*global more*/
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/services/hosts", ["exports", "ember"], function (exports, _ember) {
  exports["default"] = _ember["default"].Service.extend({

    env: _ember["default"].inject.service("env"),

    attachProtocolScheme: function attachProtocolScheme(url) {
      var localProto = this.get("env.app.hosts.protocolScheme");

      if (localProto === "") {
        localProto = "http:";
      }

      if (url.match("://")) {
        url = url.substr(url.indexOf("://") + 3);
      }

      return localProto + "//" + url;
    },

    normalizeURL: function normalizeURL(url) {
      var address;

      // If localBaseAddress is configured, then normalized URL has to
      // start with this address. For eg: when used with CORS proxy.
      // In any case, this fn will return with correct proto scheme.
      address = this.localAddress() + url;

      // Remove trailing slash
      if (address && address.charAt(address.length - 1) === '/') {
        address = address.slice(0, -1);
      }
      return address;
    },

    localAddress: function localAddress() {
      var localBaseAddressProto = "";

      if (this.get("env.app.hosts.localBaseAddress").length > 0) {
        localBaseAddressProto = this.get("env.app.hosts.localBaseAddress") + '/';
      }
      return this.attachProtocolScheme(localBaseAddressProto);
    },

    localBaseAddress: _ember["default"].computed(function () {
      var url = this.localAddress();
      if (url.endsWith('/')) {
        url = url.slice(0, -1);
      }
      return url;
    }),

    timelineWebAddress: _ember["default"].computed(function () {
      return this.normalizeURL(this.get("env.app.hosts.timelineWebAddress"));
    }),

    timelineV1WebAddress: _ember["default"].computed(function () {
      return this.normalizeURL(this.get("env.app.hosts.timelineV1WebAddress"));
    }),

    rmWebAddress: _ember["default"].computed(function () {
      return this.normalizeURL(this.get("env.app.hosts.rmWebAddress"));
    }),

    jhsAddress: _ember["default"].computed(function () {
      return this.normalizeURL(this.get("env.app.hosts.jhsAddress"));
    }),

    dashWebAddress: _ember["default"].computed(function () {
      return this.normalizeURL(this.get("env.app.hosts.dashWebAddress"));
    }),

    isSecurityEnabled: _ember["default"].computed(function () {
      console.log(this.get("env.app.hosts.isSecurityEnabled"));
      return this.get("env.app.hosts.isSecurityEnabled");
    })
  });
});
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
define("yarn-ui/templates/application", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 40,
                "column": 12
              },
              "end": {
                "line": 42,
                "column": 12
              }
            },
            "moduleName": "yarn-ui/templates/application.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("Cluster Overview\n              ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("span");
            dom.setAttribute(el1, "class", "sr-only");
            var el2 = dom.createTextNode("(current)");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes() {
            return [];
          },
          statements: [],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 39,
              "column": 10
            },
            "end": {
              "line": 43,
              "column": 10
            }
          },
          "moduleName": "yarn-ui/templates/application.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("            ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "link-to", ["cluster-overview"], ["class", "navigation-link"], 0, null, ["loc", [null, [40, 12], [42, 24]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 45,
                "column": 12
              },
              "end": {
                "line": 47,
                "column": 12
              }
            },
            "moduleName": "yarn-ui/templates/application.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("Queues\n              ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("span");
            dom.setAttribute(el1, "class", "sr-only");
            var el2 = dom.createTextNode("(current)");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes() {
            return [];
          },
          statements: [],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 44,
              "column": 10
            },
            "end": {
              "line": 48,
              "column": 10
            }
          },
          "moduleName": "yarn-ui/templates/application.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("            ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "link-to", ["yarn-queues", "root"], ["class", "navigation-link"], 0, null, ["loc", [null, [45, 12], [47, 24]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child2 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 50,
                "column": 12
              },
              "end": {
                "line": 52,
                "column": 12
              }
            },
            "moduleName": "yarn-ui/templates/application.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("Applications\n              ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("span");
            dom.setAttribute(el1, "class", "sr-only");
            var el2 = dom.createTextNode("(current)");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes() {
            return [];
          },
          statements: [],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 49,
              "column": 10
            },
            "end": {
              "line": 53,
              "column": 10
            }
          },
          "moduleName": "yarn-ui/templates/application.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("            ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "link-to", ["yarn-apps.apps"], ["class", "navigation-link"], 0, null, ["loc", [null, [50, 12], [52, 24]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child3 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 55,
                "column": 12
              },
              "end": {
                "line": 57,
                "column": 12
              }
            },
            "moduleName": "yarn-ui/templates/application.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("Services\n              ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("span");
            dom.setAttribute(el1, "class", "sr-only");
            var el2 = dom.createTextNode("(current)");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes() {
            return [];
          },
          statements: [],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 54,
              "column": 10
            },
            "end": {
              "line": 58,
              "column": 10
            }
          },
          "moduleName": "yarn-ui/templates/application.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("            ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "link-to", ["yarn-services"], ["class", "navigation-link"], 0, null, ["loc", [null, [55, 12], [57, 24]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child4 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 60,
                "column": 12
              },
              "end": {
                "line": 62,
                "column": 12
              }
            },
            "moduleName": "yarn-ui/templates/application.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("Flow Activity\n              ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("span");
            dom.setAttribute(el1, "class", "sr-only");
            var el2 = dom.createTextNode("(current)");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes() {
            return [];
          },
          statements: [],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 59,
              "column": 10
            },
            "end": {
              "line": 63,
              "column": 10
            }
          },
          "moduleName": "yarn-ui/templates/application.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("            ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "link-to", ["yarn-flow-activity"], ["class", "navigation-link", "disabled", ["subexpr", "@mut", [["get", "isTimelineUnHealthy", ["loc", [null, [60, 77], [60, 96]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [60, 12], [62, 24]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child5 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 65,
                "column": 12
              },
              "end": {
                "line": 67,
                "column": 12
              }
            },
            "moduleName": "yarn-ui/templates/application.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("Nodes\n              ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("span");
            dom.setAttribute(el1, "class", "sr-only");
            var el2 = dom.createTextNode("(current)");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes() {
            return [];
          },
          statements: [],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 64,
              "column": 10
            },
            "end": {
              "line": 68,
              "column": 10
            }
          },
          "moduleName": "yarn-ui/templates/application.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("            ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "link-to", ["yarn-nodes.table"], ["class", "navigation-link"], 0, null, ["loc", [null, [65, 12], [67, 24]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child6 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 70,
                "column": 12
              },
              "end": {
                "line": 72,
                "column": 12
              }
            },
            "moduleName": "yarn-ui/templates/application.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("Tools\n              ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("span");
            dom.setAttribute(el1, "class", "sr-only");
            var el2 = dom.createTextNode("(current)");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes() {
            return [];
          },
          statements: [],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 69,
              "column": 10
            },
            "end": {
              "line": 73,
              "column": 10
            }
          },
          "moduleName": "yarn-ui/templates/application.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("            ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "link-to", ["yarn-tools.yarn-conf"], ["class", "navigation-link"], 0, null, ["loc", [null, [70, 12], [72, 24]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child7 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 75,
              "column": 8
            },
            "end": {
              "line": 79,
              "column": 8
            }
          },
          "moduleName": "yarn-ui/templates/application.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("        ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "loggedin-user");
          var el2 = dom.createTextNode("\n          Logged in as: ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("span");
          dom.setAttribute(el2, "class", "username");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n        ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1, 1]), 0, 0);
          return morphs;
        },
        statements: [["content", "userInfo.requestedUser", ["loc", [null, [77, 47], [77, 73]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child8 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 99,
              "column": 6
            },
            "end": {
              "line": 101,
              "column": 6
            }
          },
          "moduleName": "yarn-ui/templates/application.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("        ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("span");
          var el2 = dom.createTextNode("Timezone ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("b");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1, 1]), 0, 0);
          return morphs;
        },
        statements: [["content", "env.app.timezone", ["loc", [null, [100, 26], [100, 46]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child9 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 105,
              "column": 4
            },
            "end": {
              "line": 113,
              "column": 4
            }
          },
          "moduleName": "yarn-ui/templates/application.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("strong");
          var el3 = dom.createTextNode("v");
          dom.appendChild(el2, el3);
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("span");
          dom.setAttribute(el2, "class", "yarn-cluster-status yarn-tooltip");
          dom.setAttribute(el2, "data-toggle", "tooltip");
          dom.setAttribute(el2, "data-placement", "top");
          var el3 = dom.createTextNode("\n        ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("i");
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n      ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          var el3 = dom.createTextNode("Started at ");
          dom.appendChild(el2, el3);
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var element1 = dom.childAt(element0, [3]);
          var element2 = dom.childAt(element1, [1]);
          var morphs = new Array(4);
          morphs[0] = dom.createMorphAt(dom.childAt(element0, [1]), 1, 1);
          morphs[1] = dom.createAttrMorph(element1, 'title');
          morphs[2] = dom.createAttrMorph(element2, 'class');
          morphs[3] = dom.createMorphAt(dom.childAt(element0, [5]), 1, 1);
          return morphs;
        },
        statements: [["content", "clusterInfo.hadoopVersion", ["loc", [null, [107, 15], [107, 44]]], 0, 0, 0, 0], ["attribute", "title", ["concat", ["Hadoop Version: ", ["get", "clusterInfo.getYARNBuildHash", ["loc", [null, [108, 78], [108, 106]]], 0, 0, 0, 0], " \nStarted on: ", ["subexpr", "date-formatter", [["get", "clusterInfo.startedOn", ["loc", [null, [108, 143], [108, 164]]], 0, 0, 0, 0]], [], ["loc", [null, [108, 126], [108, 166]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["attribute", "class", ["subexpr", "lower", [["get", "clusterInfo.state", ["loc", [null, [109, 25], [109, 42]]], 0, 0, 0, 0]], [], ["loc", [null, [null, null], [109, 44]]], 0, 0], 0, 0, 0, 0], ["inline", "date-formatter", [["get", "clusterInfo.startedOn", ["loc", [null, [111, 39], [111, 60]]], 0, 0, 0, 0]], [], ["loc", [null, [111, 22], [111, 62]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 118,
            "column": 0
          }
        },
        "moduleName": "yarn-ui/templates/application.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "footer-pusher");
        var el2 = dom.createTextNode("\n\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("nav");
        dom.setAttribute(el2, "class", "navbar navbar-default");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "container-fluid");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createComment(" Brand and toggle get grouped for better mobile display ");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("div");
        dom.setAttribute(el4, "class", "navbar-header");
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("a");
        dom.setAttribute(el5, "class", "navbar-brand");
        dom.setAttribute(el5, "href", "#");
        var el6 = dom.createTextNode("\n         ");
        dom.appendChild(el5, el6);
        var el6 = dom.createElement("img");
        dom.setAttribute(el6, "class", "hadoop-brand-image");
        dom.setAttribute(el6, "alt", "Apache Hadoop");
        dom.setAttribute(el6, "src", "assets/images/hadoop_logo.png");
        dom.appendChild(el5, el6);
        var el6 = dom.createTextNode("\n        ");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("button");
        dom.setAttribute(el5, "type", "button");
        dom.setAttribute(el5, "class", "navbar-toggle collapsed");
        dom.setAttribute(el5, "data-toggle", "collapse");
        dom.setAttribute(el5, "data-target", "#bs-example-navbar-collapse-1");
        dom.setAttribute(el5, "aria-expanded", "false");
        var el6 = dom.createTextNode("\n          ");
        dom.appendChild(el5, el6);
        var el6 = dom.createElement("span");
        dom.setAttribute(el6, "class", "sr-only");
        var el7 = dom.createTextNode("Toggle navigation");
        dom.appendChild(el6, el7);
        dom.appendChild(el5, el6);
        var el6 = dom.createTextNode("\n          ");
        dom.appendChild(el5, el6);
        var el6 = dom.createElement("span");
        dom.setAttribute(el6, "class", "icon-bar");
        dom.appendChild(el5, el6);
        var el6 = dom.createTextNode("\n          ");
        dom.appendChild(el5, el6);
        var el6 = dom.createElement("span");
        dom.setAttribute(el6, "class", "icon-bar");
        dom.appendChild(el5, el6);
        var el6 = dom.createTextNode("\n          ");
        dom.appendChild(el5, el6);
        var el6 = dom.createElement("span");
        dom.setAttribute(el6, "class", "icon-bar");
        dom.appendChild(el5, el6);
        var el6 = dom.createTextNode("\n        ");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createComment(" Collect the nav links, forms, and other content for toggling ");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("div");
        dom.setAttribute(el4, "class", "collapse navbar-collapse");
        dom.setAttribute(el4, "id", "bs-example-navbar-collapse-1");
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("ul");
        dom.setAttribute(el5, "class", "nav navbar-nav");
        var el6 = dom.createTextNode("\n");
        dom.appendChild(el5, el6);
        var el6 = dom.createComment("");
        dom.appendChild(el5, el6);
        var el6 = dom.createComment("");
        dom.appendChild(el5, el6);
        var el6 = dom.createComment("");
        dom.appendChild(el5, el6);
        var el6 = dom.createComment("");
        dom.appendChild(el5, el6);
        var el6 = dom.createComment("");
        dom.appendChild(el5, el6);
        var el6 = dom.createComment("");
        dom.appendChild(el5, el6);
        var el6 = dom.createComment("");
        dom.appendChild(el5, el6);
        var el6 = dom.createTextNode("        ");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n");
        dom.appendChild(el4, el5);
        var el5 = dom.createComment("");
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createComment(" /.navbar-collapse ");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createComment(" /.container-fluid ");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "container-fluid");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("br");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("br");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("br");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "footer yarn-ui-footer");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("a");
        dom.setAttribute(el3, "target", "_blank");
        var el4 = dom.createTextNode("\n      Licensed under the Apache License, Version 2.0.\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "ui-info");
        var el4 = dom.createTextNode("\n");
        dom.appendChild(el3, el4);
        var el4 = dom.createComment("");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "yarn-cluster-info");
        var el3 = dom.createTextNode("\n");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element3 = dom.childAt(fragment, [1]);
        var element4 = dom.childAt(element3, [1, 1, 7]);
        var element5 = dom.childAt(element4, [1]);
        var element6 = dom.childAt(fragment, [3]);
        var element7 = dom.childAt(element6, [1]);
        var element8 = dom.childAt(element7, [1]);
        var morphs = new Array(13);
        morphs[0] = dom.createMorphAt(element5, 1, 1);
        morphs[1] = dom.createMorphAt(element5, 2, 2);
        morphs[2] = dom.createMorphAt(element5, 3, 3);
        morphs[3] = dom.createMorphAt(element5, 4, 4);
        morphs[4] = dom.createMorphAt(element5, 5, 5);
        morphs[5] = dom.createMorphAt(element5, 6, 6);
        morphs[6] = dom.createMorphAt(element5, 7, 7);
        morphs[7] = dom.createMorphAt(element4, 3, 3);
        morphs[8] = dom.createMorphAt(dom.childAt(element3, [3]), 1, 1);
        morphs[9] = dom.createAttrMorph(element8, 'href');
        morphs[10] = dom.createMorphAt(dom.childAt(element7, [3]), 1, 1);
        morphs[11] = dom.createMorphAt(dom.childAt(element6, [3]), 1, 1);
        morphs[12] = dom.createMorphAt(fragment, 5, 5, contextualElement);
        return morphs;
      },
      statements: [["block", "link-to", ["cluster-overview"], ["tagName", "li"], 0, null, ["loc", [null, [39, 10], [43, 22]]]], ["block", "link-to", ["yarn-queues", "root"], ["tagName", "li", "class", ["subexpr", "concat", [["subexpr", "if", [["get", "isQueuesTabActive", [], 0, 0, 0, 0], "active"], [], [], 0, 0], " "], [], [], 0, 0]], 1, null, ["loc", [null, [44, 10], [48, 22]]]], ["block", "link-to", ["yarn-apps.apps"], ["tagName", "li", "current-when", "yarn-apps.apps"], 2, null, ["loc", [null, [49, 10], [53, 22]]]], ["block", "link-to", ["yarn-services"], ["tagName", "li"], 3, null, ["loc", [null, [54, 10], [58, 22]]]], ["block", "link-to", ["yarn-flow-activity"], ["tagName", "li", "disabled", ["subexpr", "@mut", [["get", "isTimelineUnHealthy", ["loc", [null, [59, 64], [59, 83]]], 0, 0, 0, 0]], [], [], 0, 0]], 4, null, ["loc", [null, [59, 10], [63, 22]]]], ["block", "link-to", ["yarn-nodes.table"], ["tagName", "li", "current-when", "yarn-nodes.table yarn-nodes.heatmap"], 5, null, ["loc", [null, [64, 10], [68, 22]]]], ["block", "link-to", ["yarn-tools.yarn-conf"], ["tagName", "li"], 6, null, ["loc", [null, [69, 10], [73, 22]]]], ["block", "if", [["get", "userInfo", ["loc", [null, [75, 14], [75, 22]]], 0, 0, 0, 0]], [], 7, null, ["loc", [null, [75, 8], [79, 15]]]], ["content", "outlet", ["loc", [null, [85, 4], [85, 14]]], 0, 0, 0, 0], ["attribute", "href", ["get", "env.app.hrefs.license", ["loc", [null, [95, 14], [95, 35]]], 0, 0, 0, 0], 0, 0, 0, 0], ["block", "if", [["get", "env.app.timezone", ["loc", [null, [99, 12], [99, 28]]], 0, 0, 0, 0]], [], 8, null, ["loc", [null, [99, 6], [101, 13]]]], ["block", "if", [["get", "clusterInfo", ["loc", [null, [105, 10], [105, 21]]], 0, 0, 0, 0]], [], 9, null, ["loc", [null, [105, 4], [113, 11]]]], ["content", "info-tooltip", ["loc", [null, [117, 0], [117, 16]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0, child1, child2, child3, child4, child5, child6, child7, child8, child9]
    };
  })());
});
define("yarn-ui/templates/cluster-overview", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 78,
                "column": 2
              },
              "end": {
                "line": 96,
                "column": 2
              }
            },
            "moduleName": "yarn-ui/templates/cluster-overview.hbs"
          },
          isEmpty: false,
          arity: 2,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("div");
            dom.setAttribute(el1, "class", "col-lg-4 container-fluid");
            var el2 = dom.createTextNode("\n    ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("div");
            dom.setAttribute(el2, "class", "panel panel-default");
            var el3 = dom.createTextNode("\n      ");
            dom.appendChild(el2, el3);
            var el3 = dom.createElement("div");
            dom.setAttribute(el3, "class", "panel-heading");
            var el4 = dom.createTextNode("\n        [");
            dom.appendChild(el3, el4);
            var el4 = dom.createComment("");
            dom.appendChild(el3, el4);
            var el4 = dom.createTextNode("] Cluster Resource Usage By Leaf Queues\n      ");
            dom.appendChild(el3, el4);
            dom.appendChild(el2, el3);
            var el3 = dom.createTextNode("\n\n      ");
            dom.appendChild(el2, el3);
            var el3 = dom.createElement("div");
            dom.setAttribute(el3, "class", "container-fluid donut-chart");
            var el4 = dom.createTextNode("\n        ");
            dom.appendChild(el3, el4);
            var el4 = dom.createComment("");
            dom.appendChild(el3, el4);
            var el4 = dom.createTextNode("\n      ");
            dom.appendChild(el3, el4);
            dom.appendChild(el2, el3);
            var el3 = dom.createTextNode("\n      ");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n    ");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var element2 = dom.childAt(fragment, [1, 1]);
            var element3 = dom.childAt(element2, [3]);
            var morphs = new Array(3);
            morphs[0] = dom.createMorphAt(dom.childAt(element2, [1]), 1, 1);
            morphs[1] = dom.createAttrMorph(element3, 'id');
            morphs[2] = dom.createMorphAt(element3, 1, 1);
            return morphs;
          },
          statements: [["content", "partition", ["loc", [null, [82, 9], [82, 22]]], 0, 0, 0, 0], ["attribute", "id", ["concat", ["queueusage-donut-chart-", ["get", "index", ["loc", [null, [85, 76], [85, 81]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["inline", "queue-usage-donut-chart", [], ["data", ["subexpr", "@mut", [["get", "model.queues", ["loc", [null, [86, 39], [86, 51]]], 0, 0, 0, 0]], [], [], 0, 0], "showLabels", true, "parentIdPrefix", "queueusage-donut-chart-", "id", ["subexpr", "@mut", [["get", "index", ["loc", [null, [89, 11], [89, 16]]], 0, 0, 0, 0]], [], [], 0, 0], "ratio", 0.5, "maxHeight", 350, "partition", ["subexpr", "@mut", [["get", "partition", ["loc", [null, [92, 18], [92, 27]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [86, 8], [92, 29]]], 0, 0]],
          locals: ["partition", "index"],
          templates: []
        };
      })();
      var child1 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 104,
                  "column": 6
                },
                "end": {
                  "line": 126,
                  "column": 6
                }
              },
              "moduleName": "yarn-ui/templates/cluster-overview.hbs"
            },
            isEmpty: false,
            arity: 1,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createTextNode("        ");
              dom.appendChild(el0, el1);
              var el1 = dom.createElement("div");
              dom.setAttribute(el1, "class", "col-lg-4 container-fluid");
              var el2 = dom.createTextNode("\n          ");
              dom.appendChild(el1, el2);
              var el2 = dom.createElement("div");
              dom.setAttribute(el2, "class", "panel panel-default");
              var el3 = dom.createTextNode("\n            ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("div");
              dom.setAttribute(el3, "class", "panel-heading");
              var el4 = dom.createTextNode("\n              ");
              dom.appendChild(el3, el4);
              var el4 = dom.createComment("");
              dom.appendChild(el3, el4);
              var el4 = dom.createTextNode(" - Usages\n            ");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n            ");
              dom.appendChild(el2, el3);
              var el3 = dom.createElement("div");
              dom.setAttribute(el3, "class", "container-fluid");
              var el4 = dom.createTextNode("\n              ");
              dom.appendChild(el3, el4);
              var el4 = dom.createComment("");
              dom.appendChild(el3, el4);
              var el4 = dom.createTextNode("\n            ");
              dom.appendChild(el3, el4);
              dom.appendChild(el2, el3);
              var el3 = dom.createTextNode("\n          ");
              dom.appendChild(el2, el3);
              dom.appendChild(el1, el2);
              var el2 = dom.createTextNode("\n        ");
              dom.appendChild(el1, el2);
              dom.appendChild(el0, el1);
              var el1 = dom.createTextNode("\n");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var element0 = dom.childAt(fragment, [1, 1]);
              var element1 = dom.childAt(element0, [3]);
              var morphs = new Array(3);
              morphs[0] = dom.createMorphAt(dom.childAt(element0, [1]), 1, 1);
              morphs[1] = dom.createAttrMorph(element1, 'id');
              morphs[2] = dom.createMorphAt(element1, 1, 1);
              return morphs;
            },
            statements: [["content", "perTypeUsage.name", ["loc", [null, [109, 14], [109, 35]]], 0, 0, 0, 0], ["attribute", "id", ["concat", ["resource-type-", ["get", "perTypeUsage.id", ["loc", [null, [111, 61], [111, 76]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["inline", "donut-chart", [], ["data", ["subexpr", "@mut", [["get", "perTypeUsage.data", ["loc", [null, [113, 21], [113, 38]]], 0, 0, 0, 0]], [], [], 0, 0], "showLabels", true, "parentIdPrefix", "resource-type-", "id", ["subexpr", "@mut", [["get", "perTypeUsage.id", ["loc", [null, [116, 19], [116, 34]]], 0, 0, 0, 0]], [], [], 0, 0], "ratio", 0.6, "unit", ["subexpr", "@mut", [["get", "perTypeUsage.unit", ["loc", [null, [118, 21], [118, 38]]], 0, 0, 0, 0]], [], [], 0, 0], "type", "resource", "maxHeight", 350, "colorTargets", "good", "colorTargetReverse", true], ["loc", [null, [112, 14], [122, 41]]], 0, 0]],
            locals: ["perTypeUsage"],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 103,
                "column": 4
              },
              "end": {
                "line": 127,
                "column": 4
              }
            },
            "moduleName": "yarn-ui/templates/cluster-overview.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
            dom.insertBoundary(fragment, 0);
            dom.insertBoundary(fragment, null);
            return morphs;
          },
          statements: [["block", "each", [["get", "model.clusterMetrics.firstObject.getAllResourceTypesDonutChart", ["loc", [null, [105, 8], [105, 70]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [104, 6], [126, 15]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      var child2 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 127,
                "column": 4
              },
              "end": {
                "line": 164,
                "column": 4
              }
            },
            "moduleName": "yarn-ui/templates/cluster-overview.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("div");
            dom.setAttribute(el1, "class", "col-lg-4 container-fluid");
            var el2 = dom.createTextNode("\n        ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("div");
            dom.setAttribute(el2, "class", "panel panel-default");
            var el3 = dom.createTextNode("\n          ");
            dom.appendChild(el2, el3);
            var el3 = dom.createElement("div");
            dom.setAttribute(el3, "class", "panel-heading");
            var el4 = dom.createTextNode("\n            Resource - Memory\n          ");
            dom.appendChild(el3, el4);
            dom.appendChild(el2, el3);
            var el3 = dom.createTextNode("\n          ");
            dom.appendChild(el2, el3);
            var el3 = dom.createElement("div");
            dom.setAttribute(el3, "class", "container-fluid");
            dom.setAttribute(el3, "id", "mem-donut-chart");
            var el4 = dom.createTextNode("\n            ");
            dom.appendChild(el3, el4);
            var el4 = dom.createComment("");
            dom.appendChild(el3, el4);
            var el4 = dom.createTextNode("\n          ");
            dom.appendChild(el3, el4);
            dom.appendChild(el2, el3);
            var el3 = dom.createTextNode("\n        ");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n      ");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n\n      ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("div");
            dom.setAttribute(el1, "class", "col-lg-4 container-fluid");
            var el2 = dom.createTextNode("\n        ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("div");
            dom.setAttribute(el2, "class", "panel panel-default");
            var el3 = dom.createTextNode("\n          ");
            dom.appendChild(el2, el3);
            var el3 = dom.createElement("div");
            dom.setAttribute(el3, "class", "panel-heading");
            var el4 = dom.createTextNode("\n            Resource - VCores\n          ");
            dom.appendChild(el3, el4);
            dom.appendChild(el2, el3);
            var el3 = dom.createTextNode("\n          ");
            dom.appendChild(el2, el3);
            var el3 = dom.createElement("div");
            dom.setAttribute(el3, "class", "container-fluid");
            dom.setAttribute(el3, "id", "vcore-donut-chart");
            var el4 = dom.createTextNode("\n            ");
            dom.appendChild(el3, el4);
            var el4 = dom.createComment("");
            dom.appendChild(el3, el4);
            var el4 = dom.createTextNode("\n          ");
            dom.appendChild(el3, el4);
            dom.appendChild(el2, el3);
            var el3 = dom.createTextNode("\n        ");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n      ");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(2);
            morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1, 1, 3]), 1, 1);
            morphs[1] = dom.createMorphAt(dom.childAt(fragment, [3, 1, 3]), 1, 1);
            return morphs;
          },
          statements: [["inline", "donut-chart", [], ["data", ["subexpr", "@mut", [["get", "model.clusterMetrics.firstObject.getMemoryDataForDonutChart", ["loc", [null, [135, 19], [135, 78]]], 0, 0, 0, 0]], [], [], 0, 0], "showLabels", true, "parentId", "mem-donut-chart", "ratio", 0.6, "maxHeight", 350, "colorTargets", "good", "colorTargetReverse", true, "type", "memory"], ["loc", [null, [134, 12], [142, 29]]], 0, 0], ["inline", "donut-chart", [], ["data", ["subexpr", "@mut", [["get", "model.clusterMetrics.firstObject.getVCoreDataForDonutChart", ["loc", [null, [154, 19], [154, 77]]], 0, 0, 0, 0]], [], [], 0, 0], "showLabels", true, "parentId", "vcore-donut-chart", "ratio", 0.6, "maxHeight", 350, "colorTargets", "good", "colorTargetReverse", true], ["loc", [null, [153, 12], [160, 39]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 21,
              "column": 0
            },
            "end": {
              "line": 186,
              "column": 0
            }
          },
          "moduleName": "yarn-ui/templates/cluster-overview.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "col-md-12 container-fluid");
          var el2 = dom.createTextNode("\n  ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("h3");
          var el3 = dom.createTextNode("Applications");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n  ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          dom.setAttribute(el2, "class", "row");
          var el3 = dom.createTextNode("\n    ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("div");
          dom.setAttribute(el3, "class", "col-lg-6 container-fluid");
          var el4 = dom.createTextNode("\n      ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("div");
          dom.setAttribute(el4, "class", "panel panel-default");
          var el5 = dom.createTextNode("\n        ");
          dom.appendChild(el4, el5);
          var el5 = dom.createElement("div");
          dom.setAttribute(el5, "class", "panel-heading");
          var el6 = dom.createTextNode("\n          Cluster Resource Usage By Applications\n        ");
          dom.appendChild(el5, el6);
          dom.appendChild(el4, el5);
          var el5 = dom.createTextNode("\n        ");
          dom.appendChild(el4, el5);
          var el5 = dom.createElement("div");
          dom.setAttribute(el5, "class", "container-fluid donut-chart");
          dom.setAttribute(el5, "id", "appusage-donut-chart");
          var el6 = dom.createTextNode("\n          ");
          dom.appendChild(el5, el6);
          var el6 = dom.createComment("");
          dom.appendChild(el5, el6);
          var el6 = dom.createTextNode("\n        ");
          dom.appendChild(el5, el6);
          dom.appendChild(el4, el5);
          var el5 = dom.createTextNode("\n      ");
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n    ");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n  ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n\n  ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          dom.setAttribute(el2, "class", "row");
          var el3 = dom.createTextNode("\n    ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("div");
          dom.setAttribute(el3, "class", "col-lg-4 container-fluid");
          var el4 = dom.createTextNode("\n      ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("div");
          dom.setAttribute(el4, "class", "panel panel-default");
          var el5 = dom.createTextNode("\n        ");
          dom.appendChild(el4, el5);
          var el5 = dom.createElement("div");
          dom.setAttribute(el5, "class", "panel-heading");
          var el6 = dom.createTextNode("\n          Finished Apps From All Users\n        ");
          dom.appendChild(el5, el6);
          dom.appendChild(el4, el5);
          var el5 = dom.createTextNode("\n        ");
          dom.appendChild(el4, el5);
          var el5 = dom.createElement("div");
          dom.setAttribute(el5, "class", "container-fluid");
          dom.setAttribute(el5, "id", "finishedapps-donut-chart");
          var el6 = dom.createTextNode("\n          ");
          dom.appendChild(el5, el6);
          var el6 = dom.createComment("");
          dom.appendChild(el5, el6);
          var el6 = dom.createTextNode("\n        ");
          dom.appendChild(el5, el6);
          dom.appendChild(el4, el5);
          var el5 = dom.createTextNode("\n      ");
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n    ");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n\n    ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("div");
          dom.setAttribute(el3, "class", "col-lg-4 container-fluid");
          var el4 = dom.createTextNode("\n      ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("div");
          dom.setAttribute(el4, "class", "panel panel-default");
          var el5 = dom.createTextNode("\n        ");
          dom.appendChild(el4, el5);
          var el5 = dom.createElement("div");
          dom.setAttribute(el5, "class", "panel-heading");
          var el6 = dom.createTextNode("\n          Running Apps From All Users\n        ");
          dom.appendChild(el5, el6);
          dom.appendChild(el4, el5);
          var el5 = dom.createTextNode("\n        ");
          dom.appendChild(el4, el5);
          var el5 = dom.createElement("div");
          dom.setAttribute(el5, "class", "container-fluid");
          dom.setAttribute(el5, "id", "runningapps-donut-chart");
          var el6 = dom.createTextNode("\n          ");
          dom.appendChild(el5, el6);
          var el6 = dom.createComment("");
          dom.appendChild(el5, el6);
          var el6 = dom.createTextNode("\n        ");
          dom.appendChild(el5, el6);
          dom.appendChild(el4, el5);
          var el5 = dom.createTextNode("\n      ");
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n    ");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n  ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n\n  ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("h3");
          var el3 = dom.createTextNode("Partitions");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n  ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          dom.setAttribute(el2, "class", "row");
          var el3 = dom.createTextNode("\n");
          dom.appendChild(el2, el3);
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("  ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n\n  ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("h3");
          var el3 = dom.createTextNode("Resources");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n  ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          dom.setAttribute(el2, "class", "row");
          var el3 = dom.createTextNode("\n    ");
          dom.appendChild(el2, el3);
          var el3 = dom.createComment(" When getAllResourceTypesDonutChart is not null, use it to show per-resource-type usages. Otherwise only show\n         vcore/memory usage from metrics ");
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n");
          dom.appendChild(el2, el3);
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("  ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n\n  ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          dom.setAttribute(el2, "class", "row");
          var el3 = dom.createTextNode("\n    ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("div");
          dom.setAttribute(el3, "class", "col-lg-6 container-fluid");
          var el4 = dom.createTextNode("\n      ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("div");
          dom.setAttribute(el4, "class", "panel panel-default");
          var el5 = dom.createTextNode("\n        ");
          dom.appendChild(el4, el5);
          var el5 = dom.createElement("div");
          dom.setAttribute(el5, "class", "panel-heading");
          var el6 = dom.createTextNode("\n          Node Managers\n        ");
          dom.appendChild(el5, el6);
          dom.appendChild(el4, el5);
          var el5 = dom.createTextNode("\n        ");
          dom.appendChild(el4, el5);
          var el5 = dom.createElement("div");
          dom.setAttribute(el5, "class", "container-fluid");
          dom.setAttribute(el5, "id", "nodes-donut-chart");
          var el6 = dom.createTextNode("\n          ");
          dom.appendChild(el5, el6);
          var el6 = dom.createComment("");
          dom.appendChild(el5, el6);
          var el6 = dom.createTextNode("\n        ");
          dom.appendChild(el5, el6);
          dom.appendChild(el4, el5);
          var el5 = dom.createTextNode("\n      ");
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n    ");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n  ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element4 = dom.childAt(fragment, [1]);
          var element5 = dom.childAt(element4, [5]);
          var morphs = new Array(6);
          morphs[0] = dom.createMorphAt(dom.childAt(element4, [3, 1, 1, 3]), 1, 1);
          morphs[1] = dom.createMorphAt(dom.childAt(element5, [1, 1, 3]), 1, 1);
          morphs[2] = dom.createMorphAt(dom.childAt(element5, [3, 1, 3]), 1, 1);
          morphs[3] = dom.createMorphAt(dom.childAt(element4, [9]), 1, 1);
          morphs[4] = dom.createMorphAt(dom.childAt(element4, [13]), 3, 3);
          morphs[5] = dom.createMorphAt(dom.childAt(element4, [15, 1, 1, 3]), 1, 1);
          return morphs;
        },
        statements: [["inline", "app-usage-donut-chart", [], ["data", ["subexpr", "@mut", [["get", "model.apps", ["loc", [null, [32, 39], [32, 49]]], 0, 0, 0, 0]], [], [], 0, 0], "showLabels", true, "parentId", "appusage-donut-chart", "ratio", 0.5, "maxHeight", 500], ["loc", [null, [32, 10], [36, 25]]], 0, 0], ["inline", "donut-chart", [], ["data", ["subexpr", "@mut", [["get", "model.clusterMetrics.firstObject.getFinishedAppsDataForDonutChart", ["loc", [null, [49, 29], [49, 94]]], 0, 0, 0, 0]], [], [], 0, 0], "showLabels", true, "parentId", "finishedapps-donut-chart", "ratio", 0.6, "maxHeight", 350, "colorTargets", "good warn error"], ["loc", [null, [49, 10], [54, 42]]], 0, 0], ["inline", "donut-chart", [], ["data", ["subexpr", "@mut", [["get", "model.clusterMetrics.firstObject.getRunningAppsDataForDonutChart", ["loc", [null, [65, 29], [65, 93]]], 0, 0, 0, 0]], [], [], 0, 0], "showLabels", true, "parentId", "runningapps-donut-chart", "ratio", 0.6, "maxHeight", 350, "colorTargets", "warn good"], ["loc", [null, [65, 10], [70, 36]]], 0, 0], ["block", "each", [["get", "model.queues.firstObject.partitions", ["loc", [null, [78, 10], [78, 45]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [78, 2], [96, 11]]]], ["block", "if", [["get", "model.clusterMetrics.firstObject.getAllResourceTypesDonutChart", ["loc", [null, [103, 10], [103, 72]]], 0, 0, 0, 0]], [], 1, 2, ["loc", [null, [103, 4], [164, 11]]]], ["inline", "donut-chart", [], ["data", ["subexpr", "@mut", [["get", "model.clusterMetrics.firstObject.getNodesDataForDonutChart", ["loc", [null, [174, 29], [174, 87]]], 0, 0, 0, 0]], [], [], 0, 0], "showLabels", true, "parentId", "nodes-donut-chart", "ratio", 0.6, "maxHeight", 350, "colorTargets", "good error warn"], ["loc", [null, [174, 10], [179, 42]]], 0, 0]],
        locals: [],
        templates: [child0, child1, child2]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 190,
            "column": 0
          }
        },
        "moduleName": "yarn-ui/templates/cluster-overview.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 5, 5, contextualElement);
        return morphs;
      },
      statements: [["inline", "breadcrumb-bar", [], ["breadcrumbs", ["subexpr", "@mut", [["get", "breadcrumbs", ["loc", [null, [19, 29], [19, 40]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [19, 0], [19, 42]]], 0, 0], ["block", "if", [["get", "model", ["loc", [null, [21, 6], [21, 11]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [21, 0], [186, 7]]]], ["content", "outlet", ["loc", [null, [189, 0], [189, 10]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define("yarn-ui/templates/components/app-attempt-table", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 29,
              "column": 4
            },
            "end": {
              "line": 34,
              "column": 4
            }
          },
          "moduleName": "yarn-ui/templates/components/app-attempt-table.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("tr");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createTextNode("Finished Time");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1, 3]), 0, 0);
          return morphs;
        },
        statements: [["content", "attempt.validatedFinishedTs", ["loc", [null, [32, 10], [32, 41]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 47,
              "column": 4
            },
            "end": {
              "line": 52,
              "column": 4
            }
          },
          "moduleName": "yarn-ui/templates/components/app-attempt-table.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("tr");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createTextNode("Attempt State");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1, 3]), 0, 0);
          return morphs;
        },
        statements: [["content", "attempt.attemptState", ["loc", [null, [50, 10], [50, 34]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child2 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 53,
              "column": 4
            },
            "end": {
              "line": 58,
              "column": 4
            }
          },
          "moduleName": "yarn-ui/templates/components/app-attempt-table.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("tr");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createTextNode("AM Node Web UI");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createElement("a");
          var el4 = dom.createComment("");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element2 = dom.childAt(fragment, [1, 3]);
          var element3 = dom.childAt(element2, [0]);
          var morphs = new Array(3);
          morphs[0] = dom.createAttrMorph(element2, 'title');
          morphs[1] = dom.createAttrMorph(element3, 'href');
          morphs[2] = dom.createMorphAt(element3, 0, 0);
          return morphs;
        },
        statements: [["attribute", "title", ["concat", [["get", "attempt.nodeHttpAddress", ["loc", [null, [56, 19], [56, 42]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["attribute", "href", ["concat", [["get", "attempt.masterNodeURL", ["loc", [null, [56, 57], [56, 78]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["content", "attempt.nodeHttpAddress", ["loc", [null, [56, 82], [56, 109]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child3 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 59,
              "column": 4
            },
            "end": {
              "line": 64,
              "column": 4
            }
          },
          "moduleName": "yarn-ui/templates/components/app-attempt-table.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("tr");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createTextNode("Exposed Ports");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element1 = dom.childAt(fragment, [1, 3]);
          var morphs = new Array(2);
          morphs[0] = dom.createAttrMorph(element1, 'title');
          morphs[1] = dom.createMorphAt(element1, 0, 0);
          return morphs;
        },
        statements: [["attribute", "title", ["concat", [["get", "attempt.exposedPorts", ["loc", [null, [62, 19], [62, 39]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["content", "attempt.exposedPorts", ["loc", [null, [62, 43], [62, 67]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child4 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 65,
              "column": 4
            },
            "end": {
              "line": 72,
              "column": 4
            }
          },
          "moduleName": "yarn-ui/templates/components/app-attempt-table.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("tr");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createTextNode("Logs");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createTextNode("\n        ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("a");
          var el4 = dom.createTextNode("Link");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n      ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1, 3, 1]);
          var morphs = new Array(1);
          morphs[0] = dom.createAttrMorph(element0, 'href');
          return morphs;
        },
        statements: [["attribute", "href", ["concat", [["get", "attempt.appAttemptContainerLogsURL", ["loc", [null, [69, 19], [69, 53]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child5 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 73,
              "column": 4
            },
            "end": {
              "line": 78,
              "column": 4
            }
          },
          "moduleName": "yarn-ui/templates/components/app-attempt-table.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("tr");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createTextNode("Diagnostics Info");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1, 3]), 0, 0);
          return morphs;
        },
        statements: [["content", "attempt.diagnosticsInfo", ["loc", [null, [76, 10], [76, 37]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 81,
            "column": 0
          }
        },
        "moduleName": "yarn-ui/templates/components/app-attempt-table.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("table");
        dom.setAttribute(el1, "id", "app-attempt-table");
        dom.setAttribute(el1, "class", "table table-striped table-bordered");
        dom.setAttribute(el1, "cellspacing", "0");
        dom.setAttribute(el1, "width", "100%");
        dom.setAttribute(el1, "height", "100%");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("tbody");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("tr");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("td");
        var el5 = dom.createTextNode("Application Attempt Id");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("td");
        var el5 = dom.createComment("");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("tr");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("td");
        var el5 = dom.createTextNode("Started Time");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("td");
        var el5 = dom.createComment("");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("tr");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("td");
        var el5 = dom.createTextNode("Elapsed Time");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("td");
        var el5 = dom.createComment("");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("tr");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("td");
        var el5 = dom.createTextNode("AM Container Id");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("td");
        var el5 = dom.createComment("");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("tr");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("td");
        var el5 = dom.createTextNode("AM Node Id");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("td");
        var el5 = dom.createComment("");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element4 = dom.childAt(fragment, [1, 1]);
        var element5 = dom.childAt(element4, [1, 3]);
        var element6 = dom.childAt(element4, [9, 3]);
        var element7 = dom.childAt(element4, [11, 3]);
        var morphs = new Array(14);
        morphs[0] = dom.createAttrMorph(element5, 'title');
        morphs[1] = dom.createMorphAt(element5, 0, 0);
        morphs[2] = dom.createMorphAt(dom.childAt(element4, [3, 3]), 0, 0);
        morphs[3] = dom.createMorphAt(element4, 5, 5);
        morphs[4] = dom.createMorphAt(dom.childAt(element4, [7, 3]), 0, 0);
        morphs[5] = dom.createAttrMorph(element6, 'title');
        morphs[6] = dom.createMorphAt(element6, 0, 0);
        morphs[7] = dom.createAttrMorph(element7, 'title');
        morphs[8] = dom.createMorphAt(element7, 0, 0);
        morphs[9] = dom.createMorphAt(element4, 13, 13);
        morphs[10] = dom.createMorphAt(element4, 14, 14);
        morphs[11] = dom.createMorphAt(element4, 15, 15);
        morphs[12] = dom.createMorphAt(element4, 16, 16);
        morphs[13] = dom.createMorphAt(element4, 17, 17);
        return morphs;
      },
      statements: [["attribute", "title", ["concat", [["get", "attempt.id", ["loc", [null, [23, 19], [23, 29]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["content", "attempt.id", ["loc", [null, [23, 33], [23, 47]]], 0, 0, 0, 0], ["content", "attempt.attemptStartedTime", ["loc", [null, [27, 10], [27, 40]]], 0, 0, 0, 0], ["block", "if", [["get", "attempt.validatedFinishedTs", ["loc", [null, [29, 10], [29, 37]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [29, 4], [34, 11]]]], ["content", "attempt.elapsedTime", ["loc", [null, [37, 10], [37, 33]]], 0, 0, 0, 0], ["attribute", "title", ["concat", [["get", "attempt.appMasterContainerId", ["loc", [null, [41, 19], [41, 47]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["content", "attempt.appMasterContainerId", ["loc", [null, [41, 51], [41, 83]]], 0, 0, 0, 0], ["attribute", "title", ["concat", [["get", "attempt.amNodeId", ["loc", [null, [45, 19], [45, 35]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["content", "attempt.amNodeId", ["loc", [null, [45, 39], [45, 59]]], 0, 0, 0, 0], ["block", "if", [["get", "attempt.attemptState", ["loc", [null, [47, 10], [47, 30]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [47, 4], [52, 11]]]], ["block", "if", [["get", "attempt.nodeHttpAddress", ["loc", [null, [53, 10], [53, 33]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [53, 4], [58, 11]]]], ["block", "if", [["get", "attempt.exposedPorts", ["loc", [null, [59, 10], [59, 30]]], 0, 0, 0, 0]], [], 3, null, ["loc", [null, [59, 4], [64, 11]]]], ["block", "if", [["get", "attempt.appAttemptContainerLogsURL", ["loc", [null, [65, 10], [65, 44]]], 0, 0, 0, 0]], [], 4, null, ["loc", [null, [65, 4], [72, 11]]]], ["block", "if", [["get", "attempt.diagnosticsInfo", ["loc", [null, [73, 10], [73, 33]]], 0, 0, 0, 0]], [], 5, null, ["loc", [null, [73, 4], [78, 11]]]]],
      locals: [],
      templates: [child0, child1, child2, child3, child4, child5]
    };
  })());
});
define("yarn-ui/templates/components/app-table", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 39,
                "column": 6
              },
              "end": {
                "line": 61,
                "column": 6
              }
            },
            "moduleName": "yarn-ui/templates/components/app-table.hbs"
          },
          isEmpty: false,
          arity: 1,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("        ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("tr");
            var el2 = dom.createTextNode("\n          ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("td");
            var el3 = dom.createElement("a");
            var el4 = dom.createComment("");
            dom.appendChild(el3, el4);
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n          ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("td");
            var el3 = dom.createComment("");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n          ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("td");
            var el3 = dom.createComment("");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n          ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("td");
            var el3 = dom.createComment("");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n          ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("td");
            var el3 = dom.createComment("");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n          ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("td");
            var el3 = dom.createComment("");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n          ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("td");
            var el3 = dom.createElement("span");
            var el4 = dom.createComment("");
            dom.appendChild(el3, el4);
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n          ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("td");
            var el3 = dom.createComment("");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n          ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("td");
            var el3 = dom.createComment("");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n          ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("td");
            var el3 = dom.createComment("");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n          ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("td");
            var el3 = dom.createComment("");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n          ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("td");
            var el3 = dom.createTextNode("\n            ");
            dom.appendChild(el2, el3);
            var el3 = dom.createElement("div");
            dom.setAttribute(el3, "class", "progress");
            dom.setAttribute(el3, "style", "margin-bottom: 0;");
            var el4 = dom.createTextNode("\n              ");
            dom.appendChild(el3, el4);
            var el4 = dom.createElement("div");
            dom.setAttribute(el4, "class", "progress-bar");
            dom.setAttribute(el4, "role", "progressbar");
            dom.setAttribute(el4, "aria-valuenow", "60");
            dom.setAttribute(el4, "aria-valuemin", "0");
            dom.setAttribute(el4, "aria-valuemax", "100");
            var el5 = dom.createTextNode("\n                ");
            dom.appendChild(el4, el5);
            var el5 = dom.createComment("");
            dom.appendChild(el4, el5);
            var el5 = dom.createTextNode("%\n              ");
            dom.appendChild(el4, el5);
            dom.appendChild(el3, el4);
            var el4 = dom.createTextNode("\n            ");
            dom.appendChild(el3, el4);
            dom.appendChild(el2, el3);
            var el3 = dom.createTextNode("\n          ");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n          ");
            dom.appendChild(el1, el2);
            var el2 = dom.createElement("td");
            var el3 = dom.createComment("");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            var el2 = dom.createTextNode("\n        ");
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var element4 = dom.childAt(fragment, [1]);
            var element5 = dom.childAt(element4, [1, 0]);
            var element6 = dom.childAt(element4, [13, 0]);
            var element7 = dom.childAt(element4, [23, 1, 1]);
            var morphs = new Array(16);
            morphs[0] = dom.createAttrMorph(element5, 'href');
            morphs[1] = dom.createMorphAt(element5, 0, 0);
            morphs[2] = dom.createMorphAt(dom.childAt(element4, [3]), 0, 0);
            morphs[3] = dom.createMorphAt(dom.childAt(element4, [5]), 0, 0);
            morphs[4] = dom.createMorphAt(dom.childAt(element4, [7]), 0, 0);
            morphs[5] = dom.createMorphAt(dom.childAt(element4, [9]), 0, 0);
            morphs[6] = dom.createMorphAt(dom.childAt(element4, [11]), 0, 0);
            morphs[7] = dom.createAttrMorph(element6, 'class');
            morphs[8] = dom.createMorphAt(element6, 0, 0);
            morphs[9] = dom.createMorphAt(dom.childAt(element4, [15]), 0, 0);
            morphs[10] = dom.createMorphAt(dom.childAt(element4, [17]), 0, 0);
            morphs[11] = dom.createMorphAt(dom.childAt(element4, [19]), 0, 0);
            morphs[12] = dom.createMorphAt(dom.childAt(element4, [21]), 0, 0);
            morphs[13] = dom.createAttrMorph(element7, 'style');
            morphs[14] = dom.createMorphAt(element7, 1, 1);
            morphs[15] = dom.createMorphAt(dom.childAt(element4, [25]), 0, 0);
            return morphs;
          },
          statements: [["attribute", "href", ["concat", ["#/yarn-app/", ["get", "app.id", ["loc", [null, [41, 36], [41, 42]]], 0, 0, 0, 0], "/info"], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["content", "app.id", ["loc", [null, [41, 51], [41, 61]]], 0, 0, 0, 0], ["content", "app.applicationType", ["loc", [null, [42, 14], [42, 37]]], 0, 0, 0, 0], ["content", "app.appName", ["loc", [null, [43, 14], [43, 29]]], 0, 0, 0, 0], ["content", "app.user", ["loc", [null, [44, 14], [44, 26]]], 0, 0, 0, 0], ["content", "app.queue", ["loc", [null, [45, 14], [45, 27]]], 0, 0, 0, 0], ["content", "app.state", ["loc", [null, [46, 14], [46, 27]]], 0, 0, 0, 0], ["attribute", "class", ["get", "app.finalStatusStyle", ["loc", [null, [47, 28], [47, 48]]], 0, 0, 0, 0], 0, 0, 0, 0], ["content", "app.finalStatus", ["loc", [null, [47, 51], [47, 70]]], 0, 0, 0, 0], ["content", "app.startTime", ["loc", [null, [48, 14], [48, 31]]], 0, 0, 0, 0], ["content", "app.elapsedTime", ["loc", [null, [49, 14], [49, 33]]], 0, 0, 0, 0], ["content", "app.validatedFinishedTs", ["loc", [null, [50, 14], [50, 41]]], 0, 0, 0, 0], ["content", "app.priority", ["loc", [null, [51, 14], [51, 30]]], 0, 0, 0, 0], ["attribute", "style", ["get", "app.progressStyle", ["loc", [null, [54, 124], [54, 141]]], 0, 0, 0, 0], 0, 0, 0, 0], ["content", "app.progress", ["loc", [null, [55, 16], [55, 32]]], 0, 0, 0, 0], ["content", "app.clusterUsagePercentage", ["loc", [null, [59, 14], [59, 44]]], 0, 0, 0, 0]],
          locals: ["app"],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 38,
              "column": 4
            },
            "end": {
              "line": 62,
              "column": 4
            }
          },
          "moduleName": "yarn-ui/templates/components/app-table.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "each", [["get", "arr", ["loc", [null, [39, 14], [39, 17]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [39, 6], [61, 15]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 62,
              "column": 4
            },
            "end": {
              "line": 84,
              "column": 4
            }
          },
          "moduleName": "yarn-ui/templates/components/app-table.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("      ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("tr");
          var el2 = dom.createTextNode("\n          ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createElement("a");
          var el4 = dom.createComment("");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n          ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n          ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n          ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n          ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n          ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n          ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createElement("span");
          var el4 = dom.createComment("");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n          ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n          ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n          ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n          ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n          ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createTextNode("\n            ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("div");
          dom.setAttribute(el3, "class", "progress");
          dom.setAttribute(el3, "style", "margin-bottom: 0;");
          var el4 = dom.createTextNode("\n              ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("div");
          dom.setAttribute(el4, "class", "progress-bar");
          dom.setAttribute(el4, "role", "progressbar");
          dom.setAttribute(el4, "aria-valuenow", "60");
          dom.setAttribute(el4, "aria-valuemin", "0");
          dom.setAttribute(el4, "aria-valuemax", "100");
          var el5 = dom.createTextNode("\n                ");
          dom.appendChild(el4, el5);
          var el5 = dom.createComment("");
          dom.appendChild(el4, el5);
          var el5 = dom.createTextNode("%\n              ");
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n            ");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n          ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n          ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var element1 = dom.childAt(element0, [1, 0]);
          var element2 = dom.childAt(element0, [13, 0]);
          var element3 = dom.childAt(element0, [23, 1, 1]);
          var morphs = new Array(16);
          morphs[0] = dom.createAttrMorph(element1, 'href');
          morphs[1] = dom.createMorphAt(element1, 0, 0);
          morphs[2] = dom.createMorphAt(dom.childAt(element0, [3]), 0, 0);
          morphs[3] = dom.createMorphAt(dom.childAt(element0, [5]), 0, 0);
          morphs[4] = dom.createMorphAt(dom.childAt(element0, [7]), 0, 0);
          morphs[5] = dom.createMorphAt(dom.childAt(element0, [9]), 0, 0);
          morphs[6] = dom.createMorphAt(dom.childAt(element0, [11]), 0, 0);
          morphs[7] = dom.createAttrMorph(element2, 'class');
          morphs[8] = dom.createMorphAt(element2, 0, 0);
          morphs[9] = dom.createMorphAt(dom.childAt(element0, [15]), 0, 0);
          morphs[10] = dom.createMorphAt(dom.childAt(element0, [17]), 0, 0);
          morphs[11] = dom.createMorphAt(dom.childAt(element0, [19]), 0, 0);
          morphs[12] = dom.createMorphAt(dom.childAt(element0, [21]), 0, 0);
          morphs[13] = dom.createAttrMorph(element3, 'style');
          morphs[14] = dom.createMorphAt(element3, 1, 1);
          morphs[15] = dom.createMorphAt(dom.childAt(element0, [25]), 0, 0);
          return morphs;
        },
        statements: [["attribute", "href", ["concat", ["#/yarn-app/", ["get", "app.id", ["loc", [null, [64, 36], [64, 42]]], 0, 0, 0, 0], "/info"], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["content", "app.id", ["loc", [null, [64, 51], [64, 61]]], 0, 0, 0, 0], ["content", "app.applicationType", ["loc", [null, [65, 14], [65, 37]]], 0, 0, 0, 0], ["content", "app.appName", ["loc", [null, [66, 14], [66, 29]]], 0, 0, 0, 0], ["content", "app.user", ["loc", [null, [67, 14], [67, 26]]], 0, 0, 0, 0], ["content", "app.queue", ["loc", [null, [68, 14], [68, 27]]], 0, 0, 0, 0], ["content", "app.state", ["loc", [null, [69, 14], [69, 27]]], 0, 0, 0, 0], ["attribute", "class", ["get", "app.finalStatusStyle", ["loc", [null, [70, 28], [70, 48]]], 0, 0, 0, 0], 0, 0, 0, 0], ["content", "app.finalStatus", ["loc", [null, [70, 51], [70, 70]]], 0, 0, 0, 0], ["content", "app.startTime", ["loc", [null, [71, 14], [71, 31]]], 0, 0, 0, 0], ["content", "app.elapsedTime", ["loc", [null, [72, 14], [72, 33]]], 0, 0, 0, 0], ["content", "app.validatedFinishedTs", ["loc", [null, [73, 14], [73, 41]]], 0, 0, 0, 0], ["content", "app.priority", ["loc", [null, [74, 14], [74, 30]]], 0, 0, 0, 0], ["attribute", "style", ["get", "app.progressStyle", ["loc", [null, [77, 124], [77, 141]]], 0, 0, 0, 0], 0, 0, 0, 0], ["content", "app.progress", ["loc", [null, [78, 16], [78, 32]]], 0, 0, 0, 0], ["content", "app.clusterUsagePercentage", ["loc", [null, [82, 14], [82, 44]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 87,
            "column": 0
          }
        },
        "moduleName": "yarn-ui/templates/components/app-table.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("table");
        dom.setAttribute(el1, "class", "display table table-striped table-bordered");
        dom.setAttribute(el1, "cellspacing", "0");
        dom.setAttribute(el1, "width", "100%");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("thead");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("tr");
        var el4 = dom.createTextNode("\n          ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("th");
        var el5 = dom.createTextNode("Application ID");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n          ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("th");
        var el5 = dom.createTextNode("Application Type");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n          ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("th");
        var el5 = dom.createTextNode("Name");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n          ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("th");
        var el5 = dom.createTextNode("User");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n          ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("th");
        var el5 = dom.createTextNode("Queue");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n          ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("th");
        var el5 = dom.createTextNode("State");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n          ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("th");
        var el5 = dom.createTextNode("Final Status");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n          ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("th");
        var el5 = dom.createTextNode("Start Time");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n          ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("th");
        var el5 = dom.createTextNode("Elapsed Time");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode(" ");
        dom.appendChild(el3, el4);
        var el4 = dom.createComment(" idx = 7 ");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n          ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("th");
        var el5 = dom.createTextNode("Finished Time");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n          ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("th");
        var el5 = dom.createTextNode("Priority");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n          ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("th");
        var el5 = dom.createTextNode("Progress");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n          ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("th");
        var el5 = dom.createTextNode("%Cluster");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("tbody");
        var el3 = dom.createTextNode("\n");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element8 = dom.childAt(fragment, [1]);
        var morphs = new Array(2);
        morphs[0] = dom.createAttrMorph(element8, 'id');
        morphs[1] = dom.createMorphAt(dom.childAt(element8, [3]), 1, 1);
        return morphs;
      },
      statements: [["attribute", "id", ["get", "table-id", ["loc", [null, [19, 12], [19, 20]]], 0, 0, 0, 0], 0, 0, 0, 0], ["block", "if", [["get", "arr", ["loc", [null, [38, 10], [38, 13]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [38, 4], [84, 11]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define("yarn-ui/templates/components/app-timeout-bar", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 20,
              "column": 2
            },
            "end": {
              "line": 33,
              "column": 2
            }
          },
          "moduleName": "yarn-ui/templates/components/app-timeout-bar.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "panel panel-default");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          dom.setAttribute(el2, "class", "panel-body");
          var el3 = dom.createTextNode("\n        ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("label");
          var el4 = dom.createTextNode("Application will be timed out after ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("span");
          dom.setAttribute(el4, "class", "text-danger");
          var el5 = dom.createComment("");
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n        ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("div");
          dom.setAttribute(el3, "class", "progress");
          var el4 = dom.createTextNode("\n          ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("div");
          dom.setAttribute(el4, "class", "progress-bar progress-bar-danger progress-bar-striped active");
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n        ");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n        ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("div");
          var el4 = dom.createTextNode("\n          ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("label");
          dom.setAttribute(el4, "class", "pull-left");
          var el5 = dom.createComment("");
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n          ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("label");
          dom.setAttribute(el4, "class", "pull-right");
          var el5 = dom.createComment("");
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n        ");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n      ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1, 1]);
          var element1 = dom.childAt(element0, [3, 1]);
          var element2 = dom.childAt(element0, [5]);
          var morphs = new Array(4);
          morphs[0] = dom.createMorphAt(dom.childAt(element0, [1, 1]), 0, 0);
          morphs[1] = dom.createAttrMorph(element1, 'style');
          morphs[2] = dom.createMorphAt(dom.childAt(element2, [1]), 0, 0);
          morphs[3] = dom.createMorphAt(dom.childAt(element2, [3]), 0, 0);
          return morphs;
        },
        statements: [["content", "appTimeoutValue", ["loc", [null, [23, 77], [23, 96]]], 0, 0, 0, 0], ["attribute", "style", ["concat", [["get", "appTimeoutBarStyle", ["loc", [null, [25, 93], [25, 111]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["content", "app.startTime", ["loc", [null, [28, 35], [28, 52]]], 0, 0, 0, 0], ["content", "app.applicationExpiryTime", ["loc", [null, [29, 36], [29, 65]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 35,
            "column": 0
          }
        },
        "moduleName": "yarn-ui/templates/components/app-timeout-bar.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "app-timeout-wrapper");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 1, 1);
        return morphs;
      },
      statements: [["block", "unless", [["get", "isAppTimedOut", ["loc", [null, [20, 12], [20, 25]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [20, 2], [33, 13]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define("yarn-ui/templates/components/breadcrumb-bar", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 21,
              "column": 2
            },
            "end": {
              "line": 23,
              "column": 2
            }
          },
          "moduleName": "yarn-ui/templates/components/breadcrumb-bar.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          dom.setAttribute(el1, "type", "button");
          dom.setAttribute(el1, "class", "btn btn-sm btn-primary refresh");
          var el2 = dom.createTextNode("Refresh");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var morphs = new Array(1);
          morphs[0] = dom.createElementMorph(element0);
          return morphs;
        },
        statements: [["element", "action", ["refresh"], [], ["loc", [null, [22, 65], [22, 85]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 25,
            "column": 0
          }
        },
        "moduleName": "yarn-ui/templates/components/breadcrumb-bar.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "col-md-12 container-fluid breadcrumb-bar");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element1 = dom.childAt(fragment, [1]);
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(element1, 1, 1);
        morphs[1] = dom.createMorphAt(element1, 3, 3);
        return morphs;
      },
      statements: [["inline", "em-breadcrumbs", [], ["items", ["subexpr", "@mut", [["get", "breadcrumbs", ["loc", [null, [20, 25], [20, 36]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [20, 2], [20, 38]]], 0, 0], ["block", "unless", [["get", "hideRefresh", ["loc", [null, [21, 12], [21, 23]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [21, 2], [23, 13]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define("yarn-ui/templates/components/bs-accordion-item", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 8,
              "column": 0
            },
            "end": {
              "line": 12,
              "column": 0
            }
          },
          "moduleName": "yarn-ui/templates/components/bs-accordion-item.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "panel-body");
          var el2 = dom.createTextNode("\n        ");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 1, 1);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [10, 8], [10, 17]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 12,
            "column": 16
          }
        },
        "moduleName": "yarn-ui/templates/components/bs-accordion-item.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "role", "tab");
        var el2 = dom.createTextNode("\n    ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("h4");
        dom.setAttribute(el2, "class", "panel-title");
        var el3 = dom.createTextNode("\n        ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("a");
        dom.setAttribute(el3, "href", "#");
        var el4 = dom.createTextNode("\n            ");
        dom.appendChild(el3, el4);
        var el4 = dom.createComment("");
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n        ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        var morphs = new Array(4);
        morphs[0] = dom.createAttrMorph(element0, 'class');
        morphs[1] = dom.createElementMorph(element0);
        morphs[2] = dom.createMorphAt(dom.childAt(element0, [1, 1]), 1, 1);
        morphs[3] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["attribute", "class", ["concat", ["panel-heading ", ["subexpr", "if", [["get", "collapsed", ["loc", [null, [1, 68], [1, 77]]], 0, 0, 0, 0], "collapsed"], [], ["loc", [null, [1, 63], [1, 91]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["toggleActive"], [], ["loc", [null, [1, 16], [1, 41]]], 0, 0], ["content", "title", ["loc", [null, [4, 12], [4, 21]]], 0, 0, 0, 0], ["block", "bs-collapse", [], ["collapsed", ["subexpr", "@mut", [["get", "collapsed", ["loc", [null, [8, 25], [8, 34]]], 0, 0, 0, 0]], [], [], 0, 0], "class", "panel-collapse"], 0, null, ["loc", [null, [8, 0], [12, 16]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define("yarn-ui/templates/components/bs-alert", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 2,
                "column": 0
              },
              "end": {
                "line": 4,
                "column": 0
              }
            },
            "moduleName": "yarn-ui/templates/components/bs-alert.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("    ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("button");
            dom.setAttribute(el1, "type", "button");
            dom.setAttribute(el1, "class", "close");
            dom.setAttribute(el1, "aria-label", "Close");
            var el2 = dom.createElement("span");
            dom.setAttribute(el2, "aria-hidden", "true");
            var el3 = dom.createTextNode("×");
            dom.appendChild(el2, el3);
            dom.appendChild(el1, el2);
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var element0 = dom.childAt(fragment, [1]);
            var morphs = new Array(1);
            morphs[0] = dom.createElementMorph(element0);
            return morphs;
          },
          statements: [["element", "action", ["dismiss"], [], ["loc", [null, [3, 59], [3, 79]]], 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 6,
              "column": 0
            }
          },
          "moduleName": "yarn-ui/templates/components/bs-alert.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(2);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          dom.insertBoundary(fragment, 0);
          return morphs;
        },
        statements: [["block", "if", [["get", "dismissible", ["loc", [null, [2, 6], [2, 17]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [2, 0], [4, 7]]]], ["content", "yield", ["loc", [null, [5, 0], [5, 9]]], 0, 0, 0, 0]],
        locals: [],
        templates: [child0]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 7,
            "column": 0
          }
        },
        "moduleName": "yarn-ui/templates/components/bs-alert.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "unless", [["get", "dismissed", ["loc", [null, [1, 10], [1, 19]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [6, 11]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define("yarn-ui/templates/components/bs-button", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 1,
              "column": 37
            }
          },
          "moduleName": "yarn-ui/templates/components/bs-button.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createElement("i");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode(" ");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [0]);
          var morphs = new Array(1);
          morphs[0] = dom.createAttrMorph(element0, 'class');
          return morphs;
        },
        statements: [["attribute", "class", ["concat", [["get", "icon", ["loc", [null, [1, 24], [1, 28]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 1,
            "column": 61
          }
        },
        "moduleName": "yarn-ui/templates/components/bs-button.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(3);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
        morphs[2] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "icon", ["loc", [null, [1, 6], [1, 10]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [1, 44]]]], ["content", "text", ["loc", [null, [1, 44], [1, 52]]], 0, 0, 0, 0], ["content", "yield", ["loc", [null, [1, 52], [1, 61]]], 0, 0, 0, 0]],
      locals: [],
      templates: [child0]
    };
  })());
});
define("yarn-ui/templates/components/bs-form-group", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 2,
              "column": 0
            },
            "end": {
              "line": 4,
              "column": 0
            }
          },
          "moduleName": "yarn-ui/templates/components/bs-form-group.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("span");
          dom.setAttribute(el1, "aria-hidden", "true");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var morphs = new Array(1);
          morphs[0] = dom.createAttrMorph(element0, 'class');
          return morphs;
        },
        statements: [["attribute", "class", ["concat", ["form-control-feedback ", ["get", "iconName", ["loc", [null, [3, 41], [3, 49]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 4,
            "column": 7
          }
        },
        "moduleName": "yarn-ui/templates/components/bs-form-group.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0], ["block", "if", [["get", "hasFeedback", ["loc", [null, [2, 6], [2, 17]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [2, 0], [4, 7]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define("yarn-ui/templates/components/bs-form", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 1,
            "column": 9
          }
        },
        "moduleName": "yarn-ui/templates/components/bs-form.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define("yarn-ui/templates/components/bs-modal-dialog", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 8
            },
            "end": {
              "line": 5,
              "column": 8
            }
          },
          "moduleName": "yarn-ui/templates/components/bs-modal-dialog.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("            ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "bs-modal-header", [], ["title", ["subexpr", "@mut", [["get", "title", ["loc", [null, [4, 36], [4, 41]]], 0, 0, 0, 0]], [], [], 0, 0], "closeButton", ["subexpr", "@mut", [["get", "closeButton", ["loc", [null, [4, 54], [4, 65]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [4, 12], [4, 67]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 7,
                "column": 12
              },
              "end": {
                "line": 9,
                "column": 12
              }
            },
            "moduleName": "yarn-ui/templates/components/bs-modal-dialog.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("                ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["content", "yield", ["loc", [null, [8, 16], [8, 25]]], 0, 0, 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 6,
              "column": 8
            },
            "end": {
              "line": 10,
              "column": 8
            }
          },
          "moduleName": "yarn-ui/templates/components/bs-modal-dialog.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "bs-modal-body", [], [], 0, null, ["loc", [null, [7, 12], [9, 30]]]]],
        locals: [],
        templates: [child0]
      };
    })();
    var child2 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 10,
              "column": 8
            },
            "end": {
              "line": 12,
              "column": 8
            }
          },
          "moduleName": "yarn-ui/templates/components/bs-modal-dialog.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("            ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [11, 12], [11, 21]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child3 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 14,
              "column": 8
            },
            "end": {
              "line": 16,
              "column": 8
            }
          },
          "moduleName": "yarn-ui/templates/components/bs-modal-dialog.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("            ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "bs-modal-footer", ["loc", [null, [15, 12], [15, 31]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 18,
            "column": 6
          }
        },
        "moduleName": "yarn-ui/templates/components/bs-modal-dialog.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createElement("div");
        var el2 = dom.createTextNode("\n    ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "modal-content");
        var el3 = dom.createTextNode("\n");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("    ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [0]);
        var element1 = dom.childAt(element0, [1]);
        var morphs = new Array(4);
        morphs[0] = dom.createAttrMorph(element0, 'class');
        morphs[1] = dom.createMorphAt(element1, 1, 1);
        morphs[2] = dom.createMorphAt(element1, 2, 2);
        morphs[3] = dom.createMorphAt(element1, 4, 4);
        return morphs;
      },
      statements: [["attribute", "class", ["concat", ["modal-dialog ", ["get", "sizeClass", ["loc", [null, [1, 27], [1, 36]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["block", "if", [["get", "header", ["loc", [null, [3, 14], [3, 20]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [3, 8], [5, 15]]]], ["block", "if", [["get", "body", ["loc", [null, [6, 14], [6, 18]]], 0, 0, 0, 0]], [], 1, 2, ["loc", [null, [6, 8], [12, 15]]]], ["block", "if", [["get", "footer", ["loc", [null, [14, 14], [14, 20]]], 0, 0, 0, 0]], [], 3, null, ["loc", [null, [14, 8], [16, 15]]]]],
      locals: [],
      templates: [child0, child1, child2, child3]
    };
  })());
});
define("yarn-ui/templates/components/bs-modal-footer", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "yarn-ui/templates/components/bs-modal-footer.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "yield", [["get", "this", ["loc", [null, [2, 12], [2, 16]]], 0, 0, 0, 0]], [], ["loc", [null, [2, 4], [2, 18]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      var child0 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 5,
                  "column": 8
                },
                "end": {
                  "line": 5,
                  "column": 66
                }
              },
              "moduleName": "yarn-ui/templates/components/bs-modal-footer.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["content", "closeTitle", ["loc", [null, [5, 52], [5, 66]]], 0, 0, 0, 0]],
            locals: [],
            templates: []
          };
        })();
        var child1 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 6,
                  "column": 8
                },
                "end": {
                  "line": 6,
                  "column": 96
                }
              },
              "moduleName": "yarn-ui/templates/components/bs-modal-footer.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["content", "submitTitle", ["loc", [null, [6, 81], [6, 96]]], 0, 0, 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 4,
                "column": 4
              },
              "end": {
                "line": 7,
                "column": 4
              }
            },
            "moduleName": "yarn-ui/templates/components/bs-modal-footer.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("        ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n        ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(2);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
            return morphs;
          },
          statements: [["block", "bs-button", [], ["type", "default", "action", "close"], 0, null, ["loc", [null, [5, 8], [5, 80]]]], ["block", "bs-button", [], ["type", "primary", "buttonType", "submit", "disabled", ["subexpr", "@mut", [["get", "submitDisabled", ["loc", [null, [6, 65], [6, 79]]], 0, 0, 0, 0]], [], [], 0, 0]], 1, null, ["loc", [null, [6, 8], [6, 110]]]]],
          locals: [],
          templates: [child0, child1]
        };
      })();
      var child1 = (function () {
        var child0 = (function () {
          return {
            meta: {
              "revision": "Ember@2.8.0",
              "loc": {
                "source": null,
                "start": {
                  "line": 8,
                  "column": 8
                },
                "end": {
                  "line": 8,
                  "column": 66
                }
              },
              "moduleName": "yarn-ui/templates/components/bs-modal-footer.hbs"
            },
            isEmpty: false,
            arity: 0,
            cachedFragment: null,
            hasRendered: false,
            buildFragment: function buildFragment(dom) {
              var el0 = dom.createDocumentFragment();
              var el1 = dom.createComment("");
              dom.appendChild(el0, el1);
              return el0;
            },
            buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
              var morphs = new Array(1);
              morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
              dom.insertBoundary(fragment, 0);
              dom.insertBoundary(fragment, null);
              return morphs;
            },
            statements: [["content", "closeTitle", ["loc", [null, [8, 52], [8, 66]]], 0, 0, 0, 0]],
            locals: [],
            templates: []
          };
        })();
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 7,
                "column": 4
              },
              "end": {
                "line": 9,
                "column": 4
              }
            },
            "moduleName": "yarn-ui/templates/components/bs-modal-footer.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("        ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["block", "bs-button", [], ["type", "primary", "action", "close"], 0, null, ["loc", [null, [8, 8], [8, 80]]]]],
          locals: [],
          templates: [child0]
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 3,
              "column": 0
            },
            "end": {
              "line": 10,
              "column": 0
            }
          },
          "moduleName": "yarn-ui/templates/components/bs-modal-footer.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["block", "if", [["get", "hasSubmitButton", ["loc", [null, [4, 10], [4, 25]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [4, 4], [9, 11]]]]],
        locals: [],
        templates: [child0, child1]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 10,
            "column": 7
          }
        },
        "moduleName": "yarn-ui/templates/components/bs-modal-footer.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "hasBlock", ["loc", [null, [1, 6], [1, 14]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [1, 0], [10, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define("yarn-ui/templates/components/bs-modal-header", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 3,
              "column": 0
            }
          },
          "moduleName": "yarn-ui/templates/components/bs-modal-header.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("button");
          dom.setAttribute(el1, "type", "button");
          dom.setAttribute(el1, "class", "close");
          dom.setAttribute(el1, "aria-label", "Close");
          var el2 = dom.createElement("span");
          dom.setAttribute(el2, "aria-hidden", "true");
          var el3 = dom.createTextNode("×");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var morphs = new Array(1);
          morphs[0] = dom.createElementMorph(element0);
          return morphs;
        },
        statements: [["element", "action", ["close"], [], ["loc", [null, [2, 59], [2, 77]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 4,
              "column": 0
            },
            "end": {
              "line": 6,
              "column": 0
            }
          },
          "moduleName": "yarn-ui/templates/components/bs-modal-header.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["inline", "yield", [["get", "this", ["loc", [null, [5, 12], [5, 16]]], 0, 0, 0, 0]], [], ["loc", [null, [5, 4], [5, 18]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child2 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 6,
              "column": 0
            },
            "end": {
              "line": 8,
              "column": 0
            }
          },
          "moduleName": "yarn-ui/templates/components/bs-modal-header.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("h4");
          dom.setAttribute(el1, "class", "modal-title");
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 0, 0);
          return morphs;
        },
        statements: [["content", "title", ["loc", [null, [7, 28], [7, 37]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 9,
            "column": 0
          }
        },
        "moduleName": "yarn-ui/templates/components/bs-modal-header.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 1, 1, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "closeButton", ["loc", [null, [1, 6], [1, 17]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [3, 7]]]], ["block", "if", [["get", "hasBlock", ["loc", [null, [4, 6], [4, 14]]], 0, 0, 0, 0]], [], 1, 2, ["loc", [null, [4, 0], [8, 7]]]]],
      locals: [],
      templates: [child0, child1, child2]
    };
  })());
});
define("yarn-ui/templates/components/bs-modal", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      var child0 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 3,
                "column": 0
              },
              "end": {
                "line": 5,
                "column": 0
              }
            },
            "moduleName": "yarn-ui/templates/components/bs-modal.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("  ");
            dom.appendChild(el0, el1);
            var el1 = dom.createComment("");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var morphs = new Array(1);
            morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
            return morphs;
          },
          statements: [["content", "yield", ["loc", [null, [4, 2], [4, 11]]], 0, 0, 0, 0]],
          locals: [],
          templates: []
        };
      })();
      var child1 = (function () {
        return {
          meta: {
            "revision": "Ember@2.8.0",
            "loc": {
              "source": null,
              "start": {
                "line": 7,
                "column": 0
              },
              "end": {
                "line": 9,
                "column": 0
              }
            },
            "moduleName": "yarn-ui/templates/components/bs-modal.hbs"
          },
          isEmpty: false,
          arity: 0,
          cachedFragment: null,
          hasRendered: false,
          buildFragment: function buildFragment(dom) {
            var el0 = dom.createDocumentFragment();
            var el1 = dom.createTextNode("  ");
            dom.appendChild(el0, el1);
            var el1 = dom.createElement("div");
            dom.appendChild(el0, el1);
            var el1 = dom.createTextNode("\n");
            dom.appendChild(el0, el1);
            return el0;
          },
          buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
            var element0 = dom.childAt(fragment, [1]);
            var morphs = new Array(2);
            morphs[0] = dom.createAttrMorph(element0, 'class');
            morphs[1] = dom.createAttrMorph(element0, 'id');
            return morphs;
          },
          statements: [["attribute", "class", ["concat", ["modal-backdrop ", ["subexpr", "if", [["get", "fade", ["loc", [null, [8, 34], [8, 38]]], 0, 0, 0, 0], "fade"], [], ["loc", [null, [8, 29], [8, 47]]], 0, 0], " ", ["subexpr", "if", [["get", "in", ["loc", [null, [8, 53], [8, 55]]], 0, 0, 0, 0], "in"], [], ["loc", [null, [8, 48], [8, 62]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["attribute", "id", ["concat", [["get", "backdropId", ["loc", [null, [8, 70], [8, 80]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0]],
          locals: [],
          templates: []
        };
      })();
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 11,
              "column": 0
            }
          },
          "moduleName": "yarn-ui/templates/components/bs-modal.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(2);
          morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
          morphs[1] = dom.createMorphAt(fragment, 3, 3, contextualElement);
          return morphs;
        },
        statements: [["block", "bs-modal-dialog", [], ["close", ["subexpr", "action", ["close"], [], ["loc", [null, [3, 25], [3, 41]]], 0, 0], "fade", ["subexpr", "@mut", [["get", "fade", ["loc", [null, [3, 47], [3, 51]]], 0, 0, 0, 0]], [], [], 0, 0], "in", ["subexpr", "@mut", [["get", "in", ["loc", [null, [3, 55], [3, 57]]], 0, 0, 0, 0]], [], [], 0, 0], "id", ["subexpr", "@mut", [["get", "modalId", ["loc", [null, [3, 61], [3, 68]]], 0, 0, 0, 0]], [], [], 0, 0], "title", ["subexpr", "@mut", [["get", "title", ["loc", [null, [3, 75], [3, 80]]], 0, 0, 0, 0]], [], [], 0, 0], "closeButton", ["subexpr", "@mut", [["get", "closeButton", ["loc", [null, [3, 93], [3, 104]]], 0, 0, 0, 0]], [], [], 0, 0], "keyboard", ["subexpr", "@mut", [["get", "keyboard", ["loc", [null, [3, 114], [3, 122]]], 0, 0, 0, 0]], [], [], 0, 0], "header", ["subexpr", "@mut", [["get", "header", ["loc", [null, [3, 130], [3, 136]]], 0, 0, 0, 0]], [], [], 0, 0], "body", ["subexpr", "@mut", [["get", "body", ["loc", [null, [3, 142], [3, 146]]], 0, 0, 0, 0]], [], [], 0, 0], "footer", ["subexpr", "@mut", [["get", "footer", ["loc", [null, [3, 154], [3, 160]]], 0, 0, 0, 0]], [], [], 0, 0], "size", ["subexpr", "@mut", [["get", "size", ["loc", [null, [3, 166], [3, 170]]], 0, 0, 0, 0]], [], [], 0, 0], "backdropClose", ["subexpr", "@mut", [["get", "backdropClose", ["loc", [null, [3, 185], [3, 198]]], 0, 0, 0, 0]], [], [], 0, 0]], 0, null, ["loc", [null, [3, 0], [5, 20]]]], ["block", "if", [["get", "showBackdrop", ["loc", [null, [7, 6], [7, 18]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [7, 0], [9, 7]]]]],
        locals: [],
        templates: [child0, child1]
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 11,
            "column": 19
          }
        },
        "moduleName": "yarn-ui/templates/components/bs-modal.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "ember-wormhole", [], ["to", "ember-bootstrap-modal-container"], 0, null, ["loc", [null, [1, 0], [11, 19]]]]],
      locals: [],
      templates: [child0]
    };
  })());
});
define("yarn-ui/templates/components/bs-select", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 1,
              "column": 0
            },
            "end": {
              "line": 5,
              "column": 0
            }
          },
          "moduleName": "yarn-ui/templates/components/bs-select.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("option");
          dom.setAttribute(el1, "disabled", "");
          var el2 = dom.createTextNode("\n        ");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element1 = dom.childAt(fragment, [1]);
          var morphs = new Array(2);
          morphs[0] = dom.createAttrMorph(element1, 'selected');
          morphs[1] = dom.createMorphAt(element1, 1, 1);
          return morphs;
        },
        statements: [["attribute", "selected", ["subexpr", "is-not", [["get", "value", ["loc", [null, [2, 39], [2, 44]]], 0, 0, 0, 0]], [], ["loc", [null, [null, null], [2, 46]]], 0, 0], 0, 0, 0, 0], ["content", "prompt", ["loc", [null, [3, 8], [3, 18]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 7,
              "column": 0
            },
            "end": {
              "line": 12,
              "column": 0
            }
          },
          "moduleName": "yarn-ui/templates/components/bs-select.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("option");
          var el2 = dom.createTextNode("\n        ");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var morphs = new Array(3);
          morphs[0] = dom.createAttrMorph(element0, 'value');
          morphs[1] = dom.createAttrMorph(element0, 'selected');
          morphs[2] = dom.createMorphAt(element0, 1, 1);
          return morphs;
        },
        statements: [["attribute", "value", ["concat", [["subexpr", "read-path", [["get", "item", ["loc", [null, [8, 31], [8, 35]]], 0, 0, 0, 0], ["get", "optionValuePath", ["loc", [null, [8, 36], [8, 51]]], 0, 0, 0, 0]], [], ["loc", [null, [8, 19], [8, 53]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["attribute", "selected", ["subexpr", "is-equal", [["get", "item", ["loc", [null, [9, 32], [9, 36]]], 0, 0, 0, 0], ["get", "value", ["loc", [null, [9, 37], [9, 42]]], 0, 0, 0, 0]], [], ["loc", [null, [null, null], [9, 44]]], 0, 0], 0, 0, 0, 0], ["inline", "read-path", [["get", "item", ["loc", [null, [10, 20], [10, 24]]], 0, 0, 0, 0], ["get", "optionLabelPath", ["loc", [null, [10, 25], [10, 40]]], 0, 0, 0, 0]], [], ["loc", [null, [10, 8], [10, 42]]], 0, 0]],
        locals: ["item"],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 12,
            "column": 9
          }
        },
        "moduleName": "yarn-ui/templates/components/bs-select.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(2);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        morphs[1] = dom.createMorphAt(fragment, 2, 2, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "prompt", ["loc", [null, [1, 6], [1, 12]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [1, 0], [5, 7]]]], ["block", "each", [["get", "content", ["loc", [null, [7, 8], [7, 15]]], 0, 0, 0, 0]], ["key", "@identity"], 1, null, ["loc", [null, [7, 0], [12, 9]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define("yarn-ui/templates/components/collapsible-panel", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 22,
            "column": 0
          }
        },
        "moduleName": "yarn-ui/templates/components/collapsible-panel.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("a");
        dom.setAttribute(el1, "class", "pull-right toggle_switch");
        dom.setAttribute(el1, "href", "#");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("span");
        dom.setAttribute(el2, "class", "glyphicon glyphicon-chevron-up");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [1]);
        var morphs = new Array(1);
        morphs[0] = dom.createElementMorph(element0);
        return morphs;
      },
      statements: [["element", "action", ["togglePanelCollapse"], [], ["loc", [null, [19, 45], [19, 77]]], 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define("yarn-ui/templates/components/confirm-dialog", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 38,
            "column": 0
          }
        },
        "moduleName": "yarn-ui/templates/components/confirm-dialog.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "modal fade");
        dom.setAttribute(el1, "tabindex", "-1");
        dom.setAttribute(el1, "role", "dialog");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "modal-dialog");
        dom.setAttribute(el2, "role", "document");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "modal-content");
        dom.setAttribute(el3, "style", "width: 500px;");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("div");
        dom.setAttribute(el4, "class", "modal-header");
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("button");
        dom.setAttribute(el5, "type", "button");
        dom.setAttribute(el5, "class", "close");
        dom.setAttribute(el5, "data-dismiss", "modal");
        dom.setAttribute(el5, "aria-label", "Close");
        var el6 = dom.createTextNode("\n          ");
        dom.appendChild(el5, el6);
        var el6 = dom.createElement("span");
        dom.setAttribute(el6, "aria-hidden", "true");
        var el7 = dom.createTextNode("×");
        dom.appendChild(el6, el7);
        dom.appendChild(el5, el6);
        var el6 = dom.createTextNode("\n        ");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("h3");
        dom.setAttribute(el5, "class", "modal-title");
        var el6 = dom.createComment("");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("div");
        dom.setAttribute(el4, "class", "modal-body");
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createComment("");
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("div");
        dom.setAttribute(el4, "class", "modal-footer");
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("button");
        dom.setAttribute(el5, "type", "button");
        dom.setAttribute(el5, "class", "btn btn-default");
        dom.setAttribute(el5, "data-dismiss", "modal");
        var el6 = dom.createTextNode("No");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("button");
        dom.setAttribute(el5, "type", "button");
        dom.setAttribute(el5, "class", "btn btn-primary");
        var el6 = dom.createTextNode("Yes");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element0 = dom.childAt(fragment, [1]);
        var element1 = dom.childAt(element0, [1, 1]);
        var element2 = dom.childAt(element1, [5, 3]);
        var morphs = new Array(4);
        morphs[0] = dom.createAttrMorph(element0, 'id');
        morphs[1] = dom.createMorphAt(dom.childAt(element1, [1, 3]), 0, 0);
        morphs[2] = dom.createMorphAt(dom.childAt(element1, [3]), 1, 1);
        morphs[3] = dom.createElementMorph(element2);
        return morphs;
      },
      statements: [["attribute", "id", ["concat", [["get", "dialogId", ["loc", [null, [19, 58], [19, 66]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["content", "title", ["loc", [null, [26, 32], [26, 41]]], 0, 0, 0, 0], ["content", "message", ["loc", [null, [29, 8], [29, 19]]], 0, 0, 0, 0], ["element", "action", ["yesConfirmed"], [], ["loc", [null, [33, 54], [33, 79]]], 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
define("yarn-ui/templates/components/container-table", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 25,
              "column": 4
            },
            "end": {
              "line": 30,
              "column": 4
            }
          },
          "moduleName": "yarn-ui/templates/components/container-table.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("tr");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createTextNode("Finished Time");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1, 3]), 0, 0);
          return morphs;
        },
        statements: [["content", "container.validatedFinishedTs", ["loc", [null, [28, 10], [28, 43]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 39,
              "column": 4
            },
            "end": {
              "line": 44,
              "column": 4
            }
          },
          "moduleName": "yarn-ui/templates/components/container-table.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("tr");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createTextNode("Exit Status");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1, 3]), 0, 0);
          return morphs;
        },
        statements: [["content", "container.containerExitStatus", ["loc", [null, [42, 10], [42, 43]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child2 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 45,
              "column": 4
            },
            "end": {
              "line": 50,
              "column": 4
            }
          },
          "moduleName": "yarn-ui/templates/components/container-table.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("tr");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createTextNode("State");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1, 3]), 0, 0);
          return morphs;
        },
        statements: [["content", "container.containerState", ["loc", [null, [48, 10], [48, 38]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child3 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 51,
              "column": 4
            },
            "end": {
              "line": 56,
              "column": 4
            }
          },
          "moduleName": "yarn-ui/templates/components/container-table.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("tr");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createTextNode("NodeManager UI");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createElement("a");
          var el4 = dom.createComment("");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element3 = dom.childAt(fragment, [1, 3]);
          var element4 = dom.childAt(element3, [0]);
          var morphs = new Array(3);
          morphs[0] = dom.createAttrMorph(element3, 'title');
          morphs[1] = dom.createAttrMorph(element4, 'href');
          morphs[2] = dom.createMorphAt(element4, 0, 0);
          return morphs;
        },
        statements: [["attribute", "title", ["concat", [["get", "container.nodeHttpAddress", ["loc", [null, [54, 19], [54, 44]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["attribute", "href", ["concat", [["get", "container.masterNodeURL", ["loc", [null, [54, 59], [54, 82]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["content", "container.nodeHttpAddress", ["loc", [null, [54, 86], [54, 115]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child4 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 57,
              "column": 4
            },
            "end": {
              "line": 62,
              "column": 4
            }
          },
          "moduleName": "yarn-ui/templates/components/container-table.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("tr");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createTextNode("Exposed Ports");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createComment("");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element2 = dom.childAt(fragment, [1, 3]);
          var morphs = new Array(2);
          morphs[0] = dom.createAttrMorph(element2, 'title');
          morphs[1] = dom.createMorphAt(element2, 0, 0);
          return morphs;
        },
        statements: [["attribute", "title", ["concat", [["get", "container.exposedPorts", ["loc", [null, [60, 19], [60, 41]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["content", "container.exposedPorts", ["loc", [null, [60, 45], [60, 71]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child5 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 63,
              "column": 4
            },
            "end": {
              "line": 70,
              "column": 4
            }
          },
          "moduleName": "yarn-ui/templates/components/container-table.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("tr");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createTextNode("Logs");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createTextNode("\n        ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("a");
          var el4 = dom.createTextNode("Link");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n      ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element1 = dom.childAt(fragment, [1, 3, 1]);
          var morphs = new Array(1);
          morphs[0] = dom.createAttrMorph(element1, 'href');
          return morphs;
        },
        statements: [["attribute", "href", ["concat", [["get", "container.appAttemptContainerLogsURL", ["loc", [null, [67, 19], [67, 55]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child6 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 71,
              "column": 4
            },
            "end": {
              "line": 76,
              "column": 4
            }
          },
          "moduleName": "yarn-ui/templates/components/container-table.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("tr");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createTextNode("Terminal");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("td");
          var el3 = dom.createElement("a");
          dom.setAttribute(el3, "target", "_blank");
          var el4 = dom.createTextNode("Link");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1, 3, 0]);
          var morphs = new Array(1);
          morphs[0] = dom.createAttrMorph(element0, 'href');
          return morphs;
        },
        statements: [["attribute", "href", ["concat", [["get", "container.nodeHttpAddress", ["loc", [null, [74, 21], [74, 46]]], 0, 0, 0, 0], "/terminal/terminal.template?container=", ["get", "container.id", ["loc", [null, [74, 88], [74, 100]]], 0, 0, 0, 0], "&user.name=", ["get", "requestedUser", ["loc", [null, [74, 115], [74, 128]]], 0, 0, 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 79,
            "column": 0
          }
        },
        "moduleName": "yarn-ui/templates/components/container-table.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("table");
        dom.setAttribute(el1, "id", "container-table");
        dom.setAttribute(el1, "class", "table table-striped table-bordered");
        dom.setAttribute(el1, "cellspacing", "0");
        dom.setAttribute(el1, "width", "100%");
        dom.setAttribute(el1, "height", "100%");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("tbody");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("tr");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("td");
        var el5 = dom.createTextNode("Started Time");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("td");
        var el5 = dom.createComment("");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("tr");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("td");
        var el5 = dom.createTextNode("Elapsed Time");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("td");
        var el5 = dom.createComment("");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("tr");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("td");
        var el5 = dom.createTextNode("Priority");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("td");
        var el5 = dom.createComment("");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element5 = dom.childAt(fragment, [1, 1]);
        var morphs = new Array(10);
        morphs[0] = dom.createMorphAt(dom.childAt(element5, [1, 3]), 0, 0);
        morphs[1] = dom.createMorphAt(element5, 3, 3);
        morphs[2] = dom.createMorphAt(dom.childAt(element5, [5, 3]), 0, 0);
        morphs[3] = dom.createMorphAt(dom.childAt(element5, [7, 3]), 0, 0);
        morphs[4] = dom.createMorphAt(element5, 9, 9);
        morphs[5] = dom.createMorphAt(element5, 10, 10);
        morphs[6] = dom.createMorphAt(element5, 11, 11);
        morphs[7] = dom.createMorphAt(element5, 12, 12);
        morphs[8] = dom.createMorphAt(element5, 13, 13);
        morphs[9] = dom.createMorphAt(element5, 14, 14);
        return morphs;
      },
      statements: [["content", "container.startedTime", ["loc", [null, [23, 10], [23, 35]]], 0, 0, 0, 0], ["block", "if", [["get", "container.validatedFinishedTs", ["loc", [null, [25, 10], [25, 39]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [25, 4], [30, 11]]]], ["content", "container.elapsedTime", ["loc", [null, [33, 10], [33, 35]]], 0, 0, 0, 0], ["content", "container.priority", ["loc", [null, [37, 10], [37, 32]]], 0, 0, 0, 0], ["block", "if", [["get", "container.containerExitStatus", ["loc", [null, [39, 10], [39, 39]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [39, 4], [44, 11]]]], ["block", "if", [["get", "container.containerState", ["loc", [null, [45, 10], [45, 34]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [45, 4], [50, 11]]]], ["block", "if", [["get", "container.nodeHttpAddress", ["loc", [null, [51, 10], [51, 35]]], 0, 0, 0, 0]], [], 3, null, ["loc", [null, [51, 4], [56, 11]]]], ["block", "if", [["get", "container.exposedPorts", ["loc", [null, [57, 10], [57, 32]]], 0, 0, 0, 0]], [], 4, null, ["loc", [null, [57, 4], [62, 11]]]], ["block", "if", [["get", "container.appAttemptContainerLogsURL", ["loc", [null, [63, 10], [63, 46]]], 0, 0, 0, 0]], [], 5, null, ["loc", [null, [63, 4], [70, 11]]]], ["block", "if", [["get", "container.nodeHttpAddress", ["loc", [null, [71, 10], [71, 35]]], 0, 0, 0, 0]], [], 6, null, ["loc", [null, [71, 4], [76, 11]]]]],
      locals: [],
      templates: [child0, child1, child2, child3, child4, child5, child6]
    };
  })());
});
define("yarn-ui/templates/components/deploy-service", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 20,
              "column": 2
            },
            "end": {
              "line": 31,
              "column": 2
            }
          },
          "moduleName": "yarn-ui/templates/components/deploy-service.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "row");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          dom.setAttribute(el2, "class", "col-md-12");
          var el3 = dom.createTextNode("\n        ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("div");
          dom.setAttribute(el3, "class", "panel panel-default service-resp");
          var el4 = dom.createTextNode("\n          ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("div");
          var el5 = dom.createTextNode("\n            ");
          dom.appendChild(el4, el5);
          var el5 = dom.createElement("span");
          dom.setAttribute(el5, "class", "glyphicon glyphicon-remove pull-right remove-icon");
          dom.appendChild(el4, el5);
          var el5 = dom.createTextNode("\n            ");
          dom.appendChild(el4, el5);
          var el5 = dom.createElement("strong");
          var el6 = dom.createComment("");
          dom.appendChild(el5, el6);
          dom.appendChild(el4, el5);
          var el5 = dom.createTextNode("\n          ");
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n        ");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n      ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element2 = dom.childAt(fragment, [1, 1, 1, 1]);
          var element3 = dom.childAt(element2, [1]);
          var element4 = dom.childAt(element2, [3]);
          var morphs = new Array(4);
          morphs[0] = dom.createAttrMorph(element2, 'class');
          morphs[1] = dom.createElementMorph(element3);
          morphs[2] = dom.createAttrMorph(element4, 'class');
          morphs[3] = dom.createMorphAt(element4, 0, 0);
          return morphs;
        },
        statements: [["attribute", "class", ["concat", ["panel-body ", ["subexpr", "if", [["subexpr", "eq", [["get", "serviceResp.type", ["loc", [null, [24, 42], [24, 58]]], 0, 0, 0, 0], "error"], [], ["loc", [null, [24, 38], [24, 67]]], 0, 0], "bg-danger", "bg-success"], [], ["loc", [null, [24, 33], [24, 94]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["clearServiceResponse"], [], ["loc", [null, [25, 76], [25, 109]]], 0, 0], ["attribute", "class", ["concat", [["subexpr", "if", [["subexpr", "eq", [["get", "serviceResp.type", ["loc", [null, [26, 36], [26, 52]]], 0, 0, 0, 0], "error"], [], ["loc", [null, [26, 32], [26, 61]]], 0, 0], "text-danger", "text-success"], [], ["loc", [null, [26, 27], [26, 92]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["content", "serviceResp.message", ["loc", [null, [26, 94], [26, 117]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 32,
              "column": 2
            },
            "end": {
              "line": 43,
              "column": 2
            }
          },
          "moduleName": "yarn-ui/templates/components/deploy-service.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("    ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "row");
          var el2 = dom.createTextNode("\n      ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          dom.setAttribute(el2, "class", "col-md-4");
          var el3 = dom.createTextNode("\n        ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("div");
          dom.setAttribute(el3, "class", "form-group shrink-height");
          var el4 = dom.createTextNode("\n          ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("label");
          dom.setAttribute(el4, "class", "required");
          var el5 = dom.createTextNode("User Name for service");
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n          ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("span");
          dom.setAttribute(el4, "class", "glyphicon glyphicon-info-sign info-icon");
          dom.setAttribute(el4, "data-info", "userName");
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n          ");
          dom.appendChild(el3, el4);
          var el4 = dom.createComment("");
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n        ");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n        ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("br");
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n      ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1, 1, 1]), 5, 5);
          return morphs;
        },
        statements: [["inline", "input", [], ["type", "text", "class", "form-control", "placeholder", "User Name", "value", ["subexpr", "@mut", [["get", "userName", ["loc", [null, [38, 81], [38, 89]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [38, 10], [38, 91]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child2 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 45,
              "column": 4
            },
            "end": {
              "line": 47,
              "column": 4
            }
          },
          "moduleName": "yarn-ui/templates/components/deploy-service.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("      ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("img");
          dom.setAttribute(el1, "src", "assets/images/spinner.gif");
          dom.setAttribute(el1, "alt", "Loading...");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes() {
          return [];
        },
        statements: [],
        locals: [],
        templates: []
      };
    })();
    var child3 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 54,
              "column": 14
            },
            "end": {
              "line": 59,
              "column": 14
            }
          },
          "moduleName": "yarn-ui/templates/components/deploy-service.hbs"
        },
        isEmpty: false,
        arity: 1,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("                ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("a");
          dom.setAttribute(el1, "href", "#");
          var el2 = dom.createTextNode("\n                  ");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n                  ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("span");
          dom.setAttribute(el2, "class", "glyphicon glyphicon-remove pull-right remove-icon");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n                ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var element1 = dom.childAt(element0, [3]);
          var morphs = new Array(4);
          morphs[0] = dom.createAttrMorph(element0, 'class');
          morphs[1] = dom.createElementMorph(element0);
          morphs[2] = dom.createMorphAt(element0, 1, 1);
          morphs[3] = dom.createElementMorph(element1);
          return morphs;
        },
        statements: [["attribute", "class", ["concat", ["list-group-item ", ["subexpr", "if", [["get", "list.active", ["loc", [null, [55, 56], [55, 67]]], 0, 0, 0, 0], "active"], [], ["loc", [null, [55, 51], [55, 78]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["element", "action", ["updateServiceDef", ["get", "list", ["loc", [null, [55, 108], [55, 112]]], 0, 0, 0, 0]], [], ["loc", [null, [55, 80], [55, 114]]], 0, 0], ["content", "list.name", ["loc", [null, [56, 18], [56, 31]]], 0, 0, 0, 0], ["element", "action", ["removeFromSavedList", ["get", "list", ["loc", [null, [57, 113], [57, 117]]], 0, 0, 0, 0]], [], ["loc", [null, [57, 82], [57, 119]]], 0, 0]],
        locals: ["list"],
        templates: []
      };
    })();
    var child4 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 59,
              "column": 14
            },
            "end": {
              "line": 61,
              "column": 14
            }
          },
          "moduleName": "yarn-ui/templates/components/deploy-service.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("                ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("li");
          dom.setAttribute(el1, "class", "list-group-item align-center");
          var el2 = dom.createTextNode("No saved templates");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes() {
          return [];
        },
        statements: [],
        locals: [],
        templates: []
      };
    })();
    var child5 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 78,
              "column": 12
            },
            "end": {
              "line": 135,
              "column": 12
            }
          },
          "moduleName": "yarn-ui/templates/components/deploy-service.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("\n              ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "row");
          var el2 = dom.createTextNode("\n                ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          dom.setAttribute(el2, "class", "col-md-4");
          var el3 = dom.createTextNode("\n                  ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("div");
          dom.setAttribute(el3, "class", "form-group shrink-height");
          var el4 = dom.createTextNode("\n                    ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("label");
          dom.setAttribute(el4, "class", "required");
          var el5 = dom.createTextNode("Service Name");
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n                    ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("span");
          dom.setAttribute(el4, "class", "glyphicon glyphicon-info-sign info-icon");
          dom.setAttribute(el4, "data-info", "serviceName");
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n                    ");
          dom.appendChild(el3, el4);
          var el4 = dom.createComment("");
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n                  ");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n                  ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("br");
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n                ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n              ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n\n              ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "row");
          var el2 = dom.createTextNode("\n                ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          dom.setAttribute(el2, "class", "col-md-4");
          var el3 = dom.createTextNode("\n                  ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("div");
          dom.setAttribute(el3, "class", "form-group shrink-height");
          var el4 = dom.createTextNode("\n                    ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("label");
          dom.setAttribute(el4, "class", "required");
          var el5 = dom.createTextNode("Queue Name");
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n                    ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("span");
          dom.setAttribute(el4, "class", "glyphicon glyphicon-info-sign info-icon");
          dom.setAttribute(el4, "data-info", "queueName");
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n                    ");
          dom.appendChild(el3, el4);
          var el4 = dom.createComment("");
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n                  ");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n                  ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("br");
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n                ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n              ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n\n              ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "row");
          var el2 = dom.createTextNode("\n                ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          dom.setAttribute(el2, "class", "col-md-4");
          var el3 = dom.createTextNode("\n                  ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("div");
          dom.setAttribute(el3, "class", "form-group shrink-height");
          var el4 = dom.createTextNode("\n                    ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("label");
          dom.setAttribute(el4, "class", "required");
          var el5 = dom.createTextNode("Service Version");
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n                    ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("span");
          dom.setAttribute(el4, "class", "glyphicon glyphicon-info-sign info-icon");
          dom.setAttribute(el4, "data-info", "version");
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n                    ");
          dom.appendChild(el3, el4);
          var el4 = dom.createComment("");
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n                  ");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n                  ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("br");
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n                ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n              ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n\n              ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "row");
          var el2 = dom.createTextNode("\n                ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("div");
          dom.setAttribute(el2, "class", "col-md-4");
          var el3 = dom.createTextNode("\n                  ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("div");
          dom.setAttribute(el3, "class", "form-group");
          var el4 = dom.createTextNode("\n                    ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("label");
          var el5 = dom.createTextNode("Service Lifetime");
          dom.appendChild(el4, el5);
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n                    ");
          dom.appendChild(el3, el4);
          var el4 = dom.createElement("span");
          dom.setAttribute(el4, "class", "glyphicon glyphicon-info-sign info-icon");
          dom.setAttribute(el4, "data-info", "lifetime");
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n                    ");
          dom.appendChild(el3, el4);
          var el4 = dom.createComment("");
          dom.appendChild(el3, el4);
          var el4 = dom.createTextNode("\n                  ");
          dom.appendChild(el3, el4);
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n                  ");
          dom.appendChild(el2, el3);
          var el3 = dom.createElement("br");
          dom.appendChild(el2, el3);
          var el3 = dom.createTextNode("\n                ");
          dom.appendChild(el2, el3);
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n              ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n\n              ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "row");
          var el2 = dom.createTextNode("\n                ");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n              ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n\n              ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "row");
          var el2 = dom.createTextNode("\n                ");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n              ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n\n              ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "row");
          var el2 = dom.createTextNode("\n                ");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n              ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(7);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1, 1, 1]), 5, 5);
          morphs[1] = dom.createMorphAt(dom.childAt(fragment, [3, 1, 1]), 5, 5);
          morphs[2] = dom.createMorphAt(dom.childAt(fragment, [5, 1, 1]), 5, 5);
          morphs[3] = dom.createMorphAt(dom.childAt(fragment, [7, 1, 1]), 5, 5);
          morphs[4] = dom.createMorphAt(dom.childAt(fragment, [9]), 1, 1);
          morphs[5] = dom.createMorphAt(dom.childAt(fragment, [11]), 1, 1);
          morphs[6] = dom.createMorphAt(dom.childAt(fragment, [13]), 1, 1);
          return morphs;
        },
        statements: [["inline", "input", [], ["type", "text", "class", "form-control", "placeholder", "Service Name", "value", ["subexpr", "@mut", [["get", "serviceDef.name", ["loc", [null, [85, 94], [85, 109]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [85, 20], [85, 111]]], 0, 0], ["inline", "input", [], ["type", "text", "class", "form-control", "placeholder", "Queue Name", "value", ["subexpr", "@mut", [["get", "serviceDef.queue", ["loc", [null, [96, 92], [96, 108]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [96, 20], [96, 110]]], 0, 0], ["inline", "input", [], ["type", "text", "class", "form-control", "placeholder", "1.0.0", "value", ["subexpr", "@mut", [["get", "serviceDef.version", ["loc", [null, [107, 87], [107, 105]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [107, 20], [107, 107]]], 0, 0], ["inline", "input", [], ["type", "number", "min", "0", "class", "form-control", "placeholder", "Service Lifetime (Seconds)", "value", ["subexpr", "@mut", [["get", "serviceDef.lifetime", ["loc", [null, [118, 118], [118, 137]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [118, 20], [118, 139]]], 0, 0], ["inline", "service-component-table", [], ["serviceDef", ["subexpr", "@mut", [["get", "serviceDef", ["loc", [null, [125, 53], [125, 63]]], 0, 0, 0, 0]], [], [], 0, 0], "applicationCtrl", ["subexpr", "@mut", [["get", "applicationCtrl", ["loc", [null, [125, 80], [125, 95]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [125, 16], [125, 97]]], 0, 0], ["inline", "service-config-table", [], ["serviceDef", ["subexpr", "@mut", [["get", "serviceDef", ["loc", [null, [129, 50], [129, 60]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [129, 16], [129, 62]]], 0, 0], ["inline", "service-fileconfig-table", [], ["serviceDef", ["subexpr", "@mut", [["get", "serviceDef", ["loc", [null, [133, 54], [133, 64]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [133, 16], [133, 66]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child6 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 137,
              "column": 12
            },
            "end": {
              "line": 141,
              "column": 12
            }
          },
          "moduleName": "yarn-ui/templates/components/deploy-service.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("            ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("div");
          dom.setAttribute(el1, "class", "form-group custom-json-area");
          var el2 = dom.createTextNode("\n              ");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n            ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(dom.childAt(fragment, [1]), 1, 1);
          return morphs;
        },
        statements: [["inline", "textarea", [], ["class", "form-control", "rows", "29", "cols", "120", "value", ["subexpr", "@mut", [["get", "customServiceDef", ["loc", [null, [139, 73], [139, 89]]], 0, 0, 0, 0]], [], [], 0, 0], "placeholder", "Service JSON configuration here..."], ["loc", [null, [139, 14], [139, 140]]], 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 181,
            "column": 0
          }
        },
        "moduleName": "yarn-ui/templates/components/deploy-service.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "container-fluid deploy-service");
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createComment("");
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        var el3 = dom.createTextNode("\n");
        dom.appendChild(el2, el3);
        var el3 = dom.createComment("");
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "row");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("div");
        dom.setAttribute(el4, "class", "col-md-12");
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("div");
        dom.setAttribute(el5, "class", "col-md-2 savedlist-column");
        var el6 = dom.createTextNode("\n          ");
        dom.appendChild(el5, el6);
        var el6 = dom.createElement("label");
        var el7 = dom.createTextNode("Saved Templates");
        dom.appendChild(el6, el7);
        dom.appendChild(el5, el6);
        var el6 = dom.createTextNode("\n          ");
        dom.appendChild(el5, el6);
        var el6 = dom.createElement("div");
        dom.setAttribute(el6, "class", "panel panel-default saved-list");
        var el7 = dom.createTextNode("\n            ");
        dom.appendChild(el6, el7);
        var el7 = dom.createElement("ul");
        dom.setAttribute(el7, "class", "list-group");
        var el8 = dom.createTextNode("\n");
        dom.appendChild(el7, el8);
        var el8 = dom.createComment("");
        dom.appendChild(el7, el8);
        var el8 = dom.createTextNode("            ");
        dom.appendChild(el7, el8);
        dom.appendChild(el6, el7);
        var el7 = dom.createTextNode("\n          ");
        dom.appendChild(el6, el7);
        dom.appendChild(el5, el6);
        var el6 = dom.createTextNode("\n        ");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("div");
        dom.setAttribute(el5, "class", "col-md-10 definition-column");
        var el6 = dom.createTextNode("\n          ");
        dom.appendChild(el5, el6);
        var el6 = dom.createElement("label");
        var el7 = dom.createTextNode("Service Definition");
        dom.appendChild(el6, el7);
        dom.appendChild(el5, el6);
        var el6 = dom.createTextNode("\n          ");
        dom.appendChild(el5, el6);
        var el6 = dom.createElement("div");
        dom.setAttribute(el6, "class", "btn-group pull-right");
        dom.setAttribute(el6, "data-toggle", "buttons");
        var el7 = dom.createTextNode("\n            ");
        dom.appendChild(el6, el7);
        var el7 = dom.createElement("label");
        dom.setAttribute(el7, "class", "btn btn-default btn-sm toggle-btn active");
        var el8 = dom.createTextNode("\n              ");
        dom.appendChild(el7, el8);
        var el8 = dom.createElement("input");
        dom.setAttribute(el8, "type", "radio");
        dom.setAttribute(el8, "name", "custom");
        dom.setAttribute(el8, "checked", "");
        dom.appendChild(el7, el8);
        var el8 = dom.createElement("b");
        var el9 = dom.createTextNode("Standard");
        dom.appendChild(el8, el9);
        dom.appendChild(el7, el8);
        var el8 = dom.createTextNode("\n            ");
        dom.appendChild(el7, el8);
        dom.appendChild(el6, el7);
        var el7 = dom.createTextNode("\n            ");
        dom.appendChild(el6, el7);
        var el7 = dom.createElement("label");
        dom.setAttribute(el7, "class", "btn btn-default btn-sm toggle-btn");
        var el8 = dom.createTextNode("\n              ");
        dom.appendChild(el7, el8);
        var el8 = dom.createElement("input");
        dom.setAttribute(el8, "type", "radio");
        dom.setAttribute(el8, "name", "custom");
        dom.appendChild(el7, el8);
        var el8 = dom.createElement("b");
        var el9 = dom.createTextNode("Custom");
        dom.appendChild(el8, el9);
        dom.appendChild(el7, el8);
        var el8 = dom.createTextNode("\n            ");
        dom.appendChild(el7, el8);
        dom.appendChild(el6, el7);
        var el7 = dom.createTextNode("\n          ");
        dom.appendChild(el6, el7);
        dom.appendChild(el5, el6);
        var el6 = dom.createTextNode("\n\n          ");
        dom.appendChild(el5, el6);
        var el6 = dom.createElement("div");
        dom.setAttribute(el6, "class", "col-md-12 content-area");
        var el7 = dom.createTextNode("\n");
        dom.appendChild(el6, el7);
        var el7 = dom.createComment("");
        dom.appendChild(el6, el7);
        var el7 = dom.createTextNode("\n");
        dom.appendChild(el6, el7);
        var el7 = dom.createComment("");
        dom.appendChild(el6, el7);
        var el7 = dom.createTextNode("          ");
        dom.appendChild(el6, el7);
        dom.appendChild(el5, el6);
        var el6 = dom.createTextNode("\n\n          ");
        dom.appendChild(el5, el6);
        var el6 = dom.createElement("div");
        dom.setAttribute(el6, "class", "col-md-12 action-btns");
        var el7 = dom.createTextNode("\n            ");
        dom.appendChild(el6, el7);
        var el7 = dom.createElement("button");
        dom.setAttribute(el7, "class", "btn btn-default btn-sm");
        var el8 = dom.createTextNode("\n              Reset\n            ");
        dom.appendChild(el7, el8);
        dom.appendChild(el6, el7);
        var el7 = dom.createTextNode("\n            ");
        dom.appendChild(el6, el7);
        var el7 = dom.createElement("button");
        dom.setAttribute(el7, "class", "btn btn-primary btn-sm");
        var el8 = dom.createTextNode("\n              Save\n            ");
        dom.appendChild(el7, el8);
        dom.appendChild(el6, el7);
        var el7 = dom.createTextNode("\n            ");
        dom.appendChild(el6, el7);
        var el7 = dom.createElement("button");
        dom.setAttribute(el7, "class", "btn btn-success btn-sm");
        var el8 = dom.createTextNode("\n              Deploy\n            ");
        dom.appendChild(el7, el8);
        dom.appendChild(el6, el7);
        var el7 = dom.createTextNode("\n          ");
        dom.appendChild(el6, el7);
        dom.appendChild(el5, el6);
        var el6 = dom.createTextNode("\n        ");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createElement("div");
        dom.setAttribute(el1, "class", "modal fade deploy-service-modal");
        dom.setAttribute(el1, "tabindex", "-1");
        dom.setAttribute(el1, "role", "dialog");
        dom.setAttribute(el1, "id", "saveListModal");
        var el2 = dom.createTextNode("\n  ");
        dom.appendChild(el1, el2);
        var el2 = dom.createElement("div");
        dom.setAttribute(el2, "class", "modal-dialog");
        dom.setAttribute(el2, "role", "document");
        var el3 = dom.createTextNode("\n    ");
        dom.appendChild(el2, el3);
        var el3 = dom.createElement("div");
        dom.setAttribute(el3, "class", "modal-content");
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("div");
        dom.setAttribute(el4, "class", "modal-header");
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("button");
        dom.setAttribute(el5, "type", "button");
        dom.setAttribute(el5, "class", "close");
        dom.setAttribute(el5, "data-dismiss", "modal");
        dom.setAttribute(el5, "aria-label", "Close");
        var el6 = dom.createElement("span");
        dom.setAttribute(el6, "aria-hidden", "true");
        var el7 = dom.createTextNode("×");
        dom.appendChild(el6, el7);
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("h4");
        dom.setAttribute(el5, "class", "modal-title");
        var el6 = dom.createTextNode("Save Template As");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("div");
        dom.setAttribute(el4, "class", "modal-body");
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("div");
        dom.setAttribute(el5, "class", "form-group");
        var el6 = dom.createTextNode("\n          ");
        dom.appendChild(el5, el6);
        var el6 = dom.createElement("label");
        var el7 = dom.createTextNode("Template Name");
        dom.appendChild(el6, el7);
        dom.appendChild(el5, el6);
        var el6 = dom.createTextNode("\n          ");
        dom.appendChild(el5, el6);
        var el6 = dom.createComment("");
        dom.appendChild(el5, el6);
        var el6 = dom.createTextNode("\n        ");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n      ");
        dom.appendChild(el3, el4);
        var el4 = dom.createElement("div");
        dom.setAttribute(el4, "class", "modal-footer");
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("button");
        dom.setAttribute(el5, "type", "button");
        dom.setAttribute(el5, "class", "btn btn-default");
        dom.setAttribute(el5, "data-dismiss", "modal");
        var el6 = dom.createTextNode("Close");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n        ");
        dom.appendChild(el4, el5);
        var el5 = dom.createElement("button");
        dom.setAttribute(el5, "type", "button");
        dom.setAttribute(el5, "class", "btn btn-primary");
        var el6 = dom.createTextNode("Add");
        dom.appendChild(el5, el6);
        dom.appendChild(el4, el5);
        var el5 = dom.createTextNode("\n      ");
        dom.appendChild(el4, el5);
        dom.appendChild(el3, el4);
        var el4 = dom.createTextNode("\n    ");
        dom.appendChild(el3, el4);
        dom.appendChild(el2, el3);
        var el3 = dom.createTextNode("\n  ");
        dom.appendChild(el2, el3);
        dom.appendChild(el1, el2);
        var el2 = dom.createTextNode("\n");
        dom.appendChild(el1, el2);
        dom.appendChild(el0, el1);
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var element5 = dom.childAt(fragment, [1]);
        var element6 = dom.childAt(element5, [4]);
        var element7 = dom.childAt(element6, [3, 1]);
        var element8 = dom.childAt(element7, [3]);
        var element9 = dom.childAt(element8, [3]);
        var element10 = dom.childAt(element9, [1]);
        if (this.cachedFragment) {
          dom.repairClonedNode(dom.childAt(element10, [1]), [], true);
        }
        var element11 = dom.childAt(element9, [3]);
        var element12 = dom.childAt(element8, [5]);
        var element13 = dom.childAt(element8, [7]);
        var element14 = dom.childAt(element13, [1]);
        var element15 = dom.childAt(element13, [3]);
        var element16 = dom.childAt(element13, [5]);
        var element17 = dom.childAt(fragment, [3, 1, 1]);
        var element18 = dom.childAt(element17, [5, 3]);
        var morphs = new Array(18);
        morphs[0] = dom.createMorphAt(element5, 1, 1);
        morphs[1] = dom.createMorphAt(element5, 2, 2);
        morphs[2] = dom.createAttrMorph(element6, 'class');
        morphs[3] = dom.createMorphAt(element6, 1, 1);
        morphs[4] = dom.createMorphAt(dom.childAt(element7, [1, 3, 1]), 1, 1);
        morphs[5] = dom.createElementMorph(element10);
        morphs[6] = dom.createElementMorph(element11);
        morphs[7] = dom.createMorphAt(element12, 1, 1);
        morphs[8] = dom.createMorphAt(element12, 3, 3);
        morphs[9] = dom.createAttrMorph(element14, 'disabled');
        morphs[10] = dom.createElementMorph(element14);
        morphs[11] = dom.createAttrMorph(element15, 'disabled');
        morphs[12] = dom.createElementMorph(element15);
        morphs[13] = dom.createAttrMorph(element16, 'disabled');
        morphs[14] = dom.createElementMorph(element16);
        morphs[15] = dom.createMorphAt(dom.childAt(element17, [3, 1]), 3, 3);
        morphs[16] = dom.createAttrMorph(element18, 'disabled');
        morphs[17] = dom.createElementMorph(element18);
        return morphs;
      },
      statements: [["block", "if", [["get", "serviceResp", ["loc", [null, [20, 8], [20, 19]]], 0, 0, 0, 0]], [], 0, null, ["loc", [null, [20, 2], [31, 9]]]], ["block", "if", [["get", "isSecurityNotEnabled", ["loc", [null, [32, 8], [32, 28]]], 0, 0, 0, 0]], [], 1, null, ["loc", [null, [32, 2], [43, 9]]]], ["attribute", "class", ["concat", ["panel panel-default ", ["subexpr", "if", [["get", "isLoading", ["loc", [null, [44, 39], [44, 48]]], 0, 0, 0, 0], "loading-state"], [], ["loc", [null, [44, 34], [44, 66]]], 0, 0]], 0, 0, 0, 0, 0], 0, 0, 0, 0], ["block", "if", [["get", "isLoading", ["loc", [null, [45, 10], [45, 19]]], 0, 0, 0, 0]], [], 2, null, ["loc", [null, [45, 4], [47, 11]]]], ["block", "each", [["get", "getSavedList", ["loc", [null, [54, 22], [54, 34]]], 0, 0, 0, 0]], [], 3, 4, ["loc", [null, [54, 14], [61, 23]]]], ["element", "action", ["updateViewType", "standard"], [], ["loc", [null, [69, 68], [69, 106]]], 0, 0], ["element", "action", ["updateViewType", "custom"], [], ["loc", [null, [72, 61], [72, 97]]], 0, 0], ["block", "if", [["get", "isStandardViewType", ["loc", [null, [78, 18], [78, 36]]], 0, 0, 0, 0]], [], 5, null, ["loc", [null, [78, 12], [135, 19]]]], ["block", "if", [["get", "isCustomViewType", ["loc", [null, [137, 18], [137, 34]]], 0, 0, 0, 0]], [], 6, null, ["loc", [null, [137, 12], [141, 19]]]], ["attribute", "disabled", ["subexpr", "if", [["get", "isLoading", ["loc", [null, [145, 91], [145, 100]]], 0, 0, 0, 0], "disabled"], [], ["loc", [null, [null, null], [145, 113]]], 0, 0], 0, 0, 0, 0], ["element", "action", ["clearConfigs"], [], ["loc", [null, [145, 51], [145, 76]]], 0, 0], ["attribute", "disabled", ["subexpr", "unless", [["get", "enableSaveOrDeployBtn", ["loc", [null, [148, 69], [148, 90]]], 0, 0, 0, 0], "disabled"], [], ["loc", [null, [null, null], [148, 103]]], 0, 0], 0, 0, 0, 0], ["element", "action", ["showSaveTemplateModal"], [], ["loc", [null, [148, 104], [148, 138]]], 0, 0], ["attribute", "disabled", ["subexpr", "unless", [["get", "enableSaveOrDeployBtn", ["loc", [null, [151, 69], [151, 90]]], 0, 0, 0, 0], "disabled"], [], ["loc", [null, [null, null], [151, 103]]], 0, 0], 0, 0, 0, 0], ["element", "action", ["deployService"], [], ["loc", [null, [151, 104], [151, 130]]], 0, 0], ["inline", "input", [], ["type", "text", "class", "form-control", "id", "templateNameInput", "value", ["subexpr", "@mut", [["get", "savedTemplateName", ["loc", [null, [171, 80], [171, 97]]], 0, 0, 0, 0]], [], [], 0, 0]], ["loc", [null, [171, 10], [171, 99]]], 0, 0], ["attribute", "disabled", ["subexpr", "unless", [["get", "isValidTemplateName", ["loc", [null, [176, 100], [176, 119]]], 0, 0, 0, 0], "disabled"], [], ["loc", [null, [null, null], [176, 132]]], 0, 0], 0, 0, 0, 0], ["element", "action", ["addToSavedList"], [], ["loc", [null, [176, 54], [176, 81]]], 0, 0]],
      locals: [],
      templates: [child0, child1, child2, child3, child4, child5, child6]
    };
  })());
});
define("yarn-ui/templates/components/em-table-html-cell", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 19,
              "column": 0
            },
            "end": {
              "line": 21,
              "column": 0
            }
          },
          "moduleName": "yarn-ui/templates/components/em-table-html-cell.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createUnsafeMorphAt(fragment, 1, 1, contextualElement);
          return morphs;
        },
        statements: [["content", "content", ["loc", [null, [20, 2], [20, 15]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 21,
              "column": 0
            },
            "end": {
              "line": 23,
              "column": 0
            }
          },
          "moduleName": "yarn-ui/templates/components/em-table-html-cell.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("span");
          dom.setAttribute(el1, "class", "txt-message");
          var el2 = dom.createTextNode("Not Available!");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes() {
          return [];
        },
        statements: [],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 24,
            "column": 0
          }
        },
        "moduleName": "yarn-ui/templates/components/em-table-html-cell.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createTextNode("\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "content", ["loc", [null, [19, 6], [19, 13]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [19, 0], [23, 7]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
});
define("yarn-ui/templates/components/em-table-simple-status-cell", ["exports"], function (exports) {
  exports["default"] = Ember.HTMLBars.template((function () {
    var child0 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 20,
              "column": 0
            },
            "end": {
              "line": 25,
              "column": 0
            }
          },
          "moduleName": "yarn-ui/templates/components/em-table-simple-status-cell.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("span");
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createElement("i");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n    ");
          dom.appendChild(el1, el2);
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
          var el2 = dom.createTextNode("\n  ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var element0 = dom.childAt(fragment, [1]);
          var element1 = dom.childAt(element0, [1]);
          var morphs = new Array(2);
          morphs[0] = dom.createAttrMorph(element1, 'class');
          morphs[1] = dom.createMorphAt(element0, 3, 3);
          return morphs;
        },
        statements: [["attribute", "class", ["subexpr", "lower", [["get", "content", ["loc", [null, [22, 21], [22, 28]]], 0, 0, 0, 0]], [], ["loc", [null, [null, null], [22, 30]]], 0, 0], 0, 0, 0, 0], ["content", "statusName", ["loc", [null, [23, 4], [23, 18]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {
          "revision": "Ember@2.8.0",
          "loc": {
            "source": null,
            "start": {
              "line": 25,
              "column": 0
            },
            "end": {
              "line": 27,
              "column": 0
            }
          },
          "moduleName": "yarn-ui/templates/components/em-table-simple-status-cell.hbs"
        },
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createTextNode("  ");
          dom.appendChild(el0, el1);
          var el1 = dom.createElement("span");
          dom.setAttribute(el1, "class", "txt-message");
          var el2 = dom.createTextNode(" N/A ");
          dom.appendChild(el1, el2);
          dom.appendChild(el0, el1);
          var el1 = dom.createTextNode("\n");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes() {
          return [];
        },
        statements: [],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {
        "revision": "Ember@2.8.0",
        "loc": {
          "source": null,
          "start": {
            "line": 1,
            "column": 0
          },
          "end": {
            "line": 28,
            "column": 0
          }
        },
        "moduleName": "yarn-ui/templates/components/em-table-simple-status-cell.hbs"
      },
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createTextNode("\n\n");
        dom.appendChild(el0, el1);
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 1, 1, contextualElement);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      stat