/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.yarn.service.api.records.ConfigFormat;
import org.apache.hadoop.yarn.service.utils.ConfigHelper;
import org.apache.hadoop.yarn.service.utils.ConfigUtils;
import org.apache.hadoop.yarn.service.utils.PublishedConfiguration;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public abstract class PublishedConfigurationOutputter {
    private static final String COMMENTS = "Generated by Apache Slider";
    protected final PublishedConfiguration owner;

    protected PublishedConfigurationOutputter(PublishedConfiguration owner) {
        this.owner = owner;
    }

    public void save(File dest) throws IOException {
        FileUtils.writeStringToFile((File)dest, (String)this.asString(), (Charset)StandardCharsets.UTF_8);
    }

    public void save(OutputStream out) throws IOException {
        IOUtils.write((String)this.asString(), (OutputStream)out, (Charset)StandardCharsets.UTF_8);
    }

    public abstract String asString() throws IOException;

    public static PublishedConfigurationOutputter createOutputter(ConfigFormat format, PublishedConfiguration owner) {
        Preconditions.checkNotNull((Object)owner);
        switch (format) {
            case XML: 
            case HADOOP_XML: {
                return new XmlOutputter(owner);
            }
            case PROPERTIES: {
                return new PropertiesOutputter(owner);
            }
            case JSON: {
                return new JsonOutputter(owner);
            }
            case TEMPLATE: {
                return new TemplateOutputter(owner);
            }
            case YAML: {
                return new YamlOutputter(owner);
            }
        }
        throw new RuntimeException("Unsupported format :" + format);
    }

    public static class XmlOutputter
    extends PublishedConfigurationOutputter {
        private final Configuration configuration;

        public XmlOutputter(PublishedConfiguration owner) {
            super(owner);
            this.configuration = owner.asConfiguration();
        }

        @Override
        public void save(OutputStream out) throws IOException {
            this.configuration.writeXml(out);
        }

        @Override
        public String asString() throws IOException {
            return ConfigHelper.toXml(this.configuration);
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }
    }

    public static class PropertiesOutputter
    extends PublishedConfigurationOutputter {
        private final Properties properties;

        public PropertiesOutputter(PublishedConfiguration owner) {
            super(owner);
            this.properties = owner.asProperties();
        }

        @Override
        public void save(OutputStream out) throws IOException {
            this.properties.store(out, PublishedConfigurationOutputter.COMMENTS);
        }

        @Override
        public String asString() throws IOException {
            StringWriter sw = new StringWriter();
            this.properties.store(sw, PublishedConfigurationOutputter.COMMENTS);
            return sw.toString();
        }
    }

    public static class JsonOutputter
    extends PublishedConfigurationOutputter {
        public JsonOutputter(PublishedConfiguration owner) {
            super(owner);
        }

        @Override
        public String asString() throws IOException {
            return this.owner.asJson();
        }
    }

    public static class TemplateOutputter
    extends EnvOutputter {
        public TemplateOutputter(PublishedConfiguration owner) {
            super(owner);
        }
    }

    public static class YamlOutputter
    extends PublishedConfigurationOutputter {
        private final Yaml yaml;

        public YamlOutputter(PublishedConfiguration owner) {
            super(owner);
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            this.yaml = new Yaml(options);
        }

        @Override
        public String asString() throws IOException {
            return this.yaml.dump(this.owner.entries);
        }
    }

    public static class EnvOutputter
    extends PublishedConfigurationOutputter {
        public EnvOutputter(PublishedConfiguration owner) {
            super(owner);
        }

        @Override
        public String asString() throws IOException {
            if (!this.owner.entries.containsKey("content")) {
                throw new IOException("Configuration has no content field and cannot be retrieved as type 'env'");
            }
            String content = this.owner.entries.get("content");
            return ConfigUtils.replaceProps(this.owner.entries, content);
        }
    }
}

