/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.service.ServiceTestUtils;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.KerberosPrincipal;
import org.apache.hadoop.yarn.service.api.records.PlacementConstraint;
import org.apache.hadoop.yarn.service.api.records.PlacementPolicy;
import org.apache.hadoop.yarn.service.api.records.PlacementScope;
import org.apache.hadoop.yarn.service.api.records.PlacementType;
import org.apache.hadoop.yarn.service.api.records.Resource;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.conf.RestApiConstants;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.service.utils.SliderFileSystem;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestServiceApiUtil
extends ServiceTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TestServiceApiUtil.class);
    private static final String EXCEPTION_PREFIX = "Should have thrown exception: ";
    private static final String NO_EXCEPTION_PREFIX = "Should not have thrown exception: ";
    private static final String LEN_64_STR = "abcdefghijklmnopqrstuvwxyz0123456789abcdefghijklmnopqrstuvwxyz01";
    private static final YarnConfiguration CONF_DEFAULT_DNS = new YarnConfiguration();
    private static final YarnConfiguration CONF_DNS_ENABLED = new YarnConfiguration();

    @BeforeAll
    public static void init() {
        CONF_DNS_ENABLED.setBoolean("hadoop.registry.dns.enabled", true);
    }

    @Test
    @Timeout(value=90L)
    public void testResourceValidation() throws Exception {
        String[] badNames;
        org.junit.jupiter.api.Assertions.assertEquals((int)64, (int)LEN_64_STR.length());
        SliderFileSystem sfs = ServiceTestUtils.initMockFs();
        Service app = new Service();
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: service with no name");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"Service name is either empty or not provided", (Object)e.getMessage());
        }
        app.setName("test");
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception:  service with no version");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)String.format("Version of service %s is either empty or not provided", app.getName()), (Object)e.getMessage());
        }
        app.setVersion("v1");
        for (String badName : badNames = new String[]{"4finance", "Finance", "finance@home", LEN_64_STR}) {
            app.setName(badName);
            try {
                ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
                org.junit.jupiter.api.Assertions.fail((String)("Should have thrown exception: service with bad name " + badName));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        app.setName(LEN_64_STR);
        Component comp = new Component().name("comp1");
        app.addComponent(comp);
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DEFAULT_DNS);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: service with no launch command");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"launch_command is required when type is not DOCKER", (Object)e.getMessage());
        }
        app.setName(LEN_64_STR.substring(0, 63));
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: service with no launch command");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"launch_command is required when type is not DOCKER", (Object)e.getMessage());
        }
        comp.setLaunchCommand("sleep 1");
        Resource res = new Resource();
        app.setResource(res);
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: service with no memory");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)String.format("Service resource or memory not provided for component %s (nor at the global level)", comp.getName()), (Object)e.getMessage());
        }
        res.setMemory("100mb");
        res.setCpus(Integer.valueOf(-2));
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: service with invalid no of cpus");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)String.format("Unacceptable no of cpus specified, either zero or negative for component %s (or at the global level)", comp.getName()), (Object)e.getMessage());
        }
        res.setCpus(Integer.valueOf(2));
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: service with no container count");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)e.getMessage().contains("Invalid no of containers specified"));
        }
        res.setProfile("hbase_finance_large");
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: service with resource profile along with cpus/memory");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)String.format("Cannot specify cpus/memory along with profile for component %s", comp.getName()), (Object)e.getMessage());
        }
        res.setCpus(null);
        res.setMemory(null);
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: service with resource profile only");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"Resource profile is not supported yet. Please specify cpus/memory.", (Object)e.getMessage());
        }
        res.setProfile(null);
        res.setCpus(Integer.valueOf(2));
        res.setMemory("2gb");
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: null number of containers");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)e.getMessage().startsWith("Invalid no of containers specified"));
        }
    }

    @Test
    public void testArtifacts() throws IOException {
        SliderFileSystem sfs = ServiceTestUtils.initMockFs();
        Service app = new Service();
        app.setName("service1");
        app.setVersion("v1");
        Resource res = new Resource();
        app.setResource(res);
        res.setMemory("512M");
        Artifact artifact = new Artifact();
        app.setArtifact(artifact);
        String compName = "comp1";
        Component comp = ServiceTestUtils.createComponent(compName);
        app.setComponents(Collections.singletonList(comp));
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: service with no artifact id");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)String.format("Artifact id (like docker image name) is either empty or not provided for component %s (nor at the global level)", compName), (Object)e.getMessage());
        }
        artifact.setType(Artifact.TypeEnum.SERVICE);
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: service with no artifact id");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"Artifact id (like docker image name) is either empty or not provided", (Object)e.getMessage());
        }
        artifact.setType(Artifact.TypeEnum.TARBALL);
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: service with no artifact id");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)String.format("Artifact id (like docker image name) is either empty or not provided for component %s (nor at the global level)", compName), (Object)e.getMessage());
        }
        artifact.setType(Artifact.TypeEnum.DOCKER);
        artifact.setId("docker.io/centos:centos7");
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
        }
        catch (IllegalArgumentException e) {
            LOG.error("service attributes specified should be valid here", (Throwable)e);
            org.junit.jupiter.api.Assertions.fail((String)(NO_EXCEPTION_PREFIX + e.getMessage()));
        }
        Assertions.assertThat((Long)app.getLifetime()).isEqualTo((Object)RestApiConstants.DEFAULT_UNLIMITED_LIFETIME);
    }

    private static Resource createValidResource() {
        Resource res = new Resource();
        res.setMemory("512M");
        return res;
    }

    private static Component createValidComponent(String compName) {
        Component comp = new Component();
        comp.setName(compName);
        comp.setResource(TestServiceApiUtil.createValidResource());
        comp.setNumberOfContainers(Long.valueOf(1L));
        comp.setLaunchCommand("sleep 1");
        return comp;
    }

    private static Service createValidApplication(String compName) {
        Service app = new Service();
        app.setName("name");
        app.setVersion("v1");
        app.setResource(TestServiceApiUtil.createValidResource());
        if (compName != null) {
            app.addComponent(TestServiceApiUtil.createValidComponent(compName));
        }
        return app;
    }

    @Test
    public void testExternalApplication() throws IOException {
        Service ext = TestServiceApiUtil.createValidApplication("comp1");
        SliderFileSystem sfs = ServiceTestUtils.initMockFs(ext);
        Service app = TestServiceApiUtil.createValidApplication(null);
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.SERVICE);
        artifact.setId("id");
        app.setArtifact(artifact);
        app.addComponent(ServiceTestUtils.createComponent("comp2"));
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.fail((String)(NO_EXCEPTION_PREFIX + e.getMessage()));
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)app.getComponents().size());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)app.getComponent("comp2"));
    }

    @Test
    public void testDuplicateComponents() throws IOException {
        SliderFileSystem sfs = ServiceTestUtils.initMockFs();
        String compName = "comp1";
        Service app = TestServiceApiUtil.createValidApplication(compName);
        app.addComponent(TestServiceApiUtil.createValidComponent(compName));
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: service with component collision");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)("Component name collision: " + compName), (Object)e.getMessage());
        }
    }

    @Test
    public void testComponentNameSameAsServiceName() throws IOException {
        SliderFileSystem sfs = ServiceTestUtils.initMockFs();
        Service app = new Service();
        app.setName("test");
        app.setVersion("v1");
        app.addComponent(TestServiceApiUtil.createValidComponent("test"));
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: component name matches service name");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"Component name test must not be same as service name test", (Object)e.getMessage());
        }
    }

    @Test
    public void testExternalDuplicateComponent() throws IOException {
        Service ext = TestServiceApiUtil.createValidApplication("comp1");
        SliderFileSystem sfs = ServiceTestUtils.initMockFs(ext);
        Service app = TestServiceApiUtil.createValidApplication("comp1");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.SERVICE);
        artifact.setId("id");
        app.getComponent("comp1").setArtifact(artifact);
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.fail((String)(NO_EXCEPTION_PREFIX + e.getMessage()));
        }
    }

    @Test
    public void testExternalComponent() throws IOException {
        Service ext = TestServiceApiUtil.createValidApplication("comp1");
        SliderFileSystem sfs = ServiceTestUtils.initMockFs(ext);
        Service app = TestServiceApiUtil.createValidApplication("comp2");
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.SERVICE);
        artifact.setId("id");
        app.setArtifact(artifact);
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.fail((String)(NO_EXCEPTION_PREFIX + e.getMessage()));
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)app.getComponents().size());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)app.getComponent("comp2"));
        app.getComponent("comp2").setArtifact(artifact);
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.fail((String)(NO_EXCEPTION_PREFIX + e.getMessage()));
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)app.getComponents().size());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)app.getComponent("comp1"));
    }

    public static void verifyDependencySorting(List<Component> components, Component ... expectedSorting) {
        Collection actualSorting = ServiceApiUtil.sortByDependencies(components);
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedSorting.length, (int)actualSorting.size());
        int i = 0;
        for (Component component : actualSorting) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)expectedSorting[i++], (Object)component);
        }
    }

    @Test
    public void testDependencySorting() throws IOException {
        Component a = ServiceTestUtils.createComponent("a");
        Component b = ServiceTestUtils.createComponent("b");
        Component c = ServiceTestUtils.createComponent("c");
        Component d = ServiceTestUtils.createComponent("d").dependencies(Arrays.asList("c"));
        Component e = ServiceTestUtils.createComponent("e").dependencies(Arrays.asList("b", "d"));
        TestServiceApiUtil.verifyDependencySorting(Arrays.asList(a, b, c), a, b, c);
        TestServiceApiUtil.verifyDependencySorting(Arrays.asList(c, a, b), c, a, b);
        TestServiceApiUtil.verifyDependencySorting(Arrays.asList(a, b, c, d, e), a, b, c, d, e);
        TestServiceApiUtil.verifyDependencySorting(Arrays.asList(e, d, c, b, a), c, b, a, d, e);
        c.setDependencies(Arrays.asList("e"));
        try {
            TestServiceApiUtil.verifyDependencySorting(Arrays.asList(a, b, c, d, e), new Component[0]);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: components with dependency cycle");
        }
        catch (IllegalArgumentException ex) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)String.format("Invalid dependencies, a cycle may exist: %s", Arrays.asList(c, d, e)), (Object)ex.getMessage());
        }
        SliderFileSystem sfs = ServiceTestUtils.initMockFs();
        Service service = TestServiceApiUtil.createValidApplication(null);
        service.setComponents(Arrays.asList(c, d, e));
        try {
            ServiceApiUtil.validateAndResolveService((Service)service, (SliderFileSystem)sfs, (Configuration)CONF_DEFAULT_DNS);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: components with bad dependencies");
        }
        catch (IllegalArgumentException ex) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)String.format("Dependency %s for component %s is invalid, does not exist as a component", "b", "e"), (Object)ex.getMessage());
        }
    }

    @Test
    public void testInvalidComponent() throws IOException {
        SliderFileSystem sfs = ServiceTestUtils.initMockFs();
        TestServiceApiUtil.testComponent(sfs);
    }

    @Test
    public void testValidateCompName() {
        String[] invalidNames;
        for (String name : invalidNames = new String[]{"EXAMPLE", "example_app"}) {
            try {
                ServiceApiUtil.validateNameFormat((String)name, (Configuration)new Configuration());
                org.junit.jupiter.api.Assertions.fail();
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void testComponent(SliderFileSystem sfs) throws IOException {
        int maxLen = 63;
        org.junit.jupiter.api.Assertions.assertEquals((int)19, (int)Long.toString(Long.MAX_VALUE).length());
        String compName = LEN_64_STR.substring(0, (maxLen -= Long.toString(Long.MAX_VALUE).length()) + 1);
        Service app = TestServiceApiUtil.createValidApplication(null);
        app.addComponent(TestServiceApiUtil.createValidComponent(compName));
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: service with invalid component name");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)String.format("Component name must be no more than %s characters: %s", maxLen, compName), (Object)e.getMessage());
        }
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DEFAULT_DNS);
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.fail((String)(NO_EXCEPTION_PREFIX + e.getMessage()));
        }
        compName = LEN_64_STR.substring(0, maxLen);
        app = TestServiceApiUtil.createValidApplication(null);
        app.addComponent(TestServiceApiUtil.createValidComponent(compName));
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.fail((String)(NO_EXCEPTION_PREFIX + e.getMessage()));
        }
    }

    @Test
    public void testPlacementPolicy() throws IOException {
        SliderFileSystem sfs = ServiceTestUtils.initMockFs();
        Service app = TestServiceApiUtil.createValidApplication("comp-a");
        Component comp = (Component)app.getComponents().get(0);
        PlacementPolicy pp = new PlacementPolicy();
        PlacementConstraint pc = new PlacementConstraint();
        pc.setName("CA1");
        pp.setConstraints(Collections.singletonList(pc));
        comp.setPlacementPolicy(pp);
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: constraint with no type");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)String.format("Type not specified for constraint %sin placement policy of component %s.", "CA1 ", "comp-a"), (Object)e.getMessage());
        }
        pc.setType(PlacementType.ANTI_AFFINITY);
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: constraint with no scope");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)String.format("Scope not specified for constraint %sin placement policy of component %s.", "CA1 ", "comp-a"), (Object)e.getMessage());
        }
        pc.setScope(PlacementScope.NODE);
        pc.setTargetTags(Collections.singletonList("comp-a"));
        try {
            ServiceApiUtil.validateAndResolveService((Service)app, (SliderFileSystem)sfs, (Configuration)CONF_DNS_ENABLED);
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.fail((String)(NO_EXCEPTION_PREFIX + e.getMessage()));
        }
    }

    @Test
    public void testKerberosPrincipal() throws IOException {
        SliderFileSystem sfs = ServiceTestUtils.initMockFs();
        Service app = TestServiceApiUtil.createValidApplication("comp-a");
        KerberosPrincipal kp = new KerberosPrincipal();
        kp.setKeytab("file:///tmp/a.keytab");
        kp.setPrincipalName("user/_HOST@domain.com");
        app.setKerberosPrincipal(kp);
        try {
            ServiceApiUtil.validateKerberosPrincipal((KerberosPrincipal)app.getKerberosPrincipal());
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.fail((String)(NO_EXCEPTION_PREFIX + e.getMessage()));
        }
        kp.setKeytab("/some/path");
        try {
            ServiceApiUtil.validateKerberosPrincipal((KerberosPrincipal)app.getKerberosPrincipal());
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.fail((String)(NO_EXCEPTION_PREFIX + e.getMessage()));
        }
    }

    @Test
    public void testKerberosPrincipalNameFormat() throws IOException {
        Service app = TestServiceApiUtil.createValidApplication("comp-a");
        KerberosPrincipal kp = new KerberosPrincipal();
        kp.setPrincipalName("user@domain.com");
        app.setKerberosPrincipal(kp);
        try {
            ServiceApiUtil.validateKerberosPrincipal((KerberosPrincipal)app.getKerberosPrincipal());
            org.junit.jupiter.api.Assertions.fail((String)"Should have thrown exception: service with invalid principal name format.");
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)String.format("Kerberos principal (%s) does  not contain a hostname.", kp.getPrincipalName()), (Object)e.getMessage());
        }
        kp.setPrincipalName("user/_HOST@domain.com");
        try {
            ServiceApiUtil.validateKerberosPrincipal((KerberosPrincipal)app.getKerberosPrincipal());
        }
        catch (IllegalArgumentException e) {
            org.junit.jupiter.api.Assertions.fail((String)(NO_EXCEPTION_PREFIX + e.getMessage()));
        }
        kp.setPrincipalName(null);
        kp.setKeytab(null);
        try {
            ServiceApiUtil.validateKerberosPrincipal((KerberosPrincipal)app.getKerberosPrincipal());
        }
        catch (NullPointerException e) {
            org.junit.jupiter.api.Assertions.fail((String)(NO_EXCEPTION_PREFIX + e.getMessage()));
        }
    }

    @Test
    public void testResolveCompsDependency() {
        Service service = TestServiceApiUtil.createExampleApplication();
        ArrayList<String> dependencies = new ArrayList<String>();
        dependencies.add("compb");
        Component compa = TestServiceApiUtil.createComponent("compa");
        compa.setDependencies(dependencies);
        Component compb = TestServiceApiUtil.createComponent("compb");
        service.addComponent(compa);
        service.addComponent(compb);
        List order = ServiceApiUtil.resolveCompsDependency((Service)service);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("compb");
        expected.add("compa");
        for (int i = 0; i < expected.size(); ++i) {
            org.junit.jupiter.api.Assertions.assertEquals(expected.get(i), order.get(i), (String)"Components are not equal.");
        }
    }

    @Test
    public void testResolveCompsDependencyReversed() {
        Service service = TestServiceApiUtil.createExampleApplication();
        ArrayList<String> dependencies = new ArrayList<String>();
        dependencies.add("compa");
        Component compa = TestServiceApiUtil.createComponent("compa");
        Component compb = TestServiceApiUtil.createComponent("compb");
        compb.setDependencies(dependencies);
        service.addComponent(compa);
        service.addComponent(compb);
        List order = ServiceApiUtil.resolveCompsDependency((Service)service);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("compa");
        expected.add("compb");
        for (int i = 0; i < expected.size(); ++i) {
            org.junit.jupiter.api.Assertions.assertEquals(expected.get(i), order.get(i), (String)"Components are not equal.");
        }
    }

    @Test
    public void testResolveCompsCircularDependency() {
        Service service = TestServiceApiUtil.createExampleApplication();
        ArrayList<String> dependencies = new ArrayList<String>();
        ArrayList<String> dependencies2 = new ArrayList<String>();
        dependencies.add("compb");
        dependencies2.add("compa");
        Component compa = TestServiceApiUtil.createComponent("compa");
        compa.setDependencies(dependencies);
        Component compb = TestServiceApiUtil.createComponent("compb");
        compa.setDependencies(dependencies2);
        service.addComponent(compa);
        service.addComponent(compb);
        List order = ServiceApiUtil.resolveCompsDependency((Service)service);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("compa");
        expected.add("compb");
        for (int i = 0; i < expected.size(); ++i) {
            org.junit.jupiter.api.Assertions.assertEquals(expected.get(i), order.get(i), (String)"Components are not equal.");
        }
    }

    @Test
    public void testResolveNoCompsDependency() {
        Service service = TestServiceApiUtil.createExampleApplication();
        Component compa = TestServiceApiUtil.createComponent("compa");
        Component compb = TestServiceApiUtil.createComponent("compb");
        service.addComponent(compa);
        service.addComponent(compb);
        List order = ServiceApiUtil.resolveCompsDependency((Service)service);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("compa");
        expected.add("compb");
        for (int i = 0; i < expected.size(); ++i) {
            org.junit.jupiter.api.Assertions.assertEquals(expected.get(i), order.get(i), (String)"Components are not equal.");
        }
    }

    @Test
    @Timeout(value=1L)
    public void testNoServiceDependencies() {
        Service service = TestServiceApiUtil.createExampleApplication();
        Component compa = TestServiceApiUtil.createComponent("compa");
        Component compb = TestServiceApiUtil.createComponent("compb");
        service.addComponent(compa);
        service.addComponent(compb);
        ArrayList dependencies = new ArrayList();
        service.setDependencies(dependencies);
        ServiceApiUtil.checkServiceDependencySatisified((Service)service);
    }

    @Test
    public void testServiceDependencies() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                Service service = TestServiceApiUtil.createExampleApplication();
                Component compa = ServiceTestUtils.createComponent("compa");
                Component compb = ServiceTestUtils.createComponent("compb");
                service.addComponent(compa);
                service.addComponent(compb);
                ArrayList<String> dependencies = new ArrayList<String>();
                dependencies.add("abc");
                service.setDependencies(dependencies);
                Service dependent = TestServiceApiUtil.createExampleApplication();
                dependent.setState(ServiceState.STOPPED);
                ServiceApiUtil.checkServiceDependencySatisified((Service)service);
            }
        };
        thread.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)thread.isAlive());
    }

    @Test
    public void testJvmOpts() throws Exception {
        String invalidJvmOpts = "`ping -c 3 example.com`";
        LambdaTestUtils.intercept(IllegalArgumentException.class, (String)"Invalid character in yarn.service.am.java.opts.", () -> ServiceApiUtil.validateJvmOpts((String)invalidJvmOpts));
        String validJvmOpts = "-Dyarn.service.am.java.opts=-Xmx768m -Djava.security.auth.login.config=/opt/hadoop/etc/jaas-zk.conf";
        try {
            ServiceApiUtil.validateJvmOpts((String)validJvmOpts);
        }
        catch (Exception ex) {
            org.junit.jupiter.api.Assertions.fail((String)"Invalid character in yarn.service.am.java.opts.");
        }
    }

    public static Service createExampleApplication() {
        Service exampleApp = new Service();
        exampleApp.setName("example-app");
        exampleApp.setVersion("v1");
        return exampleApp;
    }
}

