/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import java.util.List;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.proto.ClientAMProtocol;
import org.apache.hadoop.yarn.service.MockRunningServiceContext;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.ServiceTestUtils;
import org.apache.hadoop.yarn.service.TestServiceManager;
import org.apache.hadoop.yarn.service.api.records.ComponentContainers;
import org.apache.hadoop.yarn.service.api.records.ContainerState;
import org.apache.hadoop.yarn.service.utils.FilterUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class TestFilterUtils {
    @RegisterExtension
    private ServiceTestUtils.ServiceFSWatcher rule = new ServiceTestUtils.ServiceFSWatcher();

    @Test
    public void testNoFilter() throws Exception {
        ClientAMProtocol.GetCompInstancesRequestProto req = ClientAMProtocol.GetCompInstancesRequestProto.newBuilder().build();
        List compContainers = FilterUtils.filterInstances((ServiceContext)new MockRunningServiceContext(this.rule, TestServiceManager.createBaseDef("service")), (ClientAMProtocol.GetCompInstancesRequestProto)req);
        Assertions.assertEquals((int)2, (int)compContainers.size(), (String)"num comps");
        compContainers.forEach(item -> Assertions.assertEquals((int)2, (int)item.getContainers().size(), (String)"num containers"));
    }

    @Test
    public void testFilterWithComp() throws Exception {
        ClientAMProtocol.GetCompInstancesRequestProto req = ClientAMProtocol.GetCompInstancesRequestProto.newBuilder().addAllComponentNames((Iterable)Lists.newArrayList((Object[])new String[]{"compa"})).build();
        List compContainers = FilterUtils.filterInstances((ServiceContext)new MockRunningServiceContext(this.rule, TestServiceManager.createBaseDef("service")), (ClientAMProtocol.GetCompInstancesRequestProto)req);
        Assertions.assertEquals((int)1, (int)compContainers.size(), (String)"num comps");
        Assertions.assertEquals((Object)"compa", (Object)((ComponentContainers)compContainers.get(0)).getComponentName(), (String)"comp name");
        Assertions.assertEquals((int)2, (int)((ComponentContainers)compContainers.get(0)).getContainers().size(), (String)"num containers");
    }

    @Test
    public void testFilterWithVersion() throws Exception {
        MockRunningServiceContext sc = new MockRunningServiceContext(this.rule, TestServiceManager.createBaseDef("service"));
        ClientAMProtocol.GetCompInstancesRequestProto.Builder reqBuilder = ClientAMProtocol.GetCompInstancesRequestProto.newBuilder();
        reqBuilder.setVersion("v2");
        Assertions.assertEquals((int)0, (int)FilterUtils.filterInstances((ServiceContext)sc, (ClientAMProtocol.GetCompInstancesRequestProto)reqBuilder.build()).size(), (String)"num comps");
        reqBuilder.addAllComponentNames((Iterable)Lists.newArrayList((Object[])new String[]{"compa"})).setVersion("v1").build();
        Assertions.assertEquals((int)2, (int)((ComponentContainers)FilterUtils.filterInstances((ServiceContext)sc, (ClientAMProtocol.GetCompInstancesRequestProto)reqBuilder.build()).get(0)).getContainers().size(), (String)"num containers");
    }

    @Test
    public void testFilterWithState() throws Exception {
        MockRunningServiceContext sc = new MockRunningServiceContext(this.rule, TestServiceManager.createBaseDef("service"));
        ClientAMProtocol.GetCompInstancesRequestProto.Builder reqBuilder = ClientAMProtocol.GetCompInstancesRequestProto.newBuilder();
        reqBuilder.addAllContainerStates((Iterable)Lists.newArrayList((Object[])new String[]{ContainerState.READY.toString()}));
        List compContainers = FilterUtils.filterInstances((ServiceContext)sc, (ClientAMProtocol.GetCompInstancesRequestProto)reqBuilder.build());
        Assertions.assertEquals((int)2, (int)compContainers.size(), (String)"num comps");
        compContainers.forEach(item -> Assertions.assertEquals((int)2, (int)item.getContainers().size(), (String)"num containers"));
        reqBuilder.clearContainerStates();
        reqBuilder.addAllContainerStates((Iterable)Lists.newArrayList((Object[])new String[]{ContainerState.STOPPED.toString()}));
        Assertions.assertEquals((int)0, (int)FilterUtils.filterInstances((ServiceContext)sc, (ClientAMProtocol.GetCompInstancesRequestProto)reqBuilder.build()).size(), (String)"num comps");
    }
}

