/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.providers;

import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.provider.ProviderFactory;
import org.apache.hadoop.yarn.service.provider.defaultImpl.DefaultClientProvider;
import org.apache.hadoop.yarn.service.provider.defaultImpl.DefaultProviderFactory;
import org.apache.hadoop.yarn.service.provider.defaultImpl.DefaultProviderService;
import org.apache.hadoop.yarn.service.provider.docker.DockerClientProvider;
import org.apache.hadoop.yarn.service.provider.docker.DockerProviderFactory;
import org.apache.hadoop.yarn.service.provider.docker.DockerProviderService;
import org.apache.hadoop.yarn.service.provider.tarball.TarballClientProvider;
import org.apache.hadoop.yarn.service.provider.tarball.TarballProviderFactory;
import org.apache.hadoop.yarn.service.provider.tarball.TarballProviderService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestProviderFactory {
    @Test
    public void testDockerFactory() throws Throwable {
        ProviderFactory factory = ProviderFactory.createServiceProviderFactory((Artifact)new Artifact().type(Artifact.TypeEnum.DOCKER));
        Assertions.assertTrue((boolean)(factory instanceof DockerProviderFactory));
        Assertions.assertTrue((boolean)(factory.createClientProvider() instanceof DockerClientProvider));
        Assertions.assertTrue((boolean)(factory.createServerProvider() instanceof DockerProviderService));
        Assertions.assertTrue((boolean)(ProviderFactory.getProviderService((Artifact)new Artifact().type(Artifact.TypeEnum.DOCKER)) instanceof DockerProviderService));
    }

    @Test
    public void testTarballFactory() throws Throwable {
        ProviderFactory factory = ProviderFactory.createServiceProviderFactory((Artifact)new Artifact().type(Artifact.TypeEnum.TARBALL));
        Assertions.assertTrue((boolean)(factory instanceof TarballProviderFactory));
        Assertions.assertTrue((boolean)(factory.createClientProvider() instanceof TarballClientProvider));
        Assertions.assertTrue((boolean)(factory.createServerProvider() instanceof TarballProviderService));
        Assertions.assertTrue((boolean)(ProviderFactory.getProviderService((Artifact)new Artifact().type(Artifact.TypeEnum.TARBALL)) instanceof TarballProviderService));
    }

    @Test
    public void testDefaultFactory() throws Throwable {
        ProviderFactory factory = ProviderFactory.createServiceProviderFactory(null);
        Assertions.assertTrue((boolean)(factory instanceof DefaultProviderFactory));
        Assertions.assertTrue((boolean)(factory.createClientProvider() instanceof DefaultClientProvider));
        Assertions.assertTrue((boolean)(factory.createServerProvider() instanceof DefaultProviderService));
        Assertions.assertTrue((boolean)(ProviderFactory.getProviderService(null) instanceof DefaultProviderService));
    }
}

