/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.providers;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.service.api.records.ConfigFile;
import org.apache.hadoop.yarn.service.provider.defaultImpl.DefaultClientProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestDefaultClientProvider {
    private static final String EXCEPTION_PREFIX = "Should have thrown exception: ";
    private static final String NO_EXCEPTION_PREFIX = "Should not have thrown exception: ";

    @Test
    public void testConfigFile() throws IOException {
        DefaultClientProvider defaultClientProvider = new DefaultClientProvider();
        FileSystem mockFs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)mockFs.exists((Path)ArgumentMatchers.any())).thenReturn((Object)true);
        String compName = "sleeper";
        ConfigFile configFile = new ConfigFile();
        configFile.setDestFile("/var/tmp/a.txt");
        try {
            defaultClientProvider.validateConfigFile(configFile, compName, mockFs);
            Assertions.fail((String)"Should have thrown exception:  dest_file must be relative");
        }
        catch (IllegalArgumentException e) {
            String actualMsg = String.format("For component %s with %s artifact, dest_file must be a relative path: %s", compName, "no", configFile.getDestFile());
            Assertions.assertEquals((Object)actualMsg, (Object)e.getLocalizedMessage());
        }
        configFile.setDestFile("../a.txt");
        try {
            defaultClientProvider.validateConfigFile(configFile, compName, mockFs);
        }
        catch (IllegalArgumentException e) {
            Assertions.fail((String)(NO_EXCEPTION_PREFIX + e.getLocalizedMessage()));
        }
    }
}

