/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.provider;

import java.io.File;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.service.MockRunningServiceContext;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.ServiceTestUtils;
import org.apache.hadoop.yarn.service.TestServiceManager;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.component.Component;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.containerlaunch.AbstractLauncher;
import org.apache.hadoop.yarn.service.containerlaunch.ContainerLaunchService;
import org.apache.hadoop.yarn.service.provider.docker.DockerProviderService;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;

public class TestAbstractProviderService {
    private ServiceContext serviceContext;
    private Service testService;
    private AbstractLauncher launcher;
    @RegisterExtension
    private ServiceTestUtils.ServiceFSWatcher rule = new ServiceTestUtils.ServiceFSWatcher();

    @BeforeEach
    public void setup() throws Exception {
        this.testService = TestServiceManager.createBaseDef("testService");
        this.serviceContext = new MockRunningServiceContext(this.rule, this.testService);
        this.launcher = new AbstractLauncher(this.serviceContext);
        this.rule.getFs().setAppDir(new Path("target/testAbstractProviderService"));
    }

    @AfterEach
    public void teardown() throws Exception {
        FileUtils.deleteQuietly((File)new File(this.rule.getFs().getAppDir().toUri().getPath()));
    }

    @Test
    public void testBuildContainerLaunchCommand() throws Exception {
        DockerProviderService providerService = new DockerProviderService();
        Component component = (Component)this.serviceContext.scheduler.getAllComponents().entrySet().iterator().next().getValue();
        ContainerLaunchService.ComponentLaunchContext clc = TestAbstractProviderService.createEntryPointCLCFor(this.testService, component, "sleep,9000");
        ComponentInstance instance = (ComponentInstance)component.getAllComponentInstances().iterator().next();
        Container container = (Container)Mockito.mock(Container.class);
        providerService.buildContainerLaunchCommand(this.launcher, this.testService, instance, this.rule.getFs(), this.serviceContext.scheduler.getConfig(), container, clc, null);
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new String[]{clc.getLaunchCommand()}), (Object)this.launcher.getCommands(), (String)"commands");
    }

    @Test
    public void testBuildContainerLaunchCommandWithSpace() throws Exception {
        DockerProviderService providerService = new DockerProviderService();
        Component component = (Component)this.serviceContext.scheduler.getAllComponents().entrySet().iterator().next().getValue();
        ContainerLaunchService.ComponentLaunchContext clc = TestAbstractProviderService.createEntryPointCLCFor(this.testService, component, "ls -l \" space\"");
        ComponentInstance instance = (ComponentInstance)component.getAllComponentInstances().iterator().next();
        Container container = (Container)Mockito.mock(Container.class);
        providerService.buildContainerLaunchCommand(this.launcher, this.testService, instance, this.rule.getFs(), this.serviceContext.scheduler.getConfig(), container, clc, null);
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"ls,-l, space"}), (Object)this.launcher.getCommands(), (String)"commands don't match.");
    }

    @Test
    public void testBuildContainerLaunchContext() throws Exception {
        DockerProviderService providerService = new DockerProviderService();
        Component component = (Component)this.serviceContext.scheduler.getAllComponents().entrySet().iterator().next().getValue();
        ContainerLaunchService.ComponentLaunchContext clc = TestAbstractProviderService.createEntryPointCLCFor(this.testService, component, "sleep,9000");
        ComponentInstance instance = (ComponentInstance)component.getAllComponentInstances().iterator().next();
        Container container = (Container)Mockito.mock(Container.class);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), (int)1), (long)1L);
        Mockito.when((Object)container.getId()).thenReturn((Object)containerId);
        providerService.buildContainerLaunchContext(this.launcher, this.testService, instance, this.rule.getFs(), this.serviceContext.scheduler.getConfig(), container, clc);
        Assertions.assertEquals((Object)clc.getArtifact().getId(), (Object)this.launcher.getDockerImage(), (String)"artifact");
    }

    private static ContainerLaunchService.ComponentLaunchContext createEntryPointCLCFor(Service service, Component component, String launchCmd) {
        Artifact artifact = new Artifact();
        artifact.setType(Artifact.TypeEnum.DOCKER);
        artifact.setId("example");
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("YARN_CONTAINER_RUNTIME_DOCKER_DELAYED_REMOVAL", "true");
        env.put("YARN_CONTAINER_RUNTIME_DOCKER_RUN_OVERRIDE_DISABLE", "true");
        component.getComponentSpec().getConfiguration().setEnv(env);
        return new ContainerLaunchService.ComponentLaunchContext(component.getName(), service.getVersion()).setArtifact(artifact).setConfiguration(component.getComponentSpec().getConfiguration()).setLaunchCommand(launchCmd);
    }
}

