/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.monitor;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.apache.curator.test.TestingCluster;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.service.MockServiceAM;
import org.apache.hadoop.yarn.service.ServiceTestUtils;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestServiceMonitor
extends ServiceTestUtils {
    private File basedir;
    YarnConfiguration conf = new YarnConfiguration();
    TestingCluster zkCluster;

    @BeforeEach
    public void setup() throws Exception {
        this.basedir = new File("target", "apps");
        if (this.basedir.exists()) {
            FileUtils.deleteDirectory((File)this.basedir);
        } else {
            this.basedir.mkdirs();
        }
        this.conf.setLong("yarn.service.readiness-check-interval.seconds", 2L);
        this.zkCluster = new TestingCluster(1);
        this.zkCluster.start();
        this.conf.set("hadoop.registry.zk.quorum", this.zkCluster.getConnectString());
        System.out.println("ZK cluster: " + this.zkCluster.getConnectString());
    }

    @AfterEach
    public void tearDown() throws IOException {
        if (this.basedir != null) {
            FileUtils.deleteDirectory((File)this.basedir);
        }
        if (this.zkCluster != null) {
            this.zkCluster.stop();
        }
    }

    @Test
    public void testComponentDependency() throws Exception {
        ApplicationId applicationId = ApplicationId.newInstance((long)123456L, (int)1);
        Service exampleApp = new Service();
        exampleApp.setVersion("v1");
        exampleApp.setId(applicationId.toString());
        exampleApp.setName("testComponentDependency");
        exampleApp.addComponent(TestServiceMonitor.createComponent("compa", 1L, "sleep 1000"));
        Component compb = TestServiceMonitor.createComponent("compb", 1L, "sleep 1000", Component.RestartPolicyEnum.ON_FAILURE, Collections.singletonList("compa"));
        Component compc = TestServiceMonitor.createComponent("compc", 1L, "sleep 1000", Component.RestartPolicyEnum.NEVER, Collections.singletonList("compb"));
        exampleApp.addComponent(compb);
        exampleApp.addComponent(compc);
        MockServiceAM am = new MockServiceAM(exampleApp);
        am.init((Configuration)this.conf);
        am.start();
        Assertions.assertTrue((boolean)am.getComponent("compa").areDependenciesReady());
        Assertions.assertFalse((boolean)am.getComponent("compb").areDependenciesReady());
        am.feedContainerToComp(exampleApp, 1, "compa");
        am.waitForDependenciesSatisfied("compb");
        am.feedContainerToComp(exampleApp, 2, "compb");
        am.waitForDependenciesSatisfied("compc");
        am.feedContainerToComp(exampleApp, 2, "compb");
        am.flexComponent("compa", 2L);
        am.waitForNumDesiredContainers("compa", 2);
        Assertions.assertFalse((boolean)am.getComponent("compb").areDependenciesReady());
        am.stop();
    }
}

