/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.containerlaunch;

import java.io.IOException;
import org.apache.hadoop.fi.FiConfig;
import org.apache.hadoop.test.MockitoUtil;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.api.records.Configuration;
import org.apache.hadoop.yarn.service.component.AlwaysRestartPolicy;
import org.apache.hadoop.yarn.service.component.Component;
import org.apache.hadoop.yarn.service.component.NeverRestartPolicy;
import org.apache.hadoop.yarn.service.component.OnFailureRestartPolicy;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;
import org.apache.hadoop.yarn.service.containerlaunch.AbstractLauncher;
import org.apache.hadoop.yarn.service.containerlaunch.ContainerLaunchService;
import org.apache.hadoop.yarn.service.provider.defaultImpl.DefaultProviderService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestAbstractLauncher {
    private AbstractLauncher launcher;

    @BeforeEach
    public void setup() {
        this.launcher = new AbstractLauncher((ServiceContext)Mockito.mock(ServiceContext.class));
    }

    @Test
    public void testDockerContainerMounts() throws IOException {
        this.launcher.yarnDockerMode = true;
        this.launcher.envVars.put("YARN_CONTAINER_RUNTIME_DOCKER_MOUNTS", "s1:t1:ro");
        this.launcher.mountPaths.put("s2", "t2");
        this.launcher.completeContainerLaunch();
        String dockerContainerMounts = (String)this.launcher.containerLaunchContext.getEnvironment().get("YARN_CONTAINER_RUNTIME_DOCKER_MOUNTS");
        Assertions.assertEquals((Object)"s1:t1:ro,s2:t2:ro", (Object)dockerContainerMounts);
    }

    @Test
    public void testContainerRetries() throws Exception {
        DefaultProviderService providerService = new DefaultProviderService();
        AbstractLauncher mockLauncher = (AbstractLauncher)Mockito.mock(AbstractLauncher.class);
        ContainerLaunchService.ComponentLaunchContext componentLaunchContext = (ContainerLaunchService.ComponentLaunchContext)Mockito.mock(ContainerLaunchService.ComponentLaunchContext.class);
        ComponentInstance componentInstance = (ComponentInstance)Mockito.mock(ComponentInstance.class);
        Component component = (Component)Mockito.mock(Component.class);
        Mockito.when((Object)componentInstance.getComponent()).thenReturn((Object)component);
        Mockito.when((Object)component.getRestartPolicyHandler()).thenReturn((Object)NeverRestartPolicy.getInstance());
        providerService.buildContainerRetry(mockLauncher, FiConfig.getConfig(), componentLaunchContext, componentInstance);
        MockitoUtil.verifyZeroInteractions((Object[])new Object[]{mockLauncher});
        Mockito.when((Object)component.getRestartPolicyHandler()).thenReturn((Object)OnFailureRestartPolicy.getInstance());
        Mockito.when((Object)componentLaunchContext.getConfiguration()).thenReturn((Object)new Configuration());
        providerService.buildContainerRetry(mockLauncher, FiConfig.getConfig(), componentLaunchContext, componentInstance);
        ((AbstractLauncher)Mockito.verify((Object)mockLauncher)).setRetryContext(10, 30000, 600000L);
        Mockito.reset((Object[])new AbstractLauncher[]{mockLauncher});
        Mockito.when((Object)component.getRestartPolicyHandler()).thenReturn((Object)AlwaysRestartPolicy.getInstance());
        providerService.buildContainerRetry(mockLauncher, FiConfig.getConfig(), componentLaunchContext, componentInstance);
        ((AbstractLauncher)Mockito.verify((Object)mockLauncher)).setRetryContext(10, 30000, 600000L);
    }
}

