/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.conf;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestValidateServiceNames {
    void assertValidName(String name) {
        ServiceApiUtil.validateNameFormat((String)name, (Configuration)new Configuration());
    }

    void assertInvalidName(String name) {
        try {
            ServiceApiUtil.validateNameFormat((String)name, (Configuration)new Configuration());
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    void assertInvalid(List<String> names) {
        for (String name : names) {
            this.assertInvalidName(name);
        }
    }

    void assertValid(List<String> names) {
        for (String name : names) {
            this.assertValidName(name);
        }
    }

    @Test
    public void testEmptyName() throws Throwable {
        this.assertInvalidName("");
    }

    @Test
    public void testSpaceName() throws Throwable {
        this.assertInvalidName(" ");
    }

    @Test
    public void testLeadingHyphen() throws Throwable {
        this.assertInvalidName("-hyphen");
    }

    @Test
    public void testTitleLetters() throws Throwable {
        this.assertInvalidName("Title");
    }

    @Test
    public void testCapitalLetters() throws Throwable {
        this.assertInvalidName("UPPER-CASE-CLUSTER");
    }

    @Test
    public void testInnerBraced() throws Throwable {
        this.assertInvalidName("a[a");
    }

    @Test
    public void testLeadingBrace() throws Throwable {
        this.assertInvalidName("[");
    }

    @Test
    public void testNonalphaLeadingChars() throws Throwable {
        this.assertInvalid(Arrays.asList("[a", "#", "@", "=", "*", "."));
    }

    @Test
    public void testNonalphaInnerChars() throws Throwable {
        this.assertInvalid(Arrays.asList("a[a", "b#", "c@", "d=", "e*", "f.", "g ", "h i"));
    }

    @Test
    public void testClusterValid() throws Throwable {
        this.assertValidName("cluster");
    }

    @Test
    public void testValidNames() throws Throwable {
        this.assertValid(Arrays.asList("cluster", "cluster1", "very-very-very-long-cluster-name", "c1234567890"));
    }
}

